;
; NoteCase Windows setup script file (Inno Setup)
;

[Setup]
AppName=NoteCase
AppVerName=NoteCase v1.0.3
AppPublisherURL=http://notecase.sourceforge.net
AppSupportURL=http://notecase.sourceforge.net
AppUpdatesURL=http://notecase.sourceforge.net
AppCopyright=Copyright 2004-2005 by NoteCase developer team
DefaultDirName={pf}\NoteCase
DefaultGroupName=NoteCase
UninstallDisplayIcon={app}\notecase.exe
;it is possible to skip creating program group
AllowNoIcons=yes

[Tasks]
;Name: menuitems; Description: "Create a start menu items"; GroupDescription: "Additional items:";
Name: desktopicon; Description: "Create a &desktop icon"; GroupDescription: "Additional items:";
Name: quicklaunchicon; Description: "Create a &Quick Launch icon"; GroupDescription: "Additional items:"; Flags: unchecked
Name: startmenuicon; Description: "Create a &start menu icon"; GroupDescription: "Additional items:"; Flags: unchecked
Name: gtkinstall; Description: "Install GTK";

[Files]
Source: "notecase.exe"; DestDir: "{app}"; Flags: promptifolder
Source: "readme.txt"; DestDir: "{app}"; Flags: isreadme
Source: "help.ncd"; DestDir: "{app}"
Source: "notecase.url"; DestDir: "{app}"
Source: "gtk-win32-2.6.10-rc1.exe"; Tasks: gtkinstall; DestDir: "{tmp}"; Flags: deleteafterinstall;
Source: "locale\hr\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\hr\LC_MESSAGES"
Source: "locale\zh\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\zh\LC_MESSAGES"
Source: "locale\it\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\it\LC_MESSAGES"
Source: "locale\de\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\de\LC_MESSAGES"
Source: "locale\es\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\es\LC_MESSAGES"
Source: "locale\fr\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\fr\LC_MESSAGES"
Source: "locale\fr_CA\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\fr_CA\LC_MESSAGES"
Source: "locale\nl\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\nl\LC_MESSAGES"
Source: "locale\hu\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\hu\LC_MESSAGES"
Source: "locale\nn\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\nn\LC_MESSAGES"
Source: "locale\tr\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\tr\LC_MESSAGES"
Source: "locale\sk\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\sk\LC_MESSAGES"
Source: "locale\pt\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\pt\LC_MESSAGES"
Source: "locale\pl\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\pl\LC_MESSAGES"
Source: "locale\ro\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\ro\LC_MESSAGES"
Source: "locale\da\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\da\LC_MESSAGES"
Source: "locale\ru\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\ru\LC_MESSAGES"
Source: "locale\el\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\el\LC_MESSAGES"
Source: "locale\pt_BR\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\pt_BR\LC_MESSAGES"
Source: "locale\ko\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\ko\LC_MESSAGES"
Source: "locale\fi\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\fi\LC_MESSAGES"
Source: "locale\sr\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\sr\LC_MESSAGES"
Source: "locale\cs\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\cs\LC_MESSAGES"
Source: "locale\id\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\id\LC_MESSAGES"
Source: "locale\no\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\no\LC_MESSAGES"
Source: "locale\ms\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\ms\LC_MESSAGES"
Source: "locale\ta\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\ta\LC_MESSAGES"
Source: "locale\sl\LC_MESSAGES\notecase.mo"; DestDir: "{app}\locale\sl\LC_MESSAGES"
Source: "msvcrt.dll"; DestDir: "{sys}"; Flags: onlyifdoesntexist uninsneveruninstall

[Run]
; execute gtk installer if required
Filename: "{tmp}\gtk-win32-2.6.10-rc1.exe";  Tasks: gtkinstall;  Flags: hidewizard skipifdoesntexist; AfterInstall: UpdateAppPath;

[Icons]
Name: "{group}\NoteCase"; Filename: "{app}\notecase.exe"; WorkingDir: "{app}";
Name: "{group}\Visit the Web Site"; Filename: "{app}\notecase.url";
Name: "{group}\Read me"; Filename: "{app}\readme.txt";
Name: "{group}\Uninstall NoteCase"; Filename: "{uninstallexe}";
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\NoteCase"; Filename: "{app}\notecase.exe"; Tasks: quicklaunchicon;  WorkingDir: "{app}"
Name: "{userdesktop}\NoteCase"; Filename: "{app}\notecase.exe"; Tasks: desktopicon; WorkingDir: "{app}"
Name: "{userstartmenu}\NoteCase"; Filename: "{app}\notecase.exe"; Tasks: startmenuicon; WorkingDir: "{app}"

[Registry]
; register .ncd format with notecase
Root: HKCR; Subkey: ".ncd"; ValueType: string; ValueName: ""; ValueData: "NoteCase.PlainFormat"; Flags: uninsdeletevalue
Root: HKCR; Subkey: "NoteCase.PlainFormat"; ValueType: string; ValueName: ""; ValueData: "NoteCase unencrypted file format"; Flags: uninsdeletekey
Root: HKCR; Subkey: "NoteCase.PlainFormat\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\notecase.exe,0"
Root: HKCR; Subkey: "NoteCase.PlainFormat\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\notecase.exe"" ""%1"""
; register .nce format with notecase
Root: HKCR; Subkey: ".nce"; ValueType: string; ValueName: ""; ValueData: "NoteCase.EncryptedFormat"; Flags: uninsdeletevalue
Root: HKCR; Subkey: "NoteCase.EncryptedFormat"; ValueType: string; ValueName: ""; ValueData: "NoteCase encrypted file format"; Flags: uninsdeletekey
Root: HKCR; Subkey: "NoteCase.EncryptedFormat\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\notecase.exe,0"
Root: HKCR; Subkey: "NoteCase.EncryptedFormat\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\notecase.exe"" ""%1"""
; This adds the GTK+ libraries to notecase.exe's path
Root: HKLM; Subkey: "Software\Microsoft\Windows\CurrentVersion\App Paths\notecase.exe"; Flags: uninsdeletekeyifempty
Root: HKLM; Subkey: "Software\Microsoft\Windows\CurrentVersion\App Paths\notecase.exe"; ValueType: string; ValueData: "{app}\notecase.exe"; Flags: uninsdeletevalue
; this one is a placeholder, its value is filled in UpdateAppPath();
Root: HKLM; Subkey: "Software\Microsoft\Windows\CurrentVersion\App Paths\notecase.exe"; ValueType: string; ValueName: "Path"; ValueData: ""; Flags: uninsdeletevalue

[Code]

var
  Exists: Boolean;
  GtkPath: String;

function GetGtkInstalled(): Boolean;
begin
  Exists := RegQueryStringValue (HKLM, 'Software\GTK\2.0', 'Path', GtkPath);
  if not Exists then begin
    Exists := RegQueryStringValue (HKCU, 'Software\GTK\2.0', 'Path', GtkPath);
  end;
   Result := Exists
end;

procedure UpdateAppPath();
var
 AppPath: String;
 RegValue: String;
begin
    AppPath := ExpandConstant('{app}');

    GetGtkInstalled (); //first read Gtk Path

    //create and write registry key
    RegValue := AppPath;
    RegValue := RegValue + ';';
    RegValue := RegValue + GtkPath;
    RegValue := RegValue + '\bin';
    
    //MsgBox(RegValue, mbInformation, MB_OK);
    RegWriteStringValue (HKLM, 'Software\Microsoft\Windows\CurrentVersion\App Paths\notecase.exe', 'Path', RegValue);
end;
