////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: Dialog to view/edit document node properties
////////////////////////////////////////////////////////////////////////////

#include "NodePropertiesDlg.h"
#include "support.h"
#include "gui/FileDialog.h"

const char *InternalIcon_Index2Name(int nIndex);
const char **InternalIcon_GetFromIdx(int);
int InternalIcon_Name2Index(const char *);

static void on_icon_none_clicked(GtkMenuItem *menuitem, gpointer user_data);
static void on_icon_internal_clicked(GtkMenuItem *menuitem, gpointer user_data);
static void on_icon_custom_clicked(GtkMenuItem *menuitem, gpointer user_data);
static void on_xpm_select_clicked(GtkMenuItem *menuitem, gpointer user_data);
static void on_internal_combo_selected (GtkComboBox *widget, gpointer user_data);

NodePropertiesDlg::NodePropertiesDlg()
{
}

NodePropertiesDlg::~NodePropertiesDlg()
{
	Destroy();
}

void NodePropertiesDlg::Create()
{
	m_pDialog = create_node_properties_dialog ();

	//set node title
	if(m_strTitle.c_str())
	{
		GtkWidget *entry = lookup_widget(m_pDialog, "entry_node_title");
		gtk_entry_set_text(GTK_ENTRY(entry), m_strTitle.c_str());
	}

	//fill internal icons combo
	GtkWidget *cbo2	= lookup_widget(m_pDialog, "comboboxentry2");
	for (int i=ICON_INTERNAL_FIRST; i<=ICON_INTERNAL_LAST; i++)
		gtk_combo_box_append_text(GTK_COMBO_BOX(cbo2), InternalIcon_Index2Name(i));

	//select first entry in combo (must not be empty selection)
	gtk_combo_box_set_active(GTK_COMBO_BOX(cbo2), 0);
}

const char *NodePropertiesDlg::GetNodeTitle()
{
	GtkWidget *entry = lookup_widget(m_pDialog, "entry_node_title");
	return gtk_entry_get_text(GTK_ENTRY(entry));
}

int NodePropertiesDlg::GetIconType()
{
	GtkWidget *radio_ico_none 	= lookup_widget(m_pDialog, "radio_ico_none");
	GtkWidget *radio_ico_internal	= lookup_widget(m_pDialog, "radio_ico_internal");

	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_ico_none)))
		return ICON_NONE;
	else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_ico_internal))) 
		return ICON_INTERNAL;
	return ICON_CUSTOM;
}

const char *NodePropertiesDlg::GetIconValue()
{
	GtkWidget *cbo2		= lookup_widget(m_pDialog, "comboboxentry2");
	GtkWidget *entry4	= lookup_widget(m_pDialog, "entry4");

	switch (GetIconType())
	{
		case ICON_INTERNAL:	
		{
		#if GTK_CHECK_VERSION(2,6,0) //new API //TOFIX set proper version//
			return gtk_combo_box_get_active_text(GTK_COMBO_BOX(cbo2));
		#else
			int nPos = gtk_combo_box_get_active(GTK_COMBO_BOX(cbo2));
			if(nPos >= 0)
			{
				GtkTreeModel *model = gtk_combo_box_get_model(GTK_COMBO_BOX(cbo2));
				GtkTreeIter iter;
				char szPath[10];
				sprintf(szPath, "%d", nPos);
				GtkTreePath *path1 = gtk_tree_path_new_from_string (szPath);
				if(gtk_tree_model_get_iter(model, &iter, path1))
				{
					gchar *value = NULL;
					gtk_tree_model_get (model, &iter, 0, &value, -1);
					return value;
					//g_free(value);
				}
			}
			return NULL;
		#endif
		}
		case ICON_CUSTOM:	return gtk_entry_get_text(GTK_ENTRY(entry4));
		default: 		return "";
	}
}

void NodePropertiesDlg::SetIconType(int nType)
{
	GtkWidget *radio_ico_none 	= lookup_widget(m_pDialog, "radio_ico_none");
	GtkWidget *radio_ico_internal	= lookup_widget(m_pDialog, "radio_ico_internal");
	GtkWidget *radio_ico_custom	= lookup_widget(m_pDialog, "radio_ico_custom");
	GtkWidget *cbo2			= lookup_widget(m_pDialog, "comboboxentry2");

	if(ICON_NONE == nType)
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_ico_none), TRUE);
		on_icon_none_clicked(NULL, this);
	}
	else if(ICON_CUSTOM == nType) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_ico_custom), TRUE);
	else
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_ico_internal), TRUE);
		gtk_combo_box_set_active(GTK_COMBO_BOX(cbo2), nType);
	}

	UpdatePreview();
}

void NodePropertiesDlg::SetIconValue(const char *szValue)
{
	GtkWidget *entry4	= lookup_widget(m_pDialog, "entry4");
	gtk_entry_set_text(GTK_ENTRY(entry4), szValue);

	UpdatePreview();
}

GtkWidget* NodePropertiesDlg::create_node_properties_dialog ()
{
	GtkWidget *node_properties_dialog;
	GtkWidget *dialog_vbox5;
	GtkWidget *table4;
	GtkWidget *label21;
	GtkWidget *entry_node_title;
	GtkWidget *label22;
	GtkWidget *vbox10;
	GtkWidget *hbox2;
	GtkWidget *table6;
	GtkWidget *radio_ico_none;
	GSList    *radio_ico_none_group = NULL;
	GtkWidget *radio_ico_internal;
	GtkWidget *radio_ico_custom;
	GtkWidget *entry4;
	GtkWidget *label23;
	GtkWidget *image1;
	GtkWidget *button_xpm_select;
	GtkWidget *comboboxentry2;
	GtkWidget *dialog_action_area5;
	GtkWidget *cancelbutton5;
	GtkWidget *okbutton5;
	
	node_properties_dialog = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (node_properties_dialog), _("Node Properties"));
	gtk_window_set_type_hint (GTK_WINDOW (node_properties_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);
	
	dialog_vbox5 = GTK_DIALOG (node_properties_dialog)->vbox;
	gtk_widget_show (dialog_vbox5);
	
	table4 = gtk_table_new (2, 2, FALSE);
	gtk_widget_show (table4);
	gtk_box_pack_start (GTK_BOX (dialog_vbox5), table4, TRUE, TRUE, 0);
	
	label21 = gtk_label_new (_("Title:"));
	gtk_widget_show (label21);
	gtk_table_attach (GTK_TABLE (table4), label21, 0, 1, 0, 1,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label21), 0, 0.5);
	
	entry_node_title = gtk_entry_new ();
	gtk_widget_show (entry_node_title);
	gtk_table_attach (GTK_TABLE (table4), entry_node_title, 1, 2, 0, 1,
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		(GtkAttachOptions) (0), 0, 0);
	
	label22 = gtk_label_new (_("Icon:"));
	gtk_widget_show (label22);
	gtk_table_attach (GTK_TABLE (table4), label22, 0, 1, 1, 2,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label22), 0, 0);
	
	vbox10 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox10);
	gtk_table_attach (GTK_TABLE (table4), vbox10, 1, 2, 1, 2,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (GTK_FILL), 0, 0);
	
	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox10), hbox2, FALSE, FALSE, 0);
	
	table6 = gtk_table_new (4, 3, FALSE);
	gtk_widget_show (table6);
	gtk_box_pack_start (GTK_BOX (hbox2), table6, TRUE, TRUE, 0);
	
	radio_ico_none = gtk_radio_button_new_with_mnemonic (NULL, _("None"));
	gtk_widget_show (radio_ico_none);
	gtk_table_attach (GTK_TABLE (table6), radio_ico_none, 0, 1, 0, 1,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (0), 0, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (radio_ico_none), radio_ico_none_group);
	radio_ico_none_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio_ico_none));
	
	radio_ico_internal = gtk_radio_button_new_with_mnemonic (NULL, _("Internal"));
	gtk_widget_show (radio_ico_internal);
	gtk_table_attach (GTK_TABLE (table6), radio_ico_internal, 0, 1, 1, 2,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (0), 0, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (radio_ico_internal), radio_ico_none_group);
	radio_ico_none_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio_ico_internal));
	
	radio_ico_custom = gtk_radio_button_new_with_mnemonic (NULL, _("Custom"));
	gtk_widget_show (radio_ico_custom);
	gtk_table_attach (GTK_TABLE (table6), radio_ico_custom, 0, 1, 2, 3,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (0), 0, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (radio_ico_custom), radio_ico_none_group);
	radio_ico_none_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio_ico_custom));
	
	entry4 = gtk_entry_new ();
	gtk_entry_set_editable (GTK_ENTRY(entry4), FALSE);
	gtk_widget_show (entry4);
	gtk_table_attach (GTK_TABLE (table6), entry4, 1, 2, 2, 3,
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		(GtkAttachOptions) (0), 0, 0);
	
	label23 = gtk_label_new (_("Preview:"));
	gtk_widget_show (label23);
	gtk_table_attach (GTK_TABLE (table6), label23, 0, 1, 3, 4,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label23), 0, 0.5);
	
	image1 = gtk_image_new ();
	gtk_widget_show (image1);
	gtk_widget_set_size_request(image1, -1, 20);
	gtk_table_attach (GTK_TABLE (table6), image1, 1, 2, 3, 4,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (GTK_FILL), 0, 0);
	
	button_xpm_select = gtk_button_new_with_mnemonic ("...");
	gtk_widget_show (button_xpm_select);
	gtk_table_attach (GTK_TABLE (table6), button_xpm_select, 2, 3, 2, 3,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (0), 0, 0);
	
	comboboxentry2 = gtk_combo_box_new_text ();
	gtk_widget_show (comboboxentry2);
	gtk_table_attach (GTK_TABLE (table6), comboboxentry2, 1, 2, 1, 2,
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		(GtkAttachOptions) (GTK_FILL), 0, 0);
	
	dialog_action_area5 = GTK_DIALOG (node_properties_dialog)->action_area;
	gtk_widget_show (dialog_action_area5);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area5), GTK_BUTTONBOX_END);
	
	cancelbutton5 = gtk_button_new_from_stock ("gtk-cancel");
	gtk_widget_show (cancelbutton5);
	gtk_dialog_add_action_widget (GTK_DIALOG (node_properties_dialog), cancelbutton5, GTK_RESPONSE_CANCEL);
	GTK_WIDGET_SET_FLAGS (cancelbutton5, GTK_CAN_DEFAULT);
	
	okbutton5 = gtk_button_new_from_stock ("gtk-ok");
	gtk_widget_show (okbutton5);
	gtk_dialog_add_action_widget (GTK_DIALOG (node_properties_dialog), okbutton5, GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS (okbutton5, GTK_CAN_DEFAULT);

	g_signal_connect (radio_ico_none,		"clicked",	G_CALLBACK (on_icon_none_clicked), this);
	g_signal_connect (radio_ico_internal,	"clicked",	G_CALLBACK (on_icon_internal_clicked), this);
	g_signal_connect (radio_ico_custom,		"clicked",	G_CALLBACK (on_icon_custom_clicked), this);
	g_signal_connect (button_xpm_select,	"clicked",	G_CALLBACK (on_xpm_select_clicked), this);
	g_signal_connect (comboboxentry2,		"changed",  G_CALLBACK (on_internal_combo_selected), this);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (node_properties_dialog, node_properties_dialog, "node_properties_dialog");
	GLADE_HOOKUP_OBJECT_NO_REF (node_properties_dialog, dialog_vbox5, "dialog_vbox5");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, table4, "table4");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, label21, "label21");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, entry_node_title, "entry_node_title");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, label22, "label22");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, vbox10, "vbox10");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, hbox2, "hbox2");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, table6, "table6");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, radio_ico_none, "radio_ico_none");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, radio_ico_internal, "radio_ico_internal");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, radio_ico_custom, "radio_ico_custom");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, entry4, "entry4");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, label23, "label23");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, image1, "image1");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, button_xpm_select, "button_xpm_select");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, comboboxentry2, "comboboxentry2");
	GLADE_HOOKUP_OBJECT_NO_REF (node_properties_dialog, dialog_action_area5, "dialog_action_area5");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, cancelbutton5, "cancelbutton5");
	GLADE_HOOKUP_OBJECT (node_properties_dialog, okbutton5, "okbutton5");
	
	return node_properties_dialog;
}

void on_icon_none_clicked(GtkMenuItem *menuitem, gpointer user_data)
{
	NodePropertiesDlg *pDlg = (NodePropertiesDlg *)user_data;

	GtkWidget *radio_ico_none = lookup_widget(pDlg->m_pDialog, "radio_ico_none");
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_ico_none)))
	{
		GtkWidget *cbo2				= lookup_widget(pDlg->m_pDialog, "comboboxentry2");
		GtkWidget *entry4			= lookup_widget(pDlg->m_pDialog, "entry4");
		GtkWidget *button			= lookup_widget(pDlg->m_pDialog, "button_xpm_select");

		gtk_widget_set_sensitive(cbo2, FALSE);
		gtk_widget_set_sensitive(entry4, FALSE);
		gtk_widget_set_sensitive(button, FALSE);

		pDlg->UpdatePreview();
	}
}

void on_icon_internal_clicked(GtkMenuItem *menuitem, gpointer user_data)
{
	NodePropertiesDlg *pDlg = (NodePropertiesDlg *)user_data;

	GtkWidget *radio_ico_internal = lookup_widget(pDlg->m_pDialog, "radio_ico_internal");
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_ico_internal)))
	{
		GtkWidget *cbo2		= lookup_widget(pDlg->m_pDialog, "comboboxentry2");
		GtkWidget *entry4	= lookup_widget(pDlg->m_pDialog, "entry4");
		GtkWidget *button	= lookup_widget(pDlg->m_pDialog, "button_xpm_select");
		
		gtk_widget_set_sensitive(cbo2, TRUE);
		gtk_widget_set_sensitive(entry4, FALSE);
		gtk_widget_set_sensitive(button, FALSE);

		pDlg->UpdatePreview();
	}
}

void on_icon_custom_clicked(GtkMenuItem *menuitem, gpointer user_data)
{
	NodePropertiesDlg *pDlg = (NodePropertiesDlg *)user_data;
	
	GtkWidget *radio_ico_custom = lookup_widget(pDlg->m_pDialog, "radio_ico_custom");
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_ico_custom)))
	{
		GtkWidget *cbo2		= lookup_widget(pDlg->m_pDialog, "comboboxentry2");
		GtkWidget *entry4	= lookup_widget(pDlg->m_pDialog, "entry4");
		GtkWidget *button	= lookup_widget(pDlg->m_pDialog, "button_xpm_select");

		gtk_widget_set_sensitive(cbo2, FALSE);
		gtk_widget_set_sensitive(entry4, TRUE);
		gtk_widget_set_sensitive(button, TRUE);

		pDlg->UpdatePreview();
	}
}

void on_xpm_select_clicked(GtkMenuItem *menuitem, gpointer user_data)
{
	FileDialog dlg;
	dlg.AddFilter(_("XPM icon file (*.xpm)"), "*.xpm");
	if(dlg.DoModal())
	{
		NodePropertiesDlg *pDlg = (NodePropertiesDlg *)user_data;
		GtkWidget *entry4	= lookup_widget(pDlg->m_pDialog, "entry4");
		gtk_entry_set_text(GTK_ENTRY(entry4), dlg.GetFilename());

		pDlg->UpdatePreview();
	}
}

void NodePropertiesDlg::UpdatePreview()
{
	GtkWidget *image1 = lookup_widget(m_pDialog, "image1");

	int nType = GetIconType();
	if(ICON_INTERNAL == nType)
	{
		int nIcoIdx = InternalIcon_Name2Index(GetIconValue());
		if(nIcoIdx >= 0)
		{
			const char **szIconData = InternalIcon_GetFromIdx(nIcoIdx);
			GdkPixbuf *pixbuf = gdk_pixbuf_new_from_xpm_data (szIconData);
			GdkPixbuf *destpix = gdk_pixbuf_scale_simple(pixbuf, 16, 16, GDK_INTERP_NEAREST);
			g_object_unref (G_OBJECT (pixbuf));
			gtk_image_set_from_pixbuf (GTK_IMAGE(image1), destpix);
			g_object_unref (G_OBJECT (destpix));
		}
		else
		{
			gtk_image_set_from_file(GTK_IMAGE(image1), NULL);	//clear image
		}
	}
	else if(ICON_CUSTOM == nType)
	{
		GdkPixbuf *pixbuf = gdk_pixbuf_new_from_file_at_size(GetIconValue(), 16, 16, NULL);
		if(pixbuf){
			gtk_image_set_from_pixbuf (GTK_IMAGE(image1), pixbuf);
			g_object_unref (G_OBJECT (pixbuf));
		}
		else
		{
			gtk_image_set_from_file(GTK_IMAGE(image1), NULL);	//clear image
		}
	}
	else
		gtk_image_set_from_file(GTK_IMAGE(image1), NULL);	//clear image
}

void on_internal_combo_selected (GtkComboBox *widget, gpointer user_data)
{
	NodePropertiesDlg *pDlg = (NodePropertiesDlg *)user_data;
	pDlg->UpdatePreview();
}

