////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: Window class for Password input 
////////////////////////////////////////////////////////////////////////////

#include "PasswordDialog.h"
#include "support.h"

extern GtkWidget *window1; 
static GtkWidget* create_password_dialog (GtkWidget* parent1=NULL);

PasswordDialog::PasswordDialog()
{
	Create();
}

PasswordDialog::~PasswordDialog()
{
}

void PasswordDialog::Create()
{
	m_pDialog = create_password_dialog (window1);
}

GtkWidget* create_password_dialog (GtkWidget* parent1)
{
	GtkWidget *dialog1;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *label1;
	GtkWidget *entry1;
	GtkWidget *dialog_action_area1;
	GtkWidget *cancelbutton1;
	GtkWidget *okbutton1;
	
	dialog1 = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (dialog1), _("Password"));
	gtk_window_set_modal (GTK_WINDOW (dialog1), TRUE);
	gtk_window_set_skip_pager_hint (GTK_WINDOW (dialog1), TRUE);
#ifndef _WIN32  //TOFIX API is buggy on Win32 (kills modal dialog state)
	gtk_window_set_skip_taskbar_hint (GTK_WINDOW (dialog1), TRUE);
#endif
	gtk_window_set_type_hint (GTK_WINDOW (dialog1), GDK_WINDOW_TYPE_HINT_DIALOG);
	
	if(parent1)
		gtk_window_set_transient_for(GTK_WINDOW (dialog1), GTK_WINDOW(parent1));   //set parent
		
#if GTK_CHECK_VERSION(2,4,0) //new API TOFIX set proper version
  #ifndef _WIN32  //TOFIX API is buggy on Win32 (kills modal dialog state)
	gtk_window_set_keep_above(GTK_WINDOW (dialog1), TRUE);
  #endif
#endif
	gtk_window_set_position(GTK_WINDOW (dialog1), GTK_WIN_POS_CENTER_ON_PARENT);

	dialog_vbox1 = GTK_DIALOG (dialog1)->vbox;
	gtk_widget_show (dialog_vbox1);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

	label1 = gtk_label_new (_("Please enter the password:"));
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);
	gtk_misc_set_padding (GTK_MISC (label1), 0, 10);

	entry1 = gtk_entry_new ();
	gtk_widget_show (entry1);
	gtk_box_pack_start (GTK_BOX (vbox1), entry1, FALSE, FALSE, 0);
	gtk_entry_set_visibility (GTK_ENTRY (entry1), FALSE);
	gtk_entry_set_activates_default (GTK_ENTRY (entry1), TRUE);
	dialog_action_area1 = GTK_DIALOG (dialog1)->action_area;
	gtk_widget_show (dialog_action_area1);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);
	
	cancelbutton1 = gtk_button_new_from_stock ("gtk-cancel");
	gtk_widget_show (cancelbutton1);
	gtk_dialog_add_action_widget (GTK_DIALOG (dialog1), cancelbutton1, GTK_RESPONSE_CANCEL);
	GTK_WIDGET_SET_FLAGS (cancelbutton1, GTK_CAN_DEFAULT);
	
	okbutton1 = gtk_button_new_from_stock ("gtk-ok");
	gtk_widget_show (okbutton1);
	gtk_dialog_add_action_widget (GTK_DIALOG (dialog1), okbutton1, GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);
	
	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (dialog1, dialog1, "dialog1");
	GLADE_HOOKUP_OBJECT_NO_REF (dialog1, dialog_vbox1, "dialog_vbox1");
	GLADE_HOOKUP_OBJECT (dialog1, vbox1, "vbox1");
	GLADE_HOOKUP_OBJECT (dialog1, label1, "label1");
	GLADE_HOOKUP_OBJECT (dialog1, entry1, "entry1");
	GLADE_HOOKUP_OBJECT_NO_REF (dialog1, dialog_action_area1, "dialog_action_area1");
	GLADE_HOOKUP_OBJECT (dialog1, cancelbutton1, "CANCEL");
	GLADE_HOOKUP_OBJECT (dialog1, okbutton1, "OK");
	
	gtk_widget_grab_default (okbutton1);
	return dialog1;
}

void PasswordDialog::SetLabel(const char *szText)
{
	GtkWidget *label1 = lookup_widget(m_pDialog, "label1");
	gtk_label_set_text(GTK_LABEL(label1), szText);
}
