////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: Implements light wrapper around FileChooser GTK API
////////////////////////////////////////////////////////////////////////////

#include "FileDialog.h"
#include <string>

#include <gdk/gdkkeysyms.h>
#include "../support.h"

#if !GTK_CHECK_VERSION(2,4,0) //minimal version for new type of dialog
   #define _OLD_DIALOG
#endif

FileDialog::FileDialog(bool bOpen, const char *szTitle, void *pParent)
{
	m_szFile = NULL;
	m_szDir  = NULL;
	m_bOpenDialog = bOpen;

	const char *szDlgTitle = szTitle;
	if(NULL == szDlgTitle)
		szDlgTitle = (bOpen) ? _("Open file") : _("Save file");

#ifdef _OLD_DIALOG
	m_pDialog = gtk_file_selection_new(szDlgTitle);
	gtk_dialog_set_default_response (GTK_DIALOG (m_pDialog), GTK_RESPONSE_OK);
#else
	if(bOpen)
		m_pDialog = gtk_file_chooser_dialog_new(szDlgTitle, GTK_WINDOW (pParent), 
			GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, 
			GTK_STOCK_OPEN, GTK_RESPONSE_OK, NULL);
	else
		m_pDialog = gtk_file_chooser_dialog_new(szDlgTitle, GTK_WINDOW (pParent), 
			GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, 
			GTK_STOCK_SAVE, GTK_RESPONSE_OK, NULL);
#endif
}

FileDialog::~FileDialog()
{
	Close();

#ifndef _WIN32
	if(m_szFile)
		g_free(m_szFile);
	if(m_szDir)
		g_free(m_szDir);
#endif
}

void FileDialog::AddFilter(const char *szText, const char *szPtrn)
{
	//add filters
#ifdef _OLD_DIALOG
#else
	GtkFileFilter *filter = gtk_file_filter_new();
	gtk_file_filter_set_name(filter, szText);

	//we allow multiple wildcard patterns to be separated with | character
	std::string strMulti(szPtrn);
	std::string strPtrn;
	size_t nPos = strMulti.find('|');
	while(nPos != std::string::npos)
	{
		strPtrn  = strMulti.substr(0, nPos);
		strMulti = strMulti.substr(nPos+1, 10000);
		nPos = strMulti.find('|');

		gtk_file_filter_add_pattern(filter, strPtrn.c_str());
	}
	if(!strMulti.empty())
		gtk_file_filter_add_pattern(filter, strMulti.c_str());


	gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(m_pDialog), filter);
#endif
}

bool FileDialog::DoModal()
{
	return (gtk_dialog_run(GTK_DIALOG(m_pDialog)) == GTK_RESPONSE_OK);
}

void FileDialog::Close()
{
	if(m_pDialog)
		gtk_widget_destroy(m_pDialog);
	m_pDialog = NULL;
}

const char *FileDialog::GetFilename()
{
	//free if already allocated
	if(m_szFile)
		g_free(m_szFile);

#ifdef _OLD_DIALOG
	m_szFile = (char *)gtk_file_selection_get_filename(GTK_FILE_SELECTION (m_pDialog));
#else
	m_szFile = (char *)gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(m_pDialog));
#endif

	return m_szFile;
}

void FileDialog::SetFilename(const char *szName)
{
#ifdef _OLD_DIALOG
	gtk_file_selection_set_filename(GTK_FILE_SELECTION (m_pDialog), szName);
#else
	gtk_file_chooser_set_current_name(GTK_FILE_CHOOSER(m_pDialog), szName);
#endif
}

void FileDialog::SetDirectory(const char *szPath)
{
#ifdef _OLD_DIALOG
#else
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(m_pDialog), szPath);	
#endif
}

void FileDialog::SetTitle(const char *szText)
{
	gtk_window_set_title (GTK_WINDOW (m_pDialog), szText);
}

const char *FileDialog::GetCurrentFilterName()
{
#ifdef _OLD_DIALOG
#else
	GtkFileFilter *filter = gtk_file_chooser_get_filter(GTK_FILE_CHOOSER(m_pDialog));
	if(filter)
		return gtk_file_filter_get_name(filter);
#endif
	return NULL;
}

const char *FileDialog::GetDirectory()
{
#ifdef _OLD_DIALOG
#else	
	if(m_szDir)
		g_free(m_szDir);

	m_szDir = gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER(m_pDialog));
#endif

	return m_szDir;
}

