////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: Implements Blowfish encrypted NoteCase HTML format I/O
////////////////////////////////////////////////////////////////////////////

#include "FormatEncHtml.h"
#include "File64Enc.h"
#include "DocumentIterator.h"
#include "SHA1.h"
#include <stdio.h>	//sprintf

void WriteLevel(DocumentIterator &it, File64 &file, int nParentID);
void DumpDocument(NoteDocument &doc, const char *szFile);

FormatEncHTML::FormatEncHTML()
{
	m_nOrigSize = 0;
}

FormatEncHTML::~FormatEncHTML()
{
}

void FormatEncHTML::SetPassword(const char *szPass)
{
	m_strPass = szPass;
}

int FormatEncHTML::Load(const char *szFile, NoteDocument &doc)
{
	if(m_strPass.size()==0)
		return DOC_LOAD_WRONG_PASSWORD;	//password not set

	File64Enc objFile;	
	char szBuffer[1032];
	int nRead;

	m_objDoc = &doc;  //store pointer

	//clear old document contents
	doc.Clear();

	if(!objFile.Open(szFile, F64_READ|F64_SHARE_READ|F64_OPEN_EXISTING))
		return DOC_LOAD_NOT_FOUND;

	objFile.SetPassword(m_strPass.c_str());

	//
	// read encrypted format header
	//
	
	// 1. format signature text "NOTECASE" (8 bytes)
	char szFormatCode[9];
	objFile.File64::Read(szFormatCode, 8);	// "explicit qualification"
	szFormatCode[8] = '\0';
	if(0 != strcmp(szFormatCode, "NOTECASE"))
		return DOC_LOAD_FORMAT_ERROR;	//
	
	// 2. SHA-1 password hash value (20 bytes)
	char szHashRead[20] = "";
	objFile.File64::Read(szHashRead, 20);
	CSHA1 hash;
	hash.Update((BYTE *)m_strPass.c_str(), m_strPass.size());
	hash.Final();
	if(0 != memcmp(szHashRead, hash.m_digest, 20))
		return DOC_LOAD_WRONG_PASSWORD;	//invalid password
	
	// 3. original (unencrpyted) file size (6 bytes)
	objFile.File64::Read((char *)&m_nOrigSize, sizeof(m_nOrigSize));

			
	//TOFIX error handling
	while((nRead = objFile.Read(szBuffer, 1024)) > 0)
		Parse(szBuffer, nRead);

	//TOFIX use m_nOrigSize
	return DOC_LOAD_OK;
}

bool FormatEncHTML::Save(const char *szFile, NoteDocument &doc)
{
	if(m_strPass.size()==0)
		return false;	//password not set

	File64Enc objFile;	
	if(!objFile.Open(szFile, F64_WRITE|F64_SHARE_READ|F64_OPEN_NEW))
		return false;

	objFile.SetPassword(m_strPass.c_str());

	//
	// write encrypted format header
	//
	
	// 1. format signature text "NOTECASE" (8 bytes)
	objFile.File64::Write("NOTECASE", 8);
	
	// 2. SHA-1 password hash value (20 bytes)
	CSHA1 hash;
	hash.Update((BYTE *)m_strPass.c_str(), m_strPass.size());
	hash.Final();
	objFile.File64::Write((char *)hash.m_digest, 20);
		
	// 3. original (unencrpyted) file size (6 bytes)
	objFile.File64::Write((char *)&m_nOrigSize, sizeof(m_nOrigSize));//TOFIX update at the end
	
	//write header
	objFile.WriteString("<!DOCTYPE NoteCenter-File>\r\n"); //TOFIX

	//calc and write selected node "index"
	char szLastNote[100];
	sprintf(szLastNote, "<!--LastNote:%d-->\r\n", doc.m_nCurrentNode);
	objFile.WriteString(szLastNote);
	
	objFile.WriteString("<HTML>\r\n<HEAD>\r\n<TITLE>");
	//TOFIX write file title as document title
	objFile.WriteString("</TITLE>\r\n</HEAD>\r\n<BODY BGCOLOR=\"#FFFFFF\">\r\n");

	//recursively iterate through document node tree
	DocumentIterator it(doc);
	WriteLevel(it, objFile, -1);

	//write footer
	objFile.WriteString("</BODY>\r\n</HTML>\r\n");
	objFile.WriteFinal();
	
	//TOFIX update m_nOrigSize

#ifdef _DEBUG
	//DumpDocument(doc, "D:\\dump.txt");//debug code
#endif
	return true;
}

