////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: Implements NoteCase HTML format (and NoteCenter format) I/O
////////////////////////////////////////////////////////////////////////////

#include "FormatStickyNotes.h"
#include "File64.h"
#include "DocumentIterator.h"
#include <stdio.h>	//sprintf

#define  DOC_PARSE_BLANK		0
#define  DOC_PARSE_EXPECT_TITLE	1
#define  DOC_PARSE_EXPECT_TEXT	2

void replaceall(std::string &strData, const char *szFind, const char *szReplace);
void WriteLevel(DocumentIterator &it, File64 &file, int nParentID);
void DumpDocument(NoteDocument &doc, const char *szFile);
void DbgTrace(char *szFmt, ...);

FormatStickyNotes::FormatStickyNotes()
{
	m_nCurParentID = -1;
	m_nCurNodeID = -1;
	m_nDocParseState = DOC_PARSE_BLANK;
	m_nTagsParsedCount = 0;
}

FormatStickyNotes::~FormatStickyNotes()
{
}

int FormatStickyNotes::Load(const char *szFile, NoteDocument &doc)
{
	m_objDoc = &doc;  //store pointer

	//clear old document contents
	doc.Clear();

	File64 objFile;	
	if(!objFile.Open(szFile, F64_READ|F64_SHARE_READ|F64_OPEN_EXISTING))
		return DOC_LOAD_NOT_FOUND;

	char szBuffer[1024];
	int nRead;

	//TOFIX better error handling
	while((nRead = objFile.Read(szBuffer, sizeof(szBuffer))) > 0)
		Parse(szBuffer, nRead);

	//detect errors in file format (should have at least some HTML tags inside)
	if(0 == m_nTagsParsedCount)
		return DOC_LOAD_FORMAT_ERROR;

	return DOC_LOAD_OK;
}

bool FormatStickyNotes::Save(const char *szFile, NoteDocument &doc)
{
	return false;	//export not supported
}

// HTMLParser event handlers
void FormatStickyNotes::OnTagBegin(const char *szTag, const char *szParams)
{
	m_nTagsParsedCount ++;

	//if proper tag, create new node
	if(0 == strcmp(szTag, "note"))	//new note
	{
		m_objDoc->NodeInsert(-1, -1);  //TOFIX error report
		int nIdx = m_objDoc->GetNodeCount()-1;
		m_nCurNodeID = m_objDoc->GetNodeByIdx(nIdx).m_nID;
		m_nDocParseState = DOC_PARSE_EXPECT_TEXT;

		//parse title from tag parameters
		std::string strTitle("New node");
		const char *szTitleStart = strstr(szParams, "title=\"");
		if(NULL != szTitleStart)
		{
			printf("params: %s\n",szParams);
			szTitleStart += strlen("title=\"");
			strTitle = szTitleStart;
			const char *szTitleEnd = strstr(szTitleStart, "\"");
			if(NULL != szTitleEnd)
				strTitle = strTitle.substr(0, szTitleEnd-szTitleStart);
		}
		m_objDoc->GetNodeByIdx(nIdx).SetTitle(strTitle.c_str());
	}
}

void FormatStickyNotes::OnTagEnd(const char *szTag)	
{
	//if proper tag, position on the parent node ?
	if(0 == strcmp(szTag, "note"))
	{
		m_nCurNodeID   = -1;
	}
}

void FormatStickyNotes::OnComment(const char *szText)
{
}

void FormatStickyNotes::OnText(const char *szText)
{
	std::string data(szText);

	//set text or title for current node
	if(DOC_PARSE_EXPECT_TEXT == m_nDocParseState)
	{
		HTMLParser::UnescapeChars(data);	//only for node text (NC format)

		//set node text
		int nIdx = m_objDoc->GetIdxFromID(m_nCurNodeID);
		if(nIdx >= 0)
			m_objDoc->GetNodeByIdx(nIdx).SetText(data.c_str());

		m_nDocParseState = DOC_PARSE_BLANK;
	}
}
