/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#ifndef FREE_TEXT_H

#define FREE_TEXT_H
#include "freereplaceable.h"
#include <cairo/cairo.h>

class NedFreeText : public NedFreeReplaceable {
	public:
		NedFreeText(char *text, unsigned int tempo, bool enable_tempo, unsigned int volume, bool enable_volume,
				char *font_family, double font_size, cairo_font_slant_t font_slant, cairo_font_weight_t font_weight);
		NedFreeText(char *text, unsigned int tempo, bool enable_tempo, unsigned int volume, bool enable_volume,
		                        char *font_family, double font_size, cairo_font_slant_t font_slant, cairo_font_weight_t font_weight, NedChordOrRest *element);
		NedFreeText(char *text, unsigned int tempo, bool enable_tempo, unsigned int volume, bool enable_volume,
		                        char *font_family, double font_size, cairo_font_slant_t font_slant, cairo_font_weight_t font_weight, NedChordOrRest *element,
						double x, double y, bool relative);
		virtual NedFreeReplaceable *clone(NedChordOrRest *newelement);
		virtual void draw(cairo_t *cr, double leftx, double topy, double zoom_factor, int zoom_level);
		virtual int getType() {return FREE_PLACEABLE_TEXT;}
		virtual void startContextDialog(GtkWindow *ref);
		unsigned int getTempo() {return m_tempo;}
		void setTempo(unsigned int tempo) {m_tempo = tempo;}
		double getTempoInverse();
		unsigned int m_midi_volume;
		bool m_enable_volume_change, m_enable_tempo_change;
		char *getText() {return m_text;}
		void setText(char *text);
		char *m_font_family;
		double m_font_size;
		cairo_font_slant_t m_font_slant;
		cairo_font_weight_t m_font_weight;
	private: 
		unsigned int m_tempo;
		char *m_text;

};

#endif /* FREE_TEXT_H */
