/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#include <math.h>
#include "testmenu.h"
#include "localization.h"
#include "resource.h"
#include "mainwindow.h"

#define IS_IT(b) ((row == the_dialog->m_current_row && column == the_dialog->m_current_column) ? b[1] : b[0])


XImage* NedTestMenu::m_x11_n64img[2] =  {NULL, NULL};
XImage* NedTestMenu::m_x11_n32img[2] =  {NULL, NULL};
XImage* NedTestMenu::m_x11_n16img[2] =  {NULL, NULL};
XImage* NedTestMenu::m_x11_n8img[2] =  {NULL, NULL};
XImage* NedTestMenu::m_x11_n4img[2] =  {NULL, NULL};
XImage* NedTestMenu::m_x11_n2img[2] =  {NULL, NULL};
XImage* NedTestMenu::m_x11_n1img[2] =  {NULL, NULL};
XImage* NedTestMenu::m_x11_rest_img[2] =  {NULL, NULL};
XImage* NedTestMenu::m_x11_str_grace_img[2] =  {NULL, NULL};
XImage* NedTestMenu::m_x11_grace8_img[2] =  {NULL, NULL};
XImage* NedTestMenu::m_x11_grace16img[2] =  {NULL, NULL};

int NedTestMenu::m_back_img_width, NedTestMenu::m_back_img_height;



NedTestMenu::NedTestMenu(GtkWindow *parent, NedMainWindow *main_window) : m_main_window(main_window),
	m_current_row(-1), m_current_column(-1) {
	GtkWidget *dialog;
	GdkColor bgcolor;

	dialog = gtk_dialog_new_with_buttons(_("Test Menu"), parent, (GtkDialogFlags) (GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT),
		GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL);

	g_signal_connect(dialog, "response", G_CALLBACK (OnClose), (void *) this);

	m_back_img_width = gdk_pixbuf_get_width(NedResource::m_background1);
	m_back_img_height = gdk_pixbuf_get_height(NedResource::m_background1);



	m_test_frame = gtk_frame_new(_("Test Frame"));
	m_test_aera = gtk_drawing_area_new ();
	bgcolor.pixel = 1;
	bgcolor.red = bgcolor.green =  bgcolor.blue =  0xaaaa;
	gtk_widget_modify_bg(GTK_WIDGET(m_test_aera), GTK_STATE_NORMAL, &bgcolor);
	gtk_drawing_area_size(GTK_DRAWING_AREA(m_test_aera), 4 * m_back_img_width, 3 * m_back_img_height);
	gtk_container_add (GTK_CONTAINER(m_test_frame), m_test_aera);

	g_signal_connect (m_test_frame, "expose-event", G_CALLBACK (draw_menu), (void *) this);
	gtk_widget_add_events(m_test_aera, GDK_BUTTON_PRESS_MASK);
	g_signal_connect (m_test_aera, "button-press-event", G_CALLBACK (OnButtonPress), (void *) this);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), m_test_frame);
	gtk_widget_show_all (dialog);
	gtk_dialog_run(GTK_DIALOG(dialog));

}

void NedTestMenu::OnClose(GtkDialog *dialog, gint result, gpointer data) {
	NedTestMenu *test_dialog = (NedTestMenu *) data;
	switch (result) {
		case GTK_RESPONSE_ACCEPT:
			test_dialog->m_state = TRUE;
		break;
		default:
			test_dialog->m_state = FALSE;
		break;
	}
	gtk_widget_destroy (GTK_WIDGET(dialog));
}


void NedTestMenu::getValues(bool *state) {
	*state = m_state;
}

#ifdef AAA
gboolean NedTestMenu::draw_menu(GtkWidget *widget, GdkEventExpose *event, gpointer data) {
	cairo_t *cr;
	NedTestMenu *the_dialog = (NedTestMenu *) data;
	cr = gdk_cairo_create (the_dialog->m_test_aera->window);
	cairo_set_source_rgb (cr, 1.0, 1.0, 1.0);
	cairo_rectangle (cr,  0, 0,  the_dialog->m_test_aera->allocation.width, the_dialog->m_test_aera->allocation.height);
	cairo_fill(cr);
	cairo_set_source_rgb (cr, 0.0, 0.0, 1.0);
	cairo_new_path(cr);
	cairo_set_line_width(cr, 4.0);

	cairo_arc(cr, TEST_AREA_WIDTH /2, TEST_AREA_HEIGHT / 2, TEST_AREA_WIDTH / 4, 0.0, 2.0 * M_PI);
	cairo_fill(cr);
	cairo_destroy (cr);
	return FALSE;
}
#else
gboolean NedTestMenu::draw_menu(GtkWidget *widget, GdkEventExpose *event, gpointer data) {
	NedTestMenu *the_dialog = (NedTestMenu *) data;
	Display *dpy;
	Window win;
	GC gc;
	int screen;
	int row, column;
	
	dpy = gdk_x11_drawable_get_xdisplay(the_dialog->m_test_aera->window);
	win = gdk_x11_drawable_get_xid(the_dialog->m_test_aera->window);
	screen = DefaultScreen(dpy);
	gc = DefaultGC(dpy, screen);
	if (m_x11_n32img[0] == NULL) {
		createX11Pixmaps(dpy, screen, the_dialog->m_test_aera->window, the_dialog->m_test_aera->style->white_gc);
	}
	row = column = 0;
	XPutImage(dpy, win, gc, IS_IT(m_x11_n64img), 0, 0, 0, 0, m_back_img_width, m_back_img_height);
	column++;
	XPutImage(dpy, win, gc, IS_IT(m_x11_n32img), 0, 0, m_back_img_width, 0, m_back_img_width, m_back_img_height);
	column++;
	XPutImage(dpy, win, gc, IS_IT(m_x11_n16img), 0, 0, 2 * m_back_img_width, 0, m_back_img_width, m_back_img_height);
	column++;
	XPutImage(dpy, win, gc, IS_IT(m_x11_n8img), 0, 0, 3 * m_back_img_width, 0, m_back_img_width, m_back_img_height);

	row = 1; column = 0;
	XPutImage(dpy, win, gc, IS_IT(m_x11_n4img), 0, 0, 0, m_back_img_height, m_back_img_width, m_back_img_height);
	column++;
	XPutImage(dpy, win, gc, IS_IT(m_x11_n2img), 0, 0, m_back_img_width, m_back_img_height, m_back_img_width, m_back_img_height);
	column++;
	XPutImage(dpy, win, gc, IS_IT(m_x11_n1img), 0, 0, 2 * m_back_img_width,  m_back_img_height, m_back_img_width, m_back_img_height);
	column++;
	XPutImage(dpy, win, gc, IS_IT(m_x11_rest_img), 0, 0, 3 * m_back_img_width, m_back_img_height, m_back_img_width, m_back_img_height);

	row = 2; column = 0;
	XPutImage(dpy, win, gc, IS_IT(m_x11_str_grace_img), 0, 0, 0, 2 * m_back_img_height, m_back_img_width, m_back_img_height);
	column++;
	XPutImage(dpy, win, gc, IS_IT(m_x11_grace8_img), 0, 0, m_back_img_width, 2 * m_back_img_height, m_back_img_width, m_back_img_height);
	column++;
	XPutImage(dpy, win, gc, IS_IT(m_x11_grace16img), 0, 0, 2 * m_back_img_width, 2 * m_back_img_height, m_back_img_width, m_back_img_height);

	return FALSE;
}
#endif

void NedTestMenu::createX11Pixmaps(Display *dpy, int screen, GdkDrawable *d, GdkGC *gc) {


	m_x11_n64img[0] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_64thnote_icon, false);
	m_x11_n32img[0] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_32ndnote_icon, false);
	m_x11_n16img[0] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_sixteenthnote_icon, false);
	m_x11_n8img[0] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_eightnote_icon, false);
	m_x11_n4img[0] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_quarternote_icon, false);
	m_x11_n2img[0] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_halfnote_icon, false);
	m_x11_n1img[0] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_fullnote_icon, false);
	m_x11_rest_img[0] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_rest_icon, false);
	m_x11_str_grace_img[0] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_stroken_grace_icon, false);
	m_x11_grace8_img[0] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_grace_eighth_icon, false);
	m_x11_grace16img[0] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_grace_eighth_icon, false);

	m_x11_n64img[1] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_64thnote_icon, true);
	m_x11_n32img[1] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_32ndnote_icon, true);
	m_x11_n16img[1] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_sixteenthnote_icon, true);
	m_x11_n8img[1] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_eightnote_icon, true);
	m_x11_n4img[1] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_quarternote_icon, true);
	m_x11_n2img[1] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_halfnote_icon, true);
	m_x11_n1img[1] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_fullnote_icon, true);
	m_x11_rest_img[1] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_rest_icon, true);
	m_x11_str_grace_img[1] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_stroken_grace_icon, true);
	m_x11_grace8_img[1] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_grace_eighth_icon, true);
	m_x11_grace16img[1] = createX11PixmapFromGdkPixbuffer(dpy, screen, d, gc, NedResource::m_grace_eighth_icon, true);
}

XImage *NedTestMenu::createX11PixmapFromGdkPixbuffer(Display *dpy, int screen, GdkDrawable *d, GdkGC *gc, GdkPixbuf *pixbuf, bool up) {
	int depth;
	GdkImage *gdk_image;
	GdkPixmap *gdk_pixmap;
	XImage *x11_img;
	int w, h;

	w = gdk_pixbuf_get_width(pixbuf);
	h = gdk_pixbuf_get_height(pixbuf);

	depth = DefaultDepth(dpy, screen);

	gdk_pixmap = gdk_pixmap_new(d, m_back_img_width, m_back_img_height, depth);
	//gdk_draw_rectangle(gdk_pixmap, gc, TRUE, 0, 0, m_back_img_width, m_back_img_height);
	gdk_pixbuf_render_to_drawable (up ? NedResource::m_background1 : NedResource::m_background2, gdk_pixmap, gc,
		0, 0, 0, 0, m_back_img_width, m_back_img_height, GDK_RGB_DITHER_NONE, 0, 0);
	gdk_pixbuf_render_to_drawable (pixbuf, gdk_pixmap, gc,
		0, 0, (m_back_img_width - w) / 2, (m_back_img_height - h) / 2, w, h, GDK_RGB_DITHER_NONE, 0, 0);
	gdk_image = gdk_image_get(gdk_pixmap, 0, 0, m_back_img_width, m_back_img_height);
	x11_img = gdk_x11_image_get_ximage(gdk_image);
	//g_object_unref(gdk_pixmap);
	return x11_img;
}

bool NedTestMenu::OnButtonPress(GtkWidget *widget, GdkEventButton *event, gpointer data) {

	if (event->x < 0 || event->x > 4 * m_back_img_width) return FALSE;
	if (event->y < 0 || event->y > 3 * m_back_img_height) return FALSE;
	NedTestMenu *the_dialog = (NedTestMenu *) data;
	the_dialog->m_current_column = (int) (event->x / m_back_img_width);
	the_dialog->m_current_row = (int) (event->y / m_back_img_height);
	gdk_window_invalidate_rect(the_dialog->m_test_frame->window, NULL, FALSE);
	return FALSE;
}
