/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#ifndef TEST_MENU_H

#define TEST_MENU_H
#include "config.h"
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

class NedMainWindow;


class NedTestMenu {
	public:
		NedTestMenu(GtkWindow *parent, NedMainWindow *main_window);
		void getValues(bool *state);
	private:
		static void OnClose(GtkDialog *dialog, gint result, gpointer data);
		static bool OnButtonPress(GtkWidget *widget, GdkEventButton *event, gpointer data);
		static gboolean draw_menu(GtkWidget *widget, GdkEventExpose *event, gpointer data);
		static void createX11Pixmaps(Display *dpy, int screen, GdkDrawable *d, GdkGC *gc);
		static XImage *createX11PixmapFromGdkPixbuffer(Display *dpy, int screen, GdkDrawable *d, GdkGC *gc,
			GdkPixbuf *pixbuf, bool up);
		GtkWidget *m_test_aera;
		GtkWidget *m_test_frame;
		bool m_state;
		NedMainWindow *m_main_window;
		int m_current_row, m_current_column;
		static XImage* m_x11_n64img[2], *m_x11_n32img[2], *m_x11_n16img[2], *m_x11_n8img[2];
		static XImage* m_x11_n4img[2], *m_x11_n2img[2], *m_x11_n1img[2], *m_x11_rest_img[2];
		static XImage* m_x11_str_grace_img[2], *m_x11_grace8_img[2], *m_x11_grace16img[2];
		static int m_back_img_width, m_back_img_height;
};

#endif /* TEST_MENU_H */
