/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#include "chordnamedialog.h"
#include "localization.h"
#include "resource.h"
#include "config.h"

NedChordNameDialog::NedChordNameDialog(GtkWindow *parent, char *roottext, char *uptext, char *downtext) {
	GtkWidget *dialog;
	GtkWidget *text_frame;
	GtkWidget *main_h_box;
	GtkWidget *vbox;

	dialog = gtk_dialog_new_with_buttons(_("Chordname"), parent, (GtkDialogFlags) (GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT),
		GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL);
	g_signal_connect(dialog, "response", G_CALLBACK (CloseCallBack), (void *) this);


	text_frame = gtk_frame_new(_("chordname"));
	main_h_box = gtk_hbox_new(FALSE, 2);
	vbox = gtk_vbox_new(FALSE, 2);

	m_root_text_widget = gtk_entry_new_with_max_length(10);
	if (roottext != NULL) {
		gtk_entry_set_text(GTK_ENTRY(m_root_text_widget), roottext);
	}

	m_up_text_widget = gtk_entry_new_with_max_length(10);
	if (uptext != NULL) {
		gtk_entry_set_text(GTK_ENTRY(m_up_text_widget), uptext);
	}

	m_down_text_widget = gtk_entry_new_with_max_length(10);
	if (downtext != NULL) {
		gtk_entry_set_text(GTK_ENTRY(m_down_text_widget), downtext);
	}
	gtk_box_pack_start(GTK_BOX(main_h_box), m_root_text_widget, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), m_up_text_widget, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), m_down_text_widget, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(main_h_box), vbox, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER(text_frame), main_h_box);

	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), text_frame);
	gtk_widget_show_all (dialog);
	gtk_dialog_run(GTK_DIALOG(dialog));
}

void NedChordNameDialog::CloseCallBack(GtkDialog *dialog, gint result, gpointer data) {
	NedChordNameDialog *text_dialog = (NedChordNameDialog *) data;
	const gchar *newtext;

	switch (result) {
		case GTK_RESPONSE_ACCEPT:
			text_dialog->m_state = TRUE;
		break;
		default:
			text_dialog->m_state = FALSE;
		break;
	}
	if (text_dialog->m_state) {
		text_dialog->m_root_text = NULL;
		newtext = gtk_entry_get_text(GTK_ENTRY(text_dialog->m_root_text_widget));
		if (strlen(newtext) > 0) {
			text_dialog->m_root_text = strdup(newtext);
		}
		else {
			text_dialog->m_state = false;
		}
		text_dialog->m_up_text = NULL;
		newtext = gtk_entry_get_text(GTK_ENTRY(text_dialog->m_up_text_widget));
		if (strlen(newtext) > 0) {
			text_dialog->m_up_text = strdup(newtext);
		}
		text_dialog->m_down_text = NULL;
		newtext = gtk_entry_get_text(GTK_ENTRY(text_dialog->m_down_text_widget));
		if (strlen(newtext) > 0) {
			text_dialog->m_down_text = strdup(newtext);
		}
	}
	gtk_widget_destroy (GTK_WIDGET(dialog));
}

void NedChordNameDialog::getValues(bool *state, char **roottext, char **uptext, char **downtext) {
	*state = m_state;
	*roottext = m_root_text;
	*uptext = m_up_text;
	*downtext = m_down_text;
}
