/*! cal-heatmap v3.1.0 (Thu Aug 08 2013 01:26:31)
 *  ---------------------------------------------
 *  Cal-Heatmap is a javascript module to create calendar heatmap to visualize time series data, a la github contribution graph
 *  https://github.com/kamisama/cal-heatmap
 *  Licensed under the MIT license
 *  Copyright 2013 Wan Qi Chen
 */
function mergeRecursive(t,e){for(var n in e)try{t[n]=e[n].constructor===Object?mergeRecursive(t[n],e[n]):e[n]}catch(o){t[n]=e[n]}return t}var CalHeatMap=function(){"use strict";function t(){if(o.getDomain(o.options.start).map(function(t){return t.getTime()}).map(function(t){o._domains.set(t,o.getSubDomain(t).map(function(t){return{t:o._domainType[o.options.subDomain].extractUnit(t),v:null}}))}),o.root=d3.select(o.options.itemSelector),o.root.append("svg").attr("class","graph"),o.options.paintOnLoad)if(o.verticalDomainLabel="top"===o.options.label.position||"bottom"===o.options.label.position,o.domainVerticalLabelHeight=Math.max(25,2*o.options.cellSize),o.domainHorizontalLabelWidth=0,o.verticalDomainLabel||(o.domainVerticalLabelHeight=0,o.domainHorizontalLabelWidth=o.options.label.width),"number"==typeof o.options.domainMargin&&(o.options.domainMargin=[o.options.domainMargin,o.options.domainMargin,o.options.domainMargin,o.options.domainMargin]),o.paint(),o.options.nextSelector!==!1&&d3.select(o.options.nextSelector).on("click."+o.options.itemNamespace,function(){return d3.event.preventDefault(),o.loadNextDomain()}),o.options.previousSelector!==!1&&d3.select(o.options.previousSelector).on("click."+o.options.itemNamespace,function(){return d3.event.preventDefault(),o.loadPreviousDomain()}),o.options.displayLegend&&o.displayLegend(r.width-o.options.domainGutter-o.options.cellPadding),null!==o.options.afterLoad&&o.afterLoad(),o.options.loadOnInit){var t=o._domains.keys().sort();o.getDatas(o.options.data,new Date(parseInt(t[0],10)),o.getSubDomain(parseInt(t[t.length-1],10)).pop(),function(){o.fill(),o.onComplete()})}else o.onComplete();return!0}function e(t,e){var n=o.options.cellSize*o._domainType[o.options.subDomain].column(t)+o.options.cellPadding*o._domainType[o.options.subDomain].column(t);return e!==void 0&&e===!0?n+=o.domainHorizontalLabelWidth+o.options.domainGutter+o.options.domainMargin[1]+o.options.domainMargin[3]:n}function n(t,e){var n=o.options.cellSize*o._domainType[o.options.subDomain].row(t)+o.options.cellPadding*o._domainType[o.options.subDomain].row(t);return e!==void 0&&e===!0&&(n+=o.options.domainGutter+o.domainVerticalLabelHeight+o.options.domainMargin[0]+o.options.domainMargin[2]),n}var o=this,i=["json","csv","tsv","txt"];this.options={itemSelector:"#cal-heatmap",paintOnLoad:!0,range:12,cellSize:10,cellPadding:2,cellRadius:0,domainGutter:2,domainMargin:[0,0,0,0],domain:"hour",subDomain:"min",weekStartOnMonday:!0,start:new Date,minDate:null,maxDate:null,data:"",dataType:i[0],considerMissingDataAsZero:!1,loadOnInit:!0,verticalOrientation:!1,domainDynamicDimension:!0,label:{position:"bottom",align:"center",offset:{x:0,y:0},rotate:null,width:100},legend:[10,20,30,40],displayLegend:!0,legendCellSize:10,legendCellPadding:2,legendMargin:[10,0,0,0],legendVerticalPosition:"bottom",legendHorizontalPosition:"left",highlight:[],itemName:["item","items"],domainLabelFormat:null,subDomainTitleFormat:{empty:"{date}",filled:"{count} {name} {connector} {date}"},subDomainDateFormat:null,subDomainTextFormat:null,legendTitleFormat:{lower:"less than {min} {name}",inner:"between {down} and {up} {name}",upper:"more than {max} {name}"},animationDuration:500,nextSelector:!1,previousSelector:!1,itemNamespace:"cal-heatmap",onClick:null,afterLoad:null,afterLoadNextDomain:null,afterLoadPreviousDomain:null,onComplete:null,afterLoadData:function(t){return t},onMaxDomainReached:null,onMinDomainReached:null},this._domainType={min:{name:"minute",level:10,row:function(){return 10},column:function(){return 6},position:{x:function(t){return Math.floor(t.getMinutes()/o._domainType.min.row(t))},y:function(t){return t.getMinutes()%o._domainType.min.row(t)}},format:{date:"%H:%M, %A %B %e, %Y",legend:"",connector:"at"},extractUnit:function(t){var e=new Date(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes());return e.getTime()}},hour:{name:"hour",level:20,row:function(){return 6},column:function(t){switch(o.options.domain){case"day":return 4;case"week":return 28;case"month":return 4*(o.options.domainDynamicDimension?o.getEndOfMonth(t).getDate():31)}},position:{x:function(t){return"month"===o.options.domain?Math.floor(t.getHours()/o._domainType.hour.row(t))+4*(t.getDate()-1):"week"===o.options.domain?Math.floor(t.getHours()/o._domainType.hour.row(t))+4*o.getWeekDay(t):Math.floor(t.getHours()/o._domainType.hour.row(t))},y:function(t){return t.getHours()%o._domainType.hour.row(t)}},format:{date:"%Hh, %A %B %e, %Y",legend:"%H:00",connector:"at"},extractUnit:function(t){var e=new Date(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours());return e.getTime()}},day:{name:"day",level:30,row:function(){return 7},column:function(t){switch(t=new Date(t),o.options.domain){case"year":return o.options.domainDynamicDimension?o.getWeekNumber(new Date(t.getFullYear(),11,31))-o.getWeekNumber(new Date(t.getFullYear(),0))+1:54;case"month":return o.options.verticalOrientation?6:o.options.domainDynamicDimension?o.getWeekNumber(new Date(t.getFullYear(),t.getMonth()+1,0))-o.getWeekNumber(t)+1:6;case"week":return 1}},position:{x:function(t){switch(o.options.domain){case"week":return 0;case"month":return o.getWeekNumber(t)-o.getWeekNumber(new Date(t.getFullYear(),t.getMonth()));case"year":return o.getWeekNumber(t)}},y:function(t){return o.getWeekDay(t)}},format:{date:"%A %B %e, %Y",legend:"%e %b",connector:"on"},extractUnit:function(t){var e=new Date(t.getFullYear(),t.getMonth(),t.getDate());return e.getTime()}},week:{name:"week",level:40,row:function(){return 1},column:function(t){switch(t=new Date(t),o.options.domain){case"year":return 54;case"month":return o.getWeekNumber(new Date(t.getFullYear(),t.getMonth()+1,0))-o.getWeekNumber(t);default:return 1}},position:{x:function(t){switch(o.options.domain){case"year":return o.getWeekNumber(t);case"month":return o.getWeekNumber(t)-o.getWeekNumber(new Date(t.getFullYear(),t.getMonth()))-1}},y:function(){return 0}},format:{date:"%B Week #%W",legend:"%B Week #%W",connector:"on"},extractUnit:function(t){var e=new Date(t.getFullYear(),t.getMonth(),t.getDate()),n=e.getDay()-1;return 0>n&&(n=6),e.setDate(e.getDate()-n),e.getTime()}},month:{name:"month",level:50,row:function(){return 1},column:function(){return 12},position:{x:function(t){return Math.floor(t.getMonth()/o._domainType.month.row(t))},y:function(t){return t.getMonth()%o._domainType.month.row(t)}},format:{date:"%B %Y",legend:"%B",connector:"on"},extractUnit:function(t){var e=new Date(t.getFullYear(),t.getMonth());return e.getTime()}},year:{name:"year",level:60,row:function(){return 1},column:function(){return 12},position:{x:function(t){return Math.floor(t.getFullYear()/this._domainType.year.row(t))},y:function(t){return t.getFullYear()%this._domainType.year.row(t)}},format:{date:"%Y",legend:"%Y",connector:"on"},extractUnit:function(t){var e=new Date(t.getFullYear());return e.getTime()}}};for(var a in this._domainType)this._domainType["x_"+a]={},this._domainType["x_"+a].name="x_"+a,this._domainType["x_"+a].level=this._domainType[a].level,this._domainType["x_"+a].row=this._domainType[a].column,this._domainType["x_"+a].column=this._domainType[a].row,this._domainType["x_"+a].position={},this._domainType["x_"+a].position.x=this._domainType[a].position.y,this._domainType["x_"+a].position.y=this._domainType[a].position.x,this._domainType["x_"+a].format=this._domainType[a].format,this._domainType["x_"+a].extractUnit=this._domainType[a].extractUnit;this._domainType.x_day.row=function(t){switch(t=new Date(t),o.options.domain){case"year":return o.options.domainDynamicDimension?o.getWeekNumber(new Date(t.getFullYear(),11,31))-o.getWeekNumber(new Date(t.getFullYear(),0))+1:54;case"month":return o.options.verticalOrientation?o.options.domainDynamicDimension?o.getWeekNumber(new Date(t.getFullYear(),t.getMonth()+1,0))-o.getWeekNumber(t)+1:6:6;case"week":return 1}},this.svg=null,this._completed=!1,this._domains=d3.map();var r={width:0,height:0};this.NAVIGATE_LEFT=1,this.NAVIGATE_RIGHT=2,this.RESET_ALL_ON_UPDATE=0,this.RESET_SINGLE_ON_UPDATE=1,this.APPEND_ON_UPDATE=2,this.root=null,this._maxDomainReached=!1,this._minDomainReached=!1,this.domainPosition=new DomainPosition,this.paint=function(t){function i(e,n,i,a){var r=0;switch(t){case!1:return r=n[i],n[i]+=a,o.domainPosition.setPosition(e,r),r;case o.NAVIGATE_RIGHT:return o.domainPosition.setPosition(e,n[i]),l=a,m=o.domainPosition.getPositionFromIndex(1),o.domainPosition.shiftRightBy(m),n[i];case o.NAVIGATE_LEFT:return r=-a,l=-r,m=n[i]-o.domainPosition.getLast(),o.domainPosition.setPosition(e,r),o.domainPosition.shiftLeftBy(l),r}}function a(t){switch(o.options.label.rotate){case"right":t.attr("transform",function(t){var n="rotate(90), ";switch(o.options.label.position){case"right":n+="translate(-"+e(t)+" , -"+e(t)+")";break;case"left":n+="translate(0, -"+o.domainHorizontalLabelWidth+")"}return n});break;case"left":t.attr("transform",function(t){var n="rotate(270), ";switch(o.options.label.position){case"right":n+="translate(-"+(e(t)+o.domainHorizontalLabelWidth)+" , "+e(t)+")";break;case"left":n+="translate(-"+o.domainHorizontalLabelWidth+" , "+o.domainHorizontalLabelWidth+")"}return n})}}t===void 0&&(t=!1);var s=o.root.select(".graph").selectAll(".graph-domain").data(o._domains.keys().map(function(t){return parseInt(t,10)}),function(t){return t}),l=0,m=0;o.svg=s.enter().append("svg").attr("width",function(t){return e(t,!0)}).attr("height",function(t){return n(t,!0)}).attr("x",function(t){return o.options.verticalOrientation?(r.width=e(t,!0),0):i(t,r,"width",e(t,!0))}).attr("y",function(t){return o.options.verticalOrientation?i(t,r,"height",n(t,!0)):(r.height=n(t,!0),0)}).attr("class",function(t){var e="graph-domain",n=new Date(t);switch(o.options.domain){case"hour":e+=" h_"+n.getHours();case"day":e+=" d_"+n.getDate()+" dy_"+n.getDay();case"week":e+=" w_"+o.getWeekNumber(n);case"month":e+=" m_"+(n.getMonth()+1);case"year":e+=" y_"+n.getFullYear()}return e}),o.svg.append("rect").attr("width",function(t){return e(t,!0)-o.options.domainGutter-o.options.cellPadding}).attr("height",function(t){return n(t,!0)-o.options.domainGutter-o.options.cellPadding}).attr("class","domain-background");var u=o.svg.append("svg").attr("x",function(){return"left"===o.options.label.position?o.domainHorizontalLabelWidth+o.options.domainMargin[3]:o.options.domainMargin[3]}).attr("y",function(){return"top"===o.options.label.position?o.domainVerticalLabelHeight+o.options.domainMargin[0]:o.options.domainMargin[0]}).attr("class","graph-subdomain-group"),p=u.selectAll("g").data(function(t){return o._domains.get(t)},function(t){return t.t}).enter().append("g");p.append("rect").attr("class",function(t){return"graph-rect"+o.getHighlightClassName(t.t)+(null!==o.options.onClick?" hover_cursor":"")}).attr("width",o.options.cellSize).attr("height",o.options.cellSize).attr("x",function(t){return o.positionSubDomainX(t.t)}).attr("y",function(t){return o.positionSubDomainY(t.t)}).on("click",function(t){return null!==o.options.onClick?o.onClick(new Date(t.t),t.v):void 0}).call(function(t){o.options.cellRadius>0&&t.attr("rx",o.options.cellRadius).attr("ry",o.options.cellRadius)}),p.append("title").text(function(t){return o.formatDate(new Date(t.t),o.options.subDomainDateFormat)}),o.svg.append("text").attr("class","graph-label").attr("y",function(t){var e=o.options.domainMargin[0];switch(o.options.label.position){case"top":e+=o.domainVerticalLabelHeight/2;break;case"bottom":e+=n(t)+o.domainVerticalLabelHeight/2}return e+o.options.label.offset.y*("right"===o.options.label.rotate&&"right"===o.options.label.position||"left"===o.options.label.rotate&&"left"===o.options.label.position?-1:1)}).attr("x",function(t){var n=o.options.domainMargin[3];switch(o.options.label.position){case"right":n+=e(t);break;case"bottom":case"top":n+=e(t)/2}return"right"===o.options.label.align?n+o.domainHorizontalLabelWidth-o.options.label.offset.x*("right"===o.options.label.rotate?-1:1):n+o.options.label.offset.x}).attr("text-anchor",function(){switch(o.options.label.align){case"start":case"left":return"start";case"end":case"right":return"end";default:return"middle"}}).attr("dominant-baseline",function(){return o.verticalDomainLabel?"middle":"top"}).text(function(t){return o.formatDate(new Date(t),o.options.domainLabelFormat)}).call(a),null!==o.options.subDomainTextFormat&&p.append("text").attr("class",function(t){return"subdomain-text"+o.getHighlightClassName(t.t)}).attr("x",function(t){return o.positionSubDomainX(t.t)+o.options.cellSize/2}).attr("y",function(t){return o.positionSubDomainY(t.t)+o.options.cellSize/2}).attr("text-anchor","middle").attr("dominant-baseline","central").text(function(t){return o.formatDate(new Date(t.t),o.options.subDomainTextFormat)}),t!==!1&&s.transition().duration(o.options.animationDuration).attr("x",function(t){return o.options.verticalOrientation?0:o.domainPosition.getPosition(t)}).attr("y",function(t){return o.options.verticalOrientation?o.domainPosition.getPosition(t):0});var h=r.width,g=r.height;o.options.verticalOrientation?r.height+=l-m:r.width+=l-m,s.exit().transition().duration(o.options.animationDuration).attr("x",function(n){if(o.options.verticalOrientation)return 0;switch(t){case o.NAVIGATE_LEFT:return Math.min(r.width,h);case o.NAVIGATE_RIGHT:return-e(n,!0)}}).attr("y",function(e){if(!o.options.verticalOrientation)return 0;switch(t){case o.NAVIGATE_LEFT:return Math.min(r.height,g);case o.NAVIGATE_RIGHT:return-n(e,!0)}}).remove(),o.root.select(".graph").transition().duration(o.options.animationDuration).attr("width",function(){return r.width-o.options.domainGutter-o.options.cellPadding}).attr("height",function(){return r.height-o.options.domainGutter-o.options.cellPadding})},this.fill=function(){var t=o.svg.selectAll("svg").selectAll("g").data(function(t){return o._domains.get(t)},function(t){return t.t});t.transition().select("rect").attr("class",function(t){var e="graph-rect"+o.getHighlightClassName(t.t);return null!==t.v?e+=" "+o.legend(t.v):o.options.considerMissingDataAsZero&&(e+=" "+o.legend(0)),null!==o.options.onClick&&(e+=" hover_cursor"),e}),t.transition().select("title").text(function(t){if(null!==t.v||o.options.considerMissingDataAsZero){var e=t.v;return null===e&&o.options.considerMissingDataAsZero&&(e=0),o.options.subDomainTitleFormat.filled.format({count:o.formatNumber(e),name:o.options.itemName[1!==e?1:0],connector:o._domainType[o.options.subDomain].format.connector,date:o.formatDate(new Date(t.t),o.options.subDomainDateFormat)})}return o.options.subDomainTitleFormat.empty.format({date:o.formatDate(new Date(t.t),o.options.subDomainDateFormat)})})},this.init=function(e){function n(t){return!(t instanceof Element)&&"string"!=typeof t||""===t}if(o.options=mergeRecursive(o.options,e),!this._domainType.hasOwnProperty(o.options.domain)||"min"===o.options.domain||"x_"===o.options.domain.substring(0,2))return console.log("The domain '"+o.options.domain+"' is not valid"),!1;if(!this._domainType.hasOwnProperty(o.options.subDomain)||"year"===o.options.subDomain)return console.log("The subDomain '"+o.options.subDomain+"' is not valid"),!1;if(this._domainType[o.options.domain].level<=this._domainType[o.options.subDomain].level)return console.log("'"+o.options.subDomain+"' is not a valid subDomain to '"+o.options.domain+"'"),!1;if(!e.hasOwnProperty("subDomain"))switch(o.options.domain){case"year":o.options.subDomain="month";break;case"month":o.options.subDomain="day";break;case"week":o.options.subDomain="day";break;case"day":o.options.subDomain="hour";break;default:o.options.subDomain="min"}if(0>i.indexOf(o.options.dataType))return console.log("The data type '"+o.options.dataType+"' is not valid data type"),!1;if(null===o.options.subDomainDateFormat&&(o.options.subDomainDateFormat=this._domainType[o.options.subDomain].format.date),null===o.options.domainLabelFormat&&(o.options.domainLabelFormat=this._domainType[o.options.domain].format.legend),!e.hasOwnProperty("label")||e.hasOwnProperty("label")&&!e.label.hasOwnProperty("align")){switch(o.options.label.position){case"left":o.options.label.align="right";break;case"right":o.options.label.align="left";break;default:o.options.label.align="center"}"left"===o.options.label.rotate?o.options.label.align="right":"right"===o.options.label.rotate&&(o.options.label.align="left")}if((!e.hasOwnProperty("label")||e.hasOwnProperty("label")&&!e.label.hasOwnProperty("offset"))&&("left"===o.options.label.position||"right"===o.options.label.position)&&(o.options.label.offset={x:10,y:15}),n(o.options.itemSelector))return console.log("The itemSelector is invalid"),!1;if(null===d3.select(o.options.itemSelector)[0][0])return console.log("The node specified in itemSelector does not exists"),!1;if(o.options.nextSelector!==!1&&n(o.options.nextSelector))return console.log("The nextSelector is invalid"),!1;if(o.options.previousSelector!==!1&&n(o.options.previousSelector))return console.log("The previousSelector is invalid"),!1;if(("string"!=typeof o.options.itemNamespace||""===o.options.itemNamespace)&&(console.log("itemNamespace can not be empty, falling back to cal-heatmap"),o.options.itemNamespace="cal-heatmap"),"number"==typeof o.options.domainMargin&&(o.options.domainMargin=[o.options.domainMargin,o.options.domainMargin,o.options.domainMargin,o.options.domainMargin]),Array.isArray(o.options.domainMargin))switch(o.options.domainMargin.length){case 0:o.options.domainMargin=[0,0,0,0];break;case 1:o.options.domainMargin=[o.options.domainMargin,o.options.domainMargin,o.options.domainMargin,o.options.domainMargin];break;case 2:o.options.domainMargin=[o.options.domainMargin[0],o.options.domainMargin[1],o.options.domainMargin[0],o.options.domainMargin[1]];break;case 3:o.options.domainMargin=[o.options.domainMargin[0],o.options.domainMargin[1],o.options.domainMargin[2],o.options.domainMargin[1]];break;case 4:o.options.domainMargin=o.options.domainMargin;break;default:o.options.domainMargin.splice(4)}"string"==typeof o.options.itemName?o.options.itemName=[o.options.itemName,o.options.itemName+"s"]:Array.isArray(o.options.itemName)&&1===o.options.itemName.length&&(o.options.itemName=[o.options.itemName[0],o.options.itemName[0]+"s"]);var a=["data","onComplete","onClick","afterLoad","afterLoadData","afterLoadPreviousDomain","afterLoadNextDomain"];for(var r in a)e.hasOwnProperty(a[r])&&(o.options[a[r]]=e[a[r]]);if("string"==typeof o.options.highlight)o.options.highlight="now"===o.options.highlight?[new Date]:[];else if(Array.isArray(o.options.highlight)){var s=o.options.highlight.indexOf("now");-1!==s&&(o.options.highlight.splice(s,1),o.options.highlight.push(new Date))}return t()}};CalHeatMap.prototype={triggerEvent:function(t,e,n){return 3===arguments.length&&n||null===this.options[t]?!0:"function"==typeof this.options[t]?("function"==typeof e&&(e=e()),this.options[t].apply(this,e)):(console.log("Provided callback for "+t+" is not a function."),!1)},onClick:function(t,e){return this.triggerEvent("onClick",[t,e])},afterLoad:function(){return this.triggerEvent("afterLoad")},onComplete:function(){var t=this.triggerEvent("onComplete",[],this._completed);return this._completed=!0,t},afterLoadPreviousDomain:function(t){var e=this;return this.triggerEvent("afterLoadPreviousDomain",function(){var n=e.getSubDomain(t);return[n.shift(),n.pop()]})},afterLoadNextDomain:function(t){var e=this;return this.triggerEvent("afterLoadNextDomain",function(){var n=e.getSubDomain(t);return[n.shift(),n.pop()]})},onMinDomainReached:function(t){return this._minDomainReached=t,this.triggerEvent("onMinDomainReached",[t])},onMaxDomainReached:function(t){return this._maxDomainReached=t,this.triggerEvent("onMaxDomainReached",[t])},formatNumber:d3.format(",g"),formatDate:function(t,e){if(e===void 0&&(e="title"),"function"==typeof e)return e(t);var n=d3.time.format(e);return n(t)},loadNextDomain:function(){var t=this.getNextDomain().getTime();if(this._maxDomainReached||this.maxDomainIsReached(t))return!1;var e=this;this._domains.set(t,this.getSubDomain(t).map(function(t){return{t:e._domainType[e.options.subDomain].extractUnit(t),v:null}})),this._domains.remove(this._domains.keys().sort().shift()),this.paint(this.NAVIGATE_RIGHT);var n=this._domains.keys().sort();return this.getDatas(this.options.data,new Date(parseInt(n[n.length-1],10)),this.getSubDomain(parseInt(n[n.length-1],10)).pop(),function(){e.fill()}),this.afterLoadNextDomain(new Date(parseInt(n[n.length-1],10))),this.maxDomainIsReached(this.getNextDomain().getTime())&&this.onMaxDomainReached(!0),this._minDomainReached&&!this.minDomainIsReached(n[0])&&this.onMinDomainReached(!1),!0},loadPreviousDomain:function(){if(this._minDomainReached||this.minDomainIsReached(this._domains[0]))return!1;var t=this.getPreviousDomain().getTime(),e=this;this._domains.set(t,this.getSubDomain(t).map(function(t){return{t:e._domainType[e.options.subDomain].extractUnit(t),v:null}})),this._domains.remove(this._domains.keys().sort().pop()),this.paint(this.NAVIGATE_LEFT);var n=this._domains.keys().sort();return this.getDatas(this.options.data,new Date(parseInt(n[0],10)),this.getSubDomain(parseInt(n[0],10)).pop(),function(){e.fill()}),this.afterLoadPreviousDomain(new Date(parseInt(n[0],10))),this.minDomainIsReached(t)&&this.onMinDomainReached(!0),this._maxDomainReached&&!this.maxDomainIsReached(n[n.length-1])&&this.onMaxDomainReached(!1),!0},maxDomainIsReached:function(t){return null!==this.options.maxDate&&t>this.options.maxDate.getTime()},minDomainIsReached:function(t){return null!==this.options.minDate&&this.options.minDate.getTime()>=t},displayLegend:function(t){var e=this,n=this.root;n="top"===this.options.legendVerticalPosition?n.insert("svg",".graph"):n.append("svg");var o=this.options.legendCellSize*(this.options.legend.length+1)+this.options.legendCellPadding*(this.options.legend.length+1)+this.options.legendMargin[3]+this.options.legendMargin[1];n=n.attr("class","graph-legend").attr("height",this.options.legendCellSize+this.options.legendMargin[0]+this.options.legendMargin[2]).attr("width",t).append("g").attr("transform",function(){switch(e.options.legendHorizontalPosition){case"right":return"translate("+(t-o)+")";case"middle":case"center":return"translate("+(t/2-o/2)+")";default:return"translate("+e.options.legendMargin[3]+")"}}).attr("y",this.options.legendMargin[0]).selectAll().data(d3.range(0,this.options.legend.length+1));var i=n.enter().append("rect").attr("width",this.options.legendCellSize).attr("height",this.options.legendCellSize).attr("class",function(t){return"graph-rect q"+(t+1)}).attr("x",function(t){return t*(e.options.legendCellSize+e.options.legendCellPadding)}).attr("y",this.options.legendMargin[0]).attr("fill-opacity",0);i.transition().delay(function(t,n){return e.options.animationDuration*n/10}).attr("fill-opacity",1),i.append("title").text(function(t){return 0===t?e.options.legendTitleFormat.lower.format({min:e.options.legend[t],name:e.options.itemName[1]}):t===e.options.legend.length?e.options.legendTitleFormat.upper.format({max:e.options.legend[t-1],name:e.options.itemName[1]}):e.options.legendTitleFormat.inner.format({down:e.options.legend[t-1],up:e.options.legend[t],name:e.options.itemName[1]})})},positionSubDomainX:function(t){var e=this._domainType[this.options.subDomain].position.x(new Date(t));return e*this.options.cellSize+e*this.options.cellPadding},positionSubDomainY:function(t){var e=this._domainType[this.options.subDomain].position.y(new Date(t));return e*this.options.cellSize+e*this.options.cellPadding},getHighlightClassName:function(t){if(t=new Date(t),this.options.highlight.length>0)for(var e in this.options.highlight)if(this.options.highlight[e]instanceof Date&&this.dateIsEqual(this.options.highlight[e],t))return" highlight"+(this.isNow(this.options.highlight[e])?" now":"");return""},isNow:function(t){return this.dateIsEqual(t,new Date)},dateIsEqual:function(t,e){switch(this.options.subDomain){case"x_min":case"min":return t.getFullYear()===e.getFullYear()&&t.getMonth()===e.getMonth()&&t.getDate()===e.getDate()&&t.getHours()===e.getHours()&&t.getMinutes()===e.getMinutes();case"x_hour":case"hour":return t.getFullYear()===e.getFullYear()&&t.getMonth()===e.getMonth()&&t.getDate()===e.getDate()&&t.getHours()===e.getHours();case"x_day":case"day":return t.getFullYear()===e.getFullYear()&&t.getMonth()===e.getMonth()&&t.getDate()===e.getDate();case"x_week":case"week":case"x_month":case"month":return t.getFullYear()===e.getFullYear()&&t.getMonth()===e.getMonth();default:return!1}},getDayOfYear:d3.time.format("%j"),getWeekNumber:function(t){var e=this.options.weekStartOnMonday===!0?d3.time.format("%W"):d3.time.format("%U");return e(t)},getWeekDay:function(t){return this.options.weekStartOnMonday===!1?t.getDay():0===t.getDay()?6:t.getDay()-1},getEndOfMonth:function(t){return"number"==typeof t&&(t=new Date(t)),new Date(t.getFullYear(),t.getMonth()+1,0)},getWeekDomain:function(t,e){var n;this.options.weekStartOnMonday===!1?n=new Date(t.getFullYear(),t.getMonth(),t.getDate()-t.getDay()):1===t.getDay()?n=new Date(t.getFullYear(),t.getMonth(),t.getDate()):0===t.getDay()?(n=new Date(t.getFullYear(),t.getMonth(),t.getDate()),n.setDate(n.getDate()-6)):n=new Date(t.getFullYear(),t.getMonth(),t.getDate()-t.getDay()+1);var o=new Date(n),i=new Date(o.setDate(o.getDate()+7*e));return this.options.weekStartOnMonday===!0?d3.time.mondays(Math.min(n,i),Math.max(n,i)):d3.time.sundays(Math.min(n,i),Math.max(n,i))},getYearDomain:function(t,e){var n=new Date(t.getFullYear(),0),o=new Date(t.getFullYear()+e,0);return d3.time.years(Math.min(n,o),Math.max(n,o))},getMinuteDomain:function(t,e){var n=new Date(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours()),o=new Date(n.getTime()+6e4*e);return d3.time.minutes(Math.min(n,o),Math.max(n,o))},getHourDomain:function(t,e){var n=new Date(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours()),o=e;return"number"==typeof e&&(o=new Date(n.getTime()+36e5*e)),d3.time.hours(Math.min(n,o),Math.max(n,o))},getDayDomain:function(t,e){var n=new Date(t.getFullYear(),t.getMonth(),t.getDate()),o=new Date(n);return o=new Date(o.setDate(o.getDate()+parseInt(e,10))),d3.time.days(Math.min(n,o),Math.max(n,o))},getMonthDomain:function(t,e){var n=new Date(t.getFullYear(),t.getMonth()),o=new Date(n);return o=o.setMonth(o.getMonth()+e),d3.time.months(Math.min(n,o),Math.max(n,o))},getDomain:function(t,e){switch("number"==typeof t&&(t=new Date(t)),e===void 0&&(e=this.options.range),this.options.domain){case"hour":return this.getHourDomain(t,e);case"day":return this.getDayDomain(t,e);case"week":return this.getWeekDomain(t,e);case"month":return this.getMonthDomain(t,e);case"year":return this.getYearDomain(t,e)}},getSubDomain:function(t){"number"==typeof t&&(t=new Date(t));var e=this,n=function(t,n){switch(n){case"year":return e.getDayOfYear(new Date(t.getFullYear()+1,0,0));case"month":var o=new Date(t.getFullYear(),t.getMonth()+1,0);return o.getDate();case"week":return 7}},o=function(t,e){switch(e){case"hour":return 60;case"day":return 1440;case"week":return 10080}},i=function(t,e){switch(e){case"day":return 24;case"week":return 168;case"month":var n=new Date(t.getFullYear(),t.getMonth()+1,0);return 24*n.getDate()}},a=function(t,n){if("month"===n){var o=new Date(t.getFullYear(),t.getMonth()+1,0),i=e.getWeekNumber(o),a=e.getWeekNumber(new Date(t.getFullYear(),t.getMonth()));return a>i&&(a=0,i++),i-a+1}return"year"===n?e.getWeekNumber(new Date(t.getFullYear(),11,31)):void 0};switch(this.options.subDomain){case"x_min":case"min":return this.getMinuteDomain(t,o(t,this.options.domain));case"x_hour":case"hour":return this.getHourDomain(t,i(t,this.options.domain));case"x_day":case"day":return this.getDayDomain(t,n(t,this.options.domain));case"x_week":case"week":return this.getWeekDomain(t,a(t,this.options.domain));case"x_month":case"month":return this.getMonthDomain(t,12)}},getNextDomain:function(){return this.getDomain(parseInt(this._domains.keys().sort().pop(),10),2).pop()},getPreviousDomain:function(){return this.getDomain(parseInt(this._domains.keys().sort().shift(),10),-1)[0]},legend:function(t){if(isNaN(t))return"qi";if(null===t)return"";for(var e=0,n=this.options.legend.length-1;n>=e;e++){if(0===t&&this.options.legend[0]>0)return"";if(this.options.legend[0]>0&&0>t)return"qi";if(this.options.legend[e]>=t)return"q"+(e+1)}return"q"+(this.options.legend.length+1)},getDatas:function(t,e,n,o,i,a){var r=this;5>arguments.length&&(i=!0),6>arguments.length&&(a=this.APPEND_ON_UPDATE);var s=function(t){if(i!==!1)if("function"==typeof i)t=i(t);else{if("function"!=typeof r.options.afterLoadData)return console.log("Provided callback for afterLoadData is not a function."),{};t=r.options.afterLoadData(t)}r.parseDatas(t,a),o()};switch(typeof t){case"string":if(""===t)return s({}),!0;switch(this.options.dataType){case"json":d3.json(this.parseURI(t,e,n),s);break;case"csv":d3.csv(this.parseURI(t,e,n),s);break;case"tsv":d3.tsv(this.parseURI(t,e,n),s);break;case"text":d3.text(this.parseURI(t,e,n),"text/plain",s)}return!1;case"object":s(t)}return!0},parseDatas:function(t,e){e===this.RESET_ALL_ON_UPDATE&&this._domains.forEach(function(t,e){e.forEach(function(t,e,n){n[e].v=null})});var n=this._domains.keys(),o=this._domains.get(n[0])[1].t-this._domains.get(n[0])[0].t;for(var i in t){var a=new Date(1e3*i),r=this.getDomain(a)[0].getTime();if(this._domains.has(r)){var s=this._domainType[this.options.subDomain].extractUnit(a),l=this._domains.get(r),m=Math.floor((s-r)/o);e===this.RESET_SINGLE_ON_UPDATE?l[m].v=t[i]:isNaN(l[m].v)?l[m].v=t[i]:l[m].v+=t[i]}}},parseURI:function(t,e,n){return t=t.replace(/\{\{t:start\}\}/g,e.getTime()/1e3),t=t.replace(/\{\{t:end\}\}/g,n.getTime()/1e3),t=t.replace(/\{\{d:start\}\}/g,e.toISOString()),t=t.replace(/\{\{d:end\}\}/g,n.toISOString())},next:function(){return this.loadNextDomain()},previous:function(){return this.loadPreviousDomain()},update:function(t,e,n){2>arguments.length&&(e=!0),3>arguments.length&&(n=this.RESET_ALL_ON_UPDATE);var o=this._domains.keys().sort(),i=this;this.getDatas(t,new Date(parseInt(o[0],10)),this.getSubDomain(parseInt(o[o.length-1],10)).pop(),function(){i.fill()},e,n)},getSVG:function(){for(var t={".graph":{},".graph-rect":{},"rect.highlight":{},"rect.now":{},"text.highlight":{},"text.now":{},".domain-background":{},".graph-label":{},".subdomain-text":{},".qi":{}},e=0,n=this.options.legend.length;n>e;e++)t[".q"+e]={};var o=this.root,i=["stroke","stroke-width","stroke-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-miterlimit","fill","fill-opacity","fill-rule","marker","marker-start","marker-mid","marker-end","alignement-baseline","baseline-shift","dominant-baseline","glyph-orientation-horizontal","glyph-orientation-vertical","kerning","text-anchor","shape-rendering","text-transform","font-family","font","font-size","font-weight"],a=function(e,n,o){-1!==i.indexOf(n)&&(t[e][n]=o)},r=function(t){return o.select(t)[0][0]};for(var s in t){var l=r(s);if(null!==l)if("getComputedStyle"in window){var m=getComputedStyle(l,null);if(0!==m.length)for(var u=0;m.length>u;u++)a(s,m.item(u),m.getPropertyValue(m.item(u)));else for(var p in m)m.hasOwnProperty(p)&&a(s,p,m[p])}else if("currentStyle"in l){var h=l.currentStyle;for(var g in h)a(s,g,h[g])}}var c='<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><style type="text/css"><![CDATA[ ';for(var d in t){c+=d+" {\n";for(var f in t[d])c+="	"+f+":"+t[d][f]+";\n";c+="}\n"}return c+="]]></style>",c+=(new XMLSerializer).serializeToString(this.root.selectAll("svg")[0][0]),c+=(new XMLSerializer).serializeToString(this.root.selectAll("svg")[0][1]),c+="</svg>"}};var DomainPosition=function(){this.positions=d3.map()};DomainPosition.prototype.getPosition=function(t){return this.positions.get(t)},DomainPosition.prototype.getPositionFromIndex=function(t){var e=this.positions.keys().sort();return this.positions.get(e[t])},DomainPosition.prototype.getLast=function(){var t=this.positions.keys().sort();return this.positions.get(t[t.length-1])},DomainPosition.prototype.setPosition=function(t,e){this.positions.set(t,e)
},DomainPosition.prototype.shiftRightBy=function(t){this.positions.forEach(function(e,n){this.set(e,n-t)});var e=this.positions.keys().sort();this.positions.remove(e[0])},DomainPosition.prototype.shiftLeftBy=function(t){this.positions.forEach(function(e,n){this.set(e,n+t)});var e=this.positions.keys().sort();this.positions.remove(e[e.length-1])},String.prototype.format=function(){var t=this;for(var e in arguments[0]){var n=RegExp("\\{"+e+"\\}","gi");t=t.replace(n,arguments[0][e])}return t},"function"==typeof define&&define.amd&&define(["d3"],function(){return CalHeatMap});
//@ sourceMappingURL=cal-heatmap.source-map.js