/*
 ** Copyright(C) 2007 INL
 ** Written by Victor Stinner <victor.stinner@inl.fr>
 **
 ** $Id: nuthread.h 3057 2007-03-26 16:28:48Z haypo $
 **
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, version 2 of the License.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef NUTHREAD_H
#define NUTHREAD_H

struct nuauth_thread_t {
	int valid;
	GThread *thread;
	GMutex *mutex;
	const char *name;
};

void thread_new(struct nuauth_thread_t *thread,
		const char* name,
		void *(*func) (GMutex *));
void thread_stop(struct nuauth_thread_t *thread);
void thread_wait_end(struct nuauth_thread_t *thread);
void thread_destroy(struct nuauth_thread_t *thread);

#endif

