/* bcmxcp.h -- header for (BCM/XCP)  protocol module
 * 
 * Copyright (c) 2002, Martin Schroeder
 * emes -at- geomer.de
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Martin Schroeder nor the names of his contributors 
 *    may be used to endorse or promote products derived from this software 
 *    without specific prior written permission. 
 *
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */    

#ifndef _POWERWARE_H
#define _POWERWARE_H

#include <termios.h>


char *FreqTol[3] 	= {"+/-2%", "+/-5%", "+/-7"};
char *ABMStatus[4]	= {"Charging", "Discharging", "Floating", "Resting"};

#define PW_MAX_TRY  3	/* How often we try to get valid data from the ups in */
			/* case of a read error                               */


#define PW_MAX_BAUD 5
struct pw_baud_rate {
	int rate;
	int name;
} pw_baud_rates[] = {
	{ B1200,  1200 },
	{ B2400,  2400 },
	{ B4800,  4800 },
	{ B9600,  9600 },
	{ B19200, 19200 },
};
                            

#define PW_COMMAND_START_BYTE	0xAB

 
#define PW_SYSTEM_INFO1		0x31	/* Model name, ...                        */
#define PW_SYSTEM_MODE		0x33	/* On Line, On Bypass, ...                */
#define PW_SYSTEM_STATUS	0x34	/* Current UPS status (Load, utility,...) */
#define PW_SYSTEM_INFO2		0x36	/* Model serial#, ...                     */
#define PW_ABM_STATUS		0x3B	/* Charging, floating, ...                */
#define PW_SYSTEM_SETTINGS	0x3C	/* Configuration (Bypass thresholds,...)  */


#endif /* _POWERWARE_H */

