/*************************************************
**      To: main.cpp
** Project: nvclock
**  Author: Jan Prokop
**  e-mail: jprokop@ibl.sk
*************************************************/

/* for va_list.... */
#include <stdarg.h>
#include <stdlib.h>

#include <unistd.h>
#include <sys/types.h>

#include "qt_nvclock.h"

#include <qmessagebox.h>
#include <qapplication.h>

//***********************************************************************

int total_cards;

/*
    Since I don't know much c++, this is the code from plain nvclock ...
*/
void error(error_type code, const char *format, ...)
{
    va_list arg;
    va_start(arg, format);

    switch(code)
    {
	case ERROR:
	    fprintf(stderr, "Error: ");
	    vfprintf(stderr, format, arg);	
	    fprintf(stderr, "\n");	
	    exit(EXIT_SUCCESS);
	    break;
	case INFO:
	    fprintf(stderr, "Info: ");	
	    vfprintf(stderr, format, arg);	
	    fprintf(stderr, "\n");	
	    break;
	case WARNING:
	    fprintf(stderr, "Warning: ");	
	    vfprintf(stderr, format, arg);	
	    fprintf(stderr, "\n");	
	    break;
    }
    va_end(arg);
}

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    total_cards = FindAllCards();

    switch(total_cards)
    {
	/* If no cards found, exit. */
	case -1:
    	    QMessageBox::critical(0, QObject::tr("Error"),
                         QObject::tr("No nVidia card found in your system!"));
	    return(1);
	    break;
	case -2:
    	    QMessageBox::critical(0, QObject::tr("Error"),
                         QObject::tr("You don't have access to the registers of your nVidia card.\nRun this program as root or install and load the closed source nVidia drivers!"));
	    return(1);
	    break;
    }

    CNVclock nv(0, "nv");

    app.setMainWidget(&nv);
    nv.show();
    
    return(app.exec());
}
