c $Id: metadynamics.F 21890 2012-01-27 20:37:16Z bylaska $

c     **********************************************
c     *                                            *
c     *            meta_initialize                 *
c     *                                            *
c     **********************************************
      subroutine meta_initialize(rtdb)
      implicit none
      integer rtdb

#include "mafdecls.fh"
#include "rtdb.fh"
#include "errquit.fh"
#include "metadynamics.fh"

*     **** local variables ****
      integer taskid,MASTER
      parameter (MASTER=0)
      logical value,cnmeta_read
      integer d,i,j,n1,n2,s1,s2,yshift,ntype
      real*8 x,y,z,r,rmax,dr,pi,da,maxcoord,a,b,n,m,sigma,w,r0
      character*80 rtdb_name
      character*4 celement1,celement2

*     **** external functions ****
      real*8      lattice_unita
      character*7 c_index_name
      integer     control_it_out
      external    lattice_unita
      external    c_index_name
      external    control_it_out

      call Parallel_taskid(taskid)
      metaprintcount = 0
      rtdb_name = 'metadynamics_print'
      if (.not.rtdb_get(rtdb,rtdb_name,mt_int,1,maxmetaprintcount)) 
     >   maxmetaprintcount=100

      rtdb_name = 'metadynamics_nmeta'
      if (.not.rtdb_get(rtdb,rtdb_name,mt_int,1,nmeta)) nmeta = 0

      metafound = (nmeta.gt.0)

      if (metafound) then

         rtdb_name = 'metadynamics_update'
         if (.not.rtdb_get(rtdb,rtdb_name,mt_int,1,maxmetacount)) 
     >      maxmetacount = 1

         rtdb_name = 'metadynamics_metacount'
         if (.not.rtdb_get(rtdb,rtdb_name,mt_int,1,metacount)) 
     >      metacount = 0

         rtdb_name = 'metadynamics_print_shift'
         if (.not.rtdb_get(rtdb,rtdb_name,mt_int,1,metarayshift)) 
     >      metarayshift = 0

         rtdb_name = 'metadynamics_metaraycount'
         if (.not.rtdb_get(rtdb,rtdb_name,mt_int,1,metaraycount)) 
     >      metaraycount = 0

         rtdb_name = 'metadynamics_tempered'
         if (.not.rtdb_get(rtdb,rtdb_name,mt_dbl,1,dTtempered)) 
     >      dTtempered = -1.0d0

         value = .true.
         if (nmeta.gt.0) then
            rtdb_name = 'metadynamics_nindxmeta'
            if (.not.rtdb_get(rtdb,rtdb_name,mt_int,1,nindxmeta)) 
     >         nindxmeta = 0
            rtdb_name = 'metadynamics_nparammeta'
            if (.not.rtdb_get(rtdb,rtdb_name,mt_int,1,nparammeta)) 
     >         nparammeta = 0
            rtdb_name = 'metadynamics_nxmeta_all'
            if (.not.rtdb_get(rtdb,rtdb_name,mt_int,1,nxmeta_all)) 
     >         nxmeta_all = 0

*           **** allocate and read nxmeta,sindxmeta,sparameta,and indxmeta ****
            value = value.and.
     >              MA_alloc_get(mt_int,nmeta,'nxmeta',
     >                           nxmeta(2),nxmeta(1))
            value = value.and.
     >              MA_alloc_get(mt_int,nmeta,'sindxmeta',
     >                           sindxmeta(2),sindxmeta(1))
            value = value.and.
     >              MA_alloc_get(mt_int,nmeta,'sparammeta',
     >                           sparammeta(2),sparammeta(1))
            value = value.and.
     >              MA_alloc_get(mt_int,nindxmeta,'indxmeta',
     >                           indxmeta(2),indxmeta(1))

            rtdb_name = 'metadynamics_nxmeta'
            if (.not.rtdb_get(rtdb,rtdb_name,mt_int,nmeta,
     >                        int_mb(nxmeta(1)))) then
               do d=1,nmeta
                  int_mb(nxmeta(1)+d-1) = 0
               end do
            end if
            rtdb_name = 'metadynamics_sindxmeta'
            if (.not.rtdb_get(rtdb,rtdb_name,mt_int,nmeta,
     >                        int_mb(sindxmeta(1)))) then
               do d=1,nmeta
                  int_mb(sindxmeta(1)+d-1) = 0
               end do
            end if
            rtdb_name = 'metadynamics_sparammeta'
            if (.not.rtdb_get(rtdb,rtdb_name,mt_int,nmeta,
     >                        int_mb(sparammeta(1)))) then
               do d=1,nmeta
                  int_mb(sindxmeta(1)+d-1) = 0
               end do
            end if
            rtdb_name = 'metadynamics_indxmeta'
            if (.not.rtdb_get(rtdb,rtdb_name,mt_int,nindxmeta,
     >                        int_mb(indxmeta(1)))) then
               do d=1,nindxmeta
                  int_mb(indxmeta(1)+d-1) = 0
               end do
            end if


*           ***** allocate and read ameta,bmeta,parammeta, and ymeta ****
            value = value.and.
     >              MA_alloc_get(mt_dbl,nmeta,'ameta',ameta(2),ameta(1))
            value = value.and.
     >              MA_alloc_get(mt_dbl,nmeta,'bmeta',bmeta(2),bmeta(1))
            value = value.and.
     >              MA_alloc_get(mt_dbl,nparammeta,'parammeta',
     >                           parammeta(2),parammeta(1))
            value = value.and.
     >              MA_alloc_get(mt_dbl,nxmeta_all,
     >                           'ymeta',ymeta(2),ymeta(1))

            rtdb_name = 'metadynamics_ameta'
            if (.not.rtdb_get(rtdb,rtdb_name,mt_dbl,nmeta,
     >                        dbl_mb(ameta(1)))) then
               do d=1,nmeta
                  dbl_mb(ameta(1)+d-1) = 0.0d0
               end do
            end if
            rtdb_name = 'metadynamics_bmeta'
            if (.not.rtdb_get(rtdb,rtdb_name,mt_dbl,nmeta,
     >                        dbl_mb(bmeta(1)))) then
               do d=1,nmeta
                  dbl_mb(bmeta(1)+d-1) = 0.0d0
               end do
            end if
            rtdb_name = 'metadynamics_parammeta'
            if (.not.rtdb_get(rtdb,rtdb_name,mt_dbl,nparammeta,
     >                        dbl_mb(parammeta(1)))) then
               do d=1,nparammeta
                  dbl_mb(parammeta(1)+d-1) = 0.0d0
               end do
            end if

*           **** load old spline fits ****
            call dcopy(nxmeta_all,0.0d0,0,dbl_mb(ymeta(1)),1)
            rtdb_name = 'metadynamics_ymeta'
            if (.not.rtdb_get(rtdb,rtdb_name,mt_dbl,nxmeta_all,
     >                       dbl_mb(ymeta(1)))) then
               call dcopy(nxmeta_all,0.0d0,0,dbl_mb(ymeta(1)),1)
            else
               if (taskid.eq.MASTER) 
     >            write(*,*) "  ... reading bond metadynamics data"
            end if

*           **** set default limits ****
            x = lattice_unita(1,1)
            y = lattice_unita(2,1)
            z = lattice_unita(3,1)
            r = dsqrt(x*x+y*y+z*z)
            rmax = r
            x = lattice_unita(1,2)
            y = lattice_unita(2,2)
            z = lattice_unita(3,2)
            r = dsqrt(x*x+y*y+z*z)
            if (r.gt.rmax) rmax = r
            x = lattice_unita(1,3)
            y = lattice_unita(2,3)
            z = lattice_unita(3,3)
            r = dsqrt(x*x+y*y+z*z)
            if (r.gt.rmax) rmax = r
            do d=1,nmeta
               s1 = int_mb(sindxmeta(1) +d-1)
               if ((int_mb(indxmeta(1)+s1).eq.1).or.
     >             (int_mb(indxmeta(1)+s1).eq.5)) then
                  if (dbl_mb(ameta(1)+d-1).lt.0.0d0) 
     >               dbl_mb(ameta(1)+d-1) = 0.0d0
                  if (dbl_mb(bmeta(1)+d-1).lt.0.0d0)
     >               dbl_mb(bmeta(1)+d-1) = rmax
               end if
               if (int_mb(indxmeta(1)+s1).eq.2) then
                  if (dbl_mb(ameta(1)+d-1).lt.(-99.0d0))
     >               dbl_mb(ameta(1)+d-1) = 0.0d0
                  if (dbl_mb(bmeta(1)+d-1).lt.(-99.0d0))
     >               dbl_mb(bmeta(1)+d-1) = 4.0d0*datan(1.0d0)
               end if
            end do
         end if

         call nwpw_interp_init(nmeta,8)

         if (.not.value)
     >    call errquit('cannot allocate heap memory for metadynamics',0,
     >       MA_ERR)

*     **** write out header info ****
      call Parallel_taskid(taskid)
      if (taskid.eq.MASTER) then
         write(*,*) 
         write(*,*)  "MetaDynamics parameters:"
         if (dTtempered.gt.0.0d0) then
            write(*,'(A,5x,F11.6)') "   - Tempered dT (K) = ",dTtempered
         end if
         do d=1,nmeta
            s1 = int_mb(sindxmeta(1) +d-1)
            s2 = int_mb(sparammeta(1)+d-1)
            ntype = int_mb(indxmeta(1)+s1)
            w     = dbl_mb(parammeta(1)+s2)
            sigma = dbl_mb(parammeta(1)+s2+1)

            if (ntype.eq.1) then
             write(*,'(A,5x,2I4,
     >                /6x,A,F11.6,4x,A,F11.6,
     >                /6x,A,F11.6,F11.6,4x,A,I5)')
     >       "   - Bond Parameters =  ",
     >           (int_mb(indxmeta(1)+s1+j),j=1,2),
     >           'w=',w,'sigma=',sigma,
     >           'range=  ',dbl_mb(ameta(1)+d-1),dbl_mb(bmeta(1)+d-1),
     >           'nrange= ',int_mb(nxmeta(1)+d-1)

            else if (ntype.eq.2) then
             write(*,'(A,3I4,4x,A,F11.6,4x,A,F11.6,
     >                /6x,A,F11.6,F11.6,4x,A,I5)')
     >       "   - Angle Parameters =  ",
     >           (int_mb(indxmeta(1)+s1+j),j=1,3),
     >           'w=',w,'sigma=',sigma,
     >           'range=  ',dbl_mb(ameta(1)+d-1),dbl_mb(bmeta(1)+d-1),
     >           'nrange= ',int_mb(nxmeta(1)+d-1)

            else if (ntype.eq.4) then
             n1 = int_mb(indxmeta(1)+s1+1)
             n2 = int_mb(indxmeta(1)+s1+2)
             n  =  dbl_mb(parammeta(1)+s2+2)
             m  =  dbl_mb(parammeta(1)+s2+3)
             r0 =  dbl_mb(parammeta(1)+s2+4)
             write(*,1001) (int_mb(indxmeta(1)+s1+3+j-1),j=1,n1)
             write(*,1002) (int_mb(indxmeta(1)+s2+3+n1+j-1),j=1,n2)

             write(*,'(A,/6x,A,F11.6,4x,A,F11.6,
     >                   /6x,A,F11.6,4x,A,F11.6,
     >                   /6x,A,F11.6,
     >                   /6x,A,F11.6,F11.6,
     >                   /6x,A,I5)')
     >       "  - Coordination Number Parameters: ",
     >           'n= ',n,'m=       ',m,
     >           'w= ',w,'sigma=   ',sigma,
     >           'r0=',r0,
     >           'range=  ',dbl_mb(ameta(1)+d-1),dbl_mb(bmeta(1)+d-1),
     >           'ngrid=  ',int_mb(nxmeta(1)+d-1)
              if (dbl_mb(parammeta(1)+s2+5).lt.0) then
                 write(*,'(6x,A)') '- LJ function form'
              else
                 write(*,'(6x,A)') '- Sprik function form'
              end if

            else if (ntype.eq.5) then
             n1 = int_mb(indxmeta(1)+s1+2)
             write(*,1001) int_mb(indxmeta(1)+s1+1)
             write(*,1002) (int_mb(indxmeta(1)+s1+3+j-1),j=1,n1)
             write(*,'(A,5x,
     >                /6x,A,F11.6,F11.6,F11.6,
     >                /6x,A,F11.6,4x,A,F11.6,
     >                /6x,A,F11.6,F11.6,4x,A,I5)')
     >       "  - n-plane Parameters =  ",
     >           'normal=',
     >           dbl_mb(parammeta(1)+s2+2),
     >           dbl_mb(parammeta(1)+s2+3),
     >           dbl_mb(parammeta(1)+s2+4),
     >           'w=',w,'sigma=',sigma,
     >           'range=  ',dbl_mb(ameta(1)+d-1),dbl_mb(bmeta(1)+d-1),
     >           'nrange= ',int_mb(nxmeta(1)+d-1)
            else if (ntype.eq.6) then

             if (int_mb(indxmeta(1)+s1+1).eq.1) then
             write(*,'(A,5x,I4,
     >                /6x,A,F11.6,4x,A,F11.6,
     >                /6x,A,F11.6,F11.6,4x,A,I5)')
     >       "   - X Parameters =  ",
     >           int_mb(indxmeta(1)+s1+2),
     >           'w=',w,'sigma=',sigma,
     >           'range=  ',dbl_mb(ameta(1)+d-1),dbl_mb(bmeta(1)+d-1),
     >           'nrange= ',int_mb(nxmeta(1)+d-1)
             else if (int_mb(indxmeta(1)+s1+1).eq.2) then
             write(*,'(A,5x,I4,
     >                /6x,A,F11.6,4x,A,F11.6,
     >                /6x,A,F11.6,F11.6,4x,A,I5)')
     >       "   - Y Parameters =  ",
     >           int_mb(indxmeta(1)+s1+2),
     >           'w=',w,'sigma=',sigma,
     >           'range=  ',dbl_mb(ameta(1)+d-1),dbl_mb(bmeta(1)+d-1),
     >           'nrange= ',int_mb(nxmeta(1)+d-1)
             else 
             write(*,'(A,5x,I4,
     >                /6x,A,F11.6,4x,A,F11.6,
     >                /6x,A,F11.6,F11.6,4x,A,I5)')
     >       "   - Z Parameters =  ",
     >           int_mb(indxmeta(1)+s1+2),
     >           'w=',w,'sigma=',sigma,
     >           'range=  ',dbl_mb(ameta(1)+d-1),dbl_mb(bmeta(1)+d-1),
     >           'nrange= ',int_mb(nxmeta(1)+d-1)
             end if

            end if

         end do

 1001 FORMAT(2x,"- Coorination Number (Index1) :",10I5)
 1002 FORMAT(2x,"- Coorination Number (Index2) :",10I5)

      end if
      
      end if
      return
      end

c     **********************************************
c     *                                            *
c     *            meta_finalize                   *
c     *                                            *
c     **********************************************
      subroutine meta_finalize(rtdb)
      implicit none
      integer rtdb

#include "mafdecls.fh"
#include "rtdb.fh"
#include "errquit.fh"
#include "metadynamics.fh"

*     **** local variables ****
      integer taskid,MASTER
      parameter (MASTER=0)

      logical value
      integer i,j,yshift,k
      real*8 r
      character*80 filename,rtdb_name
      character*255 full_filename

*     **** external functions ****
      character*7 c_index_name
      external    c_index_name

      call Parallel_taskid(taskid)

      if (metafound) then

*        **** print out potentials ******
         !metaraycount = metaraycount + metarayshift
         call meta_print_potentials(0)

         value=.true.
         rtdb_name='metadynamics_metacount'
         value= value.and.rtdb_put(rtdb,rtdb_name,mt_int,1,metacount)
         rtdb_name='metadynamics_metaraycount'
         value= value.and.rtdb_put(rtdb,rtdb_name,mt_int,1,metaraycount)

         if (nmeta.gt.0) then

*           **** write out current spline fits ****
            rtdb_name = 'metadynamics_ymeta'
            value = value.and.rtdb_put(rtdb,rtdb_name,mt_dbl,
     >                        nxmeta_all,dbl_mb(ymeta(1)))

            value = value.and.MA_free_heap(ameta(2))
            value = value.and.MA_free_heap(bmeta(2))
            value = value.and.MA_free_heap(nxmeta(2))
            value = value.and.MA_free_heap(indxmeta(2))
            value = value.and.MA_free_heap(parammeta(2))
            value = value.and.MA_free_heap(sindxmeta(2))
            value = value.and.MA_free_heap(sparammeta(2))
            value = value.and.MA_free_heap(ymeta(2))
            call nwpw_interp_end()

         end if

      end if

      return
      end


c     **********************************************
c     *                                            *
c     *            meta_collective                 *
c     *                                            *
c     **********************************************
      real*8 function meta_collective(indx,param)
      implicit none
      integer indx(*)
      real*8  param(*)

*     **** local variables ****
      integer i,j,ntype,n1,n2
      real*8 x1,y1,z1,x2,y2,z2,x3,y3,z3,dx,dy,dz,r,r1,r3
      real*8 dx1,dy1,dz1,dx3,dy3,dz3,theta,n,m,r0,f
      real*8 nx,ny,nz

*     **** external functions ****
      real*8   ion_rion
      external ion_rion

      ntype = indx(1)

      f = 0.0d0
c     **** bond distance ***
      if (ntype.eq.1) then
         x1 = ion_rion(1,indx(2))
         y1 = ion_rion(2,indx(2))
         z1 = ion_rion(3,indx(2))
         x2 = ion_rion(1,indx(3))
         y2 = ion_rion(2,indx(3))
         z2 = ion_rion(3,indx(3))
         dx = x1-x2
         dy = y1-y2
         dz = z1-z2
         call lattice_min_difference(dx,dy,dz)
         r  = dsqrt(dx**2 + dy**2 + dz**2)
         f  = r

c     **** bond angle ***
      else if (ntype.eq.2) then
         x1 = ion_rion(1,indx(2))
         y1 = ion_rion(2,indx(2))
         z1 = ion_rion(3,indx(2))
         x2 = ion_rion(1,indx(3))
         y2 = ion_rion(2,indx(3))
         z2 = ion_rion(3,indx(3))
         x3 = ion_rion(1,indx(4))
         y3 = ion_rion(2,indx(4))
         z3 = ion_rion(3,indx(4))
         dx1 = x1-x2
         dy1 = y1-y2
         dz1 = z1-z2
         call lattice_min_difference(dx1,dy1,dz1)
         r1  = dsqrt(dx1**2 + dy1**2 + dz1**2)
         dx3 = x3-x2
         dy3 = y3-y2
         dz3 = z3-z2
         call lattice_min_difference(dx3,dy3,dz3)
         r3  = dsqrt(dx3**2 + dy3**2 + dz3**2)
         theta = (dx1*dx3 + dy1*dy3 + dz1*dz3)/(r1*r3)
         if (theta.gt.1.0d0)  theta = 1.0d0
         if (theta.lt.-1.0d0) theta = -1.0d0
         theta = dacos(theta)
         f = theta

c     **** bond dihedral ****

c     **** coordination number ****
      else if (ntype.eq.4) then
         n1=indx(2)
         n2=indx(3)
         if (param(6).lt.0.0d0) then
            f = 0.0d0
            n  = param(3)
            m  = param(4)
            r0 = param(5)
            do i=1,n1
               do j=1,n2
                  x1 = ion_rion(1,indx(3+i))
                  y1 = ion_rion(2,indx(3+i))
                  z1 = ion_rion(3,indx(3+i))
                  x2 = ion_rion(1,indx(3+n1+j))
                  y2 = ion_rion(2,indx(3+n1+j))
                  z2 = ion_rion(3,indx(3+n1+j))
                  dx1 = x1-x2
                  dy1 = y1-y2
                  dz1 = z1-z2
                  call lattice_min_difference(dx1,dy1,dz1)
                  r1  = dsqrt(dx1**2 + dy1**2 + dz1**2)
                  f = f + (1.0d0-(r1/r0)**n)/(1.0d0-(r1/r0)**m)
               end do
            end do
         else
            f = 0.0d0
            n  = param(3)
            m  = param(4)
            r0 = param(5)
            do i=1,n1
               do j=1,n2
                  x1 = ion_rion(1,indx(3+i))
                  y1 = ion_rion(2,indx(3+i))
                  z1 = ion_rion(3,indx(3+i))
                  x2 = ion_rion(1,indx(3+n1+j))
                  y2 = ion_rion(2,indx(3+n1+j))
                  z2 = ion_rion(3,indx(3+n1+j))
                  dx1 = x1-x2
                  dy1 = y1-y2
                  dz1 = z1-z2
                  call lattice_min_difference(dx1,dy1,dz1)
                  r1  = dsqrt(dx1**2 + dy1**2 + dz1**2)
c                 f = f + (1.0d0-(r1/r0)**n)/(1.0d0-(r1/r0)**m)
                  f = f + 1.d0/(1.d0+dexp(n*(r1-r0)))
               end do
            end do
         end if

c     **** n-plane ****
      else if (ntype.eq.5) then
         f = 0.0d0
         nx = param(3)
         ny = param(4)
         nz = param(5)
         x1 = ion_rion(1,indx(2))
         y1 = ion_rion(2,indx(2))
         z1 = ion_rion(3,indx(2))
         n1=indx(3)
         do i=1,n1
            x2 = ion_rion(1,indx(3+i))
            y2 = ion_rion(2,indx(3+i))
            z2 = ion_rion(3,indx(3+i))
            dx = x1-x2
            dy = y1-y2
            dz = z1-z2
            call lattice_min_difference(dx,dy,dz)
            r =  nx*dx + ny*dy + nz*dz
            f = f + dsqrt(r*r)
         end do
         f = f/dble(n1)

*     **** x,y,z ****
      else if (ntype.eq.6) then
         if (indx(2).eq.1)  then
            f = ion_rion(1,indx(3))
         else if (indx(2).eq.1)  then
            f = ion_rion(2,indx(3))
         else
            f = ion_rion(3,indx(3))
         end if
      end if

      meta_collective = f
      return
      end

c     **********************************************
c     *                                            *
c     *           meta_collective_force            *
c     *                                            *
c     **********************************************
      subroutine meta_collective_force(indx,param,dv,fmeta)
      implicit none
      integer indx(*)
      real*8 param(*),dv,fmeta(3,*)

*     **** local variables ****
      integer i,j,ntype,n1,n2
      real*8 x1,y1,z1,r1,vx1,vx2,vy1,vy2,vz1,vz2
      real*8 x2,y2,z2,aa,a11,a12,a22,r,df,n,m,r0,rn,rm
      real*8 x3,y3,z3,r3,ctheta,stheta,denom
      real*8 dx,dy,dz,dx1,dy1,dz1,dx3,dy3,dz3,nx,ny,nz

*     **** external functions ****
      real*8   ion_rion
      external ion_rion

      ntype = indx(1)

c     **** bond distance ***
      if (ntype.eq.1) then
         x1 = ion_rion(1,indx(2))
         y1 = ion_rion(2,indx(2))
         z1 = ion_rion(3,indx(2))
         x2 = ion_rion(1,indx(3))
         y2 = ion_rion(2,indx(3))
         z2 = ion_rion(3,indx(3))
         dx = x1-x2
         dy = y1-y2
         dz = z1-z2
         call lattice_min_difference(dx,dy,dz)
         r  = dsqrt(dx**2 + dy**2 + dz**2)

         fmeta(1,indx(2)) = fmeta(1,indx(2)) - (dx/r)*dv
         fmeta(2,indx(2)) = fmeta(2,indx(2)) - (dy/r)*dv
         fmeta(3,indx(2)) = fmeta(3,indx(2)) - (dz/r)*dv
         fmeta(1,indx(3)) = fmeta(1,indx(3)) + (dx/r)*dv
         fmeta(2,indx(3)) = fmeta(2,indx(3)) + (dy/r)*dv
         fmeta(3,indx(3)) = fmeta(3,indx(3)) + (dz/r)*dv

c     **** bond angle ***
      else if (ntype.eq.2) then
         x1 = ion_rion(1,indx(2))
         y1 = ion_rion(2,indx(2))
         z1 = ion_rion(3,indx(2))
         x2 = ion_rion(1,indx(3))
         y2 = ion_rion(2,indx(3))
         z2 = ion_rion(3,indx(3))
         x3 = ion_rion(1,indx(4))
         y3 = ion_rion(2,indx(4))
         z3 = ion_rion(3,indx(4))
         dx1 = x1-x2
         dy1 = y1-y2
         dz1 = z1-z2
         call lattice_min_difference(dx1,dy1,dz1)
         r1  = dsqrt(dx1**2 + dy1**2 + dz1**2)
         dx3 = x3-x2
         dy3 = y3-y2
         dz3 = z3-z2
         call lattice_min_difference(dx3,dy3,dz3)
         r3  = dsqrt(dx3**2 + dy3**2 + dz3**2)
         denom = r1*r3
         if (denom.gt.1.0d-11) then
            ctheta = (dx1*dx3 + dy1*dy3 + dz1*dz3)/(denom)
            if (ctheta.gt.1.0d0)  ctheta =  1.0d0
            if (ctheta.lt.-1.0d0) ctheta = -1.0d0
            stheta = dsqrt(1.0d0-ctheta*ctheta)
            if (stheta.lt.0.001d0) stheta = 0.001d0
            stheta = 1.0d0/stheta

            aa  =  dv*stheta
            a11 =  aa*ctheta/r1
            a12 = -aa/(denom)
            a22 =  aa*ctheta/r3

            vx1 = a11*dx1 + a12*dx3
            vx2 = a22*dx3 + a12*dx1

            vy1 = a11*dy1 + a12*dy3
            vy2 = a22*dy3 + a12*dy1

            vz1 = a11*dz1 + a12*dz3
            vz2 = a22*dz3 + a12*dz1

            fmeta(1,indx(2)) = fmeta(1,indx(2)) - vx1
            fmeta(2,indx(2)) = fmeta(2,indx(2)) - vy1
            fmeta(3,indx(2)) = fmeta(3,indx(2)) - vz1

            fmeta(1,indx(3)) = fmeta(1,indx(3)) + vx1 + vx2
            fmeta(2,indx(3)) = fmeta(2,indx(3)) + vy1 + vy2
            fmeta(3,indx(3)) = fmeta(3,indx(3)) + vz1 + vz2

            fmeta(1,indx(4)) = fmeta(1,indx(4)) - vx2
            fmeta(2,indx(4)) = fmeta(2,indx(4)) - vy2
            fmeta(3,indx(4)) = fmeta(3,indx(4)) - vz2
         end if

c     **** bond dihedral ****


c     **** coordination number ***
      else if (ntype.eq.4) then
         n1 = indx(2)
         n2 = indx(3)
         if (param(6).lt.0.0d0) then
            n  = param(3)
            m  = param(4)
            r0 = param(5)
            do i=1,n1
               do j=1,n2
                  x1 = ion_rion(1,indx(3+i))
                  y1 = ion_rion(2,indx(3+i))
                  z1 = ion_rion(3,indx(3+i))
                  x2 = ion_rion(1,indx(3+n1+j))
                  y2 = ion_rion(2,indx(3+n1+j))
                  z2 = ion_rion(3,indx(3+n1+j))
                  dx = x1-x2
                  dy = y1-y2
                  dz = z1-z2
                  call lattice_min_difference(dx,dy,dz)
                  r  = dsqrt(dx**2 + dy**2 + dz**2)
                  rn  = (1.0d0-(r/r0)**n)
                  rm  = (1.0d0-(r/r0)**m)
                  df = (-n*rm/r0*(r/r0)**(n-1) + m*rn/r0*(r/r0)**(m-1))
     >                 / (rm**2)
                  fmeta(1,indx(3+i)) = fmeta(1,indx(3+i)) - (dx/r)*df*dv
                  fmeta(2,indx(3+i)) = fmeta(2,indx(3+i)) - (dy/r)*df*dv
                  fmeta(3,indx(3+i)) = fmeta(3,indx(3+i)) - (dz/r)*df*dv
                  fmeta(1,indx(3+n1+j)) = fmeta(1,indx(3+n1+j)) 
     >                                  + (dx/r)*df*dv
                  fmeta(2,indx(3+n1+j)) = fmeta(2,indx(3+n1+j)) 
     >                                  + (dy/r)*df*dv
                  fmeta(3,indx(3+n1+j)) = fmeta(3,indx(3+n1+j)) 
     >                                  + (dz/r)*df*dv
               end do
            end do
         else
            n  = param(3)
            m  = param(4)
            r0 = param(5)
            do i=1,n1
               do j=1,n2
                  x1 = ion_rion(1,indx(3+i))
                  y1 = ion_rion(2,indx(3+i))
                  z1 = ion_rion(3,indx(3+i))
                  x2 = ion_rion(1,indx(3+n1+j))
                  y2 = ion_rion(2,indx(3+n1+j))
                  z2 = ion_rion(3,indx(3+n1+j))
                  dx = x1-x2
                  dy = y1-y2
                  dz = z1-z2
                  call lattice_min_difference(dx,dy,dz)
                  r  = dsqrt(dx**2 + dy**2 + dz**2)
c                 rn  = (1.0d0-(r/r0)**n)
c                 rm  = (1.0d0-(r/r0)**m)
c                 df = (-n*rm/r0*(r/r0)**(n-1) + m*rn/r0*(r/r0)**(m-1))
c    >                 / (rm**2)
                  rn  = 1.d0+dexp(n*(r-r0))
                  df = -n*(rn-1.d0)/(rn*rn)
                  fmeta(1,indx(3+i)) = fmeta(1,indx(3+i)) - (dx/r)*df*dv
                  fmeta(2,indx(3+i)) = fmeta(2,indx(3+i)) - (dy/r)*df*dv
                  fmeta(3,indx(3+i)) = fmeta(3,indx(3+i)) - (dz/r)*df*dv
                  fmeta(1,indx(3+n1+j)) = fmeta(1,indx(3+n1+j)) 
     >                                  + (dx/r)*df*dv
                  fmeta(2,indx(3+n1+j)) = fmeta(2,indx(3+n1+j)) 
     >                                  + (dy/r)*df*dv
                  fmeta(3,indx(3+n1+j)) = fmeta(3,indx(3+n1+j)) 
     >                                  + (dz/r)*df*dv
               end do
            end do
         endif

c     **** n-plane ****
      else if (ntype.eq.5) then
         nx = param(3)
         ny = param(4)
         nz = param(5)
         x1 = ion_rion(1,indx(2))
         y1 = ion_rion(2,indx(2))
         z1 = ion_rion(3,indx(2))
         n1=indx(3)
         do i=1,n1
            x2 = ion_rion(1,indx(3+i))
            y2 = ion_rion(2,indx(3+i))
            z2 = ion_rion(3,indx(3+i))
            dx = x1-x2
            dy = y1-y2
            dz = z1-z2
            call lattice_min_difference(dx,dy,dz)
            r =  nx*dx + ny*dy + nz*dz
            r0 =  dsqrt(r*r)
            df = (r/r0)*dv/dble(n1)
            fmeta(1,indx(2)) = fmeta(1,indx(2)) - nx*df
            fmeta(2,indx(2)) = fmeta(2,indx(2)) - ny*df
            fmeta(3,indx(2)) = fmeta(3,indx(2)) - nz*df

            fmeta(1,indx(3+i)) = fmeta(1,indx(3+i)) + nx*df
            fmeta(2,indx(3+i)) = fmeta(2,indx(3+i)) + ny*df
            fmeta(3,indx(3+i)) = fmeta(3,indx(3+i)) + nz*df
         end do

*     **** x,y,z ****
      else if (ntype.eq.6) then
         if (indx(2).eq.1)  then
            fmeta(1,indx(3)) = fmeta(1,indx(3)) - dv
         else if (indx(2).eq.1)  then
            fmeta(2,indx(3)) = fmeta(2,indx(3)) - dv
         else
            fmeta(3,indx(3)) = fmeta(3,indx(3)) - dv
         end if
      end if

      return
      end



*     ***********************************************
*     *                                             *
*     *              meta_update                    *
*     *                                             *
*     ***********************************************
      subroutine meta_update()
      implicit none

#include "mafdecls.fh"
#include "errquit.fh"
#include "metadynamics.fh"

*     **** local variables ****
      double precision kb
      parameter (kb=3.16679d-6)

      integer d,i,j(10),s1,s2
      real*8  r0,r,x,w,ww,sigma,v,expv

*     **** external functions ****
      real*8   meta_collective,meta_energy
      external meta_collective,meta_energy

      if (metafound) then

         metacount = metacount + 1
         if (metacount.ge.maxmetacount) then
         metacount = 0

         if (dTtempered.gt.0.0d0) then
            v    = meta_energy()
            expv = dexp(-v/(kb*dTtempered))
         else
            v    = 0.0d0
            expv = 1.0d0
         end if

         if (nmeta.gt.0) then
            w = 1.0d0
            do d=1,nmeta
               s2 =   int_mb(sparammeta(1)+d-1)
               w  = w*dbl_mb(parammeta(1)+s2)
               j(d) = 0
            end do
            w = w**(1.0d0/dble(nmeta))
           
            do i=1,nxmeta_all
               ww = 1.0d0
               do d=1,nmeta
                  s1 = int_mb(sindxmeta(1) +d-1)
                  s2 = int_mb(sparammeta(1)+d-1)
                  r0    = meta_collective(int_mb(indxmeta(1)+s1),
     >                                    dbl_mb(parammeta(1)+s2))
                  sigma = dbl_mb(parammeta(1)+s2+1)
                  x = dbl_mb(ameta(1)+d-1) 
     >              + j(d)*(dbl_mb(bmeta(1)+d-1)-dbl_mb(ameta(1)+d-1))
     >                    /dble(int_mb(nxmeta(1)+d-1)-1)
                  r = x-r0
                  ww = ww * dexp(-0.5d0*(r/sigma)**2)
               end do
            
               dbl_mb(ymeta(1)+i-1) = dbl_mb(ymeta(1)+i-1) + ww*w*expv

               j(1) = j(1) + 1
               do d=1,nmeta-1
                  if (j(d).ge.int_mb(nxmeta(1)+d-1)) then
                     j(d) = 0
                     j(d+1) = j(d+1)+1
                  end if
               end do
            end do
         end if

         end if

         metaprintcount = metaprintcount + 1
         if (metaprintcount.ge.maxmetaprintcount) then
            metaprintcount = 0
            metaraycount   = metaraycount + metarayshift
            call meta_print_potentials(metaraycount)
         end if

      end if
 
      return
      end

*     ***********************************************
*     *                                             *
*     *              meta_force                     *
*     *                                             *
*     ***********************************************
      subroutine meta_force(fmeta)
      implicit none
      real*8 fmeta(3,*)

#include "mafdecls.fh"
#include "errquit.fh"
#include "metadynamics.fh"

*     **** local variables ****
      integer d,s1,s2
      real*8 r(10),dv(10)

*     **** external functions ****
      real*8   meta_collective
      external meta_collective
      
      if (metafound) then

         if (nmeta.gt.0) then
            do d=1,nmeta
               s1 = int_mb(sindxmeta(1) +d-1)
               s2 = int_mb(sparammeta(1)+d-1)
               r(d) = meta_collective(int_mb(indxmeta(1)+s1),
     >                                dbl_mb(parammeta(1)+s2))
            end do

            call nwpw_dinterp(nmeta,int_mb(nxmeta(1)),
     >                        dbl_mb(ameta(1)),dbl_mb(bmeta(1)),
     >                        dbl_mb(ymeta(1)),r,dv)

            do d=1,nmeta
               s1 = int_mb(sindxmeta(1) +d-1)
               s2 = int_mb(sparammeta(1)+d-1)
               call meta_collective_force(int_mb(indxmeta(1) +s1),
     >                                    dbl_mb(parammeta(1)+s2),
     >                                    dv(d),fmeta)
            end do
         end if

      end if

      return
      end


*     ***********************************************
*     *                                             *
*     *              meta_energy                    *
*     *                                             *
*     ***********************************************
      real*8 function meta_energy()
      implicit none

#include "mafdecls.fh"
#include "errquit.fh"
#include "metadynamics.fh"

*     **** local variables ****
      integer d,s1,s2
      real*8 r(10),v

*     **** external functions ****
      real*8   nwpw_interp,meta_collective
      external nwpw_interp,meta_collective

      v = 0.0d0
      if (metafound) then

         if (nmeta.gt.0) then
            do d=1,nmeta
               s1 = int_mb(sindxmeta(1) +d-1)
               s2 = int_mb(sparammeta(1)+d-1)
               r(d) = meta_collective(int_mb(indxmeta(1)+s1),
     >                                dbl_mb(parammeta(1)+s2))
            end do
            v = nwpw_interp(nmeta,int_mb(nxmeta(1)),
     >                      dbl_mb(ameta(1)),dbl_mb(bmeta(1)),
     >                      dbl_mb(ymeta(1)),r)

         end if

      end if

      meta_energy = v 
      return
      end

*     ***********************************************
*     *                                             *
*     *              meta_found                     *
*     *                                             *
*     ***********************************************
      logical function meta_found()
      implicit none

#include "metadynamics.fh"

      meta_found = metafound
      return
      end


c     **********************************************
c     *                                            *
c     *            meta_print_potentials           *
c     *                                            *
c     **********************************************
      subroutine meta_print_potentials(icount)
      implicit none
      integer icount

#include "mafdecls.fh"
#include "errquit.fh"
#include "metadynamics.fh"

*     **** local variables ****
      integer taskid,MASTER
      parameter (MASTER=0)

      integer d,i,j(10)
      real*8  x(10),r,v,dv(10),fac,temp
      character*80 filename
      character*255 full_filename

*     **** external functions ****
      logical  control_Nose
      external control_Nose
      character*7 c_index_name
      external    c_index_name
      real*8   nwpw_interp,control_Nose_Tr,ion_Temperature
      external nwpw_interp,control_Nose_Tr,ion_Temperature

      call Parallel_taskid(taskid)

      if (metafound) then

*        **** determine tempered metadynamics factor ****
         fac = 1.0d0
         if (dTtempered.gt.0.0d0) then
            if (control_Nose()) then
               temp = control_Nose_Tr()
            else
               temp = ion_Temperature()
            end if
            fac = (temp+dTtempered)/dTtempered
         end if


*        **** print out potentials ******
         if (nmeta.gt.0) then
            if (taskid.eq.MASTER) then
               if (icount.gt.0) then
                  filename = "meta"//c_index_name(icount)//".dat"
               else
                  filename = "meta"//".dat"
               end if

               call util_file_name_noprefix(filename,.false.,
     >                                      .false.,
     >                                      full_filename)
               open(unit=53,file=full_filename,form='formatted')

               do d=1,nmeta
                  j(d) = 0
               end do
               do i=1,nxmeta_all
                  do d=1,nmeta
                     x(d) = dbl_mb(ameta(1)+d-1)
     >                + j(d)*(dbl_mb(bmeta(1)+d-1)-dbl_mb(ameta(1)+d-1))
     >                      /dble(int_mb(nxmeta(1)+d-1)-1)
                  end do
                  write(53,'(12F15.6)') 
     >                 (x(d),d=1,nmeta),dbl_mb(ymeta(1)+i-1)*fac

                  j(1) = j(1) + 1

                  if (j(1).ge.int_mb(nxmeta(1))) then
                     write(53,*)
                  end if

                  do d=1,nmeta-1
                     if (j(d).ge.int_mb(nxmeta(1)+d-1)) then
                        j(d) = 0
                        j(d+1) = j(d+1)+1
                     end if
                  end do
               end do

               close(53)
               
            end if
         end if

      end if

      return
      end
