c
c ---------------------------------------------------------------------
c computes the xyz coords along the imode normal mode
c ---------------------------------------------------------------------
c
      subroutine raman_modestep(rtdb,nat3,natom,geom,rmmodes,imode,
     &    iii,first,eigenvecs,eigenvals,ncoords,rminfo,step_size)
c
      implicit none
c
#include "errquit.fh"
#include "rtdb.fh"
#include "mafdecls.fh"
#include "stdio.fh"
#include "geom.fh"
#include "nwc_const.fh"
#include "inp.fh"
#include "global.fh"
#include "bas.fh"
c
      integer iii ! step number which determines sign 
      integer imode ! mode cordinates are dipsplaced along
      integer iatom, ixyz, ivec ! counting index
      integer geom    ! [input] geom handle
      integer rtdb    ! [input] rtdb handle
      integer natom   ! [input] number of atoms
      integer nat3    ! [input] 3*number of atoms
      integer first   ! first mode to consider in aoresponse (default =7 ramana =1 hyperraman)
      integer tmpmode ! set to fill rminfo from 1 ( not 7 for raman calc)
      integer rmmodes ! # of raman active modes
c
      double precision rminfo(rmmodes,4) ! data for raman spec
      double precision step_size ! multiplictive factor for step along normal mode
      double precision sign,bohr2ang ! sign of the step , unit conversion
      double precision eigenvecs(nat3,nat3) ! [input](xyz&atom,mode)
      double precision eigenvals(nat3)      ! [input] (mode)
      double precision ncoords(3,natom)    ! [scratch] coords after step
      double precision steps(3,natom)     ! [scratch] step generated by vector and scaled
c
      parameter (bohr2ang=0.52917724924D+00) ! CONVERSION OF BOHR to ANGSTROMS
c -------------determine sign of the step---------------------------------
      if (iii.eq.1) then
        sign = 1.0D+00
      else
        sign = -1.0D+00
      endif
c  --- save imode values in rminfo  ---
      tmpmode=imode-first+1
      rminfo(tmpmode,1) = eigenvals(imode)
c --------------------------------------------------------------------
        ivec = 1
        do iatom = 1,natom
          do ixyz = 1,3
      steps(ixyz,iatom)=sign*step_size*eigenvecs(ivec,imode)
            ivec = ivec + 1
          enddo ! ixyz
        enddo ! iatom
c
      call daxpy(nat3,1.0d00,steps,1,ncoords,1) ! mult coords 
      if (.not. geom_cart_coords_set(geom,ncoords))
     $     call errquit('raman_modestep: bad geom',0, GEOM_ERR)
c
      return
      end
c
c --------------------------------------------------------------------
c    Finite differencing for Raman Scattering Calculations
c --------------------------------------------------------------------
c
      subroutine fd_raman(rtdb,imode,rmmodes,natom,nat3,alfarex2,
     &           alfarimx2,step_size,rminfo,eigenvecs,mass)
c
      implicit none
c
#include "errquit.fh"
#include "global.fh"
#include "mafdecls.fh"
#include "stdio.fh"
#include "rtdb.fh"
#include "util.fh"
c
      logical debug
c
      integer rmmodes !  # modes used in raman calculation (3N-6)
      integer  i,j,m,ii,jj,mm,ivec  ! counting indexes
      integer rtdb    ! [input] rtdb handle
      integer imode   ! mode #
      integer natom   ! [input] number of atoms
      integer nat3    ! [input] 3*number of atoms
c
      double precision rminfo(rmmodes,4) ! raman data
      double precision step_size,stepsize ! [input] step of finite differencing
c      double precision laser(nfreq) ! [input] frequency used in AORESPONSE 
      double precision eigenvecs(nat3,nat3) ! [input](xyz&atom,mode)
      double precision tmode(3,natom) ! [input](atom#,xyz)
      double precision mass(natom) ! [input](atom#)
      double precision norm ! constant
      double precision fdipol(3,3), fdrpol(3,3) ! finite difference 
      double precision alfarex2(6,3), alfarimx2(6,3) ! AORESPONSE date for plus and minus step
      double precision ar2, ai2, gr2, gi2 ! alpha and g for imode
      double precision zero, one, two, three, six, seven,
     &                  fourty_five, bohr2ang
      parameter (zero=0.0D+00, one=1.0D+00, two=2.0D+00, three=3.0D+00,
     &            six=6.0D+00, seven=7.0D+00, fourty_five=45.0D+00)
      parameter (bohr2ang=0.52917724924D+00) ! CONVERSION OF BOHR to ANGSTROMS
c
      debug =  ( .false. .and. ga_nodeid().eq.0 )
c --------------------------------------------------------------------  
      call dfill(9,0.0D+00,fdrpol,1)  ! real fdipole polariability for 
      call dfill(9,0.0D+00,fdipol,1) ! imaginary fdipole polariability for
      call dfill(3*natom,0.0D+00,tmode,1) ! 
c zero
      stepsize = zero
      m = imode - 6 
      j=1
      i=1
      ar2   = zero ! alpha real
      gr2   = zero ! gradient real
      ai2   = zero ! alpha imaginaruy
      gi2   = zero ! gradient imaginary
      MM=3
c -----------mass weight the normal coordinates--------------------------------
       norm= 0.0D+00
       ivec = 1
      do i=1,natom
       do j=1,3
         tmode(j,i) = eigenvecs(ivec,imode)*sqrt(mass(i))
          ivec = ivec + 1
       end do
      end do
c ---calculate the norm of the qmass---
      do i=1,natom
         norm = norm + tmode(1,i)*tmode(1,i) + 
     *    tmode(2,i)*tmode(2,i) + tmode(3,i)*tmode(3,i)
      end do
      norm = sqrt(norm)
c --- normalize ---
      do i=1,natom
       do j=1,3
         tmode(j,i)= tmode(j,i)/norm
       end do
      end do
c
      do i=1,natom
       do j=1,3
         tmode(j,i) = tmode(j,i)/sqrt(mass(i))
       end do
      end do
c
      norm = zero
      do i=1,natom
         norm = norm + tmode(1,i)*tmode(1,i) + tmode(2,i)*tmode(2,i)
     *          + tmode(3,i)*tmode(3,i)
      end do
c --- calculate stepsize --- 
      stepsize = step_size/sqrt(norm)
c
      if (ga_nodeid().eq.0)  write(luout,*) 'Stepsize :',stepsize
c --------------------------------------------------------------------
      j=1
      i=1
      DO ii=1,3
       DO jj=1,3
c       difference polaraizability (real)
      fdrpol(ii,jj)     = alfarex2(ii,jj) - alfarex2(ii+3,jj)
c        difference polaraizability (imaginary)
      fdipol(ii,jj)     = alfarimx2(ii,jj) - alfarimx2(ii+3,jj)
c        convert units
       fdrpol(ii,jj) = ( fdrpol(ii,jj)*(bohr2ang**2) )/(two*stepsize)
       fdipol(ii,jj) = ( fdipol(ii,jj)*(bohr2ang**2) )/(two*stepsize)
       enddo
      enddo
c ----------calculate a and g for real and impaginary--------
      ar2 = ( ( (fdrpol(i,j)+fdrpol(i+1,j+1)+fdrpol(i+2,j+2))/three) 
     *       *( (fdrpol(i,j)+fdrpol(i+1,j+1)+fdrpol(i+2,j+2))/three) ) 
c
      gr2 = ( ( ((fdrpol(i,j)    - fdrpol(i+1,j+1))**2)
     *      +  ((fdrpol(i+1,j+1) - fdrpol(i+2,j+2))**2) 
     *      +  ((fdrpol(i+2,j+2) - fdrpol(i,j    ))**2) )
     *      + ( six*((fdrpol(i,j+1)   * fdrpol(i,j+1))
     *      +        (fdrpol(i+2,j)   * fdrpol(i+2,j))
     *      +        (fdrpol(i+1,j+2) * fdrpol(i+1,j+2))) )  )/two
c imaginary
      ai2 = ( ( (fdipol(i,j)+fdipol(i+1,j+1)+fdipol(i+2,j+2))/three)   
     *       *( (fdipol(i,j)+fdipol(i+1,j+1)+fdipol(i+2,j+2))/three) ) 
c
      gi2 = (  ( ((fdipol(i,j)     - fdipol(i+1,j+1))**2)
     *      +    ((fdipol(i+1,j+1) - fdipol(i+2,j+2))**2)
     *      +    ((fdipol(i+2,j+2) - fdipol(i,j    ))**2) )
     *      + ( six*((fdipol(i,j+1)   * fdipol(i,j+1))
     *      +        (fdipol(i+2,j)   * fdipol(i+2,j))
     *      +        (fdipol(i+1,j+2) * fdipol(i+1,j+2))) )  )/two
c --------------------------------------------------------------------
      if (debug) then
          write(luout,*) 'alfarimx2'
          call output(alfarimx2,1,6,1,3,6,3,1)
          write(luout,*) 'alfarex2'
          call output(alfarex2,1,6,1,3,6,3,1)
          write(luout,*) 'fdrpol'
          call output(fdrpol,1,3,1,3,3,3,1)
          write(luout,*) 'fdipol'
          call output(fdipol,1,3,1,3,3,3,1)
          write(luout,*) 'ar2=',ar2
          write(luout,*) 'gr2=',gr2
          write(luout,*) 'ai2=',ai2
          write(luout,*) 'gi2=',gi2
          write(luout,*) 'stepsize=',stepsize
      endif !  for DEBUG
      rminfo(m,2) = fourty_five*ar2 + seven*gr2 ! real component  
      rminfo(m,3) = fourty_five*ai2 + seven*gi2 ! imaginary component
      rminfo(m,4) = fourty_five*ar2 + seven*gr2 + fourty_five*ai2 +
     &               seven*gi2 ! total fdipole_polarizability_derivative
c------------ print result from finite difference ---------------------
      if (ga_nodeid().eq.0) write(luout,9001) rminfo(m,1),rminfo(m,2)
      if (ga_nodeid().eq.0) write(luout,9002) rminfo(m,1),rminfo(m,3)
      if (ga_nodeid().eq.0) write(luout,9003) rminfo(m,1),rminfo(m,4)
c --------------- save the rminfo for restart -------------------------
      if (.not. rtdb_put(rtdb, 'raman:rminfo ', mt_dbl,
     &    rmmodes*4, rminfo))
     &  call errquit('FD_raman:failed to write rminfo', 0, RTDB_ERR)
c --------------------------------------------------------------------
 9001 FORMAT(/1X,F7.2,2X,'REAL     ',2X,F24.6/)
 9002 FORMAT(/1X,F7.2,2X,'IMAGINARY',2X,F24.6/)
 9003 FORMAT(/1X,F7.2,2X,'TOTAL    ',2X,F24.6/)
      return
      end 
c
c --------------------------------------------------------------------
c   calculate absolute differential raman scattering cross section.
c   Producing a raman scattering output file 
c --------------------------------------------------------------------
c
      subroutine raman_scattering(rtdb,start,last,rmmodes,nfreq,plot,
     &                            line,width,laser,rminfo)
c
      implicit none
c
#include "global.fh"
#include "stdio.fh"
#include "rtdb.fh"
#include "inp.fh"
c
      character*16 plot, line
c
      integer rmmodes ! number or raman active modes
      integer rtdb    ! [input] rtdb handle
      integer nfreq   ! [input] number of excitation freqencies
      integer i,j   ! counting indexes 
      integer numpts ! number of points in plot
      integer last  ! [input] last mode to calculate for aoresponse
      integer begin ! first=begin if not restarting, else modified
      integer start ! [input] first mode to use in calculation of plot
c
      integer ifreq
      Double precision laser(nfreq) ! [input] laser used in AORESPONSE calculation
      Double precision width ! [input] line width
      Double precision rminfo(rmmodes,4) ! raman data
c      Double precision freq(rmmodes) ! [input] number of excitation frequencies used in AORESPONSE
      Double precision tempfc, frq4th 
      Double precision crs_real(rmmodes) ! real differential cross section
      Double precision  crs_imag(rmmodes) ! imaginary differential cross section
      Double precision crs_tot(rmmodes) ! total differential cross section
      Double precision frq, frqmin, frqmax, dfrq ! current, minimum, maximum and step of frequency
      Double precision afac, bfac, factor ! lineshape factors.
      Double precision conv_tot, conv_real, conv_imag !
      Double precision lambda ! exciation inverse wavenumber (1/cm)
      Double precision widthfac, pi, planck, boltz, speed, epsilon0 
      Double precision avogadro, nm2icm, temp, scale, amu,au2nm
      Double precision exparg, conver, zero, two, one, forty_five
c
      character*255 filename
      integer unitno
      parameter (unitno = 77)
c
      parameter (widthfac = 2.35482D+00)
      parameter (zero = 0.0D+00, one = 1.0D+00, 
     *           two = 2.0D+00, forty_five = 45.0D+00)
      parameter (pi = 3.14159265358979323846D+00)
      parameter (planck = 6.6260755D-34) ! plank's constant (J*sec)
      parameter (boltz = 1.3806580D-23) ! bolztmann's constant  (J/K)
      parameter (speed = 2.99792458D+08) ! speed of light (m/sec)
      parameter (epsilon0 = 8.8541878D-12) ! free permitivity (J^-1C^2m^-1)
      parameter (avogadro = 6.02214199D+23) ! avagadro's number (unitless)
      parameter (amu = (one/avogadro)*1.0D-03 ) ! atomic mass unit 
      parameter (au2nm =45.563353D+00)  ! converion factor from au to nm
      parameter (nm2icm = 1.0D+07) !converion factor from nm to 1/cm
      parameter (temp = 3.0D+02) ! tempature (k)
      parameter (scale = 1.0D+34)
      parameter (exparg  = (planck*speed*100.0D+00)/boltz )
      parameter (conver  = ( (two*planck*pi*pi)/speed*1.0D-40)/amu ) ! conver = 2*planck_h*pi^2/c * 10^40/atomic_mass_unit               
      parameter (numpts  = 1000)
c
      logical debug
      debug      = .false. ! produce debug output
c
c ----------outline and units of the calculation:---------------------
c d(sigma)/d(omega) = h/(8*(epsilon0)^2 *c) *(lambda-lambda_z)^4/lambda_z
c                     /(1-exp(-h*c*lambda_z/(kT))*(scattering factor)/45                    
c differential cross sections:
c - constant pre-factor for differential scattering cross sections:
c        h/(8*(epsilon0)^2*c) = 3.524100053d-21 J^3*s^2*m/C^4
c - lambda_t is given in [1/m^3]
c - squared polarizability derivatives have to be given in
c   [C^2*m^2/V^2/kg], but they are given as squared derivatives of
c   polarizability volumes in [Angstrom^4/amu].
c   conversion factor: (4*pi*epsilon0)^2*10^-40{Angstrom^4/m^4}
c                      /atomic_mass_unit{amu/kg}
c --------------------------------------------------------------------
c
      if (debug) then
          write(6,*) "rmmodes",rmmodes
          do ifreq = 1,nfreq
            write(6,*) "laser",laser(ifreq)
          end do
          write(6,*) 'rminfo'
          call output(rminfo,1,rmmodes,1,4,rmmodes,4,1)
      endif
c
c     --- write raman scattering data to file ---
c
      call util_file_name(plot,.false.,.false.,filename)
      open(unitno, status='unknown', form='formatted',file=filename)

      write(unitno,9002) plot
      do ifreq = 1,nfreq
         write(unitno,9003) au2nm/laser(ifreq)
      end do
      write(unitno,9004) line 
      write(unitno,9005) width
      write(unitno,9010) rmmodes
c
      if (plot =='normal') then
         write(unitno,9011)
         do i=1,rmmodes             
            write(unitno,9012) i, rminfo(i,1), rminfo(i,4)
         end do
            write(unitno,9006)
      else if (plot =='resonance') then
         write(unitno,9013)
         do i=1,rmmodes
            write(unitno,9014) i, rminfo(i,1), rminfo(i,4), 
     &                        rminfo(i,2), rminfo(i,3)
         end do
            write(unitno,9006)
      end if ! normal
c
c ----------convert laser from au. -> nm -> 1/cm ----------------------------
c
        lambda = nm2icm/(au2nm/laser(1))
c
c ------------Calculate differential cross section-----------------------
c
      do i=start,rmmodes
         crs_real(i) = zero
         crs_imag(i) = zero
         crs_tot(i)  = zero
         tempfc=1.0D+06/(one-exp(-exparg*rminfo(i,1)/temp))
         frq4th = (lambda-rminfo(i,1))**4
         crs_tot(i) = tempfc*frq4th*conver*rminfo(i,4)/
     *                     (forty_five*rminfo(i,1))
         if (plot == 'resonance') then
            crs_real(i) = tempfc*frq4th*conver*rminfo(i,2)/
     *                     (forty_five*rminfo(i,1))
            crs_imag(i) = tempfc*frq4th*conver*rminfo(i,3)/
     *                     (forty_five*rminfo(i,1))
         end if
      enddo ! rmmodes
c
         frqmin = rminfo(1,1) - 60.0D+00  ! determine plot minimum
         frqmax = rminfo(rmmodes,1) + 60.0D+00 ! determine plot maximum
         dfrq   = ((frqmax-frqmin)) / (numpts-1) !energy steps determined by numpts
c
c ------calculate lineshape factors for the plot-----------------------
c
      if (line == 'lorentzian') then
         afac = width/(two*pi)
         bfac = width/two
      end if
c      
      if (line == 'gaussian') then
         width = width/widthfac
         afac = one/(sqrt(two*pi)*width)
         bfac = one/(two*width**two)
      end if
c
c ----------- make the plot---------------------------------------
c
      do i=1,numpts ! loop over number of points
         conv_tot = zero
         conv_real = zero
         conv_imag = zero
         frq = frqmin + i*dfrq
         do j=start,rmmodes ! loop over number of raman active modes
            if (line == 'lorentzian') then  
             factor = scale*afac/((frq-rminfo(j,1))**2 + bfac**2)
            else if (line == 'gaussian') then  
             factor = scale*afac*exp(-bfac* (frq-rminfo(j,1))**2)
            endif
            conv_tot = conv_tot + factor*crs_tot(j)
            if (plot == 'resonance') then
               conv_real = conv_real + factor*crs_real(j)
               conv_imag = conv_imag + factor*crs_imag(j)
            end if
         end do  ! end loop over rmmodes 
c
         if (plot == 'normal' ) then
            write (unitno,9017) frq, conv_tot
         else if (plot =='resonance') then
            write(unitno,9018) frq, conv_tot, conv_real, conv_imag
         endif  ! plot
      end do ! end loop over numpts
c
      close(unitno) 
c
      write(luout,22) filename(1:inp_strlen(filename))
 22   format(/' Raman scattering data written to ',a/)
      call util_flush(luout)
c
c --------------------------------------------------------------------
 9002 FORMAT(/1X,60(1H-)/5X,A16,'Raman Scattering Plot'/1X,60(1H-))
 9003 FORMAT(1X,'Excitation wavelength',F8.2,1X,'nm')
 9004 FORMAT(1X,'Convolution lineshape is ',A12)
 9005 FORMAT(1X,'FWHM',F8.2,1X,' 1/cm'/1X,60(1H-))
 9006 FORMAT(1X,60(1H-))
 9010 FORMAT(1X,60(1H-)/1X,'# of frequencies : ',I5)
 9011 FORMAT(1X,60(1H-)/1X,'#  freq [ 1/cm]  S [Ang**4/amu]'/
     *        1X,60(1H-))
 9012 FORMAT(1X,I3,F9.2,F14.4)
 9013 FORMAT(1X,60(1H-)/'#  freq [ 1/cm]  S-tot [a.u.]',  
     * 'S-real [a.u.]  S-imag [a.u.]'/1X,60(1H-))
 9014 FORMAT(1X,I3,F9.2,3F14.4)
 9015 FORMAT(1X,I4,F10.2,2E12.4)
 9016 FORMAT(1X,F10.2,3E12.4)
 9017 FORMAT(1X,F8.2,G14.4)
 9018 FORMAT(1X,F8.2,3G14.4)
c
      return
      end  
c ----------------end raman_scattering---------------------------------------
c
      subroutine raman_save(rtdb,ii,junk3,junk4)
c
      implicit none
#include "errquit.fh"
#include "rtdb.fh"
#include "mafdecls.fh"
#include "stdio.fh"
#include "geom.fh"
#include "nwc_const.fh" 
#include "inp.fh"
#include "global.fh"
c
      integer i,j,n,ii ! counting indexes
      integer rtdb     ! [input] rtdb handle
      double precision alfare(3,3),alfaim(3,3) ! [aoresponse] real and imaginary polarizanbility
      double precision junk3(6,3),junk4(6,3) ! temp. arrays for FD of polarizanbility
      logical debug
      logical status
c
      debug      = (.false. .and. ga_nodeid().eq.0) ! produce debug output
      status = rtdb_parallel(.true.)
c  -------------get raman ploarizability from rtdb ----------------------------
        if (.not. rtdb_get(rtdb, 'raman:alfare ', mt_dbl, 9, alfare))
     &   call errquit('raman_save:failed to get alfare', 1, RTDB_ERR)
        if (.not. rtdb_get(rtdb, 'raman:alfaim ', mt_dbl, 9, alfaim)) 
     &   call errquit('raman_save:failed to get alfaim', 2, RTDB_ERR)
c
      n=(ii-1)*3
      DO i=1,3
         n=n+1
        DO j=1,3
          junk3(n,j)= alfare(i,j) ! add AORESPONSE real data to array for finite_differencing
          junk4(n,j)= alfaim(i,j) ! add AORESPONSE imaginary data to array for finite_differencing
        enddo ! j loop
       enddo ! i loop
c  -------------delete raman ploarizability from rtdb ----------------------------
      IF (debug) THEN
          write(luout,*) 'junk3'
          call output(junk3,1,6,1,3,6,3,1)
          write(luout,*) 'junk4'
          call output(junk4,1,6,1,3,6,3,1)
          write(luout,*) 'alfare'
          call output(alfare,1,3,1,3,3,3,1)
          write(luout,*) 'alfaim'
          call output(alfaim,1,3,1,3,3,3,1)
      ENDIF !  for DEBUG
c
      return
      end
c ----------------end raman_save------------------------------------------------
c $Id: raman.F 21176 2011-10-10 06:35:49Z d3y133 $
