C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_x_m11.F 
C> The nwxcm_x_m11 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_x_m11 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& \rho_\alpha^{{{1}\over{3}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha}}\\\\ 
C>   {\it t_5} &=& 1.0-0.04275941461768073\,{\it t_3}\,
C>    \left({{0.1282782438530422\,{\it t_3}
C>    -2.63857249068588 \times 10^{-4}\,{\it t_4}}
C>    \over{e^{243.0826598584318\,\rho_\alpha^{{{2}\over{3}}}}}}
C>    -0.1924173657795633\,{\it t_3}+2.63857249068588 \times 10^{-4}
C>    \,{\it t_4}+3.544907701811032\,\mathrm{erf}
C>    \left(15.59110835888301\,{\it t_2}\right)\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& 0.804\,\left(1.0-{{1.0}\over{0.004492667444378077
C>    \,{\it t_6}\,\sigma_{\alpha\alpha}+1.0}}\right)+1.0\\\\ 
C>   {\it t_8} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_9} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{10}} &=& 9.115599744691192\,\rho_\alpha^{{{5}
C>    \over{3}}}\\\\ 
C>   {\it t_{11}} &=& {\it t_{10}}-2.0\,\tau_\alpha\\\\ 
C>   {\it t_{12}} &=& {\it t_{11}}^{11}\\\\ 
C>   {\it t_{13}} &=& 2.0\,\tau_\alpha+{\it t_{10}}\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_{13}}^{11}}}\\\\ 
C>   {\it t_{15}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{16}} &=& {\it t_{11}}^{10}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{{\it t_{13}}^{10}}}\\\\ 
C>   {\it t_{18}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{19}} &=& {\it t_{11}}^9\\\\ 
C>   {\it t_{20}} &=& {{1}\over{{\it t_{13}}^9}}\\\\ 
C>   {\it t_{21}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{22}} &=& {\it t_{11}}^8\\\\ 
C>   {\it t_{23}} &=& {{1}\over{{\it t_{13}}^8}}\\\\ 
C>   {\it t_{24}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{25}} &=& {\it t_{11}}^7\\\\ 
C>   {\it t_{26}} &=& {{1}\over{{\it t_{13}}^7}}\\\\ 
C>   {\it t_{27}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{28}} &=& {\it t_{11}}^6\\\\ 
C>   {\it t_{29}} &=& {{1}\over{{\it t_{13}}^6}}\\\\ 
C>   {\it t_{30}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{31}} &=& {\it t_{11}}^5\\\\ 
C>   {\it t_{32}} &=& {{1}\over{{\it t_{13}}^5}}\\\\ 
C>   {\it t_{33}} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_{34}} &=& {\it t_{11}}^4\\\\ 
C>   {\it t_{35}} &=& {{1}\over{{\it t_{13}}^4}}\\\\ 
C>   {\it t_{36}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{37}} &=& {\it t_{11}}^3\\\\ 
C>   {\it t_{38}} &=& {{1}\over{{\it t_{13}}^3}}\\\\ 
C>   {\it t_{39}} &=& {\it param}\left(3\right)\\\\ 
C>   {\it t_{40}} &=& {\it t_{11}}^2\\\\ 
C>   {\it t_{41}} &=& {{1}\over{{\it t_{13}}^2}}\\\\ 
C>   {\it t_{42}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{43}} &=& {{1}\over{{\it t_{13}}}}\\\\ 
C>   {\it t_{44}} &=& 0.552\,\left(1.0-{{1}
C>    \over{e^{0.003680288926019986\,{\it t_6}\,
C>    \sigma_{\alpha\alpha}}}}\right)+1.0\\\\ 
C>   {\it t_{45}} &=& {\it param}\left(13\right)\\\\ 
C>   {\it t_{46}} &=& {\it param}\left(24\right)\\\\ 
C>   {\it t_{47}} &=& {\it param}\left(23\right)\\\\ 
C>   {\it t_{48}} &=& {\it param}\left(22\right)\\\\ 
C>   {\it t_{49}} &=& {\it param}\left(21\right)\\\\ 
C>   {\it t_{50}} &=& {\it param}\left(20\right)\\\\ 
C>   {\it t_{51}} &=& {\it param}\left(19\right)\\\\ 
C>   {\it t_{52}} &=& {\it param}\left(18\right)\\\\ 
C>   {\it t_{53}} &=& {\it param}\left(17\right)\\\\ 
C>   {\it t_{54}} &=& {\it param}\left(16\right)\\\\ 
C>   {\it t_{55}} &=& {\it param}\left(15\right)\\\\ 
C>   {\it t_{56}} &=& {\it param}\left(14\right)\\\\ 
C>   {\it t_{57}} &=& 0.9305257363491002\,{\it t_1}\,{\it t_5}
C>    -0.9305257363491002\,{\it t_1}\\\\ 
C>   {\it t_{58}} &=& {\it param}\left(25\right)\\\\ 
C>   {\it t_{59}} &=& {\it param}\left(36\right)\\\\ 
C>   {\it t_{60}} &=& {\it param}\left(35\right)\\\\ 
C>   {\it t_{61}} &=& {\it param}\left(34\right)\\\\ 
C>   {\it t_{62}} &=& {\it param}\left(33\right)\\\\ 
C>   {\it t_{63}} &=& {\it param}\left(32\right)\\\\ 
C>   {\it t_{64}} &=& {\it param}\left(31\right)\\\\ 
C>   {\it t_{65}} &=& {\it param}\left(30\right)\\\\ 
C>   {\it t_{66}} &=& {\it param}\left(29\right)\\\\ 
C>   {\it t_{67}} &=& {\it param}\left(28\right)\\\\ 
C>   {\it t_{68}} &=& {\it param}\left(27\right)\\\\ 
C>   {\it t_{69}} &=& {\it param}\left(26\right)\\\\ 
C>   {\it t_{70}} &=& {\it param}\left(37\right)\\\\ 
C>   {\it t_{71}} &=& {\it param}\left(48\right)\\\\ 
C>   {\it t_{72}} &=& {\it param}\left(47\right)\\\\ 
C>   {\it t_{73}} &=& {\it param}\left(46\right)\\\\ 
C>   {\it t_{74}} &=& {\it param}\left(45\right)\\\\ 
C>   {\it t_{75}} &=& {\it param}\left(44\right)\\\\ 
C>   {\it t_{76}} &=& {\it param}\left(43\right)\\\\ 
C>   {\it t_{77}} &=& {\it param}\left(42\right)\\\\ 
C>   {\it t_{78}} &=& {\it param}\left(41\right)\\\\ 
C>   {\it t_{79}} &=& {\it param}\left(40\right)\\\\ 
C>   {\it t_{80}} &=& {\it param}\left(39\right)\\\\ 
C>   {\it t_{81}} &=& {\it param}\left(38\right)\\\\ 
C>   {\it t_{82}} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_{83}} &=& \rho_\beta^{{{1}\over{3}}}\\\\ 
C>   {\it t_{84}} &=& {{1}\over{{\it t_{83}}}}\\\\ 
C>   {\it t_{85}} &=& {{1}\over{\rho_\beta}}\\\\ 
C>   {\it t_{86}} &=& 1.0-0.04275941461768073\,{\it t_{84}}\,
C>    \left({{0.1282782438530422\,{\it t_{84}}
C>    -2.63857249068588 \times 10^{-4}\,{\it t_{85}}}
C>    \over{e^{243.0826598584318\,\rho_\beta^{{{2}\over{3}}}}}}
C>    -0.1924173657795633\,{\it t_{84}}+2.63857249068588 \times 10^{
C>    -4}\,{\it t_{85}}+3.544907701811032\,\mathrm{erf}
C>    \left(15.59110835888301\,{\it t_{83}}\right)\right)\\\\ 
C>   {\it t_{87}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{88}} &=& 0.804\,\left(1.0-{{1.0}
C>    \over{0.004492667444378077\,{\it t_{87}}\,\sigma_{\beta\beta}
C>    +1.0}}\right)+1.0\\\\ 
C>   {\it t_{89}} &=& 9.115599744691192\,\rho_\beta^{{{5}\over{3}}}\\\\ 
C>   {\it t_{90}} &=& {\it t_{89}}-2.0\,\tau_\beta\\\\ 
C>   {\it t_{91}} &=& {\it t_{90}}^{11}\\\\ 
C>   {\it t_{92}} &=& 2.0\,\tau_\beta+{\it t_{89}}\\\\ 
C>   {\it t_{93}} &=& {{1}\over{{\it t_{92}}^{11}}}\\\\ 
C>   {\it t_{94}} &=& {\it t_{90}}^{10}\\\\ 
C>   {\it t_{95}} &=& {{1}\over{{\it t_{92}}^{10}}}\\\\ 
C>   {\it t_{96}} &=& {\it t_{90}}^9\\\\ 
C>   {\it t_{97}} &=& {{1}\over{{\it t_{92}}^9}}\\\\ 
C>   {\it t_{98}} &=& {\it t_{90}}^8\\\\ 
C>   {\it t_{99}} &=& {{1}\over{{\it t_{92}}^8}}\\\\ 
C>   {\it t_{100}} &=& {\it t_{90}}^7\\\\ 
C>   {\it t_{101}} &=& {{1}\over{{\it t_{92}}^7}}\\\\ 
C>   {\it t_{102}} &=& {\it t_{90}}^6\\\\ 
C>   {\it t_{103}} &=& {{1}\over{{\it t_{92}}^6}}\\\\ 
C>   {\it t_{104}} &=& {\it t_{90}}^5\\\\ 
C>   {\it t_{105}} &=& {{1}\over{{\it t_{92}}^5}}\\\\ 
C>   {\it t_{106}} &=& {\it t_{90}}^4\\\\ 
C>   {\it t_{107}} &=& {{1}\over{{\it t_{92}}^4}}\\\\ 
C>   {\it t_{108}} &=& {\it t_{90}}^3\\\\ 
C>   {\it t_{109}} &=& {{1}\over{{\it t_{92}}^3}}\\\\ 
C>   {\it t_{110}} &=& {\it t_{90}}^2\\\\ 
C>   {\it t_{111}} &=& {{1}\over{{\it t_{92}}^2}}\\\\ 
C>   {\it t_{112}} &=& {{1}\over{{\it t_{92}}}}\\\\ 
C>   {\it t_{113}} &=& 0.552\,\left(1.0-{{1}
C>    \over{e^{0.003680288926019986\,{\it t_{87}}\,
C>    \sigma_{\beta\beta}}}}\right)+1.0\\\\ 
C>   {\it t_{114}} &=& 0.9305257363491002\,{\it t_{82}}\,{\it t_{86}}
C>    -0.9305257363491002\,{\it t_{82}}\\\\ 
C>   {\it t_{115}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{116}} &=& \rho_s^{{{1}\over{3}}}\\\\ 
C>   {\it t_{117}} &=& {{1}\over{{\it t_{116}}}}\\\\ 
C>   {\it t_{118}} &=& {{1}\over{\rho_s}}\\\\ 
C>   {\it t_{119}} &=& 1.0-0.04275941461768073\,{\it t_{117}}
C>    \,\left({{0.1282782438530422\,{\it t_{117}}
C>    -2.63857249068588 \times 10^{-4}\,{\it t_{118}}}
C>    \over{e^{243.0826598584318\,\rho_s^{{{2}\over{3}}}}}}
C>    -0.1924173657795633\,{\it t_{117}}+2.63857249068588 \times 10^{
C>    -4}\,{\it t_{118}}+3.544907701811032\,\mathrm{erf}
C>    \left(15.59110835888301\,{\it t_{116}}\right)\right)\\\\ 
C>   {\it t_{120}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{121}} &=& 0.804\,\left(1.0-{{1.0}
C>    \over{0.004492667444378077\,{\it t_{120}}\,\sigma_{ss}
C>    +1.0}}\right)+1.0\\\\ 
C>   {\it t_{122}} &=& 9.115599744691192\,\rho_s^{{{5}\over{3}}}\\\\ 
C>   {\it t_{123}} &=& {\it t_{122}}-2.0\,\tau_s\\\\ 
C>   {\it t_{124}} &=& {\it t_{123}}^{11}\\\\ 
C>   {\it t_{125}} &=& 2.0\,\tau_s+{\it t_{122}}\\\\ 
C>   {\it t_{126}} &=& {{1}\over{{\it t_{125}}^{11}}}\\\\ 
C>   {\it t_{127}} &=& {\it t_{123}}^{10}\\\\ 
C>   {\it t_{128}} &=& {{1}\over{{\it t_{125}}^{10}}}\\\\ 
C>   {\it t_{129}} &=& {\it t_{123}}^9\\\\ 
C>   {\it t_{130}} &=& {{1}\over{{\it t_{125}}^9}}\\\\ 
C>   {\it t_{131}} &=& {\it t_{123}}^8\\\\ 
C>   {\it t_{132}} &=& {{1}\over{{\it t_{125}}^8}}\\\\ 
C>   {\it t_{133}} &=& {\it t_{123}}^7\\\\ 
C>   {\it t_{134}} &=& {{1}\over{{\it t_{125}}^7}}\\\\ 
C>   {\it t_{135}} &=& {\it t_{123}}^6\\\\ 
C>   {\it t_{136}} &=& {{1}\over{{\it t_{125}}^6}}\\\\ 
C>   {\it t_{137}} &=& {\it t_{123}}^5\\\\ 
C>   {\it t_{138}} &=& {{1}\over{{\it t_{125}}^5}}\\\\ 
C>   {\it t_{139}} &=& {\it t_{123}}^4\\\\ 
C>   {\it t_{140}} &=& {{1}\over{{\it t_{125}}^4}}\\\\ 
C>   {\it t_{141}} &=& {\it t_{123}}^3\\\\ 
C>   {\it t_{142}} &=& {{1}\over{{\it t_{125}}^3}}\\\\ 
C>   {\it t_{143}} &=& {\it t_{123}}^2\\\\ 
C>   {\it t_{144}} &=& {{1}\over{{\it t_{125}}^2}}\\\\ 
C>   {\it t_{145}} &=& {{1}\over{{\it t_{125}}}}\\\\ 
C>   {\it t_{146}} &=& 0.552\,\left(1.0-{{1}
C>    \over{e^{0.003680288926019986\,{\it t_{120}}\,
C>    \sigma_{ss}}}}\right)+1.0\\\\ 
C>   {\it t_{147}} &=& 0.9305257363491002\,{\it t_{115}}\,{
C>    \it t_{119}}-0.9305257363491002\,{\it t_{115}}\\\\ 
C>   f &=& 1.0\,\left({\it t_{114}}\,{\it t_{113}}\,\left({
C>    \it t_{81}}\,{\it t_{90}}\,{\it t_{112}}+{\it t_{80}}\,{
C>    \it t_{110}}\,{\it t_{111}}+{\it t_{79}}\,{\it t_{108}}\,{
C>    \it t_{109}}+{\it t_{78}}\,{\it t_{106}}\,{\it t_{107}}+{
C>    \it t_{77}}\,{\it t_{104}}\,{\it t_{105}}+{\it t_{76}}\,{
C>    \it t_{102}}\,{\it t_{103}}+{\it t_{75}}\,{\it t_{100}}\,{
C>    \it t_{101}}+{\it t_{74}}\,{\it t_{98}}\,{\it t_{99}}+{
C>    \it t_{73}}\,{\it t_{96}}\,{\it t_{97}}+{\it t_{72}}\,{
C>    \it t_{94}}\,{\it t_{95}}+{\it t_{71}}\,{\it t_{91}}\,{
C>    \it t_{93}}+{\it t_{70}}\right)+{\it t_{114}}\,{\it t_{88}}
C>    \,\left({\it t_{69}}\,{\it t_{90}}\,{\it t_{112}}+{\it t_{68}}
C>    \,{\it t_{110}}\,{\it t_{111}}+{\it t_{67}}\,{\it t_{108}}
C>    \,{\it t_{109}}+{\it t_{66}}\,{\it t_{106}}\,{\it t_{107}}+{
C>    \it t_{65}}\,{\it t_{104}}\,{\it t_{105}}+{\it t_{64}}\,{
C>    \it t_{102}}\,{\it t_{103}}+{\it t_{63}}\,{\it t_{100}}\,{
C>    \it t_{101}}+{\it t_{62}}\,{\it t_{98}}\,{\it t_{99}}+{
C>    \it t_{61}}\,{\it t_{96}}\,{\it t_{97}}+{\it t_{60}}\,{
C>    \it t_{94}}\,{\it t_{95}}+{\it t_{59}}\,{\it t_{91}}\,{
C>    \it t_{93}}+{\it t_{58}}\right)-0.9305257363491002\,{
C>    \it t_{82}}\,{\it t_{86}}\,{\it t_{113}}\,\left({\it t_{56}}
C>    \,{\it t_{90}}\,{\it t_{112}}+{\it t_{55}}\,{\it t_{110}}\,{
C>    \it t_{111}}+{\it t_{54}}\,{\it t_{108}}\,{\it t_{109}}+{
C>    \it t_{53}}\,{\it t_{106}}\,{\it t_{107}}+{\it t_{52}}\,{
C>    \it t_{104}}\,{\it t_{105}}+{\it t_{51}}\,{\it t_{102}}\,{
C>    \it t_{103}}+{\it t_{50}}\,{\it t_{100}}\,{\it t_{101}}+{
C>    \it t_{49}}\,{\it t_{98}}\,{\it t_{99}}+{\it t_{48}}\,{
C>    \it t_{96}}\,{\it t_{97}}+{\it t_{47}}\,{\it t_{94}}\,{
C>    \it t_{95}}+{\it t_{46}}\,{\it t_{91}}\,{\it t_{93}}+{
C>    \it t_{45}}\right)-0.9305257363491002\,{\it t_{82}}\,{
C>    \it t_{86}}\,{\it t_{88}}\,\left({\it t_{42}}\,{\it t_{90}}
C>    \,{\it t_{112}}+{\it t_{39}}\,{\it t_{110}}\,{\it t_{111}}+{
C>    \it t_{36}}\,{\it t_{108}}\,{\it t_{109}}+{\it t_{33}}\,{
C>    \it t_{106}}\,{\it t_{107}}+{\it t_{30}}\,{\it t_{104}}\,{
C>    \it t_{105}}+{\it t_{27}}\,{\it t_{102}}\,{\it t_{103}}+{
C>    \it t_{24}}\,{\it t_{100}}\,{\it t_{101}}+{\it t_{21}}\,{
C>    \it t_{98}}\,{\it t_{99}}+{\it t_{18}}\,{\it t_{96}}\,{
C>    \it t_{97}}+{\it t_{15}}\,{\it t_{94}}\,{\it t_{95}}+{\it t_9}
C>    \,{\it t_{91}}\,{\it t_{93}}+{\it t_8}\right)\right)+1.0
C>    \,\left({\it t_{57}}\,{\it t_{44}}\,\left({\it t_{81}}\,{
C>    \it t_{11}}\,{\it t_{43}}+{\it t_{80}}\,{\it t_{40}}\,{
C>    \it t_{41}}+{\it t_{79}}\,{\it t_{37}}\,{\it t_{38}}+{
C>    \it t_{78}}\,{\it t_{34}}\,{\it t_{35}}+{\it t_{77}}\,{
C>    \it t_{31}}\,{\it t_{32}}+{\it t_{76}}\,{\it t_{28}}\,{
C>    \it t_{29}}+{\it t_{75}}\,{\it t_{25}}\,{\it t_{26}}+{
C>    \it t_{74}}\,{\it t_{22}}\,{\it t_{23}}+{\it t_{73}}\,{
C>    \it t_{19}}\,{\it t_{20}}+{\it t_{72}}\,{\it t_{16}}\,{
C>    \it t_{17}}+{\it t_{71}}\,{\it t_{12}}\,{\it t_{14}}+{
C>    \it t_{70}}\right)+{\it t_{57}}\,{\it t_7}\,\left({\it t_{69}}
C>    \,{\it t_{11}}\,{\it t_{43}}+{\it t_{68}}\,{\it t_{40}}\,{
C>    \it t_{41}}+{\it t_{67}}\,{\it t_{37}}\,{\it t_{38}}+{
C>    \it t_{66}}\,{\it t_{34}}\,{\it t_{35}}+{\it t_{65}}\,{
C>    \it t_{31}}\,{\it t_{32}}+{\it t_{64}}\,{\it t_{28}}\,{
C>    \it t_{29}}+{\it t_{63}}\,{\it t_{25}}\,{\it t_{26}}+{
C>    \it t_{62}}\,{\it t_{22}}\,{\it t_{23}}+{\it t_{61}}\,{
C>    \it t_{19}}\,{\it t_{20}}+{\it t_{60}}\,{\it t_{16}}\,{
C>    \it t_{17}}+{\it t_{59}}\,{\it t_{12}}\,{\it t_{14}}+{
C>    \it t_{58}}\right)-0.9305257363491002\,{\it t_1}\,{\it t_5}
C>    \,{\it t_{44}}\,\left({\it t_{56}}\,{\it t_{11}}\,{\it t_{43}}
C>    +{\it t_{55}}\,{\it t_{40}}\,{\it t_{41}}+{\it t_{54}}\,{
C>    \it t_{37}}\,{\it t_{38}}+{\it t_{53}}\,{\it t_{34}}\,{
C>    \it t_{35}}+{\it t_{52}}\,{\it t_{31}}\,{\it t_{32}}+{
C>    \it t_{51}}\,{\it t_{28}}\,{\it t_{29}}+{\it t_{50}}\,{
C>    \it t_{25}}\,{\it t_{26}}+{\it t_{49}}\,{\it t_{22}}\,{
C>    \it t_{23}}+{\it t_{48}}\,{\it t_{19}}\,{\it t_{20}}+{
C>    \it t_{47}}\,{\it t_{16}}\,{\it t_{17}}+{\it t_{46}}\,{
C>    \it t_{12}}\,{\it t_{14}}+{\it t_{45}}\right)
C>    -0.9305257363491002\,{\it t_1}\,{\it t_5}\,{\it t_7}\,
C>    \left({\it t_{42}}\,{\it t_{11}}\,{\it t_{43}}+{\it t_{39}}
C>    \,{\it t_{40}}\,{\it t_{41}}+{\it t_{36}}\,{\it t_{37}}\,{
C>    \it t_{38}}+{\it t_{33}}\,{\it t_{34}}\,{\it t_{35}}+{
C>    \it t_{30}}\,{\it t_{31}}\,{\it t_{32}}+{\it t_{27}}\,{
C>    \it t_{28}}\,{\it t_{29}}+{\it t_{24}}\,{\it t_{25}}\,{
C>    \it t_{26}}+{\it t_{21}}\,{\it t_{22}}\,{\it t_{23}}+{
C>    \it t_{18}}\,{\it t_{19}}\,{\it t_{20}}+{\it t_{15}}\,{
C>    \it t_{16}}\,{\it t_{17}}+{\it t_9}\,{\it t_{12}}\,{\it t_{14}}
C>    +{\it t_8}\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left({\it t_{147}}\,{\it t_{146}}\,\left({
C>    \it t_{81}}\,{\it t_{123}}\,{\it t_{145}}+{\it t_{80}}\,{
C>    \it t_{143}}\,{\it t_{144}}+{\it t_{79}}\,{\it t_{141}}\,{
C>    \it t_{142}}+{\it t_{78}}\,{\it t_{139}}\,{\it t_{140}}+{
C>    \it t_{77}}\,{\it t_{137}}\,{\it t_{138}}+{\it t_{76}}\,{
C>    \it t_{135}}\,{\it t_{136}}+{\it t_{75}}\,{\it t_{133}}\,{
C>    \it t_{134}}+{\it t_{74}}\,{\it t_{131}}\,{\it t_{132}}+{
C>    \it t_{73}}\,{\it t_{129}}\,{\it t_{130}}+{\it t_{72}}\,{
C>    \it t_{127}}\,{\it t_{128}}+{\it t_{71}}\,{\it t_{124}}\,{
C>    \it t_{126}}+{\it t_{70}}\right)+{\it t_{147}}\,{\it t_{121}}
C>    \,\left({\it t_{69}}\,{\it t_{123}}\,{\it t_{145}}+{
C>    \it t_{68}}\,{\it t_{143}}\,{\it t_{144}}+{\it t_{67}}\,{
C>    \it t_{141}}\,{\it t_{142}}+{\it t_{66}}\,{\it t_{139}}\,{
C>    \it t_{140}}+{\it t_{65}}\,{\it t_{137}}\,{\it t_{138}}+{
C>    \it t_{64}}\,{\it t_{135}}\,{\it t_{136}}+{\it t_{63}}\,{
C>    \it t_{133}}\,{\it t_{134}}+{\it t_{62}}\,{\it t_{131}}\,{
C>    \it t_{132}}+{\it t_{61}}\,{\it t_{129}}\,{\it t_{130}}+{
C>    \it t_{60}}\,{\it t_{127}}\,{\it t_{128}}+{\it t_{59}}\,{
C>    \it t_{124}}\,{\it t_{126}}+{\it t_{58}}\right)
C>    -0.9305257363491002\,{\it t_{115}}\,{\it t_{119}}\,{
C>    \it t_{146}}\,\left({\it t_{56}}\,{\it t_{123}}\,{\it t_{145}}
C>    +{\it t_{55}}\,{\it t_{143}}\,{\it t_{144}}+{\it t_{54}}\,{
C>    \it t_{141}}\,{\it t_{142}}+{\it t_{53}}\,{\it t_{139}}\,{
C>    \it t_{140}}+{\it t_{52}}\,{\it t_{137}}\,{\it t_{138}}+{
C>    \it t_{51}}\,{\it t_{135}}\,{\it t_{136}}+{\it t_{50}}\,{
C>    \it t_{133}}\,{\it t_{134}}+{\it t_{49}}\,{\it t_{131}}\,{
C>    \it t_{132}}+{\it t_{48}}\,{\it t_{129}}\,{\it t_{130}}+{
C>    \it t_{47}}\,{\it t_{127}}\,{\it t_{128}}+{\it t_{46}}\,{
C>    \it t_{124}}\,{\it t_{126}}+{\it t_{45}}\right)
C>    -0.9305257363491002\,{\it t_{115}}\,{\it t_{119}}\,{
C>    \it t_{121}}\,\left({\it t_{42}}\,{\it t_{123}}\,{\it t_{145}}
C>    +{\it t_{39}}\,{\it t_{143}}\,{\it t_{144}}+{\it t_{36}}\,{
C>    \it t_{141}}\,{\it t_{142}}+{\it t_{33}}\,{\it t_{139}}\,{
C>    \it t_{140}}+{\it t_{30}}\,{\it t_{137}}\,{\it t_{138}}+{
C>    \it t_{27}}\,{\it t_{135}}\,{\it t_{136}}+{\it t_{24}}\,{
C>    \it t_{133}}\,{\it t_{134}}+{\it t_{21}}\,{\it t_{131}}\,{
C>    \it t_{132}}+{\it t_{18}}\,{\it t_{129}}\,{\it t_{130}}+{
C>    \it t_{15}}\,{\it t_{127}}\,{\it t_{128}}+{\it t_9}\,{
C>    \it t_{124}}\,{\it t_{126}}+{\it t_8}\right)\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] R Peverati, DG Truhlar, J.Phys.Chem.Lett. 2, 2810 (2011)  , DOI: 
C> <a href="http://dx.doi.org/10.1021/jz201170d "> 
C> 10.1021/jz201170d </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_x_m11(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Cmat,Mmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = rhoa**3.333333333333333d-1
            t6 = 1/t5
            t7 = 1/rhoa
            t8 = 1.282782438530422d-1*t6-2.63857249068588d-4*t7
            t9 = rhoa**6.666666666666666d-1
            t10 = exp(-2.4308265985843178d+2*t9)
            t11 = t10*t8+2.63857249068588d-4*t7-1.924173657795633d-1*t6+
     1         3.544907701811032d+0*erf(1.5591108358883013d+1*t5)
            t12 = 1.0d+0-4.275941461768073d-2*t11*t6
            t13 = param(12)
            t14 = 9.115599744691192d+0*rhoa**1.6666666666666669d+0
            t15 = t14-2.0d+0*taua
            t16 = t15**11
            t17 = 2.0d+0*taua+t14
            t18 = 1/t17**11
            t19 = param(11)
            t20 = t15**10
            t21 = 1/t17**10
            t22 = param(10)
            t23 = t15**9
            t24 = 1/t17**9
            t25 = param(9)
            t26 = t15**8
            t27 = 1/t17**8
            t28 = param(8)
            t29 = t15**7
            t30 = 1/t17**7
            t31 = param(7)
            t32 = t15**6
            t33 = 1/t17**6
            t34 = param(6)
            t35 = t15**5
            t36 = 1/t17**5
            t37 = param(5)
            t38 = t15**4
            t39 = 1/t17**4
            t40 = param(4)
            t41 = t15**3
            t42 = 1/t17**3
            t43 = param(3)
            t44 = t15**2
            t45 = 1/t17**2
            t46 = param(2)
            t47 = 1/t17
            t48 = t15*t46*t47+t43*t44*t45+t40*t41*t42+t37*t38*t39+t34*t3
     1         5*t36+t31*t32*t33+t28*t29*t30+t25*t26*t27+t22*t23*t24+t19
     2         *t20*t21+t13*t16*t18+param(1)
            t49 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t50 = 5.52d-1*(1.0d+0-t49)+1.0d+0
            t51 = param(24)
            t52 = param(23)
            t53 = param(22)
            t54 = param(21)
            t55 = param(20)
            t56 = param(19)
            t57 = param(18)
            t58 = param(17)
            t59 = param(16)
            t60 = param(15)
            t61 = param(14)
            t62 = t15*t47*t61+t44*t45*t60+t41*t42*t59+t38*t39*t58+t35*t3
     1         6*t57+t32*t33*t56+t29*t30*t55+t26*t27*t54+t23*t24*t53+t20
     2         *t21*t52+t16*t18*t51+param(13)
            t63 = 9.305257363491002d-1*t12*t4-9.305257363491002d-1*t4
            t64 = param(36)
            t65 = param(35)
            t66 = param(34)
            t67 = param(33)
            t68 = param(32)
            t69 = param(31)
            t70 = param(30)
            t71 = param(29)
            t72 = param(28)
            t73 = param(27)
            t74 = param(26)
            t75 = t15*t47*t74+t44*t45*t73+t41*t42*t72+t38*t39*t71+t35*t3
     1         6*t70+t32*t33*t69+t29*t30*t68+t26*t27*t67+t23*t24*t66+t20
     2         *t21*t65+t16*t18*t64+param(25)
            t76 = param(48)
            t77 = param(47)
            t78 = param(46)
            t79 = param(45)
            t80 = param(44)
            t81 = param(43)
            t82 = param(42)
            t83 = param(41)
            t84 = param(40)
            t85 = param(39)
            t86 = param(38)
            t87 = t15*t47*t86+t44*t45*t85+t41*t42*t84+t38*t39*t83+t35*t3
     1         6*t82+t32*t33*t81+t29*t30*t80+t26*t27*t79+t23*t24*t78+t20
     2         *t21*t77+t16*t18*t76+param(37)
            t88 = 1/t17**12
            t89 = 1/t2**2
            t90 = 1/rhoa**2.3333333333333334d+0
            t91 = 1/t4
            t92 = 1/rhoa**2
            t93 = 1.4253138205893576d-2*t11*t91-4.275941461768073d-2*t6*
     1         (-2.63857249068588d-4*t92+t10*(2.63857249068588d-4*t92-4.
     2         2759414617680735d-2*t91)+6.41391219265211d-2*t91+2.078814
     3         4478510684d+1*t10/t9-1.6205510657228786d+2*t10*t6*t8)
            t94 = 1/rhoa**3.6666666666666664d+0
            t95 = 9.305257363491002d-1*t4*t93+1.2407009817988002d+0*t12*
     1         t5-1.2407009817988002d+0*t5
            fnc(iq) = 2.0d+0*(t50*t63*t87+t3*t63*t75-9.305257363491002d-
     1         1*t12*t4*t50*t62-9.305257363491002d-1*t12*t3*t4*t48)*wght
     2         +fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(t50*t87*t95+t3*t75*t95-9.6322790007
     1         46596d-3*gammaaa*t63*t75*t89*t94-5.417385299101419d-3*gam
     2         maaa*t49*t63*t87*t94-9.305257363491002d-1*t4*t50*t62*t93-
     3         9.305257363491002d-1*t3*t4*t48*t93+8.963083509889702d-3*g
     4         ammaaa*t12*t48*t89*t90+5.041016444533138d-3*gammaaa*t12*t
     5         49*t62*t90+t50*t63*(-1.6711932865267184d+2*t16*t76*t88*t9
     6         +1.5192666241151986d+1*t47*t86*t9-1.5192666241151986d+1*t
     7         15*t45*t86*t9+3.038533248230397d+1*t15*t45*t85*t9-3.03853
     8         3248230397d+1*t42*t44*t85*t9+4.5577998723455965d+1*t42*t4
     9         4*t84*t9-4.5577998723455965d+1*t39*t41*t84*t9+6.077066496
     :         460795d+1*t39*t41*t83*t9-6.077066496460795d+1*t36*t38*t83
     ;         *t9+7.596333120575993d+1*t36*t38*t82*t9-7.596333120575993
     <         d+1*t33*t35*t82*t9+9.115599744691193d+1*t33*t35*t81*t9-9.
     =         115599744691193d+1*t30*t32*t81*t9+1.0634866368806391d+2*t
     >         30*t32*t80*t9-1.0634866368806391d+2*t27*t29*t80*t9+1.2154
     ?         132992921589d+2*t27*t29*t79*t9-1.2154132992921589d+2*t24*
     @         t26*t79*t9+1.3673399617036788d+2*t24*t26*t78*t9-1.3673399
     1         617036788d+2*t21*t23*t78*t9+1.5192666241151986d+2*t21*t23
     2         *t77*t9-1.5192666241151986d+2*t18*t20*t77*t9+1.6711932865
     3         267184d+2*t18*t20*t76*t9)+t3*t63*(-1.6711932865267184d+2*
     4         t16*t64*t88*t9+1.5192666241151986d+1*t47*t74*t9-1.5192666
     5         241151986d+1*t15*t45*t74*t9+3.038533248230397d+1*t15*t45*
     6         t73*t9-3.038533248230397d+1*t42*t44*t73*t9+4.557799872345
     7         5965d+1*t42*t44*t72*t9-4.5577998723455965d+1*t39*t41*t72*
     8         t9+6.077066496460795d+1*t39*t41*t71*t9-6.077066496460795d
     9         +1*t36*t38*t71*t9+7.596333120575993d+1*t36*t38*t70*t9-7.5
     :         96333120575993d+1*t33*t35*t70*t9+9.115599744691193d+1*t33
     ;         *t35*t69*t9-9.115599744691193d+1*t30*t32*t69*t9+1.0634866
     <         368806391d+2*t30*t32*t68*t9-1.0634866368806391d+2*t27*t29
     =         *t68*t9+1.2154132992921589d+2*t27*t29*t67*t9-1.2154132992
     >         921589d+2*t24*t26*t67*t9+1.3673399617036788d+2*t24*t26*t6
     ?         6*t9-1.3673399617036788d+2*t21*t23*t66*t9+1.5192666241151
     @         986d+2*t21*t23*t65*t9-1.5192666241151986d+2*t18*t20*t65*t
     1         9+1.6711932865267184d+2*t18*t20*t64*t9)-9.305257363491002
     2         d-1*t12*t4*t50*(-1.6711932865267184d+2*t16*t51*t88*t9+1.5
     3         192666241151986d+1*t47*t61*t9-1.5192666241151986d+1*t15*t
     4         45*t61*t9+3.038533248230397d+1*t15*t45*t60*t9-3.038533248
     5         230397d+1*t42*t44*t60*t9+4.5577998723455965d+1*t42*t44*t5
     6         9*t9-4.5577998723455965d+1*t39*t41*t59*t9+6.0770664964607
     7         95d+1*t39*t41*t58*t9-6.077066496460795d+1*t36*t38*t58*t9+
     8         7.596333120575993d+1*t36*t38*t57*t9-7.596333120575993d+1*
     9         t33*t35*t57*t9+9.115599744691193d+1*t33*t35*t56*t9-9.1155
     :         99744691193d+1*t30*t32*t56*t9+1.0634866368806391d+2*t30*t
     ;         32*t55*t9-1.0634866368806391d+2*t27*t29*t55*t9+1.21541329
     <         92921589d+2*t27*t29*t54*t9-1.2154132992921589d+2*t24*t26*
     =         t54*t9+1.3673399617036788d+2*t24*t26*t53*t9-1.36733996170
     >         36788d+2*t21*t23*t53*t9+1.5192666241151986d+2*t21*t23*t52
     ?         *t9-1.5192666241151986d+2*t18*t20*t52*t9+1.67119328652671
     @         84d+2*t18*t20*t51*t9)-9.305257363491002d-1*t12*t3*t4*(-1.
     1         6711932865267184d+2*t13*t16*t88*t9+1.5192666241151986d+1*
     2         t46*t47*t9-1.5192666241151986d+1*t15*t45*t46*t9+3.0385332
     3         48230397d+1*t15*t43*t45*t9-3.038533248230397d+1*t42*t43*t
     4         44*t9+4.5577998723455965d+1*t40*t42*t44*t9-4.557799872345
     5         5965d+1*t39*t40*t41*t9+6.077066496460795d+1*t37*t39*t41*t
     6         9-6.077066496460795d+1*t36*t37*t38*t9+7.596333120575993d+
     7         1*t34*t36*t38*t9-7.596333120575993d+1*t33*t34*t35*t9+9.11
     8         5599744691193d+1*t31*t33*t35*t9-9.115599744691193d+1*t30*
     9         t31*t32*t9+1.0634866368806391d+2*t28*t30*t32*t9-1.0634866
     :         368806391d+2*t27*t28*t29*t9+1.2154132992921589d+2*t25*t27
     ;         *t29*t9-1.2154132992921589d+2*t24*t25*t26*t9+1.3673399617
     <         036788d+2*t22*t24*t26*t9-1.3673399617036788d+2*t21*t22*t2
     =         3*t9+1.5192666241151986d+2*t19*t21*t23*t9-1.5192666241151
     >         986d+2*t18*t19*t20*t9+1.6711932865267184d+2*t13*t18*t20*t
     ?         9)-1.2407009817988002d+0*t12*t5*t50*t62-1.240700981798800
     @         2d+0*t12*t3*t48*t5)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(-3.361156316208638d-3*t12*t48*t89*
     1         t91-1.890381166699927d-3*t12*t49*t62*t91+3.61210462527997
     2         4d-3*t1*t63*t75*t89+2.0315194871630324d-3*t1*t49*t63*t87)
     3         *wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Mmat(iq,D1_TA) = 1.0d+0*(t50*t63*(-2.2d+1*t16*t76*t88-2.0d+0
     1         *t47*t86-2.0d+0*t15*t45*t86-4.0d+0*t15*t45*t85-4.0d+0*t42
     2         *t44*t85-6.0d+0*t42*t44*t84-6.0d+0*t39*t41*t84-8.0d+0*t39
     3         *t41*t83-8.0d+0*t36*t38*t83-1.0d+1*t36*t38*t82-1.0d+1*t33
     4         *t35*t82-1.2d+1*t33*t35*t81-1.2d+1*t30*t32*t81-1.4d+1*t30
     5         *t32*t80-1.4d+1*t27*t29*t80-1.6d+1*t27*t29*t79-1.6d+1*t24
     6         *t26*t79-1.8d+1*t24*t26*t78-1.8d+1*t21*t23*t78-2.0d+1*t21
     7         *t23*t77-2.0d+1*t18*t20*t77-2.2d+1*t18*t20*t76)+t3*t63*(-
     8         2.2d+1*t16*t64*t88-2.0d+0*t47*t74-2.0d+0*t15*t45*t74-4.0d
     9         +0*t15*t45*t73-4.0d+0*t42*t44*t73-6.0d+0*t42*t44*t72-6.0d
     :         +0*t39*t41*t72-8.0d+0*t39*t41*t71-8.0d+0*t36*t38*t71-1.0d
     ;         +1*t36*t38*t70-1.0d+1*t33*t35*t70-1.2d+1*t33*t35*t69-1.2d
     <         +1*t30*t32*t69-1.4d+1*t30*t32*t68-1.4d+1*t27*t29*t68-1.6d
     =         +1*t27*t29*t67-1.6d+1*t24*t26*t67-1.8d+1*t24*t26*t66-1.8d
     >         +1*t21*t23*t66-2.0d+1*t21*t23*t65-2.0d+1*t18*t20*t65-2.2d
     ?         +1*t18*t20*t64)-9.305257363491002d-1*t12*t4*t50*(-2.2d+1*
     @         t16*t51*t88-2.0d+0*t47*t61-2.0d+0*t15*t45*t61-4.0d+0*t15*
     1         t45*t60-4.0d+0*t42*t44*t60-6.0d+0*t42*t44*t59-6.0d+0*t39*
     2         t41*t59-8.0d+0*t39*t41*t58-8.0d+0*t36*t38*t58-1.0d+1*t36*
     3         t38*t57-1.0d+1*t33*t35*t57-1.2d+1*t33*t35*t56-1.2d+1*t30*
     4         t32*t56-1.4d+1*t30*t32*t55-1.4d+1*t27*t29*t55-1.6d+1*t27*
     5         t29*t54-1.6d+1*t24*t26*t54-1.8d+1*t24*t26*t53-1.8d+1*t21*
     6         t23*t53-2.0d+1*t21*t23*t52-2.0d+1*t18*t20*t52-2.2d+1*t18*
     7         t20*t51)-9.305257363491002d-1*t12*t3*t4*(-2.2d+1*t13*t16*
     8         t88-2.0d+0*t46*t47-2.0d+0*t15*t45*t46-4.0d+0*t15*t43*t45-
     9         4.0d+0*t42*t43*t44-6.0d+0*t40*t42*t44-6.0d+0*t39*t40*t41-
     :         8.0d+0*t37*t39*t41-8.0d+0*t36*t37*t38-1.0d+1*t34*t36*t38-
     ;         1.0d+1*t33*t34*t35-1.2d+1*t31*t33*t35-1.2d+1*t30*t31*t32-
     <         1.4d+1*t28*t30*t32-1.4d+1*t27*t28*t29-1.6d+1*t25*t27*t29-
     =         1.6d+1*t24*t25*t26-1.8d+1*t22*t24*t26-1.8d+1*t21*t22*t23-
     >         2.0d+1*t19*t21*t23-2.0d+1*t18*t19*t20-2.2d+1*t13*t18*t20)
     ?         )*wght+Mmat(iq,D1_TA)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = rhoa**3.333333333333333d-1
            t6 = 1/t5
            t7 = 1/rhoa
            t8 = 1.282782438530422d-1*t6-2.63857249068588d-4*t7
            t9 = rhoa**6.666666666666666d-1
            t10 = exp(-2.4308265985843178d+2*t9)
            t11 = t10*t8+2.63857249068588d-4*t7-1.924173657795633d-1*t6+
     1         3.544907701811032d+0*erf(1.5591108358883013d+1*t5)
            t12 = 1.0d+0-4.275941461768073d-2*t11*t6
            t13 = param(1)
            t14 = param(12)
            t15 = 9.115599744691192d+0*rhoa**1.6666666666666669d+0
            t16 = t15-2.0d+0*taua
            t17 = t16**11
            t18 = 2.0d+0*taua+t15
            t19 = 1/t18**11
            t20 = param(11)
            t21 = t16**10
            t22 = 1/t18**10
            t23 = param(10)
            t24 = t16**9
            t25 = 1/t18**9
            t26 = param(9)
            t27 = t16**8
            t28 = 1/t18**8
            t29 = param(8)
            t30 = t16**7
            t31 = 1/t18**7
            t32 = param(7)
            t33 = t16**6
            t34 = 1/t18**6
            t35 = param(6)
            t36 = t16**5
            t37 = 1/t18**5
            t38 = param(5)
            t39 = t16**4
            t40 = 1/t18**4
            t41 = param(4)
            t42 = t16**3
            t43 = 1/t18**3
            t44 = param(3)
            t45 = t16**2
            t46 = 1/t18**2
            t47 = param(2)
            t48 = 1/t18
            t49 = t16*t47*t48+t44*t45*t46+t41*t42*t43+t38*t39*t40+t35*t3
     1         6*t37+t32*t33*t34+t29*t30*t31+t26*t27*t28+t23*t24*t25+t20
     2         *t21*t22+t14*t17*t19+t13
            t50 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t51 = 5.52d-1*(1.0d+0-t50)+1.0d+0
            t52 = param(13)
            t53 = param(24)
            t54 = param(23)
            t55 = param(22)
            t56 = param(21)
            t57 = param(20)
            t58 = param(19)
            t59 = param(18)
            t60 = param(17)
            t61 = param(16)
            t62 = param(15)
            t63 = param(14)
            t64 = t16*t48*t63+t45*t46*t62+t42*t43*t61+t39*t40*t60+t36*t3
     1         7*t59+t33*t34*t58+t30*t31*t57+t27*t28*t56+t24*t25*t55+t21
     2         *t22*t54+t17*t19*t53+t52
            t65 = 9.305257363491002d-1*t12*t4-9.305257363491002d-1*t4
            t66 = param(25)
            t67 = param(36)
            t68 = param(35)
            t69 = param(34)
            t70 = param(33)
            t71 = param(32)
            t72 = param(31)
            t73 = param(30)
            t74 = param(29)
            t75 = param(28)
            t76 = param(27)
            t77 = param(26)
            t78 = t16*t48*t77+t45*t46*t76+t42*t43*t75+t39*t40*t74+t36*t3
     1         7*t73+t33*t34*t72+t30*t31*t71+t27*t28*t70+t24*t25*t69+t21
     2         *t22*t68+t17*t19*t67+t66
            t79 = param(37)
            t80 = param(48)
            t81 = param(47)
            t82 = param(46)
            t83 = param(45)
            t84 = param(44)
            t85 = param(43)
            t86 = param(42)
            t87 = param(41)
            t88 = param(40)
            t89 = param(39)
            t90 = param(38)
            t91 = t16*t48*t90+t45*t46*t89+t42*t43*t88+t39*t40*t87+t36*t3
     1         7*t86+t33*t34*t85+t30*t31*t84+t27*t28*t83+t24*t25*t82+t21
     2         *t22*t81+t17*t19*t80+t79
            t92 = 1/rhob**2.6666666666666666d+0
            t93 = 4.492667444378077d-3*gammabb*t92+1.0d+0
            t94 = 8.04d-1*(1.0d+0-1.0d+0/t93)+1.0d+0
            t95 = rhob**1.3333333333333333d+0
            t96 = rhob**3.333333333333333d-1
            t97 = 1/t96
            t98 = 1/rhob
            t99 = 1.282782438530422d-1*t97-2.63857249068588d-4*t98
            t100 = rhob**6.666666666666666d-1
            t101 = exp(-2.4308265985843178d+2*t100)
            t102 = t101*t99+2.63857249068588d-4*t98-1.924173657795633d-1
     1         *t97+3.544907701811032d+0*erf(1.5591108358883013d+1*t96)
            t103 = 1.0d+0-4.275941461768073d-2*t102*t97
            t104 = 9.115599744691192d+0*rhob**1.6666666666666669d+0
            t105 = t104-2.0d+0*taub
            t106 = t105**11
            t107 = 2.0d+0*taub+t104
            t108 = 1/t107**11
            t109 = t105**10
            t110 = 1/t107**10
            t111 = t105**9
            t112 = 1/t107**9
            t113 = t105**8
            t114 = 1/t107**8
            t115 = t105**7
            t116 = 1/t107**7
            t117 = t105**6
            t118 = 1/t107**6
            t119 = t105**5
            t120 = 1/t107**5
            t121 = t105**4
            t122 = 1/t107**4
            t123 = t105**3
            t124 = 1/t107**3
            t125 = t105**2
            t126 = 1/t107**2
            t127 = 1/t107
            t128 = t105*t127*t47+t125*t126*t44+t123*t124*t41+t121*t122*t
     1         38+t119*t120*t35+t117*t118*t32+t115*t116*t29+t113*t114*t2
     2         6+t111*t112*t23+t109*t110*t20+t106*t108*t14+t13
            t129 = exp(-3.6802889260199856d-3*gammabb*t92)
            t130 = 5.52d-1*(1.0d+0-t129)+1.0d+0
            t131 = t105*t127*t63+t125*t126*t62+t123*t124*t61+t121*t122*t
     1         60+t119*t120*t59+t117*t118*t58+t115*t116*t57+t113*t114*t5
     2         6+t111*t112*t55+t109*t110*t54+t106*t108*t53+t52
            t132 = 9.305257363491002d-1*t103*t95-9.305257363491002d-1*t9
     1         5
            t133 = t105*t127*t77+t125*t126*t76+t123*t124*t75+t121*t122*t
     1         74+t119*t120*t73+t117*t118*t72+t115*t116*t71+t113*t114*t7
     2         0+t111*t112*t69+t109*t110*t68+t106*t108*t67+t66
            t134 = t105*t127*t90+t125*t126*t89+t123*t124*t88+t121*t122*t
     1         87+t119*t120*t86+t117*t118*t85+t115*t116*t84+t113*t114*t8
     2         3+t111*t112*t82+t109*t110*t81+t106*t108*t80+t79
            t135 = 1/t18**12
            t136 = 1/t2**2
            t137 = 1/rhoa**2.3333333333333334d+0
            t138 = 1/t4
            t139 = 1/rhoa**2
            t140 = 5.641895835477563d-1
            t141 = 1.4253138205893576d-2*t11*t138-4.275941461768073d-2*t
     1         6*(3.6846026734116505d+1*t10*t140/t9-1.6205510657228786d+
     2         2*t10*t6*t8-2.63857249068588d-4*t139+t10*(2.6385724906858
     3         8d-4*t139-4.2759414617680735d-2*t138)+6.41391219265211d-2
     4         *t138)
            t142 = 1/rhoa**3.6666666666666664d+0
            t143 = 1.2407009817988002d+0*t12*t5-1.2407009817988002d+0*t5
     1         +9.305257363491002d-1*t141*t4
            t144 = 1/t107**12
            t145 = 1/t93**2
            t146 = 1/rhob**2.3333333333333334d+0
            t147 = 1/t95
            t148 = 1/rhob**2
            t149 = 1.4253138205893576d-2*t102*t147-4.275941461768073d-2*
     1         t97*(-1.6205510657228786d+2*t101*t97*t99-2.63857249068588
     2         d-4*t148+t101*(2.63857249068588d-4*t148-4.275941461768073
     3         5d-2*t147)+6.41391219265211d-2*t147+3.6846026734116505d+1
     4         *t101*t140/t100)
            t150 = 1/rhob**3.6666666666666664d+0
            t151 = 1.2407009817988002d+0*t103*t96-1.2407009817988002d+0*
     1         t96+9.305257363491002d-1*t149*t95
            fnc(iq) = (1.0d+0*(-9.305257363491002d-1*t103*t128*t94*t95-9
     1         .305257363491002d-1*t103*t130*t131*t95+t132*t133*t94+t130
     2         *t132*t134)+1.0d+0*(t51*t65*t91+t3*t65*t78-9.305257363491
     3         002d-1*t12*t4*t51*t64-9.305257363491002d-1*t12*t3*t4*t49)
     4         )*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(-5.417385299101419d-3*gammaaa*t142*
     1         t50*t65*t91+t143*t51*t91+t51*t65*(1.5192666241151986d+1*t
     2         48*t9*t90-1.5192666241151986d+1*t16*t46*t9*t90+3.03853324
     3         8230397d+1*t16*t46*t89*t9-3.038533248230397d+1*t43*t45*t8
     4         9*t9+4.5577998723455965d+1*t43*t45*t88*t9-4.5577998723455
     5         965d+1*t40*t42*t88*t9+6.077066496460795d+1*t40*t42*t87*t9
     6         -6.077066496460795d+1*t37*t39*t87*t9+7.596333120575993d+1
     7         *t37*t39*t86*t9-7.596333120575993d+1*t34*t36*t86*t9+9.115
     8         599744691193d+1*t34*t36*t85*t9-9.115599744691193d+1*t31*t
     9         33*t85*t9+1.0634866368806391d+2*t31*t33*t84*t9-1.06348663
     :         68806391d+2*t28*t30*t84*t9+1.2154132992921589d+2*t28*t30*
     ;         t83*t9-1.2154132992921589d+2*t25*t27*t83*t9+1.36733996170
     <         36788d+2*t25*t27*t82*t9-1.3673399617036788d+2*t22*t24*t82
     =         *t9+1.5192666241151986d+2*t22*t24*t81*t9-1.51926662411519
     >         86d+2*t19*t21*t81*t9+1.6711932865267184d+2*t19*t21*t80*t9
     ?         -1.6711932865267184d+2*t135*t17*t80*t9)+t3*t65*(1.5192666
     @         241151986d+1*t48*t77*t9-1.5192666241151986d+1*t16*t46*t77
     1         *t9+3.038533248230397d+1*t16*t46*t76*t9-3.038533248230397
     2         d+1*t43*t45*t76*t9+4.5577998723455965d+1*t43*t45*t75*t9-4
     3         .5577998723455965d+1*t40*t42*t75*t9+6.077066496460795d+1*
     4         t40*t42*t74*t9-6.077066496460795d+1*t37*t39*t74*t9+7.5963
     5         33120575993d+1*t37*t39*t73*t9-7.596333120575993d+1*t34*t3
     6         6*t73*t9+9.115599744691193d+1*t34*t36*t72*t9-9.1155997446
     7         91193d+1*t31*t33*t72*t9+1.0634866368806391d+2*t31*t33*t71
     8         *t9-1.0634866368806391d+2*t28*t30*t71*t9+1.21541329929215
     9         89d+2*t28*t30*t70*t9-1.2154132992921589d+2*t25*t27*t70*t9
     :         +1.3673399617036788d+2*t25*t27*t69*t9-1.3673399617036788d
     ;         +2*t22*t24*t69*t9+1.5192666241151986d+2*t22*t24*t68*t9-1.
     <         5192666241151986d+2*t19*t21*t68*t9+1.6711932865267184d+2*
     =         t19*t21*t67*t9-1.6711932865267184d+2*t135*t17*t67*t9)-9.3
     >         05257363491002d-1*t12*t4*t51*(1.5192666241151986d+1*t48*t
     ?         63*t9-1.5192666241151986d+1*t16*t46*t63*t9+3.038533248230
     @         397d+1*t16*t46*t62*t9-3.038533248230397d+1*t43*t45*t62*t9
     1         +4.5577998723455965d+1*t43*t45*t61*t9-4.5577998723455965d
     2         +1*t40*t42*t61*t9+6.077066496460795d+1*t40*t42*t60*t9-6.0
     3         77066496460795d+1*t37*t39*t60*t9+7.596333120575993d+1*t37
     4         *t39*t59*t9-7.596333120575993d+1*t34*t36*t59*t9+9.1155997
     5         44691193d+1*t34*t36*t58*t9-9.115599744691193d+1*t31*t33*t
     6         58*t9+1.0634866368806391d+2*t31*t33*t57*t9-1.063486636880
     7         6391d+2*t28*t30*t57*t9+1.2154132992921589d+2*t28*t30*t56*
     8         t9-1.2154132992921589d+2*t25*t27*t56*t9+1.367339961703678
     9         8d+2*t25*t27*t55*t9-1.3673399617036788d+2*t22*t24*t55*t9+
     :         1.5192666241151986d+2*t22*t24*t54*t9-1.5192666241151986d+
     ;         2*t19*t21*t54*t9+1.6711932865267184d+2*t19*t21*t53*t9-1.6
     <         711932865267184d+2*t135*t17*t53*t9)-9.305257363491002d-1*
     =         t12*t3*t4*(1.5192666241151986d+1*t47*t48*t9-1.51926662411
     >         51986d+1*t16*t46*t47*t9+3.038533248230397d+1*t16*t44*t46*
     ?         t9-3.038533248230397d+1*t43*t44*t45*t9+4.5577998723455965
     @         d+1*t41*t43*t45*t9-4.5577998723455965d+1*t40*t41*t42*t9+6
     1         .077066496460795d+1*t38*t40*t42*t9-6.077066496460795d+1*t
     2         37*t38*t39*t9+7.596333120575993d+1*t35*t37*t39*t9-7.59633
     3         3120575993d+1*t34*t35*t36*t9+9.115599744691193d+1*t32*t34
     4         *t36*t9-9.115599744691193d+1*t31*t32*t33*t9+1.06348663688
     5         06391d+2*t29*t31*t33*t9-1.0634866368806391d+2*t28*t29*t30
     6         *t9+1.2154132992921589d+2*t26*t28*t30*t9-1.21541329929215
     7         89d+2*t25*t26*t27*t9+1.3673399617036788d+2*t23*t25*t27*t9
     8         -1.3673399617036788d+2*t22*t23*t24*t9+1.5192666241151986d
     9         +2*t20*t22*t24*t9-1.5192666241151986d+2*t19*t20*t21*t9+1.
     :         6711932865267184d+2*t14*t19*t21*t9-1.6711932865267184d+2*
     ;         t135*t14*t17*t9)-9.632279000746596d-3*gammaaa*t136*t142*t
     <         65*t78+t143*t3*t78-1.2407009817988002d+0*t12*t5*t51*t64-9
     =         .305257363491002d-1*t141*t4*t51*t64+5.041016444533138d-3*
     >         gammaaa*t12*t137*t50*t64-1.2407009817988002d+0*t12*t3*t49
     ?         *t5-9.305257363491002d-1*t141*t3*t4*t49+8.963083509889702
     @         d-3*gammaaa*t12*t136*t137*t49)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*(-1.2407009817988002d+0*t103*t128*t9
     1         4*t96-1.2407009817988002d+0*t103*t130*t131*t96-9.30525736
     2         3491002d-1*t103*(1.5192666241151986d+1*t100*t127*t47-1.51
     3         92666241151986d+1*t100*t105*t126*t47+3.038533248230397d+1
     4         *t100*t105*t126*t44-3.038533248230397d+1*t100*t124*t125*t
     5         44+4.5577998723455965d+1*t100*t124*t125*t41-4.55779987234
     6         55965d+1*t100*t122*t123*t41+6.077066496460795d+1*t100*t12
     7         2*t123*t38-6.077066496460795d+1*t100*t120*t121*t38+7.5963
     8         33120575993d+1*t100*t120*t121*t35-7.596333120575993d+1*t1
     9         00*t118*t119*t35+9.115599744691193d+1*t100*t118*t119*t32-
     :         9.115599744691193d+1*t100*t116*t117*t32+1.063486636880639
     ;         1d+2*t100*t116*t117*t29-1.0634866368806391d+2*t100*t114*t
     <         115*t29+1.2154132992921589d+2*t100*t114*t115*t26-1.215413
     =         2992921589d+2*t100*t112*t113*t26+1.3673399617036788d+2*t1
     >         00*t112*t113*t23-1.3673399617036788d+2*t100*t110*t111*t23
     ?         +1.5192666241151986d+2*t100*t110*t111*t20-1.5192666241151
     @         986d+2*t100*t108*t109*t20-1.6711932865267184d+2*t100*t106
     1         *t14*t144+1.6711932865267184d+2*t100*t108*t109*t14)*t94*t
     2         95-9.305257363491002d-1*t128*t149*t94*t95-9.3052573634910
     3         02d-1*t103*t130*(1.5192666241151986d+1*t100*t127*t63-1.51
     4         92666241151986d+1*t100*t105*t126*t63+3.038533248230397d+1
     5         *t100*t105*t126*t62-3.038533248230397d+1*t100*t124*t125*t
     6         62+4.5577998723455965d+1*t100*t124*t125*t61-4.55779987234
     7         55965d+1*t100*t122*t123*t61+6.077066496460795d+1*t100*t12
     8         2*t123*t60-6.077066496460795d+1*t100*t120*t121*t60+7.5963
     9         33120575993d+1*t100*t120*t121*t59-7.596333120575993d+1*t1
     :         00*t118*t119*t59+9.115599744691193d+1*t100*t118*t119*t58-
     ;         9.115599744691193d+1*t100*t116*t117*t58+1.063486636880639
     <         1d+2*t100*t116*t117*t57-1.0634866368806391d+2*t100*t114*t
     =         115*t57+1.2154132992921589d+2*t100*t114*t115*t56-1.215413
     >         2992921589d+2*t100*t112*t113*t56+1.3673399617036788d+2*t1
     ?         00*t112*t113*t55-1.3673399617036788d+2*t100*t110*t111*t55
     @         +1.5192666241151986d+2*t100*t110*t111*t54-1.5192666241151
     1         986d+2*t100*t108*t109*t54-1.6711932865267184d+2*t100*t106
     2         *t144*t53+1.6711932865267184d+2*t100*t108*t109*t53)*t95-9
     3         .305257363491002d-1*t130*t131*t149*t95+t132*(1.5192666241
     4         151986d+1*t100*t127*t77-1.5192666241151986d+1*t100*t105*t
     5         126*t77+3.038533248230397d+1*t100*t105*t126*t76-3.0385332
     6         48230397d+1*t100*t124*t125*t76+4.5577998723455965d+1*t100
     7         *t124*t125*t75-4.5577998723455965d+1*t100*t122*t123*t75+6
     8         .077066496460795d+1*t100*t122*t123*t74-6.077066496460795d
     9         +1*t100*t120*t121*t74+7.596333120575993d+1*t100*t120*t121
     :         *t73-7.596333120575993d+1*t100*t118*t119*t73+9.1155997446
     ;         91193d+1*t100*t118*t119*t72-9.115599744691193d+1*t100*t11
     <         6*t117*t72+1.0634866368806391d+2*t100*t116*t117*t71-1.063
     =         4866368806391d+2*t100*t114*t115*t71+1.2154132992921589d+2
     >         *t100*t114*t115*t70-1.2154132992921589d+2*t100*t112*t113*
     ?         t70+1.3673399617036788d+2*t100*t112*t113*t69-1.3673399617
     @         036788d+2*t100*t110*t111*t69+1.5192666241151986d+2*t100*t
     1         110*t111*t68-1.5192666241151986d+2*t100*t108*t109*t68-1.6
     2         711932865267184d+2*t100*t106*t144*t67+1.6711932865267184d
     3         +2*t100*t108*t109*t67)*t94+t133*t151*t94+t130*t132*(1.519
     4         2666241151986d+1*t100*t127*t90-1.5192666241151986d+1*t100
     5         *t105*t126*t90+3.038533248230397d+1*t100*t105*t126*t89-3.
     6         038533248230397d+1*t100*t124*t125*t89+4.5577998723455965d
     7         +1*t100*t124*t125*t88-4.5577998723455965d+1*t100*t122*t12
     8         3*t88+6.077066496460795d+1*t100*t122*t123*t87-6.077066496
     9         460795d+1*t100*t120*t121*t87+7.596333120575993d+1*t100*t1
     :         20*t121*t86-7.596333120575993d+1*t100*t118*t119*t86+9.115
     ;         599744691193d+1*t100*t118*t119*t85-9.115599744691193d+1*t
     <         100*t116*t117*t85+1.0634866368806391d+2*t100*t116*t117*t8
     =         4-1.0634866368806391d+2*t100*t114*t115*t84+1.215413299292
     >         1589d+2*t100*t114*t115*t83-1.2154132992921589d+2*t100*t11
     ?         2*t113*t83+1.3673399617036788d+2*t100*t112*t113*t82-1.367
     @         3399617036788d+2*t100*t110*t111*t82+1.5192666241151986d+2
     1         *t100*t110*t111*t81-1.5192666241151986d+2*t100*t108*t109*
     2         t81-1.6711932865267184d+2*t100*t106*t144*t80+1.6711932865
     3         267184d+2*t100*t108*t109*t80)+t130*t134*t151-9.6322790007
     4         46596d-3*gammabb*t132*t133*t145*t150-5.417385299101419d-3
     5         *gammabb*t129*t132*t134*t150+8.963083509889702d-3*gammabb
     6         *t103*t128*t145*t146+5.041016444533138d-3*gammabb*t103*t1
     7         29*t131*t146)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = 1.0d+0*(2.0315194871630324d-3*t1*t50*t65*t
     1         91+3.612104625279974d-3*t1*t136*t65*t78-1.890381166699927
     2         d-3*t12*t138*t50*t64-3.361156316208638d-3*t12*t136*t138*t
     3         49)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = 1.0d+0*(3.612104625279974d-3*t132*t133*t14
     1         5*t92+2.0315194871630324d-3*t129*t132*t134*t92-3.36115631
     2         6208638d-3*t103*t128*t145*t147-1.890381166699927d-3*t103*
     3         t129*t131*t147)*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TA) = 1.0d+0*(t51*t65*(-2.0d+0*t48*t90-2.0d+0*t16
     1         *t46*t90-4.0d+0*t16*t46*t89-4.0d+0*t43*t45*t89-6.0d+0*t43
     2         *t45*t88-6.0d+0*t40*t42*t88-8.0d+0*t40*t42*t87-8.0d+0*t37
     3         *t39*t87-1.0d+1*t37*t39*t86-1.0d+1*t34*t36*t86-1.2d+1*t34
     4         *t36*t85-1.2d+1*t31*t33*t85-1.4d+1*t31*t33*t84-1.4d+1*t28
     5         *t30*t84-1.6d+1*t28*t30*t83-1.6d+1*t25*t27*t83-1.8d+1*t25
     6         *t27*t82-1.8d+1*t22*t24*t82-2.0d+1*t22*t24*t81-2.0d+1*t19
     7         *t21*t81-2.2d+1*t19*t21*t80-2.2d+1*t135*t17*t80)+t3*t65*(
     8         -2.0d+0*t48*t77-2.0d+0*t16*t46*t77-4.0d+0*t16*t46*t76-4.0
     9         d+0*t43*t45*t76-6.0d+0*t43*t45*t75-6.0d+0*t40*t42*t75-8.0
     :         d+0*t40*t42*t74-8.0d+0*t37*t39*t74-1.0d+1*t37*t39*t73-1.0
     ;         d+1*t34*t36*t73-1.2d+1*t34*t36*t72-1.2d+1*t31*t33*t72-1.4
     <         d+1*t31*t33*t71-1.4d+1*t28*t30*t71-1.6d+1*t28*t30*t70-1.6
     =         d+1*t25*t27*t70-1.8d+1*t25*t27*t69-1.8d+1*t22*t24*t69-2.0
     >         d+1*t22*t24*t68-2.0d+1*t19*t21*t68-2.2d+1*t19*t21*t67-2.2
     ?         d+1*t135*t17*t67)-9.305257363491002d-1*t12*t4*t51*(-2.0d+
     @         0*t48*t63-2.0d+0*t16*t46*t63-4.0d+0*t16*t46*t62-4.0d+0*t4
     1         3*t45*t62-6.0d+0*t43*t45*t61-6.0d+0*t40*t42*t61-8.0d+0*t4
     2         0*t42*t60-8.0d+0*t37*t39*t60-1.0d+1*t37*t39*t59-1.0d+1*t3
     3         4*t36*t59-1.2d+1*t34*t36*t58-1.2d+1*t31*t33*t58-1.4d+1*t3
     4         1*t33*t57-1.4d+1*t28*t30*t57-1.6d+1*t28*t30*t56-1.6d+1*t2
     5         5*t27*t56-1.8d+1*t25*t27*t55-1.8d+1*t22*t24*t55-2.0d+1*t2
     6         2*t24*t54-2.0d+1*t19*t21*t54-2.2d+1*t19*t21*t53-2.2d+1*t1
     7         35*t17*t53)-9.305257363491002d-1*t12*t3*t4*(-2.0d+0*t47*t
     8         48-2.0d+0*t16*t46*t47-4.0d+0*t16*t44*t46-4.0d+0*t43*t44*t
     9         45-6.0d+0*t41*t43*t45-6.0d+0*t40*t41*t42-8.0d+0*t38*t40*t
     :         42-8.0d+0*t37*t38*t39-1.0d+1*t35*t37*t39-1.0d+1*t34*t35*t
     ;         36-1.2d+1*t32*t34*t36-1.2d+1*t31*t32*t33-1.4d+1*t29*t31*t
     <         33-1.4d+1*t28*t29*t30-1.6d+1*t26*t28*t30-1.6d+1*t25*t26*t
     =         27-1.8d+1*t23*t25*t27-1.8d+1*t22*t23*t24-2.0d+1*t20*t22*t
     >         24-2.0d+1*t19*t20*t21-2.2d+1*t14*t19*t21-2.2d+1*t135*t14*
     ?         t17))*wght+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = 1.0d+0*(-9.305257363491002d-1*t103*(-2.0d+0
     1         *t127*t47-2.0d+0*t105*t126*t47-4.0d+0*t105*t126*t44-4.0d+
     2         0*t124*t125*t44-6.0d+0*t124*t125*t41-6.0d+0*t122*t123*t41
     3         -8.0d+0*t122*t123*t38-8.0d+0*t120*t121*t38-1.0d+1*t120*t1
     4         21*t35-1.0d+1*t118*t119*t35-1.2d+1*t118*t119*t32-1.2d+1*t
     5         116*t117*t32-1.4d+1*t116*t117*t29-1.4d+1*t114*t115*t29-1.
     6         6d+1*t114*t115*t26-1.6d+1*t112*t113*t26-1.8d+1*t112*t113*
     7         t23-1.8d+1*t110*t111*t23-2.0d+1*t110*t111*t20-2.0d+1*t108
     8         *t109*t20-2.2d+1*t106*t14*t144-2.2d+1*t108*t109*t14)*t94*
     9         t95-9.305257363491002d-1*t103*t130*(-2.0d+0*t127*t63-2.0d
     :         +0*t105*t126*t63-4.0d+0*t105*t126*t62-4.0d+0*t124*t125*t6
     ;         2-6.0d+0*t124*t125*t61-6.0d+0*t122*t123*t61-8.0d+0*t122*t
     <         123*t60-8.0d+0*t120*t121*t60-1.0d+1*t120*t121*t59-1.0d+1*
     =         t118*t119*t59-1.2d+1*t118*t119*t58-1.2d+1*t116*t117*t58-1
     >         .4d+1*t116*t117*t57-1.4d+1*t114*t115*t57-1.6d+1*t114*t115
     ?         *t56-1.6d+1*t112*t113*t56-1.8d+1*t112*t113*t55-1.8d+1*t11
     @         0*t111*t55-2.0d+1*t110*t111*t54-2.0d+1*t108*t109*t54-2.2d
     1         +1*t106*t144*t53-2.2d+1*t108*t109*t53)*t95+t132*(-2.0d+0*
     2         t127*t77-2.0d+0*t105*t126*t77-4.0d+0*t105*t126*t76-4.0d+0
     3         *t124*t125*t76-6.0d+0*t124*t125*t75-6.0d+0*t122*t123*t75-
     4         8.0d+0*t122*t123*t74-8.0d+0*t120*t121*t74-1.0d+1*t120*t12
     5         1*t73-1.0d+1*t118*t119*t73-1.2d+1*t118*t119*t72-1.2d+1*t1
     6         16*t117*t72-1.4d+1*t116*t117*t71-1.4d+1*t114*t115*t71-1.6
     7         d+1*t114*t115*t70-1.6d+1*t112*t113*t70-1.8d+1*t112*t113*t
     8         69-1.8d+1*t110*t111*t69-2.0d+1*t110*t111*t68-2.0d+1*t108*
     9         t109*t68-2.2d+1*t106*t144*t67-2.2d+1*t108*t109*t67)*t94+t
     :         130*t132*(-2.0d+0*t127*t90-2.0d+0*t105*t126*t90-4.0d+0*t1
     ;         05*t126*t89-4.0d+0*t124*t125*t89-6.0d+0*t124*t125*t88-6.0
     <         d+0*t122*t123*t88-8.0d+0*t122*t123*t87-8.0d+0*t120*t121*t
     =         87-1.0d+1*t120*t121*t86-1.0d+1*t118*t119*t86-1.2d+1*t118*
     >         t119*t85-1.2d+1*t116*t117*t85-1.4d+1*t116*t117*t84-1.4d+1
     ?         *t114*t115*t84-1.6d+1*t114*t115*t83-1.6d+1*t112*t113*t83-
     @         1.8d+1*t112*t113*t82-1.8d+1*t110*t111*t82-2.0d+1*t110*t11
     1         1*t81-2.0d+1*t108*t109*t81-2.2d+1*t106*t144*t80-2.2d+1*t1
     2         08*t109*t80))*wght+Mmat(iq,D1_TB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = rhoa**3.333333333333333d-1
            t6 = 1/t5
            t7 = 1/rhoa
            t8 = 1.282782438530422d-1*t6-2.63857249068588d-4*t7
            t9 = rhoa**6.666666666666666d-1
            t10 = exp(-2.4308265985843178d+2*t9)
            t11 = t10*t8+2.63857249068588d-4*t7-1.924173657795633d-1*t6+
     1         3.544907701811032d+0*erf(1.5591108358883013d+1*t5)
            t12 = 1.0d+0-4.275941461768073d-2*t11*t6
            t13 = param(12)
            t14 = 9.115599744691192d+0*rhoa**1.6666666666666669d+0
            t15 = t14-2.0d+0*taua
            t16 = t15**11
            t17 = 2.0d+0*taua+t14
            t18 = 1/t17**11
            t19 = param(11)
            t20 = t15**10
            t21 = 1/t17**10
            t22 = param(10)
            t23 = t15**9
            t24 = 1/t17**9
            t25 = param(9)
            t26 = t15**8
            t27 = 1/t17**8
            t28 = param(8)
            t29 = t15**7
            t30 = 1/t17**7
            t31 = param(7)
            t32 = t15**6
            t33 = 1/t17**6
            t34 = param(6)
            t35 = t15**5
            t36 = 1/t17**5
            t37 = param(5)
            t38 = t15**4
            t39 = 1/t17**4
            t40 = param(4)
            t41 = t15**3
            t42 = 1/t17**3
            t43 = param(3)
            t44 = t15**2
            t45 = 1/t17**2
            t46 = param(2)
            t47 = 1/t17
            t48 = t15*t46*t47+t43*t44*t45+t40*t41*t42+t37*t38*t39+t34*t3
     1         5*t36+t31*t32*t33+t28*t29*t30+t25*t26*t27+t22*t23*t24+t19
     2         *t20*t21+t13*t16*t18+param(1)
            t49 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t50 = 5.52d-1*(1.0d+0-t49)+1.0d+0
            t51 = param(24)
            t52 = param(23)
            t53 = param(22)
            t54 = param(21)
            t55 = param(20)
            t56 = param(19)
            t57 = param(18)
            t58 = param(17)
            t59 = param(16)
            t60 = param(15)
            t61 = param(14)
            t62 = t15*t47*t61+t44*t45*t60+t41*t42*t59+t38*t39*t58+t35*t3
     1         6*t57+t32*t33*t56+t29*t30*t55+t26*t27*t54+t23*t24*t53+t20
     2         *t21*t52+t16*t18*t51+param(13)
            t63 = 9.305257363491002d-1*t12*t4-9.305257363491002d-1*t4
            t64 = param(36)
            t65 = param(35)
            t66 = param(34)
            t67 = param(33)
            t68 = param(32)
            t69 = param(31)
            t70 = param(30)
            t71 = param(29)
            t72 = param(28)
            t73 = param(27)
            t74 = param(26)
            t75 = t15*t47*t74+t44*t45*t73+t41*t42*t72+t38*t39*t71+t35*t3
     1         6*t70+t32*t33*t69+t29*t30*t68+t26*t27*t67+t23*t24*t66+t20
     2         *t21*t65+t16*t18*t64+param(25)
            t76 = param(48)
            t77 = param(47)
            t78 = param(46)
            t79 = param(45)
            t80 = param(44)
            t81 = param(43)
            t82 = param(42)
            t83 = param(41)
            t84 = param(40)
            t85 = param(39)
            t86 = param(38)
            t87 = t15*t47*t86+t44*t45*t85+t41*t42*t84+t38*t39*t83+t35*t3
     1         6*t82+t32*t33*t81+t29*t30*t80+t26*t27*t79+t23*t24*t78+t20
     2         *t21*t77+t16*t18*t76+param(37)
            t88 = 1/t17**12
            t89 = 1/t2**2
            t90 = 1/rhoa**2.3333333333333334d+0
            t91 = 1/t4
            t92 = 1/rhoa**2
            t93 = 1.4253138205893576d-2*t11*t91-4.275941461768073d-2*t6*
     1         (-2.63857249068588d-4*t92+t10*(2.63857249068588d-4*t92-4.
     2         2759414617680735d-2*t91)+6.41391219265211d-2*t91+2.078814
     3         4478510684d+1*t10/t9-1.6205510657228786d+2*t10*t6*t8)
            t94 = 1/rhoa**3.6666666666666664d+0
            t95 = 9.305257363491002d-1*t4*t93+1.2407009817988002d+0*t12*
     1         t5-1.2407009817988002d+0*t5
            fnc(iq) = 1.0d+0*(t50*t63*t87+t3*t63*t75-9.305257363491002d-
     1         1*t12*t4*t50*t62-9.305257363491002d-1*t12*t3*t4*t48)*wght
     2         +fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(t50*t87*t95+t3*t75*t95-9.6322790007
     1         46596d-3*gammaaa*t63*t75*t89*t94-5.417385299101419d-3*gam
     2         maaa*t49*t63*t87*t94-9.305257363491002d-1*t4*t50*t62*t93-
     3         9.305257363491002d-1*t3*t4*t48*t93+8.963083509889702d-3*g
     4         ammaaa*t12*t48*t89*t90+5.041016444533138d-3*gammaaa*t12*t
     5         49*t62*t90+t50*t63*(-1.6711932865267184d+2*t16*t76*t88*t9
     6         +1.5192666241151986d+1*t47*t86*t9-1.5192666241151986d+1*t
     7         15*t45*t86*t9+3.038533248230397d+1*t15*t45*t85*t9-3.03853
     8         3248230397d+1*t42*t44*t85*t9+4.5577998723455965d+1*t42*t4
     9         4*t84*t9-4.5577998723455965d+1*t39*t41*t84*t9+6.077066496
     :         460795d+1*t39*t41*t83*t9-6.077066496460795d+1*t36*t38*t83
     ;         *t9+7.596333120575993d+1*t36*t38*t82*t9-7.596333120575993
     <         d+1*t33*t35*t82*t9+9.115599744691193d+1*t33*t35*t81*t9-9.
     =         115599744691193d+1*t30*t32*t81*t9+1.0634866368806391d+2*t
     >         30*t32*t80*t9-1.0634866368806391d+2*t27*t29*t80*t9+1.2154
     ?         132992921589d+2*t27*t29*t79*t9-1.2154132992921589d+2*t24*
     @         t26*t79*t9+1.3673399617036788d+2*t24*t26*t78*t9-1.3673399
     1         617036788d+2*t21*t23*t78*t9+1.5192666241151986d+2*t21*t23
     2         *t77*t9-1.5192666241151986d+2*t18*t20*t77*t9+1.6711932865
     3         267184d+2*t18*t20*t76*t9)+t3*t63*(-1.6711932865267184d+2*
     4         t16*t64*t88*t9+1.5192666241151986d+1*t47*t74*t9-1.5192666
     5         241151986d+1*t15*t45*t74*t9+3.038533248230397d+1*t15*t45*
     6         t73*t9-3.038533248230397d+1*t42*t44*t73*t9+4.557799872345
     7         5965d+1*t42*t44*t72*t9-4.5577998723455965d+1*t39*t41*t72*
     8         t9+6.077066496460795d+1*t39*t41*t71*t9-6.077066496460795d
     9         +1*t36*t38*t71*t9+7.596333120575993d+1*t36*t38*t70*t9-7.5
     :         96333120575993d+1*t33*t35*t70*t9+9.115599744691193d+1*t33
     ;         *t35*t69*t9-9.115599744691193d+1*t30*t32*t69*t9+1.0634866
     <         368806391d+2*t30*t32*t68*t9-1.0634866368806391d+2*t27*t29
     =         *t68*t9+1.2154132992921589d+2*t27*t29*t67*t9-1.2154132992
     >         921589d+2*t24*t26*t67*t9+1.3673399617036788d+2*t24*t26*t6
     ?         6*t9-1.3673399617036788d+2*t21*t23*t66*t9+1.5192666241151
     @         986d+2*t21*t23*t65*t9-1.5192666241151986d+2*t18*t20*t65*t
     1         9+1.6711932865267184d+2*t18*t20*t64*t9)-9.305257363491002
     2         d-1*t12*t4*t50*(-1.6711932865267184d+2*t16*t51*t88*t9+1.5
     3         192666241151986d+1*t47*t61*t9-1.5192666241151986d+1*t15*t
     4         45*t61*t9+3.038533248230397d+1*t15*t45*t60*t9-3.038533248
     5         230397d+1*t42*t44*t60*t9+4.5577998723455965d+1*t42*t44*t5
     6         9*t9-4.5577998723455965d+1*t39*t41*t59*t9+6.0770664964607
     7         95d+1*t39*t41*t58*t9-6.077066496460795d+1*t36*t38*t58*t9+
     8         7.596333120575993d+1*t36*t38*t57*t9-7.596333120575993d+1*
     9         t33*t35*t57*t9+9.115599744691193d+1*t33*t35*t56*t9-9.1155
     :         99744691193d+1*t30*t32*t56*t9+1.0634866368806391d+2*t30*t
     ;         32*t55*t9-1.0634866368806391d+2*t27*t29*t55*t9+1.21541329
     <         92921589d+2*t27*t29*t54*t9-1.2154132992921589d+2*t24*t26*
     =         t54*t9+1.3673399617036788d+2*t24*t26*t53*t9-1.36733996170
     >         36788d+2*t21*t23*t53*t9+1.5192666241151986d+2*t21*t23*t52
     ?         *t9-1.5192666241151986d+2*t18*t20*t52*t9+1.67119328652671
     @         84d+2*t18*t20*t51*t9)-9.305257363491002d-1*t12*t3*t4*(-1.
     1         6711932865267184d+2*t13*t16*t88*t9+1.5192666241151986d+1*
     2         t46*t47*t9-1.5192666241151986d+1*t15*t45*t46*t9+3.0385332
     3         48230397d+1*t15*t43*t45*t9-3.038533248230397d+1*t42*t43*t
     4         44*t9+4.5577998723455965d+1*t40*t42*t44*t9-4.557799872345
     5         5965d+1*t39*t40*t41*t9+6.077066496460795d+1*t37*t39*t41*t
     6         9-6.077066496460795d+1*t36*t37*t38*t9+7.596333120575993d+
     7         1*t34*t36*t38*t9-7.596333120575993d+1*t33*t34*t35*t9+9.11
     8         5599744691193d+1*t31*t33*t35*t9-9.115599744691193d+1*t30*
     9         t31*t32*t9+1.0634866368806391d+2*t28*t30*t32*t9-1.0634866
     :         368806391d+2*t27*t28*t29*t9+1.2154132992921589d+2*t25*t27
     ;         *t29*t9-1.2154132992921589d+2*t24*t25*t26*t9+1.3673399617
     <         036788d+2*t22*t24*t26*t9-1.3673399617036788d+2*t21*t22*t2
     =         3*t9+1.5192666241151986d+2*t19*t21*t23*t9-1.5192666241151
     >         986d+2*t18*t19*t20*t9+1.6711932865267184d+2*t13*t18*t20*t
     ?         9)-1.2407009817988002d+0*t12*t5*t50*t62-1.240700981798800
     @         2d+0*t12*t3*t48*t5)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(-3.361156316208638d-3*t12*t48*t89*
     1         t91-1.890381166699927d-3*t12*t49*t62*t91+3.61210462527997
     2         4d-3*t1*t63*t75*t89+2.0315194871630324d-3*t1*t49*t63*t87)
     3         *wght+Cmat(iq,D1_GAA)
            Mmat(iq,D1_TA) = 1.0d+0*(t50*t63*(-2.2d+1*t16*t76*t88-2.0d+0
     1         *t47*t86-2.0d+0*t15*t45*t86-4.0d+0*t15*t45*t85-4.0d+0*t42
     2         *t44*t85-6.0d+0*t42*t44*t84-6.0d+0*t39*t41*t84-8.0d+0*t39
     3         *t41*t83-8.0d+0*t36*t38*t83-1.0d+1*t36*t38*t82-1.0d+1*t33
     4         *t35*t82-1.2d+1*t33*t35*t81-1.2d+1*t30*t32*t81-1.4d+1*t30
     5         *t32*t80-1.4d+1*t27*t29*t80-1.6d+1*t27*t29*t79-1.6d+1*t24
     6         *t26*t79-1.8d+1*t24*t26*t78-1.8d+1*t21*t23*t78-2.0d+1*t21
     7         *t23*t77-2.0d+1*t18*t20*t77-2.2d+1*t18*t20*t76)+t3*t63*(-
     8         2.2d+1*t16*t64*t88-2.0d+0*t47*t74-2.0d+0*t15*t45*t74-4.0d
     9         +0*t15*t45*t73-4.0d+0*t42*t44*t73-6.0d+0*t42*t44*t72-6.0d
     :         +0*t39*t41*t72-8.0d+0*t39*t41*t71-8.0d+0*t36*t38*t71-1.0d
     ;         +1*t36*t38*t70-1.0d+1*t33*t35*t70-1.2d+1*t33*t35*t69-1.2d
     <         +1*t30*t32*t69-1.4d+1*t30*t32*t68-1.4d+1*t27*t29*t68-1.6d
     =         +1*t27*t29*t67-1.6d+1*t24*t26*t67-1.8d+1*t24*t26*t66-1.8d
     >         +1*t21*t23*t66-2.0d+1*t21*t23*t65-2.0d+1*t18*t20*t65-2.2d
     ?         +1*t18*t20*t64)-9.305257363491002d-1*t12*t4*t50*(-2.2d+1*
     @         t16*t51*t88-2.0d+0*t47*t61-2.0d+0*t15*t45*t61-4.0d+0*t15*
     1         t45*t60-4.0d+0*t42*t44*t60-6.0d+0*t42*t44*t59-6.0d+0*t39*
     2         t41*t59-8.0d+0*t39*t41*t58-8.0d+0*t36*t38*t58-1.0d+1*t36*
     3         t38*t57-1.0d+1*t33*t35*t57-1.2d+1*t33*t35*t56-1.2d+1*t30*
     4         t32*t56-1.4d+1*t30*t32*t55-1.4d+1*t27*t29*t55-1.6d+1*t27*
     5         t29*t54-1.6d+1*t24*t26*t54-1.8d+1*t24*t26*t53-1.8d+1*t21*
     6         t23*t53-2.0d+1*t21*t23*t52-2.0d+1*t18*t20*t52-2.2d+1*t18*
     7         t20*t51)-9.305257363491002d-1*t12*t3*t4*(-2.2d+1*t13*t16*
     8         t88-2.0d+0*t46*t47-2.0d+0*t15*t45*t46-4.0d+0*t15*t43*t45-
     9         4.0d+0*t42*t43*t44-6.0d+0*t40*t42*t44-6.0d+0*t39*t40*t41-
     :         8.0d+0*t37*t39*t41-8.0d+0*t36*t37*t38-1.0d+1*t34*t36*t38-
     ;         1.0d+1*t33*t34*t35-1.2d+1*t31*t33*t35-1.2d+1*t30*t31*t32-
     <         1.4d+1*t28*t30*t32-1.4d+1*t27*t28*t29-1.6d+1*t25*t27*t29-
     =         1.6d+1*t24*t25*t26-1.8d+1*t22*t24*t26-1.8d+1*t21*t22*t23-
     >         2.0d+1*t19*t21*t23-2.0d+1*t18*t19*t20-2.2d+1*t13*t18*t20)
     ?         )*wght+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhob**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammabb*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhob**1.3333333333333333d+0
            t5 = rhob**3.333333333333333d-1
            t6 = 1/t5
            t7 = 1/rhob
            t8 = 1.282782438530422d-1*t6-2.63857249068588d-4*t7
            t9 = rhob**6.666666666666666d-1
            t10 = exp(-2.4308265985843178d+2*t9)
            t11 = t10*t8+2.63857249068588d-4*t7-1.924173657795633d-1*t6+
     1         3.544907701811032d+0*erf(1.5591108358883013d+1*t5)
            t12 = 1.0d+0-4.275941461768073d-2*t11*t6
            t13 = param(12)
            t14 = 9.115599744691192d+0*rhob**1.6666666666666669d+0
            t15 = t14-2.0d+0*taub
            t16 = t15**11
            t17 = 2.0d+0*taub+t14
            t18 = 1/t17**11
            t19 = param(11)
            t20 = t15**10
            t21 = 1/t17**10
            t22 = param(10)
            t23 = t15**9
            t24 = 1/t17**9
            t25 = param(9)
            t26 = t15**8
            t27 = 1/t17**8
            t28 = param(8)
            t29 = t15**7
            t30 = 1/t17**7
            t31 = param(7)
            t32 = t15**6
            t33 = 1/t17**6
            t34 = param(6)
            t35 = t15**5
            t36 = 1/t17**5
            t37 = param(5)
            t38 = t15**4
            t39 = 1/t17**4
            t40 = param(4)
            t41 = t15**3
            t42 = 1/t17**3
            t43 = param(3)
            t44 = t15**2
            t45 = 1/t17**2
            t46 = param(2)
            t47 = 1/t17
            t48 = t15*t46*t47+t43*t44*t45+t40*t41*t42+t37*t38*t39+t34*t3
     1         5*t36+t31*t32*t33+t28*t29*t30+t25*t26*t27+t22*t23*t24+t19
     2         *t20*t21+t13*t16*t18+param(1)
            t49 = exp(-3.6802889260199856d-3*gammabb*t1)
            t50 = 5.52d-1*(1.0d+0-t49)+1.0d+0
            t51 = param(24)
            t52 = param(23)
            t53 = param(22)
            t54 = param(21)
            t55 = param(20)
            t56 = param(19)
            t57 = param(18)
            t58 = param(17)
            t59 = param(16)
            t60 = param(15)
            t61 = param(14)
            t62 = t15*t47*t61+t44*t45*t60+t41*t42*t59+t38*t39*t58+t35*t3
     1         6*t57+t32*t33*t56+t29*t30*t55+t26*t27*t54+t23*t24*t53+t20
     2         *t21*t52+t16*t18*t51+param(13)
            t63 = 9.305257363491002d-1*t12*t4-9.305257363491002d-1*t4
            t64 = param(36)
            t65 = param(35)
            t66 = param(34)
            t67 = param(33)
            t68 = param(32)
            t69 = param(31)
            t70 = param(30)
            t71 = param(29)
            t72 = param(28)
            t73 = param(27)
            t74 = param(26)
            t75 = t15*t47*t74+t44*t45*t73+t41*t42*t72+t38*t39*t71+t35*t3
     1         6*t70+t32*t33*t69+t29*t30*t68+t26*t27*t67+t23*t24*t66+t20
     2         *t21*t65+t16*t18*t64+param(25)
            t76 = param(48)
            t77 = param(47)
            t78 = param(46)
            t79 = param(45)
            t80 = param(44)
            t81 = param(43)
            t82 = param(42)
            t83 = param(41)
            t84 = param(40)
            t85 = param(39)
            t86 = param(38)
            t87 = t15*t47*t86+t44*t45*t85+t41*t42*t84+t38*t39*t83+t35*t3
     1         6*t82+t32*t33*t81+t29*t30*t80+t26*t27*t79+t23*t24*t78+t20
     2         *t21*t77+t16*t18*t76+param(37)
            t88 = 1/t17**12
            t89 = 1/t2**2
            t90 = 1/rhob**2.3333333333333334d+0
            t91 = 1/t4
            t92 = 1/rhob**2
            t93 = 1.4253138205893576d-2*t11*t91-4.275941461768073d-2*t6*
     1         (-2.63857249068588d-4*t92+t10*(2.63857249068588d-4*t92-4.
     2         2759414617680735d-2*t91)+6.41391219265211d-2*t91+2.078814
     3         4478510684d+1*t10/t9-1.6205510657228786d+2*t10*t6*t8)
            t94 = 1/rhob**3.6666666666666664d+0
            t95 = 9.305257363491002d-1*t4*t93+1.2407009817988002d+0*t12*
     1         t5-1.2407009817988002d+0*t5
            fnc(iq) = 1.0d+0*(t50*t63*t87+t3*t63*t75-9.305257363491002d-
     1         1*t12*t4*t50*t62-9.305257363491002d-1*t12*t3*t4*t48)*wght
     2         +fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*(t50*t87*t95+t3*t75*t95-9.6322790007
     1         46596d-3*gammabb*t63*t75*t89*t94-5.417385299101419d-3*gam
     2         mabb*t49*t63*t87*t94-9.305257363491002d-1*t4*t50*t62*t93-
     3         9.305257363491002d-1*t3*t4*t48*t93+8.963083509889702d-3*g
     4         ammabb*t12*t48*t89*t90+5.041016444533138d-3*gammabb*t12*t
     5         49*t62*t90+t50*t63*(-1.6711932865267184d+2*t16*t76*t88*t9
     6         +1.5192666241151986d+1*t47*t86*t9-1.5192666241151986d+1*t
     7         15*t45*t86*t9+3.038533248230397d+1*t15*t45*t85*t9-3.03853
     8         3248230397d+1*t42*t44*t85*t9+4.5577998723455965d+1*t42*t4
     9         4*t84*t9-4.5577998723455965d+1*t39*t41*t84*t9+6.077066496
     :         460795d+1*t39*t41*t83*t9-6.077066496460795d+1*t36*t38*t83
     ;         *t9+7.596333120575993d+1*t36*t38*t82*t9-7.596333120575993
     <         d+1*t33*t35*t82*t9+9.115599744691193d+1*t33*t35*t81*t9-9.
     =         115599744691193d+1*t30*t32*t81*t9+1.0634866368806391d+2*t
     >         30*t32*t80*t9-1.0634866368806391d+2*t27*t29*t80*t9+1.2154
     ?         132992921589d+2*t27*t29*t79*t9-1.2154132992921589d+2*t24*
     @         t26*t79*t9+1.3673399617036788d+2*t24*t26*t78*t9-1.3673399
     1         617036788d+2*t21*t23*t78*t9+1.5192666241151986d+2*t21*t23
     2         *t77*t9-1.5192666241151986d+2*t18*t20*t77*t9+1.6711932865
     3         267184d+2*t18*t20*t76*t9)+t3*t63*(-1.6711932865267184d+2*
     4         t16*t64*t88*t9+1.5192666241151986d+1*t47*t74*t9-1.5192666
     5         241151986d+1*t15*t45*t74*t9+3.038533248230397d+1*t15*t45*
     6         t73*t9-3.038533248230397d+1*t42*t44*t73*t9+4.557799872345
     7         5965d+1*t42*t44*t72*t9-4.5577998723455965d+1*t39*t41*t72*
     8         t9+6.077066496460795d+1*t39*t41*t71*t9-6.077066496460795d
     9         +1*t36*t38*t71*t9+7.596333120575993d+1*t36*t38*t70*t9-7.5
     :         96333120575993d+1*t33*t35*t70*t9+9.115599744691193d+1*t33
     ;         *t35*t69*t9-9.115599744691193d+1*t30*t32*t69*t9+1.0634866
     <         368806391d+2*t30*t32*t68*t9-1.0634866368806391d+2*t27*t29
     =         *t68*t9+1.2154132992921589d+2*t27*t29*t67*t9-1.2154132992
     >         921589d+2*t24*t26*t67*t9+1.3673399617036788d+2*t24*t26*t6
     ?         6*t9-1.3673399617036788d+2*t21*t23*t66*t9+1.5192666241151
     @         986d+2*t21*t23*t65*t9-1.5192666241151986d+2*t18*t20*t65*t
     1         9+1.6711932865267184d+2*t18*t20*t64*t9)-9.305257363491002
     2         d-1*t12*t4*t50*(-1.6711932865267184d+2*t16*t51*t88*t9+1.5
     3         192666241151986d+1*t47*t61*t9-1.5192666241151986d+1*t15*t
     4         45*t61*t9+3.038533248230397d+1*t15*t45*t60*t9-3.038533248
     5         230397d+1*t42*t44*t60*t9+4.5577998723455965d+1*t42*t44*t5
     6         9*t9-4.5577998723455965d+1*t39*t41*t59*t9+6.0770664964607
     7         95d+1*t39*t41*t58*t9-6.077066496460795d+1*t36*t38*t58*t9+
     8         7.596333120575993d+1*t36*t38*t57*t9-7.596333120575993d+1*
     9         t33*t35*t57*t9+9.115599744691193d+1*t33*t35*t56*t9-9.1155
     :         99744691193d+1*t30*t32*t56*t9+1.0634866368806391d+2*t30*t
     ;         32*t55*t9-1.0634866368806391d+2*t27*t29*t55*t9+1.21541329
     <         92921589d+2*t27*t29*t54*t9-1.2154132992921589d+2*t24*t26*
     =         t54*t9+1.3673399617036788d+2*t24*t26*t53*t9-1.36733996170
     >         36788d+2*t21*t23*t53*t9+1.5192666241151986d+2*t21*t23*t52
     ?         *t9-1.5192666241151986d+2*t18*t20*t52*t9+1.67119328652671
     @         84d+2*t18*t20*t51*t9)-9.305257363491002d-1*t12*t3*t4*(-1.
     1         6711932865267184d+2*t13*t16*t88*t9+1.5192666241151986d+1*
     2         t46*t47*t9-1.5192666241151986d+1*t15*t45*t46*t9+3.0385332
     3         48230397d+1*t15*t43*t45*t9-3.038533248230397d+1*t42*t43*t
     4         44*t9+4.5577998723455965d+1*t40*t42*t44*t9-4.557799872345
     5         5965d+1*t39*t40*t41*t9+6.077066496460795d+1*t37*t39*t41*t
     6         9-6.077066496460795d+1*t36*t37*t38*t9+7.596333120575993d+
     7         1*t34*t36*t38*t9-7.596333120575993d+1*t33*t34*t35*t9+9.11
     8         5599744691193d+1*t31*t33*t35*t9-9.115599744691193d+1*t30*
     9         t31*t32*t9+1.0634866368806391d+2*t28*t30*t32*t9-1.0634866
     :         368806391d+2*t27*t28*t29*t9+1.2154132992921589d+2*t25*t27
     ;         *t29*t9-1.2154132992921589d+2*t24*t25*t26*t9+1.3673399617
     <         036788d+2*t22*t24*t26*t9-1.3673399617036788d+2*t21*t22*t2
     =         3*t9+1.5192666241151986d+2*t19*t21*t23*t9-1.5192666241151
     >         986d+2*t18*t19*t20*t9+1.6711932865267184d+2*t13*t18*t20*t
     ?         9)-1.2407009817988002d+0*t12*t5*t50*t62-1.240700981798800
     @         2d+0*t12*t3*t48*t5)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*(-3.361156316208638d-3*t12*t48*t89*
     1         t91-1.890381166699927d-3*t12*t49*t62*t91+3.61210462527997
     2         4d-3*t1*t63*t75*t89+2.0315194871630324d-3*t1*t49*t63*t87)
     3         *wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TB) = 1.0d+0*(t50*t63*(-2.2d+1*t16*t76*t88-2.0d+0
     1         *t47*t86-2.0d+0*t15*t45*t86-4.0d+0*t15*t45*t85-4.0d+0*t42
     2         *t44*t85-6.0d+0*t42*t44*t84-6.0d+0*t39*t41*t84-8.0d+0*t39
     3         *t41*t83-8.0d+0*t36*t38*t83-1.0d+1*t36*t38*t82-1.0d+1*t33
     4         *t35*t82-1.2d+1*t33*t35*t81-1.2d+1*t30*t32*t81-1.4d+1*t30
     5         *t32*t80-1.4d+1*t27*t29*t80-1.6d+1*t27*t29*t79-1.6d+1*t24
     6         *t26*t79-1.8d+1*t24*t26*t78-1.8d+1*t21*t23*t78-2.0d+1*t21
     7         *t23*t77-2.0d+1*t18*t20*t77-2.2d+1*t18*t20*t76)+t3*t63*(-
     8         2.2d+1*t16*t64*t88-2.0d+0*t47*t74-2.0d+0*t15*t45*t74-4.0d
     9         +0*t15*t45*t73-4.0d+0*t42*t44*t73-6.0d+0*t42*t44*t72-6.0d
     :         +0*t39*t41*t72-8.0d+0*t39*t41*t71-8.0d+0*t36*t38*t71-1.0d
     ;         +1*t36*t38*t70-1.0d+1*t33*t35*t70-1.2d+1*t33*t35*t69-1.2d
     <         +1*t30*t32*t69-1.4d+1*t30*t32*t68-1.4d+1*t27*t29*t68-1.6d
     =         +1*t27*t29*t67-1.6d+1*t24*t26*t67-1.8d+1*t24*t26*t66-1.8d
     >         +1*t21*t23*t66-2.0d+1*t21*t23*t65-2.0d+1*t18*t20*t65-2.2d
     ?         +1*t18*t20*t64)-9.305257363491002d-1*t12*t4*t50*(-2.2d+1*
     @         t16*t51*t88-2.0d+0*t47*t61-2.0d+0*t15*t45*t61-4.0d+0*t15*
     1         t45*t60-4.0d+0*t42*t44*t60-6.0d+0*t42*t44*t59-6.0d+0*t39*
     2         t41*t59-8.0d+0*t39*t41*t58-8.0d+0*t36*t38*t58-1.0d+1*t36*
     3         t38*t57-1.0d+1*t33*t35*t57-1.2d+1*t33*t35*t56-1.2d+1*t30*
     4         t32*t56-1.4d+1*t30*t32*t55-1.4d+1*t27*t29*t55-1.6d+1*t27*
     5         t29*t54-1.6d+1*t24*t26*t54-1.8d+1*t24*t26*t53-1.8d+1*t21*
     6         t23*t53-2.0d+1*t21*t23*t52-2.0d+1*t18*t20*t52-2.2d+1*t18*
     7         t20*t51)-9.305257363491002d-1*t12*t3*t4*(-2.2d+1*t13*t16*
     8         t88-2.0d+0*t46*t47-2.0d+0*t15*t45*t46-4.0d+0*t15*t43*t45-
     9         4.0d+0*t42*t43*t44-6.0d+0*t40*t42*t44-6.0d+0*t39*t40*t41-
     :         8.0d+0*t37*t39*t41-8.0d+0*t36*t37*t38-1.0d+1*t34*t36*t38-
     ;         1.0d+1*t33*t34*t35-1.2d+1*t31*t33*t35-1.2d+1*t30*t31*t32-
     <         1.4d+1*t28*t30*t32-1.4d+1*t27*t28*t29-1.6d+1*t25*t27*t29-
     =         1.6d+1*t24*t25*t26-1.8d+1*t22*t24*t26-1.8d+1*t21*t22*t23-
     >         2.0d+1*t19*t21*t23-2.0d+1*t18*t19*t20-2.2d+1*t13*t18*t20)
     ?         )*wght+Mmat(iq,D1_TB)
            Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_x_m11 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& \rho_\alpha^{{{1}\over{3}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha}}\\\\ 
C>   {\it t_5} &=& 1.0-0.04275941461768073\,{\it t_3}\,
C>    \left({{0.1282782438530422\,{\it t_3}
C>    -2.63857249068588 \times 10^{-4}\,{\it t_4}}
C>    \over{e^{243.0826598584318\,\rho_\alpha^{{{2}\over{3}}}}}}
C>    -0.1924173657795633\,{\it t_3}+2.63857249068588 \times 10^{-4}
C>    \,{\it t_4}+3.544907701811032\,\mathrm{erf}
C>    \left(15.59110835888301\,{\it t_2}\right)\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& 0.804\,\left(1.0-{{1.0}\over{0.004492667444378077
C>    \,{\it t_6}\,\sigma_{\alpha\alpha}+1.0}}\right)+1.0\\\\ 
C>   {\it t_8} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_9} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{10}} &=& 9.115599744691192\,\rho_\alpha^{{{5}
C>    \over{3}}}\\\\ 
C>   {\it t_{11}} &=& {\it t_{10}}-2.0\,\tau_\alpha\\\\ 
C>   {\it t_{12}} &=& {\it t_{11}}^{11}\\\\ 
C>   {\it t_{13}} &=& 2.0\,\tau_\alpha+{\it t_{10}}\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_{13}}^{11}}}\\\\ 
C>   {\it t_{15}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{16}} &=& {\it t_{11}}^{10}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{{\it t_{13}}^{10}}}\\\\ 
C>   {\it t_{18}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{19}} &=& {\it t_{11}}^9\\\\ 
C>   {\it t_{20}} &=& {{1}\over{{\it t_{13}}^9}}\\\\ 
C>   {\it t_{21}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{22}} &=& {\it t_{11}}^8\\\\ 
C>   {\it t_{23}} &=& {{1}\over{{\it t_{13}}^8}}\\\\ 
C>   {\it t_{24}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{25}} &=& {\it t_{11}}^7\\\\ 
C>   {\it t_{26}} &=& {{1}\over{{\it t_{13}}^7}}\\\\ 
C>   {\it t_{27}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{28}} &=& {\it t_{11}}^6\\\\ 
C>   {\it t_{29}} &=& {{1}\over{{\it t_{13}}^6}}\\\\ 
C>   {\it t_{30}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{31}} &=& {\it t_{11}}^5\\\\ 
C>   {\it t_{32}} &=& {{1}\over{{\it t_{13}}^5}}\\\\ 
C>   {\it t_{33}} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_{34}} &=& {\it t_{11}}^4\\\\ 
C>   {\it t_{35}} &=& {{1}\over{{\it t_{13}}^4}}\\\\ 
C>   {\it t_{36}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{37}} &=& {\it t_{11}}^3\\\\ 
C>   {\it t_{38}} &=& {{1}\over{{\it t_{13}}^3}}\\\\ 
C>   {\it t_{39}} &=& {\it param}\left(3\right)\\\\ 
C>   {\it t_{40}} &=& {\it t_{11}}^2\\\\ 
C>   {\it t_{41}} &=& {{1}\over{{\it t_{13}}^2}}\\\\ 
C>   {\it t_{42}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{43}} &=& {{1}\over{{\it t_{13}}}}\\\\ 
C>   {\it t_{44}} &=& 0.552\,\left(1.0-{{1}
C>    \over{e^{0.003680288926019986\,{\it t_6}\,
C>    \sigma_{\alpha\alpha}}}}\right)+1.0\\\\ 
C>   {\it t_{45}} &=& {\it param}\left(13\right)\\\\ 
C>   {\it t_{46}} &=& {\it param}\left(24\right)\\\\ 
C>   {\it t_{47}} &=& {\it param}\left(23\right)\\\\ 
C>   {\it t_{48}} &=& {\it param}\left(22\right)\\\\ 
C>   {\it t_{49}} &=& {\it param}\left(21\right)\\\\ 
C>   {\it t_{50}} &=& {\it param}\left(20\right)\\\\ 
C>   {\it t_{51}} &=& {\it param}\left(19\right)\\\\ 
C>   {\it t_{52}} &=& {\it param}\left(18\right)\\\\ 
C>   {\it t_{53}} &=& {\it param}\left(17\right)\\\\ 
C>   {\it t_{54}} &=& {\it param}\left(16\right)\\\\ 
C>   {\it t_{55}} &=& {\it param}\left(15\right)\\\\ 
C>   {\it t_{56}} &=& {\it param}\left(14\right)\\\\ 
C>   {\it t_{57}} &=& 0.9305257363491002\,{\it t_1}\,{\it t_5}
C>    -0.9305257363491002\,{\it t_1}\\\\ 
C>   {\it t_{58}} &=& {\it param}\left(25\right)\\\\ 
C>   {\it t_{59}} &=& {\it param}\left(36\right)\\\\ 
C>   {\it t_{60}} &=& {\it param}\left(35\right)\\\\ 
C>   {\it t_{61}} &=& {\it param}\left(34\right)\\\\ 
C>   {\it t_{62}} &=& {\it param}\left(33\right)\\\\ 
C>   {\it t_{63}} &=& {\it param}\left(32\right)\\\\ 
C>   {\it t_{64}} &=& {\it param}\left(31\right)\\\\ 
C>   {\it t_{65}} &=& {\it param}\left(30\right)\\\\ 
C>   {\it t_{66}} &=& {\it param}\left(29\right)\\\\ 
C>   {\it t_{67}} &=& {\it param}\left(28\right)\\\\ 
C>   {\it t_{68}} &=& {\it param}\left(27\right)\\\\ 
C>   {\it t_{69}} &=& {\it param}\left(26\right)\\\\ 
C>   {\it t_{70}} &=& {\it param}\left(37\right)\\\\ 
C>   {\it t_{71}} &=& {\it param}\left(48\right)\\\\ 
C>   {\it t_{72}} &=& {\it param}\left(47\right)\\\\ 
C>   {\it t_{73}} &=& {\it param}\left(46\right)\\\\ 
C>   {\it t_{74}} &=& {\it param}\left(45\right)\\\\ 
C>   {\it t_{75}} &=& {\it param}\left(44\right)\\\\ 
C>   {\it t_{76}} &=& {\it param}\left(43\right)\\\\ 
C>   {\it t_{77}} &=& {\it param}\left(42\right)\\\\ 
C>   {\it t_{78}} &=& {\it param}\left(41\right)\\\\ 
C>   {\it t_{79}} &=& {\it param}\left(40\right)\\\\ 
C>   {\it t_{80}} &=& {\it param}\left(39\right)\\\\ 
C>   {\it t_{81}} &=& {\it param}\left(38\right)\\\\ 
C>   {\it t_{82}} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_{83}} &=& \rho_\beta^{{{1}\over{3}}}\\\\ 
C>   {\it t_{84}} &=& {{1}\over{{\it t_{83}}}}\\\\ 
C>   {\it t_{85}} &=& {{1}\over{\rho_\beta}}\\\\ 
C>   {\it t_{86}} &=& 1.0-0.04275941461768073\,{\it t_{84}}\,
C>    \left({{0.1282782438530422\,{\it t_{84}}
C>    -2.63857249068588 \times 10^{-4}\,{\it t_{85}}}
C>    \over{e^{243.0826598584318\,\rho_\beta^{{{2}\over{3}}}}}}
C>    -0.1924173657795633\,{\it t_{84}}+2.63857249068588 \times 10^{
C>    -4}\,{\it t_{85}}+3.544907701811032\,\mathrm{erf}
C>    \left(15.59110835888301\,{\it t_{83}}\right)\right)\\\\ 
C>   {\it t_{87}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{88}} &=& 0.804\,\left(1.0-{{1.0}
C>    \over{0.004492667444378077\,{\it t_{87}}\,\sigma_{\beta\beta}
C>    +1.0}}\right)+1.0\\\\ 
C>   {\it t_{89}} &=& 9.115599744691192\,\rho_\beta^{{{5}\over{3}}}\\\\ 
C>   {\it t_{90}} &=& {\it t_{89}}-2.0\,\tau_\beta\\\\ 
C>   {\it t_{91}} &=& {\it t_{90}}^{11}\\\\ 
C>   {\it t_{92}} &=& 2.0\,\tau_\beta+{\it t_{89}}\\\\ 
C>   {\it t_{93}} &=& {{1}\over{{\it t_{92}}^{11}}}\\\\ 
C>   {\it t_{94}} &=& {\it t_{90}}^{10}\\\\ 
C>   {\it t_{95}} &=& {{1}\over{{\it t_{92}}^{10}}}\\\\ 
C>   {\it t_{96}} &=& {\it t_{90}}^9\\\\ 
C>   {\it t_{97}} &=& {{1}\over{{\it t_{92}}^9}}\\\\ 
C>   {\it t_{98}} &=& {\it t_{90}}^8\\\\ 
C>   {\it t_{99}} &=& {{1}\over{{\it t_{92}}^8}}\\\\ 
C>   {\it t_{100}} &=& {\it t_{90}}^7\\\\ 
C>   {\it t_{101}} &=& {{1}\over{{\it t_{92}}^7}}\\\\ 
C>   {\it t_{102}} &=& {\it t_{90}}^6\\\\ 
C>   {\it t_{103}} &=& {{1}\over{{\it t_{92}}^6}}\\\\ 
C>   {\it t_{104}} &=& {\it t_{90}}^5\\\\ 
C>   {\it t_{105}} &=& {{1}\over{{\it t_{92}}^5}}\\\\ 
C>   {\it t_{106}} &=& {\it t_{90}}^4\\\\ 
C>   {\it t_{107}} &=& {{1}\over{{\it t_{92}}^4}}\\\\ 
C>   {\it t_{108}} &=& {\it t_{90}}^3\\\\ 
C>   {\it t_{109}} &=& {{1}\over{{\it t_{92}}^3}}\\\\ 
C>   {\it t_{110}} &=& {\it t_{90}}^2\\\\ 
C>   {\it t_{111}} &=& {{1}\over{{\it t_{92}}^2}}\\\\ 
C>   {\it t_{112}} &=& {{1}\over{{\it t_{92}}}}\\\\ 
C>   {\it t_{113}} &=& 0.552\,\left(1.0-{{1}
C>    \over{e^{0.003680288926019986\,{\it t_{87}}\,
C>    \sigma_{\beta\beta}}}}\right)+1.0\\\\ 
C>   {\it t_{114}} &=& 0.9305257363491002\,{\it t_{82}}\,{\it t_{86}}
C>    -0.9305257363491002\,{\it t_{82}}\\\\ 
C>   {\it t_{115}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{116}} &=& \rho_s^{{{1}\over{3}}}\\\\ 
C>   {\it t_{117}} &=& {{1}\over{{\it t_{116}}}}\\\\ 
C>   {\it t_{118}} &=& {{1}\over{\rho_s}}\\\\ 
C>   {\it t_{119}} &=& 1.0-0.04275941461768073\,{\it t_{117}}
C>    \,\left({{0.1282782438530422\,{\it t_{117}}
C>    -2.63857249068588 \times 10^{-4}\,{\it t_{118}}}
C>    \over{e^{243.0826598584318\,\rho_s^{{{2}\over{3}}}}}}
C>    -0.1924173657795633\,{\it t_{117}}+2.63857249068588 \times 10^{
C>    -4}\,{\it t_{118}}+3.544907701811032\,\mathrm{erf}
C>    \left(15.59110835888301\,{\it t_{116}}\right)\right)\\\\ 
C>   {\it t_{120}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{121}} &=& 0.804\,\left(1.0-{{1.0}
C>    \over{0.004492667444378077\,{\it t_{120}}\,\sigma_{ss}
C>    +1.0}}\right)+1.0\\\\ 
C>   {\it t_{122}} &=& 9.115599744691192\,\rho_s^{{{5}\over{3}}}\\\\ 
C>   {\it t_{123}} &=& {\it t_{122}}-2.0\,\tau_s\\\\ 
C>   {\it t_{124}} &=& {\it t_{123}}^{11}\\\\ 
C>   {\it t_{125}} &=& 2.0\,\tau_s+{\it t_{122}}\\\\ 
C>   {\it t_{126}} &=& {{1}\over{{\it t_{125}}^{11}}}\\\\ 
C>   {\it t_{127}} &=& {\it t_{123}}^{10}\\\\ 
C>   {\it t_{128}} &=& {{1}\over{{\it t_{125}}^{10}}}\\\\ 
C>   {\it t_{129}} &=& {\it t_{123}}^9\\\\ 
C>   {\it t_{130}} &=& {{1}\over{{\it t_{125}}^9}}\\\\ 
C>   {\it t_{131}} &=& {\it t_{123}}^8\\\\ 
C>   {\it t_{132}} &=& {{1}\over{{\it t_{125}}^8}}\\\\ 
C>   {\it t_{133}} &=& {\it t_{123}}^7\\\\ 
C>   {\it t_{134}} &=& {{1}\over{{\it t_{125}}^7}}\\\\ 
C>   {\it t_{135}} &=& {\it t_{123}}^6\\\\ 
C>   {\it t_{136}} &=& {{1}\over{{\it t_{125}}^6}}\\\\ 
C>   {\it t_{137}} &=& {\it t_{123}}^5\\\\ 
C>   {\it t_{138}} &=& {{1}\over{{\it t_{125}}^5}}\\\\ 
C>   {\it t_{139}} &=& {\it t_{123}}^4\\\\ 
C>   {\it t_{140}} &=& {{1}\over{{\it t_{125}}^4}}\\\\ 
C>   {\it t_{141}} &=& {\it t_{123}}^3\\\\ 
C>   {\it t_{142}} &=& {{1}\over{{\it t_{125}}^3}}\\\\ 
C>   {\it t_{143}} &=& {\it t_{123}}^2\\\\ 
C>   {\it t_{144}} &=& {{1}\over{{\it t_{125}}^2}}\\\\ 
C>   {\it t_{145}} &=& {{1}\over{{\it t_{125}}}}\\\\ 
C>   {\it t_{146}} &=& 0.552\,\left(1.0-{{1}
C>    \over{e^{0.003680288926019986\,{\it t_{120}}\,
C>    \sigma_{ss}}}}\right)+1.0\\\\ 
C>   {\it t_{147}} &=& 0.9305257363491002\,{\it t_{115}}\,{
C>    \it t_{119}}-0.9305257363491002\,{\it t_{115}}\\\\ 
C>   f &=& 1.0\,\left({\it t_{114}}\,{\it t_{113}}\,\left({
C>    \it t_{81}}\,{\it t_{90}}\,{\it t_{112}}+{\it t_{80}}\,{
C>    \it t_{110}}\,{\it t_{111}}+{\it t_{79}}\,{\it t_{108}}\,{
C>    \it t_{109}}+{\it t_{78}}\,{\it t_{106}}\,{\it t_{107}}+{
C>    \it t_{77}}\,{\it t_{104}}\,{\it t_{105}}+{\it t_{76}}\,{
C>    \it t_{102}}\,{\it t_{103}}+{\it t_{75}}\,{\it t_{100}}\,{
C>    \it t_{101}}+{\it t_{74}}\,{\it t_{98}}\,{\it t_{99}}+{
C>    \it t_{73}}\,{\it t_{96}}\,{\it t_{97}}+{\it t_{72}}\,{
C>    \it t_{94}}\,{\it t_{95}}+{\it t_{71}}\,{\it t_{91}}\,{
C>    \it t_{93}}+{\it t_{70}}\right)+{\it t_{114}}\,{\it t_{88}}
C>    \,\left({\it t_{69}}\,{\it t_{90}}\,{\it t_{112}}+{\it t_{68}}
C>    \,{\it t_{110}}\,{\it t_{111}}+{\it t_{67}}\,{\it t_{108}}
C>    \,{\it t_{109}}+{\it t_{66}}\,{\it t_{106}}\,{\it t_{107}}+{
C>    \it t_{65}}\,{\it t_{104}}\,{\it t_{105}}+{\it t_{64}}\,{
C>    \it t_{102}}\,{\it t_{103}}+{\it t_{63}}\,{\it t_{100}}\,{
C>    \it t_{101}}+{\it t_{62}}\,{\it t_{98}}\,{\it t_{99}}+{
C>    \it t_{61}}\,{\it t_{96}}\,{\it t_{97}}+{\it t_{60}}\,{
C>    \it t_{94}}\,{\it t_{95}}+{\it t_{59}}\,{\it t_{91}}\,{
C>    \it t_{93}}+{\it t_{58}}\right)-0.9305257363491002\,{
C>    \it t_{82}}\,{\it t_{86}}\,{\it t_{113}}\,\left({\it t_{56}}
C>    \,{\it t_{90}}\,{\it t_{112}}+{\it t_{55}}\,{\it t_{110}}\,{
C>    \it t_{111}}+{\it t_{54}}\,{\it t_{108}}\,{\it t_{109}}+{
C>    \it t_{53}}\,{\it t_{106}}\,{\it t_{107}}+{\it t_{52}}\,{
C>    \it t_{104}}\,{\it t_{105}}+{\it t_{51}}\,{\it t_{102}}\,{
C>    \it t_{103}}+{\it t_{50}}\,{\it t_{100}}\,{\it t_{101}}+{
C>    \it t_{49}}\,{\it t_{98}}\,{\it t_{99}}+{\it t_{48}}\,{
C>    \it t_{96}}\,{\it t_{97}}+{\it t_{47}}\,{\it t_{94}}\,{
C>    \it t_{95}}+{\it t_{46}}\,{\it t_{91}}\,{\it t_{93}}+{
C>    \it t_{45}}\right)-0.9305257363491002\,{\it t_{82}}\,{
C>    \it t_{86}}\,{\it t_{88}}\,\left({\it t_{42}}\,{\it t_{90}}
C>    \,{\it t_{112}}+{\it t_{39}}\,{\it t_{110}}\,{\it t_{111}}+{
C>    \it t_{36}}\,{\it t_{108}}\,{\it t_{109}}+{\it t_{33}}\,{
C>    \it t_{106}}\,{\it t_{107}}+{\it t_{30}}\,{\it t_{104}}\,{
C>    \it t_{105}}+{\it t_{27}}\,{\it t_{102}}\,{\it t_{103}}+{
C>    \it t_{24}}\,{\it t_{100}}\,{\it t_{101}}+{\it t_{21}}\,{
C>    \it t_{98}}\,{\it t_{99}}+{\it t_{18}}\,{\it t_{96}}\,{
C>    \it t_{97}}+{\it t_{15}}\,{\it t_{94}}\,{\it t_{95}}+{\it t_9}
C>    \,{\it t_{91}}\,{\it t_{93}}+{\it t_8}\right)\right)+1.0
C>    \,\left({\it t_{57}}\,{\it t_{44}}\,\left({\it t_{81}}\,{
C>    \it t_{11}}\,{\it t_{43}}+{\it t_{80}}\,{\it t_{40}}\,{
C>    \it t_{41}}+{\it t_{79}}\,{\it t_{37}}\,{\it t_{38}}+{
C>    \it t_{78}}\,{\it t_{34}}\,{\it t_{35}}+{\it t_{77}}\,{
C>    \it t_{31}}\,{\it t_{32}}+{\it t_{76}}\,{\it t_{28}}\,{
C>    \it t_{29}}+{\it t_{75}}\,{\it t_{25}}\,{\it t_{26}}+{
C>    \it t_{74}}\,{\it t_{22}}\,{\it t_{23}}+{\it t_{73}}\,{
C>    \it t_{19}}\,{\it t_{20}}+{\it t_{72}}\,{\it t_{16}}\,{
C>    \it t_{17}}+{\it t_{71}}\,{\it t_{12}}\,{\it t_{14}}+{
C>    \it t_{70}}\right)+{\it t_{57}}\,{\it t_7}\,\left({\it t_{69}}
C>    \,{\it t_{11}}\,{\it t_{43}}+{\it t_{68}}\,{\it t_{40}}\,{
C>    \it t_{41}}+{\it t_{67}}\,{\it t_{37}}\,{\it t_{38}}+{
C>    \it t_{66}}\,{\it t_{34}}\,{\it t_{35}}+{\it t_{65}}\,{
C>    \it t_{31}}\,{\it t_{32}}+{\it t_{64}}\,{\it t_{28}}\,{
C>    \it t_{29}}+{\it t_{63}}\,{\it t_{25}}\,{\it t_{26}}+{
C>    \it t_{62}}\,{\it t_{22}}\,{\it t_{23}}+{\it t_{61}}\,{
C>    \it t_{19}}\,{\it t_{20}}+{\it t_{60}}\,{\it t_{16}}\,{
C>    \it t_{17}}+{\it t_{59}}\,{\it t_{12}}\,{\it t_{14}}+{
C>    \it t_{58}}\right)-0.9305257363491002\,{\it t_1}\,{\it t_5}
C>    \,{\it t_{44}}\,\left({\it t_{56}}\,{\it t_{11}}\,{\it t_{43}}
C>    +{\it t_{55}}\,{\it t_{40}}\,{\it t_{41}}+{\it t_{54}}\,{
C>    \it t_{37}}\,{\it t_{38}}+{\it t_{53}}\,{\it t_{34}}\,{
C>    \it t_{35}}+{\it t_{52}}\,{\it t_{31}}\,{\it t_{32}}+{
C>    \it t_{51}}\,{\it t_{28}}\,{\it t_{29}}+{\it t_{50}}\,{
C>    \it t_{25}}\,{\it t_{26}}+{\it t_{49}}\,{\it t_{22}}\,{
C>    \it t_{23}}+{\it t_{48}}\,{\it t_{19}}\,{\it t_{20}}+{
C>    \it t_{47}}\,{\it t_{16}}\,{\it t_{17}}+{\it t_{46}}\,{
C>    \it t_{12}}\,{\it t_{14}}+{\it t_{45}}\right)
C>    -0.9305257363491002\,{\it t_1}\,{\it t_5}\,{\it t_7}\,
C>    \left({\it t_{42}}\,{\it t_{11}}\,{\it t_{43}}+{\it t_{39}}
C>    \,{\it t_{40}}\,{\it t_{41}}+{\it t_{36}}\,{\it t_{37}}\,{
C>    \it t_{38}}+{\it t_{33}}\,{\it t_{34}}\,{\it t_{35}}+{
C>    \it t_{30}}\,{\it t_{31}}\,{\it t_{32}}+{\it t_{27}}\,{
C>    \it t_{28}}\,{\it t_{29}}+{\it t_{24}}\,{\it t_{25}}\,{
C>    \it t_{26}}+{\it t_{21}}\,{\it t_{22}}\,{\it t_{23}}+{
C>    \it t_{18}}\,{\it t_{19}}\,{\it t_{20}}+{\it t_{15}}\,{
C>    \it t_{16}}\,{\it t_{17}}+{\it t_9}\,{\it t_{12}}\,{\it t_{14}}
C>    +{\it t_8}\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left({\it t_{147}}\,{\it t_{146}}\,\left({
C>    \it t_{81}}\,{\it t_{123}}\,{\it t_{145}}+{\it t_{80}}\,{
C>    \it t_{143}}\,{\it t_{144}}+{\it t_{79}}\,{\it t_{141}}\,{
C>    \it t_{142}}+{\it t_{78}}\,{\it t_{139}}\,{\it t_{140}}+{
C>    \it t_{77}}\,{\it t_{137}}\,{\it t_{138}}+{\it t_{76}}\,{
C>    \it t_{135}}\,{\it t_{136}}+{\it t_{75}}\,{\it t_{133}}\,{
C>    \it t_{134}}+{\it t_{74}}\,{\it t_{131}}\,{\it t_{132}}+{
C>    \it t_{73}}\,{\it t_{129}}\,{\it t_{130}}+{\it t_{72}}\,{
C>    \it t_{127}}\,{\it t_{128}}+{\it t_{71}}\,{\it t_{124}}\,{
C>    \it t_{126}}+{\it t_{70}}\right)+{\it t_{147}}\,{\it t_{121}}
C>    \,\left({\it t_{69}}\,{\it t_{123}}\,{\it t_{145}}+{
C>    \it t_{68}}\,{\it t_{143}}\,{\it t_{144}}+{\it t_{67}}\,{
C>    \it t_{141}}\,{\it t_{142}}+{\it t_{66}}\,{\it t_{139}}\,{
C>    \it t_{140}}+{\it t_{65}}\,{\it t_{137}}\,{\it t_{138}}+{
C>    \it t_{64}}\,{\it t_{135}}\,{\it t_{136}}+{\it t_{63}}\,{
C>    \it t_{133}}\,{\it t_{134}}+{\it t_{62}}\,{\it t_{131}}\,{
C>    \it t_{132}}+{\it t_{61}}\,{\it t_{129}}\,{\it t_{130}}+{
C>    \it t_{60}}\,{\it t_{127}}\,{\it t_{128}}+{\it t_{59}}\,{
C>    \it t_{124}}\,{\it t_{126}}+{\it t_{58}}\right)
C>    -0.9305257363491002\,{\it t_{115}}\,{\it t_{119}}\,{
C>    \it t_{146}}\,\left({\it t_{56}}\,{\it t_{123}}\,{\it t_{145}}
C>    +{\it t_{55}}\,{\it t_{143}}\,{\it t_{144}}+{\it t_{54}}\,{
C>    \it t_{141}}\,{\it t_{142}}+{\it t_{53}}\,{\it t_{139}}\,{
C>    \it t_{140}}+{\it t_{52}}\,{\it t_{137}}\,{\it t_{138}}+{
C>    \it t_{51}}\,{\it t_{135}}\,{\it t_{136}}+{\it t_{50}}\,{
C>    \it t_{133}}\,{\it t_{134}}+{\it t_{49}}\,{\it t_{131}}\,{
C>    \it t_{132}}+{\it t_{48}}\,{\it t_{129}}\,{\it t_{130}}+{
C>    \it t_{47}}\,{\it t_{127}}\,{\it t_{128}}+{\it t_{46}}\,{
C>    \it t_{124}}\,{\it t_{126}}+{\it t_{45}}\right)
C>    -0.9305257363491002\,{\it t_{115}}\,{\it t_{119}}\,{
C>    \it t_{121}}\,\left({\it t_{42}}\,{\it t_{123}}\,{\it t_{145}}
C>    +{\it t_{39}}\,{\it t_{143}}\,{\it t_{144}}+{\it t_{36}}\,{
C>    \it t_{141}}\,{\it t_{142}}+{\it t_{33}}\,{\it t_{139}}\,{
C>    \it t_{140}}+{\it t_{30}}\,{\it t_{137}}\,{\it t_{138}}+{
C>    \it t_{27}}\,{\it t_{135}}\,{\it t_{136}}+{\it t_{24}}\,{
C>    \it t_{133}}\,{\it t_{134}}+{\it t_{21}}\,{\it t_{131}}\,{
C>    \it t_{132}}+{\it t_{18}}\,{\it t_{129}}\,{\it t_{130}}+{
C>    \it t_{15}}\,{\it t_{127}}\,{\it t_{128}}+{\it t_9}\,{
C>    \it t_{124}}\,{\it t_{126}}+{\it t_8}\right)\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] R Peverati, DG Truhlar, J.Phys.Chem.Lett. 2, 2810 (2011)  , DOI: 
C> <a href="http://dx.doi.org/10.1021/jz201170d "> 
C> 10.1021/jz201170d </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_x_m11_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Cmat,Cmat2,Mmat,Mmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = rhoa**3.333333333333333d-1
            t6 = 1/t5
            t7 = 1/rhoa
            t8 = 1.282782438530422d-1*t6-2.63857249068588d-4*t7
            t9 = rhoa**6.666666666666666d-1
            t10 = exp(-2.4308265985843178d+2*t9)
            t11 = t10*t8+2.63857249068588d-4*t7-1.924173657795633d-1*t6+
     1         3.544907701811032d+0*erf(1.5591108358883013d+1*t5)
            t12 = 1.0d+0-4.275941461768073d-2*t11*t6
            t13 = param(12)
            t14 = rhoa**1.6666666666666669d+0
            t15 = 9.115599744691192d+0*t14
            t16 = t15-2.0d+0*taua
            t17 = t16**11
            t18 = 2.0d+0*taua+t15
            t19 = 1/t18**11
            t20 = param(11)
            t21 = t16**10
            t22 = 1/t18**10
            t23 = param(10)
            t24 = t16**9
            t25 = 1/t18**9
            t26 = param(9)
            t27 = t16**8
            t28 = 1/t18**8
            t29 = param(8)
            t30 = t16**7
            t31 = 1/t18**7
            t32 = param(7)
            t33 = t16**6
            t34 = 1/t18**6
            t35 = param(6)
            t36 = t16**5
            t37 = 1/t18**5
            t38 = param(5)
            t39 = t16**4
            t40 = 1/t18**4
            t41 = param(4)
            t42 = t16**3
            t43 = 1/t18**3
            t44 = param(3)
            t45 = t16**2
            t46 = 1/t18**2
            t47 = param(2)
            t48 = 1/t18
            t49 = t16*t47*t48+t44*t45*t46+t41*t42*t43+t38*t39*t40+t35*t3
     1         6*t37+t32*t33*t34+t29*t30*t31+t26*t27*t28+t23*t24*t25+t20
     2         *t21*t22+t13*t17*t19+param(1)
            t50 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t51 = 5.52d-1*(1.0d+0-t50)+1.0d+0
            t52 = param(24)
            t53 = param(23)
            t54 = param(22)
            t55 = param(21)
            t56 = param(20)
            t57 = param(19)
            t58 = param(18)
            t59 = param(17)
            t60 = param(16)
            t61 = param(15)
            t62 = param(14)
            t63 = t16*t48*t62+t45*t46*t61+t42*t43*t60+t39*t40*t59+t36*t3
     1         7*t58+t33*t34*t57+t30*t31*t56+t27*t28*t55+t24*t25*t54+t21
     2         *t22*t53+t17*t19*t52+param(13)
            t64 = 9.305257363491002d-1*t12*t4-9.305257363491002d-1*t4
            t65 = param(36)
            t66 = param(35)
            t67 = param(34)
            t68 = param(33)
            t69 = param(32)
            t70 = param(31)
            t71 = param(30)
            t72 = param(29)
            t73 = param(28)
            t74 = param(27)
            t75 = param(26)
            t76 = t16*t48*t75+t45*t46*t74+t42*t43*t73+t39*t40*t72+t36*t3
     1         7*t71+t33*t34*t70+t30*t31*t69+t27*t28*t68+t24*t25*t67+t21
     2         *t22*t66+t17*t19*t65+param(25)
            t77 = param(48)
            t78 = param(47)
            t79 = param(46)
            t80 = param(45)
            t81 = param(44)
            t82 = param(43)
            t83 = param(42)
            t84 = param(41)
            t85 = param(40)
            t86 = param(39)
            t87 = param(38)
            t88 = t16*t48*t87+t45*t46*t86+t42*t43*t85+t39*t40*t84+t36*t3
     1         7*t83+t33*t34*t82+t30*t31*t81+t27*t28*t80+t24*t25*t79+t21
     2         *t22*t78+t17*t19*t77+param(37)
            t89 = 1/t18**12
            t90 = -1.6711932865267184d+2*t13*t17*t89*t9+1.51926662411519
     1         86d+1*t47*t48*t9-1.5192666241151986d+1*t16*t46*t47*t9+3.0
     2         38533248230397d+1*t16*t44*t46*t9-3.038533248230397d+1*t43
     3         *t44*t45*t9+4.5577998723455965d+1*t41*t43*t45*t9-4.557799
     4         8723455965d+1*t40*t41*t42*t9+6.077066496460795d+1*t38*t40
     5         *t42*t9-6.077066496460795d+1*t37*t38*t39*t9+7.59633312057
     6         5993d+1*t35*t37*t39*t9-7.596333120575993d+1*t34*t35*t36*t
     7         9+9.115599744691193d+1*t32*t34*t36*t9-9.115599744691193d+
     8         1*t31*t32*t33*t9+1.0634866368806391d+2*t29*t31*t33*t9-1.0
     9         634866368806391d+2*t28*t29*t30*t9+1.2154132992921589d+2*t
     :         26*t28*t30*t9-1.2154132992921589d+2*t25*t26*t27*t9+1.3673
     ;         399617036788d+2*t23*t25*t27*t9-1.3673399617036788d+2*t22*
     <         t23*t24*t9+1.5192666241151986d+2*t20*t22*t24*t9-1.5192666
     =         241151986d+2*t19*t20*t21*t9+1.6711932865267184d+2*t13*t19
     >         *t21*t9
            t91 = -1.6711932865267184d+2*t17*t52*t89*t9+1.51926662411519
     1         86d+1*t48*t62*t9-1.5192666241151986d+1*t16*t46*t62*t9+3.0
     2         38533248230397d+1*t16*t46*t61*t9-3.038533248230397d+1*t43
     3         *t45*t61*t9+4.5577998723455965d+1*t43*t45*t60*t9-4.557799
     4         8723455965d+1*t40*t42*t60*t9+6.077066496460795d+1*t40*t42
     5         *t59*t9-6.077066496460795d+1*t37*t39*t59*t9+7.59633312057
     6         5993d+1*t37*t39*t58*t9-7.596333120575993d+1*t34*t36*t58*t
     7         9+9.115599744691193d+1*t34*t36*t57*t9-9.115599744691193d+
     8         1*t31*t33*t57*t9+1.0634866368806391d+2*t31*t33*t56*t9-1.0
     9         634866368806391d+2*t28*t30*t56*t9+1.2154132992921589d+2*t
     :         28*t30*t55*t9-1.2154132992921589d+2*t25*t27*t55*t9+1.3673
     ;         399617036788d+2*t25*t27*t54*t9-1.3673399617036788d+2*t22*
     <         t24*t54*t9+1.5192666241151986d+2*t22*t24*t53*t9-1.5192666
     =         241151986d+2*t19*t21*t53*t9+1.6711932865267184d+2*t19*t21
     >         *t52*t9
            t92 = -1.6711932865267184d+2*t17*t65*t89*t9+1.51926662411519
     1         86d+1*t48*t75*t9-1.5192666241151986d+1*t16*t46*t75*t9+3.0
     2         38533248230397d+1*t16*t46*t74*t9-3.038533248230397d+1*t43
     3         *t45*t74*t9+4.5577998723455965d+1*t43*t45*t73*t9-4.557799
     4         8723455965d+1*t40*t42*t73*t9+6.077066496460795d+1*t40*t42
     5         *t72*t9-6.077066496460795d+1*t37*t39*t72*t9+7.59633312057
     6         5993d+1*t37*t39*t71*t9-7.596333120575993d+1*t34*t36*t71*t
     7         9+9.115599744691193d+1*t34*t36*t70*t9-9.115599744691193d+
     8         1*t31*t33*t70*t9+1.0634866368806391d+2*t31*t33*t69*t9-1.0
     9         634866368806391d+2*t28*t30*t69*t9+1.2154132992921589d+2*t
     :         28*t30*t68*t9-1.2154132992921589d+2*t25*t27*t68*t9+1.3673
     ;         399617036788d+2*t25*t27*t67*t9-1.3673399617036788d+2*t22*
     <         t24*t67*t9+1.5192666241151986d+2*t22*t24*t66*t9-1.5192666
     =         241151986d+2*t19*t21*t66*t9+1.6711932865267184d+2*t19*t21
     >         *t65*t9
            t93 = -1.6711932865267184d+2*t17*t77*t89*t9+1.51926662411519
     1         86d+1*t48*t87*t9-1.5192666241151986d+1*t16*t46*t87*t9+3.0
     2         38533248230397d+1*t16*t46*t86*t9-3.038533248230397d+1*t43
     3         *t45*t86*t9+4.5577998723455965d+1*t43*t45*t85*t9-4.557799
     4         8723455965d+1*t40*t42*t85*t9+6.077066496460795d+1*t40*t42
     5         *t84*t9-6.077066496460795d+1*t37*t39*t84*t9+7.59633312057
     6         5993d+1*t37*t39*t83*t9-7.596333120575993d+1*t34*t36*t83*t
     7         9+9.115599744691193d+1*t34*t36*t82*t9-9.115599744691193d+
     8         1*t31*t33*t82*t9+1.0634866368806391d+2*t31*t33*t81*t9-1.0
     9         634866368806391d+2*t28*t30*t81*t9+1.2154132992921589d+2*t
     :         28*t30*t80*t9-1.2154132992921589d+2*t25*t27*t80*t9+1.3673
     ;         399617036788d+2*t25*t27*t79*t9-1.3673399617036788d+2*t22*
     <         t24*t79*t9+1.5192666241151986d+2*t22*t24*t78*t9-1.5192666
     =         241151986d+2*t19*t21*t78*t9+1.6711932865267184d+2*t19*t21
     >         *t77*t9
            t94 = 1/t2**2
            t95 = 1/rhoa**2.3333333333333334d+0
            t96 = 1/t4
            t97 = 1/rhoa**2
            t98 = 2.63857249068588d-4*t97-4.2759414617680735d-2*t96
            t99 = 5.641895835477563d-1
            t100 = 1/t9
            t101 = 3.6846026734116505d+1*t10*t100*t99+t10*t98-2.63857249
     1         068588d-4*t97+6.41391219265211d-2*t96-1.6205510657228786d
     2         +2*t10*t6*t8
            t102 = 1.4253138205893576d-2*t11*t96-4.275941461768073d-2*t1
     1         01*t6
            t103 = 1/rhoa**3.6666666666666664d+0
            t104 = 1.2407009817988002d+0*t12*t5-1.2407009817988002d+0*t5
     1         +9.305257363491002d-1*t102*t4
            t105 = -2.2d+1*t13*t17*t89-2.0d+0*t47*t48-2.0d+0*t16*t46*t47
     1         -4.0d+0*t16*t44*t46-4.0d+0*t43*t44*t45-6.0d+0*t41*t43*t45
     2         -6.0d+0*t40*t41*t42-8.0d+0*t38*t40*t42-8.0d+0*t37*t38*t39
     3         -1.0d+1*t35*t37*t39-1.0d+1*t34*t35*t36-1.2d+1*t32*t34*t36
     4         -1.2d+1*t31*t32*t33-1.4d+1*t29*t31*t33-1.4d+1*t28*t29*t30
     5         -1.6d+1*t26*t28*t30-1.6d+1*t25*t26*t27-1.8d+1*t23*t25*t27
     6         -1.8d+1*t22*t23*t24-2.0d+1*t20*t22*t24-2.0d+1*t19*t20*t21
     7         -2.2d+1*t13*t19*t21
            t106 = -2.2d+1*t17*t52*t89-2.0d+0*t48*t62-2.0d+0*t16*t46*t62
     1         -4.0d+0*t16*t46*t61-4.0d+0*t43*t45*t61-6.0d+0*t43*t45*t60
     2         -6.0d+0*t40*t42*t60-8.0d+0*t40*t42*t59-8.0d+0*t37*t39*t59
     3         -1.0d+1*t37*t39*t58-1.0d+1*t34*t36*t58-1.2d+1*t34*t36*t57
     4         -1.2d+1*t31*t33*t57-1.4d+1*t31*t33*t56-1.4d+1*t28*t30*t56
     5         -1.6d+1*t28*t30*t55-1.6d+1*t25*t27*t55-1.8d+1*t25*t27*t54
     6         -1.8d+1*t22*t24*t54-2.0d+1*t22*t24*t53-2.0d+1*t19*t21*t53
     7         -2.2d+1*t19*t21*t52
            t107 = -2.2d+1*t17*t65*t89-2.0d+0*t48*t75-2.0d+0*t16*t46*t75
     1         -4.0d+0*t16*t46*t74-4.0d+0*t43*t45*t74-6.0d+0*t43*t45*t73
     2         -6.0d+0*t40*t42*t73-8.0d+0*t40*t42*t72-8.0d+0*t37*t39*t72
     3         -1.0d+1*t37*t39*t71-1.0d+1*t34*t36*t71-1.2d+1*t34*t36*t70
     4         -1.2d+1*t31*t33*t70-1.4d+1*t31*t33*t69-1.4d+1*t28*t30*t69
     5         -1.6d+1*t28*t30*t68-1.6d+1*t25*t27*t68-1.8d+1*t25*t27*t67
     6         -1.8d+1*t22*t24*t67-2.0d+1*t22*t24*t66-2.0d+1*t19*t21*t66
     7         -2.2d+1*t19*t21*t65
            t108 = -2.2d+1*t17*t77*t89-2.0d+0*t48*t87-2.0d+0*t16*t46*t87
     1         -4.0d+0*t16*t46*t86-4.0d+0*t43*t45*t86-6.0d+0*t43*t45*t85
     2         -6.0d+0*t40*t42*t85-8.0d+0*t40*t42*t84-8.0d+0*t37*t39*t84
     3         -1.0d+1*t37*t39*t83-1.0d+1*t34*t36*t83-1.2d+1*t34*t36*t82
     4         -1.2d+1*t31*t33*t82-1.4d+1*t31*t33*t81-1.4d+1*t28*t30*t81
     5         -1.6d+1*t28*t30*t80-1.6d+1*t25*t27*t80-1.8d+1*t25*t27*t79
     6         -1.8d+1*t22*t24*t79-2.0d+1*t22*t24*t78-2.0d+1*t19*t21*t78
     7         -2.2d+1*t19*t21*t77
            t109 = 1/t18**13
            t110 = gammaaa**2
            t111 = 1/t2**3
            t112 = 1/rhoa**6
            t113 = 1/rhoa**3.3333333333333337d+0
            t114 = 1/rhoa**3
            t115 = -4.275941461768073d-2*t6*(-5.971086789162617d+3*t10*t
     1         7*t99-2.4564017822744336d+1*t10*t99/t14-3.241102131445757
     2         d+2*t10*t6*t98+5.401836885742928d+1*t10*t8*t96-8.55188292
     3         3536147d-2*t95+t10*(5.701255282357431d-2*t95-5.2771449813
     4         7176d-4*t114)+2.626185756615557d+4*t10*t100*t8+5.27714498
     5         137176d-4*t114)+2.850627641178715d-2*t101*t96-1.900418427
     6         4524766d-2*t11*t95
            t116 = 1/rhoa**7.333333333333333d+0
            t117 = 1/rhoa**4.666666666666667d+0
            t118 = 2.4814019635976003d+0*t102*t5+9.305257363491002d-1*t1
     1         15*t4+4.135669939329334d-1*t100*t12-4.135669939329334d-1*
     2         t100
            t119 = 1/rhoa**5
            t120 = 1/rhoa**6.333333333333333d+0
            t121 = 1/rhoa**4
            t122 = 1/rhoa**5.333333333333333d+0
            fnc(iq) = 2.0d+0*(t51*t64*t88+t3*t64*t76-9.305257363491002d-
     1         1*t12*t4*t51*t63-9.305257363491002d-1*t12*t3*t4*t49)*wght
     2         +fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(8.963083509889702d-3*gammaaa*t12*t4
     1         9*t94*t95+5.041016444533138d-3*gammaaa*t12*t50*t63*t95-9.
     2         632279000746596d-3*gammaaa*t103*t64*t76*t94+t51*t64*t93+t
     3         3*t64*t92-9.305257363491002d-1*t12*t4*t51*t91-9.305257363
     4         491002d-1*t12*t3*t4*t90-5.417385299101419d-3*gammaaa*t103
     5         *t50*t64*t88+t104*t51*t88+t104*t3*t76-1.2407009817988002d
     6         +0*t12*t5*t51*t63-9.305257363491002d-1*t102*t4*t51*t63-1.
     7         2407009817988002d+0*t12*t3*t49*t5-9.305257363491002d-1*t1
     8         02*t3*t4*t49)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(-3.361156316208638d-3*t12*t49*t94*
     1         t96-1.890381166699927d-3*t12*t50*t63*t96+3.61210462527997
     2         4d-3*t1*t64*t76*t94+2.0315194871630324d-3*t1*t50*t64*t88)
     3         *wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Mmat(iq,D1_TA) = 1.0d+0*(t108*t51*t64+t107*t3*t64-9.30525736
     1         3491002d-1*t106*t12*t4*t51-9.305257363491002d-1*t105*t12*
     2         t3*t4)*wght+Mmat(iq,D1_TA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*((1.7926167019779404d-2*gammaaa*
     1         t12*t90+1.7926167019779404d-2*gammaaa*t102*t49)*t94*t95+(
     2         1.0082032889066277d-2*gammaaa*t12*t50*t91+1.0082032889066
     3         277d-2*gammaaa*t102*t50*t63)*t95+t103*(-1.926455800149319
     4         3d-2*gammaaa*t64*t92-1.9264558001493193d-2*gammaaa*t104*t
     5         76)*t94+3.5318356336070855d-2*gammaaa*t117*t64*t76*t94-8.
     6         963083509889707d-3*gammaaa*t113*t12*t49*t94+t103*(-1.0834
     7         770598202839d-2*gammaaa*t50*t64*t93-1.0834770598202839d-2
     8         *gammaaa*t104*t50*t88)+2*t104*t51*t93+2*t104*t3*t92-2.481
     9         4019635976003d+0*t12*t5*t51*t91-1.8610514726982003d+0*t10
     :         2*t4*t51*t91-2.4814019635976003d+0*t12*t3*t5*t90-1.861051
     ;         4726982003d+0*t102*t3*t4*t90+t51*t64*(2.5389881826654315d
     <         +4*t21*t4*t78*t89-1.1141288576844789d+2*t17*t6*t77*t89-5.
     =         585774001863949d+4*t21*t4*t77*t89+1.0128444160767991d+1*t
     >         48*t6*t87-1.0128444160767991d+1*t16*t46*t6*t87-4.61634215
     ?         03007845d+2*t4*t46*t87+4.6163421503007845d+2*t16*t4*t43*t
     @         87+2.0256888321535982d+1*t16*t46*t6*t86-2.025688832153598
     1         2d+1*t43*t45*t6*t86+4.6163421503007845d+2*t4*t46*t86+1.38
     2         49026450902355d+3*t4*t40*t45*t86-1.846536860120314d+3*t16
     3         *t4*t43*t86+3.038533248230397d+1*t43*t45*t6*t85-3.0385332
     4         48230397d+1*t40*t42*t6*t85-4.1547079352707067d+3*t4*t40*t
     5         45*t85+1.3849026450902355d+3*t16*t4*t43*t85+2.76980529018
     6         0471d+3*t37*t4*t42*t85+4.0513776643071964d+1*t40*t42*t6*t
     7         84-4.0513776643071964d+1*t37*t39*t6*t84+2.769805290180471
     8         d+3*t4*t40*t45*t84-7.386147440481255d+3*t37*t4*t42*t84+4.
     9         616342150300784d+3*t34*t39*t4*t84+5.064222080383994d+1*t3
     :         7*t39*t6*t83-5.064222080383994d+1*t34*t36*t6*t83+4.616342
     ;         150300784d+3*t37*t4*t42*t83-1.154085537575196d+4*t34*t39*
     <         t4*t83+6.924513225451178d+3*t31*t36*t4*t83+6.077066496460
     =         795d+1*t34*t36*t6*t82-6.077066496460795d+1*t31*t33*t6*t82
     >         +6.924513225451178d+3*t34*t39*t4*t82-1.661883174108283d+4
     ?         *t31*t36*t4*t82+9.694318515631648d+3*t28*t33*t4*t82+7.089
     @         910912537593d+1*t31*t33*t6*t81-7.089910912537593d+1*t28*t
     1         30*t6*t81+9.694318515631648d+3*t31*t36*t4*t81-2.262007653
     2         6473846d+4*t28*t33*t4*t81+1.2925758020842196d+4*t25*t30*t
     3         4*t81+8.102755328614393d+1*t28*t30*t6*t80-8.1027553286143
     4         93d+1*t25*t27*t6*t80+1.2925758020842196d+4*t28*t33*t4*t80
     5         -2.954458976192502d+4*t25*t30*t4*t80+1.6618831741082823d+
     6         4*t22*t27*t4*t80+9.115599744691191d+1*t25*t27*t6*t79-9.11
     7         5599744691191d+1*t22*t24*t6*t79+1.6618831741082823d+4*t25
     8         *t30*t4*t79-3.7392371417436354d+4*t22*t27*t4*t79+2.077353
     9         9676353528d+4*t19*t24*t4*t79+1.012844416076799d+2*t22*t24
     :         *t6*t78-1.012844416076799d+2*t19*t21*t6*t78+2.07735396763
     ;         53528d+4*t22*t27*t4*t78-4.616342150300784d+4*t19*t24*t4*t
     <         78+1.1141288576844789d+2*t19*t21*t6*t77+2.538988182665431
     =         5d+4*t19*t24*t4*t77+3.046785819198518d+4*t109*t17*t4*t77)
     >         +t3*t64*(2.5389881826654315d+4*t21*t4*t66*t89-1.114128857
     ?         6844789d+2*t17*t6*t65*t89-5.585774001863949d+4*t21*t4*t65
     @         *t89+1.0128444160767991d+1*t48*t6*t75-1.0128444160767991d
     1         +1*t16*t46*t6*t75-4.6163421503007845d+2*t4*t46*t75+4.6163
     2         421503007845d+2*t16*t4*t43*t75+2.0256888321535982d+1*t16*
     3         t46*t6*t74-2.0256888321535982d+1*t43*t45*t6*t74+4.6163421
     4         503007845d+2*t4*t46*t74+1.3849026450902355d+3*t4*t40*t45*
     5         t74-1.846536860120314d+3*t16*t4*t43*t74+3.038533248230397
     6         d+1*t43*t45*t6*t73-3.038533248230397d+1*t40*t42*t6*t73-4.
     7         1547079352707067d+3*t4*t40*t45*t73+1.3849026450902355d+3*
     8         t16*t4*t43*t73+2.769805290180471d+3*t37*t4*t42*t73+4.0513
     9         776643071964d+1*t40*t42*t6*t72-4.0513776643071964d+1*t37*
     :         t39*t6*t72+2.769805290180471d+3*t4*t40*t45*t72-7.38614744
     ;         0481255d+3*t37*t4*t42*t72+4.616342150300784d+3*t34*t39*t4
     <         *t72+5.064222080383994d+1*t37*t39*t6*t71-5.06422208038399
     =         4d+1*t34*t36*t6*t71+4.616342150300784d+3*t37*t4*t42*t71-1
     >         .154085537575196d+4*t34*t39*t4*t71+6.924513225451178d+3*t
     ?         31*t36*t4*t71+6.077066496460795d+1*t34*t36*t6*t70-6.07706
     @         6496460795d+1*t31*t33*t6*t70+6.924513225451178d+3*t34*t39
     1         *t4*t70-1.661883174108283d+4*t31*t36*t4*t70+9.69431851563
     2         1648d+3*t28*t33*t4*t70+7.089910912537593d+1*t31*t33*t6*t6
     3         9-7.089910912537593d+1*t28*t30*t6*t69+9.694318515631648d+
     4         3*t31*t36*t4*t69-2.2620076536473846d+4*t28*t33*t4*t69+1.2
     5         925758020842196d+4*t25*t30*t4*t69+8.102755328614393d+1*t2
     6         8*t30*t6*t68-8.102755328614393d+1*t25*t27*t6*t68+1.292575
     7         8020842196d+4*t28*t33*t4*t68-2.954458976192502d+4*t25*t30
     8         *t4*t68+1.6618831741082823d+4*t22*t27*t4*t68+9.1155997446
     9         91191d+1*t25*t27*t6*t67-9.115599744691191d+1*t22*t24*t6*t
     :         67+1.6618831741082823d+4*t25*t30*t4*t67-3.739237141743635
     ;         4d+4*t22*t27*t4*t67+2.0773539676353528d+4*t19*t24*t4*t67+
     <         1.012844416076799d+2*t22*t24*t6*t66-1.012844416076799d+2*
     =         t19*t21*t6*t66+2.0773539676353528d+4*t22*t27*t4*t66-4.616
     >         342150300784d+4*t19*t24*t4*t66+1.1141288576844789d+2*t19*
     ?         t21*t6*t65+2.5389881826654315d+4*t19*t24*t4*t65+3.0467858
     @         19198518d+4*t109*t17*t4*t65)-9.305257363491002d-1*t12*t4*
     1         t51*(-1.1141288576844789d+2*t17*t52*t6*t89+2.538988182665
     2         4315d+4*t21*t4*t53*t89-5.585774001863949d+4*t21*t4*t52*t8
     3         9+1.0128444160767991d+1*t48*t6*t62-1.0128444160767991d+1*
     4         t16*t46*t6*t62-4.6163421503007845d+2*t4*t46*t62+4.6163421
     5         503007845d+2*t16*t4*t43*t62+2.0256888321535982d+1*t16*t46
     6         *t6*t61-2.0256888321535982d+1*t43*t45*t6*t61+4.6163421503
     7         007845d+2*t4*t46*t61+1.3849026450902355d+3*t4*t40*t45*t61
     8         -1.846536860120314d+3*t16*t4*t43*t61+3.038533248230397d+1
     9         *t43*t45*t6*t60-3.038533248230397d+1*t40*t42*t6*t60-4.154
     :         7079352707067d+3*t4*t40*t45*t60+1.3849026450902355d+3*t16
     ;         *t4*t43*t60+2.769805290180471d+3*t37*t4*t42*t60+4.0513776
     <         643071964d+1*t40*t42*t59*t6-4.0513776643071964d+1*t37*t39
     =         *t59*t6+5.064222080383994d+1*t37*t39*t58*t6-5.06422208038
     >         3994d+1*t34*t36*t58*t6+6.077066496460795d+1*t34*t36*t57*t
     ?         6-6.077066496460795d+1*t31*t33*t57*t6+7.089910912537593d+
     @         1*t31*t33*t56*t6-7.089910912537593d+1*t28*t30*t56*t6+8.10
     1         2755328614393d+1*t28*t30*t55*t6-8.102755328614393d+1*t25*
     2         t27*t55*t6+9.115599744691191d+1*t25*t27*t54*t6-9.11559974
     3         4691191d+1*t22*t24*t54*t6+1.012844416076799d+2*t22*t24*t5
     4         3*t6-1.012844416076799d+2*t19*t21*t53*t6+1.11412885768447
     5         89d+2*t19*t21*t52*t6+2.769805290180471d+3*t4*t40*t45*t59-
     6         7.386147440481255d+3*t37*t4*t42*t59+4.616342150300784d+3*
     7         t34*t39*t4*t59+4.616342150300784d+3*t37*t4*t42*t58-1.1540
     8         85537575196d+4*t34*t39*t4*t58+6.924513225451178d+3*t31*t3
     9         6*t4*t58+6.924513225451178d+3*t34*t39*t4*t57-1.6618831741
     :         08283d+4*t31*t36*t4*t57+9.694318515631648d+3*t28*t33*t4*t
     ;         57+9.694318515631648d+3*t31*t36*t4*t56-2.2620076536473846
     <         d+4*t28*t33*t4*t56+1.2925758020842196d+4*t25*t30*t4*t56+1
     =         .2925758020842196d+4*t28*t33*t4*t55-2.954458976192502d+4*
     >         t25*t30*t4*t55+1.6618831741082823d+4*t22*t27*t4*t55+1.661
     ?         8831741082823d+4*t25*t30*t4*t54-3.7392371417436354d+4*t22
     @         *t27*t4*t54+2.0773539676353528d+4*t19*t24*t4*t54+2.077353
     1         9676353528d+4*t22*t27*t4*t53-4.616342150300784d+4*t19*t24
     2         *t4*t53+2.5389881826654315d+4*t19*t24*t4*t52+3.0467858191
     3         98518d+4*t109*t17*t4*t52)-9.305257363491002d-1*t12*t3*t4*
     4         (-1.1141288576844789d+2*t13*t17*t6*t89+2.5389881826654315
     5         d+4*t20*t21*t4*t89-5.585774001863949d+4*t13*t21*t4*t89+1.
     6         0128444160767991d+1*t47*t48*t6-1.0128444160767991d+1*t16*
     7         t46*t47*t6+2.0256888321535982d+1*t16*t44*t46*t6-2.0256888
     8         321535982d+1*t43*t44*t45*t6+3.038533248230397d+1*t41*t43*
     9         t45*t6-3.038533248230397d+1*t40*t41*t42*t6+4.051377664307
     :         1964d+1*t38*t40*t42*t6-4.0513776643071964d+1*t37*t38*t39*
     ;         t6+5.064222080383994d+1*t35*t37*t39*t6-5.064222080383994d
     <         +1*t34*t35*t36*t6+6.077066496460795d+1*t32*t34*t36*t6-6.0
     =         77066496460795d+1*t31*t32*t33*t6+7.089910912537593d+1*t29
     >         *t31*t33*t6-7.089910912537593d+1*t28*t29*t30*t6+8.1027553
     ?         28614393d+1*t26*t28*t30*t6-8.102755328614393d+1*t25*t26*t
     @         27*t6+9.115599744691191d+1*t23*t25*t27*t6-9.1155997446911
     1         91d+1*t22*t23*t24*t6+1.012844416076799d+2*t20*t22*t24*t6-
     2         1.012844416076799d+2*t19*t20*t21*t6+1.1141288576844789d+2
     3         *t13*t19*t21*t6-4.6163421503007845d+2*t4*t46*t47+4.616342
     4         1503007845d+2*t16*t4*t43*t47+4.6163421503007845d+2*t4*t44
     5         *t46+1.3849026450902355d+3*t4*t40*t44*t45-4.1547079352707
     6         067d+3*t4*t40*t41*t45+2.769805290180471d+3*t38*t4*t40*t45
     7         -1.846536860120314d+3*t16*t4*t43*t44+1.3849026450902355d+
     8         3*t16*t4*t41*t43+2.769805290180471d+3*t37*t4*t41*t42-7.38
     9         6147440481255d+3*t37*t38*t4*t42+4.616342150300784d+3*t35*
     :         t37*t4*t42+4.616342150300784d+3*t34*t38*t39*t4-1.15408553
     ;         7575196d+4*t34*t35*t39*t4+6.924513225451178d+3*t32*t34*t3
     <         9*t4+6.924513225451178d+3*t31*t35*t36*t4-1.66188317410828
     =         3d+4*t31*t32*t36*t4+9.694318515631648d+3*t29*t31*t36*t4+9
     >         .694318515631648d+3*t28*t32*t33*t4-2.2620076536473846d+4*
     ?         t28*t29*t33*t4+1.2925758020842196d+4*t26*t28*t33*t4+1.292
     @         5758020842196d+4*t25*t29*t30*t4-2.954458976192502d+4*t25*
     1         t26*t30*t4+1.6618831741082823d+4*t23*t25*t30*t4+1.6618831
     2         741082823d+4*t22*t26*t27*t4-3.7392371417436354d+4*t22*t23
     3         *t27*t4+2.0773539676353528d+4*t20*t22*t27*t4+2.0773539676
     4         353528d+4*t19*t23*t24*t4-4.616342150300784d+4*t19*t20*t24
     5         *t4+2.5389881826654315d+4*t13*t19*t24*t4+3.04678581919851
     6         8d+4*t109*t13*t17*t4)+1.9863746096705204d-2*gammaaa*t117*
     7         t50*t64*t88-5.316678166471045d-5*t110*t116*t50*t64*t88+t1
     8         18*t51*t88-2.3079800683637772d-4*t110*t111*t116*t64*t76+t
     9         118*t3*t76+t100*(-4.135669939329334d-1*t12*t51*t63-4.1356
     :         69939329334d-1*t12*t3*t49)-2.4814019635976003d+0*t102*t5*
     ;         t51*t63-9.305257363491002d-1*t115*t4*t51*t63-5.0410164445
     <         33138d-3*gammaaa*t113*t12*t50*t63+4.947305865786653d-5*t1
     =         10*t112*t12*t50*t63-2.4814019635976003d+0*t102*t3*t49*t5-
     >         9.305257363491002d-1*t115*t3*t4*t49+2.1476348525932504d-4
     ?         *t110*t111*t112*t12*t49)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*((-3.361156316208638d-3*t12*t90
     1         -3.361156316208638d-3*t102*t49)*t94*t96+(-1.8903811666999
     2         27d-3*t12*t50*t91-1.890381166699927d-3*t102*t50*t63)*t96+
     3         4.481541754944851d-3*t12*t49*t94*t95+2.520508222266569d-3
     4         *t12*t50*t63*t95+t1*(3.612104625279974d-3*t64*t92+3.61210
     5         4625279974d-3*t104*t76)*t94-9.632279000746596d-3*t103*t64
     6         *t76*t94+t1*(2.0315194871630324d-3*t50*t64*t93+2.03151948
     7         71630324d-3*t104*t50*t88)+1.9937543124266421d-5*gammaaa*t
     8         120*t50*t64*t88-5.417385299101419d-3*t103*t50*t64*t88+8.6
     9         54925256364164d-5*gammaaa*t111*t120*t64*t76-1.85523969966
     :         9995d-5*gammaaa*t119*t12*t50*t63-8.05363069722469d-5*gamm
     ;         aaa*t111*t119*t12*t49)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(-7.476578671599909d-6*t122*t5
     1         0*t64*t88-3.245596971136562d-5*t111*t122*t64*t76+6.957148
     2         873762482d-6*t12*t121*t50*t63+3.020111511459258d-5*t111*t
     3         12*t121*t49)*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Mmat2(iq,D2_RA_TA) = 1.0d+0*(8.963083509889702d-3*gammaaa*t1
     1         05*t12*t94*t95+5.041016444533138d-3*gammaaa*t106*t12*t50*
     2         t95-9.632279000746596d-3*gammaaa*t103*t107*t64*t94+t51*t6
     3         4*(3.342386573053437d+3*t21*t78*t89*t9+6.077066496460795d
     4         +1*t16*t43*t87*t9-6.077066496460795d+1*t46*t86*t9+1.82311
     5         99489382385d+2*t40*t45*t86*t9-1.8231199489382385d+2*t16*t
     6         43*t85*t9+3.646239897876477d+2*t37*t42*t85*t9-3.646239897
     7         876477d+2*t40*t45*t84*t9+6.077066496460795d+2*t34*t39*t84
     8         *t9-6.077066496460795d+2*t37*t42*t83*t9+9.115599744691192
     9         d+2*t31*t36*t83*t9-9.115599744691192d+2*t34*t39*t82*t9+1.
     :         276183964256767d+3*t28*t33*t82*t9-1.276183964256767d+3*t3
     ;         1*t36*t81*t9+1.7015786190090226d+3*t25*t30*t81*t9-1.70157
     <         86190090226d+3*t28*t33*t80*t9+2.187743938725886d+3*t22*t2
     =         7*t80*t9-2.187743938725886d+3*t25*t30*t79*t9+2.7346799234
     >         07357d+3*t19*t24*t79*t9-2.734679923407357d+3*t22*t27*t78*
     ?         t9-3.342386573053437d+3*t19*t24*t77*t9+4.0108638876641245
     @         d+3*t109*t17*t77*t9)+t3*t64*(3.342386573053437d+3*t21*t66
     1         *t89*t9+6.077066496460795d+1*t16*t43*t75*t9-6.07706649646
     2         0795d+1*t46*t74*t9+1.8231199489382385d+2*t40*t45*t74*t9-1
     3         .8231199489382385d+2*t16*t43*t73*t9+3.646239897876477d+2*
     4         t37*t42*t73*t9-3.646239897876477d+2*t40*t45*t72*t9+6.0770
     5         66496460795d+2*t34*t39*t72*t9-6.077066496460795d+2*t37*t4
     6         2*t71*t9+9.115599744691192d+2*t31*t36*t71*t9-9.1155997446
     7         91192d+2*t34*t39*t70*t9+1.276183964256767d+3*t28*t33*t70*
     8         t9-1.276183964256767d+3*t31*t36*t69*t9+1.7015786190090226
     9         d+3*t25*t30*t69*t9-1.7015786190090226d+3*t28*t33*t68*t9+2
     :         .187743938725886d+3*t22*t27*t68*t9-2.187743938725886d+3*t
     ;         25*t30*t67*t9+2.734679923407357d+3*t19*t24*t67*t9-2.73467
     <         9923407357d+3*t22*t27*t66*t9-3.342386573053437d+3*t19*t24
     =         *t65*t9+4.0108638876641245d+3*t109*t17*t65*t9)-9.30525736
     >         3491002d-1*t12*t4*t51*(3.342386573053437d+3*t21*t53*t89*t
     ?         9+6.077066496460795d+1*t16*t43*t62*t9-6.077066496460795d+
     @         1*t46*t61*t9+1.8231199489382385d+2*t40*t45*t61*t9-1.82311
     1         99489382385d+2*t16*t43*t60*t9+3.646239897876477d+2*t37*t4
     2         2*t60*t9-3.646239897876477d+2*t40*t45*t59*t9+6.0770664964
     3         60795d+2*t34*t39*t59*t9-6.077066496460795d+2*t37*t42*t58*
     4         t9+9.115599744691192d+2*t31*t36*t58*t9-9.115599744691192d
     5         +2*t34*t39*t57*t9+1.276183964256767d+3*t28*t33*t57*t9-1.2
     6         76183964256767d+3*t31*t36*t56*t9+1.7015786190090226d+3*t2
     7         5*t30*t56*t9-1.7015786190090226d+3*t28*t33*t55*t9+2.18774
     8         3938725886d+3*t22*t27*t55*t9-2.187743938725886d+3*t25*t30
     9         *t54*t9+2.734679923407357d+3*t19*t24*t54*t9-2.73467992340
     :         7357d+3*t22*t27*t53*t9-3.342386573053437d+3*t19*t24*t52*t
     ;         9+4.0108638876641245d+3*t109*t17*t52*t9)-9.30525736349100
     <         2d-1*t12*t3*t4*(3.342386573053437d+3*t20*t21*t89*t9+6.077
     =         066496460795d+1*t16*t43*t47*t9-6.077066496460795d+1*t44*t
     >         46*t9+1.8231199489382385d+2*t40*t44*t45*t9-3.646239897876
     ?         477d+2*t38*t40*t45*t9-1.8231199489382385d+2*t16*t41*t43*t
     @         9+3.646239897876477d+2*t37*t41*t42*t9-6.077066496460795d+
     1         2*t35*t37*t42*t9+6.077066496460795d+2*t34*t38*t39*t9-9.11
     2         5599744691192d+2*t32*t34*t39*t9+9.115599744691192d+2*t31*
     3         t35*t36*t9-1.276183964256767d+3*t29*t31*t36*t9+1.27618396
     4         4256767d+3*t28*t32*t33*t9-1.7015786190090226d+3*t26*t28*t
     5         33*t9+1.7015786190090226d+3*t25*t29*t30*t9-2.187743938725
     6         886d+3*t23*t25*t30*t9+2.187743938725886d+3*t22*t26*t27*t9
     7         -2.734679923407357d+3*t20*t22*t27*t9+2.734679923407357d+3
     8         *t19*t23*t24*t9-3.342386573053437d+3*t13*t19*t24*t9+4.010
     9         8638876641245d+3*t109*t13*t17*t9)-5.417385299101419d-3*ga
     :         mmaaa*t103*t108*t50*t64-1.2407009817988002d+0*t106*t12*t5
     ;         *t51-9.305257363491002d-1*t102*t106*t4*t51+t104*t108*t51-
     <         1.2407009817988002d+0*t105*t12*t3*t5-9.305257363491002d-1
     =         *t102*t105*t3*t4+t104*t107*t3)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = 1.0d+0*(-3.361156316208638d-3*t105*t12
     1         *t94*t96-1.890381166699927d-3*t106*t12*t50*t96+3.61210462
     2         5279974d-3*t1*t107*t64*t94+2.0315194871630324d-3*t1*t108*
     3         t50*t64)*wght+Mmat2(iq,D2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_TA_TA) = 1.0d+0*(t51*t64*(4.4d+2*t21*t78*t89+9.6
     1         8d+2*t21*t77*t89+8.0d+0*t46*t87+8.0d+0*t16*t43*t87+8.0d+0
     2         *t46*t86+2.4d+1*t40*t45*t86+3.2d+1*t16*t43*t86+7.2d+1*t40
     3         *t45*t85+2.4d+1*t16*t43*t85+4.8d+1*t37*t42*t85+4.8d+1*t40
     4         *t45*t84+1.28d+2*t37*t42*t84+8.0d+1*t34*t39*t84+8.0d+1*t3
     5         7*t42*t83+2.0d+2*t34*t39*t83+1.2d+2*t31*t36*t83+1.2d+2*t3
     6         4*t39*t82+2.88d+2*t31*t36*t82+1.68d+2*t28*t33*t82+1.68d+2
     7         *t31*t36*t81+3.92d+2*t28*t33*t81+2.24d+2*t25*t30*t81+2.24
     8         d+2*t28*t33*t80+5.12d+2*t25*t30*t80+2.88d+2*t22*t27*t80+2
     9         .88d+2*t25*t30*t79+6.48d+2*t22*t27*t79+3.6d+2*t19*t24*t79
     :         +3.6d+2*t22*t27*t78+8.0d+2*t19*t24*t78+4.4d+2*t19*t24*t77
     ;         +5.28d+2*t109*t17*t77)+t3*t64*(4.4d+2*t21*t66*t89+9.68d+2
     <         *t21*t65*t89+8.0d+0*t46*t75+8.0d+0*t16*t43*t75+8.0d+0*t46
     =         *t74+2.4d+1*t40*t45*t74+3.2d+1*t16*t43*t74+7.2d+1*t40*t45
     >         *t73+2.4d+1*t16*t43*t73+4.8d+1*t37*t42*t73+4.8d+1*t40*t45
     ?         *t72+1.28d+2*t37*t42*t72+8.0d+1*t34*t39*t72+8.0d+1*t37*t4
     @         2*t71+2.0d+2*t34*t39*t71+1.2d+2*t31*t36*t71+1.2d+2*t34*t3
     1         9*t70+2.88d+2*t31*t36*t70+1.68d+2*t28*t33*t70+1.68d+2*t31
     2         *t36*t69+3.92d+2*t28*t33*t69+2.24d+2*t25*t30*t69+2.24d+2*
     3         t28*t33*t68+5.12d+2*t25*t30*t68+2.88d+2*t22*t27*t68+2.88d
     4         +2*t25*t30*t67+6.48d+2*t22*t27*t67+3.6d+2*t19*t24*t67+3.6
     5         d+2*t22*t27*t66+8.0d+2*t19*t24*t66+4.4d+2*t19*t24*t65+5.2
     6         8d+2*t109*t17*t65)-9.305257363491002d-1*t12*t4*t51*(4.4d+
     7         2*t21*t53*t89+9.68d+2*t21*t52*t89+8.0d+0*t46*t62+8.0d+0*t
     8         16*t43*t62+8.0d+0*t46*t61+2.4d+1*t40*t45*t61+3.2d+1*t16*t
     9         43*t61+7.2d+1*t40*t45*t60+2.4d+1*t16*t43*t60+4.8d+1*t37*t
     :         42*t60+4.8d+1*t40*t45*t59+1.28d+2*t37*t42*t59+8.0d+1*t34*
     ;         t39*t59+8.0d+1*t37*t42*t58+2.0d+2*t34*t39*t58+1.2d+2*t31*
     <         t36*t58+1.2d+2*t34*t39*t57+2.88d+2*t31*t36*t57+1.68d+2*t2
     =         8*t33*t57+1.68d+2*t31*t36*t56+3.92d+2*t28*t33*t56+2.24d+2
     >         *t25*t30*t56+2.24d+2*t28*t33*t55+5.12d+2*t25*t30*t55+2.88
     ?         d+2*t22*t27*t55+2.88d+2*t25*t30*t54+6.48d+2*t22*t27*t54+3
     @         .6d+2*t19*t24*t54+3.6d+2*t22*t27*t53+8.0d+2*t19*t24*t53+4
     1         .4d+2*t19*t24*t52+5.28d+2*t109*t17*t52)-9.305257363491002
     2         d-1*t12*t3*t4*(4.4d+2*t20*t21*t89+9.68d+2*t13*t21*t89+8.0
     3         d+0*t46*t47+8.0d+0*t16*t43*t47+8.0d+0*t44*t46+2.4d+1*t40*
     4         t44*t45+7.2d+1*t40*t41*t45+4.8d+1*t38*t40*t45+3.2d+1*t16*
     5         t43*t44+2.4d+1*t16*t41*t43+4.8d+1*t37*t41*t42+1.28d+2*t37
     6         *t38*t42+8.0d+1*t35*t37*t42+8.0d+1*t34*t38*t39+2.0d+2*t34
     7         *t35*t39+1.2d+2*t32*t34*t39+1.2d+2*t31*t35*t36+2.88d+2*t3
     8         1*t32*t36+1.68d+2*t29*t31*t36+1.68d+2*t28*t32*t33+3.92d+2
     9         *t28*t29*t33+2.24d+2*t26*t28*t33+2.24d+2*t25*t29*t30+5.12
     :         d+2*t25*t26*t30+2.88d+2*t23*t25*t30+2.88d+2*t22*t26*t27+6
     ;         .48d+2*t22*t23*t27+3.6d+2*t20*t22*t27+3.6d+2*t19*t23*t24+
     <         8.0d+2*t19*t20*t24+4.4d+2*t13*t19*t24+5.28d+2*t109*t13*t1
     =         7))*wght+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = rhoa**3.333333333333333d-1
            t6 = 1/t5
            t7 = 1/rhoa
            t8 = 1.282782438530422d-1*t6-2.63857249068588d-4*t7
            t9 = rhoa**6.666666666666666d-1
            t10 = exp(-2.4308265985843178d+2*t9)
            t11 = t10*t8+2.63857249068588d-4*t7-1.924173657795633d-1*t6+
     1         3.544907701811032d+0*erf(1.5591108358883013d+1*t5)
            t12 = 1.0d+0-4.275941461768073d-2*t11*t6
            t13 = param(1)
            t14 = param(12)
            t15 = rhoa**1.6666666666666669d+0
            t16 = 9.115599744691192d+0*t15
            t17 = t16-2.0d+0*taua
            t18 = t17**11
            t19 = 2.0d+0*taua+t16
            t20 = 1/t19**11
            t21 = param(11)
            t22 = t17**10
            t23 = 1/t19**10
            t24 = param(10)
            t25 = t17**9
            t26 = 1/t19**9
            t27 = param(9)
            t28 = t17**8
            t29 = 1/t19**8
            t30 = param(8)
            t31 = t17**7
            t32 = 1/t19**7
            t33 = param(7)
            t34 = t17**6
            t35 = 1/t19**6
            t36 = param(6)
            t37 = t17**5
            t38 = 1/t19**5
            t39 = param(5)
            t40 = t17**4
            t41 = 1/t19**4
            t42 = param(4)
            t43 = t17**3
            t44 = 1/t19**3
            t45 = param(3)
            t46 = t17**2
            t47 = 1/t19**2
            t48 = param(2)
            t49 = 1/t19
            t50 = t17*t48*t49+t45*t46*t47+t42*t43*t44+t39*t40*t41+t36*t3
     1         7*t38+t33*t34*t35+t30*t31*t32+t27*t28*t29+t24*t25*t26+t21
     2         *t22*t23+t14*t18*t20+t13
            t51 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t52 = 5.52d-1*(1.0d+0-t51)+1.0d+0
            t53 = param(13)
            t54 = param(24)
            t55 = param(23)
            t56 = param(22)
            t57 = param(21)
            t58 = param(20)
            t59 = param(19)
            t60 = param(18)
            t61 = param(17)
            t62 = param(16)
            t63 = param(15)
            t64 = param(14)
            t65 = t17*t49*t64+t46*t47*t63+t43*t44*t62+t40*t41*t61+t37*t3
     1         8*t60+t34*t35*t59+t31*t32*t58+t28*t29*t57+t25*t26*t56+t22
     2         *t23*t55+t18*t20*t54+t53
            t66 = 9.305257363491002d-1*t12*t4-9.305257363491002d-1*t4
            t67 = param(25)
            t68 = param(36)
            t69 = param(35)
            t70 = param(34)
            t71 = param(33)
            t72 = param(32)
            t73 = param(31)
            t74 = param(30)
            t75 = param(29)
            t76 = param(28)
            t77 = param(27)
            t78 = param(26)
            t79 = t17*t49*t78+t46*t47*t77+t43*t44*t76+t40*t41*t75+t37*t3
     1         8*t74+t34*t35*t73+t31*t32*t72+t28*t29*t71+t25*t26*t70+t22
     2         *t23*t69+t18*t20*t68+t67
            t80 = param(37)
            t81 = param(48)
            t82 = param(47)
            t83 = param(46)
            t84 = param(45)
            t85 = param(44)
            t86 = param(43)
            t87 = param(42)
            t88 = param(41)
            t89 = param(40)
            t90 = param(39)
            t91 = param(38)
            t92 = t17*t49*t91+t46*t47*t90+t43*t44*t89+t40*t41*t88+t37*t3
     1         8*t87+t34*t35*t86+t31*t32*t85+t28*t29*t84+t25*t26*t83+t22
     2         *t23*t82+t18*t20*t81+t80
            t93 = 1/rhob**2.6666666666666666d+0
            t94 = 4.492667444378077d-3*gammabb*t93+1.0d+0
            t95 = 8.04d-1*(1.0d+0-1.0d+0/t94)+1.0d+0
            t96 = rhob**1.3333333333333333d+0
            t97 = rhob**3.333333333333333d-1
            t98 = 1/t97
            t99 = 1/rhob
            t100 = 1.282782438530422d-1*t98-2.63857249068588d-4*t99
            t101 = rhob**6.666666666666666d-1
            t102 = exp(-2.4308265985843178d+2*t101)
            t103 = 2.63857249068588d-4*t99-1.924173657795633d-1*t98+3.54
     1         4907701811032d+0*erf(1.5591108358883013d+1*t97)+t100*t102
            t104 = 1.0d+0-4.275941461768073d-2*t103*t98
            t105 = rhob**1.6666666666666669d+0
            t106 = 9.115599744691192d+0*t105
            t107 = t106-2.0d+0*taub
            t108 = t107**11
            t109 = 2.0d+0*taub+t106
            t110 = 1/t109**11
            t111 = t107**10
            t112 = 1/t109**10
            t113 = t107**9
            t114 = 1/t109**9
            t115 = t107**8
            t116 = 1/t109**8
            t117 = t107**7
            t118 = 1/t109**7
            t119 = t107**6
            t120 = 1/t109**6
            t121 = t107**5
            t122 = 1/t109**5
            t123 = t107**4
            t124 = 1/t109**4
            t125 = t107**3
            t126 = 1/t109**3
            t127 = t107**2
            t128 = 1/t109**2
            t129 = 1/t109
            t130 = t107*t129*t48+t127*t128*t45+t125*t126*t42+t123*t124*t
     1         39+t121*t122*t36+t119*t120*t33+t117*t118*t30+t115*t116*t2
     2         7+t113*t114*t24+t111*t112*t21+t108*t110*t14+t13
            t131 = exp(-3.6802889260199856d-3*gammabb*t93)
            t132 = 5.52d-1*(1.0d+0-t131)+1.0d+0
            t133 = t107*t129*t64+t127*t128*t63+t125*t126*t62+t123*t124*t
     1         61+t121*t122*t60+t119*t120*t59+t117*t118*t58+t115*t116*t5
     2         7+t113*t114*t56+t111*t112*t55+t108*t110*t54+t53
            t134 = 9.305257363491002d-1*t104*t96-9.305257363491002d-1*t9
     1         6
            t135 = t107*t129*t78+t127*t128*t77+t125*t126*t76+t123*t124*t
     1         75+t121*t122*t74+t119*t120*t73+t117*t118*t72+t115*t116*t7
     2         1+t113*t114*t70+t111*t112*t69+t108*t110*t68+t67
            t136 = t107*t129*t91+t127*t128*t90+t125*t126*t89+t123*t124*t
     1         88+t121*t122*t87+t119*t120*t86+t117*t118*t85+t115*t116*t8
     2         4+t113*t114*t83+t111*t112*t82+t108*t110*t81+t80
            t137 = 1/t19**12
            t138 = 1.5192666241151986d+1*t48*t49*t9-1.5192666241151986d+
     1         1*t17*t47*t48*t9+3.038533248230397d+1*t17*t45*t47*t9-3.03
     2         8533248230397d+1*t44*t45*t46*t9+4.5577998723455965d+1*t42
     3         *t44*t46*t9-4.5577998723455965d+1*t41*t42*t43*t9+6.077066
     4         496460795d+1*t39*t41*t43*t9-6.077066496460795d+1*t38*t39*
     5         t40*t9+7.596333120575993d+1*t36*t38*t40*t9-7.596333120575
     6         993d+1*t35*t36*t37*t9+9.115599744691193d+1*t33*t35*t37*t9
     7         -9.115599744691193d+1*t32*t33*t34*t9+1.0634866368806391d+
     8         2*t30*t32*t34*t9-1.0634866368806391d+2*t29*t30*t31*t9+1.2
     9         154132992921589d+2*t27*t29*t31*t9-1.2154132992921589d+2*t
     :         26*t27*t28*t9+1.3673399617036788d+2*t24*t26*t28*t9-1.3673
     ;         399617036788d+2*t23*t24*t25*t9+1.5192666241151986d+2*t21*
     <         t23*t25*t9-1.5192666241151986d+2*t20*t21*t22*t9+1.6711932
     =         865267184d+2*t14*t20*t22*t9-1.6711932865267184d+2*t137*t1
     >         4*t18*t9
            t139 = 1.5192666241151986d+1*t49*t64*t9-1.5192666241151986d+
     1         1*t17*t47*t64*t9+3.038533248230397d+1*t17*t47*t63*t9-3.03
     2         8533248230397d+1*t44*t46*t63*t9+4.5577998723455965d+1*t44
     3         *t46*t62*t9-4.5577998723455965d+1*t41*t43*t62*t9+6.077066
     4         496460795d+1*t41*t43*t61*t9-6.077066496460795d+1*t38*t40*
     5         t61*t9+7.596333120575993d+1*t38*t40*t60*t9-7.596333120575
     6         993d+1*t35*t37*t60*t9+9.115599744691193d+1*t35*t37*t59*t9
     7         -9.115599744691193d+1*t32*t34*t59*t9+1.0634866368806391d+
     8         2*t32*t34*t58*t9-1.0634866368806391d+2*t29*t31*t58*t9+1.2
     9         154132992921589d+2*t29*t31*t57*t9-1.2154132992921589d+2*t
     :         26*t28*t57*t9+1.3673399617036788d+2*t26*t28*t56*t9-1.3673
     ;         399617036788d+2*t23*t25*t56*t9+1.5192666241151986d+2*t23*
     <         t25*t55*t9-1.5192666241151986d+2*t20*t22*t55*t9+1.6711932
     =         865267184d+2*t20*t22*t54*t9-1.6711932865267184d+2*t137*t1
     >         8*t54*t9
            t140 = 1.5192666241151986d+1*t49*t78*t9-1.5192666241151986d+
     1         1*t17*t47*t78*t9+3.038533248230397d+1*t17*t47*t77*t9-3.03
     2         8533248230397d+1*t44*t46*t77*t9+4.5577998723455965d+1*t44
     3         *t46*t76*t9-4.5577998723455965d+1*t41*t43*t76*t9+6.077066
     4         496460795d+1*t41*t43*t75*t9-6.077066496460795d+1*t38*t40*
     5         t75*t9+7.596333120575993d+1*t38*t40*t74*t9-7.596333120575
     6         993d+1*t35*t37*t74*t9+9.115599744691193d+1*t35*t37*t73*t9
     7         -9.115599744691193d+1*t32*t34*t73*t9+1.0634866368806391d+
     8         2*t32*t34*t72*t9-1.0634866368806391d+2*t29*t31*t72*t9+1.2
     9         154132992921589d+2*t29*t31*t71*t9-1.2154132992921589d+2*t
     :         26*t28*t71*t9+1.3673399617036788d+2*t26*t28*t70*t9-1.3673
     ;         399617036788d+2*t23*t25*t70*t9+1.5192666241151986d+2*t23*
     <         t25*t69*t9-1.5192666241151986d+2*t20*t22*t69*t9+1.6711932
     =         865267184d+2*t20*t22*t68*t9-1.6711932865267184d+2*t137*t1
     >         8*t68*t9
            t141 = 1.5192666241151986d+1*t49*t9*t91-1.5192666241151986d+
     1         1*t17*t47*t9*t91+3.038533248230397d+1*t17*t47*t9*t90-3.03
     2         8533248230397d+1*t44*t46*t9*t90+4.5577998723455965d+1*t44
     3         *t46*t89*t9-4.5577998723455965d+1*t41*t43*t89*t9+6.077066
     4         496460795d+1*t41*t43*t88*t9-6.077066496460795d+1*t38*t40*
     5         t88*t9+7.596333120575993d+1*t38*t40*t87*t9-7.596333120575
     6         993d+1*t35*t37*t87*t9+9.115599744691193d+1*t35*t37*t86*t9
     7         -9.115599744691193d+1*t32*t34*t86*t9+1.0634866368806391d+
     8         2*t32*t34*t85*t9-1.0634866368806391d+2*t29*t31*t85*t9+1.2
     9         154132992921589d+2*t29*t31*t84*t9-1.2154132992921589d+2*t
     :         26*t28*t84*t9+1.3673399617036788d+2*t26*t28*t83*t9-1.3673
     ;         399617036788d+2*t23*t25*t83*t9+1.5192666241151986d+2*t23*
     <         t25*t82*t9-1.5192666241151986d+2*t20*t22*t82*t9+1.6711932
     =         865267184d+2*t20*t22*t81*t9-1.6711932865267184d+2*t137*t1
     >         8*t81*t9
            t142 = 1/t2**2
            t143 = 1/rhoa**2.3333333333333334d+0
            t144 = 1/t4
            t145 = 1/rhoa**2
            t146 = 2.63857249068588d-4*t145-4.2759414617680735d-2*t144
            t147 = 5.641895835477563d-1
            t148 = 1/t9
            t149 = -1.6205510657228786d+2*t10*t6*t8+3.6846026734116505d+
     1         1*t10*t147*t148+t10*t146-2.63857249068588d-4*t145+6.41391
     2         219265211d-2*t144
            t150 = 1.4253138205893576d-2*t11*t144-4.275941461768073d-2*t
     1         149*t6
            t151 = 1/rhoa**3.6666666666666664d+0
            t152 = 1.2407009817988002d+0*t12*t5-1.2407009817988002d+0*t5
     1         +9.305257363491002d-1*t150*t4
            t153 = 1/t109**12
            t154 = 1.5192666241151986d+1*t101*t129*t48-1.519266624115198
     1         6d+1*t101*t107*t128*t48+3.038533248230397d+1*t101*t107*t1
     2         28*t45-3.038533248230397d+1*t101*t126*t127*t45+4.55779987
     3         23455965d+1*t101*t126*t127*t42-4.5577998723455965d+1*t101
     4         *t124*t125*t42+6.077066496460795d+1*t101*t124*t125*t39-6.
     5         077066496460795d+1*t101*t122*t123*t39+7.596333120575993d+
     6         1*t101*t122*t123*t36-7.596333120575993d+1*t101*t120*t121*
     7         t36+9.115599744691193d+1*t101*t120*t121*t33-9.11559974469
     8         1193d+1*t101*t118*t119*t33+1.0634866368806391d+2*t101*t11
     9         8*t119*t30-1.0634866368806391d+2*t101*t116*t117*t30+1.215
     :         4132992921589d+2*t101*t116*t117*t27-1.2154132992921589d+2
     ;         *t101*t114*t115*t27+1.3673399617036788d+2*t101*t114*t115*
     <         t24-1.3673399617036788d+2*t101*t112*t113*t24+1.5192666241
     =         151986d+2*t101*t112*t113*t21-1.5192666241151986d+2*t101*t
     >         110*t111*t21-1.6711932865267184d+2*t101*t108*t14*t153+1.6
     ?         711932865267184d+2*t101*t110*t111*t14
            t155 = 1.5192666241151986d+1*t101*t129*t64-1.519266624115198
     1         6d+1*t101*t107*t128*t64+3.038533248230397d+1*t101*t107*t1
     2         28*t63-3.038533248230397d+1*t101*t126*t127*t63+4.55779987
     3         23455965d+1*t101*t126*t127*t62-4.5577998723455965d+1*t101
     4         *t124*t125*t62+6.077066496460795d+1*t101*t124*t125*t61-6.
     5         077066496460795d+1*t101*t122*t123*t61+7.596333120575993d+
     6         1*t101*t122*t123*t60-7.596333120575993d+1*t101*t120*t121*
     7         t60+9.115599744691193d+1*t101*t120*t121*t59-9.11559974469
     8         1193d+1*t101*t118*t119*t59+1.0634866368806391d+2*t101*t11
     9         8*t119*t58-1.0634866368806391d+2*t101*t116*t117*t58+1.215
     :         4132992921589d+2*t101*t116*t117*t57-1.2154132992921589d+2
     ;         *t101*t114*t115*t57+1.3673399617036788d+2*t101*t114*t115*
     <         t56-1.3673399617036788d+2*t101*t112*t113*t56+1.5192666241
     =         151986d+2*t101*t112*t113*t55-1.5192666241151986d+2*t101*t
     >         110*t111*t55-1.6711932865267184d+2*t101*t108*t153*t54+1.6
     ?         711932865267184d+2*t101*t110*t111*t54
            t156 = 1.5192666241151986d+1*t101*t129*t78-1.519266624115198
     1         6d+1*t101*t107*t128*t78+3.038533248230397d+1*t101*t107*t1
     2         28*t77-3.038533248230397d+1*t101*t126*t127*t77+4.55779987
     3         23455965d+1*t101*t126*t127*t76-4.5577998723455965d+1*t101
     4         *t124*t125*t76+6.077066496460795d+1*t101*t124*t125*t75-6.
     5         077066496460795d+1*t101*t122*t123*t75+7.596333120575993d+
     6         1*t101*t122*t123*t74-7.596333120575993d+1*t101*t120*t121*
     7         t74+9.115599744691193d+1*t101*t120*t121*t73-9.11559974469
     8         1193d+1*t101*t118*t119*t73+1.0634866368806391d+2*t101*t11
     9         8*t119*t72-1.0634866368806391d+2*t101*t116*t117*t72+1.215
     :         4132992921589d+2*t101*t116*t117*t71-1.2154132992921589d+2
     ;         *t101*t114*t115*t71+1.3673399617036788d+2*t101*t114*t115*
     <         t70-1.3673399617036788d+2*t101*t112*t113*t70+1.5192666241
     =         151986d+2*t101*t112*t113*t69-1.5192666241151986d+2*t101*t
     >         110*t111*t69-1.6711932865267184d+2*t101*t108*t153*t68+1.6
     ?         711932865267184d+2*t101*t110*t111*t68
            t157 = 1.5192666241151986d+1*t101*t129*t91-1.519266624115198
     1         6d+1*t101*t107*t128*t91+3.038533248230397d+1*t101*t107*t1
     2         28*t90-3.038533248230397d+1*t101*t126*t127*t90+4.55779987
     3         23455965d+1*t101*t126*t127*t89-4.5577998723455965d+1*t101
     4         *t124*t125*t89+6.077066496460795d+1*t101*t124*t125*t88-6.
     5         077066496460795d+1*t101*t122*t123*t88+7.596333120575993d+
     6         1*t101*t122*t123*t87-7.596333120575993d+1*t101*t120*t121*
     7         t87+9.115599744691193d+1*t101*t120*t121*t86-9.11559974469
     8         1193d+1*t101*t118*t119*t86+1.0634866368806391d+2*t101*t11
     9         8*t119*t85-1.0634866368806391d+2*t101*t116*t117*t85+1.215
     :         4132992921589d+2*t101*t116*t117*t84-1.2154132992921589d+2
     ;         *t101*t114*t115*t84+1.3673399617036788d+2*t101*t114*t115*
     <         t83-1.3673399617036788d+2*t101*t112*t113*t83+1.5192666241
     =         151986d+2*t101*t112*t113*t82-1.5192666241151986d+2*t101*t
     >         110*t111*t82-1.6711932865267184d+2*t101*t108*t153*t81+1.6
     ?         711932865267184d+2*t101*t110*t111*t81
            t158 = 1/t94**2
            t159 = 1/rhob**2.3333333333333334d+0
            t160 = 1/t96
            t161 = 1/rhob**2
            t162 = 2.63857249068588d-4*t161-4.2759414617680735d-2*t160
            t163 = 1/t101
            t164 = -1.6205510657228786d+2*t100*t102*t98+3.68460267341165
     1         05d+1*t102*t147*t163+t102*t162-2.63857249068588d-4*t161+6
     2         .41391219265211d-2*t160
            t165 = 1.4253138205893576d-2*t103*t160-4.275941461768073d-2*
     1         t164*t98
            t166 = 1/rhob**3.6666666666666664d+0
            t167 = 1.2407009817988002d+0*t104*t97-1.2407009817988002d+0*
     1         t97+9.305257363491002d-1*t165*t96
            t168 = -2.0d+0*t48*t49-2.0d+0*t17*t47*t48-4.0d+0*t17*t45*t47
     1         -4.0d+0*t44*t45*t46-6.0d+0*t42*t44*t46-6.0d+0*t41*t42*t43
     2         -8.0d+0*t39*t41*t43-8.0d+0*t38*t39*t40-1.0d+1*t36*t38*t40
     3         -1.0d+1*t35*t36*t37-1.2d+1*t33*t35*t37-1.2d+1*t32*t33*t34
     4         -1.4d+1*t30*t32*t34-1.4d+1*t29*t30*t31-1.6d+1*t27*t29*t31
     5         -1.6d+1*t26*t27*t28-1.8d+1*t24*t26*t28-1.8d+1*t23*t24*t25
     6         -2.0d+1*t21*t23*t25-2.0d+1*t20*t21*t22-2.2d+1*t14*t20*t22
     7         -2.2d+1*t137*t14*t18
            t169 = -2.0d+0*t49*t64-2.0d+0*t17*t47*t64-4.0d+0*t17*t47*t63
     1         -4.0d+0*t44*t46*t63-6.0d+0*t44*t46*t62-6.0d+0*t41*t43*t62
     2         -8.0d+0*t41*t43*t61-8.0d+0*t38*t40*t61-1.0d+1*t38*t40*t60
     3         -1.0d+1*t35*t37*t60-1.2d+1*t35*t37*t59-1.2d+1*t32*t34*t59
     4         -1.4d+1*t32*t34*t58-1.4d+1*t29*t31*t58-1.6d+1*t29*t31*t57
     5         -1.6d+1*t26*t28*t57-1.8d+1*t26*t28*t56-1.8d+1*t23*t25*t56
     6         -2.0d+1*t23*t25*t55-2.0d+1*t20*t22*t55-2.2d+1*t20*t22*t54
     7         -2.2d+1*t137*t18*t54
            t170 = -2.0d+0*t49*t78-2.0d+0*t17*t47*t78-4.0d+0*t17*t47*t77
     1         -4.0d+0*t44*t46*t77-6.0d+0*t44*t46*t76-6.0d+0*t41*t43*t76
     2         -8.0d+0*t41*t43*t75-8.0d+0*t38*t40*t75-1.0d+1*t38*t40*t74
     3         -1.0d+1*t35*t37*t74-1.2d+1*t35*t37*t73-1.2d+1*t32*t34*t73
     4         -1.4d+1*t32*t34*t72-1.4d+1*t29*t31*t72-1.6d+1*t29*t31*t71
     5         -1.6d+1*t26*t28*t71-1.8d+1*t26*t28*t70-1.8d+1*t23*t25*t70
     6         -2.0d+1*t23*t25*t69-2.0d+1*t20*t22*t69-2.2d+1*t20*t22*t68
     7         -2.2d+1*t137*t18*t68
            t171 = -2.0d+0*t49*t91-2.0d+0*t17*t47*t91-4.0d+0*t17*t47*t90
     1         -4.0d+0*t44*t46*t90-6.0d+0*t44*t46*t89-6.0d+0*t41*t43*t89
     2         -8.0d+0*t41*t43*t88-8.0d+0*t38*t40*t88-1.0d+1*t38*t40*t87
     3         -1.0d+1*t35*t37*t87-1.2d+1*t35*t37*t86-1.2d+1*t32*t34*t86
     4         -1.4d+1*t32*t34*t85-1.4d+1*t29*t31*t85-1.6d+1*t29*t31*t84
     5         -1.6d+1*t26*t28*t84-1.8d+1*t26*t28*t83-1.8d+1*t23*t25*t83
     6         -2.0d+1*t23*t25*t82-2.0d+1*t20*t22*t82-2.2d+1*t20*t22*t81
     7         -2.2d+1*t137*t18*t81
            t172 = -2.0d+0*t129*t48-2.0d+0*t107*t128*t48-4.0d+0*t107*t12
     1         8*t45-4.0d+0*t126*t127*t45-6.0d+0*t126*t127*t42-6.0d+0*t1
     2         24*t125*t42-8.0d+0*t124*t125*t39-8.0d+0*t122*t123*t39-1.0
     3         d+1*t122*t123*t36-1.0d+1*t120*t121*t36-1.2d+1*t120*t121*t
     4         33-1.2d+1*t118*t119*t33-1.4d+1*t118*t119*t30-1.4d+1*t116*
     5         t117*t30-1.6d+1*t116*t117*t27-1.6d+1*t114*t115*t27-1.8d+1
     6         *t114*t115*t24-1.8d+1*t112*t113*t24-2.0d+1*t112*t113*t21-
     7         2.0d+1*t110*t111*t21-2.2d+1*t108*t14*t153-2.2d+1*t110*t11
     8         1*t14
            t173 = -2.0d+0*t129*t64-2.0d+0*t107*t128*t64-4.0d+0*t107*t12
     1         8*t63-4.0d+0*t126*t127*t63-6.0d+0*t126*t127*t62-6.0d+0*t1
     2         24*t125*t62-8.0d+0*t124*t125*t61-8.0d+0*t122*t123*t61-1.0
     3         d+1*t122*t123*t60-1.0d+1*t120*t121*t60-1.2d+1*t120*t121*t
     4         59-1.2d+1*t118*t119*t59-1.4d+1*t118*t119*t58-1.4d+1*t116*
     5         t117*t58-1.6d+1*t116*t117*t57-1.6d+1*t114*t115*t57-1.8d+1
     6         *t114*t115*t56-1.8d+1*t112*t113*t56-2.0d+1*t112*t113*t55-
     7         2.0d+1*t110*t111*t55-2.2d+1*t108*t153*t54-2.2d+1*t110*t11
     8         1*t54
            t174 = -2.0d+0*t129*t78-2.0d+0*t107*t128*t78-4.0d+0*t107*t12
     1         8*t77-4.0d+0*t126*t127*t77-6.0d+0*t126*t127*t76-6.0d+0*t1
     2         24*t125*t76-8.0d+0*t124*t125*t75-8.0d+0*t122*t123*t75-1.0
     3         d+1*t122*t123*t74-1.0d+1*t120*t121*t74-1.2d+1*t120*t121*t
     4         73-1.2d+1*t118*t119*t73-1.4d+1*t118*t119*t72-1.4d+1*t116*
     5         t117*t72-1.6d+1*t116*t117*t71-1.6d+1*t114*t115*t71-1.8d+1
     6         *t114*t115*t70-1.8d+1*t112*t113*t70-2.0d+1*t112*t113*t69-
     7         2.0d+1*t110*t111*t69-2.2d+1*t108*t153*t68-2.2d+1*t110*t11
     8         1*t68
            t175 = -2.0d+0*t129*t91-2.0d+0*t107*t128*t91-4.0d+0*t107*t12
     1         8*t90-4.0d+0*t126*t127*t90-6.0d+0*t126*t127*t89-6.0d+0*t1
     2         24*t125*t89-8.0d+0*t124*t125*t88-8.0d+0*t122*t123*t88-1.0
     3         d+1*t122*t123*t87-1.0d+1*t120*t121*t87-1.2d+1*t120*t121*t
     4         86-1.2d+1*t118*t119*t86-1.4d+1*t118*t119*t85-1.4d+1*t116*
     5         t117*t85-1.6d+1*t116*t117*t84-1.6d+1*t114*t115*t84-1.8d+1
     6         *t114*t115*t83-1.8d+1*t112*t113*t83-2.0d+1*t112*t113*t82-
     7         2.0d+1*t110*t111*t82-2.2d+1*t108*t153*t81-2.2d+1*t110*t11
     8         1*t81
            t176 = 1/t19**13
            t177 = gammaaa**2
            t178 = 1/t2**3
            t179 = 1/rhoa**6
            t180 = 1/rhoa**3.3333333333333337d+0
            t181 = 1/rhoa**3
            t182 = -4.275941461768073d-2*t6*(2.626185756615557d+4*t10*t1
     1         48*t8+5.401836885742928d+1*t10*t144*t8-5.971086789162617d
     2         +3*t10*t147*t7-3.241102131445757d+2*t10*t146*t6+5.2771449
     3         8137176d-4*t181+t10*(5.701255282357431d-2*t143-5.27714498
     4         137176d-4*t181)-2.4564017822744336d+1*t10*t147/t15-8.5518
     5         82923536147d-2*t143)+2.850627641178715d-2*t144*t149-1.900
     6         4184274524766d-2*t11*t143
            t183 = 1/rhoa**7.333333333333333d+0
            t184 = 1/rhoa**4.666666666666667d+0
            t185 = 2.4814019635976003d+0*t150*t5+9.305257363491002d-1*t1
     1         82*t4+4.135669939329334d-1*t12*t148-4.135669939329334d-1*
     2         t148
            t186 = 1/t109**13
            t187 = gammabb**2
            t188 = 1/t94**3
            t189 = 1/rhob**6
            t190 = 1/rhob**3.3333333333333337d+0
            t191 = 1/rhob**3
            t192 = -4.275941461768073d-2*t98*(-5.971086789162617d+3*t102
     1         *t147*t99-3.241102131445757d+2*t102*t162*t98+5.2771449813
     2         7176d-4*t191+t102*(5.701255282357431d-2*t159-5.2771449813
     3         7176d-4*t191)+2.626185756615557d+4*t100*t102*t163+5.40183
     4         6885742928d+1*t100*t102*t160-8.551882923536147d-2*t159-2.
     5         4564017822744336d+1*t102*t147/t105)+2.850627641178715d-2*
     6         t160*t164-1.9004184274524766d-2*t103*t159
            t193 = 1/rhob**7.333333333333333d+0
            t194 = 1/rhob**4.666666666666667d+0
            t195 = 2.4814019635976003d+0*t165*t97+9.305257363491002d-1*t
     1         192*t96+4.135669939329334d-1*t104*t163-4.135669939329334d
     2         -1*t163
            t196 = 1/rhoa**5
            t197 = 1/rhoa**6.333333333333333d+0
            t198 = 1/rhob**5
            t199 = 1/rhob**6.333333333333333d+0
            t200 = 1/rhoa**4
            t201 = 1/rhoa**5.333333333333333d+0
            t202 = 1/rhob**4
            t203 = 1/rhob**5.333333333333333d+0
            fnc(iq) = (1.0d+0*(-9.305257363491002d-1*t104*t130*t95*t96-9
     1         .305257363491002d-1*t104*t132*t133*t96+t134*t135*t95+t132
     2         *t134*t136)+1.0d+0*(t52*t66*t92+t3*t66*t79-9.305257363491
     3         002d-1*t12*t4*t52*t65-9.305257363491002d-1*t12*t3*t4*t50)
     4         )*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(-5.417385299101419d-3*gammaaa*t151*
     1         t51*t66*t92+t152*t52*t92-9.632279000746596d-3*gammaaa*t14
     2         2*t151*t66*t79+t152*t3*t79+t141*t52*t66+t140*t3*t66-1.240
     3         7009817988002d+0*t12*t5*t52*t65-9.305257363491002d-1*t150
     4         *t4*t52*t65+5.041016444533138d-3*gammaaa*t12*t143*t51*t65
     5         -9.305257363491002d-1*t12*t139*t4*t52-1.2407009817988002d
     6         +0*t12*t3*t5*t50-9.305257363491002d-1*t150*t3*t4*t50+8.96
     7         3083509889702d-3*gammaaa*t12*t142*t143*t50-9.305257363491
     8         002d-1*t12*t138*t3*t4)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*(-1.2407009817988002d+0*t104*t130*t9
     1         5*t97-1.2407009817988002d+0*t104*t132*t133*t97-9.30525736
     2         3491002d-1*t130*t165*t95*t96-9.305257363491002d-1*t104*t1
     3         54*t95*t96-9.305257363491002d-1*t132*t133*t165*t96-9.3052
     4         57363491002d-1*t104*t132*t155*t96+t135*t167*t95+t134*t156
     5         *t95+t132*t136*t167-9.632279000746596d-3*gammabb*t134*t13
     6         5*t158*t166-5.417385299101419d-3*gammabb*t131*t134*t136*t
     7         166+8.963083509889702d-3*gammabb*t104*t130*t158*t159+5.04
     8         1016444533138d-3*gammabb*t104*t131*t133*t159+t132*t134*t1
     9         57)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = 1.0d+0*(2.0315194871630324d-3*t1*t51*t66*t
     1         92+3.612104625279974d-3*t1*t142*t66*t79-1.890381166699927
     2         d-3*t12*t144*t51*t65-3.361156316208638d-3*t12*t142*t144*t
     3         50)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = 1.0d+0*(3.612104625279974d-3*t134*t135*t15
     1         8*t93+2.0315194871630324d-3*t131*t134*t136*t93-3.36115631
     2         6208638d-3*t104*t130*t158*t160-1.890381166699927d-3*t104*
     3         t131*t133*t160)*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TA) = 1.0d+0*(t171*t52*t66+t170*t3*t66-9.30525736
     1         3491002d-1*t12*t169*t4*t52-9.305257363491002d-1*t12*t168*
     2         t3*t4)*wght+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = 1.0d+0*(-9.305257363491002d-1*t104*t172*t95
     1         *t96-9.305257363491002d-1*t104*t132*t173*t96+t134*t174*t9
     2         5+t132*t134*t175)*wght+Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(t151*(-1.0834770598202839d-2*ga
     1         mmaaa*t152*t51*t92-1.0834770598202839d-2*gammaaa*t141*t51
     2         *t66)+1.9863746096705204d-2*gammaaa*t184*t51*t66*t92-5.31
     3         6678166471045d-5*t177*t183*t51*t66*t92+t185*t52*t92+t52*t
     4         66*(1.0128444160767991d+1*t49*t6*t91-1.0128444160767991d+
     5         1*t17*t47*t6*t91-4.6163421503007845d+2*t4*t47*t91+4.61634
     6         21503007845d+2*t17*t4*t44*t91+2.0256888321535982d+1*t17*t
     7         47*t6*t90-2.0256888321535982d+1*t44*t46*t6*t90+4.61634215
     8         03007845d+2*t4*t47*t90+1.3849026450902355d+3*t4*t41*t46*t
     9         90-1.846536860120314d+3*t17*t4*t44*t90+3.038533248230397d
     :         +1*t44*t46*t6*t89-3.038533248230397d+1*t41*t43*t6*t89-4.1
     ;         547079352707067d+3*t4*t41*t46*t89+1.3849026450902355d+3*t
     <         17*t4*t44*t89+2.769805290180471d+3*t38*t4*t43*t89+4.05137
     =         76643071964d+1*t41*t43*t6*t88-4.0513776643071964d+1*t38*t
     >         40*t6*t88+2.769805290180471d+3*t4*t41*t46*t88-7.386147440
     ?         481255d+3*t38*t4*t43*t88+4.616342150300784d+3*t35*t4*t40*
     @         t88+5.064222080383994d+1*t38*t40*t6*t87-5.064222080383994
     1         d+1*t35*t37*t6*t87+4.616342150300784d+3*t38*t4*t43*t87-1.
     2         154085537575196d+4*t35*t4*t40*t87+6.924513225451178d+3*t3
     3         2*t37*t4*t87+6.077066496460795d+1*t35*t37*t6*t86-6.077066
     4         496460795d+1*t32*t34*t6*t86+6.924513225451178d+3*t35*t4*t
     5         40*t86-1.661883174108283d+4*t32*t37*t4*t86+9.694318515631
     6         648d+3*t29*t34*t4*t86+7.089910912537593d+1*t32*t34*t6*t85
     7         -7.089910912537593d+1*t29*t31*t6*t85+9.694318515631648d+3
     8         *t32*t37*t4*t85-2.2620076536473846d+4*t29*t34*t4*t85+1.29
     9         25758020842196d+4*t26*t31*t4*t85+8.102755328614393d+1*t29
     :         *t31*t6*t84-8.102755328614393d+1*t26*t28*t6*t84+1.2925758
     ;         020842196d+4*t29*t34*t4*t84-2.954458976192502d+4*t26*t31*
     <         t4*t84+1.6618831741082823d+4*t23*t28*t4*t84+9.11559974469
     =         1191d+1*t26*t28*t6*t83-9.115599744691191d+1*t23*t25*t6*t8
     >         3+1.6618831741082823d+4*t26*t31*t4*t83-3.7392371417436354
     ?         d+4*t23*t28*t4*t83+2.0773539676353528d+4*t20*t25*t4*t83+1
     @         .012844416076799d+2*t23*t25*t6*t82-1.012844416076799d+2*t
     1         20*t22*t6*t82+2.0773539676353528d+4*t23*t28*t4*t82-4.6163
     2         42150300784d+4*t20*t25*t4*t82+2.5389881826654315d+4*t137*
     3         t22*t4*t82+1.1141288576844789d+2*t20*t22*t6*t81-1.1141288
     4         576844789d+2*t137*t18*t6*t81+2.5389881826654315d+4*t20*t2
     5         5*t4*t81-5.585774001863949d+4*t137*t22*t4*t81+3.046785819
     6         198518d+4*t176*t18*t4*t81)+t142*t151*(-1.9264558001493193
     7         d-2*gammaaa*t152*t79-1.9264558001493193d-2*gammaaa*t140*t
     8         66)+3.5318356336070855d-2*gammaaa*t142*t184*t66*t79-2.307
     9         9800683637772d-4*t177*t178*t183*t66*t79+t185*t3*t79+t3*t6
     :         6*(1.0128444160767991d+1*t49*t6*t78-1.0128444160767991d+1
     ;         *t17*t47*t6*t78-4.6163421503007845d+2*t4*t47*t78+4.616342
     <         1503007845d+2*t17*t4*t44*t78+2.0256888321535982d+1*t17*t4
     =         7*t6*t77-2.0256888321535982d+1*t44*t46*t6*t77+4.616342150
     >         3007845d+2*t4*t47*t77+1.3849026450902355d+3*t4*t41*t46*t7
     ?         7-1.846536860120314d+3*t17*t4*t44*t77+3.038533248230397d+
     @         1*t44*t46*t6*t76-3.038533248230397d+1*t41*t43*t6*t76-4.15
     1         47079352707067d+3*t4*t41*t46*t76+1.3849026450902355d+3*t1
     2         7*t4*t44*t76+2.769805290180471d+3*t38*t4*t43*t76+4.051377
     3         6643071964d+1*t41*t43*t6*t75-4.0513776643071964d+1*t38*t4
     4         0*t6*t75+2.769805290180471d+3*t4*t41*t46*t75-7.3861474404
     5         81255d+3*t38*t4*t43*t75+4.616342150300784d+3*t35*t4*t40*t
     6         75+5.064222080383994d+1*t38*t40*t6*t74-5.064222080383994d
     7         +1*t35*t37*t6*t74+4.616342150300784d+3*t38*t4*t43*t74-1.1
     8         54085537575196d+4*t35*t4*t40*t74+6.924513225451178d+3*t32
     9         *t37*t4*t74+6.077066496460795d+1*t35*t37*t6*t73-6.0770664
     :         96460795d+1*t32*t34*t6*t73+6.924513225451178d+3*t35*t4*t4
     ;         0*t73-1.661883174108283d+4*t32*t37*t4*t73+9.6943185156316
     <         48d+3*t29*t34*t4*t73+7.089910912537593d+1*t32*t34*t6*t72-
     =         7.089910912537593d+1*t29*t31*t6*t72+9.694318515631648d+3*
     >         t32*t37*t4*t72-2.2620076536473846d+4*t29*t34*t4*t72+1.292
     ?         5758020842196d+4*t26*t31*t4*t72+8.102755328614393d+1*t29*
     @         t31*t6*t71-8.102755328614393d+1*t26*t28*t6*t71+1.29257580
     1         20842196d+4*t29*t34*t4*t71-2.954458976192502d+4*t26*t31*t
     2         4*t71+1.6618831741082823d+4*t23*t28*t4*t71+9.115599744691
     3         191d+1*t26*t28*t6*t70-9.115599744691191d+1*t23*t25*t6*t70
     4         +1.6618831741082823d+4*t26*t31*t4*t70-3.7392371417436354d
     5         +4*t23*t28*t4*t70+2.0773539676353528d+4*t20*t25*t4*t70+1.
     6         012844416076799d+2*t23*t25*t6*t69-1.012844416076799d+2*t2
     7         0*t22*t6*t69+2.0773539676353528d+4*t23*t28*t4*t69-4.61634
     8         2150300784d+4*t20*t25*t4*t69+2.5389881826654315d+4*t137*t
     9         22*t4*t69+1.1141288576844789d+2*t20*t22*t6*t68-1.11412885
     :         76844789d+2*t137*t18*t6*t68+2.5389881826654315d+4*t20*t25
     ;         *t4*t68-5.585774001863949d+4*t137*t22*t4*t68+3.0467858191
     <         98518d+4*t176*t18*t4*t68)+t148*(-4.135669939329334d-1*t12
     =         *t52*t65-4.135669939329334d-1*t12*t3*t50)+t143*(1.0082032
     >         889066277d-2*gammaaa*t150*t51*t65+1.0082032889066277d-2*g
     ?         ammaaa*t12*t139*t51)-2.4814019635976003d+0*t150*t5*t52*t6
     @         5-9.305257363491002d-1*t182*t4*t52*t65-5.041016444533138d
     1         -3*gammaaa*t12*t180*t51*t65+4.947305865786653d-5*t12*t177
     2         *t179*t51*t65-9.305257363491002d-1*t12*t4*t52*(1.01284441
     3         60767991d+1*t49*t6*t64-1.0128444160767991d+1*t17*t47*t6*t
     4         64-4.6163421503007845d+2*t4*t47*t64+4.6163421503007845d+2
     5         *t17*t4*t44*t64+2.0256888321535982d+1*t17*t47*t6*t63-2.02
     6         56888321535982d+1*t44*t46*t6*t63+4.6163421503007845d+2*t4
     7         *t47*t63+1.3849026450902355d+3*t4*t41*t46*t63-1.846536860
     8         120314d+3*t17*t4*t44*t63+3.038533248230397d+1*t44*t46*t6*
     9         t62-3.038533248230397d+1*t41*t43*t6*t62-4.154707935270706
     :         7d+3*t4*t41*t46*t62+1.3849026450902355d+3*t17*t4*t44*t62+
     ;         2.769805290180471d+3*t38*t4*t43*t62+4.0513776643071964d+1
     <         *t41*t43*t6*t61-4.0513776643071964d+1*t38*t40*t6*t61+2.76
     =         9805290180471d+3*t4*t41*t46*t61-7.386147440481255d+3*t38*
     >         t4*t43*t61+4.616342150300784d+3*t35*t4*t40*t61+5.06422208
     ?         0383994d+1*t38*t40*t6*t60-5.064222080383994d+1*t35*t37*t6
     @         *t60+4.616342150300784d+3*t38*t4*t43*t60-1.15408553757519
     1         6d+4*t35*t4*t40*t60+6.924513225451178d+3*t32*t37*t4*t60+6
     2         .077066496460795d+1*t35*t37*t59*t6-6.077066496460795d+1*t
     3         32*t34*t59*t6+7.089910912537593d+1*t32*t34*t58*t6-7.08991
     4         0912537593d+1*t29*t31*t58*t6+8.102755328614393d+1*t29*t31
     5         *t57*t6-8.102755328614393d+1*t26*t28*t57*t6+9.11559974469
     6         1191d+1*t26*t28*t56*t6-9.115599744691191d+1*t23*t25*t56*t
     7         6+1.012844416076799d+2*t23*t25*t55*t6-1.012844416076799d+
     8         2*t20*t22*t55*t6+1.1141288576844789d+2*t20*t22*t54*t6-1.1
     9         141288576844789d+2*t137*t18*t54*t6+6.924513225451178d+3*t
     :         35*t4*t40*t59-1.661883174108283d+4*t32*t37*t4*t59+9.69431
     ;         8515631648d+3*t29*t34*t4*t59+9.694318515631648d+3*t32*t37
     <         *t4*t58-2.2620076536473846d+4*t29*t34*t4*t58+1.2925758020
     =         842196d+4*t26*t31*t4*t58+1.2925758020842196d+4*t29*t34*t4
     >         *t57-2.954458976192502d+4*t26*t31*t4*t57+1.66188317410828
     ?         23d+4*t23*t28*t4*t57+1.6618831741082823d+4*t26*t31*t4*t56
     @         -3.7392371417436354d+4*t23*t28*t4*t56+2.0773539676353528d
     1         +4*t20*t25*t4*t56+2.0773539676353528d+4*t23*t28*t4*t55-4.
     2         616342150300784d+4*t20*t25*t4*t55+2.5389881826654315d+4*t
     3         137*t22*t4*t55+2.5389881826654315d+4*t20*t25*t4*t54-5.585
     4         774001863949d+4*t137*t22*t4*t54+3.046785819198518d+4*t176
     5         *t18*t4*t54)-9.305257363491002d-1*t12*t3*t4*(1.0128444160
     6         767991d+1*t48*t49*t6-1.0128444160767991d+1*t17*t47*t48*t6
     7         +2.0256888321535982d+1*t17*t45*t47*t6-2.0256888321535982d
     8         +1*t44*t45*t46*t6+3.038533248230397d+1*t42*t44*t46*t6-3.0
     9         38533248230397d+1*t41*t42*t43*t6+4.0513776643071964d+1*t3
     :         9*t41*t43*t6-4.0513776643071964d+1*t38*t39*t40*t6+5.06422
     ;         2080383994d+1*t36*t38*t40*t6-5.064222080383994d+1*t35*t36
     <         *t37*t6+6.077066496460795d+1*t33*t35*t37*t6-6.07706649646
     =         0795d+1*t32*t33*t34*t6+7.089910912537593d+1*t30*t32*t34*t
     >         6-7.089910912537593d+1*t29*t30*t31*t6+8.102755328614393d+
     ?         1*t27*t29*t31*t6-8.102755328614393d+1*t26*t27*t28*t6+9.11
     @         5599744691191d+1*t24*t26*t28*t6-9.115599744691191d+1*t23*
     1         t24*t25*t6+1.012844416076799d+2*t21*t23*t25*t6-1.01284441
     2         6076799d+2*t20*t21*t22*t6+1.1141288576844789d+2*t14*t20*t
     3         22*t6-1.1141288576844789d+2*t137*t14*t18*t6-4.61634215030
     4         07845d+2*t4*t47*t48+4.6163421503007845d+2*t17*t4*t44*t48+
     5         4.6163421503007845d+2*t4*t45*t47+1.3849026450902355d+3*t4
     6         *t41*t45*t46-4.1547079352707067d+3*t4*t41*t42*t46+2.76980
     7         5290180471d+3*t39*t4*t41*t46-1.846536860120314d+3*t17*t4*
     8         t44*t45+1.3849026450902355d+3*t17*t4*t42*t44+2.7698052901
     9         80471d+3*t38*t4*t42*t43-7.386147440481255d+3*t38*t39*t4*t
     :         43+4.616342150300784d+3*t36*t38*t4*t43+4.616342150300784d
     ;         +3*t35*t39*t4*t40-1.154085537575196d+4*t35*t36*t4*t40+6.9
     <         24513225451178d+3*t33*t35*t4*t40+6.924513225451178d+3*t32
     =         *t36*t37*t4-1.661883174108283d+4*t32*t33*t37*t4+9.6943185
     >         15631648d+3*t30*t32*t37*t4+9.694318515631648d+3*t29*t33*t
     ?         34*t4-2.2620076536473846d+4*t29*t30*t34*t4+1.292575802084
     @         2196d+4*t27*t29*t34*t4+1.2925758020842196d+4*t26*t30*t31*
     1         t4-2.954458976192502d+4*t26*t27*t31*t4+1.6618831741082823
     2         d+4*t24*t26*t31*t4+1.6618831741082823d+4*t23*t27*t28*t4-3
     3         .7392371417436354d+4*t23*t24*t28*t4+2.0773539676353528d+4
     4         *t21*t23*t28*t4+2.0773539676353528d+4*t20*t24*t25*t4-4.61
     5         6342150300784d+4*t20*t21*t25*t4+2.5389881826654315d+4*t14
     6         *t20*t25*t4+2.5389881826654315d+4*t137*t21*t22*t4-5.58577
     7         4001863949d+4*t137*t14*t22*t4+3.046785819198518d+4*t14*t1
     8         76*t18*t4)-2.4814019635976003d+0*t12*t139*t5*t52-1.861051
     9         4726982003d+0*t139*t150*t4*t52+2*t141*t152*t52+t142*t143*
     :         (1.7926167019779404d-2*gammaaa*t150*t50+1.792616701977940
     ;         4d-2*gammaaa*t12*t138)-2.4814019635976003d+0*t150*t3*t5*t
     <         50-9.305257363491002d-1*t182*t3*t4*t50-8.963083509889707d
     =         -3*gammaaa*t12*t142*t180*t50+2.1476348525932504d-4*t12*t1
     >         77*t178*t179*t50-2.4814019635976003d+0*t12*t138*t3*t5-1.8
     ?         610514726982003d+0*t138*t150*t3*t4+2*t140*t152*t3)*wght+A
     @         mat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*(t132*t134*(1.0128444160767991d+
     1         1*t129*t91*t98-1.0128444160767991d+1*t107*t128*t91*t98+2.
     2         0256888321535982d+1*t107*t128*t90*t98-2.0256888321535982d
     3         +1*t126*t127*t90*t98+3.038533248230397d+1*t126*t127*t89*t
     4         98-3.038533248230397d+1*t124*t125*t89*t98+4.0513776643071
     5         964d+1*t124*t125*t88*t98-4.0513776643071964d+1*t122*t123*
     6         t88*t98+5.064222080383994d+1*t122*t123*t87*t98-5.06422208
     7         0383994d+1*t120*t121*t87*t98+6.077066496460795d+1*t120*t1
     8         21*t86*t98-6.077066496460795d+1*t118*t119*t86*t98+7.08991
     9         0912537593d+1*t118*t119*t85*t98-7.089910912537593d+1*t116
     :         *t117*t85*t98+8.102755328614393d+1*t116*t117*t84*t98-8.10
     ;         2755328614393d+1*t114*t115*t84*t98+9.115599744691191d+1*t
     <         114*t115*t83*t98-9.115599744691191d+1*t112*t113*t83*t98+1
     =         .012844416076799d+2*t112*t113*t82*t98-1.012844416076799d+
     >         2*t110*t111*t82*t98-1.1141288576844789d+2*t108*t153*t81*t
     ?         98+1.1141288576844789d+2*t110*t111*t81*t98-4.616342150300
     @         7845d+2*t128*t91*t96+4.6163421503007845d+2*t107*t126*t91*
     1         t96+4.6163421503007845d+2*t128*t90*t96+1.3849026450902355
     2         d+3*t124*t127*t90*t96-1.846536860120314d+3*t107*t126*t90*
     3         t96-4.1547079352707067d+3*t124*t127*t89*t96+1.38490264509
     4         02355d+3*t107*t126*t89*t96+2.769805290180471d+3*t122*t125
     5         *t89*t96+2.769805290180471d+3*t124*t127*t88*t96-7.3861474
     6         40481255d+3*t122*t125*t88*t96+4.616342150300784d+3*t120*t
     7         123*t88*t96+4.616342150300784d+3*t122*t125*t87*t96-1.1540
     8         85537575196d+4*t120*t123*t87*t96+6.924513225451178d+3*t11
     9         8*t121*t87*t96+6.924513225451178d+3*t120*t123*t86*t96-1.6
     :         61883174108283d+4*t118*t121*t86*t96+9.694318515631648d+3*
     ;         t116*t119*t86*t96+9.694318515631648d+3*t118*t121*t85*t96-
     <         2.2620076536473846d+4*t116*t119*t85*t96+1.292575802084219
     =         6d+4*t114*t117*t85*t96+1.2925758020842196d+4*t116*t119*t8
     >         4*t96-2.954458976192502d+4*t114*t117*t84*t96+1.6618831741
     ?         082823d+4*t112*t115*t84*t96+1.6618831741082823d+4*t114*t1
     @         17*t83*t96-3.7392371417436354d+4*t112*t115*t83*t96+2.0773
     1         539676353528d+4*t110*t113*t83*t96+2.5389881826654315d+4*t
     2         111*t153*t82*t96+2.0773539676353528d+4*t112*t115*t82*t96-
     3         4.616342150300784d+4*t110*t113*t82*t96+3.046785819198518d
     4         +4*t108*t186*t81*t96-5.585774001863949d+4*t111*t153*t81*t
     5         96+2.5389881826654315d+4*t110*t113*t81*t96)+t134*t95*(1.0
     6         128444160767991d+1*t129*t78*t98-1.0128444160767991d+1*t10
     7         7*t128*t78*t98+2.0256888321535982d+1*t107*t128*t77*t98-2.
     8         0256888321535982d+1*t126*t127*t77*t98+3.038533248230397d+
     9         1*t126*t127*t76*t98-3.038533248230397d+1*t124*t125*t76*t9
     :         8+4.0513776643071964d+1*t124*t125*t75*t98-4.0513776643071
     ;         964d+1*t122*t123*t75*t98+5.064222080383994d+1*t122*t123*t
     <         74*t98-5.064222080383994d+1*t120*t121*t74*t98+6.077066496
     =         460795d+1*t120*t121*t73*t98-6.077066496460795d+1*t118*t11
     >         9*t73*t98+7.089910912537593d+1*t118*t119*t72*t98-7.089910
     ?         912537593d+1*t116*t117*t72*t98+8.102755328614393d+1*t116*
     @         t117*t71*t98-8.102755328614393d+1*t114*t115*t71*t98+9.115
     1         599744691191d+1*t114*t115*t70*t98-9.115599744691191d+1*t1
     2         12*t113*t70*t98+1.012844416076799d+2*t112*t113*t69*t98-1.
     3         012844416076799d+2*t110*t111*t69*t98-1.1141288576844789d+
     4         2*t108*t153*t68*t98+1.1141288576844789d+2*t110*t111*t68*t
     5         98-4.6163421503007845d+2*t128*t78*t96+4.6163421503007845d
     6         +2*t107*t126*t78*t96+4.6163421503007845d+2*t128*t77*t96+1
     7         .3849026450902355d+3*t124*t127*t77*t96-1.846536860120314d
     8         +3*t107*t126*t77*t96-4.1547079352707067d+3*t124*t127*t76*
     9         t96+1.3849026450902355d+3*t107*t126*t76*t96+2.76980529018
     :         0471d+3*t122*t125*t76*t96+2.769805290180471d+3*t124*t127*
     ;         t75*t96-7.386147440481255d+3*t122*t125*t75*t96+4.61634215
     <         0300784d+3*t120*t123*t75*t96+4.616342150300784d+3*t122*t1
     =         25*t74*t96-1.154085537575196d+4*t120*t123*t74*t96+6.92451
     >         3225451178d+3*t118*t121*t74*t96+6.924513225451178d+3*t120
     ?         *t123*t73*t96-1.661883174108283d+4*t118*t121*t73*t96+9.69
     @         4318515631648d+3*t116*t119*t73*t96+9.694318515631648d+3*t
     1         118*t121*t72*t96-2.2620076536473846d+4*t116*t119*t72*t96+
     2         1.2925758020842196d+4*t114*t117*t72*t96+1.292575802084219
     3         6d+4*t116*t119*t71*t96-2.954458976192502d+4*t114*t117*t71
     4         *t96+1.6618831741082823d+4*t112*t115*t71*t96+1.6618831741
     5         082823d+4*t114*t117*t70*t96-3.7392371417436354d+4*t112*t1
     6         15*t70*t96+2.0773539676353528d+4*t110*t113*t70*t96+2.5389
     7         881826654315d+4*t111*t153*t69*t96+2.0773539676353528d+4*t
     8         112*t115*t69*t96-4.616342150300784d+4*t110*t113*t69*t96+3
     9         .046785819198518d+4*t108*t186*t68*t96-5.585774001863949d+
     :         4*t111*t153*t68*t96+2.5389881826654315d+4*t110*t113*t68*t
     ;         96)-9.305257363491002d-1*t104*t132*t96*(1.012844416076799
     <         1d+1*t129*t64*t98-1.0128444160767991d+1*t107*t128*t64*t98
     =         +2.0256888321535982d+1*t107*t128*t63*t98-2.02568883215359
     >         82d+1*t126*t127*t63*t98+3.038533248230397d+1*t126*t127*t6
     ?         2*t98-3.038533248230397d+1*t124*t125*t62*t98+4.0513776643
     @         071964d+1*t124*t125*t61*t98-4.0513776643071964d+1*t122*t1
     1         23*t61*t98+5.064222080383994d+1*t122*t123*t60*t98-5.06422
     2         2080383994d+1*t120*t121*t60*t98+6.077066496460795d+1*t120
     3         *t121*t59*t98-6.077066496460795d+1*t118*t119*t59*t98+7.08
     4         9910912537593d+1*t118*t119*t58*t98-7.089910912537593d+1*t
     5         116*t117*t58*t98+8.102755328614393d+1*t116*t117*t57*t98-8
     6         .102755328614393d+1*t114*t115*t57*t98+9.115599744691191d+
     7         1*t114*t115*t56*t98-9.115599744691191d+1*t112*t113*t56*t9
     8         8+1.012844416076799d+2*t112*t113*t55*t98-1.01284441607679
     9         9d+2*t110*t111*t55*t98-1.1141288576844789d+2*t108*t153*t5
     :         4*t98+1.1141288576844789d+2*t110*t111*t54*t98-4.616342150
     ;         3007845d+2*t128*t64*t96+4.6163421503007845d+2*t107*t126*t
     <         64*t96+4.6163421503007845d+2*t128*t63*t96+1.3849026450902
     =         355d+3*t124*t127*t63*t96-1.846536860120314d+3*t107*t126*t
     >         63*t96-4.1547079352707067d+3*t124*t127*t62*t96+1.38490264
     ?         50902355d+3*t107*t126*t62*t96+2.769805290180471d+3*t122*t
     @         125*t62*t96+2.769805290180471d+3*t124*t127*t61*t96-7.3861
     1         47440481255d+3*t122*t125*t61*t96+4.616342150300784d+3*t12
     2         0*t123*t61*t96+4.616342150300784d+3*t122*t125*t60*t96-1.1
     3         54085537575196d+4*t120*t123*t60*t96+6.924513225451178d+3*
     4         t118*t121*t60*t96+6.924513225451178d+3*t120*t123*t59*t96-
     5         1.661883174108283d+4*t118*t121*t59*t96+9.694318515631648d
     6         +3*t116*t119*t59*t96+9.694318515631648d+3*t118*t121*t58*t
     7         96-2.2620076536473846d+4*t116*t119*t58*t96+1.292575802084
     8         2196d+4*t114*t117*t58*t96+1.2925758020842196d+4*t116*t119
     9         *t57*t96-2.954458976192502d+4*t114*t117*t57*t96+1.6618831
     :         741082823d+4*t112*t115*t57*t96+1.6618831741082823d+4*t114
     ;         *t117*t56*t96-3.7392371417436354d+4*t112*t115*t56*t96+2.0
     <         773539676353528d+4*t110*t113*t56*t96+2.5389881826654315d+
     =         4*t111*t153*t55*t96+2.0773539676353528d+4*t112*t115*t55*t
     >         96-4.616342150300784d+4*t110*t113*t55*t96+3.0467858191985
     ?         18d+4*t108*t186*t54*t96-5.585774001863949d+4*t111*t153*t5
     @         4*t96+2.5389881826654315d+4*t110*t113*t54*t96)-9.30525736
     1         3491002d-1*t104*t95*t96*(1.0128444160767991d+1*t129*t48*t
     2         98-1.0128444160767991d+1*t107*t128*t48*t98+2.025688832153
     3         5982d+1*t107*t128*t45*t98-2.0256888321535982d+1*t126*t127
     4         *t45*t98+3.038533248230397d+1*t126*t127*t42*t98-3.0385332
     5         48230397d+1*t124*t125*t42*t98+4.0513776643071964d+1*t124*
     6         t125*t39*t98-4.0513776643071964d+1*t122*t123*t39*t98+5.06
     7         4222080383994d+1*t122*t123*t36*t98-5.064222080383994d+1*t
     8         120*t121*t36*t98+6.077066496460795d+1*t120*t121*t33*t98-6
     9         .077066496460795d+1*t118*t119*t33*t98+7.089910912537593d+
     :         1*t118*t119*t30*t98-7.089910912537593d+1*t116*t117*t30*t9
     ;         8+8.102755328614393d+1*t116*t117*t27*t98-8.10275532861439
     <         3d+1*t114*t115*t27*t98+9.115599744691191d+1*t114*t115*t24
     =         *t98-9.115599744691191d+1*t112*t113*t24*t98+1.01284441607
     >         6799d+2*t112*t113*t21*t98-1.012844416076799d+2*t110*t111*
     ?         t21*t98-1.1141288576844789d+2*t108*t14*t153*t98+1.1141288
     @         576844789d+2*t110*t111*t14*t98-4.6163421503007845d+2*t128
     1         *t48*t96+4.6163421503007845d+2*t107*t126*t48*t96+4.616342
     2         1503007845d+2*t128*t45*t96+1.3849026450902355d+3*t124*t12
     3         7*t45*t96-1.846536860120314d+3*t107*t126*t45*t96-4.154707
     4         9352707067d+3*t124*t127*t42*t96+1.3849026450902355d+3*t10
     5         7*t126*t42*t96+2.769805290180471d+3*t122*t125*t42*t96+2.7
     6         69805290180471d+3*t124*t127*t39*t96-7.386147440481255d+3*
     7         t122*t125*t39*t96+4.616342150300784d+3*t120*t123*t39*t96+
     8         4.616342150300784d+3*t122*t125*t36*t96-1.154085537575196d
     9         +4*t120*t123*t36*t96+6.924513225451178d+3*t118*t121*t36*t
     :         96+6.924513225451178d+3*t120*t123*t33*t96-1.6618831741082
     ;         83d+4*t118*t121*t33*t96+9.694318515631648d+3*t116*t119*t3
     <         3*t96+9.694318515631648d+3*t118*t121*t30*t96-2.2620076536
     =         473846d+4*t116*t119*t30*t96+1.2925758020842196d+4*t114*t1
     >         17*t30*t96+1.2925758020842196d+4*t116*t119*t27*t96-2.9544
     ?         58976192502d+4*t114*t117*t27*t96+1.6618831741082823d+4*t1
     @         12*t115*t27*t96+1.6618831741082823d+4*t114*t117*t24*t96-3
     1         .7392371417436354d+4*t112*t115*t24*t96+2.0773539676353528
     2         d+4*t110*t113*t24*t96+2.5389881826654315d+4*t111*t153*t21
     3         *t96+2.0773539676353528d+4*t112*t115*t21*t96-4.6163421503
     4         00784d+4*t110*t113*t21*t96+3.046785819198518d+4*t108*t14*
     5         t186*t96-5.585774001863949d+4*t111*t14*t153*t96+2.5389881
     6         826654315d+4*t110*t113*t14*t96)-2.4814019635976003d+0*t13
     7         0*t165*t95*t97-2.4814019635976003d+0*t104*t154*t95*t97-2.
     8         4814019635976003d+0*t132*t133*t165*t97-2.4814019635976003
     9         d+0*t104*t132*t155*t97-9.305257363491002d-1*t130*t192*t95
     :         *t96-1.8610514726982003d+0*t154*t165*t95*t96-9.3052573634
     ;         91002d-1*t132*t133*t192*t96-1.8610514726982003d+0*t132*t1
     <         55*t165*t96+t163*(-4.135669939329334d-1*t104*t130*t95-4.1
     =         35669939329334d-1*t104*t132*t133)+t135*t195*t95+2*t156*t1
     >         67*t95+t132*t136*t195+3.5318356336070855d-2*gammabb*t134*
     ?         t135*t158*t194+1.9863746096705204d-2*gammabb*t131*t134*t1
     @         36*t194-2.3079800683637772d-4*t134*t135*t187*t188*t193-5.
     1         316678166471045d-5*t131*t134*t136*t187*t193-8.96308350988
     2         9707d-3*gammabb*t104*t130*t158*t190-5.041016444533138d-3*
     3         gammabb*t104*t131*t133*t190+2.1476348525932504d-4*t104*t1
     4         30*t187*t188*t189+4.947305865786653d-5*t104*t131*t133*t18
     5         7*t189+t166*(-1.0834770598202839d-2*gammabb*t131*t136*t16
     6         7-1.0834770598202839d-2*gammabb*t131*t134*t157)+t158*t166
     7         *(-1.9264558001493193d-2*gammabb*t135*t167-1.926455800149
     8         3193d-2*gammabb*t134*t156)+2*t132*t157*t167+t159*(1.00820
     9         32889066277d-2*gammabb*t131*t133*t165+1.0082032889066277d
     :         -2*gammabb*t104*t131*t155)+t158*t159*(1.7926167019779404d
     ;         -2*gammabb*t130*t165+1.7926167019779404d-2*gammabb*t104*t
     <         154))*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(t1*(2.0315194871630324d-3*t152
     1         *t51*t92+2.0315194871630324d-3*t141*t51*t66)+1.9937543124
     2         266421d-5*gammaaa*t197*t51*t66*t92-5.417385299101419d-3*t
     3         151*t51*t66*t92+t1*t142*(3.612104625279974d-3*t152*t79+3.
     4         612104625279974d-3*t140*t66)+8.654925256364164d-5*gammaaa
     5         *t178*t197*t66*t79-9.632279000746596d-3*t142*t151*t66*t79
     6         +t144*(-1.890381166699927d-3*t150*t51*t65-1.8903811666999
     7         27d-3*t12*t139*t51)-1.855239699669995d-5*gammaaa*t12*t196
     8         *t51*t65+2.520508222266569d-3*t12*t143*t51*t65+t142*t144*
     9         (-3.361156316208638d-3*t150*t50-3.361156316208638d-3*t12*
     :         t138)-8.05363069722469d-5*gammaaa*t12*t178*t196*t50+4.481
     ;         541754944851d-3*t12*t142*t143*t50)*wght+Cmat2(iq,D2_RA_GA
     <         A)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*((2.0315194871630324d-3*t131*t1
     1         36*t167+2.0315194871630324d-3*t131*t134*t157)*t93+t158*(3
     2         .612104625279974d-3*t135*t167+3.612104625279974d-3*t134*t
     3         156)*t93+8.654925256364164d-5*gammabb*t134*t135*t188*t199
     4         +1.9937543124266421d-5*gammabb*t131*t134*t136*t199-8.0536
     5         3069722469d-5*gammabb*t104*t130*t188*t198-1.8552396996699
     6         95d-5*gammabb*t104*t131*t133*t198-9.632279000746596d-3*t1
     7         34*t135*t158*t166-5.417385299101419d-3*t131*t134*t136*t16
     8         6+t160*(-1.890381166699927d-3*t131*t133*t165-1.8903811666
     9         99927d-3*t104*t131*t155)+t158*t160*(-3.361156316208638d-3
     :         *t130*t165-3.361156316208638d-3*t104*t154)+4.481541754944
     ;         851d-3*t104*t130*t158*t159+2.520508222266569d-3*t104*t131
     <         *t133*t159)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(-7.476578671599909d-6*t201*t5
     1         1*t66*t92-3.245596971136562d-5*t178*t201*t66*t79+6.957148
     2         873762482d-6*t12*t200*t51*t65+3.020111511459258d-5*t12*t1
     3         78*t200*t50)*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*(-3.245596971136562d-5*t134*t1
     1         35*t188*t203-7.476578671599909d-6*t131*t134*t136*t203+3.0
     2         20111511459258d-5*t104*t130*t188*t202+6.957148873762482d-
     3         6*t104*t131*t133*t202)*wght+Cmat2(iq,D2_GBB_GBB)
            Mmat2(iq,D2_RA_TA) = 1.0d+0*(t52*t66*(6.077066496460795d+1*t
     1         17*t44*t9*t91-6.077066496460795d+1*t47*t9*t90+1.823119948
     2         9382385d+2*t41*t46*t9*t90-1.8231199489382385d+2*t17*t44*t
     3         89*t9+3.646239897876477d+2*t38*t43*t89*t9-3.6462398978764
     4         77d+2*t41*t46*t88*t9+6.077066496460795d+2*t35*t40*t88*t9-
     5         6.077066496460795d+2*t38*t43*t87*t9+9.115599744691192d+2*
     6         t32*t37*t87*t9-9.115599744691192d+2*t35*t40*t86*t9+1.2761
     7         83964256767d+3*t29*t34*t86*t9-1.276183964256767d+3*t32*t3
     8         7*t85*t9+1.7015786190090226d+3*t26*t31*t85*t9-1.701578619
     9         0090226d+3*t29*t34*t84*t9+2.187743938725886d+3*t23*t28*t8
     :         4*t9-2.187743938725886d+3*t26*t31*t83*t9+2.73467992340735
     ;         7d+3*t20*t25*t83*t9-2.734679923407357d+3*t23*t28*t82*t9+3
     <         .342386573053437d+3*t137*t22*t82*t9-3.342386573053437d+3*
     =         t20*t25*t81*t9+4.0108638876641245d+3*t176*t18*t81*t9)+t3*
     >         t66*(6.077066496460795d+1*t17*t44*t78*t9-6.07706649646079
     ?         5d+1*t47*t77*t9+1.8231199489382385d+2*t41*t46*t77*t9-1.82
     @         31199489382385d+2*t17*t44*t76*t9+3.646239897876477d+2*t38
     1         *t43*t76*t9-3.646239897876477d+2*t41*t46*t75*t9+6.0770664
     2         96460795d+2*t35*t40*t75*t9-6.077066496460795d+2*t38*t43*t
     3         74*t9+9.115599744691192d+2*t32*t37*t74*t9-9.1155997446911
     4         92d+2*t35*t40*t73*t9+1.276183964256767d+3*t29*t34*t73*t9-
     5         1.276183964256767d+3*t32*t37*t72*t9+1.7015786190090226d+3
     6         *t26*t31*t72*t9-1.7015786190090226d+3*t29*t34*t71*t9+2.18
     7         7743938725886d+3*t23*t28*t71*t9-2.187743938725886d+3*t26*
     8         t31*t70*t9+2.734679923407357d+3*t20*t25*t70*t9-2.73467992
     9         3407357d+3*t23*t28*t69*t9+3.342386573053437d+3*t137*t22*t
     :         69*t9-3.342386573053437d+3*t20*t25*t68*t9+4.0108638876641
     ;         245d+3*t176*t18*t68*t9)-9.305257363491002d-1*t12*t4*t52*(
     <         6.077066496460795d+1*t17*t44*t64*t9-6.077066496460795d+1*
     =         t47*t63*t9+1.8231199489382385d+2*t41*t46*t63*t9-1.8231199
     >         489382385d+2*t17*t44*t62*t9+3.646239897876477d+2*t38*t43*
     ?         t62*t9-3.646239897876477d+2*t41*t46*t61*t9+6.077066496460
     @         795d+2*t35*t40*t61*t9-6.077066496460795d+2*t38*t43*t60*t9
     1         +9.115599744691192d+2*t32*t37*t60*t9-9.115599744691192d+2
     2         *t35*t40*t59*t9+1.276183964256767d+3*t29*t34*t59*t9-1.276
     3         183964256767d+3*t32*t37*t58*t9+1.7015786190090226d+3*t26*
     4         t31*t58*t9-1.7015786190090226d+3*t29*t34*t57*t9+2.1877439
     5         38725886d+3*t23*t28*t57*t9-2.187743938725886d+3*t26*t31*t
     6         56*t9+2.734679923407357d+3*t20*t25*t56*t9-2.7346799234073
     7         57d+3*t23*t28*t55*t9+3.342386573053437d+3*t137*t22*t55*t9
     8         -3.342386573053437d+3*t20*t25*t54*t9+4.0108638876641245d+
     9         3*t176*t18*t54*t9)-9.305257363491002d-1*t12*t3*t4*(6.0770
     :         66496460795d+1*t17*t44*t48*t9-6.077066496460795d+1*t45*t4
     ;         7*t9+1.8231199489382385d+2*t41*t45*t46*t9-3.6462398978764
     <         77d+2*t39*t41*t46*t9-1.8231199489382385d+2*t17*t42*t44*t9
     =         +3.646239897876477d+2*t38*t42*t43*t9-6.077066496460795d+2
     >         *t36*t38*t43*t9+6.077066496460795d+2*t35*t39*t40*t9-9.115
     ?         599744691192d+2*t33*t35*t40*t9+9.115599744691192d+2*t32*t
     @         36*t37*t9-1.276183964256767d+3*t30*t32*t37*t9+1.276183964
     1         256767d+3*t29*t33*t34*t9-1.7015786190090226d+3*t27*t29*t3
     2         4*t9+1.7015786190090226d+3*t26*t30*t31*t9-2.1877439387258
     3         86d+3*t24*t26*t31*t9+2.187743938725886d+3*t23*t27*t28*t9-
     4         2.734679923407357d+3*t21*t23*t28*t9+2.734679923407357d+3*
     5         t20*t24*t25*t9-3.342386573053437d+3*t14*t20*t25*t9+3.3423
     6         86573053437d+3*t137*t21*t22*t9+4.0108638876641245d+3*t14*
     7         t176*t18*t9)-5.417385299101419d-3*gammaaa*t151*t171*t51*t
     8         66-9.632279000746596d-3*gammaaa*t142*t151*t170*t66-1.2407
     9         009817988002d+0*t12*t169*t5*t52-9.305257363491002d-1*t150
     :         *t169*t4*t52+t152*t171*t52+5.041016444533138d-3*gammaaa*t
     ;         12*t143*t169*t51-1.2407009817988002d+0*t12*t168*t3*t5-9.3
     <         05257363491002d-1*t150*t168*t3*t4+t152*t170*t3+8.96308350
     =         9889702d-3*gammaaa*t12*t142*t143*t168)*wght+Mmat2(iq,D2_R
     >         A_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = 1.0d+0*(-1.2407009817988002d+0*t104*t17
     1         2*t95*t97-1.2407009817988002d+0*t104*t132*t173*t97-9.3052
     2         57363491002d-1*t104*(6.077066496460795d+1*t101*t107*t126*
     3         t48-6.077066496460795d+1*t101*t128*t45+1.8231199489382385
     4         d+2*t101*t124*t127*t45-1.8231199489382385d+2*t101*t107*t1
     5         26*t42+3.646239897876477d+2*t101*t122*t125*t42-3.64623989
     6         7876477d+2*t101*t124*t127*t39+6.077066496460795d+2*t101*t
     7         120*t123*t39-6.077066496460795d+2*t101*t122*t125*t36+9.11
     8         5599744691192d+2*t101*t118*t121*t36-9.115599744691192d+2*
     9         t101*t120*t123*t33+1.276183964256767d+3*t101*t116*t119*t3
     :         3-1.276183964256767d+3*t101*t118*t121*t30+1.7015786190090
     ;         226d+3*t101*t114*t117*t30-1.7015786190090226d+3*t101*t116
     <         *t119*t27+2.187743938725886d+3*t101*t112*t115*t27-2.18774
     =         3938725886d+3*t101*t114*t117*t24+2.734679923407357d+3*t10
     >         1*t110*t113*t24+3.342386573053437d+3*t101*t111*t153*t21-2
     ?         .734679923407357d+3*t101*t112*t115*t21+4.0108638876641245
     @         d+3*t101*t108*t14*t186-3.342386573053437d+3*t101*t110*t11
     1         3*t14)*t95*t96-9.305257363491002d-1*t165*t172*t95*t96-9.3
     2         05257363491002d-1*t104*t132*(6.077066496460795d+1*t101*t1
     3         07*t126*t64-6.077066496460795d+1*t101*t128*t63+1.82311994
     4         89382385d+2*t101*t124*t127*t63-1.8231199489382385d+2*t101
     5         *t107*t126*t62+3.646239897876477d+2*t101*t122*t125*t62-3.
     6         646239897876477d+2*t101*t124*t127*t61+6.077066496460795d+
     7         2*t101*t120*t123*t61-6.077066496460795d+2*t101*t122*t125*
     8         t60+9.115599744691192d+2*t101*t118*t121*t60-9.11559974469
     9         1192d+2*t101*t120*t123*t59+1.276183964256767d+3*t101*t116
     :         *t119*t59-1.276183964256767d+3*t101*t118*t121*t58+1.70157
     ;         86190090226d+3*t101*t114*t117*t58-1.7015786190090226d+3*t
     <         101*t116*t119*t57+2.187743938725886d+3*t101*t112*t115*t57
     =         -2.187743938725886d+3*t101*t114*t117*t56+2.73467992340735
     >         7d+3*t101*t110*t113*t56+3.342386573053437d+3*t101*t111*t1
     ?         53*t55-2.734679923407357d+3*t101*t112*t115*t55+4.01086388
     @         76641245d+3*t101*t108*t186*t54-3.342386573053437d+3*t101*
     1         t110*t113*t54)*t96-9.305257363491002d-1*t132*t165*t173*t9
     2         6+t134*(6.077066496460795d+1*t101*t107*t126*t78-6.0770664
     3         96460795d+1*t101*t128*t77+1.8231199489382385d+2*t101*t124
     4         *t127*t77-1.8231199489382385d+2*t101*t107*t126*t76+3.6462
     5         39897876477d+2*t101*t122*t125*t76-3.646239897876477d+2*t1
     6         01*t124*t127*t75+6.077066496460795d+2*t101*t120*t123*t75-
     7         6.077066496460795d+2*t101*t122*t125*t74+9.115599744691192
     8         d+2*t101*t118*t121*t74-9.115599744691192d+2*t101*t120*t12
     9         3*t73+1.276183964256767d+3*t101*t116*t119*t73-1.276183964
     :         256767d+3*t101*t118*t121*t72+1.7015786190090226d+3*t101*t
     ;         114*t117*t72-1.7015786190090226d+3*t101*t116*t119*t71+2.1
     <         87743938725886d+3*t101*t112*t115*t71-2.187743938725886d+3
     =         *t101*t114*t117*t70+2.734679923407357d+3*t101*t110*t113*t
     >         70+3.342386573053437d+3*t101*t111*t153*t69-2.734679923407
     ?         357d+3*t101*t112*t115*t69+4.0108638876641245d+3*t101*t108
     @         *t186*t68-3.342386573053437d+3*t101*t110*t113*t68)*t95+t1
     1         67*t174*t95+t132*t134*(6.077066496460795d+1*t101*t107*t12
     2         6*t91-6.077066496460795d+1*t101*t128*t90+1.82311994893823
     3         85d+2*t101*t124*t127*t90-1.8231199489382385d+2*t101*t107*
     4         t126*t89+3.646239897876477d+2*t101*t122*t125*t89-3.646239
     5         897876477d+2*t101*t124*t127*t88+6.077066496460795d+2*t101
     6         *t120*t123*t88-6.077066496460795d+2*t101*t122*t125*t87+9.
     7         115599744691192d+2*t101*t118*t121*t87-9.115599744691192d+
     8         2*t101*t120*t123*t86+1.276183964256767d+3*t101*t116*t119*
     9         t86-1.276183964256767d+3*t101*t118*t121*t85+1.70157861900
     :         90226d+3*t101*t114*t117*t85-1.7015786190090226d+3*t101*t1
     ;         16*t119*t84+2.187743938725886d+3*t101*t112*t115*t84-2.187
     <         743938725886d+3*t101*t114*t117*t83+2.734679923407357d+3*t
     =         101*t110*t113*t83+3.342386573053437d+3*t101*t111*t153*t82
     >         -2.734679923407357d+3*t101*t112*t115*t82+4.01086388766412
     ?         45d+3*t101*t108*t186*t81-3.342386573053437d+3*t101*t110*t
     @         113*t81)+t132*t167*t175-5.417385299101419d-3*gammabb*t131
     1         *t134*t166*t175-9.632279000746596d-3*gammabb*t134*t158*t1
     2         66*t174+5.041016444533138d-3*gammabb*t104*t131*t159*t173+
     3         8.963083509889702d-3*gammabb*t104*t158*t159*t172)*wght+Mm
     4         at2(iq,D2_RB_TB)
            Mmat2(iq,D2_GAA_TA) = 1.0d+0*(2.0315194871630324d-3*t1*t171*
     1         t51*t66+3.612104625279974d-3*t1*t142*t170*t66-1.890381166
     2         699927d-3*t12*t144*t169*t51-3.361156316208638d-3*t12*t142
     3         *t144*t168)*wght+Mmat2(iq,D2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
            Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = 1.0d+0*(2.0315194871630324d-3*t131*t13
     1         4*t175*t93+3.612104625279974d-3*t134*t158*t174*t93-1.8903
     2         81166699927d-3*t104*t131*t160*t173-3.361156316208638d-3*t
     3         104*t158*t160*t172)*wght+Mmat2(iq,D2_GBB_TB)
            Mmat2(iq,D2_TA_TA) = 1.0d+0*(t52*t66*(8.0d+0*t47*t91+8.0d+0*
     1         t17*t44*t91+8.0d+0*t47*t90+2.4d+1*t41*t46*t90+3.2d+1*t17*
     2         t44*t90+7.2d+1*t41*t46*t89+2.4d+1*t17*t44*t89+4.8d+1*t38*
     3         t43*t89+4.8d+1*t41*t46*t88+1.28d+2*t38*t43*t88+8.0d+1*t35
     4         *t40*t88+8.0d+1*t38*t43*t87+2.0d+2*t35*t40*t87+1.2d+2*t32
     5         *t37*t87+1.2d+2*t35*t40*t86+2.88d+2*t32*t37*t86+1.68d+2*t
     6         29*t34*t86+1.68d+2*t32*t37*t85+3.92d+2*t29*t34*t85+2.24d+
     7         2*t26*t31*t85+2.24d+2*t29*t34*t84+5.12d+2*t26*t31*t84+2.8
     8         8d+2*t23*t28*t84+2.88d+2*t26*t31*t83+6.48d+2*t23*t28*t83+
     9         3.6d+2*t20*t25*t83+3.6d+2*t23*t28*t82+8.0d+2*t20*t25*t82+
     :         4.4d+2*t137*t22*t82+4.4d+2*t20*t25*t81+9.68d+2*t137*t22*t
     ;         81+5.28d+2*t176*t18*t81)+t3*t66*(8.0d+0*t47*t78+8.0d+0*t1
     <         7*t44*t78+8.0d+0*t47*t77+2.4d+1*t41*t46*t77+3.2d+1*t17*t4
     =         4*t77+7.2d+1*t41*t46*t76+2.4d+1*t17*t44*t76+4.8d+1*t38*t4
     >         3*t76+4.8d+1*t41*t46*t75+1.28d+2*t38*t43*t75+8.0d+1*t35*t
     ?         40*t75+8.0d+1*t38*t43*t74+2.0d+2*t35*t40*t74+1.2d+2*t32*t
     @         37*t74+1.2d+2*t35*t40*t73+2.88d+2*t32*t37*t73+1.68d+2*t29
     1         *t34*t73+1.68d+2*t32*t37*t72+3.92d+2*t29*t34*t72+2.24d+2*
     2         t26*t31*t72+2.24d+2*t29*t34*t71+5.12d+2*t26*t31*t71+2.88d
     3         +2*t23*t28*t71+2.88d+2*t26*t31*t70+6.48d+2*t23*t28*t70+3.
     4         6d+2*t20*t25*t70+3.6d+2*t23*t28*t69+8.0d+2*t20*t25*t69+4.
     5         4d+2*t137*t22*t69+4.4d+2*t20*t25*t68+9.68d+2*t137*t22*t68
     6         +5.28d+2*t176*t18*t68)-9.305257363491002d-1*t12*t4*t52*(8
     7         .0d+0*t47*t64+8.0d+0*t17*t44*t64+8.0d+0*t47*t63+2.4d+1*t4
     8         1*t46*t63+3.2d+1*t17*t44*t63+7.2d+1*t41*t46*t62+2.4d+1*t1
     9         7*t44*t62+4.8d+1*t38*t43*t62+4.8d+1*t41*t46*t61+1.28d+2*t
     :         38*t43*t61+8.0d+1*t35*t40*t61+8.0d+1*t38*t43*t60+2.0d+2*t
     ;         35*t40*t60+1.2d+2*t32*t37*t60+1.2d+2*t35*t40*t59+2.88d+2*
     <         t32*t37*t59+1.68d+2*t29*t34*t59+1.68d+2*t32*t37*t58+3.92d
     =         +2*t29*t34*t58+2.24d+2*t26*t31*t58+2.24d+2*t29*t34*t57+5.
     >         12d+2*t26*t31*t57+2.88d+2*t23*t28*t57+2.88d+2*t26*t31*t56
     ?         +6.48d+2*t23*t28*t56+3.6d+2*t20*t25*t56+3.6d+2*t23*t28*t5
     @         5+8.0d+2*t20*t25*t55+4.4d+2*t137*t22*t55+4.4d+2*t20*t25*t
     1         54+9.68d+2*t137*t22*t54+5.28d+2*t176*t18*t54)-9.305257363
     2         491002d-1*t12*t3*t4*(8.0d+0*t47*t48+8.0d+0*t17*t44*t48+8.
     3         0d+0*t45*t47+2.4d+1*t41*t45*t46+7.2d+1*t41*t42*t46+4.8d+1
     4         *t39*t41*t46+3.2d+1*t17*t44*t45+2.4d+1*t17*t42*t44+4.8d+1
     5         *t38*t42*t43+1.28d+2*t38*t39*t43+8.0d+1*t36*t38*t43+8.0d+
     6         1*t35*t39*t40+2.0d+2*t35*t36*t40+1.2d+2*t33*t35*t40+1.2d+
     7         2*t32*t36*t37+2.88d+2*t32*t33*t37+1.68d+2*t30*t32*t37+1.6
     8         8d+2*t29*t33*t34+3.92d+2*t29*t30*t34+2.24d+2*t27*t29*t34+
     9         2.24d+2*t26*t30*t31+5.12d+2*t26*t27*t31+2.88d+2*t24*t26*t
     :         31+2.88d+2*t23*t27*t28+6.48d+2*t23*t24*t28+3.6d+2*t21*t23
     ;         *t28+3.6d+2*t20*t24*t25+8.0d+2*t20*t21*t25+4.4d+2*t14*t20
     <         *t25+4.4d+2*t137*t21*t22+9.68d+2*t137*t14*t22+5.28d+2*t14
     =         *t176*t18))*wght+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = 1.0d+0*(-9.305257363491002d-1*t104*(8.0
     1         d+0*t128*t48+8.0d+0*t107*t126*t48+8.0d+0*t128*t45+2.4d+1*
     2         t124*t127*t45+3.2d+1*t107*t126*t45+7.2d+1*t124*t127*t42+2
     3         .4d+1*t107*t126*t42+4.8d+1*t122*t125*t42+4.8d+1*t124*t127
     4         *t39+1.28d+2*t122*t125*t39+8.0d+1*t120*t123*t39+8.0d+1*t1
     5         22*t125*t36+2.0d+2*t120*t123*t36+1.2d+2*t118*t121*t36+1.2
     6         d+2*t120*t123*t33+2.88d+2*t118*t121*t33+1.68d+2*t116*t119
     7         *t33+1.68d+2*t118*t121*t30+3.92d+2*t116*t119*t30+2.24d+2*
     8         t114*t117*t30+2.24d+2*t116*t119*t27+5.12d+2*t114*t117*t27
     9         +2.88d+2*t112*t115*t27+2.88d+2*t114*t117*t24+6.48d+2*t112
     :         *t115*t24+3.6d+2*t110*t113*t24+4.4d+2*t111*t153*t21+3.6d+
     ;         2*t112*t115*t21+8.0d+2*t110*t113*t21+5.28d+2*t108*t14*t18
     <         6+9.68d+2*t111*t14*t153+4.4d+2*t110*t113*t14)*t95*t96-9.3
     =         05257363491002d-1*t104*t132*(8.0d+0*t128*t64+8.0d+0*t107*
     >         t126*t64+8.0d+0*t128*t63+2.4d+1*t124*t127*t63+3.2d+1*t107
     ?         *t126*t63+7.2d+1*t124*t127*t62+2.4d+1*t107*t126*t62+4.8d+
     @         1*t122*t125*t62+4.8d+1*t124*t127*t61+1.28d+2*t122*t125*t6
     1         1+8.0d+1*t120*t123*t61+8.0d+1*t122*t125*t60+2.0d+2*t120*t
     2         123*t60+1.2d+2*t118*t121*t60+1.2d+2*t120*t123*t59+2.88d+2
     3         *t118*t121*t59+1.68d+2*t116*t119*t59+1.68d+2*t118*t121*t5
     4         8+3.92d+2*t116*t119*t58+2.24d+2*t114*t117*t58+2.24d+2*t11
     5         6*t119*t57+5.12d+2*t114*t117*t57+2.88d+2*t112*t115*t57+2.
     6         88d+2*t114*t117*t56+6.48d+2*t112*t115*t56+3.6d+2*t110*t11
     7         3*t56+4.4d+2*t111*t153*t55+3.6d+2*t112*t115*t55+8.0d+2*t1
     8         10*t113*t55+5.28d+2*t108*t186*t54+9.68d+2*t111*t153*t54+4
     9         .4d+2*t110*t113*t54)*t96+t134*(8.0d+0*t128*t78+8.0d+0*t10
     :         7*t126*t78+8.0d+0*t128*t77+2.4d+1*t124*t127*t77+3.2d+1*t1
     ;         07*t126*t77+7.2d+1*t124*t127*t76+2.4d+1*t107*t126*t76+4.8
     <         d+1*t122*t125*t76+4.8d+1*t124*t127*t75+1.28d+2*t122*t125*
     =         t75+8.0d+1*t120*t123*t75+8.0d+1*t122*t125*t74+2.0d+2*t120
     >         *t123*t74+1.2d+2*t118*t121*t74+1.2d+2*t120*t123*t73+2.88d
     ?         +2*t118*t121*t73+1.68d+2*t116*t119*t73+1.68d+2*t118*t121*
     @         t72+3.92d+2*t116*t119*t72+2.24d+2*t114*t117*t72+2.24d+2*t
     1         116*t119*t71+5.12d+2*t114*t117*t71+2.88d+2*t112*t115*t71+
     2         2.88d+2*t114*t117*t70+6.48d+2*t112*t115*t70+3.6d+2*t110*t
     3         113*t70+4.4d+2*t111*t153*t69+3.6d+2*t112*t115*t69+8.0d+2*
     4         t110*t113*t69+5.28d+2*t108*t186*t68+9.68d+2*t111*t153*t68
     5         +4.4d+2*t110*t113*t68)*t95+t132*t134*(8.0d+0*t128*t91+8.0
     6         d+0*t107*t126*t91+8.0d+0*t128*t90+2.4d+1*t124*t127*t90+3.
     7         2d+1*t107*t126*t90+7.2d+1*t124*t127*t89+2.4d+1*t107*t126*
     8         t89+4.8d+1*t122*t125*t89+4.8d+1*t124*t127*t88+1.28d+2*t12
     9         2*t125*t88+8.0d+1*t120*t123*t88+8.0d+1*t122*t125*t87+2.0d
     :         +2*t120*t123*t87+1.2d+2*t118*t121*t87+1.2d+2*t120*t123*t8
     ;         6+2.88d+2*t118*t121*t86+1.68d+2*t116*t119*t86+1.68d+2*t11
     <         8*t121*t85+3.92d+2*t116*t119*t85+2.24d+2*t114*t117*t85+2.
     =         24d+2*t116*t119*t84+5.12d+2*t114*t117*t84+2.88d+2*t112*t1
     >         15*t84+2.88d+2*t114*t117*t83+6.48d+2*t112*t115*t83+3.6d+2
     ?         *t110*t113*t83+4.4d+2*t111*t153*t82+3.6d+2*t112*t115*t82+
     @         8.0d+2*t110*t113*t82+5.28d+2*t108*t186*t81+9.68d+2*t111*t
     1         153*t81+4.4d+2*t110*t113*t81))*wght+Mmat2(iq,D2_TB_TB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = rhoa**3.333333333333333d-1
            t6 = 1/t5
            t7 = 1/rhoa
            t8 = 1.282782438530422d-1*t6-2.63857249068588d-4*t7
            t9 = rhoa**6.666666666666666d-1
            t10 = exp(-2.4308265985843178d+2*t9)
            t11 = t10*t8+2.63857249068588d-4*t7-1.924173657795633d-1*t6+
     1         3.544907701811032d+0*erf(1.5591108358883013d+1*t5)
            t12 = 1.0d+0-4.275941461768073d-2*t11*t6
            t13 = param(12)
            t14 = rhoa**1.6666666666666669d+0
            t15 = 9.115599744691192d+0*t14
            t16 = t15-2.0d+0*taua
            t17 = t16**11
            t18 = 2.0d+0*taua+t15
            t19 = 1/t18**11
            t20 = param(11)
            t21 = t16**10
            t22 = 1/t18**10
            t23 = param(10)
            t24 = t16**9
            t25 = 1/t18**9
            t26 = param(9)
            t27 = t16**8
            t28 = 1/t18**8
            t29 = param(8)
            t30 = t16**7
            t31 = 1/t18**7
            t32 = param(7)
            t33 = t16**6
            t34 = 1/t18**6
            t35 = param(6)
            t36 = t16**5
            t37 = 1/t18**5
            t38 = param(5)
            t39 = t16**4
            t40 = 1/t18**4
            t41 = param(4)
            t42 = t16**3
            t43 = 1/t18**3
            t44 = param(3)
            t45 = t16**2
            t46 = 1/t18**2
            t47 = param(2)
            t48 = 1/t18
            t49 = t16*t47*t48+t44*t45*t46+t41*t42*t43+t38*t39*t40+t35*t3
     1         6*t37+t32*t33*t34+t29*t30*t31+t26*t27*t28+t23*t24*t25+t20
     2         *t21*t22+t13*t17*t19+param(1)
            t50 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t51 = 5.52d-1*(1.0d+0-t50)+1.0d+0
            t52 = param(24)
            t53 = param(23)
            t54 = param(22)
            t55 = param(21)
            t56 = param(20)
            t57 = param(19)
            t58 = param(18)
            t59 = param(17)
            t60 = param(16)
            t61 = param(15)
            t62 = param(14)
            t63 = t16*t48*t62+t45*t46*t61+t42*t43*t60+t39*t40*t59+t36*t3
     1         7*t58+t33*t34*t57+t30*t31*t56+t27*t28*t55+t24*t25*t54+t21
     2         *t22*t53+t17*t19*t52+param(13)
            t64 = 9.305257363491002d-1*t12*t4-9.305257363491002d-1*t4
            t65 = param(36)
            t66 = param(35)
            t67 = param(34)
            t68 = param(33)
            t69 = param(32)
            t70 = param(31)
            t71 = param(30)
            t72 = param(29)
            t73 = param(28)
            t74 = param(27)
            t75 = param(26)
            t76 = t16*t48*t75+t45*t46*t74+t42*t43*t73+t39*t40*t72+t36*t3
     1         7*t71+t33*t34*t70+t30*t31*t69+t27*t28*t68+t24*t25*t67+t21
     2         *t22*t66+t17*t19*t65+param(25)
            t77 = param(48)
            t78 = param(47)
            t79 = param(46)
            t80 = param(45)
            t81 = param(44)
            t82 = param(43)
            t83 = param(42)
            t84 = param(41)
            t85 = param(40)
            t86 = param(39)
            t87 = param(38)
            t88 = t16*t48*t87+t45*t46*t86+t42*t43*t85+t39*t40*t84+t36*t3
     1         7*t83+t33*t34*t82+t30*t31*t81+t27*t28*t80+t24*t25*t79+t21
     2         *t22*t78+t17*t19*t77+param(37)
            t89 = 1/t18**12
            t90 = -1.6711932865267184d+2*t13*t17*t89*t9+1.51926662411519
     1         86d+1*t47*t48*t9-1.5192666241151986d+1*t16*t46*t47*t9+3.0
     2         38533248230397d+1*t16*t44*t46*t9-3.038533248230397d+1*t43
     3         *t44*t45*t9+4.5577998723455965d+1*t41*t43*t45*t9-4.557799
     4         8723455965d+1*t40*t41*t42*t9+6.077066496460795d+1*t38*t40
     5         *t42*t9-6.077066496460795d+1*t37*t38*t39*t9+7.59633312057
     6         5993d+1*t35*t37*t39*t9-7.596333120575993d+1*t34*t35*t36*t
     7         9+9.115599744691193d+1*t32*t34*t36*t9-9.115599744691193d+
     8         1*t31*t32*t33*t9+1.0634866368806391d+2*t29*t31*t33*t9-1.0
     9         634866368806391d+2*t28*t29*t30*t9+1.2154132992921589d+2*t
     :         26*t28*t30*t9-1.2154132992921589d+2*t25*t26*t27*t9+1.3673
     ;         399617036788d+2*t23*t25*t27*t9-1.3673399617036788d+2*t22*
     <         t23*t24*t9+1.5192666241151986d+2*t20*t22*t24*t9-1.5192666
     =         241151986d+2*t19*t20*t21*t9+1.6711932865267184d+2*t13*t19
     >         *t21*t9
            t91 = -1.6711932865267184d+2*t17*t52*t89*t9+1.51926662411519
     1         86d+1*t48*t62*t9-1.5192666241151986d+1*t16*t46*t62*t9+3.0
     2         38533248230397d+1*t16*t46*t61*t9-3.038533248230397d+1*t43
     3         *t45*t61*t9+4.5577998723455965d+1*t43*t45*t60*t9-4.557799
     4         8723455965d+1*t40*t42*t60*t9+6.077066496460795d+1*t40*t42
     5         *t59*t9-6.077066496460795d+1*t37*t39*t59*t9+7.59633312057
     6         5993d+1*t37*t39*t58*t9-7.596333120575993d+1*t34*t36*t58*t
     7         9+9.115599744691193d+1*t34*t36*t57*t9-9.115599744691193d+
     8         1*t31*t33*t57*t9+1.0634866368806391d+2*t31*t33*t56*t9-1.0
     9         634866368806391d+2*t28*t30*t56*t9+1.2154132992921589d+2*t
     :         28*t30*t55*t9-1.2154132992921589d+2*t25*t27*t55*t9+1.3673
     ;         399617036788d+2*t25*t27*t54*t9-1.3673399617036788d+2*t22*
     <         t24*t54*t9+1.5192666241151986d+2*t22*t24*t53*t9-1.5192666
     =         241151986d+2*t19*t21*t53*t9+1.6711932865267184d+2*t19*t21
     >         *t52*t9
            t92 = -1.6711932865267184d+2*t17*t65*t89*t9+1.51926662411519
     1         86d+1*t48*t75*t9-1.5192666241151986d+1*t16*t46*t75*t9+3.0
     2         38533248230397d+1*t16*t46*t74*t9-3.038533248230397d+1*t43
     3         *t45*t74*t9+4.5577998723455965d+1*t43*t45*t73*t9-4.557799
     4         8723455965d+1*t40*t42*t73*t9+6.077066496460795d+1*t40*t42
     5         *t72*t9-6.077066496460795d+1*t37*t39*t72*t9+7.59633312057
     6         5993d+1*t37*t39*t71*t9-7.596333120575993d+1*t34*t36*t71*t
     7         9+9.115599744691193d+1*t34*t36*t70*t9-9.115599744691193d+
     8         1*t31*t33*t70*t9+1.0634866368806391d+2*t31*t33*t69*t9-1.0
     9         634866368806391d+2*t28*t30*t69*t9+1.2154132992921589d+2*t
     :         28*t30*t68*t9-1.2154132992921589d+2*t25*t27*t68*t9+1.3673
     ;         399617036788d+2*t25*t27*t67*t9-1.3673399617036788d+2*t22*
     <         t24*t67*t9+1.5192666241151986d+2*t22*t24*t66*t9-1.5192666
     =         241151986d+2*t19*t21*t66*t9+1.6711932865267184d+2*t19*t21
     >         *t65*t9
            t93 = -1.6711932865267184d+2*t17*t77*t89*t9+1.51926662411519
     1         86d+1*t48*t87*t9-1.5192666241151986d+1*t16*t46*t87*t9+3.0
     2         38533248230397d+1*t16*t46*t86*t9-3.038533248230397d+1*t43
     3         *t45*t86*t9+4.5577998723455965d+1*t43*t45*t85*t9-4.557799
     4         8723455965d+1*t40*t42*t85*t9+6.077066496460795d+1*t40*t42
     5         *t84*t9-6.077066496460795d+1*t37*t39*t84*t9+7.59633312057
     6         5993d+1*t37*t39*t83*t9-7.596333120575993d+1*t34*t36*t83*t
     7         9+9.115599744691193d+1*t34*t36*t82*t9-9.115599744691193d+
     8         1*t31*t33*t82*t9+1.0634866368806391d+2*t31*t33*t81*t9-1.0
     9         634866368806391d+2*t28*t30*t81*t9+1.2154132992921589d+2*t
     :         28*t30*t80*t9-1.2154132992921589d+2*t25*t27*t80*t9+1.3673
     ;         399617036788d+2*t25*t27*t79*t9-1.3673399617036788d+2*t22*
     <         t24*t79*t9+1.5192666241151986d+2*t22*t24*t78*t9-1.5192666
     =         241151986d+2*t19*t21*t78*t9+1.6711932865267184d+2*t19*t21
     >         *t77*t9
            t94 = 1/t2**2
            t95 = 1/rhoa**2.3333333333333334d+0
            t96 = 1/t4
            t97 = 1/rhoa**2
            t98 = 2.63857249068588d-4*t97-4.2759414617680735d-2*t96
            t99 = 5.641895835477563d-1
            t100 = 1/t9
            t101 = 3.6846026734116505d+1*t10*t100*t99+t10*t98-2.63857249
     1         068588d-4*t97+6.41391219265211d-2*t96-1.6205510657228786d
     2         +2*t10*t6*t8
            t102 = 1.4253138205893576d-2*t11*t96-4.275941461768073d-2*t1
     1         01*t6
            t103 = 1/rhoa**3.6666666666666664d+0
            t104 = 1.2407009817988002d+0*t12*t5-1.2407009817988002d+0*t5
     1         +9.305257363491002d-1*t102*t4
            t105 = -2.2d+1*t13*t17*t89-2.0d+0*t47*t48-2.0d+0*t16*t46*t47
     1         -4.0d+0*t16*t44*t46-4.0d+0*t43*t44*t45-6.0d+0*t41*t43*t45
     2         -6.0d+0*t40*t41*t42-8.0d+0*t38*t40*t42-8.0d+0*t37*t38*t39
     3         -1.0d+1*t35*t37*t39-1.0d+1*t34*t35*t36-1.2d+1*t32*t34*t36
     4         -1.2d+1*t31*t32*t33-1.4d+1*t29*t31*t33-1.4d+1*t28*t29*t30
     5         -1.6d+1*t26*t28*t30-1.6d+1*t25*t26*t27-1.8d+1*t23*t25*t27
     6         -1.8d+1*t22*t23*t24-2.0d+1*t20*t22*t24-2.0d+1*t19*t20*t21
     7         -2.2d+1*t13*t19*t21
            t106 = -2.2d+1*t17*t52*t89-2.0d+0*t48*t62-2.0d+0*t16*t46*t62
     1         -4.0d+0*t16*t46*t61-4.0d+0*t43*t45*t61-6.0d+0*t43*t45*t60
     2         -6.0d+0*t40*t42*t60-8.0d+0*t40*t42*t59-8.0d+0*t37*t39*t59
     3         -1.0d+1*t37*t39*t58-1.0d+1*t34*t36*t58-1.2d+1*t34*t36*t57
     4         -1.2d+1*t31*t33*t57-1.4d+1*t31*t33*t56-1.4d+1*t28*t30*t56
     5         -1.6d+1*t28*t30*t55-1.6d+1*t25*t27*t55-1.8d+1*t25*t27*t54
     6         -1.8d+1*t22*t24*t54-2.0d+1*t22*t24*t53-2.0d+1*t19*t21*t53
     7         -2.2d+1*t19*t21*t52
            t107 = -2.2d+1*t17*t65*t89-2.0d+0*t48*t75-2.0d+0*t16*t46*t75
     1         -4.0d+0*t16*t46*t74-4.0d+0*t43*t45*t74-6.0d+0*t43*t45*t73
     2         -6.0d+0*t40*t42*t73-8.0d+0*t40*t42*t72-8.0d+0*t37*t39*t72
     3         -1.0d+1*t37*t39*t71-1.0d+1*t34*t36*t71-1.2d+1*t34*t36*t70
     4         -1.2d+1*t31*t33*t70-1.4d+1*t31*t33*t69-1.4d+1*t28*t30*t69
     5         -1.6d+1*t28*t30*t68-1.6d+1*t25*t27*t68-1.8d+1*t25*t27*t67
     6         -1.8d+1*t22*t24*t67-2.0d+1*t22*t24*t66-2.0d+1*t19*t21*t66
     7         -2.2d+1*t19*t21*t65
            t108 = -2.2d+1*t17*t77*t89-2.0d+0*t48*t87-2.0d+0*t16*t46*t87
     1         -4.0d+0*t16*t46*t86-4.0d+0*t43*t45*t86-6.0d+0*t43*t45*t85
     2         -6.0d+0*t40*t42*t85-8.0d+0*t40*t42*t84-8.0d+0*t37*t39*t84
     3         -1.0d+1*t37*t39*t83-1.0d+1*t34*t36*t83-1.2d+1*t34*t36*t82
     4         -1.2d+1*t31*t33*t82-1.4d+1*t31*t33*t81-1.4d+1*t28*t30*t81
     5         -1.6d+1*t28*t30*t80-1.6d+1*t25*t27*t80-1.8d+1*t25*t27*t79
     6         -1.8d+1*t22*t24*t79-2.0d+1*t22*t24*t78-2.0d+1*t19*t21*t78
     7         -2.2d+1*t19*t21*t77
            t109 = 1/t18**13
            t110 = gammaaa**2
            t111 = 1/t2**3
            t112 = 1/rhoa**6
            t113 = 1/rhoa**3.3333333333333337d+0
            t114 = 1/rhoa**3
            t115 = -4.275941461768073d-2*t6*(-5.971086789162617d+3*t10*t
     1         7*t99-2.4564017822744336d+1*t10*t99/t14-3.241102131445757
     2         d+2*t10*t6*t98+5.401836885742928d+1*t10*t8*t96-8.55188292
     3         3536147d-2*t95+t10*(5.701255282357431d-2*t95-5.2771449813
     4         7176d-4*t114)+2.626185756615557d+4*t10*t100*t8+5.27714498
     5         137176d-4*t114)+2.850627641178715d-2*t101*t96-1.900418427
     6         4524766d-2*t11*t95
            t116 = 1/rhoa**7.333333333333333d+0
            t117 = 1/rhoa**4.666666666666667d+0
            t118 = 2.4814019635976003d+0*t102*t5+9.305257363491002d-1*t1
     1         15*t4+4.135669939329334d-1*t100*t12-4.135669939329334d-1*
     2         t100
            t119 = 1/rhoa**5
            t120 = 1/rhoa**6.333333333333333d+0
            t121 = 1/rhoa**4
            t122 = 1/rhoa**5.333333333333333d+0
            fnc(iq) = 1.0d+0*(t51*t64*t88+t3*t64*t76-9.305257363491002d-
     1         1*t12*t4*t51*t63-9.305257363491002d-1*t12*t3*t4*t49)*wght
     2         +fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(8.963083509889702d-3*gammaaa*t12*t4
     1         9*t94*t95+5.041016444533138d-3*gammaaa*t12*t50*t63*t95-9.
     2         632279000746596d-3*gammaaa*t103*t64*t76*t94+t51*t64*t93+t
     3         3*t64*t92-9.305257363491002d-1*t12*t4*t51*t91-9.305257363
     4         491002d-1*t12*t3*t4*t90-5.417385299101419d-3*gammaaa*t103
     5         *t50*t64*t88+t104*t51*t88+t104*t3*t76-1.2407009817988002d
     6         +0*t12*t5*t51*t63-9.305257363491002d-1*t102*t4*t51*t63-1.
     7         2407009817988002d+0*t12*t3*t49*t5-9.305257363491002d-1*t1
     8         02*t3*t4*t49)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(-3.361156316208638d-3*t12*t49*t94*
     1         t96-1.890381166699927d-3*t12*t50*t63*t96+3.61210462527997
     2         4d-3*t1*t64*t76*t94+2.0315194871630324d-3*t1*t50*t64*t88)
     3         *wght+Cmat(iq,D1_GAA)
            Mmat(iq,D1_TA) = 1.0d+0*(t108*t51*t64+t107*t3*t64-9.30525736
     1         3491002d-1*t106*t12*t4*t51-9.305257363491002d-1*t105*t12*
     2         t3*t4)*wght+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*((1.7926167019779404d-2*gammaaa*
     1         t12*t90+1.7926167019779404d-2*gammaaa*t102*t49)*t94*t95+(
     2         1.0082032889066277d-2*gammaaa*t12*t50*t91+1.0082032889066
     3         277d-2*gammaaa*t102*t50*t63)*t95+t103*(-1.926455800149319
     4         3d-2*gammaaa*t64*t92-1.9264558001493193d-2*gammaaa*t104*t
     5         76)*t94+3.5318356336070855d-2*gammaaa*t117*t64*t76*t94-8.
     6         963083509889707d-3*gammaaa*t113*t12*t49*t94+t103*(-1.0834
     7         770598202839d-2*gammaaa*t50*t64*t93-1.0834770598202839d-2
     8         *gammaaa*t104*t50*t88)+2*t104*t51*t93+2*t104*t3*t92-2.481
     9         4019635976003d+0*t12*t5*t51*t91-1.8610514726982003d+0*t10
     :         2*t4*t51*t91-2.4814019635976003d+0*t12*t3*t5*t90-1.861051
     ;         4726982003d+0*t102*t3*t4*t90+t51*t64*(2.5389881826654315d
     <         +4*t21*t4*t78*t89-1.1141288576844789d+2*t17*t6*t77*t89-5.
     =         585774001863949d+4*t21*t4*t77*t89+1.0128444160767991d+1*t
     >         48*t6*t87-1.0128444160767991d+1*t16*t46*t6*t87-4.61634215
     ?         03007845d+2*t4*t46*t87+4.6163421503007845d+2*t16*t4*t43*t
     @         87+2.0256888321535982d+1*t16*t46*t6*t86-2.025688832153598
     1         2d+1*t43*t45*t6*t86+4.6163421503007845d+2*t4*t46*t86+1.38
     2         49026450902355d+3*t4*t40*t45*t86-1.846536860120314d+3*t16
     3         *t4*t43*t86+3.038533248230397d+1*t43*t45*t6*t85-3.0385332
     4         48230397d+1*t40*t42*t6*t85-4.1547079352707067d+3*t4*t40*t
     5         45*t85+1.3849026450902355d+3*t16*t4*t43*t85+2.76980529018
     6         0471d+3*t37*t4*t42*t85+4.0513776643071964d+1*t40*t42*t6*t
     7         84-4.0513776643071964d+1*t37*t39*t6*t84+2.769805290180471
     8         d+3*t4*t40*t45*t84-7.386147440481255d+3*t37*t4*t42*t84+4.
     9         616342150300784d+3*t34*t39*t4*t84+5.064222080383994d+1*t3
     :         7*t39*t6*t83-5.064222080383994d+1*t34*t36*t6*t83+4.616342
     ;         150300784d+3*t37*t4*t42*t83-1.154085537575196d+4*t34*t39*
     <         t4*t83+6.924513225451178d+3*t31*t36*t4*t83+6.077066496460
     =         795d+1*t34*t36*t6*t82-6.077066496460795d+1*t31*t33*t6*t82
     >         +6.924513225451178d+3*t34*t39*t4*t82-1.661883174108283d+4
     ?         *t31*t36*t4*t82+9.694318515631648d+3*t28*t33*t4*t82+7.089
     @         910912537593d+1*t31*t33*t6*t81-7.089910912537593d+1*t28*t
     1         30*t6*t81+9.694318515631648d+3*t31*t36*t4*t81-2.262007653
     2         6473846d+4*t28*t33*t4*t81+1.2925758020842196d+4*t25*t30*t
     3         4*t81+8.102755328614393d+1*t28*t30*t6*t80-8.1027553286143
     4         93d+1*t25*t27*t6*t80+1.2925758020842196d+4*t28*t33*t4*t80
     5         -2.954458976192502d+4*t25*t30*t4*t80+1.6618831741082823d+
     6         4*t22*t27*t4*t80+9.115599744691191d+1*t25*t27*t6*t79-9.11
     7         5599744691191d+1*t22*t24*t6*t79+1.6618831741082823d+4*t25
     8         *t30*t4*t79-3.7392371417436354d+4*t22*t27*t4*t79+2.077353
     9         9676353528d+4*t19*t24*t4*t79+1.012844416076799d+2*t22*t24
     :         *t6*t78-1.012844416076799d+2*t19*t21*t6*t78+2.07735396763
     ;         53528d+4*t22*t27*t4*t78-4.616342150300784d+4*t19*t24*t4*t
     <         78+1.1141288576844789d+2*t19*t21*t6*t77+2.538988182665431
     =         5d+4*t19*t24*t4*t77+3.046785819198518d+4*t109*t17*t4*t77)
     >         +t3*t64*(2.5389881826654315d+4*t21*t4*t66*t89-1.114128857
     ?         6844789d+2*t17*t6*t65*t89-5.585774001863949d+4*t21*t4*t65
     @         *t89+1.0128444160767991d+1*t48*t6*t75-1.0128444160767991d
     1         +1*t16*t46*t6*t75-4.6163421503007845d+2*t4*t46*t75+4.6163
     2         421503007845d+2*t16*t4*t43*t75+2.0256888321535982d+1*t16*
     3         t46*t6*t74-2.0256888321535982d+1*t43*t45*t6*t74+4.6163421
     4         503007845d+2*t4*t46*t74+1.3849026450902355d+3*t4*t40*t45*
     5         t74-1.846536860120314d+3*t16*t4*t43*t74+3.038533248230397
     6         d+1*t43*t45*t6*t73-3.038533248230397d+1*t40*t42*t6*t73-4.
     7         1547079352707067d+3*t4*t40*t45*t73+1.3849026450902355d+3*
     8         t16*t4*t43*t73+2.769805290180471d+3*t37*t4*t42*t73+4.0513
     9         776643071964d+1*t40*t42*t6*t72-4.0513776643071964d+1*t37*
     :         t39*t6*t72+2.769805290180471d+3*t4*t40*t45*t72-7.38614744
     ;         0481255d+3*t37*t4*t42*t72+4.616342150300784d+3*t34*t39*t4
     <         *t72+5.064222080383994d+1*t37*t39*t6*t71-5.06422208038399
     =         4d+1*t34*t36*t6*t71+4.616342150300784d+3*t37*t4*t42*t71-1
     >         .154085537575196d+4*t34*t39*t4*t71+6.924513225451178d+3*t
     ?         31*t36*t4*t71+6.077066496460795d+1*t34*t36*t6*t70-6.07706
     @         6496460795d+1*t31*t33*t6*t70+6.924513225451178d+3*t34*t39
     1         *t4*t70-1.661883174108283d+4*t31*t36*t4*t70+9.69431851563
     2         1648d+3*t28*t33*t4*t70+7.089910912537593d+1*t31*t33*t6*t6
     3         9-7.089910912537593d+1*t28*t30*t6*t69+9.694318515631648d+
     4         3*t31*t36*t4*t69-2.2620076536473846d+4*t28*t33*t4*t69+1.2
     5         925758020842196d+4*t25*t30*t4*t69+8.102755328614393d+1*t2
     6         8*t30*t6*t68-8.102755328614393d+1*t25*t27*t6*t68+1.292575
     7         8020842196d+4*t28*t33*t4*t68-2.954458976192502d+4*t25*t30
     8         *t4*t68+1.6618831741082823d+4*t22*t27*t4*t68+9.1155997446
     9         91191d+1*t25*t27*t6*t67-9.115599744691191d+1*t22*t24*t6*t
     :         67+1.6618831741082823d+4*t25*t30*t4*t67-3.739237141743635
     ;         4d+4*t22*t27*t4*t67+2.0773539676353528d+4*t19*t24*t4*t67+
     <         1.012844416076799d+2*t22*t24*t6*t66-1.012844416076799d+2*
     =         t19*t21*t6*t66+2.0773539676353528d+4*t22*t27*t4*t66-4.616
     >         342150300784d+4*t19*t24*t4*t66+1.1141288576844789d+2*t19*
     ?         t21*t6*t65+2.5389881826654315d+4*t19*t24*t4*t65+3.0467858
     @         19198518d+4*t109*t17*t4*t65)-9.305257363491002d-1*t12*t4*
     1         t51*(-1.1141288576844789d+2*t17*t52*t6*t89+2.538988182665
     2         4315d+4*t21*t4*t53*t89-5.585774001863949d+4*t21*t4*t52*t8
     3         9+1.0128444160767991d+1*t48*t6*t62-1.0128444160767991d+1*
     4         t16*t46*t6*t62-4.6163421503007845d+2*t4*t46*t62+4.6163421
     5         503007845d+2*t16*t4*t43*t62+2.0256888321535982d+1*t16*t46
     6         *t6*t61-2.0256888321535982d+1*t43*t45*t6*t61+4.6163421503
     7         007845d+2*t4*t46*t61+1.3849026450902355d+3*t4*t40*t45*t61
     8         -1.846536860120314d+3*t16*t4*t43*t61+3.038533248230397d+1
     9         *t43*t45*t6*t60-3.038533248230397d+1*t40*t42*t6*t60-4.154
     :         7079352707067d+3*t4*t40*t45*t60+1.3849026450902355d+3*t16
     ;         *t4*t43*t60+2.769805290180471d+3*t37*t4*t42*t60+4.0513776
     <         643071964d+1*t40*t42*t59*t6-4.0513776643071964d+1*t37*t39
     =         *t59*t6+5.064222080383994d+1*t37*t39*t58*t6-5.06422208038
     >         3994d+1*t34*t36*t58*t6+6.077066496460795d+1*t34*t36*t57*t
     ?         6-6.077066496460795d+1*t31*t33*t57*t6+7.089910912537593d+
     @         1*t31*t33*t56*t6-7.089910912537593d+1*t28*t30*t56*t6+8.10
     1         2755328614393d+1*t28*t30*t55*t6-8.102755328614393d+1*t25*
     2         t27*t55*t6+9.115599744691191d+1*t25*t27*t54*t6-9.11559974
     3         4691191d+1*t22*t24*t54*t6+1.012844416076799d+2*t22*t24*t5
     4         3*t6-1.012844416076799d+2*t19*t21*t53*t6+1.11412885768447
     5         89d+2*t19*t21*t52*t6+2.769805290180471d+3*t4*t40*t45*t59-
     6         7.386147440481255d+3*t37*t4*t42*t59+4.616342150300784d+3*
     7         t34*t39*t4*t59+4.616342150300784d+3*t37*t4*t42*t58-1.1540
     8         85537575196d+4*t34*t39*t4*t58+6.924513225451178d+3*t31*t3
     9         6*t4*t58+6.924513225451178d+3*t34*t39*t4*t57-1.6618831741
     :         08283d+4*t31*t36*t4*t57+9.694318515631648d+3*t28*t33*t4*t
     ;         57+9.694318515631648d+3*t31*t36*t4*t56-2.2620076536473846
     <         d+4*t28*t33*t4*t56+1.2925758020842196d+4*t25*t30*t4*t56+1
     =         .2925758020842196d+4*t28*t33*t4*t55-2.954458976192502d+4*
     >         t25*t30*t4*t55+1.6618831741082823d+4*t22*t27*t4*t55+1.661
     ?         8831741082823d+4*t25*t30*t4*t54-3.7392371417436354d+4*t22
     @         *t27*t4*t54+2.0773539676353528d+4*t19*t24*t4*t54+2.077353
     1         9676353528d+4*t22*t27*t4*t53-4.616342150300784d+4*t19*t24
     2         *t4*t53+2.5389881826654315d+4*t19*t24*t4*t52+3.0467858191
     3         98518d+4*t109*t17*t4*t52)-9.305257363491002d-1*t12*t3*t4*
     4         (-1.1141288576844789d+2*t13*t17*t6*t89+2.5389881826654315
     5         d+4*t20*t21*t4*t89-5.585774001863949d+4*t13*t21*t4*t89+1.
     6         0128444160767991d+1*t47*t48*t6-1.0128444160767991d+1*t16*
     7         t46*t47*t6+2.0256888321535982d+1*t16*t44*t46*t6-2.0256888
     8         321535982d+1*t43*t44*t45*t6+3.038533248230397d+1*t41*t43*
     9         t45*t6-3.038533248230397d+1*t40*t41*t42*t6+4.051377664307
     :         1964d+1*t38*t40*t42*t6-4.0513776643071964d+1*t37*t38*t39*
     ;         t6+5.064222080383994d+1*t35*t37*t39*t6-5.064222080383994d
     <         +1*t34*t35*t36*t6+6.077066496460795d+1*t32*t34*t36*t6-6.0
     =         77066496460795d+1*t31*t32*t33*t6+7.089910912537593d+1*t29
     >         *t31*t33*t6-7.089910912537593d+1*t28*t29*t30*t6+8.1027553
     ?         28614393d+1*t26*t28*t30*t6-8.102755328614393d+1*t25*t26*t
     @         27*t6+9.115599744691191d+1*t23*t25*t27*t6-9.1155997446911
     1         91d+1*t22*t23*t24*t6+1.012844416076799d+2*t20*t22*t24*t6-
     2         1.012844416076799d+2*t19*t20*t21*t6+1.1141288576844789d+2
     3         *t13*t19*t21*t6-4.6163421503007845d+2*t4*t46*t47+4.616342
     4         1503007845d+2*t16*t4*t43*t47+4.6163421503007845d+2*t4*t44
     5         *t46+1.3849026450902355d+3*t4*t40*t44*t45-4.1547079352707
     6         067d+3*t4*t40*t41*t45+2.769805290180471d+3*t38*t4*t40*t45
     7         -1.846536860120314d+3*t16*t4*t43*t44+1.3849026450902355d+
     8         3*t16*t4*t41*t43+2.769805290180471d+3*t37*t4*t41*t42-7.38
     9         6147440481255d+3*t37*t38*t4*t42+4.616342150300784d+3*t35*
     :         t37*t4*t42+4.616342150300784d+3*t34*t38*t39*t4-1.15408553
     ;         7575196d+4*t34*t35*t39*t4+6.924513225451178d+3*t32*t34*t3
     <         9*t4+6.924513225451178d+3*t31*t35*t36*t4-1.66188317410828
     =         3d+4*t31*t32*t36*t4+9.694318515631648d+3*t29*t31*t36*t4+9
     >         .694318515631648d+3*t28*t32*t33*t4-2.2620076536473846d+4*
     ?         t28*t29*t33*t4+1.2925758020842196d+4*t26*t28*t33*t4+1.292
     @         5758020842196d+4*t25*t29*t30*t4-2.954458976192502d+4*t25*
     1         t26*t30*t4+1.6618831741082823d+4*t23*t25*t30*t4+1.6618831
     2         741082823d+4*t22*t26*t27*t4-3.7392371417436354d+4*t22*t23
     3         *t27*t4+2.0773539676353528d+4*t20*t22*t27*t4+2.0773539676
     4         353528d+4*t19*t23*t24*t4-4.616342150300784d+4*t19*t20*t24
     5         *t4+2.5389881826654315d+4*t13*t19*t24*t4+3.04678581919851
     6         8d+4*t109*t13*t17*t4)+1.9863746096705204d-2*gammaaa*t117*
     7         t50*t64*t88-5.316678166471045d-5*t110*t116*t50*t64*t88+t1
     8         18*t51*t88-2.3079800683637772d-4*t110*t111*t116*t64*t76+t
     9         118*t3*t76+t100*(-4.135669939329334d-1*t12*t51*t63-4.1356
     :         69939329334d-1*t12*t3*t49)-2.4814019635976003d+0*t102*t5*
     ;         t51*t63-9.305257363491002d-1*t115*t4*t51*t63-5.0410164445
     <         33138d-3*gammaaa*t113*t12*t50*t63+4.947305865786653d-5*t1
     =         10*t112*t12*t50*t63-2.4814019635976003d+0*t102*t3*t49*t5-
     >         9.305257363491002d-1*t115*t3*t4*t49+2.1476348525932504d-4
     ?         *t110*t111*t112*t12*t49)*wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*((-3.361156316208638d-3*t12*t90
     1         -3.361156316208638d-3*t102*t49)*t94*t96+(-1.8903811666999
     2         27d-3*t12*t50*t91-1.890381166699927d-3*t102*t50*t63)*t96+
     3         4.481541754944851d-3*t12*t49*t94*t95+2.520508222266569d-3
     4         *t12*t50*t63*t95+t1*(3.612104625279974d-3*t64*t92+3.61210
     5         4625279974d-3*t104*t76)*t94-9.632279000746596d-3*t103*t64
     6         *t76*t94+t1*(2.0315194871630324d-3*t50*t64*t93+2.03151948
     7         71630324d-3*t104*t50*t88)+1.9937543124266421d-5*gammaaa*t
     8         120*t50*t64*t88-5.417385299101419d-3*t103*t50*t64*t88+8.6
     9         54925256364164d-5*gammaaa*t111*t120*t64*t76-1.85523969966
     :         9995d-5*gammaaa*t119*t12*t50*t63-8.05363069722469d-5*gamm
     ;         aaa*t111*t119*t12*t49)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(-7.476578671599909d-6*t122*t5
     1         0*t64*t88-3.245596971136562d-5*t111*t122*t64*t76+6.957148
     2         873762482d-6*t12*t121*t50*t63+3.020111511459258d-5*t111*t
     3         12*t121*t49)*wght+Cmat2(iq,D2_GAA_GAA)
            Mmat2(iq,D2_RA_TA) = 1.0d+0*(8.963083509889702d-3*gammaaa*t1
     1         05*t12*t94*t95+5.041016444533138d-3*gammaaa*t106*t12*t50*
     2         t95-9.632279000746596d-3*gammaaa*t103*t107*t64*t94+t51*t6
     3         4*(3.342386573053437d+3*t21*t78*t89*t9+6.077066496460795d
     4         +1*t16*t43*t87*t9-6.077066496460795d+1*t46*t86*t9+1.82311
     5         99489382385d+2*t40*t45*t86*t9-1.8231199489382385d+2*t16*t
     6         43*t85*t9+3.646239897876477d+2*t37*t42*t85*t9-3.646239897
     7         876477d+2*t40*t45*t84*t9+6.077066496460795d+2*t34*t39*t84
     8         *t9-6.077066496460795d+2*t37*t42*t83*t9+9.115599744691192
     9         d+2*t31*t36*t83*t9-9.115599744691192d+2*t34*t39*t82*t9+1.
     :         276183964256767d+3*t28*t33*t82*t9-1.276183964256767d+3*t3
     ;         1*t36*t81*t9+1.7015786190090226d+3*t25*t30*t81*t9-1.70157
     <         86190090226d+3*t28*t33*t80*t9+2.187743938725886d+3*t22*t2
     =         7*t80*t9-2.187743938725886d+3*t25*t30*t79*t9+2.7346799234
     >         07357d+3*t19*t24*t79*t9-2.734679923407357d+3*t22*t27*t78*
     ?         t9-3.342386573053437d+3*t19*t24*t77*t9+4.0108638876641245
     @         d+3*t109*t17*t77*t9)+t3*t64*(3.342386573053437d+3*t21*t66
     1         *t89*t9+6.077066496460795d+1*t16*t43*t75*t9-6.07706649646
     2         0795d+1*t46*t74*t9+1.8231199489382385d+2*t40*t45*t74*t9-1
     3         .8231199489382385d+2*t16*t43*t73*t9+3.646239897876477d+2*
     4         t37*t42*t73*t9-3.646239897876477d+2*t40*t45*t72*t9+6.0770
     5         66496460795d+2*t34*t39*t72*t9-6.077066496460795d+2*t37*t4
     6         2*t71*t9+9.115599744691192d+2*t31*t36*t71*t9-9.1155997446
     7         91192d+2*t34*t39*t70*t9+1.276183964256767d+3*t28*t33*t70*
     8         t9-1.276183964256767d+3*t31*t36*t69*t9+1.7015786190090226
     9         d+3*t25*t30*t69*t9-1.7015786190090226d+3*t28*t33*t68*t9+2
     :         .187743938725886d+3*t22*t27*t68*t9-2.187743938725886d+3*t
     ;         25*t30*t67*t9+2.734679923407357d+3*t19*t24*t67*t9-2.73467
     <         9923407357d+3*t22*t27*t66*t9-3.342386573053437d+3*t19*t24
     =         *t65*t9+4.0108638876641245d+3*t109*t17*t65*t9)-9.30525736
     >         3491002d-1*t12*t4*t51*(3.342386573053437d+3*t21*t53*t89*t
     ?         9+6.077066496460795d+1*t16*t43*t62*t9-6.077066496460795d+
     @         1*t46*t61*t9+1.8231199489382385d+2*t40*t45*t61*t9-1.82311
     1         99489382385d+2*t16*t43*t60*t9+3.646239897876477d+2*t37*t4
     2         2*t60*t9-3.646239897876477d+2*t40*t45*t59*t9+6.0770664964
     3         60795d+2*t34*t39*t59*t9-6.077066496460795d+2*t37*t42*t58*
     4         t9+9.115599744691192d+2*t31*t36*t58*t9-9.115599744691192d
     5         +2*t34*t39*t57*t9+1.276183964256767d+3*t28*t33*t57*t9-1.2
     6         76183964256767d+3*t31*t36*t56*t9+1.7015786190090226d+3*t2
     7         5*t30*t56*t9-1.7015786190090226d+3*t28*t33*t55*t9+2.18774
     8         3938725886d+3*t22*t27*t55*t9-2.187743938725886d+3*t25*t30
     9         *t54*t9+2.734679923407357d+3*t19*t24*t54*t9-2.73467992340
     :         7357d+3*t22*t27*t53*t9-3.342386573053437d+3*t19*t24*t52*t
     ;         9+4.0108638876641245d+3*t109*t17*t52*t9)-9.30525736349100
     <         2d-1*t12*t3*t4*(3.342386573053437d+3*t20*t21*t89*t9+6.077
     =         066496460795d+1*t16*t43*t47*t9-6.077066496460795d+1*t44*t
     >         46*t9+1.8231199489382385d+2*t40*t44*t45*t9-3.646239897876
     ?         477d+2*t38*t40*t45*t9-1.8231199489382385d+2*t16*t41*t43*t
     @         9+3.646239897876477d+2*t37*t41*t42*t9-6.077066496460795d+
     1         2*t35*t37*t42*t9+6.077066496460795d+2*t34*t38*t39*t9-9.11
     2         5599744691192d+2*t32*t34*t39*t9+9.115599744691192d+2*t31*
     3         t35*t36*t9-1.276183964256767d+3*t29*t31*t36*t9+1.27618396
     4         4256767d+3*t28*t32*t33*t9-1.7015786190090226d+3*t26*t28*t
     5         33*t9+1.7015786190090226d+3*t25*t29*t30*t9-2.187743938725
     6         886d+3*t23*t25*t30*t9+2.187743938725886d+3*t22*t26*t27*t9
     7         -2.734679923407357d+3*t20*t22*t27*t9+2.734679923407357d+3
     8         *t19*t23*t24*t9-3.342386573053437d+3*t13*t19*t24*t9+4.010
     9         8638876641245d+3*t109*t13*t17*t9)-5.417385299101419d-3*ga
     :         mmaaa*t103*t108*t50*t64-1.2407009817988002d+0*t106*t12*t5
     ;         *t51-9.305257363491002d-1*t102*t106*t4*t51+t104*t108*t51-
     <         1.2407009817988002d+0*t105*t12*t3*t5-9.305257363491002d-1
     =         *t102*t105*t3*t4+t104*t107*t3)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = 1.0d+0*(-3.361156316208638d-3*t105*t12
     1         *t94*t96-1.890381166699927d-3*t106*t12*t50*t96+3.61210462
     2         5279974d-3*t1*t107*t64*t94+2.0315194871630324d-3*t1*t108*
     3         t50*t64)*wght+Mmat2(iq,D2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_TA_TA) = 1.0d+0*(t51*t64*(4.4d+2*t21*t78*t89+9.6
     1         8d+2*t21*t77*t89+8.0d+0*t46*t87+8.0d+0*t16*t43*t87+8.0d+0
     2         *t46*t86+2.4d+1*t40*t45*t86+3.2d+1*t16*t43*t86+7.2d+1*t40
     3         *t45*t85+2.4d+1*t16*t43*t85+4.8d+1*t37*t42*t85+4.8d+1*t40
     4         *t45*t84+1.28d+2*t37*t42*t84+8.0d+1*t34*t39*t84+8.0d+1*t3
     5         7*t42*t83+2.0d+2*t34*t39*t83+1.2d+2*t31*t36*t83+1.2d+2*t3
     6         4*t39*t82+2.88d+2*t31*t36*t82+1.68d+2*t28*t33*t82+1.68d+2
     7         *t31*t36*t81+3.92d+2*t28*t33*t81+2.24d+2*t25*t30*t81+2.24
     8         d+2*t28*t33*t80+5.12d+2*t25*t30*t80+2.88d+2*t22*t27*t80+2
     9         .88d+2*t25*t30*t79+6.48d+2*t22*t27*t79+3.6d+2*t19*t24*t79
     :         +3.6d+2*t22*t27*t78+8.0d+2*t19*t24*t78+4.4d+2*t19*t24*t77
     ;         +5.28d+2*t109*t17*t77)+t3*t64*(4.4d+2*t21*t66*t89+9.68d+2
     <         *t21*t65*t89+8.0d+0*t46*t75+8.0d+0*t16*t43*t75+8.0d+0*t46
     =         *t74+2.4d+1*t40*t45*t74+3.2d+1*t16*t43*t74+7.2d+1*t40*t45
     >         *t73+2.4d+1*t16*t43*t73+4.8d+1*t37*t42*t73+4.8d+1*t40*t45
     ?         *t72+1.28d+2*t37*t42*t72+8.0d+1*t34*t39*t72+8.0d+1*t37*t4
     @         2*t71+2.0d+2*t34*t39*t71+1.2d+2*t31*t36*t71+1.2d+2*t34*t3
     1         9*t70+2.88d+2*t31*t36*t70+1.68d+2*t28*t33*t70+1.68d+2*t31
     2         *t36*t69+3.92d+2*t28*t33*t69+2.24d+2*t25*t30*t69+2.24d+2*
     3         t28*t33*t68+5.12d+2*t25*t30*t68+2.88d+2*t22*t27*t68+2.88d
     4         +2*t25*t30*t67+6.48d+2*t22*t27*t67+3.6d+2*t19*t24*t67+3.6
     5         d+2*t22*t27*t66+8.0d+2*t19*t24*t66+4.4d+2*t19*t24*t65+5.2
     6         8d+2*t109*t17*t65)-9.305257363491002d-1*t12*t4*t51*(4.4d+
     7         2*t21*t53*t89+9.68d+2*t21*t52*t89+8.0d+0*t46*t62+8.0d+0*t
     8         16*t43*t62+8.0d+0*t46*t61+2.4d+1*t40*t45*t61+3.2d+1*t16*t
     9         43*t61+7.2d+1*t40*t45*t60+2.4d+1*t16*t43*t60+4.8d+1*t37*t
     :         42*t60+4.8d+1*t40*t45*t59+1.28d+2*t37*t42*t59+8.0d+1*t34*
     ;         t39*t59+8.0d+1*t37*t42*t58+2.0d+2*t34*t39*t58+1.2d+2*t31*
     <         t36*t58+1.2d+2*t34*t39*t57+2.88d+2*t31*t36*t57+1.68d+2*t2
     =         8*t33*t57+1.68d+2*t31*t36*t56+3.92d+2*t28*t33*t56+2.24d+2
     >         *t25*t30*t56+2.24d+2*t28*t33*t55+5.12d+2*t25*t30*t55+2.88
     ?         d+2*t22*t27*t55+2.88d+2*t25*t30*t54+6.48d+2*t22*t27*t54+3
     @         .6d+2*t19*t24*t54+3.6d+2*t22*t27*t53+8.0d+2*t19*t24*t53+4
     1         .4d+2*t19*t24*t52+5.28d+2*t109*t17*t52)-9.305257363491002
     2         d-1*t12*t3*t4*(4.4d+2*t20*t21*t89+9.68d+2*t13*t21*t89+8.0
     3         d+0*t46*t47+8.0d+0*t16*t43*t47+8.0d+0*t44*t46+2.4d+1*t40*
     4         t44*t45+7.2d+1*t40*t41*t45+4.8d+1*t38*t40*t45+3.2d+1*t16*
     5         t43*t44+2.4d+1*t16*t41*t43+4.8d+1*t37*t41*t42+1.28d+2*t37
     6         *t38*t42+8.0d+1*t35*t37*t42+8.0d+1*t34*t38*t39+2.0d+2*t34
     7         *t35*t39+1.2d+2*t32*t34*t39+1.2d+2*t31*t35*t36+2.88d+2*t3
     8         1*t32*t36+1.68d+2*t29*t31*t36+1.68d+2*t28*t32*t33+3.92d+2
     9         *t28*t29*t33+2.24d+2*t26*t28*t33+2.24d+2*t25*t29*t30+5.12
     :         d+2*t25*t26*t30+2.88d+2*t23*t25*t30+2.88d+2*t22*t26*t27+6
     ;         .48d+2*t22*t23*t27+3.6d+2*t20*t22*t27+3.6d+2*t19*t23*t24+
     <         8.0d+2*t19*t20*t24+4.4d+2*t13*t19*t24+5.28d+2*t109*t13*t1
     =         7))*wght+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhob**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammabb*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhob**1.3333333333333333d+0
            t5 = rhob**3.333333333333333d-1
            t6 = 1/t5
            t7 = 1/rhob
            t8 = 1.282782438530422d-1*t6-2.63857249068588d-4*t7
            t9 = rhob**6.666666666666666d-1
            t10 = exp(-2.4308265985843178d+2*t9)
            t11 = t10*t8+2.63857249068588d-4*t7-1.924173657795633d-1*t6+
     1         3.544907701811032d+0*erf(1.5591108358883013d+1*t5)
            t12 = 1.0d+0-4.275941461768073d-2*t11*t6
            t13 = param(12)
            t14 = rhob**1.6666666666666669d+0
            t15 = 9.115599744691192d+0*t14
            t16 = t15-2.0d+0*taub
            t17 = t16**11
            t18 = 2.0d+0*taub+t15
            t19 = 1/t18**11
            t20 = param(11)
            t21 = t16**10
            t22 = 1/t18**10
            t23 = param(10)
            t24 = t16**9
            t25 = 1/t18**9
            t26 = param(9)
            t27 = t16**8
            t28 = 1/t18**8
            t29 = param(8)
            t30 = t16**7
            t31 = 1/t18**7
            t32 = param(7)
            t33 = t16**6
            t34 = 1/t18**6
            t35 = param(6)
            t36 = t16**5
            t37 = 1/t18**5
            t38 = param(5)
            t39 = t16**4
            t40 = 1/t18**4
            t41 = param(4)
            t42 = t16**3
            t43 = 1/t18**3
            t44 = param(3)
            t45 = t16**2
            t46 = 1/t18**2
            t47 = param(2)
            t48 = 1/t18
            t49 = t16*t47*t48+t44*t45*t46+t41*t42*t43+t38*t39*t40+t35*t3
     1         6*t37+t32*t33*t34+t29*t30*t31+t26*t27*t28+t23*t24*t25+t20
     2         *t21*t22+t13*t17*t19+param(1)
            t50 = exp(-3.6802889260199856d-3*gammabb*t1)
            t51 = 5.52d-1*(1.0d+0-t50)+1.0d+0
            t52 = param(24)
            t53 = param(23)
            t54 = param(22)
            t55 = param(21)
            t56 = param(20)
            t57 = param(19)
            t58 = param(18)
            t59 = param(17)
            t60 = param(16)
            t61 = param(15)
            t62 = param(14)
            t63 = t16*t48*t62+t45*t46*t61+t42*t43*t60+t39*t40*t59+t36*t3
     1         7*t58+t33*t34*t57+t30*t31*t56+t27*t28*t55+t24*t25*t54+t21
     2         *t22*t53+t17*t19*t52+param(13)
            t64 = 9.305257363491002d-1*t12*t4-9.305257363491002d-1*t4
            t65 = param(36)
            t66 = param(35)
            t67 = param(34)
            t68 = param(33)
            t69 = param(32)
            t70 = param(31)
            t71 = param(30)
            t72 = param(29)
            t73 = param(28)
            t74 = param(27)
            t75 = param(26)
            t76 = t16*t48*t75+t45*t46*t74+t42*t43*t73+t39*t40*t72+t36*t3
     1         7*t71+t33*t34*t70+t30*t31*t69+t27*t28*t68+t24*t25*t67+t21
     2         *t22*t66+t17*t19*t65+param(25)
            t77 = param(48)
            t78 = param(47)
            t79 = param(46)
            t80 = param(45)
            t81 = param(44)
            t82 = param(43)
            t83 = param(42)
            t84 = param(41)
            t85 = param(40)
            t86 = param(39)
            t87 = param(38)
            t88 = t16*t48*t87+t45*t46*t86+t42*t43*t85+t39*t40*t84+t36*t3
     1         7*t83+t33*t34*t82+t30*t31*t81+t27*t28*t80+t24*t25*t79+t21
     2         *t22*t78+t17*t19*t77+param(37)
            t89 = 1/t18**12
            t90 = -1.6711932865267184d+2*t13*t17*t89*t9+1.51926662411519
     1         86d+1*t47*t48*t9-1.5192666241151986d+1*t16*t46*t47*t9+3.0
     2         38533248230397d+1*t16*t44*t46*t9-3.038533248230397d+1*t43
     3         *t44*t45*t9+4.5577998723455965d+1*t41*t43*t45*t9-4.557799
     4         8723455965d+1*t40*t41*t42*t9+6.077066496460795d+1*t38*t40
     5         *t42*t9-6.077066496460795d+1*t37*t38*t39*t9+7.59633312057
     6         5993d+1*t35*t37*t39*t9-7.596333120575993d+1*t34*t35*t36*t
     7         9+9.115599744691193d+1*t32*t34*t36*t9-9.115599744691193d+
     8         1*t31*t32*t33*t9+1.0634866368806391d+2*t29*t31*t33*t9-1.0
     9         634866368806391d+2*t28*t29*t30*t9+1.2154132992921589d+2*t
     :         26*t28*t30*t9-1.2154132992921589d+2*t25*t26*t27*t9+1.3673
     ;         399617036788d+2*t23*t25*t27*t9-1.3673399617036788d+2*t22*
     <         t23*t24*t9+1.5192666241151986d+2*t20*t22*t24*t9-1.5192666
     =         241151986d+2*t19*t20*t21*t9+1.6711932865267184d+2*t13*t19
     >         *t21*t9
            t91 = -1.6711932865267184d+2*t17*t52*t89*t9+1.51926662411519
     1         86d+1*t48*t62*t9-1.5192666241151986d+1*t16*t46*t62*t9+3.0
     2         38533248230397d+1*t16*t46*t61*t9-3.038533248230397d+1*t43
     3         *t45*t61*t9+4.5577998723455965d+1*t43*t45*t60*t9-4.557799
     4         8723455965d+1*t40*t42*t60*t9+6.077066496460795d+1*t40*t42
     5         *t59*t9-6.077066496460795d+1*t37*t39*t59*t9+7.59633312057
     6         5993d+1*t37*t39*t58*t9-7.596333120575993d+1*t34*t36*t58*t
     7         9+9.115599744691193d+1*t34*t36*t57*t9-9.115599744691193d+
     8         1*t31*t33*t57*t9+1.0634866368806391d+2*t31*t33*t56*t9-1.0
     9         634866368806391d+2*t28*t30*t56*t9+1.2154132992921589d+2*t
     :         28*t30*t55*t9-1.2154132992921589d+2*t25*t27*t55*t9+1.3673
     ;         399617036788d+2*t25*t27*t54*t9-1.3673399617036788d+2*t22*
     <         t24*t54*t9+1.5192666241151986d+2*t22*t24*t53*t9-1.5192666
     =         241151986d+2*t19*t21*t53*t9+1.6711932865267184d+2*t19*t21
     >         *t52*t9
            t92 = -1.6711932865267184d+2*t17*t65*t89*t9+1.51926662411519
     1         86d+1*t48*t75*t9-1.5192666241151986d+1*t16*t46*t75*t9+3.0
     2         38533248230397d+1*t16*t46*t74*t9-3.038533248230397d+1*t43
     3         *t45*t74*t9+4.5577998723455965d+1*t43*t45*t73*t9-4.557799
     4         8723455965d+1*t40*t42*t73*t9+6.077066496460795d+1*t40*t42
     5         *t72*t9-6.077066496460795d+1*t37*t39*t72*t9+7.59633312057
     6         5993d+1*t37*t39*t71*t9-7.596333120575993d+1*t34*t36*t71*t
     7         9+9.115599744691193d+1*t34*t36*t70*t9-9.115599744691193d+
     8         1*t31*t33*t70*t9+1.0634866368806391d+2*t31*t33*t69*t9-1.0
     9         634866368806391d+2*t28*t30*t69*t9+1.2154132992921589d+2*t
     :         28*t30*t68*t9-1.2154132992921589d+2*t25*t27*t68*t9+1.3673
     ;         399617036788d+2*t25*t27*t67*t9-1.3673399617036788d+2*t22*
     <         t24*t67*t9+1.5192666241151986d+2*t22*t24*t66*t9-1.5192666
     =         241151986d+2*t19*t21*t66*t9+1.6711932865267184d+2*t19*t21
     >         *t65*t9
            t93 = -1.6711932865267184d+2*t17*t77*t89*t9+1.51926662411519
     1         86d+1*t48*t87*t9-1.5192666241151986d+1*t16*t46*t87*t9+3.0
     2         38533248230397d+1*t16*t46*t86*t9-3.038533248230397d+1*t43
     3         *t45*t86*t9+4.5577998723455965d+1*t43*t45*t85*t9-4.557799
     4         8723455965d+1*t40*t42*t85*t9+6.077066496460795d+1*t40*t42
     5         *t84*t9-6.077066496460795d+1*t37*t39*t84*t9+7.59633312057
     6         5993d+1*t37*t39*t83*t9-7.596333120575993d+1*t34*t36*t83*t
     7         9+9.115599744691193d+1*t34*t36*t82*t9-9.115599744691193d+
     8         1*t31*t33*t82*t9+1.0634866368806391d+2*t31*t33*t81*t9-1.0
     9         634866368806391d+2*t28*t30*t81*t9+1.2154132992921589d+2*t
     :         28*t30*t80*t9-1.2154132992921589d+2*t25*t27*t80*t9+1.3673
     ;         399617036788d+2*t25*t27*t79*t9-1.3673399617036788d+2*t22*
     <         t24*t79*t9+1.5192666241151986d+2*t22*t24*t78*t9-1.5192666
     =         241151986d+2*t19*t21*t78*t9+1.6711932865267184d+2*t19*t21
     >         *t77*t9
            t94 = 1/t2**2
            t95 = 1/rhob**2.3333333333333334d+0
            t96 = 1/t4
            t97 = 1/rhob**2
            t98 = 2.63857249068588d-4*t97-4.2759414617680735d-2*t96
            t99 = 5.641895835477563d-1
            t100 = 1/t9
            t101 = 3.6846026734116505d+1*t10*t100*t99+t10*t98-2.63857249
     1         068588d-4*t97+6.41391219265211d-2*t96-1.6205510657228786d
     2         +2*t10*t6*t8
            t102 = 1.4253138205893576d-2*t11*t96-4.275941461768073d-2*t1
     1         01*t6
            t103 = 1/rhob**3.6666666666666664d+0
            t104 = 1.2407009817988002d+0*t12*t5-1.2407009817988002d+0*t5
     1         +9.305257363491002d-1*t102*t4
            t105 = -2.2d+1*t13*t17*t89-2.0d+0*t47*t48-2.0d+0*t16*t46*t47
     1         -4.0d+0*t16*t44*t46-4.0d+0*t43*t44*t45-6.0d+0*t41*t43*t45
     2         -6.0d+0*t40*t41*t42-8.0d+0*t38*t40*t42-8.0d+0*t37*t38*t39
     3         -1.0d+1*t35*t37*t39-1.0d+1*t34*t35*t36-1.2d+1*t32*t34*t36
     4         -1.2d+1*t31*t32*t33-1.4d+1*t29*t31*t33-1.4d+1*t28*t29*t30
     5         -1.6d+1*t26*t28*t30-1.6d+1*t25*t26*t27-1.8d+1*t23*t25*t27
     6         -1.8d+1*t22*t23*t24-2.0d+1*t20*t22*t24-2.0d+1*t19*t20*t21
     7         -2.2d+1*t13*t19*t21
            t106 = -2.2d+1*t17*t52*t89-2.0d+0*t48*t62-2.0d+0*t16*t46*t62
     1         -4.0d+0*t16*t46*t61-4.0d+0*t43*t45*t61-6.0d+0*t43*t45*t60
     2         -6.0d+0*t40*t42*t60-8.0d+0*t40*t42*t59-8.0d+0*t37*t39*t59
     3         -1.0d+1*t37*t39*t58-1.0d+1*t34*t36*t58-1.2d+1*t34*t36*t57
     4         -1.2d+1*t31*t33*t57-1.4d+1*t31*t33*t56-1.4d+1*t28*t30*t56
     5         -1.6d+1*t28*t30*t55-1.6d+1*t25*t27*t55-1.8d+1*t25*t27*t54
     6         -1.8d+1*t22*t24*t54-2.0d+1*t22*t24*t53-2.0d+1*t19*t21*t53
     7         -2.2d+1*t19*t21*t52
            t107 = -2.2d+1*t17*t65*t89-2.0d+0*t48*t75-2.0d+0*t16*t46*t75
     1         -4.0d+0*t16*t46*t74-4.0d+0*t43*t45*t74-6.0d+0*t43*t45*t73
     2         -6.0d+0*t40*t42*t73-8.0d+0*t40*t42*t72-8.0d+0*t37*t39*t72
     3         -1.0d+1*t37*t39*t71-1.0d+1*t34*t36*t71-1.2d+1*t34*t36*t70
     4         -1.2d+1*t31*t33*t70-1.4d+1*t31*t33*t69-1.4d+1*t28*t30*t69
     5         -1.6d+1*t28*t30*t68-1.6d+1*t25*t27*t68-1.8d+1*t25*t27*t67
     6         -1.8d+1*t22*t24*t67-2.0d+1*t22*t24*t66-2.0d+1*t19*t21*t66
     7         -2.2d+1*t19*t21*t65
            t108 = -2.2d+1*t17*t77*t89-2.0d+0*t48*t87-2.0d+0*t16*t46*t87
     1         -4.0d+0*t16*t46*t86-4.0d+0*t43*t45*t86-6.0d+0*t43*t45*t85
     2         -6.0d+0*t40*t42*t85-8.0d+0*t40*t42*t84-8.0d+0*t37*t39*t84
     3         -1.0d+1*t37*t39*t83-1.0d+1*t34*t36*t83-1.2d+1*t34*t36*t82
     4         -1.2d+1*t31*t33*t82-1.4d+1*t31*t33*t81-1.4d+1*t28*t30*t81
     5         -1.6d+1*t28*t30*t80-1.6d+1*t25*t27*t80-1.8d+1*t25*t27*t79
     6         -1.8d+1*t22*t24*t79-2.0d+1*t22*t24*t78-2.0d+1*t19*t21*t78
     7         -2.2d+1*t19*t21*t77
            t109 = 1/t18**13
            t110 = gammabb**2
            t111 = 1/t2**3
            t112 = 1/rhob**6
            t113 = 1/rhob**3.3333333333333337d+0
            t114 = 1/rhob**3
            t115 = -4.275941461768073d-2*t6*(-5.971086789162617d+3*t10*t
     1         7*t99-2.4564017822744336d+1*t10*t99/t14-3.241102131445757
     2         d+2*t10*t6*t98+5.401836885742928d+1*t10*t8*t96-8.55188292
     3         3536147d-2*t95+t10*(5.701255282357431d-2*t95-5.2771449813
     4         7176d-4*t114)+2.626185756615557d+4*t10*t100*t8+5.27714498
     5         137176d-4*t114)+2.850627641178715d-2*t101*t96-1.900418427
     6         4524766d-2*t11*t95
            t116 = 1/rhob**7.333333333333333d+0
            t117 = 1/rhob**4.666666666666667d+0
            t118 = 2.4814019635976003d+0*t102*t5+9.305257363491002d-1*t1
     1         15*t4+4.135669939329334d-1*t100*t12-4.135669939329334d-1*
     2         t100
            t119 = 1/rhob**5
            t120 = 1/rhob**6.333333333333333d+0
            t121 = 1/rhob**4
            t122 = 1/rhob**5.333333333333333d+0
            fnc(iq) = 1.0d+0*(t51*t64*t88+t3*t64*t76-9.305257363491002d-
     1         1*t12*t4*t51*t63-9.305257363491002d-1*t12*t3*t4*t49)*wght
     2         +fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*(8.963083509889702d-3*gammabb*t12*t4
     1         9*t94*t95+5.041016444533138d-3*gammabb*t12*t50*t63*t95-9.
     2         632279000746596d-3*gammabb*t103*t64*t76*t94+t51*t64*t93+t
     3         3*t64*t92-9.305257363491002d-1*t12*t4*t51*t91-9.305257363
     4         491002d-1*t12*t3*t4*t90-5.417385299101419d-3*gammabb*t103
     5         *t50*t64*t88+t104*t51*t88+t104*t3*t76-1.2407009817988002d
     6         +0*t12*t5*t51*t63-9.305257363491002d-1*t102*t4*t51*t63-1.
     7         2407009817988002d+0*t12*t3*t49*t5-9.305257363491002d-1*t1
     8         02*t3*t4*t49)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*(-3.361156316208638d-3*t12*t49*t94*
     1         t96-1.890381166699927d-3*t12*t50*t63*t96+3.61210462527997
     2         4d-3*t1*t64*t76*t94+2.0315194871630324d-3*t1*t50*t64*t88)
     3         *wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TB) = 1.0d+0*(t108*t51*t64+t107*t3*t64-9.30525736
     1         3491002d-1*t106*t12*t4*t51-9.305257363491002d-1*t105*t12*
     2         t3*t4)*wght+Mmat(iq,D1_TB)
            Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            Amat2(iq,D2_RB_RB) = 1.0d+0*((1.7926167019779404d-2*gammabb*
     1         t12*t90+1.7926167019779404d-2*gammabb*t102*t49)*t94*t95+(
     2         1.0082032889066277d-2*gammabb*t12*t50*t91+1.0082032889066
     3         277d-2*gammabb*t102*t50*t63)*t95+t103*(-1.926455800149319
     4         3d-2*gammabb*t64*t92-1.9264558001493193d-2*gammabb*t104*t
     5         76)*t94+3.5318356336070855d-2*gammabb*t117*t64*t76*t94-8.
     6         963083509889707d-3*gammabb*t113*t12*t49*t94+t103*(-1.0834
     7         770598202839d-2*gammabb*t50*t64*t93-1.0834770598202839d-2
     8         *gammabb*t104*t50*t88)+2*t104*t51*t93+2*t104*t3*t92-2.481
     9         4019635976003d+0*t12*t5*t51*t91-1.8610514726982003d+0*t10
     :         2*t4*t51*t91-2.4814019635976003d+0*t12*t3*t5*t90-1.861051
     ;         4726982003d+0*t102*t3*t4*t90+t51*t64*(2.5389881826654315d
     <         +4*t21*t4*t78*t89-1.1141288576844789d+2*t17*t6*t77*t89-5.
     =         585774001863949d+4*t21*t4*t77*t89+1.0128444160767991d+1*t
     >         48*t6*t87-1.0128444160767991d+1*t16*t46*t6*t87-4.61634215
     ?         03007845d+2*t4*t46*t87+4.6163421503007845d+2*t16*t4*t43*t
     @         87+2.0256888321535982d+1*t16*t46*t6*t86-2.025688832153598
     1         2d+1*t43*t45*t6*t86+4.6163421503007845d+2*t4*t46*t86+1.38
     2         49026450902355d+3*t4*t40*t45*t86-1.846536860120314d+3*t16
     3         *t4*t43*t86+3.038533248230397d+1*t43*t45*t6*t85-3.0385332
     4         48230397d+1*t40*t42*t6*t85-4.1547079352707067d+3*t4*t40*t
     5         45*t85+1.3849026450902355d+3*t16*t4*t43*t85+2.76980529018
     6         0471d+3*t37*t4*t42*t85+4.0513776643071964d+1*t40*t42*t6*t
     7         84-4.0513776643071964d+1*t37*t39*t6*t84+2.769805290180471
     8         d+3*t4*t40*t45*t84-7.386147440481255d+3*t37*t4*t42*t84+4.
     9         616342150300784d+3*t34*t39*t4*t84+5.064222080383994d+1*t3
     :         7*t39*t6*t83-5.064222080383994d+1*t34*t36*t6*t83+4.616342
     ;         150300784d+3*t37*t4*t42*t83-1.154085537575196d+4*t34*t39*
     <         t4*t83+6.924513225451178d+3*t31*t36*t4*t83+6.077066496460
     =         795d+1*t34*t36*t6*t82-6.077066496460795d+1*t31*t33*t6*t82
     >         +6.924513225451178d+3*t34*t39*t4*t82-1.661883174108283d+4
     ?         *t31*t36*t4*t82+9.694318515631648d+3*t28*t33*t4*t82+7.089
     @         910912537593d+1*t31*t33*t6*t81-7.089910912537593d+1*t28*t
     1         30*t6*t81+9.694318515631648d+3*t31*t36*t4*t81-2.262007653
     2         6473846d+4*t28*t33*t4*t81+1.2925758020842196d+4*t25*t30*t
     3         4*t81+8.102755328614393d+1*t28*t30*t6*t80-8.1027553286143
     4         93d+1*t25*t27*t6*t80+1.2925758020842196d+4*t28*t33*t4*t80
     5         -2.954458976192502d+4*t25*t30*t4*t80+1.6618831741082823d+
     6         4*t22*t27*t4*t80+9.115599744691191d+1*t25*t27*t6*t79-9.11
     7         5599744691191d+1*t22*t24*t6*t79+1.6618831741082823d+4*t25
     8         *t30*t4*t79-3.7392371417436354d+4*t22*t27*t4*t79+2.077353
     9         9676353528d+4*t19*t24*t4*t79+1.012844416076799d+2*t22*t24
     :         *t6*t78-1.012844416076799d+2*t19*t21*t6*t78+2.07735396763
     ;         53528d+4*t22*t27*t4*t78-4.616342150300784d+4*t19*t24*t4*t
     <         78+1.1141288576844789d+2*t19*t21*t6*t77+2.538988182665431
     =         5d+4*t19*t24*t4*t77+3.046785819198518d+4*t109*t17*t4*t77)
     >         +t3*t64*(2.5389881826654315d+4*t21*t4*t66*t89-1.114128857
     ?         6844789d+2*t17*t6*t65*t89-5.585774001863949d+4*t21*t4*t65
     @         *t89+1.0128444160767991d+1*t48*t6*t75-1.0128444160767991d
     1         +1*t16*t46*t6*t75-4.6163421503007845d+2*t4*t46*t75+4.6163
     2         421503007845d+2*t16*t4*t43*t75+2.0256888321535982d+1*t16*
     3         t46*t6*t74-2.0256888321535982d+1*t43*t45*t6*t74+4.6163421
     4         503007845d+2*t4*t46*t74+1.3849026450902355d+3*t4*t40*t45*
     5         t74-1.846536860120314d+3*t16*t4*t43*t74+3.038533248230397
     6         d+1*t43*t45*t6*t73-3.038533248230397d+1*t40*t42*t6*t73-4.
     7         1547079352707067d+3*t4*t40*t45*t73+1.3849026450902355d+3*
     8         t16*t4*t43*t73+2.769805290180471d+3*t37*t4*t42*t73+4.0513
     9         776643071964d+1*t40*t42*t6*t72-4.0513776643071964d+1*t37*
     :         t39*t6*t72+2.769805290180471d+3*t4*t40*t45*t72-7.38614744
     ;         0481255d+3*t37*t4*t42*t72+4.616342150300784d+3*t34*t39*t4
     <         *t72+5.064222080383994d+1*t37*t39*t6*t71-5.06422208038399
     =         4d+1*t34*t36*t6*t71+4.616342150300784d+3*t37*t4*t42*t71-1
     >         .154085537575196d+4*t34*t39*t4*t71+6.924513225451178d+3*t
     ?         31*t36*t4*t71+6.077066496460795d+1*t34*t36*t6*t70-6.07706
     @         6496460795d+1*t31*t33*t6*t70+6.924513225451178d+3*t34*t39
     1         *t4*t70-1.661883174108283d+4*t31*t36*t4*t70+9.69431851563
     2         1648d+3*t28*t33*t4*t70+7.089910912537593d+1*t31*t33*t6*t6
     3         9-7.089910912537593d+1*t28*t30*t6*t69+9.694318515631648d+
     4         3*t31*t36*t4*t69-2.2620076536473846d+4*t28*t33*t4*t69+1.2
     5         925758020842196d+4*t25*t30*t4*t69+8.102755328614393d+1*t2
     6         8*t30*t6*t68-8.102755328614393d+1*t25*t27*t6*t68+1.292575
     7         8020842196d+4*t28*t33*t4*t68-2.954458976192502d+4*t25*t30
     8         *t4*t68+1.6618831741082823d+4*t22*t27*t4*t68+9.1155997446
     9         91191d+1*t25*t27*t6*t67-9.115599744691191d+1*t22*t24*t6*t
     :         67+1.6618831741082823d+4*t25*t30*t4*t67-3.739237141743635
     ;         4d+4*t22*t27*t4*t67+2.0773539676353528d+4*t19*t24*t4*t67+
     <         1.012844416076799d+2*t22*t24*t6*t66-1.012844416076799d+2*
     =         t19*t21*t6*t66+2.0773539676353528d+4*t22*t27*t4*t66-4.616
     >         342150300784d+4*t19*t24*t4*t66+1.1141288576844789d+2*t19*
     ?         t21*t6*t65+2.5389881826654315d+4*t19*t24*t4*t65+3.0467858
     @         19198518d+4*t109*t17*t4*t65)-9.305257363491002d-1*t12*t4*
     1         t51*(-1.1141288576844789d+2*t17*t52*t6*t89+2.538988182665
     2         4315d+4*t21*t4*t53*t89-5.585774001863949d+4*t21*t4*t52*t8
     3         9+1.0128444160767991d+1*t48*t6*t62-1.0128444160767991d+1*
     4         t16*t46*t6*t62-4.6163421503007845d+2*t4*t46*t62+4.6163421
     5         503007845d+2*t16*t4*t43*t62+2.0256888321535982d+1*t16*t46
     6         *t6*t61-2.0256888321535982d+1*t43*t45*t6*t61+4.6163421503
     7         007845d+2*t4*t46*t61+1.3849026450902355d+3*t4*t40*t45*t61
     8         -1.846536860120314d+3*t16*t4*t43*t61+3.038533248230397d+1
     9         *t43*t45*t6*t60-3.038533248230397d+1*t40*t42*t6*t60-4.154
     :         7079352707067d+3*t4*t40*t45*t60+1.3849026450902355d+3*t16
     ;         *t4*t43*t60+2.769805290180471d+3*t37*t4*t42*t60+4.0513776
     <         643071964d+1*t40*t42*t59*t6-4.0513776643071964d+1*t37*t39
     =         *t59*t6+5.064222080383994d+1*t37*t39*t58*t6-5.06422208038
     >         3994d+1*t34*t36*t58*t6+6.077066496460795d+1*t34*t36*t57*t
     ?         6-6.077066496460795d+1*t31*t33*t57*t6+7.089910912537593d+
     @         1*t31*t33*t56*t6-7.089910912537593d+1*t28*t30*t56*t6+8.10
     1         2755328614393d+1*t28*t30*t55*t6-8.102755328614393d+1*t25*
     2         t27*t55*t6+9.115599744691191d+1*t25*t27*t54*t6-9.11559974
     3         4691191d+1*t22*t24*t54*t6+1.012844416076799d+2*t22*t24*t5
     4         3*t6-1.012844416076799d+2*t19*t21*t53*t6+1.11412885768447
     5         89d+2*t19*t21*t52*t6+2.769805290180471d+3*t4*t40*t45*t59-
     6         7.386147440481255d+3*t37*t4*t42*t59+4.616342150300784d+3*
     7         t34*t39*t4*t59+4.616342150300784d+3*t37*t4*t42*t58-1.1540
     8         85537575196d+4*t34*t39*t4*t58+6.924513225451178d+3*t31*t3
     9         6*t4*t58+6.924513225451178d+3*t34*t39*t4*t57-1.6618831741
     :         08283d+4*t31*t36*t4*t57+9.694318515631648d+3*t28*t33*t4*t
     ;         57+9.694318515631648d+3*t31*t36*t4*t56-2.2620076536473846
     <         d+4*t28*t33*t4*t56+1.2925758020842196d+4*t25*t30*t4*t56+1
     =         .2925758020842196d+4*t28*t33*t4*t55-2.954458976192502d+4*
     >         t25*t30*t4*t55+1.6618831741082823d+4*t22*t27*t4*t55+1.661
     ?         8831741082823d+4*t25*t30*t4*t54-3.7392371417436354d+4*t22
     @         *t27*t4*t54+2.0773539676353528d+4*t19*t24*t4*t54+2.077353
     1         9676353528d+4*t22*t27*t4*t53-4.616342150300784d+4*t19*t24
     2         *t4*t53+2.5389881826654315d+4*t19*t24*t4*t52+3.0467858191
     3         98518d+4*t109*t17*t4*t52)-9.305257363491002d-1*t12*t3*t4*
     4         (-1.1141288576844789d+2*t13*t17*t6*t89+2.5389881826654315
     5         d+4*t20*t21*t4*t89-5.585774001863949d+4*t13*t21*t4*t89+1.
     6         0128444160767991d+1*t47*t48*t6-1.0128444160767991d+1*t16*
     7         t46*t47*t6+2.0256888321535982d+1*t16*t44*t46*t6-2.0256888
     8         321535982d+1*t43*t44*t45*t6+3.038533248230397d+1*t41*t43*
     9         t45*t6-3.038533248230397d+1*t40*t41*t42*t6+4.051377664307
     :         1964d+1*t38*t40*t42*t6-4.0513776643071964d+1*t37*t38*t39*
     ;         t6+5.064222080383994d+1*t35*t37*t39*t6-5.064222080383994d
     <         +1*t34*t35*t36*t6+6.077066496460795d+1*t32*t34*t36*t6-6.0
     =         77066496460795d+1*t31*t32*t33*t6+7.089910912537593d+1*t29
     >         *t31*t33*t6-7.089910912537593d+1*t28*t29*t30*t6+8.1027553
     ?         28614393d+1*t26*t28*t30*t6-8.102755328614393d+1*t25*t26*t
     @         27*t6+9.115599744691191d+1*t23*t25*t27*t6-9.1155997446911
     1         91d+1*t22*t23*t24*t6+1.012844416076799d+2*t20*t22*t24*t6-
     2         1.012844416076799d+2*t19*t20*t21*t6+1.1141288576844789d+2
     3         *t13*t19*t21*t6-4.6163421503007845d+2*t4*t46*t47+4.616342
     4         1503007845d+2*t16*t4*t43*t47+4.6163421503007845d+2*t4*t44
     5         *t46+1.3849026450902355d+3*t4*t40*t44*t45-4.1547079352707
     6         067d+3*t4*t40*t41*t45+2.769805290180471d+3*t38*t4*t40*t45
     7         -1.846536860120314d+3*t16*t4*t43*t44+1.3849026450902355d+
     8         3*t16*t4*t41*t43+2.769805290180471d+3*t37*t4*t41*t42-7.38
     9         6147440481255d+3*t37*t38*t4*t42+4.616342150300784d+3*t35*
     :         t37*t4*t42+4.616342150300784d+3*t34*t38*t39*t4-1.15408553
     ;         7575196d+4*t34*t35*t39*t4+6.924513225451178d+3*t32*t34*t3
     <         9*t4+6.924513225451178d+3*t31*t35*t36*t4-1.66188317410828
     =         3d+4*t31*t32*t36*t4+9.694318515631648d+3*t29*t31*t36*t4+9
     >         .694318515631648d+3*t28*t32*t33*t4-2.2620076536473846d+4*
     ?         t28*t29*t33*t4+1.2925758020842196d+4*t26*t28*t33*t4+1.292
     @         5758020842196d+4*t25*t29*t30*t4-2.954458976192502d+4*t25*
     1         t26*t30*t4+1.6618831741082823d+4*t23*t25*t30*t4+1.6618831
     2         741082823d+4*t22*t26*t27*t4-3.7392371417436354d+4*t22*t23
     3         *t27*t4+2.0773539676353528d+4*t20*t22*t27*t4+2.0773539676
     4         353528d+4*t19*t23*t24*t4-4.616342150300784d+4*t19*t20*t24
     5         *t4+2.5389881826654315d+4*t13*t19*t24*t4+3.04678581919851
     6         8d+4*t109*t13*t17*t4)+1.9863746096705204d-2*gammabb*t117*
     7         t50*t64*t88-5.316678166471045d-5*t110*t116*t50*t64*t88+t1
     8         18*t51*t88-2.3079800683637772d-4*t110*t111*t116*t64*t76+t
     9         118*t3*t76+t100*(-4.135669939329334d-1*t12*t51*t63-4.1356
     :         69939329334d-1*t12*t3*t49)-2.4814019635976003d+0*t102*t5*
     ;         t51*t63-9.305257363491002d-1*t115*t4*t51*t63-5.0410164445
     <         33138d-3*gammabb*t113*t12*t50*t63+4.947305865786653d-5*t1
     =         10*t112*t12*t50*t63-2.4814019635976003d+0*t102*t3*t49*t5-
     >         9.305257363491002d-1*t115*t3*t4*t49+2.1476348525932504d-4
     ?         *t110*t111*t112*t12*t49)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*((-3.361156316208638d-3*t12*t90
     1         -3.361156316208638d-3*t102*t49)*t94*t96+(-1.8903811666999
     2         27d-3*t12*t50*t91-1.890381166699927d-3*t102*t50*t63)*t96+
     3         4.481541754944851d-3*t12*t49*t94*t95+2.520508222266569d-3
     4         *t12*t50*t63*t95+t1*(3.612104625279974d-3*t64*t92+3.61210
     5         4625279974d-3*t104*t76)*t94-9.632279000746596d-3*t103*t64
     6         *t76*t94+t1*(2.0315194871630324d-3*t50*t64*t93+2.03151948
     7         71630324d-3*t104*t50*t88)+1.9937543124266421d-5*gammabb*t
     8         120*t50*t64*t88-5.417385299101419d-3*t103*t50*t64*t88+8.6
     9         54925256364164d-5*gammabb*t111*t120*t64*t76-1.85523969966
     :         9995d-5*gammabb*t119*t12*t50*t63-8.05363069722469d-5*gamm
     ;         abb*t111*t119*t12*t49)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*(-7.476578671599909d-6*t122*t5
     1         0*t64*t88-3.245596971136562d-5*t111*t122*t64*t76+6.957148
     2         873762482d-6*t12*t121*t50*t63+3.020111511459258d-5*t111*t
     3         12*t121*t49)*wght+Cmat2(iq,D2_GBB_GBB)
            Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = 1.0d+0*(8.963083509889702d-3*gammabb*t1
     1         05*t12*t94*t95+5.041016444533138d-3*gammabb*t106*t12*t50*
     2         t95-9.632279000746596d-3*gammabb*t103*t107*t64*t94+t51*t6
     3         4*(3.342386573053437d+3*t21*t78*t89*t9+6.077066496460795d
     4         +1*t16*t43*t87*t9-6.077066496460795d+1*t46*t86*t9+1.82311
     5         99489382385d+2*t40*t45*t86*t9-1.8231199489382385d+2*t16*t
     6         43*t85*t9+3.646239897876477d+2*t37*t42*t85*t9-3.646239897
     7         876477d+2*t40*t45*t84*t9+6.077066496460795d+2*t34*t39*t84
     8         *t9-6.077066496460795d+2*t37*t42*t83*t9+9.115599744691192
     9         d+2*t31*t36*t83*t9-9.115599744691192d+2*t34*t39*t82*t9+1.
     :         276183964256767d+3*t28*t33*t82*t9-1.276183964256767d+3*t3
     ;         1*t36*t81*t9+1.7015786190090226d+3*t25*t30*t81*t9-1.70157
     <         86190090226d+3*t28*t33*t80*t9+2.187743938725886d+3*t22*t2
     =         7*t80*t9-2.187743938725886d+3*t25*t30*t79*t9+2.7346799234
     >         07357d+3*t19*t24*t79*t9-2.734679923407357d+3*t22*t27*t78*
     ?         t9-3.342386573053437d+3*t19*t24*t77*t9+4.0108638876641245
     @         d+3*t109*t17*t77*t9)+t3*t64*(3.342386573053437d+3*t21*t66
     1         *t89*t9+6.077066496460795d+1*t16*t43*t75*t9-6.07706649646
     2         0795d+1*t46*t74*t9+1.8231199489382385d+2*t40*t45*t74*t9-1
     3         .8231199489382385d+2*t16*t43*t73*t9+3.646239897876477d+2*
     4         t37*t42*t73*t9-3.646239897876477d+2*t40*t45*t72*t9+6.0770
     5         66496460795d+2*t34*t39*t72*t9-6.077066496460795d+2*t37*t4
     6         2*t71*t9+9.115599744691192d+2*t31*t36*t71*t9-9.1155997446
     7         91192d+2*t34*t39*t70*t9+1.276183964256767d+3*t28*t33*t70*
     8         t9-1.276183964256767d+3*t31*t36*t69*t9+1.7015786190090226
     9         d+3*t25*t30*t69*t9-1.7015786190090226d+3*t28*t33*t68*t9+2
     :         .187743938725886d+3*t22*t27*t68*t9-2.187743938725886d+3*t
     ;         25*t30*t67*t9+2.734679923407357d+3*t19*t24*t67*t9-2.73467
     <         9923407357d+3*t22*t27*t66*t9-3.342386573053437d+3*t19*t24
     =         *t65*t9+4.0108638876641245d+3*t109*t17*t65*t9)-9.30525736
     >         3491002d-1*t12*t4*t51*(3.342386573053437d+3*t21*t53*t89*t
     ?         9+6.077066496460795d+1*t16*t43*t62*t9-6.077066496460795d+
     @         1*t46*t61*t9+1.8231199489382385d+2*t40*t45*t61*t9-1.82311
     1         99489382385d+2*t16*t43*t60*t9+3.646239897876477d+2*t37*t4
     2         2*t60*t9-3.646239897876477d+2*t40*t45*t59*t9+6.0770664964
     3         60795d+2*t34*t39*t59*t9-6.077066496460795d+2*t37*t42*t58*
     4         t9+9.115599744691192d+2*t31*t36*t58*t9-9.115599744691192d
     5         +2*t34*t39*t57*t9+1.276183964256767d+3*t28*t33*t57*t9-1.2
     6         76183964256767d+3*t31*t36*t56*t9+1.7015786190090226d+3*t2
     7         5*t30*t56*t9-1.7015786190090226d+3*t28*t33*t55*t9+2.18774
     8         3938725886d+3*t22*t27*t55*t9-2.187743938725886d+3*t25*t30
     9         *t54*t9+2.734679923407357d+3*t19*t24*t54*t9-2.73467992340
     :         7357d+3*t22*t27*t53*t9-3.342386573053437d+3*t19*t24*t52*t
     ;         9+4.0108638876641245d+3*t109*t17*t52*t9)-9.30525736349100
     <         2d-1*t12*t3*t4*(3.342386573053437d+3*t20*t21*t89*t9+6.077
     =         066496460795d+1*t16*t43*t47*t9-6.077066496460795d+1*t44*t
     >         46*t9+1.8231199489382385d+2*t40*t44*t45*t9-3.646239897876
     ?         477d+2*t38*t40*t45*t9-1.8231199489382385d+2*t16*t41*t43*t
     @         9+3.646239897876477d+2*t37*t41*t42*t9-6.077066496460795d+
     1         2*t35*t37*t42*t9+6.077066496460795d+2*t34*t38*t39*t9-9.11
     2         5599744691192d+2*t32*t34*t39*t9+9.115599744691192d+2*t31*
     3         t35*t36*t9-1.276183964256767d+3*t29*t31*t36*t9+1.27618396
     4         4256767d+3*t28*t32*t33*t9-1.7015786190090226d+3*t26*t28*t
     5         33*t9+1.7015786190090226d+3*t25*t29*t30*t9-2.187743938725
     6         886d+3*t23*t25*t30*t9+2.187743938725886d+3*t22*t26*t27*t9
     7         -2.734679923407357d+3*t20*t22*t27*t9+2.734679923407357d+3
     8         *t19*t23*t24*t9-3.342386573053437d+3*t13*t19*t24*t9+4.010
     9         8638876641245d+3*t109*t13*t17*t9)-5.417385299101419d-3*ga
     :         mmabb*t103*t108*t50*t64-1.2407009817988002d+0*t106*t12*t5
     ;         *t51-9.305257363491002d-1*t102*t106*t4*t51+t104*t108*t51-
     <         1.2407009817988002d+0*t105*t12*t3*t5-9.305257363491002d-1
     =         *t102*t105*t3*t4+t104*t107*t3)*wght+Mmat2(iq,D2_RB_TB)
            Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = 1.0d+0*(-3.361156316208638d-3*t105*t12
     1         *t94*t96-1.890381166699927d-3*t106*t12*t50*t96+3.61210462
     2         5279974d-3*t1*t107*t64*t94+2.0315194871630324d-3*t1*t108*
     3         t50*t64)*wght+Mmat2(iq,D2_GBB_TB)
            Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = 1.0d+0*(t51*t64*(4.4d+2*t21*t78*t89+9.6
     1         8d+2*t21*t77*t89+8.0d+0*t46*t87+8.0d+0*t16*t43*t87+8.0d+0
     2         *t46*t86+2.4d+1*t40*t45*t86+3.2d+1*t16*t43*t86+7.2d+1*t40
     3         *t45*t85+2.4d+1*t16*t43*t85+4.8d+1*t37*t42*t85+4.8d+1*t40
     4         *t45*t84+1.28d+2*t37*t42*t84+8.0d+1*t34*t39*t84+8.0d+1*t3
     5         7*t42*t83+2.0d+2*t34*t39*t83+1.2d+2*t31*t36*t83+1.2d+2*t3
     6         4*t39*t82+2.88d+2*t31*t36*t82+1.68d+2*t28*t33*t82+1.68d+2
     7         *t31*t36*t81+3.92d+2*t28*t33*t81+2.24d+2*t25*t30*t81+2.24
     8         d+2*t28*t33*t80+5.12d+2*t25*t30*t80+2.88d+2*t22*t27*t80+2
     9         .88d+2*t25*t30*t79+6.48d+2*t22*t27*t79+3.6d+2*t19*t24*t79
     :         +3.6d+2*t22*t27*t78+8.0d+2*t19*t24*t78+4.4d+2*t19*t24*t77
     ;         +5.28d+2*t109*t17*t77)+t3*t64*(4.4d+2*t21*t66*t89+9.68d+2
     <         *t21*t65*t89+8.0d+0*t46*t75+8.0d+0*t16*t43*t75+8.0d+0*t46
     =         *t74+2.4d+1*t40*t45*t74+3.2d+1*t16*t43*t74+7.2d+1*t40*t45
     >         *t73+2.4d+1*t16*t43*t73+4.8d+1*t37*t42*t73+4.8d+1*t40*t45
     ?         *t72+1.28d+2*t37*t42*t72+8.0d+1*t34*t39*t72+8.0d+1*t37*t4
     @         2*t71+2.0d+2*t34*t39*t71+1.2d+2*t31*t36*t71+1.2d+2*t34*t3
     1         9*t70+2.88d+2*t31*t36*t70+1.68d+2*t28*t33*t70+1.68d+2*t31
     2         *t36*t69+3.92d+2*t28*t33*t69+2.24d+2*t25*t30*t69+2.24d+2*
     3         t28*t33*t68+5.12d+2*t25*t30*t68+2.88d+2*t22*t27*t68+2.88d
     4         +2*t25*t30*t67+6.48d+2*t22*t27*t67+3.6d+2*t19*t24*t67+3.6
     5         d+2*t22*t27*t66+8.0d+2*t19*t24*t66+4.4d+2*t19*t24*t65+5.2
     6         8d+2*t109*t17*t65)-9.305257363491002d-1*t12*t4*t51*(4.4d+
     7         2*t21*t53*t89+9.68d+2*t21*t52*t89+8.0d+0*t46*t62+8.0d+0*t
     8         16*t43*t62+8.0d+0*t46*t61+2.4d+1*t40*t45*t61+3.2d+1*t16*t
     9         43*t61+7.2d+1*t40*t45*t60+2.4d+1*t16*t43*t60+4.8d+1*t37*t
     :         42*t60+4.8d+1*t40*t45*t59+1.28d+2*t37*t42*t59+8.0d+1*t34*
     ;         t39*t59+8.0d+1*t37*t42*t58+2.0d+2*t34*t39*t58+1.2d+2*t31*
     <         t36*t58+1.2d+2*t34*t39*t57+2.88d+2*t31*t36*t57+1.68d+2*t2
     =         8*t33*t57+1.68d+2*t31*t36*t56+3.92d+2*t28*t33*t56+2.24d+2
     >         *t25*t30*t56+2.24d+2*t28*t33*t55+5.12d+2*t25*t30*t55+2.88
     ?         d+2*t22*t27*t55+2.88d+2*t25*t30*t54+6.48d+2*t22*t27*t54+3
     @         .6d+2*t19*t24*t54+3.6d+2*t22*t27*t53+8.0d+2*t19*t24*t53+4
     1         .4d+2*t19*t24*t52+5.28d+2*t109*t17*t52)-9.305257363491002
     2         d-1*t12*t3*t4*(4.4d+2*t20*t21*t89+9.68d+2*t13*t21*t89+8.0
     3         d+0*t46*t47+8.0d+0*t16*t43*t47+8.0d+0*t44*t46+2.4d+1*t40*
     4         t44*t45+7.2d+1*t40*t41*t45+4.8d+1*t38*t40*t45+3.2d+1*t16*
     5         t43*t44+2.4d+1*t16*t41*t43+4.8d+1*t37*t41*t42+1.28d+2*t37
     6         *t38*t42+8.0d+1*t35*t37*t42+8.0d+1*t34*t38*t39+2.0d+2*t34
     7         *t35*t39+1.2d+2*t32*t34*t39+1.2d+2*t31*t35*t36+2.88d+2*t3
     8         1*t32*t36+1.68d+2*t29*t31*t36+1.68d+2*t28*t32*t33+3.92d+2
     9         *t28*t29*t33+2.24d+2*t26*t28*t33+2.24d+2*t25*t29*t30+5.12
     :         d+2*t25*t26*t30+2.88d+2*t23*t25*t30+2.88d+2*t22*t26*t27+6
     ;         .48d+2*t22*t23*t27+3.6d+2*t20*t22*t27+3.6d+2*t19*t23*t24+
     <         8.0d+2*t19*t20*t24+4.4d+2*t13*t19*t24+5.28d+2*t109*t13*t1
     =         7))*wght+Mmat2(iq,D2_TB_TB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_x_m11 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& \rho_\alpha^{{{1}\over{3}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha}}\\\\ 
C>   {\it t_5} &=& 1.0-0.04275941461768073\,{\it t_3}\,
C>    \left({{0.1282782438530422\,{\it t_3}
C>    -2.63857249068588 \times 10^{-4}\,{\it t_4}}
C>    \over{e^{243.0826598584318\,\rho_\alpha^{{{2}\over{3}}}}}}
C>    -0.1924173657795633\,{\it t_3}+2.63857249068588 \times 10^{-4}
C>    \,{\it t_4}+3.544907701811032\,\mathrm{erf}
C>    \left(15.59110835888301\,{\it t_2}\right)\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& 0.804\,\left(1.0-{{1.0}\over{0.004492667444378077
C>    \,{\it t_6}\,\sigma_{\alpha\alpha}+1.0}}\right)+1.0\\\\ 
C>   {\it t_8} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_9} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{10}} &=& 9.115599744691192\,\rho_\alpha^{{{5}
C>    \over{3}}}\\\\ 
C>   {\it t_{11}} &=& {\it t_{10}}-2.0\,\tau_\alpha\\\\ 
C>   {\it t_{12}} &=& {\it t_{11}}^{11}\\\\ 
C>   {\it t_{13}} &=& 2.0\,\tau_\alpha+{\it t_{10}}\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_{13}}^{11}}}\\\\ 
C>   {\it t_{15}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{16}} &=& {\it t_{11}}^{10}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{{\it t_{13}}^{10}}}\\\\ 
C>   {\it t_{18}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{19}} &=& {\it t_{11}}^9\\\\ 
C>   {\it t_{20}} &=& {{1}\over{{\it t_{13}}^9}}\\\\ 
C>   {\it t_{21}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{22}} &=& {\it t_{11}}^8\\\\ 
C>   {\it t_{23}} &=& {{1}\over{{\it t_{13}}^8}}\\\\ 
C>   {\it t_{24}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{25}} &=& {\it t_{11}}^7\\\\ 
C>   {\it t_{26}} &=& {{1}\over{{\it t_{13}}^7}}\\\\ 
C>   {\it t_{27}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{28}} &=& {\it t_{11}}^6\\\\ 
C>   {\it t_{29}} &=& {{1}\over{{\it t_{13}}^6}}\\\\ 
C>   {\it t_{30}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{31}} &=& {\it t_{11}}^5\\\\ 
C>   {\it t_{32}} &=& {{1}\over{{\it t_{13}}^5}}\\\\ 
C>   {\it t_{33}} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_{34}} &=& {\it t_{11}}^4\\\\ 
C>   {\it t_{35}} &=& {{1}\over{{\it t_{13}}^4}}\\\\ 
C>   {\it t_{36}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{37}} &=& {\it t_{11}}^3\\\\ 
C>   {\it t_{38}} &=& {{1}\over{{\it t_{13}}^3}}\\\\ 
C>   {\it t_{39}} &=& {\it param}\left(3\right)\\\\ 
C>   {\it t_{40}} &=& {\it t_{11}}^2\\\\ 
C>   {\it t_{41}} &=& {{1}\over{{\it t_{13}}^2}}\\\\ 
C>   {\it t_{42}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{43}} &=& {{1}\over{{\it t_{13}}}}\\\\ 
C>   {\it t_{44}} &=& 0.552\,\left(1.0-{{1}
C>    \over{e^{0.003680288926019986\,{\it t_6}\,
C>    \sigma_{\alpha\alpha}}}}\right)+1.0\\\\ 
C>   {\it t_{45}} &=& {\it param}\left(13\right)\\\\ 
C>   {\it t_{46}} &=& {\it param}\left(24\right)\\\\ 
C>   {\it t_{47}} &=& {\it param}\left(23\right)\\\\ 
C>   {\it t_{48}} &=& {\it param}\left(22\right)\\\\ 
C>   {\it t_{49}} &=& {\it param}\left(21\right)\\\\ 
C>   {\it t_{50}} &=& {\it param}\left(20\right)\\\\ 
C>   {\it t_{51}} &=& {\it param}\left(19\right)\\\\ 
C>   {\it t_{52}} &=& {\it param}\left(18\right)\\\\ 
C>   {\it t_{53}} &=& {\it param}\left(17\right)\\\\ 
C>   {\it t_{54}} &=& {\it param}\left(16\right)\\\\ 
C>   {\it t_{55}} &=& {\it param}\left(15\right)\\\\ 
C>   {\it t_{56}} &=& {\it param}\left(14\right)\\\\ 
C>   {\it t_{57}} &=& 0.9305257363491002\,{\it t_1}\,{\it t_5}
C>    -0.9305257363491002\,{\it t_1}\\\\ 
C>   {\it t_{58}} &=& {\it param}\left(25\right)\\\\ 
C>   {\it t_{59}} &=& {\it param}\left(36\right)\\\\ 
C>   {\it t_{60}} &=& {\it param}\left(35\right)\\\\ 
C>   {\it t_{61}} &=& {\it param}\left(34\right)\\\\ 
C>   {\it t_{62}} &=& {\it param}\left(33\right)\\\\ 
C>   {\it t_{63}} &=& {\it param}\left(32\right)\\\\ 
C>   {\it t_{64}} &=& {\it param}\left(31\right)\\\\ 
C>   {\it t_{65}} &=& {\it param}\left(30\right)\\\\ 
C>   {\it t_{66}} &=& {\it param}\left(29\right)\\\\ 
C>   {\it t_{67}} &=& {\it param}\left(28\right)\\\\ 
C>   {\it t_{68}} &=& {\it param}\left(27\right)\\\\ 
C>   {\it t_{69}} &=& {\it param}\left(26\right)\\\\ 
C>   {\it t_{70}} &=& {\it param}\left(37\right)\\\\ 
C>   {\it t_{71}} &=& {\it param}\left(48\right)\\\\ 
C>   {\it t_{72}} &=& {\it param}\left(47\right)\\\\ 
C>   {\it t_{73}} &=& {\it param}\left(46\right)\\\\ 
C>   {\it t_{74}} &=& {\it param}\left(45\right)\\\\ 
C>   {\it t_{75}} &=& {\it param}\left(44\right)\\\\ 
C>   {\it t_{76}} &=& {\it param}\left(43\right)\\\\ 
C>   {\it t_{77}} &=& {\it param}\left(42\right)\\\\ 
C>   {\it t_{78}} &=& {\it param}\left(41\right)\\\\ 
C>   {\it t_{79}} &=& {\it param}\left(40\right)\\\\ 
C>   {\it t_{80}} &=& {\it param}\left(39\right)\\\\ 
C>   {\it t_{81}} &=& {\it param}\left(38\right)\\\\ 
C>   {\it t_{82}} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_{83}} &=& \rho_\beta^{{{1}\over{3}}}\\\\ 
C>   {\it t_{84}} &=& {{1}\over{{\it t_{83}}}}\\\\ 
C>   {\it t_{85}} &=& {{1}\over{\rho_\beta}}\\\\ 
C>   {\it t_{86}} &=& 1.0-0.04275941461768073\,{\it t_{84}}\,
C>    \left({{0.1282782438530422\,{\it t_{84}}
C>    -2.63857249068588 \times 10^{-4}\,{\it t_{85}}}
C>    \over{e^{243.0826598584318\,\rho_\beta^{{{2}\over{3}}}}}}
C>    -0.1924173657795633\,{\it t_{84}}+2.63857249068588 \times 10^{
C>    -4}\,{\it t_{85}}+3.544907701811032\,\mathrm{erf}
C>    \left(15.59110835888301\,{\it t_{83}}\right)\right)\\\\ 
C>   {\it t_{87}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{88}} &=& 0.804\,\left(1.0-{{1.0}
C>    \over{0.004492667444378077\,{\it t_{87}}\,\sigma_{\beta\beta}
C>    +1.0}}\right)+1.0\\\\ 
C>   {\it t_{89}} &=& 9.115599744691192\,\rho_\beta^{{{5}\over{3}}}\\\\ 
C>   {\it t_{90}} &=& {\it t_{89}}-2.0\,\tau_\beta\\\\ 
C>   {\it t_{91}} &=& {\it t_{90}}^{11}\\\\ 
C>   {\it t_{92}} &=& 2.0\,\tau_\beta+{\it t_{89}}\\\\ 
C>   {\it t_{93}} &=& {{1}\over{{\it t_{92}}^{11}}}\\\\ 
C>   {\it t_{94}} &=& {\it t_{90}}^{10}\\\\ 
C>   {\it t_{95}} &=& {{1}\over{{\it t_{92}}^{10}}}\\\\ 
C>   {\it t_{96}} &=& {\it t_{90}}^9\\\\ 
C>   {\it t_{97}} &=& {{1}\over{{\it t_{92}}^9}}\\\\ 
C>   {\it t_{98}} &=& {\it t_{90}}^8\\\\ 
C>   {\it t_{99}} &=& {{1}\over{{\it t_{92}}^8}}\\\\ 
C>   {\it t_{100}} &=& {\it t_{90}}^7\\\\ 
C>   {\it t_{101}} &=& {{1}\over{{\it t_{92}}^7}}\\\\ 
C>   {\it t_{102}} &=& {\it t_{90}}^6\\\\ 
C>   {\it t_{103}} &=& {{1}\over{{\it t_{92}}^6}}\\\\ 
C>   {\it t_{104}} &=& {\it t_{90}}^5\\\\ 
C>   {\it t_{105}} &=& {{1}\over{{\it t_{92}}^5}}\\\\ 
C>   {\it t_{106}} &=& {\it t_{90}}^4\\\\ 
C>   {\it t_{107}} &=& {{1}\over{{\it t_{92}}^4}}\\\\ 
C>   {\it t_{108}} &=& {\it t_{90}}^3\\\\ 
C>   {\it t_{109}} &=& {{1}\over{{\it t_{92}}^3}}\\\\ 
C>   {\it t_{110}} &=& {\it t_{90}}^2\\\\ 
C>   {\it t_{111}} &=& {{1}\over{{\it t_{92}}^2}}\\\\ 
C>   {\it t_{112}} &=& {{1}\over{{\it t_{92}}}}\\\\ 
C>   {\it t_{113}} &=& 0.552\,\left(1.0-{{1}
C>    \over{e^{0.003680288926019986\,{\it t_{87}}\,
C>    \sigma_{\beta\beta}}}}\right)+1.0\\\\ 
C>   {\it t_{114}} &=& 0.9305257363491002\,{\it t_{82}}\,{\it t_{86}}
C>    -0.9305257363491002\,{\it t_{82}}\\\\ 
C>   {\it t_{115}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{116}} &=& \rho_s^{{{1}\over{3}}}\\\\ 
C>   {\it t_{117}} &=& {{1}\over{{\it t_{116}}}}\\\\ 
C>   {\it t_{118}} &=& {{1}\over{\rho_s}}\\\\ 
C>   {\it t_{119}} &=& 1.0-0.04275941461768073\,{\it t_{117}}
C>    \,\left({{0.1282782438530422\,{\it t_{117}}
C>    -2.63857249068588 \times 10^{-4}\,{\it t_{118}}}
C>    \over{e^{243.0826598584318\,\rho_s^{{{2}\over{3}}}}}}
C>    -0.1924173657795633\,{\it t_{117}}+2.63857249068588 \times 10^{
C>    -4}\,{\it t_{118}}+3.544907701811032\,\mathrm{erf}
C>    \left(15.59110835888301\,{\it t_{116}}\right)\right)\\\\ 
C>   {\it t_{120}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{121}} &=& 0.804\,\left(1.0-{{1.0}
C>    \over{0.004492667444378077\,{\it t_{120}}\,\sigma_{ss}
C>    +1.0}}\right)+1.0\\\\ 
C>   {\it t_{122}} &=& 9.115599744691192\,\rho_s^{{{5}\over{3}}}\\\\ 
C>   {\it t_{123}} &=& {\it t_{122}}-2.0\,\tau_s\\\\ 
C>   {\it t_{124}} &=& {\it t_{123}}^{11}\\\\ 
C>   {\it t_{125}} &=& 2.0\,\tau_s+{\it t_{122}}\\\\ 
C>   {\it t_{126}} &=& {{1}\over{{\it t_{125}}^{11}}}\\\\ 
C>   {\it t_{127}} &=& {\it t_{123}}^{10}\\\\ 
C>   {\it t_{128}} &=& {{1}\over{{\it t_{125}}^{10}}}\\\\ 
C>   {\it t_{129}} &=& {\it t_{123}}^9\\\\ 
C>   {\it t_{130}} &=& {{1}\over{{\it t_{125}}^9}}\\\\ 
C>   {\it t_{131}} &=& {\it t_{123}}^8\\\\ 
C>   {\it t_{132}} &=& {{1}\over{{\it t_{125}}^8}}\\\\ 
C>   {\it t_{133}} &=& {\it t_{123}}^7\\\\ 
C>   {\it t_{134}} &=& {{1}\over{{\it t_{125}}^7}}\\\\ 
C>   {\it t_{135}} &=& {\it t_{123}}^6\\\\ 
C>   {\it t_{136}} &=& {{1}\over{{\it t_{125}}^6}}\\\\ 
C>   {\it t_{137}} &=& {\it t_{123}}^5\\\\ 
C>   {\it t_{138}} &=& {{1}\over{{\it t_{125}}^5}}\\\\ 
C>   {\it t_{139}} &=& {\it t_{123}}^4\\\\ 
C>   {\it t_{140}} &=& {{1}\over{{\it t_{125}}^4}}\\\\ 
C>   {\it t_{141}} &=& {\it t_{123}}^3\\\\ 
C>   {\it t_{142}} &=& {{1}\over{{\it t_{125}}^3}}\\\\ 
C>   {\it t_{143}} &=& {\it t_{123}}^2\\\\ 
C>   {\it t_{144}} &=& {{1}\over{{\it t_{125}}^2}}\\\\ 
C>   {\it t_{145}} &=& {{1}\over{{\it t_{125}}}}\\\\ 
C>   {\it t_{146}} &=& 0.552\,\left(1.0-{{1}
C>    \over{e^{0.003680288926019986\,{\it t_{120}}\,
C>    \sigma_{ss}}}}\right)+1.0\\\\ 
C>   {\it t_{147}} &=& 0.9305257363491002\,{\it t_{115}}\,{
C>    \it t_{119}}-0.9305257363491002\,{\it t_{115}}\\\\ 
C>   f &=& 1.0\,\left({\it t_{114}}\,{\it t_{113}}\,\left({
C>    \it t_{81}}\,{\it t_{90}}\,{\it t_{112}}+{\it t_{80}}\,{
C>    \it t_{110}}\,{\it t_{111}}+{\it t_{79}}\,{\it t_{108}}\,{
C>    \it t_{109}}+{\it t_{78}}\,{\it t_{106}}\,{\it t_{107}}+{
C>    \it t_{77}}\,{\it t_{104}}\,{\it t_{105}}+{\it t_{76}}\,{
C>    \it t_{102}}\,{\it t_{103}}+{\it t_{75}}\,{\it t_{100}}\,{
C>    \it t_{101}}+{\it t_{74}}\,{\it t_{98}}\,{\it t_{99}}+{
C>    \it t_{73}}\,{\it t_{96}}\,{\it t_{97}}+{\it t_{72}}\,{
C>    \it t_{94}}\,{\it t_{95}}+{\it t_{71}}\,{\it t_{91}}\,{
C>    \it t_{93}}+{\it t_{70}}\right)+{\it t_{114}}\,{\it t_{88}}
C>    \,\left({\it t_{69}}\,{\it t_{90}}\,{\it t_{112}}+{\it t_{68}}
C>    \,{\it t_{110}}\,{\it t_{111}}+{\it t_{67}}\,{\it t_{108}}
C>    \,{\it t_{109}}+{\it t_{66}}\,{\it t_{106}}\,{\it t_{107}}+{
C>    \it t_{65}}\,{\it t_{104}}\,{\it t_{105}}+{\it t_{64}}\,{
C>    \it t_{102}}\,{\it t_{103}}+{\it t_{63}}\,{\it t_{100}}\,{
C>    \it t_{101}}+{\it t_{62}}\,{\it t_{98}}\,{\it t_{99}}+{
C>    \it t_{61}}\,{\it t_{96}}\,{\it t_{97}}+{\it t_{60}}\,{
C>    \it t_{94}}\,{\it t_{95}}+{\it t_{59}}\,{\it t_{91}}\,{
C>    \it t_{93}}+{\it t_{58}}\right)-0.9305257363491002\,{
C>    \it t_{82}}\,{\it t_{86}}\,{\it t_{113}}\,\left({\it t_{56}}
C>    \,{\it t_{90}}\,{\it t_{112}}+{\it t_{55}}\,{\it t_{110}}\,{
C>    \it t_{111}}+{\it t_{54}}\,{\it t_{108}}\,{\it t_{109}}+{
C>    \it t_{53}}\,{\it t_{106}}\,{\it t_{107}}+{\it t_{52}}\,{
C>    \it t_{104}}\,{\it t_{105}}+{\it t_{51}}\,{\it t_{102}}\,{
C>    \it t_{103}}+{\it t_{50}}\,{\it t_{100}}\,{\it t_{101}}+{
C>    \it t_{49}}\,{\it t_{98}}\,{\it t_{99}}+{\it t_{48}}\,{
C>    \it t_{96}}\,{\it t_{97}}+{\it t_{47}}\,{\it t_{94}}\,{
C>    \it t_{95}}+{\it t_{46}}\,{\it t_{91}}\,{\it t_{93}}+{
C>    \it t_{45}}\right)-0.9305257363491002\,{\it t_{82}}\,{
C>    \it t_{86}}\,{\it t_{88}}\,\left({\it t_{42}}\,{\it t_{90}}
C>    \,{\it t_{112}}+{\it t_{39}}\,{\it t_{110}}\,{\it t_{111}}+{
C>    \it t_{36}}\,{\it t_{108}}\,{\it t_{109}}+{\it t_{33}}\,{
C>    \it t_{106}}\,{\it t_{107}}+{\it t_{30}}\,{\it t_{104}}\,{
C>    \it t_{105}}+{\it t_{27}}\,{\it t_{102}}\,{\it t_{103}}+{
C>    \it t_{24}}\,{\it t_{100}}\,{\it t_{101}}+{\it t_{21}}\,{
C>    \it t_{98}}\,{\it t_{99}}+{\it t_{18}}\,{\it t_{96}}\,{
C>    \it t_{97}}+{\it t_{15}}\,{\it t_{94}}\,{\it t_{95}}+{\it t_9}
C>    \,{\it t_{91}}\,{\it t_{93}}+{\it t_8}\right)\right)+1.0
C>    \,\left({\it t_{57}}\,{\it t_{44}}\,\left({\it t_{81}}\,{
C>    \it t_{11}}\,{\it t_{43}}+{\it t_{80}}\,{\it t_{40}}\,{
C>    \it t_{41}}+{\it t_{79}}\,{\it t_{37}}\,{\it t_{38}}+{
C>    \it t_{78}}\,{\it t_{34}}\,{\it t_{35}}+{\it t_{77}}\,{
C>    \it t_{31}}\,{\it t_{32}}+{\it t_{76}}\,{\it t_{28}}\,{
C>    \it t_{29}}+{\it t_{75}}\,{\it t_{25}}\,{\it t_{26}}+{
C>    \it t_{74}}\,{\it t_{22}}\,{\it t_{23}}+{\it t_{73}}\,{
C>    \it t_{19}}\,{\it t_{20}}+{\it t_{72}}\,{\it t_{16}}\,{
C>    \it t_{17}}+{\it t_{71}}\,{\it t_{12}}\,{\it t_{14}}+{
C>    \it t_{70}}\right)+{\it t_{57}}\,{\it t_7}\,\left({\it t_{69}}
C>    \,{\it t_{11}}\,{\it t_{43}}+{\it t_{68}}\,{\it t_{40}}\,{
C>    \it t_{41}}+{\it t_{67}}\,{\it t_{37}}\,{\it t_{38}}+{
C>    \it t_{66}}\,{\it t_{34}}\,{\it t_{35}}+{\it t_{65}}\,{
C>    \it t_{31}}\,{\it t_{32}}+{\it t_{64}}\,{\it t_{28}}\,{
C>    \it t_{29}}+{\it t_{63}}\,{\it t_{25}}\,{\it t_{26}}+{
C>    \it t_{62}}\,{\it t_{22}}\,{\it t_{23}}+{\it t_{61}}\,{
C>    \it t_{19}}\,{\it t_{20}}+{\it t_{60}}\,{\it t_{16}}\,{
C>    \it t_{17}}+{\it t_{59}}\,{\it t_{12}}\,{\it t_{14}}+{
C>    \it t_{58}}\right)-0.9305257363491002\,{\it t_1}\,{\it t_5}
C>    \,{\it t_{44}}\,\left({\it t_{56}}\,{\it t_{11}}\,{\it t_{43}}
C>    +{\it t_{55}}\,{\it t_{40}}\,{\it t_{41}}+{\it t_{54}}\,{
C>    \it t_{37}}\,{\it t_{38}}+{\it t_{53}}\,{\it t_{34}}\,{
C>    \it t_{35}}+{\it t_{52}}\,{\it t_{31}}\,{\it t_{32}}+{
C>    \it t_{51}}\,{\it t_{28}}\,{\it t_{29}}+{\it t_{50}}\,{
C>    \it t_{25}}\,{\it t_{26}}+{\it t_{49}}\,{\it t_{22}}\,{
C>    \it t_{23}}+{\it t_{48}}\,{\it t_{19}}\,{\it t_{20}}+{
C>    \it t_{47}}\,{\it t_{16}}\,{\it t_{17}}+{\it t_{46}}\,{
C>    \it t_{12}}\,{\it t_{14}}+{\it t_{45}}\right)
C>    -0.9305257363491002\,{\it t_1}\,{\it t_5}\,{\it t_7}\,
C>    \left({\it t_{42}}\,{\it t_{11}}\,{\it t_{43}}+{\it t_{39}}
C>    \,{\it t_{40}}\,{\it t_{41}}+{\it t_{36}}\,{\it t_{37}}\,{
C>    \it t_{38}}+{\it t_{33}}\,{\it t_{34}}\,{\it t_{35}}+{
C>    \it t_{30}}\,{\it t_{31}}\,{\it t_{32}}+{\it t_{27}}\,{
C>    \it t_{28}}\,{\it t_{29}}+{\it t_{24}}\,{\it t_{25}}\,{
C>    \it t_{26}}+{\it t_{21}}\,{\it t_{22}}\,{\it t_{23}}+{
C>    \it t_{18}}\,{\it t_{19}}\,{\it t_{20}}+{\it t_{15}}\,{
C>    \it t_{16}}\,{\it t_{17}}+{\it t_9}\,{\it t_{12}}\,{\it t_{14}}
C>    +{\it t_8}\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left({\it t_{147}}\,{\it t_{146}}\,\left({
C>    \it t_{81}}\,{\it t_{123}}\,{\it t_{145}}+{\it t_{80}}\,{
C>    \it t_{143}}\,{\it t_{144}}+{\it t_{79}}\,{\it t_{141}}\,{
C>    \it t_{142}}+{\it t_{78}}\,{\it t_{139}}\,{\it t_{140}}+{
C>    \it t_{77}}\,{\it t_{137}}\,{\it t_{138}}+{\it t_{76}}\,{
C>    \it t_{135}}\,{\it t_{136}}+{\it t_{75}}\,{\it t_{133}}\,{
C>    \it t_{134}}+{\it t_{74}}\,{\it t_{131}}\,{\it t_{132}}+{
C>    \it t_{73}}\,{\it t_{129}}\,{\it t_{130}}+{\it t_{72}}\,{
C>    \it t_{127}}\,{\it t_{128}}+{\it t_{71}}\,{\it t_{124}}\,{
C>    \it t_{126}}+{\it t_{70}}\right)+{\it t_{147}}\,{\it t_{121}}
C>    \,\left({\it t_{69}}\,{\it t_{123}}\,{\it t_{145}}+{
C>    \it t_{68}}\,{\it t_{143}}\,{\it t_{144}}+{\it t_{67}}\,{
C>    \it t_{141}}\,{\it t_{142}}+{\it t_{66}}\,{\it t_{139}}\,{
C>    \it t_{140}}+{\it t_{65}}\,{\it t_{137}}\,{\it t_{138}}+{
C>    \it t_{64}}\,{\it t_{135}}\,{\it t_{136}}+{\it t_{63}}\,{
C>    \it t_{133}}\,{\it t_{134}}+{\it t_{62}}\,{\it t_{131}}\,{
C>    \it t_{132}}+{\it t_{61}}\,{\it t_{129}}\,{\it t_{130}}+{
C>    \it t_{60}}\,{\it t_{127}}\,{\it t_{128}}+{\it t_{59}}\,{
C>    \it t_{124}}\,{\it t_{126}}+{\it t_{58}}\right)
C>    -0.9305257363491002\,{\it t_{115}}\,{\it t_{119}}\,{
C>    \it t_{146}}\,\left({\it t_{56}}\,{\it t_{123}}\,{\it t_{145}}
C>    +{\it t_{55}}\,{\it t_{143}}\,{\it t_{144}}+{\it t_{54}}\,{
C>    \it t_{141}}\,{\it t_{142}}+{\it t_{53}}\,{\it t_{139}}\,{
C>    \it t_{140}}+{\it t_{52}}\,{\it t_{137}}\,{\it t_{138}}+{
C>    \it t_{51}}\,{\it t_{135}}\,{\it t_{136}}+{\it t_{50}}\,{
C>    \it t_{133}}\,{\it t_{134}}+{\it t_{49}}\,{\it t_{131}}\,{
C>    \it t_{132}}+{\it t_{48}}\,{\it t_{129}}\,{\it t_{130}}+{
C>    \it t_{47}}\,{\it t_{127}}\,{\it t_{128}}+{\it t_{46}}\,{
C>    \it t_{124}}\,{\it t_{126}}+{\it t_{45}}\right)
C>    -0.9305257363491002\,{\it t_{115}}\,{\it t_{119}}\,{
C>    \it t_{121}}\,\left({\it t_{42}}\,{\it t_{123}}\,{\it t_{145}}
C>    +{\it t_{39}}\,{\it t_{143}}\,{\it t_{144}}+{\it t_{36}}\,{
C>    \it t_{141}}\,{\it t_{142}}+{\it t_{33}}\,{\it t_{139}}\,{
C>    \it t_{140}}+{\it t_{30}}\,{\it t_{137}}\,{\it t_{138}}+{
C>    \it t_{27}}\,{\it t_{135}}\,{\it t_{136}}+{\it t_{24}}\,{
C>    \it t_{133}}\,{\it t_{134}}+{\it t_{21}}\,{\it t_{131}}\,{
C>    \it t_{132}}+{\it t_{18}}\,{\it t_{129}}\,{\it t_{130}}+{
C>    \it t_{15}}\,{\it t_{127}}\,{\it t_{128}}+{\it t_9}\,{
C>    \it t_{124}}\,{\it t_{126}}+{\it t_8}\right)\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] R Peverati, DG Truhlar, J.Phys.Chem.Lett. 2, 2810 (2011)  , DOI: 
C> <a href="http://dx.doi.org/10.1021/jz201170d "> 
C> 10.1021/jz201170d </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_x_m11_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3,Mmat,Mmat2,Mmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,NCOL_AMAT3)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,NCOL_CMAT3)  !< [Output] The 3rd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat3(nq,NCOL_MMAT3)  !< [Output] The 3rd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = rhoa**3.333333333333333d-1
            t6 = 1/t5
            t7 = 1/rhoa
            t8 = 1.282782438530422d-1*t6-2.63857249068588d-4*t7
            t9 = rhoa**6.666666666666666d-1
            t10 = exp(-2.4308265985843178d+2*t9)
            t11 = t10*t8+2.63857249068588d-4*t7-1.924173657795633d-1*t6+
     1         3.544907701811032d+0*erf(1.5591108358883013d+1*t5)
            t12 = 1.0d+0-4.275941461768073d-2*t11*t6
            t13 = param(12)
            t14 = rhoa**1.6666666666666669d+0
            t15 = 9.115599744691192d+0*t14
            t16 = t15-2.0d+0*taua
            t17 = t16**11
            t18 = 2.0d+0*taua+t15
            t19 = 1/t18**11
            t20 = param(11)
            t21 = t16**10
            t22 = 1/t18**10
            t23 = param(10)
            t24 = t16**9
            t25 = 1/t18**9
            t26 = param(9)
            t27 = t16**8
            t28 = 1/t18**8
            t29 = param(8)
            t30 = t16**7
            t31 = 1/t18**7
            t32 = param(7)
            t33 = t16**6
            t34 = 1/t18**6
            t35 = param(6)
            t36 = t16**5
            t37 = 1/t18**5
            t38 = param(5)
            t39 = t16**4
            t40 = 1/t18**4
            t41 = param(4)
            t42 = t16**3
            t43 = 1/t18**3
            t44 = param(3)
            t45 = t16**2
            t46 = 1/t18**2
            t47 = param(2)
            t48 = 1/t18
            t49 = t16*t47*t48+t44*t45*t46+t41*t42*t43+t38*t39*t40+t35*t3
     1         6*t37+t32*t33*t34+t29*t30*t31+t26*t27*t28+t23*t24*t25+t20
     2         *t21*t22+t13*t17*t19+param(1)
            t50 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t51 = 5.52d-1*(1.0d+0-t50)+1.0d+0
            t52 = param(24)
            t53 = param(23)
            t54 = param(22)
            t55 = param(21)
            t56 = param(20)
            t57 = param(19)
            t58 = param(18)
            t59 = param(17)
            t60 = param(16)
            t61 = param(15)
            t62 = param(14)
            t63 = t16*t48*t62+t45*t46*t61+t42*t43*t60+t39*t40*t59+t36*t3
     1         7*t58+t33*t34*t57+t30*t31*t56+t27*t28*t55+t24*t25*t54+t21
     2         *t22*t53+t17*t19*t52+param(13)
            t64 = 9.305257363491002d-1*t12*t4-9.305257363491002d-1*t4
            t65 = param(36)
            t66 = param(35)
            t67 = param(34)
            t68 = param(33)
            t69 = param(32)
            t70 = param(31)
            t71 = param(30)
            t72 = param(29)
            t73 = param(28)
            t74 = param(27)
            t75 = param(26)
            t76 = t16*t48*t75+t45*t46*t74+t42*t43*t73+t39*t40*t72+t36*t3
     1         7*t71+t33*t34*t70+t30*t31*t69+t27*t28*t68+t24*t25*t67+t21
     2         *t22*t66+t17*t19*t65+param(25)
            t77 = param(48)
            t78 = param(47)
            t79 = param(46)
            t80 = param(45)
            t81 = param(44)
            t82 = param(43)
            t83 = param(42)
            t84 = param(41)
            t85 = param(40)
            t86 = param(39)
            t87 = param(38)
            t88 = t16*t48*t87+t45*t46*t86+t42*t43*t85+t39*t40*t84+t36*t3
     1         7*t83+t33*t34*t82+t30*t31*t81+t27*t28*t80+t24*t25*t79+t21
     2         *t22*t78+t17*t19*t77+param(37)
            t89 = 1/t18**12
            t90 = -1.6711932865267184d+2*t13*t17*t89*t9+1.51926662411519
     1         86d+1*t47*t48*t9-1.5192666241151986d+1*t16*t46*t47*t9+3.0
     2         38533248230397d+1*t16*t44*t46*t9-3.038533248230397d+1*t43
     3         *t44*t45*t9+4.5577998723455965d+1*t41*t43*t45*t9-4.557799
     4         8723455965d+1*t40*t41*t42*t9+6.077066496460795d+1*t38*t40
     5         *t42*t9-6.077066496460795d+1*t37*t38*t39*t9+7.59633312057
     6         5993d+1*t35*t37*t39*t9-7.596333120575993d+1*t34*t35*t36*t
     7         9+9.115599744691193d+1*t32*t34*t36*t9-9.115599744691193d+
     8         1*t31*t32*t33*t9+1.0634866368806391d+2*t29*t31*t33*t9-1.0
     9         634866368806391d+2*t28*t29*t30*t9+1.2154132992921589d+2*t
     :         26*t28*t30*t9-1.2154132992921589d+2*t25*t26*t27*t9+1.3673
     ;         399617036788d+2*t23*t25*t27*t9-1.3673399617036788d+2*t22*
     <         t23*t24*t9+1.5192666241151986d+2*t20*t22*t24*t9-1.5192666
     =         241151986d+2*t19*t20*t21*t9+1.6711932865267184d+2*t13*t19
     >         *t21*t9
            t91 = -1.6711932865267184d+2*t17*t52*t89*t9+1.51926662411519
     1         86d+1*t48*t62*t9-1.5192666241151986d+1*t16*t46*t62*t9+3.0
     2         38533248230397d+1*t16*t46*t61*t9-3.038533248230397d+1*t43
     3         *t45*t61*t9+4.5577998723455965d+1*t43*t45*t60*t9-4.557799
     4         8723455965d+1*t40*t42*t60*t9+6.077066496460795d+1*t40*t42
     5         *t59*t9-6.077066496460795d+1*t37*t39*t59*t9+7.59633312057
     6         5993d+1*t37*t39*t58*t9-7.596333120575993d+1*t34*t36*t58*t
     7         9+9.115599744691193d+1*t34*t36*t57*t9-9.115599744691193d+
     8         1*t31*t33*t57*t9+1.0634866368806391d+2*t31*t33*t56*t9-1.0
     9         634866368806391d+2*t28*t30*t56*t9+1.2154132992921589d+2*t
     :         28*t30*t55*t9-1.2154132992921589d+2*t25*t27*t55*t9+1.3673
     ;         399617036788d+2*t25*t27*t54*t9-1.3673399617036788d+2*t22*
     <         t24*t54*t9+1.5192666241151986d+2*t22*t24*t53*t9-1.5192666
     =         241151986d+2*t19*t21*t53*t9+1.6711932865267184d+2*t19*t21
     >         *t52*t9
            t92 = -1.6711932865267184d+2*t17*t65*t89*t9+1.51926662411519
     1         86d+1*t48*t75*t9-1.5192666241151986d+1*t16*t46*t75*t9+3.0
     2         38533248230397d+1*t16*t46*t74*t9-3.038533248230397d+1*t43
     3         *t45*t74*t9+4.5577998723455965d+1*t43*t45*t73*t9-4.557799
     4         8723455965d+1*t40*t42*t73*t9+6.077066496460795d+1*t40*t42
     5         *t72*t9-6.077066496460795d+1*t37*t39*t72*t9+7.59633312057
     6         5993d+1*t37*t39*t71*t9-7.596333120575993d+1*t34*t36*t71*t
     7         9+9.115599744691193d+1*t34*t36*t70*t9-9.115599744691193d+
     8         1*t31*t33*t70*t9+1.0634866368806391d+2*t31*t33*t69*t9-1.0
     9         634866368806391d+2*t28*t30*t69*t9+1.2154132992921589d+2*t
     :         28*t30*t68*t9-1.2154132992921589d+2*t25*t27*t68*t9+1.3673
     ;         399617036788d+2*t25*t27*t67*t9-1.3673399617036788d+2*t22*
     <         t24*t67*t9+1.5192666241151986d+2*t22*t24*t66*t9-1.5192666
     =         241151986d+2*t19*t21*t66*t9+1.6711932865267184d+2*t19*t21
     >         *t65*t9
            t93 = -1.6711932865267184d+2*t17*t77*t89*t9+1.51926662411519
     1         86d+1*t48*t87*t9-1.5192666241151986d+1*t16*t46*t87*t9+3.0
     2         38533248230397d+1*t16*t46*t86*t9-3.038533248230397d+1*t43
     3         *t45*t86*t9+4.5577998723455965d+1*t43*t45*t85*t9-4.557799
     4         8723455965d+1*t40*t42*t85*t9+6.077066496460795d+1*t40*t42
     5         *t84*t9-6.077066496460795d+1*t37*t39*t84*t9+7.59633312057
     6         5993d+1*t37*t39*t83*t9-7.596333120575993d+1*t34*t36*t83*t
     7         9+9.115599744691193d+1*t34*t36*t82*t9-9.115599744691193d+
     8         1*t31*t33*t82*t9+1.0634866368806391d+2*t31*t33*t81*t9-1.0
     9         634866368806391d+2*t28*t30*t81*t9+1.2154132992921589d+2*t
     :         28*t30*t80*t9-1.2154132992921589d+2*t25*t27*t80*t9+1.3673
     ;         399617036788d+2*t25*t27*t79*t9-1.3673399617036788d+2*t22*
     <         t24*t79*t9+1.5192666241151986d+2*t22*t24*t78*t9-1.5192666
     =         241151986d+2*t19*t21*t78*t9+1.6711932865267184d+2*t19*t21
     >         *t77*t9
            t94 = 1/t2**2
            t95 = 1/rhoa**2.3333333333333334d+0
            t96 = 1/t4
            t97 = rhoa**2
            t98 = 1/t97
            t99 = 2.63857249068588d-4*t98-4.2759414617680735d-2*t96
            t100 = 5.641895835477563d-1
            t101 = 1/t9
            t102 = t10*t99-2.63857249068588d-4*t98+6.41391219265211d-2*t
     1         96-1.6205510657228786d+2*t10*t6*t8+3.6846026734116505d+1*
     2         t10*t100*t101
            t103 = 1.4253138205893576d-2*t11*t96-4.275941461768073d-2*t1
     1         02*t6
            t104 = 1/rhoa**3.6666666666666664d+0
            t105 = 1.2407009817988002d+0*t12*t5-1.2407009817988002d+0*t5
     1         +9.305257363491002d-1*t103*t4
            t106 = -2.2d+1*t13*t17*t89-2.0d+0*t47*t48-2.0d+0*t16*t46*t47
     1         -4.0d+0*t16*t44*t46-4.0d+0*t43*t44*t45-6.0d+0*t41*t43*t45
     2         -6.0d+0*t40*t41*t42-8.0d+0*t38*t40*t42-8.0d+0*t37*t38*t39
     3         -1.0d+1*t35*t37*t39-1.0d+1*t34*t35*t36-1.2d+1*t32*t34*t36
     4         -1.2d+1*t31*t32*t33-1.4d+1*t29*t31*t33-1.4d+1*t28*t29*t30
     5         -1.6d+1*t26*t28*t30-1.6d+1*t25*t26*t27-1.8d+1*t23*t25*t27
     6         -1.8d+1*t22*t23*t24-2.0d+1*t20*t22*t24-2.0d+1*t19*t20*t21
     7         -2.2d+1*t13*t19*t21
            t107 = -2.2d+1*t17*t52*t89-2.0d+0*t48*t62-2.0d+0*t16*t46*t62
     1         -4.0d+0*t16*t46*t61-4.0d+0*t43*t45*t61-6.0d+0*t43*t45*t60
     2         -6.0d+0*t40*t42*t60-8.0d+0*t40*t42*t59-8.0d+0*t37*t39*t59
     3         -1.0d+1*t37*t39*t58-1.0d+1*t34*t36*t58-1.2d+1*t34*t36*t57
     4         -1.2d+1*t31*t33*t57-1.4d+1*t31*t33*t56-1.4d+1*t28*t30*t56
     5         -1.6d+1*t28*t30*t55-1.6d+1*t25*t27*t55-1.8d+1*t25*t27*t54
     6         -1.8d+1*t22*t24*t54-2.0d+1*t22*t24*t53-2.0d+1*t19*t21*t53
     7         -2.2d+1*t19*t21*t52
            t108 = -2.2d+1*t17*t65*t89-2.0d+0*t48*t75-2.0d+0*t16*t46*t75
     1         -4.0d+0*t16*t46*t74-4.0d+0*t43*t45*t74-6.0d+0*t43*t45*t73
     2         -6.0d+0*t40*t42*t73-8.0d+0*t40*t42*t72-8.0d+0*t37*t39*t72
     3         -1.0d+1*t37*t39*t71-1.0d+1*t34*t36*t71-1.2d+1*t34*t36*t70
     4         -1.2d+1*t31*t33*t70-1.4d+1*t31*t33*t69-1.4d+1*t28*t30*t69
     5         -1.6d+1*t28*t30*t68-1.6d+1*t25*t27*t68-1.8d+1*t25*t27*t67
     6         -1.8d+1*t22*t24*t67-2.0d+1*t22*t24*t66-2.0d+1*t19*t21*t66
     7         -2.2d+1*t19*t21*t65
            t109 = -2.2d+1*t17*t77*t89-2.0d+0*t48*t87-2.0d+0*t16*t46*t87
     1         -4.0d+0*t16*t46*t86-4.0d+0*t43*t45*t86-6.0d+0*t43*t45*t85
     2         -6.0d+0*t40*t42*t85-8.0d+0*t40*t42*t84-8.0d+0*t37*t39*t84
     3         -1.0d+1*t37*t39*t83-1.0d+1*t34*t36*t83-1.2d+1*t34*t36*t82
     4         -1.2d+1*t31*t33*t82-1.4d+1*t31*t33*t81-1.4d+1*t28*t30*t81
     5         -1.6d+1*t28*t30*t80-1.6d+1*t25*t27*t80-1.8d+1*t25*t27*t79
     6         -1.8d+1*t22*t24*t79-2.0d+1*t22*t24*t78-2.0d+1*t19*t21*t78
     7         -2.2d+1*t19*t21*t77
            t110 = 1/t18**13
            t111 = -1.1141288576844789d+2*t13*t17*t6*t89+2.5389881826654
     1         315d+4*t20*t21*t4*t89-5.585774001863949d+4*t13*t21*t4*t89
     2         +1.0128444160767991d+1*t47*t48*t6-1.0128444160767991d+1*t
     3         16*t46*t47*t6+2.0256888321535982d+1*t16*t44*t46*t6-2.0256
     4         888321535982d+1*t43*t44*t45*t6+3.038533248230397d+1*t41*t
     5         43*t45*t6-3.038533248230397d+1*t40*t41*t42*t6+4.051377664
     6         3071964d+1*t38*t40*t42*t6-4.0513776643071964d+1*t37*t38*t
     7         39*t6+5.064222080383994d+1*t35*t37*t39*t6-5.0642220803839
     8         94d+1*t34*t35*t36*t6+6.077066496460795d+1*t32*t34*t36*t6-
     9         6.077066496460795d+1*t31*t32*t33*t6+7.089910912537593d+1*
     :         t29*t31*t33*t6-7.089910912537593d+1*t28*t29*t30*t6+8.1027
     ;         55328614393d+1*t26*t28*t30*t6-8.102755328614393d+1*t25*t2
     <         6*t27*t6+9.115599744691191d+1*t23*t25*t27*t6-9.1155997446
     =         91191d+1*t22*t23*t24*t6+1.012844416076799d+2*t20*t22*t24*
     >         t6-1.012844416076799d+2*t19*t20*t21*t6+1.1141288576844789
     ?         d+2*t13*t19*t21*t6-4.6163421503007845d+2*t4*t46*t47+4.616
     @         3421503007845d+2*t16*t4*t43*t47+4.6163421503007845d+2*t4*
     1         t44*t46+1.3849026450902355d+3*t4*t40*t44*t45-4.1547079352
     2         707067d+3*t4*t40*t41*t45+2.769805290180471d+3*t38*t4*t40*
     3         t45-1.846536860120314d+3*t16*t4*t43*t44+1.384902645090235
     4         5d+3*t16*t4*t41*t43+2.769805290180471d+3*t37*t4*t41*t42-7
     5         .386147440481255d+3*t37*t38*t4*t42+4.616342150300784d+3*t
     6         35*t37*t4*t42+4.616342150300784d+3*t34*t38*t39*t4-1.15408
     7         5537575196d+4*t34*t35*t39*t4+6.924513225451178d+3*t32*t34
     8         *t39*t4+6.924513225451178d+3*t31*t35*t36*t4-1.66188317410
     9         8283d+4*t31*t32*t36*t4+9.694318515631648d+3*t29*t31*t36*t
     :         4+9.694318515631648d+3*t28*t32*t33*t4-2.2620076536473846d
     ;         +4*t28*t29*t33*t4+1.2925758020842196d+4*t26*t28*t33*t4+1.
     <         2925758020842196d+4*t25*t29*t30*t4-2.954458976192502d+4*t
     =         25*t26*t30*t4+1.6618831741082823d+4*t23*t25*t30*t4+1.6618
     >         831741082823d+4*t22*t26*t27*t4-3.7392371417436354d+4*t22*
     ?         t23*t27*t4+2.0773539676353528d+4*t20*t22*t27*t4+2.0773539
     @         676353528d+4*t19*t23*t24*t4-4.616342150300784d+4*t19*t20*
     1         t24*t4+2.5389881826654315d+4*t13*t19*t24*t4+3.04678581919
     2         8518d+4*t110*t13*t17*t4
            t112 = -1.1141288576844789d+2*t17*t52*t6*t89+2.5389881826654
     1         315d+4*t21*t4*t53*t89-5.585774001863949d+4*t21*t4*t52*t89
     2         +1.0128444160767991d+1*t48*t6*t62-1.0128444160767991d+1*t
     3         16*t46*t6*t62-4.6163421503007845d+2*t4*t46*t62+4.61634215
     4         03007845d+2*t16*t4*t43*t62+2.0256888321535982d+1*t16*t46*
     5         t6*t61-2.0256888321535982d+1*t43*t45*t6*t61+4.61634215030
     6         07845d+2*t4*t46*t61+1.3849026450902355d+3*t4*t40*t45*t61-
     7         1.846536860120314d+3*t16*t4*t43*t61+3.038533248230397d+1*
     8         t43*t45*t6*t60-3.038533248230397d+1*t40*t42*t6*t60-4.1547
     9         079352707067d+3*t4*t40*t45*t60+1.3849026450902355d+3*t16*
     :         t4*t43*t60+2.769805290180471d+3*t37*t4*t42*t60+4.05137766
     ;         43071964d+1*t40*t42*t59*t6-4.0513776643071964d+1*t37*t39*
     <         t59*t6+5.064222080383994d+1*t37*t39*t58*t6-5.064222080383
     =         994d+1*t34*t36*t58*t6+6.077066496460795d+1*t34*t36*t57*t6
     >         -6.077066496460795d+1*t31*t33*t57*t6+7.089910912537593d+1
     ?         *t31*t33*t56*t6-7.089910912537593d+1*t28*t30*t56*t6+8.102
     @         755328614393d+1*t28*t30*t55*t6-8.102755328614393d+1*t25*t
     1         27*t55*t6+9.115599744691191d+1*t25*t27*t54*t6-9.115599744
     2         691191d+1*t22*t24*t54*t6+1.012844416076799d+2*t22*t24*t53
     3         *t6-1.012844416076799d+2*t19*t21*t53*t6+1.114128857684478
     4         9d+2*t19*t21*t52*t6+2.769805290180471d+3*t4*t40*t45*t59-7
     5         .386147440481255d+3*t37*t4*t42*t59+4.616342150300784d+3*t
     6         34*t39*t4*t59+4.616342150300784d+3*t37*t4*t42*t58-1.15408
     7         5537575196d+4*t34*t39*t4*t58+6.924513225451178d+3*t31*t36
     8         *t4*t58+6.924513225451178d+3*t34*t39*t4*t57-1.66188317410
     9         8283d+4*t31*t36*t4*t57+9.694318515631648d+3*t28*t33*t4*t5
     :         7+9.694318515631648d+3*t31*t36*t4*t56-2.2620076536473846d
     ;         +4*t28*t33*t4*t56+1.2925758020842196d+4*t25*t30*t4*t56+1.
     <         2925758020842196d+4*t28*t33*t4*t55-2.954458976192502d+4*t
     =         25*t30*t4*t55+1.6618831741082823d+4*t22*t27*t4*t55+1.6618
     >         831741082823d+4*t25*t30*t4*t54-3.7392371417436354d+4*t22*
     ?         t27*t4*t54+2.0773539676353528d+4*t19*t24*t4*t54+2.0773539
     @         676353528d+4*t22*t27*t4*t53-4.616342150300784d+4*t19*t24*
     1         t4*t53+2.5389881826654315d+4*t19*t24*t4*t52+3.04678581919
     2         8518d+4*t110*t17*t4*t52
            t113 = 2.5389881826654315d+4*t21*t4*t66*t89-1.11412885768447
     1         89d+2*t17*t6*t65*t89-5.585774001863949d+4*t21*t4*t65*t89+
     2         1.0128444160767991d+1*t48*t6*t75-1.0128444160767991d+1*t1
     3         6*t46*t6*t75-4.6163421503007845d+2*t4*t46*t75+4.616342150
     4         3007845d+2*t16*t4*t43*t75+2.0256888321535982d+1*t16*t46*t
     5         6*t74-2.0256888321535982d+1*t43*t45*t6*t74+4.616342150300
     6         7845d+2*t4*t46*t74+1.3849026450902355d+3*t4*t40*t45*t74-1
     7         .846536860120314d+3*t16*t4*t43*t74+3.038533248230397d+1*t
     8         43*t45*t6*t73-3.038533248230397d+1*t40*t42*t6*t73-4.15470
     9         79352707067d+3*t4*t40*t45*t73+1.3849026450902355d+3*t16*t
     :         4*t43*t73+2.769805290180471d+3*t37*t4*t42*t73+4.051377664
     ;         3071964d+1*t40*t42*t6*t72-4.0513776643071964d+1*t37*t39*t
     <         6*t72+2.769805290180471d+3*t4*t40*t45*t72-7.3861474404812
     =         55d+3*t37*t4*t42*t72+4.616342150300784d+3*t34*t39*t4*t72+
     >         5.064222080383994d+1*t37*t39*t6*t71-5.064222080383994d+1*
     ?         t34*t36*t6*t71+4.616342150300784d+3*t37*t4*t42*t71-1.1540
     @         85537575196d+4*t34*t39*t4*t71+6.924513225451178d+3*t31*t3
     1         6*t4*t71+6.077066496460795d+1*t34*t36*t6*t70-6.0770664964
     2         60795d+1*t31*t33*t6*t70+6.924513225451178d+3*t34*t39*t4*t
     3         70-1.661883174108283d+4*t31*t36*t4*t70+9.694318515631648d
     4         +3*t28*t33*t4*t70+7.089910912537593d+1*t31*t33*t6*t69-7.0
     5         89910912537593d+1*t28*t30*t6*t69+9.694318515631648d+3*t31
     6         *t36*t4*t69-2.2620076536473846d+4*t28*t33*t4*t69+1.292575
     7         8020842196d+4*t25*t30*t4*t69+8.102755328614393d+1*t28*t30
     8         *t6*t68-8.102755328614393d+1*t25*t27*t6*t68+1.29257580208
     9         42196d+4*t28*t33*t4*t68-2.954458976192502d+4*t25*t30*t4*t
     :         68+1.6618831741082823d+4*t22*t27*t4*t68+9.115599744691191
     ;         d+1*t25*t27*t6*t67-9.115599744691191d+1*t22*t24*t6*t67+1.
     <         6618831741082823d+4*t25*t30*t4*t67-3.7392371417436354d+4*
     =         t22*t27*t4*t67+2.0773539676353528d+4*t19*t24*t4*t67+1.012
     >         844416076799d+2*t22*t24*t6*t66-1.012844416076799d+2*t19*t
     ?         21*t6*t66+2.0773539676353528d+4*t22*t27*t4*t66-4.61634215
     @         0300784d+4*t19*t24*t4*t66+1.1141288576844789d+2*t19*t21*t
     1         6*t65+2.5389881826654315d+4*t19*t24*t4*t65+3.046785819198
     2         518d+4*t110*t17*t4*t65
            t114 = 2.5389881826654315d+4*t21*t4*t78*t89-1.11412885768447
     1         89d+2*t17*t6*t77*t89-5.585774001863949d+4*t21*t4*t77*t89+
     2         1.0128444160767991d+1*t48*t6*t87-1.0128444160767991d+1*t1
     3         6*t46*t6*t87-4.6163421503007845d+2*t4*t46*t87+4.616342150
     4         3007845d+2*t16*t4*t43*t87+2.0256888321535982d+1*t16*t46*t
     5         6*t86-2.0256888321535982d+1*t43*t45*t6*t86+4.616342150300
     6         7845d+2*t4*t46*t86+1.3849026450902355d+3*t4*t40*t45*t86-1
     7         .846536860120314d+3*t16*t4*t43*t86+3.038533248230397d+1*t
     8         43*t45*t6*t85-3.038533248230397d+1*t40*t42*t6*t85-4.15470
     9         79352707067d+3*t4*t40*t45*t85+1.3849026450902355d+3*t16*t
     :         4*t43*t85+2.769805290180471d+3*t37*t4*t42*t85+4.051377664
     ;         3071964d+1*t40*t42*t6*t84-4.0513776643071964d+1*t37*t39*t
     <         6*t84+2.769805290180471d+3*t4*t40*t45*t84-7.3861474404812
     =         55d+3*t37*t4*t42*t84+4.616342150300784d+3*t34*t39*t4*t84+
     >         5.064222080383994d+1*t37*t39*t6*t83-5.064222080383994d+1*
     ?         t34*t36*t6*t83+4.616342150300784d+3*t37*t4*t42*t83-1.1540
     @         85537575196d+4*t34*t39*t4*t83+6.924513225451178d+3*t31*t3
     1         6*t4*t83+6.077066496460795d+1*t34*t36*t6*t82-6.0770664964
     2         60795d+1*t31*t33*t6*t82+6.924513225451178d+3*t34*t39*t4*t
     3         82-1.661883174108283d+4*t31*t36*t4*t82+9.694318515631648d
     4         +3*t28*t33*t4*t82+7.089910912537593d+1*t31*t33*t6*t81-7.0
     5         89910912537593d+1*t28*t30*t6*t81+9.694318515631648d+3*t31
     6         *t36*t4*t81-2.2620076536473846d+4*t28*t33*t4*t81+1.292575
     7         8020842196d+4*t25*t30*t4*t81+8.102755328614393d+1*t28*t30
     8         *t6*t80-8.102755328614393d+1*t25*t27*t6*t80+1.29257580208
     9         42196d+4*t28*t33*t4*t80-2.954458976192502d+4*t25*t30*t4*t
     :         80+1.6618831741082823d+4*t22*t27*t4*t80+9.115599744691191
     ;         d+1*t25*t27*t6*t79-9.115599744691191d+1*t22*t24*t6*t79+1.
     <         6618831741082823d+4*t25*t30*t4*t79-3.7392371417436354d+4*
     =         t22*t27*t4*t79+2.0773539676353528d+4*t19*t24*t4*t79+1.012
     >         844416076799d+2*t22*t24*t6*t78-1.012844416076799d+2*t19*t
     ?         21*t6*t78+2.0773539676353528d+4*t22*t27*t4*t78-4.61634215
     @         0300784d+4*t19*t24*t4*t78+1.1141288576844789d+2*t19*t21*t
     1         6*t77+2.5389881826654315d+4*t19*t24*t4*t77+3.046785819198
     2         518d+4*t110*t17*t4*t77
            t115 = gammaaa**2
            t116 = 1/t2**3
            t117 = 1/rhoa**6
            t118 = 1/rhoa**3.3333333333333337d+0
            t119 = 1/rhoa**3
            t120 = 5.701255282357431d-2*t95-5.27714498137176d-4*t119
            t121 = 1/t14
            t122 = -3.241102131445757d+2*t10*t6*t99+5.401836885742928d+1
     1         *t10*t8*t96-8.551882923536147d-2*t95+2.626185756615557d+4
     2         *t10*t101*t8-5.971086789162617d+3*t10*t100*t7-2.456401782
     3         2744336d+1*t10*t100*t121+t10*t120+5.27714498137176d-4*t11
     4         9
            t123 = 2.850627641178715d-2*t102*t96-1.9004184274524766d-2*t
     1         11*t95-4.275941461768073d-2*t122*t6
            t124 = 1/rhoa**7.333333333333333d+0
            t125 = 1/rhoa**4.666666666666667d+0
            t126 = 2.4814019635976003d+0*t103*t5+9.305257363491002d-1*t1
     1         23*t4+4.135669939329334d-1*t101*t12-4.135669939329334d-1*
     2         t101
            t127 = 1.7926167019779404d-2*gammaaa*t12*t90+1.7926167019779
     1         404d-2*gammaaa*t103*t49
            t128 = -4.135669939329334d-1*t12*t51*t63-4.135669939329334d-
     1         1*t12*t3*t49
            t129 = 1.0082032889066277d-2*gammaaa*t12*t50*t91+1.008203288
     1         9066277d-2*gammaaa*t103*t50*t63
            t130 = -1.9264558001493193d-2*gammaaa*t64*t92-1.926455800149
     1         3193d-2*gammaaa*t105*t76
            t131 = -1.0834770598202839d-2*gammaaa*t50*t64*t93-1.08347705
     1         98202839d-2*gammaaa*t105*t50*t88
            t132 = 1/rhoa**5
            t133 = 1/rhoa**6.333333333333333d+0
            t134 = -3.361156316208638d-3*t12*t90-3.361156316208638d-3*t1
     1         03*t49
            t135 = 3.612104625279974d-3*t64*t92+3.612104625279974d-3*t10
     1         5*t76
            t136 = 1/rhoa**4
            t137 = 1/rhoa**5.333333333333333d+0
            t138 = 3.342386573053437d+3*t20*t21*t89*t9+6.077066496460795
     1         d+1*t16*t43*t47*t9-6.077066496460795d+1*t44*t46*t9+1.8231
     2         199489382385d+2*t40*t44*t45*t9-3.646239897876477d+2*t38*t
     3         40*t45*t9-1.8231199489382385d+2*t16*t41*t43*t9+3.64623989
     4         7876477d+2*t37*t41*t42*t9-6.077066496460795d+2*t35*t37*t4
     5         2*t9+6.077066496460795d+2*t34*t38*t39*t9-9.11559974469119
     6         2d+2*t32*t34*t39*t9+9.115599744691192d+2*t31*t35*t36*t9-1
     7         .276183964256767d+3*t29*t31*t36*t9+1.276183964256767d+3*t
     8         28*t32*t33*t9-1.7015786190090226d+3*t26*t28*t33*t9+1.7015
     9         786190090226d+3*t25*t29*t30*t9-2.187743938725886d+3*t23*t
     :         25*t30*t9+2.187743938725886d+3*t22*t26*t27*t9-2.734679923
     ;         407357d+3*t20*t22*t27*t9+2.734679923407357d+3*t19*t23*t24
     <         *t9-3.342386573053437d+3*t13*t19*t24*t9+4.010863887664124
     =         5d+3*t110*t13*t17*t9
            t139 = 3.342386573053437d+3*t21*t53*t89*t9+6.077066496460795
     1         d+1*t16*t43*t62*t9-6.077066496460795d+1*t46*t61*t9+1.8231
     2         199489382385d+2*t40*t45*t61*t9-1.8231199489382385d+2*t16*
     3         t43*t60*t9+3.646239897876477d+2*t37*t42*t60*t9-3.64623989
     4         7876477d+2*t40*t45*t59*t9+6.077066496460795d+2*t34*t39*t5
     5         9*t9-6.077066496460795d+2*t37*t42*t58*t9+9.11559974469119
     6         2d+2*t31*t36*t58*t9-9.115599744691192d+2*t34*t39*t57*t9+1
     7         .276183964256767d+3*t28*t33*t57*t9-1.276183964256767d+3*t
     8         31*t36*t56*t9+1.7015786190090226d+3*t25*t30*t56*t9-1.7015
     9         786190090226d+3*t28*t33*t55*t9+2.187743938725886d+3*t22*t
     :         27*t55*t9-2.187743938725886d+3*t25*t30*t54*t9+2.734679923
     ;         407357d+3*t19*t24*t54*t9-2.734679923407357d+3*t22*t27*t53
     <         *t9-3.342386573053437d+3*t19*t24*t52*t9+4.010863887664124
     =         5d+3*t110*t17*t52*t9
            t140 = 3.342386573053437d+3*t21*t66*t89*t9+6.077066496460795
     1         d+1*t16*t43*t75*t9-6.077066496460795d+1*t46*t74*t9+1.8231
     2         199489382385d+2*t40*t45*t74*t9-1.8231199489382385d+2*t16*
     3         t43*t73*t9+3.646239897876477d+2*t37*t42*t73*t9-3.64623989
     4         7876477d+2*t40*t45*t72*t9+6.077066496460795d+2*t34*t39*t7
     5         2*t9-6.077066496460795d+2*t37*t42*t71*t9+9.11559974469119
     6         2d+2*t31*t36*t71*t9-9.115599744691192d+2*t34*t39*t70*t9+1
     7         .276183964256767d+3*t28*t33*t70*t9-1.276183964256767d+3*t
     8         31*t36*t69*t9+1.7015786190090226d+3*t25*t30*t69*t9-1.7015
     9         786190090226d+3*t28*t33*t68*t9+2.187743938725886d+3*t22*t
     :         27*t68*t9-2.187743938725886d+3*t25*t30*t67*t9+2.734679923
     ;         407357d+3*t19*t24*t67*t9-2.734679923407357d+3*t22*t27*t66
     <         *t9-3.342386573053437d+3*t19*t24*t65*t9+4.010863887664124
     =         5d+3*t110*t17*t65*t9
            t141 = 3.342386573053437d+3*t21*t78*t89*t9+6.077066496460795
     1         d+1*t16*t43*t87*t9-6.077066496460795d+1*t46*t86*t9+1.8231
     2         199489382385d+2*t40*t45*t86*t9-1.8231199489382385d+2*t16*
     3         t43*t85*t9+3.646239897876477d+2*t37*t42*t85*t9-3.64623989
     4         7876477d+2*t40*t45*t84*t9+6.077066496460795d+2*t34*t39*t8
     5         4*t9-6.077066496460795d+2*t37*t42*t83*t9+9.11559974469119
     6         2d+2*t31*t36*t83*t9-9.115599744691192d+2*t34*t39*t82*t9+1
     7         .276183964256767d+3*t28*t33*t82*t9-1.276183964256767d+3*t
     8         31*t36*t81*t9+1.7015786190090226d+3*t25*t30*t81*t9-1.7015
     9         786190090226d+3*t28*t33*t80*t9+2.187743938725886d+3*t22*t
     :         27*t80*t9-2.187743938725886d+3*t25*t30*t79*t9+2.734679923
     ;         407357d+3*t19*t24*t79*t9-2.734679923407357d+3*t22*t27*t78
     <         *t9-3.342386573053437d+3*t19*t24*t77*t9+4.010863887664124
     =         5d+3*t110*t17*t77*t9
            t142 = 1/t18**14
            t143 = gammaaa**3
            t144 = 1/t2**4
            t145 = 1/rhoa**9.666666666666666d+0
            t146 = 1/rhoa**7
            t147 = 1/rhoa**4.333333333333333d+0
            t148 = -4.275941461768073d-2*t6*(1.6205510657228786d+2*t10*t
     1         96*t99+7.878557269846671d+4*t10*t101*t99+9.95181131527102
     2         9d+3*t10*t100*t98+9.676451059701281d+5*t10*t100*t96-7.202
     3         44918099057d+1*t10*t8*t95-4.255868126669586d+6*t10*t7*t8-
     4         2.626185756615557d+4*t10*t121*t8-4.8616531971686355d+2*t1
     5         0*t120*t6-1.5831434944115283d-3*t136+t10*(1.5831434944115
     6         283d-3*t136-1.330292899216734d-1*t118)+1.995439348825101d
     7         -1*t118+4.0940029704573894d+1*t1*t10*t100)+4.275941461768
     8         0724d-2*t122*t96-5.701255282357429d-2*t102*t95+4.43430966
     9         4055779d-2*t11*t118
            t149 = 1/rhoa**11
            t150 = 1/rhoa**8.333333333333334d+0
            t151 = 1/rhoa**5.666666666666667d+0
            t152 = 3.7221029453964005d+0*t123*t5+9.305257363491002d-1*t1
     1         48*t4-2.7571132928862224d-1*t12*t121+2.7571132928862224d-
     2         1*t121+1.2407009817988002d+0*t101*t103
            t153 = 1/rhoa**8.666666666666666d+0
            t154 = 1/rhoa**10
            t155 = 1/rhoa**7.666666666666667d+0
            t156 = 1/rhoa**9
            t157 = 1/rhoa**6.666666666666667d+0
            t158 = 1/rhoa**8
            fnc(iq) = 2.0d+0*(t51*t64*t88+t3*t64*t76-9.305257363491002d-
     1         1*t12*t4*t51*t63-9.305257363491002d-1*t12*t3*t4*t49)*wght
     2         +fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(8.963083509889702d-3*gammaaa*t12*t4
     1         9*t94*t95+5.041016444533138d-3*gammaaa*t12*t50*t63*t95-9.
     2         632279000746596d-3*gammaaa*t104*t64*t76*t94+t51*t64*t93+t
     3         3*t64*t92-9.305257363491002d-1*t12*t4*t51*t91-9.305257363
     4         491002d-1*t12*t3*t4*t90-5.417385299101419d-3*gammaaa*t104
     5         *t50*t64*t88+t105*t51*t88+t105*t3*t76-1.2407009817988002d
     6         +0*t12*t5*t51*t63-9.305257363491002d-1*t103*t4*t51*t63-1.
     7         2407009817988002d+0*t12*t3*t49*t5-9.305257363491002d-1*t1
     8         03*t3*t4*t49)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(-3.361156316208638d-3*t12*t49*t94*
     1         t96-1.890381166699927d-3*t12*t50*t63*t96+3.61210462527997
     2         4d-3*t1*t64*t76*t94+2.0315194871630324d-3*t1*t50*t64*t88)
     3         *wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Mmat(iq,D1_TA) = 1.0d+0*(t109*t51*t64+t108*t3*t64-9.30525736
     1         3491002d-1*t107*t12*t4*t51-9.305257363491002d-1*t106*t12*
     2         t3*t4)*wght+Mmat(iq,D1_TA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(t127*t94*t95+t129*t95+3.5318356
     1         336070855d-2*gammaaa*t125*t64*t76*t94-8.963083509889707d-
     2         3*gammaaa*t118*t12*t49*t94+t104*t130*t94+2*t105*t51*t93+2
     3         *t105*t3*t92-2.4814019635976003d+0*t12*t5*t51*t91-1.86105
     4         14726982003d+0*t103*t4*t51*t91-2.4814019635976003d+0*t12*
     5         t3*t5*t90-1.8610514726982003d+0*t103*t3*t4*t90+1.98637460
     6         96705204d-2*gammaaa*t125*t50*t64*t88-5.316678166471045d-5
     7         *t115*t124*t50*t64*t88+t126*t51*t88-2.3079800683637772d-4
     8         *t115*t116*t124*t64*t76+t126*t3*t76+t114*t51*t64+t113*t3*
     9         t64-2.4814019635976003d+0*t103*t5*t51*t63-9.3052573634910
     :         02d-1*t123*t4*t51*t63-5.041016444533138d-3*gammaaa*t118*t
     ;         12*t50*t63+4.947305865786653d-5*t115*t117*t12*t50*t63-9.3
     <         05257363491002d-1*t112*t12*t4*t51-2.4814019635976003d+0*t
     =         103*t3*t49*t5-9.305257363491002d-1*t123*t3*t4*t49+2.14763
     >         48525932504d-4*t115*t116*t117*t12*t49-9.305257363491002d-
     ?         1*t111*t12*t3*t4+t104*t131+t101*t128)*wght+Amat2(iq,D2_RA
     @         _RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(t134*t94*t96+(-1.8903811666999
     1         27d-3*t12*t50*t91-1.890381166699927d-3*t103*t50*t63)*t96+
     2         4.481541754944851d-3*t12*t49*t94*t95+2.520508222266569d-3
     3         *t12*t50*t63*t95-9.632279000746596d-3*t104*t64*t76*t94+t1
     4         *t135*t94+t1*(2.0315194871630324d-3*t50*t64*t93+2.0315194
     5         871630324d-3*t105*t50*t88)+1.9937543124266421d-5*gammaaa*
     6         t133*t50*t64*t88-5.417385299101419d-3*t104*t50*t64*t88+8.
     7         654925256364164d-5*gammaaa*t116*t133*t64*t76-1.8552396996
     8         69995d-5*gammaaa*t12*t132*t50*t63-8.05363069722469d-5*gam
     9         maaa*t116*t12*t132*t49)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(-7.476578671599909d-6*t137*t5
     1         0*t64*t88-3.245596971136562d-5*t116*t137*t64*t76+6.957148
     2         873762482d-6*t12*t136*t50*t63+3.020111511459258d-5*t116*t
     3         12*t136*t49)*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Mmat2(iq,D2_RA_TA) = 1.0d+0*(8.963083509889702d-3*gammaaa*t1
     1         06*t12*t94*t95+5.041016444533138d-3*gammaaa*t107*t12*t50*
     2         t95-9.632279000746596d-3*gammaaa*t104*t108*t64*t94+t141*t
     3         51*t64-5.417385299101419d-3*gammaaa*t104*t109*t50*t64+t14
     4         0*t3*t64-1.2407009817988002d+0*t107*t12*t5*t51-9.30525736
     5         3491002d-1*t12*t139*t4*t51-9.305257363491002d-1*t103*t107
     6         *t4*t51+t105*t109*t51-1.2407009817988002d+0*t106*t12*t3*t
     7         5-9.305257363491002d-1*t12*t138*t3*t4-9.305257363491002d-
     8         1*t103*t106*t3*t4+t105*t108*t3)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = 1.0d+0*(-3.361156316208638d-3*t106*t12
     1         *t94*t96-1.890381166699927d-3*t107*t12*t50*t96+3.61210462
     2         5279974d-3*t1*t108*t64*t94+2.0315194871630324d-3*t1*t109*
     3         t50*t64)*wght+Mmat2(iq,D2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_TA_TA) = 1.0d+0*(t51*t64*(4.4d+2*t21*t78*t89+9.6
     1         8d+2*t21*t77*t89+8.0d+0*t46*t87+8.0d+0*t16*t43*t87+8.0d+0
     2         *t46*t86+2.4d+1*t40*t45*t86+3.2d+1*t16*t43*t86+7.2d+1*t40
     3         *t45*t85+2.4d+1*t16*t43*t85+4.8d+1*t37*t42*t85+4.8d+1*t40
     4         *t45*t84+1.28d+2*t37*t42*t84+8.0d+1*t34*t39*t84+8.0d+1*t3
     5         7*t42*t83+2.0d+2*t34*t39*t83+1.2d+2*t31*t36*t83+1.2d+2*t3
     6         4*t39*t82+2.88d+2*t31*t36*t82+1.68d+2*t28*t33*t82+1.68d+2
     7         *t31*t36*t81+3.92d+2*t28*t33*t81+2.24d+2*t25*t30*t81+2.24
     8         d+2*t28*t33*t80+5.12d+2*t25*t30*t80+2.88d+2*t22*t27*t80+2
     9         .88d+2*t25*t30*t79+6.48d+2*t22*t27*t79+3.6d+2*t19*t24*t79
     :         +3.6d+2*t22*t27*t78+8.0d+2*t19*t24*t78+4.4d+2*t19*t24*t77
     ;         +5.28d+2*t110*t17*t77)+t3*t64*(4.4d+2*t21*t66*t89+9.68d+2
     <         *t21*t65*t89+8.0d+0*t46*t75+8.0d+0*t16*t43*t75+8.0d+0*t46
     =         *t74+2.4d+1*t40*t45*t74+3.2d+1*t16*t43*t74+7.2d+1*t40*t45
     >         *t73+2.4d+1*t16*t43*t73+4.8d+1*t37*t42*t73+4.8d+1*t40*t45
     ?         *t72+1.28d+2*t37*t42*t72+8.0d+1*t34*t39*t72+8.0d+1*t37*t4
     @         2*t71+2.0d+2*t34*t39*t71+1.2d+2*t31*t36*t71+1.2d+2*t34*t3
     1         9*t70+2.88d+2*t31*t36*t70+1.68d+2*t28*t33*t70+1.68d+2*t31
     2         *t36*t69+3.92d+2*t28*t33*t69+2.24d+2*t25*t30*t69+2.24d+2*
     3         t28*t33*t68+5.12d+2*t25*t30*t68+2.88d+2*t22*t27*t68+2.88d
     4         +2*t25*t30*t67+6.48d+2*t22*t27*t67+3.6d+2*t19*t24*t67+3.6
     5         d+2*t22*t27*t66+8.0d+2*t19*t24*t66+4.4d+2*t19*t24*t65+5.2
     6         8d+2*t110*t17*t65)-9.305257363491002d-1*t12*t4*t51*(4.4d+
     7         2*t21*t53*t89+9.68d+2*t21*t52*t89+8.0d+0*t46*t62+8.0d+0*t
     8         16*t43*t62+8.0d+0*t46*t61+2.4d+1*t40*t45*t61+3.2d+1*t16*t
     9         43*t61+7.2d+1*t40*t45*t60+2.4d+1*t16*t43*t60+4.8d+1*t37*t
     :         42*t60+4.8d+1*t40*t45*t59+1.28d+2*t37*t42*t59+8.0d+1*t34*
     ;         t39*t59+8.0d+1*t37*t42*t58+2.0d+2*t34*t39*t58+1.2d+2*t31*
     <         t36*t58+1.2d+2*t34*t39*t57+2.88d+2*t31*t36*t57+1.68d+2*t2
     =         8*t33*t57+1.68d+2*t31*t36*t56+3.92d+2*t28*t33*t56+2.24d+2
     >         *t25*t30*t56+2.24d+2*t28*t33*t55+5.12d+2*t25*t30*t55+2.88
     ?         d+2*t22*t27*t55+2.88d+2*t25*t30*t54+6.48d+2*t22*t27*t54+3
     @         .6d+2*t19*t24*t54+3.6d+2*t22*t27*t53+8.0d+2*t19*t24*t53+4
     1         .4d+2*t19*t24*t52+5.28d+2*t110*t17*t52)-9.305257363491002
     2         d-1*t12*t3*t4*(4.4d+2*t20*t21*t89+9.68d+2*t13*t21*t89+8.0
     3         d+0*t46*t47+8.0d+0*t16*t43*t47+8.0d+0*t44*t46+2.4d+1*t40*
     4         t44*t45+7.2d+1*t40*t41*t45+4.8d+1*t38*t40*t45+3.2d+1*t16*
     5         t43*t44+2.4d+1*t16*t41*t43+4.8d+1*t37*t41*t42+1.28d+2*t37
     6         *t38*t42+8.0d+1*t35*t37*t42+8.0d+1*t34*t38*t39+2.0d+2*t34
     7         *t35*t39+1.2d+2*t32*t34*t39+1.2d+2*t31*t35*t36+2.88d+2*t3
     8         1*t32*t36+1.68d+2*t29*t31*t36+1.68d+2*t28*t32*t33+3.92d+2
     9         *t28*t29*t33+2.24d+2*t26*t28*t33+2.24d+2*t25*t29*t30+5.12
     :         d+2*t25*t26*t30+2.88d+2*t23*t25*t30+2.88d+2*t22*t26*t27+6
     ;         .48d+2*t22*t23*t27+3.6d+2*t20*t22*t27+3.6d+2*t19*t23*t24+
     <         8.0d+2*t19*t20*t24+4.4d+2*t13*t19*t24+5.28d+2*t110*t13*t1
     =         7))*wght+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*(t51*t64*(-3.4716600044518436
     1         d+6*t24*t79*t89*t97+1.1572200014839477d+7*t24*t78*t89*t97
     2         -1.2729420016323426d+7*t24*t77*t89*t97+2.104036366334451d
     3         +4*t43*t87*t97-2.104036366334451d+4*t16*t40*t87*t97-8.416
     4         145465337804d+4*t37*t45*t86*t97-4.208072732668902d+4*t43*
     5         t86*t97+1.2624218198006704d+5*t16*t40*t86*t97+3.787265459
     6         402013d+5*t37*t45*t85*t97+2.104036366334451d+4*t43*t85*t9
     7         7-2.104036366334451d+5*t34*t42*t85*t97-1.8936327297010064
     8         d+5*t16*t40*t85*t97-5.049687279202681d+5*t37*t45*t84*t97+
     9         8.416145465337803d+5*t34*t42*t84*t97+8.416145465337804d+4
     :         *t16*t40*t84*t97-4.2080727326689016d+5*t31*t39*t84*t97+2.
     ;         1040363663344508d+5*t37*t45*t83*t97-1.0520181831672254d+6
     <         *t34*t42*t83*t97+1.578027274750838d+6*t31*t39*t83*t97-7.3
     =         64127282170578d+5*t28*t36*t83*t97+4.208072732668902d+5*t3
     >         4*t42*t82*t97-1.893632729701006d+6*t31*t39*t82*t97+2.6510
     ?         858215814087d+6*t28*t36*t82*t97-1.1782603651472927d+6*t25
     @         *t33*t82*t97+7.364127282170578d+5*t31*t39*t81*t97-3.09293
     1         34585116436d+6*t28*t36*t81*t97+4.123911278015524d+6*t25*t
     2         33*t81*t97-1.7673905477209387d+6*t22*t30*t81*t97+1.178260
     3         3651472927d+6*t28*t36*t80*t97-4.713041460589171d+6*t25*t3
     4         3*t80*t97+6.059624735043219d+6*t22*t30*t80*t97-2.52484363
     5         9601341d+6*t19*t27*t80*t97+1.767390547720939d+6*t25*t33*t
     6         79*t97-6.817077826923622d+6*t22*t30*t79*t97+8.52134728365
     7         4526d+6*t19*t27*t79*t97+2.524843639601341d+6*t22*t30*t78*
     8         t97-9.468163648505028d+6*t19*t27*t78*t97-4.62888000593579
     9         2d+6*t110*t21*t78*t97+3.4716600044518436d+6*t19*t27*t77*t
     :         97+1.5275304019588112d+7*t110*t21*t77*t97-6.0175440077165
     ;         3d+6*t142*t17*t77*t97+3.713762858948263d+1*t17*t77*t89*t9
     <         6-3.37614805358933d+0*t48*t87*t96+3.37614805358933d+0*t16
     =         *t46*t87*t96-6.75229610717866d+0*t16*t46*t86*t96+6.752296
     >         10717866d+0*t43*t45*t86*t96-1.0128444160767991d+1*t43*t45
     ?         *t85*t96+1.0128444160767991d+1*t40*t42*t85*t96-1.35045922
     @         1435732d+1*t40*t42*t84*t96+1.350459221435732d+1*t37*t39*t
     1         84*t96-1.6880740267946648d+1*t37*t39*t83*t96+1.6880740267
     2         946648d+1*t34*t36*t83*t96-2.0256888321535982d+1*t34*t36*t
     3         82*t96+2.0256888321535982d+1*t31*t33*t82*t96-2.3633036375
     4         125308d+1*t31*t33*t81*t96+2.3633036375125308d+1*t28*t30*t
     5         81*t96-2.700918442871464d+1*t28*t30*t80*t96+2.70091844287
     6         1464d+1*t25*t27*t80*t96-3.0385332482303967d+1*t25*t27*t79
     7         *t96+3.0385332482303967d+1*t22*t24*t79*t96-3.376148053589
     8         3296d+1*t22*t24*t78*t96+3.3761480535893296d+1*t19*t21*t78
     9         *t96-3.713762858948263d+1*t19*t21*t77*t96+5.0779763653308
     :         62d+4*t21*t5*t78*t89-1.1171548003727898d+5*t21*t5*t77*t89
     ;         -9.232684300601568d+2*t46*t5*t87+9.232684300601568d+2*t16
     <         *t43*t5*t87+9.232684300601568d+2*t46*t5*t86+2.76980529018
     =         0471d+3*t40*t45*t5*t86-3.693073720240627d+3*t16*t43*t5*t8
     >         6-8.309415870541413d+3*t40*t45*t5*t85+2.769805290180471d+
     ?         3*t16*t43*t5*t85+5.539610580360942d+3*t37*t42*t5*t85+5.53
     @         9610580360942d+3*t40*t45*t5*t84-1.4772294880962508d+4*t37
     1         *t42*t5*t84+9.232684300601568d+3*t34*t39*t5*t84+9.2326843
     2         00601568d+3*t37*t42*t5*t83-2.308171075150392d+4*t34*t39*t
     3         5*t83+1.3849026450902355d+4*t31*t36*t5*t83+1.384902645090
     4         2355d+4*t34*t39*t5*t82-3.323766348216566d+4*t31*t36*t5*t8
     5         2+1.9388637031263292d+4*t28*t33*t5*t82+1.9388637031263292
     6         d+4*t31*t36*t5*t81-4.5240153072947686d+4*t28*t33*t5*t81+2
     7         .585151604168439d+4*t25*t30*t5*t81+2.585151604168439d+4*t
     8         28*t33*t5*t80-5.908917952385003d+4*t25*t30*t5*t80+3.32376
     9         63482165647d+4*t22*t27*t5*t80+3.3237663482165647d+4*t25*t
     :         30*t5*t79-7.478474283487271d+4*t22*t27*t5*t79+4.154707935
     ;         2707056d+4*t19*t24*t5*t79+4.154707935270705d+4*t22*t27*t5
     <         *t78-9.232684300601568d+4*t19*t24*t5*t78+5.07797636533086
     =         3d+4*t19*t24*t5*t77+6.093571638397036d+4*t110*t17*t5*t77)
     >         +t3*t64*(-3.4716600044518436d+6*t24*t67*t89*t97+1.1572200
     ?         014839477d+7*t24*t66*t89*t97-1.2729420016323426d+7*t24*t6
     @         5*t89*t97+2.104036366334451d+4*t43*t75*t97-2.104036366334
     1         451d+4*t16*t40*t75*t97-8.416145465337804d+4*t37*t45*t74*t
     2         97-4.208072732668902d+4*t43*t74*t97+1.2624218198006704d+5
     3         *t16*t40*t74*t97+3.787265459402013d+5*t37*t45*t73*t97+2.1
     4         04036366334451d+4*t43*t73*t97-2.104036366334451d+5*t34*t4
     5         2*t73*t97-1.8936327297010064d+5*t16*t40*t73*t97-5.0496872
     6         79202681d+5*t37*t45*t72*t97+8.416145465337803d+5*t34*t42*
     7         t72*t97+8.416145465337804d+4*t16*t40*t72*t97-4.2080727326
     8         689016d+5*t31*t39*t72*t97+2.1040363663344508d+5*t37*t45*t
     9         71*t97-1.0520181831672254d+6*t34*t42*t71*t97+1.5780272747
     :         50838d+6*t31*t39*t71*t97-7.364127282170578d+5*t28*t36*t71
     ;         *t97+4.208072732668902d+5*t34*t42*t70*t97-1.8936327297010
     <         06d+6*t31*t39*t70*t97+2.6510858215814087d+6*t28*t36*t70*t
     =         97-1.1782603651472927d+6*t25*t33*t70*t97+7.36412728217057
     >         8d+5*t31*t39*t69*t97-3.0929334585116436d+6*t28*t36*t69*t9
     ?         7+4.123911278015524d+6*t25*t33*t69*t97-1.7673905477209387
     @         d+6*t22*t30*t69*t97+1.1782603651472927d+6*t28*t36*t68*t97
     1         -4.713041460589171d+6*t25*t33*t68*t97+6.059624735043219d+
     2         6*t22*t30*t68*t97-2.524843639601341d+6*t19*t27*t68*t97+1.
     3         767390547720939d+6*t25*t33*t67*t97-6.817077826923622d+6*t
     4         22*t30*t67*t97+8.521347283654526d+6*t19*t27*t67*t97+2.524
     5         843639601341d+6*t22*t30*t66*t97-9.468163648505028d+6*t19*
     6         t27*t66*t97-4.628880005935792d+6*t110*t21*t66*t97+3.47166
     7         00044518436d+6*t19*t27*t65*t97+1.5275304019588112d+7*t110
     8         *t21*t65*t97-6.01754400771653d+6*t142*t17*t65*t97+3.71376
     9         2858948263d+1*t17*t65*t89*t96-3.37614805358933d+0*t48*t75
     :         *t96+3.37614805358933d+0*t16*t46*t75*t96-6.75229610717866
     ;         d+0*t16*t46*t74*t96+6.75229610717866d+0*t43*t45*t74*t96-1
     <         .0128444160767991d+1*t43*t45*t73*t96+1.0128444160767991d+
     =         1*t40*t42*t73*t96-1.350459221435732d+1*t40*t42*t72*t96+1.
     >         350459221435732d+1*t37*t39*t72*t96-1.6880740267946648d+1*
     ?         t37*t39*t71*t96+1.6880740267946648d+1*t34*t36*t71*t96-2.0
     @         256888321535982d+1*t34*t36*t70*t96+2.0256888321535982d+1*
     1         t31*t33*t70*t96-2.3633036375125308d+1*t31*t33*t69*t96+2.3
     2         633036375125308d+1*t28*t30*t69*t96-2.700918442871464d+1*t
     3         28*t30*t68*t96+2.700918442871464d+1*t25*t27*t68*t96-3.038
     4         5332482303967d+1*t25*t27*t67*t96+3.0385332482303967d+1*t2
     5         2*t24*t67*t96-3.3761480535893296d+1*t22*t24*t66*t96+3.376
     6         1480535893296d+1*t19*t21*t66*t96-3.713762858948263d+1*t19
     7         *t21*t65*t96+5.077976365330862d+4*t21*t5*t66*t89-1.117154
     8         8003727898d+5*t21*t5*t65*t89-9.232684300601568d+2*t46*t5*
     9         t75+9.232684300601568d+2*t16*t43*t5*t75+9.232684300601568
     :         d+2*t46*t5*t74+2.769805290180471d+3*t40*t45*t5*t74-3.6930
     ;         73720240627d+3*t16*t43*t5*t74-8.309415870541413d+3*t40*t4
     <         5*t5*t73+2.769805290180471d+3*t16*t43*t5*t73+5.5396105803
     =         60942d+3*t37*t42*t5*t73+5.539610580360942d+3*t40*t45*t5*t
     >         72-1.4772294880962508d+4*t37*t42*t5*t72+9.232684300601568
     ?         d+3*t34*t39*t5*t72+9.232684300601568d+3*t37*t42*t5*t71-2.
     @         308171075150392d+4*t34*t39*t5*t71+1.3849026450902355d+4*t
     1         31*t36*t5*t71+1.3849026450902355d+4*t34*t39*t5*t70-3.3237
     2         66348216566d+4*t31*t36*t5*t70+1.9388637031263292d+4*t28*t
     3         33*t5*t70+1.9388637031263292d+4*t31*t36*t5*t69-4.52401530
     4         72947686d+4*t28*t33*t5*t69+2.585151604168439d+4*t25*t30*t
     5         5*t69+2.585151604168439d+4*t28*t33*t5*t68-5.9089179523850
     6         03d+4*t25*t30*t5*t68+3.3237663482165647d+4*t22*t27*t5*t68
     7         +3.3237663482165647d+4*t25*t30*t5*t67-7.478474283487271d+
     8         4*t22*t27*t5*t67+4.1547079352707056d+4*t19*t24*t5*t67+4.1
     9         54707935270705d+4*t22*t27*t5*t66-9.232684300601568d+4*t19
     :         *t24*t5*t66+5.077976365330863d+4*t19*t24*t5*t65+6.0935716
     ;         38397036d+4*t110*t17*t5*t65)-9.305257363491002d-1*t12*t4*
     <         t51*(-3.4716600044518436d+6*t24*t54*t89*t97+1.15722000148
     =         39477d+7*t24*t53*t89*t97-1.2729420016323426d+7*t24*t52*t8
     >         9*t97+2.104036366334451d+4*t43*t62*t97-2.104036366334451d
     ?         +4*t16*t40*t62*t97-8.416145465337804d+4*t37*t45*t61*t97-4
     @         .208072732668902d+4*t43*t61*t97+1.2624218198006704d+5*t16
     1         *t40*t61*t97+3.787265459402013d+5*t37*t45*t60*t97+2.10403
     2         6366334451d+4*t43*t60*t97-2.104036366334451d+5*t34*t42*t6
     3         0*t97-1.8936327297010064d+5*t16*t40*t60*t97-5.04968727920
     4         2681d+5*t37*t45*t59*t97+8.416145465337803d+5*t34*t42*t59*
     5         t97+8.416145465337804d+4*t16*t40*t59*t97-4.20807273266890
     6         16d+5*t31*t39*t59*t97+2.1040363663344508d+5*t37*t45*t58*t
     7         97-1.0520181831672254d+6*t34*t42*t58*t97+1.57802727475083
     8         8d+6*t31*t39*t58*t97-7.364127282170578d+5*t28*t36*t58*t97
     9         +4.208072732668902d+5*t34*t42*t57*t97-1.893632729701006d+
     :         6*t31*t39*t57*t97+2.6510858215814087d+6*t28*t36*t57*t97-1
     ;         .1782603651472927d+6*t25*t33*t57*t97+7.364127282170578d+5
     <         *t31*t39*t56*t97-3.0929334585116436d+6*t28*t36*t56*t97+4.
     =         123911278015524d+6*t25*t33*t56*t97-1.7673905477209387d+6*
     >         t22*t30*t56*t97+1.1782603651472927d+6*t28*t36*t55*t97-4.7
     ?         13041460589171d+6*t25*t33*t55*t97+6.059624735043219d+6*t2
     @         2*t30*t55*t97-2.524843639601341d+6*t19*t27*t55*t97+1.7673
     1         90547720939d+6*t25*t33*t54*t97-6.817077826923622d+6*t22*t
     2         30*t54*t97+8.521347283654526d+6*t19*t27*t54*t97+2.5248436
     3         39601341d+6*t22*t30*t53*t97-9.468163648505028d+6*t19*t27*
     4         t53*t97-4.628880005935792d+6*t110*t21*t53*t97+3.471660004
     5         4518436d+6*t19*t27*t52*t97+1.5275304019588112d+7*t110*t21
     6         *t52*t97-6.01754400771653d+6*t142*t17*t52*t97+3.713762858
     7         948263d+1*t17*t52*t89*t96-3.37614805358933d+0*t48*t62*t96
     8         +3.37614805358933d+0*t16*t46*t62*t96-6.75229610717866d+0*
     9         t16*t46*t61*t96+6.75229610717866d+0*t43*t45*t61*t96-1.012
     :         8444160767991d+1*t43*t45*t60*t96+1.0128444160767991d+1*t4
     ;         0*t42*t60*t96-1.350459221435732d+1*t40*t42*t59*t96+1.3504
     <         59221435732d+1*t37*t39*t59*t96-1.6880740267946648d+1*t37*
     =         t39*t58*t96+1.6880740267946648d+1*t34*t36*t58*t96-2.02568
     >         88321535982d+1*t34*t36*t57*t96+2.0256888321535982d+1*t31*
     ?         t33*t57*t96-2.3633036375125308d+1*t31*t33*t56*t96+2.36330
     @         36375125308d+1*t28*t30*t56*t96-2.700918442871464d+1*t28*t
     1         30*t55*t96+2.700918442871464d+1*t25*t27*t55*t96-3.0385332
     2         482303967d+1*t25*t27*t54*t96+3.0385332482303967d+1*t22*t2
     3         4*t54*t96-3.3761480535893296d+1*t22*t24*t53*t96+3.3761480
     4         535893296d+1*t19*t21*t53*t96-3.713762858948263d+1*t19*t21
     5         *t52*t96+5.077976365330862d+4*t21*t5*t53*t89-1.1171548003
     6         727898d+5*t21*t5*t52*t89-9.232684300601568d+2*t46*t5*t62+
     7         9.232684300601568d+2*t16*t43*t5*t62+9.232684300601568d+2*
     8         t46*t5*t61+2.769805290180471d+3*t40*t45*t5*t61-3.69307372
     9         0240627d+3*t16*t43*t5*t61-8.309415870541413d+3*t40*t45*t5
     :         *t60+2.769805290180471d+3*t16*t43*t5*t60+5.53961058036094
     ;         2d+3*t37*t42*t5*t60+5.539610580360942d+3*t40*t45*t5*t59-1
     <         .4772294880962508d+4*t37*t42*t5*t59+9.232684300601568d+3*
     =         t34*t39*t5*t59+9.232684300601568d+3*t37*t42*t5*t58-2.3081
     >         71075150392d+4*t34*t39*t5*t58+1.3849026450902355d+4*t31*t
     ?         36*t5*t58+1.3849026450902355d+4*t34*t39*t5*t57-3.32376634
     @         8216566d+4*t31*t36*t5*t57+1.9388637031263292d+4*t28*t33*t
     1         5*t57+1.9388637031263292d+4*t31*t36*t5*t56-4.524015307294
     2         7686d+4*t28*t33*t5*t56+2.585151604168439d+4*t25*t30*t5*t5
     3         6+2.585151604168439d+4*t28*t33*t5*t55-5.908917952385003d+
     4         4*t25*t30*t5*t55+3.3237663482165647d+4*t22*t27*t5*t55+3.3
     5         237663482165647d+4*t25*t30*t5*t54-7.478474283487271d+4*t2
     6         2*t27*t5*t54+4.1547079352707056d+4*t19*t24*t5*t54+4.15470
     7         7935270705d+4*t22*t27*t5*t53-9.232684300601568d+4*t19*t24
     8         *t5*t53+5.077976365330863d+4*t19*t24*t5*t52+6.09357163839
     9         7036d+4*t110*t17*t5*t52)-9.305257363491002d-1*t12*t3*t4*(
     :         -3.4716600044518436d+6*t23*t24*t89*t97+1.1572200014839477
     ;         d+7*t20*t24*t89*t97-1.2729420016323426d+7*t13*t24*t89*t97
     <         +2.104036366334451d+4*t43*t47*t97-2.104036366334451d+4*t1
     =         6*t40*t47*t97-8.416145465337804d+4*t37*t44*t45*t97+3.7872
     >         65459402013d+5*t37*t41*t45*t97-5.049687279202681d+5*t37*t
     ?         38*t45*t97+2.1040363663344508d+5*t35*t37*t45*t97-4.208072
     @         732668902d+4*t43*t44*t97+1.2624218198006704d+5*t16*t40*t4
     1         4*t97+2.104036366334451d+4*t41*t43*t97-2.104036366334451d
     2         +5*t34*t41*t42*t97+8.416145465337803d+5*t34*t38*t42*t97-1
     3         .0520181831672254d+6*t34*t35*t42*t97+4.208072732668902d+5
     4         *t32*t34*t42*t97-1.8936327297010064d+5*t16*t40*t41*t97+8.
     5         416145465337804d+4*t16*t38*t40*t97-4.2080727326689016d+5*
     6         t31*t38*t39*t97+1.578027274750838d+6*t31*t35*t39*t97-1.89
     7         3632729701006d+6*t31*t32*t39*t97+7.364127282170578d+5*t29
     8         *t31*t39*t97-7.364127282170578d+5*t28*t35*t36*t97+2.65108
     9         58215814087d+6*t28*t32*t36*t97-3.0929334585116436d+6*t28*
     :         t29*t36*t97+1.1782603651472927d+6*t26*t28*t36*t97-1.17826
     ;         03651472927d+6*t25*t32*t33*t97+4.123911278015524d+6*t25*t
     <         29*t33*t97-4.713041460589171d+6*t25*t26*t33*t97+1.7673905
     =         47720939d+6*t23*t25*t33*t97-1.7673905477209387d+6*t22*t29
     >         *t30*t97+6.059624735043219d+6*t22*t26*t30*t97-6.817077826
     ?         923622d+6*t22*t23*t30*t97+2.524843639601341d+6*t20*t22*t3
     @         0*t97-2.524843639601341d+6*t19*t26*t27*t97+8.521347283654
     1         526d+6*t19*t23*t27*t97-9.468163648505028d+6*t19*t20*t27*t
     2         97+3.4716600044518436d+6*t13*t19*t27*t97-4.62888000593579
     3         2d+6*t110*t20*t21*t97+1.5275304019588112d+7*t110*t13*t21*
     4         t97-6.01754400771653d+6*t13*t142*t17*t97+3.71376285894826
     5         3d+1*t13*t17*t89*t96-3.37614805358933d+0*t47*t48*t96+3.37
     6         614805358933d+0*t16*t46*t47*t96-6.75229610717866d+0*t16*t
     7         44*t46*t96+6.75229610717866d+0*t43*t44*t45*t96-1.01284441
     8         60767991d+1*t41*t43*t45*t96+1.0128444160767991d+1*t40*t41
     9         *t42*t96-1.350459221435732d+1*t38*t40*t42*t96+1.350459221
     :         435732d+1*t37*t38*t39*t96-1.6880740267946648d+1*t35*t37*t
     ;         39*t96+1.6880740267946648d+1*t34*t35*t36*t96-2.0256888321
     <         535982d+1*t32*t34*t36*t96+2.0256888321535982d+1*t31*t32*t
     =         33*t96-2.3633036375125308d+1*t29*t31*t33*t96+2.3633036375
     >         125308d+1*t28*t29*t30*t96-2.700918442871464d+1*t26*t28*t3
     ?         0*t96+2.700918442871464d+1*t25*t26*t27*t96-3.038533248230
     @         3967d+1*t23*t25*t27*t96+3.0385332482303967d+1*t22*t23*t24
     1         *t96-3.3761480535893296d+1*t20*t22*t24*t96+3.376148053589
     2         3296d+1*t19*t20*t21*t96-3.713762858948263d+1*t13*t19*t21*
     3         t96+5.077976365330862d+4*t20*t21*t5*t89-1.117154800372789
     4         8d+5*t13*t21*t5*t89-9.232684300601568d+2*t46*t47*t5+9.232
     5         684300601568d+2*t16*t43*t47*t5+9.232684300601568d+2*t44*t
     6         46*t5+2.769805290180471d+3*t40*t44*t45*t5-8.3094158705414
     7         13d+3*t40*t41*t45*t5+5.539610580360942d+3*t38*t40*t45*t5-
     8         3.693073720240627d+3*t16*t43*t44*t5+2.769805290180471d+3*
     9         t16*t41*t43*t5+5.539610580360942d+3*t37*t41*t42*t5-1.4772
     :         294880962508d+4*t37*t38*t42*t5+9.232684300601568d+3*t35*t
     ;         37*t42*t5+9.232684300601568d+3*t34*t38*t39*t5-2.308171075
     <         150392d+4*t34*t35*t39*t5+1.3849026450902355d+4*t32*t34*t3
     =         9*t5+1.3849026450902355d+4*t31*t35*t36*t5-3.3237663482165
     >         66d+4*t31*t32*t36*t5+1.9388637031263292d+4*t29*t31*t36*t5
     ?         +1.9388637031263292d+4*t28*t32*t33*t5-4.5240153072947686d
     @         +4*t28*t29*t33*t5+2.585151604168439d+4*t26*t28*t33*t5+2.5
     1         85151604168439d+4*t25*t29*t30*t5-5.908917952385003d+4*t25
     2         *t26*t30*t5+3.3237663482165647d+4*t23*t25*t30*t5+3.323766
     3         3482165647d+4*t22*t26*t27*t5-7.478474283487271d+4*t22*t23
     4         *t27*t5+4.154707935270705d+4*t20*t22*t27*t5+4.15470793527
     5         07056d+4*t19*t23*t24*t5-9.232684300601568d+4*t19*t20*t24*
     6         t5+5.077976365330863d+4*t13*t19*t24*t5+6.093571638397036d
     7         +4*t110*t13*t17*t5)+(5.377850105933821d-2*gammaaa*t103*t9
     8         0+2.6889250529669106d-2*gammaaa*t123*t49+2.68892505296691
     9         06d-2*gammaaa*t111*t12)*t94*t95+(9.894611731573306d-5*t10
     :         4*t115*t12*t50*t91+3.024609866719883d-2*gammaaa*t103*t50*
     ;         t91+1.5123049333599414d-2*gammaaa*t123*t50*t63+9.89461173
     <         1573306d-5*t103*t104*t115*t50*t63+1.5123049333599414d-2*g
     =         ammaaa*t112*t12*t50)*t95+t101*(3.983592671062089d-3*gamma
     >         aa*t104*t12*t49*t94-1.2407009817988002d+0*t12*t51*t91-1.2
     ?         407009817988002d+0*t12*t3*t90-1.2407009817988002d+0*t103*
     @         t51*t63+2.2404517531258392d-3*gammaaa*t104*t12*t50*t63-1.
     1         2407009817988002d+0*t103*t3*t49)+t125*(3.5318356336070855
     2         d-2*gammaaa*t64*t92+3.5318356336070855d-2*gammaaa*t105*t7
     3         6)*t94+t104*(-5.779367400447957d-2*gammaaa*t105*t92-2.889
     4         6837002239784d-2*gammaaa*t126*t76-2.8896837002239784d-2*g
     5         ammaaa*t113*t64)*t94+t118*(1.4938472516482826d-2*gammaaa*
     6         t12*t90+1.4938472516482826d-2*gammaaa*t103*t49)*t94-1.648
     7         1899623499732d-1*gammaaa*t151*t64*t76*t94+2.9876945032965
     8         69d-2*gammaaa*t12*t147*t49*t94-3.6666666666666664d+0*t125
     9         *t130*t94-2.3333333333333334d+0*t118*t127*t94+t104*(-1.06
     :         3335633294209d-4*t104*t115*t50*t64*t93-3.250431179460851d
     ;         -2*gammaaa*t105*t50*t93-1.6252155897304255d-2*gammaaa*t12
     <         6*t50*t88-1.063335633294209d-4*t104*t105*t115*t50*t88-1.6
     =         252155897304255d-2*gammaaa*t114*t50*t64)+t124*(-5.3166781
     >         66471045d-5*t115*t50*t64*t93-5.316678166471045d-5*t105*t1
     ?         15*t50*t88)+t125*(1.9863746096705204d-2*gammaaa*t50*t64*t
     @         93+1.9863746096705204d-2*gammaaa*t105*t50*t88)+3*t126*t51
     1         *t93+t116*t124*(-2.3079800683637772d-4*t115*t64*t92-2.307
     2         9800683637772d-4*t105*t115*t76+2.3960893036683073d-2*gamm
     3         aaa*t130)+3*t126*t3*t92+t117*(4.947305865786653d-5*t115*t
     4         12*t50*t91+4.947305865786653d-5*t103*t115*t50*t63)+t118*(
     5         8.401694074221897d-3*gammaaa*t12*t50*t91+8.40169407422189
     6         7d-3*gammaaa*t103*t50*t63)-7.444205890792801d+0*t103*t5*t
     7         51*t91-2.7915772090473007d+0*t123*t4*t51*t91+t116*t117*(2
     8         .1476348525932504d-4*t115*t12*t90+2.1476348525932504d-4*t
     9         103*t115*t49+2.3960893036683073d-2*gammaaa*t127)-7.444205
     :         890792801d+0*t103*t3*t5*t90-2.7915772090473007d+0*t123*t3
     ;         *t4*t90-9.269748178462429d-2*gammaaa*t151*t50*t64*t88+5.8
     <         4834598311815d-4*t115*t150*t50*t64*t88-5.217843141140167d
     =         -7*t143*t149*t50*t64*t88+t152*t51*t88+2.5387780752001543d
     >         -3*t115*t116*t150*t64*t76-8.295189532329142d-6*t143*t144*
     ?         t149*t64*t76+t152*t3*t76-3.7221029453964005d+0*t123*t5*t5
     @         1*t63-9.305257363491002d-1*t148*t4*t51*t63+1.680338814844
     1         3793d-2*gammaaa*t12*t147*t50*t63-3.4631141060506576d-4*t1
     2         15*t12*t146*t50*t63+4.855337331063556d-7*t12*t143*t145*t5
     3         0*t63-3.7221029453964005d+0*t112*t12*t5*t51-2.79157720904
     4         73007d+0*t103*t112*t4*t51+3*t105*t114*t51-3.7221029453964
     5         005d+0*t123*t3*t49*t5-3.7221029453964005d+0*t111*t12*t3*t
     6         5-9.305257363491002d-1*t148*t3*t4*t49-1.5033443968152754d
     7         -3*t115*t116*t12*t146*t49+7.718887347725925d-6*t12*t143*t
     8         144*t145*t49-2.7915772090473007d+0*t103*t111*t3*t4+3*t105
     9         *t113*t3-3.6666666666666664d+0*t125*t131-2.33333333333333
     :         34d+0*t118*t129-6.666666666666666d-1*t121*t128)*wght+Amat
     ;         3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = Amat3(iq,D3_RA_RA_RB)
            Cmat3(iq,D3_RA_RA_GAA) = 1.0d+0*((-6.722312632417276d-3*t103
     1         *t90-3.361156316208638d-3*t123*t49-3.361156316208638d-3*t
     2         111*t12)*t94*t96+(-3.780762333399854d-3*t103*t50*t91-1.89
     3         0381166699927d-3*t123*t50*t63-1.890381166699927d-3*t112*t
     4         12*t50)*t96+(8.963083509889702d-3*t12*t90+8.9630835098897
     5         02d-3*t103*t49)*t94*t95+(-3.71047939933999d-5*gammaaa*t1*
     6         t12*t50*t91+5.041016444533138d-3*t12*t50*t91-3.7104793993
     7         3999d-5*gammaaa*t1*t103*t50*t63+5.041016444533138d-3*t103
     8         *t50*t63)*t95+t101*(-1.4938472516482837d-3*t1*t12*t49*t94
     9         -8.401694074221898d-4*t1*t12*t50*t63)+t104*(-1.9264558001
     :         493193d-2*t64*t92-1.9264558001493193d-2*t105*t76)*t94+t1*
     ;         (7.224209250559948d-3*t105*t92+3.612104625279974d-3*t126*
     <         t76+3.612104625279974d-3*t113*t64)*t94+3.5318356336070855
     =         d-2*t125*t64*t76*t94-8.963083509889707d-3*t118*t12*t49*t9
     >         4+t104*(3.9875086248532843d-5*gammaaa*t1*t50*t64*t93-1.08
     ?         34770598202839d-2*t50*t64*t93+3.9875086248532843d-5*gamma
     @         aa*t1*t105*t50*t88-1.0834770598202839d-2*t105*t50*t88)+t1
     1         *(4.063038974326065d-3*t105*t50*t93+2.0315194871630324d-3
     2         *t126*t50*t88+2.0315194871630324d-3*t114*t50*t64)+1.95669
     3         1177927563d-7*t115*t154*t50*t64*t88+1.9863746096705204d-2
     4         *t125*t50*t64*t88-1.7943788811839778d-4*gammaaa*t124*t50*
     5         t64*t88+3.1106960746234286d-6*t115*t144*t154*t64*t76-7.78
     6         9432730727747d-4*gammaaa*t116*t124*t64*t76-1.820751499148
     7         8338d-7*t115*t12*t153*t50*t63-5.041016444533138d-3*t118*t
     8         12*t50*t63+1.1749851431243302d-4*gammaaa*t117*t12*t50*t63
     9         -2.8945827553972214d-6*t115*t12*t144*t153*t49+5.100632774
     :         908971d-4*gammaaa*t116*t117*t12*t49-8.985334888756153d-3*
     ;         t116*t130*t133-8.985334888756153d-3*t116*t127*t132)*wght+
     <         Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_GAA_GAA) = 1.0d+0*((6.957148873762482d-6*t1*t
     1         12*t50*t91+6.957148873762482d-6*t1*t103*t50*t63)*t96+t1*(
     2         -7.476578671599909d-6*t1*t50*t64*t93-7.476578671599909d-6
     3         *t1*t105*t50*t88)-7.337591917228362d-8*gammaaa*t156*t50*t
     4         64*t88+3.9875086248532843d-5*t133*t50*t64*t88-1.166511027
     5         9837858d-6*gammaaa*t144*t156*t64*t76+1.7309850512728328d-
     6         4*t116*t133*t64*t76+6.827818121808127d-8*gammaaa*t12*t155
     7         *t50*t63-2.7828595495049924d-5*t12*t132*t50*t63+1.0854685
     8         332739583d-6*gammaaa*t12*t144*t155*t49-1.2080446045837034
     9         d-4*t116*t12*t132*t49-8.985334888756153d-3*t116*t135*t137
     :         -8.985334888756153d-3*t116*t134*t136)*wght+Cmat3(iq,D3_RA
     ;         _GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = 1.0d+0*(2.751596968960636d-8*t158
     1         *t50*t64*t88+4.374416354939197d-7*t144*t158*t64*t76-2.560
     2         431795678048d-8*t12*t157*t50*t63-4.070506999777343d-7*t12
     3         *t144*t157*t49)*wght+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
            Mmat3(iq,D3_RA_RA_TA) = 1.0d+0*((1.7926167019779404d-2*gamma
     1         aa*t12*t138+1.7926167019779404d-2*gammaaa*t103*t106)*t94*
     2         t95+(1.0082032889066277d-2*gammaaa*t12*t139*t50+1.0082032
     3         889066277d-2*gammaaa*t103*t107*t50)*t95+t104*(-1.92645580
     4         01493193d-2*gammaaa*t140*t64-1.9264558001493193d-2*gammaa
     5         a*t105*t108)*t94+3.5318356336070855d-2*gammaaa*t108*t125*
     6         t64*t94-8.963083509889707d-3*gammaaa*t106*t118*t12*t94+t5
     7         1*t64*(-4.5701787287977763d+5*t24*t4*t79*t89+2.2282577153
     8         689576d+3*t21*t6*t78*t89+5.077976365330863d+5*t24*t4*t78*
     9         t89+5.585774001863949d+5*t24*t4*t77*t89+4.051377664307196
     :         4d+1*t16*t43*t6*t87+9.232684300601569d+2*t4*t43*t87-2.769
     ;         805290180471d+3*t16*t4*t40*t87-4.0513776643071964d+1*t46*
     <         t6*t86+1.2154132992921589d+2*t40*t45*t6*t86-1.10792211607
     =         21883d+4*t37*t4*t45*t86+1.846536860120314d+3*t4*t43*t86+5
     >         .539610580360942d+3*t16*t4*t40*t86-1.2154132992921589d+2*
     ?         t16*t43*t6*t85+2.4308265985843178d+2*t37*t42*t6*t85+1.661
     @         8831741082832d+4*t37*t4*t45*t85-2.769805290180471d+3*t4*t
     1         43*t85-2.769805290180471d+4*t34*t4*t42*t85+8.309415870541
     2         416d+3*t16*t4*t40*t85-2.4308265985843178d+2*t40*t45*t6*t8
     3         4+4.0513776643071964d+2*t34*t39*t6*t84+2.2158442321443766
     4         d+4*t37*t4*t45*t84+3.693073720240629d+4*t34*t4*t42*t84-1.
     5         1079221160721883d+4*t16*t4*t40*t84-5.539610580360941d+4*t
     6         31*t39*t4*t84-4.051377664307196d+2*t37*t42*t6*t83+6.07706
     7         6496460793d+2*t31*t36*t6*t83-2.7698052901804704d+4*t37*t4
     8         *t45*t83+4.616342150300784d+4*t34*t4*t42*t83+6.9245132254
     9         51174d+4*t31*t39*t4*t83-9.694318515631648d+4*t28*t36*t4*t
     :         83-6.077066496460795d+2*t34*t39*t6*t82+8.507893095045113d
     ;         +2*t28*t33*t6*t82-5.539610580360942d+4*t34*t4*t42*t82+8.3
     <         09415870541416d+4*t31*t39*t4*t82+1.1633182218757979d+5*t2
     =         8*t36*t4*t82-1.5510909625010638d+5*t25*t33*t4*t82-8.50789
     >         3095045111d+2*t31*t36*t6*t81+1.1343857460060149d+3*t25*t3
     ?         0*t6*t81-9.694318515631648d+4*t31*t39*t4*t81+1.3572045921
     @         884307d+5*t28*t36*t4*t81+1.809606122917908d+5*t25*t33*t4*
     1         t81-2.3266364437515955d+5*t22*t30*t4*t81-1.13438574600601
     2         49d+3*t28*t33*t6*t80+1.4584959591505908d+3*t22*t27*t6*t80
     3         -1.5510909625010635d+5*t28*t36*t4*t80+2.0681212833347515d
     4         +5*t25*t33*t4*t80+2.659013078573252d+5*t22*t30*t4*t80-3.3
     5         23766348216565d+5*t19*t27*t4*t80-1.4584959591505905d+3*t2
     6         5*t30*t6*t79+1.8231199489382383d+3*t19*t24*t6*t79-2.32663
     7         64437515952d+5*t25*t33*t4*t79+2.9913897133949086d+5*t22*t
     8         30*t4*t79+3.7392371417436354d+5*t19*t27*t4*t79-1.82311994
     9         89382383d+3*t22*t27*t6*t78-3.3237663482165647d+5*t22*t30*
     :         t4*t78+4.1547079352707056d+5*t19*t27*t4*t78-6.09357163839
     ;         7035d+5*t110*t21*t4*t78-2.228257715368958d+3*t19*t24*t6*t
     <         77+2.6739092584427493d+3*t110*t17*t6*t77-4.57017872879777
     =         63d+5*t19*t27*t4*t77+6.702928802236738d+5*t110*t21*t4*t77
     >         -7.921643129916147d+5*t142*t17*t4*t77)+t3*t64*(-4.5701787
     ?         287977763d+5*t24*t4*t67*t89+2.2282577153689576d+3*t21*t6*
     @         t66*t89+5.077976365330863d+5*t24*t4*t66*t89+5.58577400186
     1         3949d+5*t24*t4*t65*t89+4.0513776643071964d+1*t16*t43*t6*t
     2         75+9.232684300601569d+2*t4*t43*t75-2.769805290180471d+3*t
     3         16*t4*t40*t75-4.0513776643071964d+1*t46*t6*t74+1.21541329
     4         92921589d+2*t40*t45*t6*t74-1.1079221160721883d+4*t37*t4*t
     5         45*t74+1.846536860120314d+3*t4*t43*t74+5.539610580360942d
     6         +3*t16*t4*t40*t74-1.2154132992921589d+2*t16*t43*t6*t73+2.
     7         4308265985843178d+2*t37*t42*t6*t73+1.6618831741082832d+4*
     8         t37*t4*t45*t73-2.769805290180471d+3*t4*t43*t73-2.76980529
     9         0180471d+4*t34*t4*t42*t73+8.309415870541416d+3*t16*t4*t40
     :         *t73-2.4308265985843178d+2*t40*t45*t6*t72+4.0513776643071
     ;         964d+2*t34*t39*t6*t72+2.2158442321443766d+4*t37*t4*t45*t7
     <         2+3.693073720240629d+4*t34*t4*t42*t72-1.1079221160721883d
     =         +4*t16*t4*t40*t72-5.539610580360941d+4*t31*t39*t4*t72-4.0
     >         51377664307196d+2*t37*t42*t6*t71+6.077066496460793d+2*t31
     ?         *t36*t6*t71-2.7698052901804704d+4*t37*t4*t45*t71+4.616342
     @         150300784d+4*t34*t4*t42*t71+6.924513225451174d+4*t31*t39*
     1         t4*t71-9.694318515631648d+4*t28*t36*t4*t71-6.077066496460
     2         795d+2*t34*t39*t6*t70+8.507893095045113d+2*t28*t33*t6*t70
     3         -5.539610580360942d+4*t34*t4*t42*t70+8.309415870541416d+4
     4         *t31*t39*t4*t70+1.1633182218757979d+5*t28*t36*t4*t70-1.55
     5         10909625010638d+5*t25*t33*t4*t70-8.507893095045111d+2*t31
     6         *t36*t6*t69+1.1343857460060149d+3*t25*t30*t6*t69-9.694318
     7         515631648d+4*t31*t39*t4*t69+1.3572045921884307d+5*t28*t36
     8         *t4*t69+1.809606122917908d+5*t25*t33*t4*t69-2.32663644375
     9         15955d+5*t22*t30*t4*t69-1.1343857460060149d+3*t28*t33*t6*
     :         t68+1.4584959591505908d+3*t22*t27*t6*t68-1.55109096250106
     ;         35d+5*t28*t36*t4*t68+2.0681212833347515d+5*t25*t33*t4*t68
     <         +2.659013078573252d+5*t22*t30*t4*t68-3.323766348216565d+5
     =         *t19*t27*t4*t68-1.4584959591505905d+3*t25*t30*t6*t67+1.82
     >         31199489382383d+3*t19*t24*t6*t67-2.3266364437515952d+5*t2
     ?         5*t33*t4*t67+2.9913897133949086d+5*t22*t30*t4*t67+3.73923
     @         71417436354d+5*t19*t27*t4*t67-1.8231199489382383d+3*t22*t
     1         27*t6*t66-3.3237663482165647d+5*t22*t30*t4*t66+4.15470793
     2         52707056d+5*t19*t27*t4*t66-6.093571638397035d+5*t110*t21*
     3         t4*t66-2.228257715368958d+3*t19*t24*t6*t65+2.673909258442
     4         7493d+3*t110*t17*t6*t65-4.5701787287977763d+5*t19*t27*t4*
     5         t65+6.702928802236738d+5*t110*t21*t4*t65-7.92164312991614
     6         7d+5*t142*t17*t4*t65)-9.305257363491002d-1*t12*t4*t51*(2.
     7         2282577153689576d+3*t21*t53*t6*t89-4.5701787287977763d+5*
     8         t24*t4*t54*t89+5.077976365330863d+5*t24*t4*t53*t89+5.5857
     9         74001863949d+5*t24*t4*t52*t89+4.0513776643071964d+1*t16*t
     :         43*t6*t62+9.232684300601569d+2*t4*t43*t62-2.7698052901804
     ;         71d+3*t16*t4*t40*t62-4.0513776643071964d+1*t46*t6*t61+1.2
     <         154132992921589d+2*t40*t45*t6*t61-1.1079221160721883d+4*t
     =         37*t4*t45*t61+1.846536860120314d+3*t4*t43*t61+5.539610580
     >         360942d+3*t16*t4*t40*t61-1.2154132992921589d+2*t16*t43*t6
     ?         *t60+2.4308265985843178d+2*t37*t42*t6*t60+1.6618831741082
     @         832d+4*t37*t4*t45*t60-2.769805290180471d+3*t4*t43*t60-2.7
     1         69805290180471d+4*t34*t4*t42*t60+8.309415870541416d+3*t16
     2         *t4*t40*t60-2.4308265985843178d+2*t40*t45*t59*t6+4.051377
     3         6643071964d+2*t34*t39*t59*t6-4.051377664307196d+2*t37*t42
     4         *t58*t6+6.077066496460793d+2*t31*t36*t58*t6-6.07706649646
     5         0795d+2*t34*t39*t57*t6+8.507893095045113d+2*t28*t33*t57*t
     6         6-8.507893095045111d+2*t31*t36*t56*t6+1.1343857460060149d
     7         +3*t25*t30*t56*t6-1.1343857460060149d+3*t28*t33*t55*t6+1.
     8         4584959591505908d+3*t22*t27*t55*t6-1.4584959591505905d+3*
     9         t25*t30*t54*t6+1.8231199489382383d+3*t19*t24*t54*t6-1.823
     :         1199489382383d+3*t22*t27*t53*t6-2.228257715368958d+3*t19*
     ;         t24*t52*t6+2.6739092584427493d+3*t110*t17*t52*t6+2.215844
     <         2321443766d+4*t37*t4*t45*t59+3.693073720240629d+4*t34*t4*
     =         t42*t59-1.1079221160721883d+4*t16*t4*t40*t59-5.5396105803
     >         60941d+4*t31*t39*t4*t59-2.7698052901804704d+4*t37*t4*t45*
     ?         t58+4.616342150300784d+4*t34*t4*t42*t58+6.924513225451174
     @         d+4*t31*t39*t4*t58-9.694318515631648d+4*t28*t36*t4*t58-5.
     1         539610580360942d+4*t34*t4*t42*t57+8.309415870541416d+4*t3
     2         1*t39*t4*t57+1.1633182218757979d+5*t28*t36*t4*t57-1.55109
     3         09625010638d+5*t25*t33*t4*t57-9.694318515631648d+4*t31*t3
     4         9*t4*t56+1.3572045921884307d+5*t28*t36*t4*t56+1.809606122
     5         917908d+5*t25*t33*t4*t56-2.3266364437515955d+5*t22*t30*t4
     6         *t56-1.5510909625010635d+5*t28*t36*t4*t55+2.0681212833347
     7         515d+5*t25*t33*t4*t55+2.659013078573252d+5*t22*t30*t4*t55
     8         -3.323766348216565d+5*t19*t27*t4*t55-2.3266364437515952d+
     9         5*t25*t33*t4*t54+2.9913897133949086d+5*t22*t30*t4*t54+3.7
     :         392371417436354d+5*t19*t27*t4*t54-3.3237663482165647d+5*t
     ;         22*t30*t4*t53+4.1547079352707056d+5*t19*t27*t4*t53-6.0935
     <         71638397035d+5*t110*t21*t4*t53-4.5701787287977763d+5*t19*
     =         t27*t4*t52+6.702928802236738d+5*t110*t21*t4*t52-7.9216431
     >         29916147d+5*t142*t17*t4*t52)-9.305257363491002d-1*t12*t3*
     ?         t4*(2.2282577153689576d+3*t20*t21*t6*t89-4.57017872879777
     @         63d+5*t23*t24*t4*t89+5.077976365330863d+5*t20*t24*t4*t89+
     1         5.585774001863949d+5*t13*t24*t4*t89+4.0513776643071964d+1
     2         *t16*t43*t47*t6-4.0513776643071964d+1*t44*t46*t6+1.215413
     3         2992921589d+2*t40*t44*t45*t6-2.4308265985843178d+2*t38*t4
     4         0*t45*t6-1.2154132992921589d+2*t16*t41*t43*t6+2.430826598
     5         5843178d+2*t37*t41*t42*t6-4.051377664307196d+2*t35*t37*t4
     6         2*t6+4.0513776643071964d+2*t34*t38*t39*t6-6.0770664964607
     7         95d+2*t32*t34*t39*t6+6.077066496460793d+2*t31*t35*t36*t6-
     8         8.507893095045111d+2*t29*t31*t36*t6+8.507893095045113d+2*
     9         t28*t32*t33*t6-1.1343857460060149d+3*t26*t28*t33*t6+1.134
     :         3857460060149d+3*t25*t29*t30*t6-1.4584959591505905d+3*t23
     ;         *t25*t30*t6+1.4584959591505908d+3*t22*t26*t27*t6-1.823119
     <         9489382383d+3*t20*t22*t27*t6+1.8231199489382383d+3*t19*t2
     =         3*t24*t6-2.228257715368958d+3*t13*t19*t24*t6+2.6739092584
     >         427493d+3*t110*t13*t17*t6+9.232684300601569d+2*t4*t43*t47
     ?         -2.769805290180471d+3*t16*t4*t40*t47-1.1079221160721883d+
     @         4*t37*t4*t44*t45+1.6618831741082832d+4*t37*t4*t41*t45+2.2
     1         158442321443766d+4*t37*t38*t4*t45-2.7698052901804704d+4*t
     2         35*t37*t4*t45+1.846536860120314d+3*t4*t43*t44+5.539610580
     3         360942d+3*t16*t4*t40*t44-2.769805290180471d+3*t4*t41*t43-
     4         2.769805290180471d+4*t34*t4*t41*t42+3.693073720240629d+4*
     5         t34*t38*t4*t42+4.616342150300784d+4*t34*t35*t4*t42-5.5396
     6         10580360942d+4*t32*t34*t4*t42+8.309415870541416d+3*t16*t4
     7         *t40*t41-1.1079221160721883d+4*t16*t38*t4*t40-5.539610580
     8         360941d+4*t31*t38*t39*t4+6.924513225451174d+4*t31*t35*t39
     9         *t4+8.309415870541416d+4*t31*t32*t39*t4-9.694318515631648
     :         d+4*t29*t31*t39*t4-9.694318515631648d+4*t28*t35*t36*t4+1.
     ;         1633182218757979d+5*t28*t32*t36*t4+1.3572045921884307d+5*
     <         t28*t29*t36*t4-1.5510909625010635d+5*t26*t28*t36*t4-1.551
     =         0909625010638d+5*t25*t32*t33*t4+1.809606122917908d+5*t25*
     >         t29*t33*t4+2.0681212833347515d+5*t25*t26*t33*t4-2.3266364
     ?         437515952d+5*t23*t25*t33*t4-2.3266364437515955d+5*t22*t29
     @         *t30*t4+2.659013078573252d+5*t22*t26*t30*t4+2.99138971339
     1         49086d+5*t22*t23*t30*t4-3.3237663482165647d+5*t20*t22*t30
     2         *t4-3.323766348216565d+5*t19*t26*t27*t4+3.739237141743635
     3         4d+5*t19*t23*t27*t4+4.1547079352707056d+5*t19*t20*t27*t4-
     4         4.5701787287977763d+5*t13*t19*t27*t4-6.093571638397035d+5
     5         *t110*t20*t21*t4+6.702928802236738d+5*t110*t13*t21*t4-7.9
     6         21643129916147d+5*t13*t142*t17*t4)+t104*(-1.0834770598202
     7         839d-2*gammaaa*t141*t50*t64-1.0834770598202839d-2*gammaaa
     8         *t105*t109*t50)+1.9863746096705204d-2*gammaaa*t109*t125*t
     9         50*t64-5.316678166471045d-5*t109*t115*t124*t50*t64-2.3079
     :         800683637772d-4*t108*t115*t116*t124*t64+t101*(-4.13566993
     ;         9329334d-1*t107*t12*t51-4.135669939329334d-1*t106*t12*t3)
     <         -2.4814019635976003d+0*t12*t139*t5*t51-2.4814019635976003
     =         d+0*t103*t107*t5*t51-1.8610514726982003d+0*t103*t139*t4*t
     >         51-9.305257363491002d-1*t107*t123*t4*t51+2*t105*t141*t51+
     ?         t109*t126*t51-5.041016444533138d-3*gammaaa*t107*t118*t12*
     @         t50+4.947305865786653d-5*t107*t115*t117*t12*t50-2.4814019
     1         635976003d+0*t12*t138*t3*t5-2.4814019635976003d+0*t103*t1
     2         06*t3*t5-1.8610514726982003d+0*t103*t138*t3*t4-9.30525736
     3         3491002d-1*t106*t123*t3*t4+2*t105*t140*t3+t108*t126*t3+2.
     4         1476348525932504d-4*t106*t115*t116*t117*t12)*wght+Mmat3(i
     5         q,D3_RA_RA_TA)
            Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
            Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
            Mmat3(iq,D3_RA_GAA_TA) = 1.0d+0*((-3.361156316208638d-3*t12*
     1         t138-3.361156316208638d-3*t103*t106)*t94*t96+(-1.89038116
     2         6699927d-3*t12*t139*t50-1.890381166699927d-3*t103*t107*t5
     3         0)*t96+4.481541754944851d-3*t106*t12*t94*t95+2.5205082222
     4         66569d-3*t107*t12*t50*t95+t1*(3.612104625279974d-3*t140*t
     5         64+3.612104625279974d-3*t105*t108)*t94-9.632279000746596d
     6         -3*t104*t108*t64*t94+t1*(2.0315194871630324d-3*t141*t50*t
     7         64+2.0315194871630324d-3*t105*t109*t50)+1.993754312426642
     8         1d-5*gammaaa*t109*t133*t50*t64-5.417385299101419d-3*t104*
     9         t109*t50*t64+8.654925256364164d-5*gammaaa*t108*t116*t133*
     :         t64-1.855239699669995d-5*gammaaa*t107*t12*t132*t50-8.0536
     ;         3069722469d-5*gammaaa*t106*t116*t12*t132)*wght+Mmat3(iq,D
     <         3_RA_GAA_TA)
            Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
            Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
            Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
            Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
            Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
            Mmat3(iq,D3_GAA_GAA_TA) = 1.0d+0*(-7.476578671599909d-6*t109
     1         *t137*t50*t64-3.245596971136562d-5*t108*t116*t137*t64+6.9
     2         57148873762482d-6*t107*t12*t136*t50+3.020111511459258d-5*
     3         t106*t116*t12*t136)*wght+Mmat3(iq,D3_GAA_GAA_TA)
            Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
            Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
            Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
            Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
            Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
            Mmat3(iq,D3_TA_TA_TA) = 1.0d+0*(t51*t64*(-7.92d+3*t24*t79*t8
     1         9-2.64d+4*t24*t78*t89-2.904d+4*t24*t77*t89-4.8d+1*t43*t87
     2         -4.8d+1*t16*t40*t87-1.92d+2*t37*t45*t86-9.6d+1*t43*t86-2.
     3         88d+2*t16*t40*t86-8.64d+2*t37*t45*t85-4.8d+1*t43*t85-4.8d
     4         +2*t34*t42*t85-4.32d+2*t16*t40*t85-1.152d+3*t37*t45*t84-1
     5         .92d+3*t34*t42*t84-1.92d+2*t16*t40*t84-9.6d+2*t31*t39*t84
     6         -4.8d+2*t37*t45*t83-2.4d+3*t34*t42*t83-3.6d+3*t31*t39*t83
     7         -1.68d+3*t28*t36*t83-9.6d+2*t34*t42*t82-4.32d+3*t31*t39*t
     8         82-6.048d+3*t28*t36*t82-2.688d+3*t25*t33*t82-1.68d+3*t31*
     9         t39*t81-7.056d+3*t28*t36*t81-9.408d+3*t25*t33*t81-4.032d+
     :         3*t22*t30*t81-2.688d+3*t28*t36*t80-1.0752d+4*t25*t33*t80-
     ;         1.3824d+4*t22*t30*t80-5.76d+3*t19*t27*t80-4.032d+3*t25*t3
     <         3*t79-1.5552d+4*t22*t30*t79-1.944d+4*t19*t27*t79-5.76d+3*
     =         t22*t30*t78-2.16d+4*t19*t27*t78-1.056d+4*t110*t21*t78-7.9
     >         2d+3*t19*t27*t77-3.4848d+4*t110*t21*t77-1.3728d+4*t142*t1
     ?         7*t77)+t3*t64*(-7.92d+3*t24*t67*t89-2.64d+4*t24*t66*t89-2
     @         .904d+4*t24*t65*t89-4.8d+1*t43*t75-4.8d+1*t16*t40*t75-1.9
     1         2d+2*t37*t45*t74-9.6d+1*t43*t74-2.88d+2*t16*t40*t74-8.64d
     2         +2*t37*t45*t73-4.8d+1*t43*t73-4.8d+2*t34*t42*t73-4.32d+2*
     3         t16*t40*t73-1.152d+3*t37*t45*t72-1.92d+3*t34*t42*t72-1.92
     4         d+2*t16*t40*t72-9.6d+2*t31*t39*t72-4.8d+2*t37*t45*t71-2.4
     5         d+3*t34*t42*t71-3.6d+3*t31*t39*t71-1.68d+3*t28*t36*t71-9.
     6         6d+2*t34*t42*t70-4.32d+3*t31*t39*t70-6.048d+3*t28*t36*t70
     7         -2.688d+3*t25*t33*t70-1.68d+3*t31*t39*t69-7.056d+3*t28*t3
     8         6*t69-9.408d+3*t25*t33*t69-4.032d+3*t22*t30*t69-2.688d+3*
     9         t28*t36*t68-1.0752d+4*t25*t33*t68-1.3824d+4*t22*t30*t68-5
     :         .76d+3*t19*t27*t68-4.032d+3*t25*t33*t67-1.5552d+4*t22*t30
     ;         *t67-1.944d+4*t19*t27*t67-5.76d+3*t22*t30*t66-2.16d+4*t19
     <         *t27*t66-1.056d+4*t110*t21*t66-7.92d+3*t19*t27*t65-3.4848
     =         d+4*t110*t21*t65-1.3728d+4*t142*t17*t65)-9.30525736349100
     >         2d-1*t12*t4*t51*(-7.92d+3*t24*t54*t89-2.64d+4*t24*t53*t89
     ?         -2.904d+4*t24*t52*t89-4.8d+1*t43*t62-4.8d+1*t16*t40*t62-1
     @         .92d+2*t37*t45*t61-9.6d+1*t43*t61-2.88d+2*t16*t40*t61-8.6
     1         4d+2*t37*t45*t60-4.8d+1*t43*t60-4.8d+2*t34*t42*t60-4.32d+
     2         2*t16*t40*t60-1.152d+3*t37*t45*t59-1.92d+3*t34*t42*t59-1.
     3         92d+2*t16*t40*t59-9.6d+2*t31*t39*t59-4.8d+2*t37*t45*t58-2
     4         .4d+3*t34*t42*t58-3.6d+3*t31*t39*t58-1.68d+3*t28*t36*t58-
     5         9.6d+2*t34*t42*t57-4.32d+3*t31*t39*t57-6.048d+3*t28*t36*t
     6         57-2.688d+3*t25*t33*t57-1.68d+3*t31*t39*t56-7.056d+3*t28*
     7         t36*t56-9.408d+3*t25*t33*t56-4.032d+3*t22*t30*t56-2.688d+
     8         3*t28*t36*t55-1.0752d+4*t25*t33*t55-1.3824d+4*t22*t30*t55
     9         -5.76d+3*t19*t27*t55-4.032d+3*t25*t33*t54-1.5552d+4*t22*t
     :         30*t54-1.944d+4*t19*t27*t54-5.76d+3*t22*t30*t53-2.16d+4*t
     ;         19*t27*t53-1.056d+4*t110*t21*t53-7.92d+3*t19*t27*t52-3.48
     <         48d+4*t110*t21*t52-1.3728d+4*t142*t17*t52)-9.305257363491
     =         002d-1*t12*t3*t4*(-7.92d+3*t23*t24*t89-2.64d+4*t20*t24*t8
     >         9-2.904d+4*t13*t24*t89-4.8d+1*t43*t47-4.8d+1*t16*t40*t47-
     ?         1.92d+2*t37*t44*t45-8.64d+2*t37*t41*t45-1.152d+3*t37*t38*
     @         t45-4.8d+2*t35*t37*t45-9.6d+1*t43*t44-2.88d+2*t16*t40*t44
     1         -4.8d+1*t41*t43-4.8d+2*t34*t41*t42-1.92d+3*t34*t38*t42-2.
     2         4d+3*t34*t35*t42-9.6d+2*t32*t34*t42-4.32d+2*t16*t40*t41-1
     3         .92d+2*t16*t38*t40-9.6d+2*t31*t38*t39-3.6d+3*t31*t35*t39-
     4         4.32d+3*t31*t32*t39-1.68d+3*t29*t31*t39-1.68d+3*t28*t35*t
     5         36-6.048d+3*t28*t32*t36-7.056d+3*t28*t29*t36-2.688d+3*t26
     6         *t28*t36-2.688d+3*t25*t32*t33-9.408d+3*t25*t29*t33-1.0752
     7         d+4*t25*t26*t33-4.032d+3*t23*t25*t33-4.032d+3*t22*t29*t30
     8         -1.3824d+4*t22*t26*t30-1.5552d+4*t22*t23*t30-5.76d+3*t20*
     9         t22*t30-5.76d+3*t19*t26*t27-1.944d+4*t19*t23*t27-2.16d+4*
     :         t19*t20*t27-7.92d+3*t13*t19*t27-1.056d+4*t110*t20*t21-3.4
     ;         848d+4*t110*t13*t21-1.3728d+4*t13*t142*t17))*wght+Mmat3(i
     <         q,D3_TA_TA_TA)
            Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = rhoa**3.333333333333333d-1
            t6 = 1/t5
            t7 = 1/rhoa
            t8 = 1.282782438530422d-1*t6-2.63857249068588d-4*t7
            t9 = rhoa**6.666666666666666d-1
            t10 = exp(-2.4308265985843178d+2*t9)
            t11 = t10*t8+2.63857249068588d-4*t7-1.924173657795633d-1*t6+
     1         3.544907701811032d+0*erf(1.5591108358883013d+1*t5)
            t12 = 1.0d+0-4.275941461768073d-2*t11*t6
            t13 = param(1)
            t14 = param(12)
            t15 = rhoa**1.6666666666666669d+0
            t16 = 9.115599744691192d+0*t15
            t17 = t16-2.0d+0*taua
            t18 = t17**11
            t19 = 2.0d+0*taua+t16
            t20 = 1/t19**11
            t21 = param(11)
            t22 = t17**10
            t23 = 1/t19**10
            t24 = param(10)
            t25 = t17**9
            t26 = 1/t19**9
            t27 = param(9)
            t28 = t17**8
            t29 = 1/t19**8
            t30 = param(8)
            t31 = t17**7
            t32 = 1/t19**7
            t33 = param(7)
            t34 = t17**6
            t35 = 1/t19**6
            t36 = param(6)
            t37 = t17**5
            t38 = 1/t19**5
            t39 = param(5)
            t40 = t17**4
            t41 = 1/t19**4
            t42 = param(4)
            t43 = t17**3
            t44 = 1/t19**3
            t45 = param(3)
            t46 = t17**2
            t47 = 1/t19**2
            t48 = param(2)
            t49 = 1/t19
            t50 = t17*t48*t49+t45*t46*t47+t42*t43*t44+t39*t40*t41+t36*t3
     1         7*t38+t33*t34*t35+t30*t31*t32+t27*t28*t29+t24*t25*t26+t21
     2         *t22*t23+t14*t18*t20+t13
            t51 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t52 = 5.52d-1*(1.0d+0-t51)+1.0d+0
            t53 = param(13)
            t54 = param(24)
            t55 = param(23)
            t56 = param(22)
            t57 = param(21)
            t58 = param(20)
            t59 = param(19)
            t60 = param(18)
            t61 = param(17)
            t62 = param(16)
            t63 = param(15)
            t64 = param(14)
            t65 = t17*t49*t64+t46*t47*t63+t43*t44*t62+t40*t41*t61+t37*t3
     1         8*t60+t34*t35*t59+t31*t32*t58+t28*t29*t57+t25*t26*t56+t22
     2         *t23*t55+t18*t20*t54+t53
            t66 = 9.305257363491002d-1*t12*t4-9.305257363491002d-1*t4
            t67 = param(25)
            t68 = param(36)
            t69 = param(35)
            t70 = param(34)
            t71 = param(33)
            t72 = param(32)
            t73 = param(31)
            t74 = param(30)
            t75 = param(29)
            t76 = param(28)
            t77 = param(27)
            t78 = param(26)
            t79 = t17*t49*t78+t46*t47*t77+t43*t44*t76+t40*t41*t75+t37*t3
     1         8*t74+t34*t35*t73+t31*t32*t72+t28*t29*t71+t25*t26*t70+t22
     2         *t23*t69+t18*t20*t68+t67
            t80 = param(37)
            t81 = param(48)
            t82 = param(47)
            t83 = param(46)
            t84 = param(45)
            t85 = param(44)
            t86 = param(43)
            t87 = param(42)
            t88 = param(41)
            t89 = param(40)
            t90 = param(39)
            t91 = param(38)
            t92 = t17*t49*t91+t46*t47*t90+t43*t44*t89+t40*t41*t88+t37*t3
     1         8*t87+t34*t35*t86+t31*t32*t85+t28*t29*t84+t25*t26*t83+t22
     2         *t23*t82+t18*t20*t81+t80
            t93 = 1/rhob**2.6666666666666666d+0
            t94 = 4.492667444378077d-3*gammabb*t93+1.0d+0
            t95 = 8.04d-1*(1.0d+0-1.0d+0/t94)+1.0d+0
            t96 = rhob**1.3333333333333333d+0
            t97 = rhob**3.333333333333333d-1
            t98 = 1/t97
            t99 = 1/rhob
            t100 = 1.282782438530422d-1*t98-2.63857249068588d-4*t99
            t101 = rhob**6.666666666666666d-1
            t102 = exp(-2.4308265985843178d+2*t101)
            t103 = 2.63857249068588d-4*t99-1.924173657795633d-1*t98+3.54
     1         4907701811032d+0*erf(1.5591108358883013d+1*t97)+t100*t102
            t104 = 1.0d+0-4.275941461768073d-2*t103*t98
            t105 = rhob**1.6666666666666669d+0
            t106 = 9.115599744691192d+0*t105
            t107 = t106-2.0d+0*taub
            t108 = t107**11
            t109 = 2.0d+0*taub+t106
            t110 = 1/t109**11
            t111 = t107**10
            t112 = 1/t109**10
            t113 = t107**9
            t114 = 1/t109**9
            t115 = t107**8
            t116 = 1/t109**8
            t117 = t107**7
            t118 = 1/t109**7
            t119 = t107**6
            t120 = 1/t109**6
            t121 = t107**5
            t122 = 1/t109**5
            t123 = t107**4
            t124 = 1/t109**4
            t125 = t107**3
            t126 = 1/t109**3
            t127 = t107**2
            t128 = 1/t109**2
            t129 = 1/t109
            t130 = t107*t129*t48+t127*t128*t45+t125*t126*t42+t123*t124*t
     1         39+t121*t122*t36+t119*t120*t33+t117*t118*t30+t115*t116*t2
     2         7+t113*t114*t24+t111*t112*t21+t108*t110*t14+t13
            t131 = exp(-3.6802889260199856d-3*gammabb*t93)
            t132 = 5.52d-1*(1.0d+0-t131)+1.0d+0
            t133 = t107*t129*t64+t127*t128*t63+t125*t126*t62+t123*t124*t
     1         61+t121*t122*t60+t119*t120*t59+t117*t118*t58+t115*t116*t5
     2         7+t113*t114*t56+t111*t112*t55+t108*t110*t54+t53
            t134 = 9.305257363491002d-1*t104*t96-9.305257363491002d-1*t9
     1         6
            t135 = t107*t129*t78+t127*t128*t77+t125*t126*t76+t123*t124*t
     1         75+t121*t122*t74+t119*t120*t73+t117*t118*t72+t115*t116*t7
     2         1+t113*t114*t70+t111*t112*t69+t108*t110*t68+t67
            t136 = t107*t129*t91+t127*t128*t90+t125*t126*t89+t123*t124*t
     1         88+t121*t122*t87+t119*t120*t86+t117*t118*t85+t115*t116*t8
     2         4+t113*t114*t83+t111*t112*t82+t108*t110*t81+t80
            t137 = 1/t19**12
            t138 = 1.5192666241151986d+1*t48*t49*t9-1.5192666241151986d+
     1         1*t17*t47*t48*t9+3.038533248230397d+1*t17*t45*t47*t9-3.03
     2         8533248230397d+1*t44*t45*t46*t9+4.5577998723455965d+1*t42
     3         *t44*t46*t9-4.5577998723455965d+1*t41*t42*t43*t9+6.077066
     4         496460795d+1*t39*t41*t43*t9-6.077066496460795d+1*t38*t39*
     5         t40*t9+7.596333120575993d+1*t36*t38*t40*t9-7.596333120575
     6         993d+1*t35*t36*t37*t9+9.115599744691193d+1*t33*t35*t37*t9
     7         -9.115599744691193d+1*t32*t33*t34*t9+1.0634866368806391d+
     8         2*t30*t32*t34*t9-1.0634866368806391d+2*t29*t30*t31*t9+1.2
     9         154132992921589d+2*t27*t29*t31*t9-1.2154132992921589d+2*t
     :         26*t27*t28*t9+1.3673399617036788d+2*t24*t26*t28*t9-1.3673
     ;         399617036788d+2*t23*t24*t25*t9+1.5192666241151986d+2*t21*
     <         t23*t25*t9-1.5192666241151986d+2*t20*t21*t22*t9+1.6711932
     =         865267184d+2*t14*t20*t22*t9-1.6711932865267184d+2*t137*t1
     >         4*t18*t9
            t139 = 1.5192666241151986d+1*t49*t64*t9-1.5192666241151986d+
     1         1*t17*t47*t64*t9+3.038533248230397d+1*t17*t47*t63*t9-3.03
     2         8533248230397d+1*t44*t46*t63*t9+4.5577998723455965d+1*t44
     3         *t46*t62*t9-4.5577998723455965d+1*t41*t43*t62*t9+6.077066
     4         496460795d+1*t41*t43*t61*t9-6.077066496460795d+1*t38*t40*
     5         t61*t9+7.596333120575993d+1*t38*t40*t60*t9-7.596333120575
     6         993d+1*t35*t37*t60*t9+9.115599744691193d+1*t35*t37*t59*t9
     7         -9.115599744691193d+1*t32*t34*t59*t9+1.0634866368806391d+
     8         2*t32*t34*t58*t9-1.0634866368806391d+2*t29*t31*t58*t9+1.2
     9         154132992921589d+2*t29*t31*t57*t9-1.2154132992921589d+2*t
     :         26*t28*t57*t9+1.3673399617036788d+2*t26*t28*t56*t9-1.3673
     ;         399617036788d+2*t23*t25*t56*t9+1.5192666241151986d+2*t23*
     <         t25*t55*t9-1.5192666241151986d+2*t20*t22*t55*t9+1.6711932
     =         865267184d+2*t20*t22*t54*t9-1.6711932865267184d+2*t137*t1
     >         8*t54*t9
            t140 = 1.5192666241151986d+1*t49*t78*t9-1.5192666241151986d+
     1         1*t17*t47*t78*t9+3.038533248230397d+1*t17*t47*t77*t9-3.03
     2         8533248230397d+1*t44*t46*t77*t9+4.5577998723455965d+1*t44
     3         *t46*t76*t9-4.5577998723455965d+1*t41*t43*t76*t9+6.077066
     4         496460795d+1*t41*t43*t75*t9-6.077066496460795d+1*t38*t40*
     5         t75*t9+7.596333120575993d+1*t38*t40*t74*t9-7.596333120575
     6         993d+1*t35*t37*t74*t9+9.115599744691193d+1*t35*t37*t73*t9
     7         -9.115599744691193d+1*t32*t34*t73*t9+1.0634866368806391d+
     8         2*t32*t34*t72*t9-1.0634866368806391d+2*t29*t31*t72*t9+1.2
     9         154132992921589d+2*t29*t31*t71*t9-1.2154132992921589d+2*t
     :         26*t28*t71*t9+1.3673399617036788d+2*t26*t28*t70*t9-1.3673
     ;         399617036788d+2*t23*t25*t70*t9+1.5192666241151986d+2*t23*
     <         t25*t69*t9-1.5192666241151986d+2*t20*t22*t69*t9+1.6711932
     =         865267184d+2*t20*t22*t68*t9-1.6711932865267184d+2*t137*t1
     >         8*t68*t9
            t141 = 1.5192666241151986d+1*t49*t9*t91-1.5192666241151986d+
     1         1*t17*t47*t9*t91+3.038533248230397d+1*t17*t47*t9*t90-3.03
     2         8533248230397d+1*t44*t46*t9*t90+4.5577998723455965d+1*t44
     3         *t46*t89*t9-4.5577998723455965d+1*t41*t43*t89*t9+6.077066
     4         496460795d+1*t41*t43*t88*t9-6.077066496460795d+1*t38*t40*
     5         t88*t9+7.596333120575993d+1*t38*t40*t87*t9-7.596333120575
     6         993d+1*t35*t37*t87*t9+9.115599744691193d+1*t35*t37*t86*t9
     7         -9.115599744691193d+1*t32*t34*t86*t9+1.0634866368806391d+
     8         2*t32*t34*t85*t9-1.0634866368806391d+2*t29*t31*t85*t9+1.2
     9         154132992921589d+2*t29*t31*t84*t9-1.2154132992921589d+2*t
     :         26*t28*t84*t9+1.3673399617036788d+2*t26*t28*t83*t9-1.3673
     ;         399617036788d+2*t23*t25*t83*t9+1.5192666241151986d+2*t23*
     <         t25*t82*t9-1.5192666241151986d+2*t20*t22*t82*t9+1.6711932
     =         865267184d+2*t20*t22*t81*t9-1.6711932865267184d+2*t137*t1
     >         8*t81*t9
            t142 = 1/t2**2
            t143 = 1/rhoa**2.3333333333333334d+0
            t144 = 1/t4
            t145 = rhoa**2
            t146 = 1/t145
            t147 = 2.63857249068588d-4*t146-4.2759414617680735d-2*t144
            t148 = 5.641895835477563d-1
            t149 = 1/t9
            t150 = -1.6205510657228786d+2*t10*t6*t8+3.6846026734116505d+
     1         1*t10*t148*t149+t10*t147-2.63857249068588d-4*t146+6.41391
     2         219265211d-2*t144
            t151 = 1.4253138205893576d-2*t11*t144-4.275941461768073d-2*t
     1         150*t6
            t152 = 1/rhoa**3.6666666666666664d+0
            t153 = 1.2407009817988002d+0*t12*t5-1.2407009817988002d+0*t5
     1         +9.305257363491002d-1*t151*t4
            t154 = 1/t109**12
            t155 = 1.5192666241151986d+1*t101*t129*t48-1.519266624115198
     1         6d+1*t101*t107*t128*t48+3.038533248230397d+1*t101*t107*t1
     2         28*t45-3.038533248230397d+1*t101*t126*t127*t45+4.55779987
     3         23455965d+1*t101*t126*t127*t42-4.5577998723455965d+1*t101
     4         *t124*t125*t42+6.077066496460795d+1*t101*t124*t125*t39-6.
     5         077066496460795d+1*t101*t122*t123*t39+7.596333120575993d+
     6         1*t101*t122*t123*t36-7.596333120575993d+1*t101*t120*t121*
     7         t36+9.115599744691193d+1*t101*t120*t121*t33-9.11559974469
     8         1193d+1*t101*t118*t119*t33+1.0634866368806391d+2*t101*t11
     9         8*t119*t30-1.0634866368806391d+2*t101*t116*t117*t30+1.215
     :         4132992921589d+2*t101*t116*t117*t27-1.2154132992921589d+2
     ;         *t101*t114*t115*t27+1.3673399617036788d+2*t101*t114*t115*
     <         t24-1.3673399617036788d+2*t101*t112*t113*t24+1.5192666241
     =         151986d+2*t101*t112*t113*t21-1.5192666241151986d+2*t101*t
     >         110*t111*t21-1.6711932865267184d+2*t101*t108*t14*t154+1.6
     ?         711932865267184d+2*t101*t110*t111*t14
            t156 = 1.5192666241151986d+1*t101*t129*t64-1.519266624115198
     1         6d+1*t101*t107*t128*t64+3.038533248230397d+1*t101*t107*t1
     2         28*t63-3.038533248230397d+1*t101*t126*t127*t63+4.55779987
     3         23455965d+1*t101*t126*t127*t62-4.5577998723455965d+1*t101
     4         *t124*t125*t62+6.077066496460795d+1*t101*t124*t125*t61-6.
     5         077066496460795d+1*t101*t122*t123*t61+7.596333120575993d+
     6         1*t101*t122*t123*t60-7.596333120575993d+1*t101*t120*t121*
     7         t60+9.115599744691193d+1*t101*t120*t121*t59-9.11559974469
     8         1193d+1*t101*t118*t119*t59+1.0634866368806391d+2*t101*t11
     9         8*t119*t58-1.0634866368806391d+2*t101*t116*t117*t58+1.215
     :         4132992921589d+2*t101*t116*t117*t57-1.2154132992921589d+2
     ;         *t101*t114*t115*t57+1.3673399617036788d+2*t101*t114*t115*
     <         t56-1.3673399617036788d+2*t101*t112*t113*t56+1.5192666241
     =         151986d+2*t101*t112*t113*t55-1.5192666241151986d+2*t101*t
     >         110*t111*t55-1.6711932865267184d+2*t101*t108*t154*t54+1.6
     ?         711932865267184d+2*t101*t110*t111*t54
            t157 = 1.5192666241151986d+1*t101*t129*t78-1.519266624115198
     1         6d+1*t101*t107*t128*t78+3.038533248230397d+1*t101*t107*t1
     2         28*t77-3.038533248230397d+1*t101*t126*t127*t77+4.55779987
     3         23455965d+1*t101*t126*t127*t76-4.5577998723455965d+1*t101
     4         *t124*t125*t76+6.077066496460795d+1*t101*t124*t125*t75-6.
     5         077066496460795d+1*t101*t122*t123*t75+7.596333120575993d+
     6         1*t101*t122*t123*t74-7.596333120575993d+1*t101*t120*t121*
     7         t74+9.115599744691193d+1*t101*t120*t121*t73-9.11559974469
     8         1193d+1*t101*t118*t119*t73+1.0634866368806391d+2*t101*t11
     9         8*t119*t72-1.0634866368806391d+2*t101*t116*t117*t72+1.215
     :         4132992921589d+2*t101*t116*t117*t71-1.2154132992921589d+2
     ;         *t101*t114*t115*t71+1.3673399617036788d+2*t101*t114*t115*
     <         t70-1.3673399617036788d+2*t101*t112*t113*t70+1.5192666241
     =         151986d+2*t101*t112*t113*t69-1.5192666241151986d+2*t101*t
     >         110*t111*t69-1.6711932865267184d+2*t101*t108*t154*t68+1.6
     ?         711932865267184d+2*t101*t110*t111*t68
            t158 = 1.5192666241151986d+1*t101*t129*t91-1.519266624115198
     1         6d+1*t101*t107*t128*t91+3.038533248230397d+1*t101*t107*t1
     2         28*t90-3.038533248230397d+1*t101*t126*t127*t90+4.55779987
     3         23455965d+1*t101*t126*t127*t89-4.5577998723455965d+1*t101
     4         *t124*t125*t89+6.077066496460795d+1*t101*t124*t125*t88-6.
     5         077066496460795d+1*t101*t122*t123*t88+7.596333120575993d+
     6         1*t101*t122*t123*t87-7.596333120575993d+1*t101*t120*t121*
     7         t87+9.115599744691193d+1*t101*t120*t121*t86-9.11559974469
     8         1193d+1*t101*t118*t119*t86+1.0634866368806391d+2*t101*t11
     9         8*t119*t85-1.0634866368806391d+2*t101*t116*t117*t85+1.215
     :         4132992921589d+2*t101*t116*t117*t84-1.2154132992921589d+2
     ;         *t101*t114*t115*t84+1.3673399617036788d+2*t101*t114*t115*
     <         t83-1.3673399617036788d+2*t101*t112*t113*t83+1.5192666241
     =         151986d+2*t101*t112*t113*t82-1.5192666241151986d+2*t101*t
     >         110*t111*t82-1.6711932865267184d+2*t101*t108*t154*t81+1.6
     ?         711932865267184d+2*t101*t110*t111*t81
            t159 = 1/t94**2
            t160 = 1/rhob**2.3333333333333334d+0
            t161 = 1/t96
            t162 = rhob**2
            t163 = 1/t162
            t164 = 2.63857249068588d-4*t163-4.2759414617680735d-2*t161
            t165 = 1/t101
            t166 = -1.6205510657228786d+2*t100*t102*t98+3.68460267341165
     1         05d+1*t102*t148*t165+t102*t164-2.63857249068588d-4*t163+6
     2         .41391219265211d-2*t161
            t167 = 1.4253138205893576d-2*t103*t161-4.275941461768073d-2*
     1         t166*t98
            t168 = 1/rhob**3.6666666666666664d+0
            t169 = 1.2407009817988002d+0*t104*t97-1.2407009817988002d+0*
     1         t97+9.305257363491002d-1*t167*t96
            t170 = -2.0d+0*t48*t49-2.0d+0*t17*t47*t48-4.0d+0*t17*t45*t47
     1         -4.0d+0*t44*t45*t46-6.0d+0*t42*t44*t46-6.0d+0*t41*t42*t43
     2         -8.0d+0*t39*t41*t43-8.0d+0*t38*t39*t40-1.0d+1*t36*t38*t40
     3         -1.0d+1*t35*t36*t37-1.2d+1*t33*t35*t37-1.2d+1*t32*t33*t34
     4         -1.4d+1*t30*t32*t34-1.4d+1*t29*t30*t31-1.6d+1*t27*t29*t31
     5         -1.6d+1*t26*t27*t28-1.8d+1*t24*t26*t28-1.8d+1*t23*t24*t25
     6         -2.0d+1*t21*t23*t25-2.0d+1*t20*t21*t22-2.2d+1*t14*t20*t22
     7         -2.2d+1*t137*t14*t18
            t171 = -2.0d+0*t49*t64-2.0d+0*t17*t47*t64-4.0d+0*t17*t47*t63
     1         -4.0d+0*t44*t46*t63-6.0d+0*t44*t46*t62-6.0d+0*t41*t43*t62
     2         -8.0d+0*t41*t43*t61-8.0d+0*t38*t40*t61-1.0d+1*t38*t40*t60
     3         -1.0d+1*t35*t37*t60-1.2d+1*t35*t37*t59-1.2d+1*t32*t34*t59
     4         -1.4d+1*t32*t34*t58-1.4d+1*t29*t31*t58-1.6d+1*t29*t31*t57
     5         -1.6d+1*t26*t28*t57-1.8d+1*t26*t28*t56-1.8d+1*t23*t25*t56
     6         -2.0d+1*t23*t25*t55-2.0d+1*t20*t22*t55-2.2d+1*t20*t22*t54
     7         -2.2d+1*t137*t18*t54
            t172 = -2.0d+0*t49*t78-2.0d+0*t17*t47*t78-4.0d+0*t17*t47*t77
     1         -4.0d+0*t44*t46*t77-6.0d+0*t44*t46*t76-6.0d+0*t41*t43*t76
     2         -8.0d+0*t41*t43*t75-8.0d+0*t38*t40*t75-1.0d+1*t38*t40*t74
     3         -1.0d+1*t35*t37*t74-1.2d+1*t35*t37*t73-1.2d+1*t32*t34*t73
     4         -1.4d+1*t32*t34*t72-1.4d+1*t29*t31*t72-1.6d+1*t29*t31*t71
     5         -1.6d+1*t26*t28*t71-1.8d+1*t26*t28*t70-1.8d+1*t23*t25*t70
     6         -2.0d+1*t23*t25*t69-2.0d+1*t20*t22*t69-2.2d+1*t20*t22*t68
     7         -2.2d+1*t137*t18*t68
            t173 = -2.0d+0*t49*t91-2.0d+0*t17*t47*t91-4.0d+0*t17*t47*t90
     1         -4.0d+0*t44*t46*t90-6.0d+0*t44*t46*t89-6.0d+0*t41*t43*t89
     2         -8.0d+0*t41*t43*t88-8.0d+0*t38*t40*t88-1.0d+1*t38*t40*t87
     3         -1.0d+1*t35*t37*t87-1.2d+1*t35*t37*t86-1.2d+1*t32*t34*t86
     4         -1.4d+1*t32*t34*t85-1.4d+1*t29*t31*t85-1.6d+1*t29*t31*t84
     5         -1.6d+1*t26*t28*t84-1.8d+1*t26*t28*t83-1.8d+1*t23*t25*t83
     6         -2.0d+1*t23*t25*t82-2.0d+1*t20*t22*t82-2.2d+1*t20*t22*t81
     7         -2.2d+1*t137*t18*t81
            t174 = -2.0d+0*t129*t48-2.0d+0*t107*t128*t48-4.0d+0*t107*t12
     1         8*t45-4.0d+0*t126*t127*t45-6.0d+0*t126*t127*t42-6.0d+0*t1
     2         24*t125*t42-8.0d+0*t124*t125*t39-8.0d+0*t122*t123*t39-1.0
     3         d+1*t122*t123*t36-1.0d+1*t120*t121*t36-1.2d+1*t120*t121*t
     4         33-1.2d+1*t118*t119*t33-1.4d+1*t118*t119*t30-1.4d+1*t116*
     5         t117*t30-1.6d+1*t116*t117*t27-1.6d+1*t114*t115*t27-1.8d+1
     6         *t114*t115*t24-1.8d+1*t112*t113*t24-2.0d+1*t112*t113*t21-
     7         2.0d+1*t110*t111*t21-2.2d+1*t108*t14*t154-2.2d+1*t110*t11
     8         1*t14
            t175 = -2.0d+0*t129*t64-2.0d+0*t107*t128*t64-4.0d+0*t107*t12
     1         8*t63-4.0d+0*t126*t127*t63-6.0d+0*t126*t127*t62-6.0d+0*t1
     2         24*t125*t62-8.0d+0*t124*t125*t61-8.0d+0*t122*t123*t61-1.0
     3         d+1*t122*t123*t60-1.0d+1*t120*t121*t60-1.2d+1*t120*t121*t
     4         59-1.2d+1*t118*t119*t59-1.4d+1*t118*t119*t58-1.4d+1*t116*
     5         t117*t58-1.6d+1*t116*t117*t57-1.6d+1*t114*t115*t57-1.8d+1
     6         *t114*t115*t56-1.8d+1*t112*t113*t56-2.0d+1*t112*t113*t55-
     7         2.0d+1*t110*t111*t55-2.2d+1*t108*t154*t54-2.2d+1*t110*t11
     8         1*t54
            t176 = -2.0d+0*t129*t78-2.0d+0*t107*t128*t78-4.0d+0*t107*t12
     1         8*t77-4.0d+0*t126*t127*t77-6.0d+0*t126*t127*t76-6.0d+0*t1
     2         24*t125*t76-8.0d+0*t124*t125*t75-8.0d+0*t122*t123*t75-1.0
     3         d+1*t122*t123*t74-1.0d+1*t120*t121*t74-1.2d+1*t120*t121*t
     4         73-1.2d+1*t118*t119*t73-1.4d+1*t118*t119*t72-1.4d+1*t116*
     5         t117*t72-1.6d+1*t116*t117*t71-1.6d+1*t114*t115*t71-1.8d+1
     6         *t114*t115*t70-1.8d+1*t112*t113*t70-2.0d+1*t112*t113*t69-
     7         2.0d+1*t110*t111*t69-2.2d+1*t108*t154*t68-2.2d+1*t110*t11
     8         1*t68
            t177 = -2.0d+0*t129*t91-2.0d+0*t107*t128*t91-4.0d+0*t107*t12
     1         8*t90-4.0d+0*t126*t127*t90-6.0d+0*t126*t127*t89-6.0d+0*t1
     2         24*t125*t89-8.0d+0*t124*t125*t88-8.0d+0*t122*t123*t88-1.0
     3         d+1*t122*t123*t87-1.0d+1*t120*t121*t87-1.2d+1*t120*t121*t
     4         86-1.2d+1*t118*t119*t86-1.4d+1*t118*t119*t85-1.4d+1*t116*
     5         t117*t85-1.6d+1*t116*t117*t84-1.6d+1*t114*t115*t84-1.8d+1
     6         *t114*t115*t83-1.8d+1*t112*t113*t83-2.0d+1*t112*t113*t82-
     7         2.0d+1*t110*t111*t82-2.2d+1*t108*t154*t81-2.2d+1*t110*t11
     8         1*t81
            t178 = 1/t19**13
            t179 = 1.0128444160767991d+1*t48*t49*t6-1.0128444160767991d+
     1         1*t17*t47*t48*t6+2.0256888321535982d+1*t17*t45*t47*t6-2.0
     2         256888321535982d+1*t44*t45*t46*t6+3.038533248230397d+1*t4
     3         2*t44*t46*t6-3.038533248230397d+1*t41*t42*t43*t6+4.051377
     4         6643071964d+1*t39*t41*t43*t6-4.0513776643071964d+1*t38*t3
     5         9*t40*t6+5.064222080383994d+1*t36*t38*t40*t6-5.0642220803
     6         83994d+1*t35*t36*t37*t6+6.077066496460795d+1*t33*t35*t37*
     7         t6-6.077066496460795d+1*t32*t33*t34*t6+7.089910912537593d
     8         +1*t30*t32*t34*t6-7.089910912537593d+1*t29*t30*t31*t6+8.1
     9         02755328614393d+1*t27*t29*t31*t6-8.102755328614393d+1*t26
     :         *t27*t28*t6+9.115599744691191d+1*t24*t26*t28*t6-9.1155997
     ;         44691191d+1*t23*t24*t25*t6+1.012844416076799d+2*t21*t23*t
     <         25*t6-1.012844416076799d+2*t20*t21*t22*t6+1.1141288576844
     =         789d+2*t14*t20*t22*t6-1.1141288576844789d+2*t137*t14*t18*
     >         t6-4.6163421503007845d+2*t4*t47*t48+4.6163421503007845d+2
     ?         *t17*t4*t44*t48+4.6163421503007845d+2*t4*t45*t47+1.384902
     @         6450902355d+3*t4*t41*t45*t46-4.1547079352707067d+3*t4*t41
     1         *t42*t46+2.769805290180471d+3*t39*t4*t41*t46-1.8465368601
     2         20314d+3*t17*t4*t44*t45+1.3849026450902355d+3*t17*t4*t42*
     3         t44+2.769805290180471d+3*t38*t4*t42*t43-7.386147440481255
     4         d+3*t38*t39*t4*t43+4.616342150300784d+3*t36*t38*t4*t43+4.
     5         616342150300784d+3*t35*t39*t4*t40-1.154085537575196d+4*t3
     6         5*t36*t4*t40+6.924513225451178d+3*t33*t35*t4*t40+6.924513
     7         225451178d+3*t32*t36*t37*t4-1.661883174108283d+4*t32*t33*
     8         t37*t4+9.694318515631648d+3*t30*t32*t37*t4+9.694318515631
     9         648d+3*t29*t33*t34*t4-2.2620076536473846d+4*t29*t30*t34*t
     :         4+1.2925758020842196d+4*t27*t29*t34*t4+1.2925758020842196
     ;         d+4*t26*t30*t31*t4-2.954458976192502d+4*t26*t27*t31*t4+1.
     <         6618831741082823d+4*t24*t26*t31*t4+1.6618831741082823d+4*
     =         t23*t27*t28*t4-3.7392371417436354d+4*t23*t24*t28*t4+2.077
     >         3539676353528d+4*t21*t23*t28*t4+2.0773539676353528d+4*t20
     ?         *t24*t25*t4-4.616342150300784d+4*t20*t21*t25*t4+2.5389881
     @         826654315d+4*t14*t20*t25*t4+2.5389881826654315d+4*t137*t2
     1         1*t22*t4-5.585774001863949d+4*t137*t14*t22*t4+3.046785819
     2         198518d+4*t14*t178*t18*t4
            t180 = 1.0128444160767991d+1*t49*t6*t64-1.0128444160767991d+
     1         1*t17*t47*t6*t64-4.6163421503007845d+2*t4*t47*t64+4.61634
     2         21503007845d+2*t17*t4*t44*t64+2.0256888321535982d+1*t17*t
     3         47*t6*t63-2.0256888321535982d+1*t44*t46*t6*t63+4.61634215
     4         03007845d+2*t4*t47*t63+1.3849026450902355d+3*t4*t41*t46*t
     5         63-1.846536860120314d+3*t17*t4*t44*t63+3.038533248230397d
     6         +1*t44*t46*t6*t62-3.038533248230397d+1*t41*t43*t6*t62-4.1
     7         547079352707067d+3*t4*t41*t46*t62+1.3849026450902355d+3*t
     8         17*t4*t44*t62+2.769805290180471d+3*t38*t4*t43*t62+4.05137
     9         76643071964d+1*t41*t43*t6*t61-4.0513776643071964d+1*t38*t
     :         40*t6*t61+2.769805290180471d+3*t4*t41*t46*t61-7.386147440
     ;         481255d+3*t38*t4*t43*t61+4.616342150300784d+3*t35*t4*t40*
     <         t61+5.064222080383994d+1*t38*t40*t6*t60-5.064222080383994
     =         d+1*t35*t37*t6*t60+4.616342150300784d+3*t38*t4*t43*t60-1.
     >         154085537575196d+4*t35*t4*t40*t60+6.924513225451178d+3*t3
     ?         2*t37*t4*t60+6.077066496460795d+1*t35*t37*t59*t6-6.077066
     @         496460795d+1*t32*t34*t59*t6+7.089910912537593d+1*t32*t34*
     1         t58*t6-7.089910912537593d+1*t29*t31*t58*t6+8.102755328614
     2         393d+1*t29*t31*t57*t6-8.102755328614393d+1*t26*t28*t57*t6
     3         +9.115599744691191d+1*t26*t28*t56*t6-9.115599744691191d+1
     4         *t23*t25*t56*t6+1.012844416076799d+2*t23*t25*t55*t6-1.012
     5         844416076799d+2*t20*t22*t55*t6+1.1141288576844789d+2*t20*
     6         t22*t54*t6-1.1141288576844789d+2*t137*t18*t54*t6+6.924513
     7         225451178d+3*t35*t4*t40*t59-1.661883174108283d+4*t32*t37*
     8         t4*t59+9.694318515631648d+3*t29*t34*t4*t59+9.694318515631
     9         648d+3*t32*t37*t4*t58-2.2620076536473846d+4*t29*t34*t4*t5
     :         8+1.2925758020842196d+4*t26*t31*t4*t58+1.2925758020842196
     ;         d+4*t29*t34*t4*t57-2.954458976192502d+4*t26*t31*t4*t57+1.
     <         6618831741082823d+4*t23*t28*t4*t57+1.6618831741082823d+4*
     =         t26*t31*t4*t56-3.7392371417436354d+4*t23*t28*t4*t56+2.077
     >         3539676353528d+4*t20*t25*t4*t56+2.0773539676353528d+4*t23
     ?         *t28*t4*t55-4.616342150300784d+4*t20*t25*t4*t55+2.5389881
     @         826654315d+4*t137*t22*t4*t55+2.5389881826654315d+4*t20*t2
     1         5*t4*t54-5.585774001863949d+4*t137*t22*t4*t54+3.046785819
     2         198518d+4*t178*t18*t4*t54
            t181 = 1.0128444160767991d+1*t49*t6*t78-1.0128444160767991d+
     1         1*t17*t47*t6*t78-4.6163421503007845d+2*t4*t47*t78+4.61634
     2         21503007845d+2*t17*t4*t44*t78+2.0256888321535982d+1*t17*t
     3         47*t6*t77-2.0256888321535982d+1*t44*t46*t6*t77+4.61634215
     4         03007845d+2*t4*t47*t77+1.3849026450902355d+3*t4*t41*t46*t
     5         77-1.846536860120314d+3*t17*t4*t44*t77+3.038533248230397d
     6         +1*t44*t46*t6*t76-3.038533248230397d+1*t41*t43*t6*t76-4.1
     7         547079352707067d+3*t4*t41*t46*t76+1.3849026450902355d+3*t
     8         17*t4*t44*t76+2.769805290180471d+3*t38*t4*t43*t76+4.05137
     9         76643071964d+1*t41*t43*t6*t75-4.0513776643071964d+1*t38*t
     :         40*t6*t75+2.769805290180471d+3*t4*t41*t46*t75-7.386147440
     ;         481255d+3*t38*t4*t43*t75+4.616342150300784d+3*t35*t4*t40*
     <         t75+5.064222080383994d+1*t38*t40*t6*t74-5.064222080383994
     =         d+1*t35*t37*t6*t74+4.616342150300784d+3*t38*t4*t43*t74-1.
     >         154085537575196d+4*t35*t4*t40*t74+6.924513225451178d+3*t3
     ?         2*t37*t4*t74+6.077066496460795d+1*t35*t37*t6*t73-6.077066
     @         496460795d+1*t32*t34*t6*t73+6.924513225451178d+3*t35*t4*t
     1         40*t73-1.661883174108283d+4*t32*t37*t4*t73+9.694318515631
     2         648d+3*t29*t34*t4*t73+7.089910912537593d+1*t32*t34*t6*t72
     3         -7.089910912537593d+1*t29*t31*t6*t72+9.694318515631648d+3
     4         *t32*t37*t4*t72-2.2620076536473846d+4*t29*t34*t4*t72+1.29
     5         25758020842196d+4*t26*t31*t4*t72+8.102755328614393d+1*t29
     6         *t31*t6*t71-8.102755328614393d+1*t26*t28*t6*t71+1.2925758
     7         020842196d+4*t29*t34*t4*t71-2.954458976192502d+4*t26*t31*
     8         t4*t71+1.6618831741082823d+4*t23*t28*t4*t71+9.11559974469
     9         1191d+1*t26*t28*t6*t70-9.115599744691191d+1*t23*t25*t6*t7
     :         0+1.6618831741082823d+4*t26*t31*t4*t70-3.7392371417436354
     ;         d+4*t23*t28*t4*t70+2.0773539676353528d+4*t20*t25*t4*t70+1
     <         .012844416076799d+2*t23*t25*t6*t69-1.012844416076799d+2*t
     =         20*t22*t6*t69+2.0773539676353528d+4*t23*t28*t4*t69-4.6163
     >         42150300784d+4*t20*t25*t4*t69+2.5389881826654315d+4*t137*
     ?         t22*t4*t69+1.1141288576844789d+2*t20*t22*t6*t68-1.1141288
     @         576844789d+2*t137*t18*t6*t68+2.5389881826654315d+4*t20*t2
     1         5*t4*t68-5.585774001863949d+4*t137*t22*t4*t68+3.046785819
     2         198518d+4*t178*t18*t4*t68
            t182 = 1.0128444160767991d+1*t49*t6*t91-1.0128444160767991d+
     1         1*t17*t47*t6*t91-4.6163421503007845d+2*t4*t47*t91+4.61634
     2         21503007845d+2*t17*t4*t44*t91+2.0256888321535982d+1*t17*t
     3         47*t6*t90-2.0256888321535982d+1*t44*t46*t6*t90+4.61634215
     4         03007845d+2*t4*t47*t90+1.3849026450902355d+3*t4*t41*t46*t
     5         90-1.846536860120314d+3*t17*t4*t44*t90+3.038533248230397d
     6         +1*t44*t46*t6*t89-3.038533248230397d+1*t41*t43*t6*t89-4.1
     7         547079352707067d+3*t4*t41*t46*t89+1.3849026450902355d+3*t
     8         17*t4*t44*t89+2.769805290180471d+3*t38*t4*t43*t89+4.05137
     9         76643071964d+1*t41*t43*t6*t88-4.0513776643071964d+1*t38*t
     :         40*t6*t88+2.769805290180471d+3*t4*t41*t46*t88-7.386147440
     ;         481255d+3*t38*t4*t43*t88+4.616342150300784d+3*t35*t4*t40*
     <         t88+5.064222080383994d+1*t38*t40*t6*t87-5.064222080383994
     =         d+1*t35*t37*t6*t87+4.616342150300784d+3*t38*t4*t43*t87-1.
     >         154085537575196d+4*t35*t4*t40*t87+6.924513225451178d+3*t3
     ?         2*t37*t4*t87+6.077066496460795d+1*t35*t37*t6*t86-6.077066
     @         496460795d+1*t32*t34*t6*t86+6.924513225451178d+3*t35*t4*t
     1         40*t86-1.661883174108283d+4*t32*t37*t4*t86+9.694318515631
     2         648d+3*t29*t34*t4*t86+7.089910912537593d+1*t32*t34*t6*t85
     3         -7.089910912537593d+1*t29*t31*t6*t85+9.694318515631648d+3
     4         *t32*t37*t4*t85-2.2620076536473846d+4*t29*t34*t4*t85+1.29
     5         25758020842196d+4*t26*t31*t4*t85+8.102755328614393d+1*t29
     6         *t31*t6*t84-8.102755328614393d+1*t26*t28*t6*t84+1.2925758
     7         020842196d+4*t29*t34*t4*t84-2.954458976192502d+4*t26*t31*
     8         t4*t84+1.6618831741082823d+4*t23*t28*t4*t84+9.11559974469
     9         1191d+1*t26*t28*t6*t83-9.115599744691191d+1*t23*t25*t6*t8
     :         3+1.6618831741082823d+4*t26*t31*t4*t83-3.7392371417436354
     ;         d+4*t23*t28*t4*t83+2.0773539676353528d+4*t20*t25*t4*t83+1
     <         .012844416076799d+2*t23*t25*t6*t82-1.012844416076799d+2*t
     =         20*t22*t6*t82+2.0773539676353528d+4*t23*t28*t4*t82-4.6163
     >         42150300784d+4*t20*t25*t4*t82+2.5389881826654315d+4*t137*
     ?         t22*t4*t82+1.1141288576844789d+2*t20*t22*t6*t81-1.1141288
     @         576844789d+2*t137*t18*t6*t81+2.5389881826654315d+4*t20*t2
     1         5*t4*t81-5.585774001863949d+4*t137*t22*t4*t81+3.046785819
     2         198518d+4*t178*t18*t4*t81
            t183 = gammaaa**2
            t184 = 1/t2**3
            t185 = 1/rhoa**6
            t186 = 1/rhoa**3.3333333333333337d+0
            t187 = 1/rhoa**3
            t188 = 5.701255282357431d-2*t143-5.27714498137176d-4*t187
            t189 = 1/t15
            t190 = 2.626185756615557d+4*t10*t149*t8+5.401836885742928d+1
     1         *t10*t144*t8-5.971086789162617d+3*t10*t148*t7-3.241102131
     2         445757d+2*t10*t147*t6-2.4564017822744336d+1*t10*t148*t189
     3         +t10*t188+5.27714498137176d-4*t187-8.551882923536147d-2*t
     4         143
            t191 = -4.275941461768073d-2*t190*t6+2.850627641178715d-2*t1
     1         44*t150-1.9004184274524766d-2*t11*t143
            t192 = 1/rhoa**7.333333333333333d+0
            t193 = 1/rhoa**4.666666666666667d+0
            t194 = 2.4814019635976003d+0*t151*t5+9.305257363491002d-1*t1
     1         91*t4+4.135669939329334d-1*t12*t149-4.135669939329334d-1*
     2         t149
            t195 = 1.7926167019779404d-2*gammaaa*t151*t50+1.792616701977
     1         9404d-2*gammaaa*t12*t138
            t196 = -4.135669939329334d-1*t12*t52*t65-4.135669939329334d-
     1         1*t12*t3*t50
            t197 = 1.0082032889066277d-2*gammaaa*t151*t51*t65+1.00820328
     1         89066277d-2*gammaaa*t12*t139*t51
            t198 = -1.9264558001493193d-2*gammaaa*t153*t79-1.92645580014
     1         93193d-2*gammaaa*t140*t66
            t199 = -1.0834770598202839d-2*gammaaa*t153*t51*t92-1.0834770
     1         598202839d-2*gammaaa*t141*t51*t66
            t200 = 1/t109**13
            t201 = 1.0128444160767991d+1*t129*t48*t98-1.0128444160767991
     1         d+1*t107*t128*t48*t98+2.0256888321535982d+1*t107*t128*t45
     2         *t98-2.0256888321535982d+1*t126*t127*t45*t98+3.0385332482
     3         30397d+1*t126*t127*t42*t98-3.038533248230397d+1*t124*t125
     4         *t42*t98+4.0513776643071964d+1*t124*t125*t39*t98-4.051377
     5         6643071964d+1*t122*t123*t39*t98+5.064222080383994d+1*t122
     6         *t123*t36*t98-5.064222080383994d+1*t120*t121*t36*t98+6.07
     7         7066496460795d+1*t120*t121*t33*t98-6.077066496460795d+1*t
     8         118*t119*t33*t98+7.089910912537593d+1*t118*t119*t30*t98-7
     9         .089910912537593d+1*t116*t117*t30*t98+8.102755328614393d+
     :         1*t116*t117*t27*t98-8.102755328614393d+1*t114*t115*t27*t9
     ;         8+9.115599744691191d+1*t114*t115*t24*t98-9.11559974469119
     <         1d+1*t112*t113*t24*t98+1.012844416076799d+2*t112*t113*t21
     =         *t98-1.012844416076799d+2*t110*t111*t21*t98-1.11412885768
     >         44789d+2*t108*t14*t154*t98+1.1141288576844789d+2*t110*t11
     ?         1*t14*t98-4.6163421503007845d+2*t128*t48*t96+4.6163421503
     @         007845d+2*t107*t126*t48*t96+4.6163421503007845d+2*t128*t4
     1         5*t96+1.3849026450902355d+3*t124*t127*t45*t96-1.846536860
     2         120314d+3*t107*t126*t45*t96-4.1547079352707067d+3*t124*t1
     3         27*t42*t96+1.3849026450902355d+3*t107*t126*t42*t96+2.7698
     4         05290180471d+3*t122*t125*t42*t96+2.769805290180471d+3*t12
     5         4*t127*t39*t96-7.386147440481255d+3*t122*t125*t39*t96+4.6
     6         16342150300784d+3*t120*t123*t39*t96+4.616342150300784d+3*
     7         t122*t125*t36*t96-1.154085537575196d+4*t120*t123*t36*t96+
     8         6.924513225451178d+3*t118*t121*t36*t96+6.924513225451178d
     9         +3*t120*t123*t33*t96-1.661883174108283d+4*t118*t121*t33*t
     :         96+9.694318515631648d+3*t116*t119*t33*t96+9.6943185156316
     ;         48d+3*t118*t121*t30*t96-2.2620076536473846d+4*t116*t119*t
     <         30*t96+1.2925758020842196d+4*t114*t117*t30*t96+1.29257580
     =         20842196d+4*t116*t119*t27*t96-2.954458976192502d+4*t114*t
     >         117*t27*t96+1.6618831741082823d+4*t112*t115*t27*t96+1.661
     ?         8831741082823d+4*t114*t117*t24*t96-3.7392371417436354d+4*
     @         t112*t115*t24*t96+2.0773539676353528d+4*t110*t113*t24*t96
     1         +2.5389881826654315d+4*t111*t154*t21*t96+2.07735396763535
     2         28d+4*t112*t115*t21*t96-4.616342150300784d+4*t110*t113*t2
     3         1*t96+3.046785819198518d+4*t108*t14*t200*t96-5.5857740018
     4         63949d+4*t111*t14*t154*t96+2.5389881826654315d+4*t110*t11
     5         3*t14*t96
            t202 = 1.0128444160767991d+1*t129*t64*t98-1.0128444160767991
     1         d+1*t107*t128*t64*t98+2.0256888321535982d+1*t107*t128*t63
     2         *t98-2.0256888321535982d+1*t126*t127*t63*t98+3.0385332482
     3         30397d+1*t126*t127*t62*t98-3.038533248230397d+1*t124*t125
     4         *t62*t98+4.0513776643071964d+1*t124*t125*t61*t98-4.051377
     5         6643071964d+1*t122*t123*t61*t98+5.064222080383994d+1*t122
     6         *t123*t60*t98-5.064222080383994d+1*t120*t121*t60*t98+6.07
     7         7066496460795d+1*t120*t121*t59*t98-6.077066496460795d+1*t
     8         118*t119*t59*t98+7.089910912537593d+1*t118*t119*t58*t98-7
     9         .089910912537593d+1*t116*t117*t58*t98+8.102755328614393d+
     :         1*t116*t117*t57*t98-8.102755328614393d+1*t114*t115*t57*t9
     ;         8+9.115599744691191d+1*t114*t115*t56*t98-9.11559974469119
     <         1d+1*t112*t113*t56*t98+1.012844416076799d+2*t112*t113*t55
     =         *t98-1.012844416076799d+2*t110*t111*t55*t98-1.11412885768
     >         44789d+2*t108*t154*t54*t98+1.1141288576844789d+2*t110*t11
     ?         1*t54*t98-4.6163421503007845d+2*t128*t64*t96+4.6163421503
     @         007845d+2*t107*t126*t64*t96+4.6163421503007845d+2*t128*t6
     1         3*t96+1.3849026450902355d+3*t124*t127*t63*t96-1.846536860
     2         120314d+3*t107*t126*t63*t96-4.1547079352707067d+3*t124*t1
     3         27*t62*t96+1.3849026450902355d+3*t107*t126*t62*t96+2.7698
     4         05290180471d+3*t122*t125*t62*t96+2.769805290180471d+3*t12
     5         4*t127*t61*t96-7.386147440481255d+3*t122*t125*t61*t96+4.6
     6         16342150300784d+3*t120*t123*t61*t96+4.616342150300784d+3*
     7         t122*t125*t60*t96-1.154085537575196d+4*t120*t123*t60*t96+
     8         6.924513225451178d+3*t118*t121*t60*t96+6.924513225451178d
     9         +3*t120*t123*t59*t96-1.661883174108283d+4*t118*t121*t59*t
     :         96+9.694318515631648d+3*t116*t119*t59*t96+9.6943185156316
     ;         48d+3*t118*t121*t58*t96-2.2620076536473846d+4*t116*t119*t
     <         58*t96+1.2925758020842196d+4*t114*t117*t58*t96+1.29257580
     =         20842196d+4*t116*t119*t57*t96-2.954458976192502d+4*t114*t
     >         117*t57*t96+1.6618831741082823d+4*t112*t115*t57*t96+1.661
     ?         8831741082823d+4*t114*t117*t56*t96-3.7392371417436354d+4*
     @         t112*t115*t56*t96+2.0773539676353528d+4*t110*t113*t56*t96
     1         +2.5389881826654315d+4*t111*t154*t55*t96+2.07735396763535
     2         28d+4*t112*t115*t55*t96-4.616342150300784d+4*t110*t113*t5
     3         5*t96+3.046785819198518d+4*t108*t200*t54*t96-5.5857740018
     4         63949d+4*t111*t154*t54*t96+2.5389881826654315d+4*t110*t11
     5         3*t54*t96
            t203 = 1.0128444160767991d+1*t129*t78*t98-1.0128444160767991
     1         d+1*t107*t128*t78*t98+2.0256888321535982d+1*t107*t128*t77
     2         *t98-2.0256888321535982d+1*t126*t127*t77*t98+3.0385332482
     3         30397d+1*t126*t127*t76*t98-3.038533248230397d+1*t124*t125
     4         *t76*t98+4.0513776643071964d+1*t124*t125*t75*t98-4.051377
     5         6643071964d+1*t122*t123*t75*t98+5.064222080383994d+1*t122
     6         *t123*t74*t98-5.064222080383994d+1*t120*t121*t74*t98+6.07
     7         7066496460795d+1*t120*t121*t73*t98-6.077066496460795d+1*t
     8         118*t119*t73*t98+7.089910912537593d+1*t118*t119*t72*t98-7
     9         .089910912537593d+1*t116*t117*t72*t98+8.102755328614393d+
     :         1*t116*t117*t71*t98-8.102755328614393d+1*t114*t115*t71*t9
     ;         8+9.115599744691191d+1*t114*t115*t70*t98-9.11559974469119
     <         1d+1*t112*t113*t70*t98+1.012844416076799d+2*t112*t113*t69
     =         *t98-1.012844416076799d+2*t110*t111*t69*t98-1.11412885768
     >         44789d+2*t108*t154*t68*t98+1.1141288576844789d+2*t110*t11
     ?         1*t68*t98-4.6163421503007845d+2*t128*t78*t96+4.6163421503
     @         007845d+2*t107*t126*t78*t96+4.6163421503007845d+2*t128*t7
     1         7*t96+1.3849026450902355d+3*t124*t127*t77*t96-1.846536860
     2         120314d+3*t107*t126*t77*t96-4.1547079352707067d+3*t124*t1
     3         27*t76*t96+1.3849026450902355d+3*t107*t126*t76*t96+2.7698
     4         05290180471d+3*t122*t125*t76*t96+2.769805290180471d+3*t12
     5         4*t127*t75*t96-7.386147440481255d+3*t122*t125*t75*t96+4.6
     6         16342150300784d+3*t120*t123*t75*t96+4.616342150300784d+3*
     7         t122*t125*t74*t96-1.154085537575196d+4*t120*t123*t74*t96+
     8         6.924513225451178d+3*t118*t121*t74*t96+6.924513225451178d
     9         +3*t120*t123*t73*t96-1.661883174108283d+4*t118*t121*t73*t
     :         96+9.694318515631648d+3*t116*t119*t73*t96+9.6943185156316
     ;         48d+3*t118*t121*t72*t96-2.2620076536473846d+4*t116*t119*t
     <         72*t96+1.2925758020842196d+4*t114*t117*t72*t96+1.29257580
     =         20842196d+4*t116*t119*t71*t96-2.954458976192502d+4*t114*t
     >         117*t71*t96+1.6618831741082823d+4*t112*t115*t71*t96+1.661
     ?         8831741082823d+4*t114*t117*t70*t96-3.7392371417436354d+4*
     @         t112*t115*t70*t96+2.0773539676353528d+4*t110*t113*t70*t96
     1         +2.5389881826654315d+4*t111*t154*t69*t96+2.07735396763535
     2         28d+4*t112*t115*t69*t96-4.616342150300784d+4*t110*t113*t6
     3         9*t96+3.046785819198518d+4*t108*t200*t68*t96-5.5857740018
     4         63949d+4*t111*t154*t68*t96+2.5389881826654315d+4*t110*t11
     5         3*t68*t96
            t204 = 1.0128444160767991d+1*t129*t91*t98-1.0128444160767991
     1         d+1*t107*t128*t91*t98+2.0256888321535982d+1*t107*t128*t90
     2         *t98-2.0256888321535982d+1*t126*t127*t90*t98+3.0385332482
     3         30397d+1*t126*t127*t89*t98-3.038533248230397d+1*t124*t125
     4         *t89*t98+4.0513776643071964d+1*t124*t125*t88*t98-4.051377
     5         6643071964d+1*t122*t123*t88*t98+5.064222080383994d+1*t122
     6         *t123*t87*t98-5.064222080383994d+1*t120*t121*t87*t98+6.07
     7         7066496460795d+1*t120*t121*t86*t98-6.077066496460795d+1*t
     8         118*t119*t86*t98+7.089910912537593d+1*t118*t119*t85*t98-7
     9         .089910912537593d+1*t116*t117*t85*t98+8.102755328614393d+
     :         1*t116*t117*t84*t98-8.102755328614393d+1*t114*t115*t84*t9
     ;         8+9.115599744691191d+1*t114*t115*t83*t98-9.11559974469119
     <         1d+1*t112*t113*t83*t98+1.012844416076799d+2*t112*t113*t82
     =         *t98-1.012844416076799d+2*t110*t111*t82*t98-1.11412885768
     >         44789d+2*t108*t154*t81*t98+1.1141288576844789d+2*t110*t11
     ?         1*t81*t98-4.6163421503007845d+2*t128*t91*t96+4.6163421503
     @         007845d+2*t107*t126*t91*t96+4.6163421503007845d+2*t128*t9
     1         0*t96+1.3849026450902355d+3*t124*t127*t90*t96-1.846536860
     2         120314d+3*t107*t126*t90*t96-4.1547079352707067d+3*t124*t1
     3         27*t89*t96+1.3849026450902355d+3*t107*t126*t89*t96+2.7698
     4         05290180471d+3*t122*t125*t89*t96+2.769805290180471d+3*t12
     5         4*t127*t88*t96-7.386147440481255d+3*t122*t125*t88*t96+4.6
     6         16342150300784d+3*t120*t123*t88*t96+4.616342150300784d+3*
     7         t122*t125*t87*t96-1.154085537575196d+4*t120*t123*t87*t96+
     8         6.924513225451178d+3*t118*t121*t87*t96+6.924513225451178d
     9         +3*t120*t123*t86*t96-1.661883174108283d+4*t118*t121*t86*t
     :         96+9.694318515631648d+3*t116*t119*t86*t96+9.6943185156316
     ;         48d+3*t118*t121*t85*t96-2.2620076536473846d+4*t116*t119*t
     <         85*t96+1.2925758020842196d+4*t114*t117*t85*t96+1.29257580
     =         20842196d+4*t116*t119*t84*t96-2.954458976192502d+4*t114*t
     >         117*t84*t96+1.6618831741082823d+4*t112*t115*t84*t96+1.661
     ?         8831741082823d+4*t114*t117*t83*t96-3.7392371417436354d+4*
     @         t112*t115*t83*t96+2.0773539676353528d+4*t110*t113*t83*t96
     1         +2.5389881826654315d+4*t111*t154*t82*t96+2.07735396763535
     2         28d+4*t112*t115*t82*t96-4.616342150300784d+4*t110*t113*t8
     3         2*t96+3.046785819198518d+4*t108*t200*t81*t96-5.5857740018
     4         63949d+4*t111*t154*t81*t96+2.5389881826654315d+4*t110*t11
     5         3*t81*t96
            t205 = gammabb**2
            t206 = 1/t94**3
            t207 = 1/rhob**6
            t208 = 1/rhob**3.3333333333333337d+0
            t209 = 1/rhob**3
            t210 = 5.701255282357431d-2*t160-5.27714498137176d-4*t209
            t211 = 1/t105
            t212 = -5.971086789162617d+3*t102*t148*t99-3.241102131445757
     1         d+2*t102*t164*t98-2.4564017822744336d+1*t102*t148*t211+t1
     2         02*t210+5.27714498137176d-4*t209+2.626185756615557d+4*t10
     3         0*t102*t165+5.401836885742928d+1*t100*t102*t161-8.5518829
     4         23536147d-2*t160
            t213 = -4.275941461768073d-2*t212*t98+2.850627641178715d-2*t
     1         161*t166-1.9004184274524766d-2*t103*t160
            t214 = 1/rhob**7.333333333333333d+0
            t215 = 1/rhob**4.666666666666667d+0
            t216 = 2.4814019635976003d+0*t167*t97+9.305257363491002d-1*t
     1         213*t96+4.135669939329334d-1*t104*t165-4.135669939329334d
     2         -1*t165
            t217 = 1.7926167019779404d-2*gammabb*t130*t167+1.79261670197
     1         79404d-2*gammabb*t104*t155
            t218 = -4.135669939329334d-1*t104*t130*t95-4.135669939329334
     1         d-1*t104*t132*t133
            t219 = 1.0082032889066277d-2*gammabb*t131*t133*t167+1.008203
     1         2889066277d-2*gammabb*t104*t131*t156
            t220 = -1.9264558001493193d-2*gammabb*t135*t169-1.9264558001
     1         493193d-2*gammabb*t134*t157
            t221 = -1.0834770598202839d-2*gammabb*t131*t136*t169-1.08347
     1         70598202839d-2*gammabb*t131*t134*t158
            t222 = 1/rhoa**5
            t223 = 1/rhoa**6.333333333333333d+0
            t224 = -3.361156316208638d-3*t151*t50-3.361156316208638d-3*t
     1         12*t138
            t225 = 3.612104625279974d-3*t153*t79+3.612104625279974d-3*t1
     1         40*t66
            t226 = 1/rhob**5
            t227 = 1/rhob**6.333333333333333d+0
            t228 = -3.361156316208638d-3*t130*t167-3.361156316208638d-3*
     1         t104*t155
            t229 = 3.612104625279974d-3*t135*t169+3.612104625279974d-3*t
     1         134*t157
            t230 = 1/rhoa**4
            t231 = 1/rhoa**5.333333333333333d+0
            t232 = 1/rhob**4
            t233 = 1/rhob**5.333333333333333d+0
            t234 = 6.077066496460795d+1*t17*t44*t48*t9-6.077066496460795
     1         d+1*t45*t47*t9+1.8231199489382385d+2*t41*t45*t46*t9-3.646
     2         239897876477d+2*t39*t41*t46*t9-1.8231199489382385d+2*t17*
     3         t42*t44*t9+3.646239897876477d+2*t38*t42*t43*t9-6.07706649
     4         6460795d+2*t36*t38*t43*t9+6.077066496460795d+2*t35*t39*t4
     5         0*t9-9.115599744691192d+2*t33*t35*t40*t9+9.11559974469119
     6         2d+2*t32*t36*t37*t9-1.276183964256767d+3*t30*t32*t37*t9+1
     7         .276183964256767d+3*t29*t33*t34*t9-1.7015786190090226d+3*
     8         t27*t29*t34*t9+1.7015786190090226d+3*t26*t30*t31*t9-2.187
     9         743938725886d+3*t24*t26*t31*t9+2.187743938725886d+3*t23*t
     :         27*t28*t9-2.734679923407357d+3*t21*t23*t28*t9+2.734679923
     ;         407357d+3*t20*t24*t25*t9-3.342386573053437d+3*t14*t20*t25
     <         *t9+3.342386573053437d+3*t137*t21*t22*t9+4.01086388766412
     =         45d+3*t14*t178*t18*t9
            t235 = 6.077066496460795d+1*t17*t44*t64*t9-6.077066496460795
     1         d+1*t47*t63*t9+1.8231199489382385d+2*t41*t46*t63*t9-1.823
     2         1199489382385d+2*t17*t44*t62*t9+3.646239897876477d+2*t38*
     3         t43*t62*t9-3.646239897876477d+2*t41*t46*t61*t9+6.07706649
     4         6460795d+2*t35*t40*t61*t9-6.077066496460795d+2*t38*t43*t6
     5         0*t9+9.115599744691192d+2*t32*t37*t60*t9-9.11559974469119
     6         2d+2*t35*t40*t59*t9+1.276183964256767d+3*t29*t34*t59*t9-1
     7         .276183964256767d+3*t32*t37*t58*t9+1.7015786190090226d+3*
     8         t26*t31*t58*t9-1.7015786190090226d+3*t29*t34*t57*t9+2.187
     9         743938725886d+3*t23*t28*t57*t9-2.187743938725886d+3*t26*t
     :         31*t56*t9+2.734679923407357d+3*t20*t25*t56*t9-2.734679923
     ;         407357d+3*t23*t28*t55*t9+3.342386573053437d+3*t137*t22*t5
     <         5*t9-3.342386573053437d+3*t20*t25*t54*t9+4.01086388766412
     =         45d+3*t178*t18*t54*t9
            t236 = 6.077066496460795d+1*t17*t44*t78*t9-6.077066496460795
     1         d+1*t47*t77*t9+1.8231199489382385d+2*t41*t46*t77*t9-1.823
     2         1199489382385d+2*t17*t44*t76*t9+3.646239897876477d+2*t38*
     3         t43*t76*t9-3.646239897876477d+2*t41*t46*t75*t9+6.07706649
     4         6460795d+2*t35*t40*t75*t9-6.077066496460795d+2*t38*t43*t7
     5         4*t9+9.115599744691192d+2*t32*t37*t74*t9-9.11559974469119
     6         2d+2*t35*t40*t73*t9+1.276183964256767d+3*t29*t34*t73*t9-1
     7         .276183964256767d+3*t32*t37*t72*t9+1.7015786190090226d+3*
     8         t26*t31*t72*t9-1.7015786190090226d+3*t29*t34*t71*t9+2.187
     9         743938725886d+3*t23*t28*t71*t9-2.187743938725886d+3*t26*t
     :         31*t70*t9+2.734679923407357d+3*t20*t25*t70*t9-2.734679923
     ;         407357d+3*t23*t28*t69*t9+3.342386573053437d+3*t137*t22*t6
     <         9*t9-3.342386573053437d+3*t20*t25*t68*t9+4.01086388766412
     =         45d+3*t178*t18*t68*t9
            t237 = 6.077066496460795d+1*t17*t44*t9*t91-6.077066496460795
     1         d+1*t47*t9*t90+1.8231199489382385d+2*t41*t46*t9*t90-1.823
     2         1199489382385d+2*t17*t44*t89*t9+3.646239897876477d+2*t38*
     3         t43*t89*t9-3.646239897876477d+2*t41*t46*t88*t9+6.07706649
     4         6460795d+2*t35*t40*t88*t9-6.077066496460795d+2*t38*t43*t8
     5         7*t9+9.115599744691192d+2*t32*t37*t87*t9-9.11559974469119
     6         2d+2*t35*t40*t86*t9+1.276183964256767d+3*t29*t34*t86*t9-1
     7         .276183964256767d+3*t32*t37*t85*t9+1.7015786190090226d+3*
     8         t26*t31*t85*t9-1.7015786190090226d+3*t29*t34*t84*t9+2.187
     9         743938725886d+3*t23*t28*t84*t9-2.187743938725886d+3*t26*t
     :         31*t83*t9+2.734679923407357d+3*t20*t25*t83*t9-2.734679923
     ;         407357d+3*t23*t28*t82*t9+3.342386573053437d+3*t137*t22*t8
     <         2*t9-3.342386573053437d+3*t20*t25*t81*t9+4.01086388766412
     =         45d+3*t178*t18*t81*t9
            t238 = 6.077066496460795d+1*t101*t107*t126*t48-6.07706649646
     1         0795d+1*t101*t128*t45+1.8231199489382385d+2*t101*t124*t12
     2         7*t45-1.8231199489382385d+2*t101*t107*t126*t42+3.64623989
     3         7876477d+2*t101*t122*t125*t42-3.646239897876477d+2*t101*t
     4         124*t127*t39+6.077066496460795d+2*t101*t120*t123*t39-6.07
     5         7066496460795d+2*t101*t122*t125*t36+9.115599744691192d+2*
     6         t101*t118*t121*t36-9.115599744691192d+2*t101*t120*t123*t3
     7         3+1.276183964256767d+3*t101*t116*t119*t33-1.2761839642567
     8         67d+3*t101*t118*t121*t30+1.7015786190090226d+3*t101*t114*
     9         t117*t30-1.7015786190090226d+3*t101*t116*t119*t27+2.18774
     :         3938725886d+3*t101*t112*t115*t27-2.187743938725886d+3*t10
     ;         1*t114*t117*t24+2.734679923407357d+3*t101*t110*t113*t24+3
     <         .342386573053437d+3*t101*t111*t154*t21-2.734679923407357d
     =         +3*t101*t112*t115*t21+4.0108638876641245d+3*t101*t108*t14
     >         *t200-3.342386573053437d+3*t101*t110*t113*t14
            t239 = 6.077066496460795d+1*t101*t107*t126*t64-6.07706649646
     1         0795d+1*t101*t128*t63+1.8231199489382385d+2*t101*t124*t12
     2         7*t63-1.8231199489382385d+2*t101*t107*t126*t62+3.64623989
     3         7876477d+2*t101*t122*t125*t62-3.646239897876477d+2*t101*t
     4         124*t127*t61+6.077066496460795d+2*t101*t120*t123*t61-6.07
     5         7066496460795d+2*t101*t122*t125*t60+9.115599744691192d+2*
     6         t101*t118*t121*t60-9.115599744691192d+2*t101*t120*t123*t5
     7         9+1.276183964256767d+3*t101*t116*t119*t59-1.2761839642567
     8         67d+3*t101*t118*t121*t58+1.7015786190090226d+3*t101*t114*
     9         t117*t58-1.7015786190090226d+3*t101*t116*t119*t57+2.18774
     :         3938725886d+3*t101*t112*t115*t57-2.187743938725886d+3*t10
     ;         1*t114*t117*t56+2.734679923407357d+3*t101*t110*t113*t56+3
     <         .342386573053437d+3*t101*t111*t154*t55-2.734679923407357d
     =         +3*t101*t112*t115*t55+4.0108638876641245d+3*t101*t108*t20
     >         0*t54-3.342386573053437d+3*t101*t110*t113*t54
            t240 = 6.077066496460795d+1*t101*t107*t126*t78-6.07706649646
     1         0795d+1*t101*t128*t77+1.8231199489382385d+2*t101*t124*t12
     2         7*t77-1.8231199489382385d+2*t101*t107*t126*t76+3.64623989
     3         7876477d+2*t101*t122*t125*t76-3.646239897876477d+2*t101*t
     4         124*t127*t75+6.077066496460795d+2*t101*t120*t123*t75-6.07
     5         7066496460795d+2*t101*t122*t125*t74+9.115599744691192d+2*
     6         t101*t118*t121*t74-9.115599744691192d+2*t101*t120*t123*t7
     7         3+1.276183964256767d+3*t101*t116*t119*t73-1.2761839642567
     8         67d+3*t101*t118*t121*t72+1.7015786190090226d+3*t101*t114*
     9         t117*t72-1.7015786190090226d+3*t101*t116*t119*t71+2.18774
     :         3938725886d+3*t101*t112*t115*t71-2.187743938725886d+3*t10
     ;         1*t114*t117*t70+2.734679923407357d+3*t101*t110*t113*t70+3
     <         .342386573053437d+3*t101*t111*t154*t69-2.734679923407357d
     =         +3*t101*t112*t115*t69+4.0108638876641245d+3*t101*t108*t20
     >         0*t68-3.342386573053437d+3*t101*t110*t113*t68
            t241 = 6.077066496460795d+1*t101*t107*t126*t91-6.07706649646
     1         0795d+1*t101*t128*t90+1.8231199489382385d+2*t101*t124*t12
     2         7*t90-1.8231199489382385d+2*t101*t107*t126*t89+3.64623989
     3         7876477d+2*t101*t122*t125*t89-3.646239897876477d+2*t101*t
     4         124*t127*t88+6.077066496460795d+2*t101*t120*t123*t88-6.07
     5         7066496460795d+2*t101*t122*t125*t87+9.115599744691192d+2*
     6         t101*t118*t121*t87-9.115599744691192d+2*t101*t120*t123*t8
     7         6+1.276183964256767d+3*t101*t116*t119*t86-1.2761839642567
     8         67d+3*t101*t118*t121*t85+1.7015786190090226d+3*t101*t114*
     9         t117*t85-1.7015786190090226d+3*t101*t116*t119*t84+2.18774
     :         3938725886d+3*t101*t112*t115*t84-2.187743938725886d+3*t10
     ;         1*t114*t117*t83+2.734679923407357d+3*t101*t110*t113*t83+3
     <         .342386573053437d+3*t101*t111*t154*t82-2.734679923407357d
     =         +3*t101*t112*t115*t82+4.0108638876641245d+3*t101*t108*t20
     >         0*t81-3.342386573053437d+3*t101*t110*t113*t81
            t242 = 8.0d+0*t47*t48+8.0d+0*t17*t44*t48+8.0d+0*t45*t47+2.4d
     1         +1*t41*t45*t46+7.2d+1*t41*t42*t46+4.8d+1*t39*t41*t46+3.2d
     2         +1*t17*t44*t45+2.4d+1*t17*t42*t44+4.8d+1*t38*t42*t43+1.28
     3         d+2*t38*t39*t43+8.0d+1*t36*t38*t43+8.0d+1*t35*t39*t40+2.0
     4         d+2*t35*t36*t40+1.2d+2*t33*t35*t40+1.2d+2*t32*t36*t37+2.8
     5         8d+2*t32*t33*t37+1.68d+2*t30*t32*t37+1.68d+2*t29*t33*t34+
     6         3.92d+2*t29*t30*t34+2.24d+2*t27*t29*t34+2.24d+2*t26*t30*t
     7         31+5.12d+2*t26*t27*t31+2.88d+2*t24*t26*t31+2.88d+2*t23*t2
     8         7*t28+6.48d+2*t23*t24*t28+3.6d+2*t21*t23*t28+3.6d+2*t20*t
     9         24*t25+8.0d+2*t20*t21*t25+4.4d+2*t14*t20*t25+4.4d+2*t137*
     :         t21*t22+9.68d+2*t137*t14*t22+5.28d+2*t14*t178*t18
            t243 = 8.0d+0*t47*t64+8.0d+0*t17*t44*t64+8.0d+0*t47*t63+2.4d
     1         +1*t41*t46*t63+3.2d+1*t17*t44*t63+7.2d+1*t41*t46*t62+2.4d
     2         +1*t17*t44*t62+4.8d+1*t38*t43*t62+4.8d+1*t41*t46*t61+1.28
     3         d+2*t38*t43*t61+8.0d+1*t35*t40*t61+8.0d+1*t38*t43*t60+2.0
     4         d+2*t35*t40*t60+1.2d+2*t32*t37*t60+1.2d+2*t35*t40*t59+2.8
     5         8d+2*t32*t37*t59+1.68d+2*t29*t34*t59+1.68d+2*t32*t37*t58+
     6         3.92d+2*t29*t34*t58+2.24d+2*t26*t31*t58+2.24d+2*t29*t34*t
     7         57+5.12d+2*t26*t31*t57+2.88d+2*t23*t28*t57+2.88d+2*t26*t3
     8         1*t56+6.48d+2*t23*t28*t56+3.6d+2*t20*t25*t56+3.6d+2*t23*t
     9         28*t55+8.0d+2*t20*t25*t55+4.4d+2*t137*t22*t55+4.4d+2*t20*
     :         t25*t54+9.68d+2*t137*t22*t54+5.28d+2*t178*t18*t54
            t244 = 8.0d+0*t47*t78+8.0d+0*t17*t44*t78+8.0d+0*t47*t77+2.4d
     1         +1*t41*t46*t77+3.2d+1*t17*t44*t77+7.2d+1*t41*t46*t76+2.4d
     2         +1*t17*t44*t76+4.8d+1*t38*t43*t76+4.8d+1*t41*t46*t75+1.28
     3         d+2*t38*t43*t75+8.0d+1*t35*t40*t75+8.0d+1*t38*t43*t74+2.0
     4         d+2*t35*t40*t74+1.2d+2*t32*t37*t74+1.2d+2*t35*t40*t73+2.8
     5         8d+2*t32*t37*t73+1.68d+2*t29*t34*t73+1.68d+2*t32*t37*t72+
     6         3.92d+2*t29*t34*t72+2.24d+2*t26*t31*t72+2.24d+2*t29*t34*t
     7         71+5.12d+2*t26*t31*t71+2.88d+2*t23*t28*t71+2.88d+2*t26*t3
     8         1*t70+6.48d+2*t23*t28*t70+3.6d+2*t20*t25*t70+3.6d+2*t23*t
     9         28*t69+8.0d+2*t20*t25*t69+4.4d+2*t137*t22*t69+4.4d+2*t20*
     :         t25*t68+9.68d+2*t137*t22*t68+5.28d+2*t178*t18*t68
            t245 = 8.0d+0*t47*t91+8.0d+0*t17*t44*t91+8.0d+0*t47*t90+2.4d
     1         +1*t41*t46*t90+3.2d+1*t17*t44*t90+7.2d+1*t41*t46*t89+2.4d
     2         +1*t17*t44*t89+4.8d+1*t38*t43*t89+4.8d+1*t41*t46*t88+1.28
     3         d+2*t38*t43*t88+8.0d+1*t35*t40*t88+8.0d+1*t38*t43*t87+2.0
     4         d+2*t35*t40*t87+1.2d+2*t32*t37*t87+1.2d+2*t35*t40*t86+2.8
     5         8d+2*t32*t37*t86+1.68d+2*t29*t34*t86+1.68d+2*t32*t37*t85+
     6         3.92d+2*t29*t34*t85+2.24d+2*t26*t31*t85+2.24d+2*t29*t34*t
     7         84+5.12d+2*t26*t31*t84+2.88d+2*t23*t28*t84+2.88d+2*t26*t3
     8         1*t83+6.48d+2*t23*t28*t83+3.6d+2*t20*t25*t83+3.6d+2*t23*t
     9         28*t82+8.0d+2*t20*t25*t82+4.4d+2*t137*t22*t82+4.4d+2*t20*
     :         t25*t81+9.68d+2*t137*t22*t81+5.28d+2*t178*t18*t81
            t246 = 8.0d+0*t128*t48+8.0d+0*t107*t126*t48+8.0d+0*t128*t45+
     1         2.4d+1*t124*t127*t45+3.2d+1*t107*t126*t45+7.2d+1*t124*t12
     2         7*t42+2.4d+1*t107*t126*t42+4.8d+1*t122*t125*t42+4.8d+1*t1
     3         24*t127*t39+1.28d+2*t122*t125*t39+8.0d+1*t120*t123*t39+8.
     4         0d+1*t122*t125*t36+2.0d+2*t120*t123*t36+1.2d+2*t118*t121*
     5         t36+1.2d+2*t120*t123*t33+2.88d+2*t118*t121*t33+1.68d+2*t1
     6         16*t119*t33+1.68d+2*t118*t121*t30+3.92d+2*t116*t119*t30+2
     7         .24d+2*t114*t117*t30+2.24d+2*t116*t119*t27+5.12d+2*t114*t
     8         117*t27+2.88d+2*t112*t115*t27+2.88d+2*t114*t117*t24+6.48d
     9         +2*t112*t115*t24+3.6d+2*t110*t113*t24+4.4d+2*t111*t154*t2
     :         1+3.6d+2*t112*t115*t21+8.0d+2*t110*t113*t21+5.28d+2*t108*
     ;         t14*t200+9.68d+2*t111*t14*t154+4.4d+2*t110*t113*t14
            t247 = 8.0d+0*t128*t64+8.0d+0*t107*t126*t64+8.0d+0*t128*t63+
     1         2.4d+1*t124*t127*t63+3.2d+1*t107*t126*t63+7.2d+1*t124*t12
     2         7*t62+2.4d+1*t107*t126*t62+4.8d+1*t122*t125*t62+4.8d+1*t1
     3         24*t127*t61+1.28d+2*t122*t125*t61+8.0d+1*t120*t123*t61+8.
     4         0d+1*t122*t125*t60+2.0d+2*t120*t123*t60+1.2d+2*t118*t121*
     5         t60+1.2d+2*t120*t123*t59+2.88d+2*t118*t121*t59+1.68d+2*t1
     6         16*t119*t59+1.68d+2*t118*t121*t58+3.92d+2*t116*t119*t58+2
     7         .24d+2*t114*t117*t58+2.24d+2*t116*t119*t57+5.12d+2*t114*t
     8         117*t57+2.88d+2*t112*t115*t57+2.88d+2*t114*t117*t56+6.48d
     9         +2*t112*t115*t56+3.6d+2*t110*t113*t56+4.4d+2*t111*t154*t5
     :         5+3.6d+2*t112*t115*t55+8.0d+2*t110*t113*t55+5.28d+2*t108*
     ;         t200*t54+9.68d+2*t111*t154*t54+4.4d+2*t110*t113*t54
            t248 = 8.0d+0*t128*t78+8.0d+0*t107*t126*t78+8.0d+0*t128*t77+
     1         2.4d+1*t124*t127*t77+3.2d+1*t107*t126*t77+7.2d+1*t124*t12
     2         7*t76+2.4d+1*t107*t126*t76+4.8d+1*t122*t125*t76+4.8d+1*t1
     3         24*t127*t75+1.28d+2*t122*t125*t75+8.0d+1*t120*t123*t75+8.
     4         0d+1*t122*t125*t74+2.0d+2*t120*t123*t74+1.2d+2*t118*t121*
     5         t74+1.2d+2*t120*t123*t73+2.88d+2*t118*t121*t73+1.68d+2*t1
     6         16*t119*t73+1.68d+2*t118*t121*t72+3.92d+2*t116*t119*t72+2
     7         .24d+2*t114*t117*t72+2.24d+2*t116*t119*t71+5.12d+2*t114*t
     8         117*t71+2.88d+2*t112*t115*t71+2.88d+2*t114*t117*t70+6.48d
     9         +2*t112*t115*t70+3.6d+2*t110*t113*t70+4.4d+2*t111*t154*t6
     :         9+3.6d+2*t112*t115*t69+8.0d+2*t110*t113*t69+5.28d+2*t108*
     ;         t200*t68+9.68d+2*t111*t154*t68+4.4d+2*t110*t113*t68
            t249 = 8.0d+0*t128*t91+8.0d+0*t107*t126*t91+8.0d+0*t128*t90+
     1         2.4d+1*t124*t127*t90+3.2d+1*t107*t126*t90+7.2d+1*t124*t12
     2         7*t89+2.4d+1*t107*t126*t89+4.8d+1*t122*t125*t89+4.8d+1*t1
     3         24*t127*t88+1.28d+2*t122*t125*t88+8.0d+1*t120*t123*t88+8.
     4         0d+1*t122*t125*t87+2.0d+2*t120*t123*t87+1.2d+2*t118*t121*
     5         t87+1.2d+2*t120*t123*t86+2.88d+2*t118*t121*t86+1.68d+2*t1
     6         16*t119*t86+1.68d+2*t118*t121*t85+3.92d+2*t116*t119*t85+2
     7         .24d+2*t114*t117*t85+2.24d+2*t116*t119*t84+5.12d+2*t114*t
     8         117*t84+2.88d+2*t112*t115*t84+2.88d+2*t114*t117*t83+6.48d
     9         +2*t112*t115*t83+3.6d+2*t110*t113*t83+4.4d+2*t111*t154*t8
     :         2+3.6d+2*t112*t115*t82+8.0d+2*t110*t113*t82+5.28d+2*t108*
     ;         t200*t81+9.68d+2*t111*t154*t81+4.4d+2*t110*t113*t81
            t250 = 1/t19**14
            t251 = gammaaa**3
            t252 = 1/t2**4
            t253 = 1/rhoa**9.666666666666666d+0
            t254 = 1/rhoa**7
            t255 = 1/rhoa**4.333333333333333d+0
            t256 = -4.275941461768073d-2*t6*(-4.255868126669586d+6*t10*t
     1         7*t8-2.626185756615557d+4*t10*t189*t8-7.20244918099057d+1
     2         *t10*t143*t8-4.8616531971686355d+2*t10*t188*t6-1.58314349
     3         44115283d-3*t230+t10*(1.5831434944115283d-3*t230-1.330292
     4         899216734d-1*t186)+1.995439348825101d-1*t186+7.8785572698
     5         46671d+4*t10*t147*t149+9.951811315271029d+3*t10*t146*t148
     6         +9.676451059701281d+5*t10*t144*t148+4.0940029704573894d+1
     7         *t1*t10*t148+1.6205510657228786d+2*t10*t144*t147)+4.27594
     8         14617680724d-2*t144*t190+4.434309664055779d-2*t11*t186-5.
     9         701255282357429d-2*t143*t150
            t257 = 1/rhoa**11
            t258 = 1/rhoa**8.333333333333334d+0
            t259 = 1/rhoa**5.666666666666667d+0
            t260 = 3.7221029453964005d+0*t191*t5+9.305257363491002d-1*t2
     1         56*t4-2.7571132928862224d-1*t12*t189+2.7571132928862224d-
     2         1*t189+1.2407009817988002d+0*t149*t151
            t261 = 1/t109**14
            t262 = gammabb**3
            t263 = 1/t94**4
            t264 = 1/rhob**9.666666666666666d+0
            t265 = 1/rhob**7
            t266 = 1/rhob**4.333333333333333d+0
            t267 = -4.275941461768073d-2*t98*(-4.255868126669586d+6*t100
     1         *t102*t99-4.8616531971686355d+2*t102*t210*t98+4.094002970
     2         4573894d+1*t102*t148*t93-1.5831434944115283d-3*t232+t102*
     3         (1.5831434944115283d-3*t232-1.330292899216734d-1*t208)-2.
     4         626185756615557d+4*t100*t102*t211+1.995439348825101d-1*t2
     5         08+7.878557269846671d+4*t102*t164*t165+1.6205510657228786
     6         d+2*t102*t161*t164+9.951811315271029d+3*t102*t148*t163+9.
     7         676451059701281d+5*t102*t148*t161-7.20244918099057d+1*t10
     8         0*t102*t160)+4.2759414617680724d-2*t161*t212+4.4343096640
     9         55779d-2*t103*t208-5.701255282357429d-2*t160*t166
            t268 = 1/rhob**11
            t269 = 1/rhob**8.333333333333334d+0
            t270 = 1/rhob**5.666666666666667d+0
            t271 = 3.7221029453964005d+0*t213*t97+9.305257363491002d-1*t
     1         267*t96-2.7571132928862224d-1*t104*t211+2.757113292886222
     2         4d-1*t211+1.2407009817988002d+0*t165*t167
            t272 = 1/rhoa**8.666666666666666d+0
            t273 = 1/rhoa**10
            t274 = 1/rhob**8.666666666666666d+0
            t275 = 1/rhob**10
            t276 = 1/rhoa**7.666666666666667d+0
            t277 = 1/rhoa**9
            t278 = 1/rhob**7.666666666666667d+0
            t279 = 1/rhob**9
            t280 = 1/rhoa**6.666666666666667d+0
            t281 = 1/rhoa**8
            t282 = 1/rhob**6.666666666666667d+0
            t283 = 1/rhob**8
            fnc(iq) = (1.0d+0*(-9.305257363491002d-1*t104*t130*t95*t96-9
     1         .305257363491002d-1*t104*t132*t133*t96+t134*t135*t95+t132
     2         *t134*t136)+1.0d+0*(t52*t66*t92+t3*t66*t79-9.305257363491
     3         002d-1*t12*t4*t52*t65-9.305257363491002d-1*t12*t3*t4*t50)
     4         )*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(-5.417385299101419d-3*gammaaa*t152*
     1         t51*t66*t92+t153*t52*t92-9.632279000746596d-3*gammaaa*t14
     2         2*t152*t66*t79+t153*t3*t79+t141*t52*t66+t140*t3*t66-1.240
     3         7009817988002d+0*t12*t5*t52*t65-9.305257363491002d-1*t151
     4         *t4*t52*t65+5.041016444533138d-3*gammaaa*t12*t143*t51*t65
     5         -9.305257363491002d-1*t12*t139*t4*t52-1.2407009817988002d
     6         +0*t12*t3*t5*t50-9.305257363491002d-1*t151*t3*t4*t50+8.96
     7         3083509889702d-3*gammaaa*t12*t142*t143*t50-9.305257363491
     8         002d-1*t12*t138*t3*t4)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*(-1.2407009817988002d+0*t104*t130*t9
     1         5*t97-1.2407009817988002d+0*t104*t132*t133*t97-9.30525736
     2         3491002d-1*t130*t167*t95*t96-9.305257363491002d-1*t104*t1
     3         55*t95*t96-9.305257363491002d-1*t132*t133*t167*t96-9.3052
     4         57363491002d-1*t104*t132*t156*t96+t135*t169*t95+t134*t157
     5         *t95+t132*t136*t169-9.632279000746596d-3*gammabb*t134*t13
     6         5*t159*t168-5.417385299101419d-3*gammabb*t131*t134*t136*t
     7         168+8.963083509889702d-3*gammabb*t104*t130*t159*t160+5.04
     8         1016444533138d-3*gammabb*t104*t131*t133*t160+t132*t134*t1
     9         58)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = 1.0d+0*(2.0315194871630324d-3*t1*t51*t66*t
     1         92+3.612104625279974d-3*t1*t142*t66*t79-1.890381166699927
     2         d-3*t12*t144*t51*t65-3.361156316208638d-3*t12*t142*t144*t
     3         50)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = 1.0d+0*(3.612104625279974d-3*t134*t135*t15
     1         9*t93+2.0315194871630324d-3*t131*t134*t136*t93-3.36115631
     2         6208638d-3*t104*t130*t159*t161-1.890381166699927d-3*t104*
     3         t131*t133*t161)*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TA) = 1.0d+0*(t173*t52*t66+t172*t3*t66-9.30525736
     1         3491002d-1*t12*t171*t4*t52-9.305257363491002d-1*t12*t170*
     2         t3*t4)*wght+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = 1.0d+0*(-9.305257363491002d-1*t104*t174*t95
     1         *t96-9.305257363491002d-1*t104*t132*t175*t96+t134*t176*t9
     2         5+t132*t134*t177)*wght+Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(1.9863746096705204d-2*gammaaa*t
     1         193*t51*t66*t92-5.316678166471045d-5*t183*t192*t51*t66*t9
     2         2+t194*t52*t92+3.5318356336070855d-2*gammaaa*t142*t193*t6
     3         6*t79-2.3079800683637772d-4*t183*t184*t192*t66*t79+t194*t
     4         3*t79+t182*t52*t66+t181*t3*t66-2.4814019635976003d+0*t151
     5         *t5*t52*t65-9.305257363491002d-1*t191*t4*t52*t65-5.041016
     6         444533138d-3*gammaaa*t12*t186*t51*t65+4.947305865786653d-
     7         5*t12*t183*t185*t51*t65-2.4814019635976003d+0*t12*t139*t5
     8         *t52-9.305257363491002d-1*t12*t180*t4*t52-1.8610514726982
     9         003d+0*t139*t151*t4*t52+2*t141*t153*t52-2.481401963597600
     :         3d+0*t151*t3*t5*t50-9.305257363491002d-1*t191*t3*t4*t50-8
     ;         .963083509889707d-3*gammaaa*t12*t142*t186*t50+2.147634852
     <         5932504d-4*t12*t183*t184*t185*t50-2.4814019635976003d+0*t
     =         12*t138*t3*t5-9.305257363491002d-1*t12*t179*t3*t4-1.86105
     >         14726982003d+0*t138*t151*t3*t4+2*t140*t153*t3+t152*t199+t
     ?         142*t152*t198+t143*t197+t149*t196+t142*t143*t195)*wght+Am
     @         at2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*(-2.4814019635976003d+0*t130*t16
     1         7*t95*t97-2.4814019635976003d+0*t104*t155*t95*t97-2.48140
     2         19635976003d+0*t132*t133*t167*t97-2.4814019635976003d+0*t
     3         104*t132*t156*t97-9.305257363491002d-1*t130*t213*t95*t96-
     4         9.305257363491002d-1*t104*t201*t95*t96-1.8610514726982003
     5         d+0*t155*t167*t95*t96-9.305257363491002d-1*t132*t133*t213
     6         *t96-9.305257363491002d-1*t104*t132*t202*t96-1.8610514726
     7         982003d+0*t132*t156*t167*t96+t135*t216*t95+t134*t203*t95+
     8         2*t157*t169*t95+t168*t221+t159*t168*t220+t160*t219+t165*t
     9         218+t159*t160*t217+t132*t136*t216+3.5318356336070855d-2*g
     :         ammabb*t134*t135*t159*t215+1.9863746096705204d-2*gammabb*
     ;         t131*t134*t136*t215-2.3079800683637772d-4*t134*t135*t205*
     <         t206*t214-5.316678166471045d-5*t131*t134*t136*t205*t214-8
     =         .963083509889707d-3*gammabb*t104*t130*t159*t208-5.0410164
     >         44533138d-3*gammabb*t104*t131*t133*t208+2.147634852593250
     ?         4d-4*t104*t130*t205*t206*t207+4.947305865786653d-5*t104*t
     @         131*t133*t205*t207+t132*t134*t204+2*t132*t158*t169)*wght+
     1         Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(t1*(2.0315194871630324d-3*t153
     1         *t51*t92+2.0315194871630324d-3*t141*t51*t66)+1.9937543124
     2         266421d-5*gammaaa*t223*t51*t66*t92-5.417385299101419d-3*t
     3         152*t51*t66*t92+8.654925256364164d-5*gammaaa*t184*t223*t6
     4         6*t79-9.632279000746596d-3*t142*t152*t66*t79+t144*(-1.890
     5         381166699927d-3*t151*t51*t65-1.890381166699927d-3*t12*t13
     6         9*t51)-1.855239699669995d-5*gammaaa*t12*t222*t51*t65+2.52
     7         0508222266569d-3*t12*t143*t51*t65-8.05363069722469d-5*gam
     8         maaa*t12*t184*t222*t50+4.481541754944851d-3*t12*t142*t143
     9         *t50+t1*t142*t225+t142*t144*t224)*wght+Cmat2(iq,D2_RA_GAA
     :         )
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*(t159*t229*t93+(2.0315194871630
     1         324d-3*t131*t136*t169+2.0315194871630324d-3*t131*t134*t15
     2         8)*t93+t159*t161*t228+8.654925256364164d-5*gammabb*t134*t
     3         135*t206*t227+1.9937543124266421d-5*gammabb*t131*t134*t13
     4         6*t227-8.05363069722469d-5*gammabb*t104*t130*t206*t226-1.
     5         855239699669995d-5*gammabb*t104*t131*t133*t226-9.63227900
     6         0746596d-3*t134*t135*t159*t168-5.417385299101419d-3*t131*
     7         t134*t136*t168+t161*(-1.890381166699927d-3*t131*t133*t167
     8         -1.890381166699927d-3*t104*t131*t156)+4.481541754944851d-
     9         3*t104*t130*t159*t160+2.520508222266569d-3*t104*t131*t133
     :         *t160)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(-7.476578671599909d-6*t231*t5
     1         1*t66*t92-3.245596971136562d-5*t184*t231*t66*t79+6.957148
     2         873762482d-6*t12*t230*t51*t65+3.020111511459258d-5*t12*t1
     3         84*t230*t50)*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*(-3.245596971136562d-5*t134*t1
     1         35*t206*t233-7.476578671599909d-6*t131*t134*t136*t233+3.0
     2         20111511459258d-5*t104*t130*t206*t232+6.957148873762482d-
     3         6*t104*t131*t133*t232)*wght+Cmat2(iq,D2_GBB_GBB)
            Mmat2(iq,D2_RA_TA) = 1.0d+0*(t237*t52*t66-5.417385299101419d
     1         -3*gammaaa*t152*t173*t51*t66+t236*t3*t66-9.63227900074659
     2         6d-3*gammaaa*t142*t152*t172*t66-1.2407009817988002d+0*t12
     3         *t171*t5*t52-9.305257363491002d-1*t12*t235*t4*t52-9.30525
     4         7363491002d-1*t151*t171*t4*t52+t153*t173*t52+5.0410164445
     5         33138d-3*gammaaa*t12*t143*t171*t51-1.2407009817988002d+0*
     6         t12*t170*t3*t5-9.305257363491002d-1*t12*t234*t3*t4-9.3052
     7         57363491002d-1*t151*t170*t3*t4+t153*t172*t3+8.96308350988
     8         9702d-3*gammaaa*t12*t142*t143*t170)*wght+Mmat2(iq,D2_RA_T
     9         A)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = 1.0d+0*(-1.2407009817988002d+0*t104*t17
     1         4*t95*t97-1.2407009817988002d+0*t104*t132*t175*t97-9.3052
     2         57363491002d-1*t104*t238*t95*t96-9.305257363491002d-1*t16
     3         7*t174*t95*t96-9.305257363491002d-1*t104*t132*t239*t96-9.
     4         305257363491002d-1*t132*t167*t175*t96+t134*t240*t95+t169*
     5         t176*t95+t132*t134*t241+t132*t169*t177-5.417385299101419d
     6         -3*gammabb*t131*t134*t168*t177-9.632279000746596d-3*gamma
     7         bb*t134*t159*t168*t176+5.041016444533138d-3*gammabb*t104*
     8         t131*t160*t175+8.963083509889702d-3*gammabb*t104*t159*t16
     9         0*t174)*wght+Mmat2(iq,D2_RB_TB)
            Mmat2(iq,D2_GAA_TA) = 1.0d+0*(2.0315194871630324d-3*t1*t173*
     1         t51*t66+3.612104625279974d-3*t1*t142*t172*t66-1.890381166
     2         699927d-3*t12*t144*t171*t51-3.361156316208638d-3*t12*t142
     3         *t144*t170)*wght+Mmat2(iq,D2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
            Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = 1.0d+0*(2.0315194871630324d-3*t131*t13
     1         4*t177*t93+3.612104625279974d-3*t134*t159*t176*t93-1.8903
     2         81166699927d-3*t104*t131*t161*t175-3.361156316208638d-3*t
     3         104*t159*t161*t174)*wght+Mmat2(iq,D2_GBB_TB)
            Mmat2(iq,D2_TA_TA) = 1.0d+0*(t245*t52*t66+t244*t3*t66-9.3052
     1         57363491002d-1*t12*t243*t4*t52-9.305257363491002d-1*t12*t
     2         242*t3*t4)*wght+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = 1.0d+0*(-9.305257363491002d-1*t104*t246
     1         *t95*t96-9.305257363491002d-1*t104*t132*t247*t96+t134*t24
     2         8*t95+t132*t134*t249)*wght+Mmat2(iq,D2_TB_TB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*(t152*(-1.6252155897304255d-2
     1         *gammaaa*t194*t51*t92-1.063335633294209d-4*t152*t153*t183
     2         *t51*t92-1.063335633294209d-4*t141*t152*t183*t51*t66-1.62
     3         52155897304255d-2*gammaaa*t182*t51*t66-3.250431179460851d
     4         -2*gammaaa*t141*t153*t51)+t192*(-5.316678166471045d-5*t15
     5         3*t183*t51*t92-5.316678166471045d-5*t141*t183*t51*t66)+t1
     6         93*(1.9863746096705204d-2*gammaaa*t153*t51*t92+1.98637460
     7         96705204d-2*gammaaa*t141*t51*t66)-9.269748178462429d-2*ga
     8         mmaaa*t259*t51*t66*t92+5.84834598311815d-4*t183*t258*t51*
     9         t66*t92-5.217843141140167d-7*t251*t257*t51*t66*t92+t260*t
     :         52*t92+t52*t66*(-9.232684300601568d+2*t47*t5*t91+9.232684
     ;         300601568d+2*t17*t44*t5*t91-3.37614805358933d+0*t144*t49*
     <         t91+3.37614805358933d+0*t144*t17*t47*t91+2.10403636633445
     =         1d+4*t145*t44*t91-2.104036366334451d+4*t145*t17*t41*t91+9
     >         .232684300601568d+2*t47*t5*t90+2.769805290180471d+3*t41*t
     ?         46*t5*t90-3.693073720240627d+3*t17*t44*t5*t90-6.752296107
     @         17866d+0*t144*t17*t47*t90+6.75229610717866d+0*t144*t44*t4
     1         6*t90-8.416145465337804d+4*t145*t38*t46*t90-4.20807273266
     2         8902d+4*t145*t44*t90+1.2624218198006704d+5*t145*t17*t41*t
     3         90-8.309415870541413d+3*t41*t46*t5*t89+2.769805290180471d
     4         +3*t17*t44*t5*t89+5.539610580360942d+3*t38*t43*t5*t89-1.0
     5         128444160767991d+1*t144*t44*t46*t89+3.787265459402013d+5*
     6         t145*t38*t46*t89+2.104036366334451d+4*t145*t44*t89+1.0128
     7         444160767991d+1*t144*t41*t43*t89-2.104036366334451d+5*t14
     8         5*t35*t43*t89-1.8936327297010064d+5*t145*t17*t41*t89+5.53
     9         9610580360942d+3*t41*t46*t5*t88-1.4772294880962508d+4*t38
     :         *t43*t5*t88+9.232684300601568d+3*t35*t40*t5*t88-5.0496872
     ;         79202681d+5*t145*t38*t46*t88-1.350459221435732d+1*t144*t4
     <         1*t43*t88+8.416145465337803d+5*t145*t35*t43*t88+8.4161454
     =         65337804d+4*t145*t17*t41*t88+1.350459221435732d+1*t144*t3
     >         8*t40*t88-4.2080727326689016d+5*t145*t32*t40*t88+9.232684
     ?         300601568d+3*t38*t43*t5*t87-2.308171075150392d+4*t35*t40*
     @         t5*t87+1.3849026450902355d+4*t32*t37*t5*t87+2.10403636633
     1         44508d+5*t145*t38*t46*t87-1.0520181831672254d+6*t145*t35*
     2         t43*t87-1.6880740267946648d+1*t144*t38*t40*t87+1.57802727
     3         4750838d+6*t145*t32*t40*t87+1.6880740267946648d+1*t144*t3
     4         5*t37*t87-7.364127282170578d+5*t145*t29*t37*t87+1.3849026
     5         450902355d+4*t35*t40*t5*t86-3.323766348216566d+4*t32*t37*
     6         t5*t86+1.9388637031263292d+4*t29*t34*t5*t86+4.20807273266
     7         8902d+5*t145*t35*t43*t86-1.893632729701006d+6*t145*t32*t4
     8         0*t86-2.0256888321535982d+1*t144*t35*t37*t86+2.6510858215
     9         814087d+6*t145*t29*t37*t86+2.0256888321535982d+1*t144*t32
     :         *t34*t86-1.1782603651472927d+6*t145*t26*t34*t86+1.9388637
     ;         031263292d+4*t32*t37*t5*t85-4.5240153072947686d+4*t29*t34
     <         *t5*t85+2.585151604168439d+4*t26*t31*t5*t85+7.36412728217
     =         0578d+5*t145*t32*t40*t85-3.0929334585116436d+6*t145*t29*t
     >         37*t85-2.3633036375125308d+1*t144*t32*t34*t85+4.123911278
     ?         015524d+6*t145*t26*t34*t85+2.3633036375125308d+1*t144*t29
     @         *t31*t85-1.7673905477209387d+6*t145*t23*t31*t85+2.5851516
     1         04168439d+4*t29*t34*t5*t84-5.908917952385003d+4*t26*t31*t
     2         5*t84+3.3237663482165647d+4*t23*t28*t5*t84+1.178260365147
     3         2927d+6*t145*t29*t37*t84-4.713041460589171d+6*t145*t26*t3
     4         4*t84-2.700918442871464d+1*t144*t29*t31*t84+6.05962473504
     5         3219d+6*t145*t23*t31*t84+2.700918442871464d+1*t144*t26*t2
     6         8*t84-2.524843639601341d+6*t145*t20*t28*t84+3.32376634821
     7         65647d+4*t26*t31*t5*t83-7.478474283487271d+4*t23*t28*t5*t
     8         83+4.1547079352707056d+4*t20*t25*t5*t83+1.767390547720939
     9         d+6*t145*t26*t34*t83-6.817077826923622d+6*t145*t23*t31*t8
     :         3-3.0385332482303967d+1*t144*t26*t28*t83+8.52134728365452
     ;         6d+6*t145*t20*t28*t83+3.0385332482303967d+1*t144*t23*t25*
     <         t83-3.4716600044518436d+6*t137*t145*t25*t83+4.15470793527
     =         0705d+4*t23*t28*t5*t82-9.232684300601568d+4*t20*t25*t5*t8
     >         2+5.077976365330862d+4*t137*t22*t5*t82+2.524843639601341d
     ?         +6*t145*t23*t31*t82-9.468163648505028d+6*t145*t20*t28*t82
     @         -3.3761480535893296d+1*t144*t23*t25*t82+1.157220001483947
     1         7d+7*t137*t145*t25*t82+3.3761480535893296d+1*t144*t20*t22
     2         *t82-4.628880005935792d+6*t145*t178*t22*t82+5.07797636533
     3         0863d+4*t20*t25*t5*t81-1.1171548003727898d+5*t137*t22*t5*
     4         t81+6.093571638397036d+4*t178*t18*t5*t81+3.47166000445184
     5         36d+6*t145*t20*t28*t81-6.01754400771653d+6*t145*t18*t250*
     6         t81-1.2729420016323426d+7*t137*t145*t25*t81-3.71376285894
     7         8263d+1*t144*t20*t22*t81+1.5275304019588112d+7*t145*t178*
     8         t22*t81+3.713762858948263d+1*t137*t144*t18*t81)+t142*t152
     9         *(-2.8896837002239784d-2*gammaaa*t194*t79-2.8896837002239
     :         784d-2*gammaaa*t181*t66-5.779367400447957d-2*gammaaa*t140
     ;         *t153)+t184*t192*(-2.3079800683637772d-4*t153*t183*t79-2.
     <         3079800683637772d-4*t140*t183*t66+2.3960893036683073d-2*g
     =         ammaaa*t198)+t142*t193*(3.5318356336070855d-2*gammaaa*t15
     >         3*t79+3.5318356336070855d-2*gammaaa*t140*t66)-1.648189962
     ?         3499732d-1*gammaaa*t142*t259*t66*t79+2.5387780752001543d-
     @         3*t183*t184*t258*t66*t79-8.295189532329142d-6*t251*t252*t
     1         257*t66*t79+t260*t3*t79+t3*t66*(-9.232684300601568d+2*t47
     2         *t5*t78+9.232684300601568d+2*t17*t44*t5*t78-3.37614805358
     3         933d+0*t144*t49*t78+3.37614805358933d+0*t144*t17*t47*t78+
     4         2.104036366334451d+4*t145*t44*t78-2.104036366334451d+4*t1
     5         45*t17*t41*t78+9.232684300601568d+2*t47*t5*t77+2.76980529
     6         0180471d+3*t41*t46*t5*t77-3.693073720240627d+3*t17*t44*t5
     7         *t77-6.75229610717866d+0*t144*t17*t47*t77+6.7522961071786
     8         6d+0*t144*t44*t46*t77-8.416145465337804d+4*t145*t38*t46*t
     9         77-4.208072732668902d+4*t145*t44*t77+1.2624218198006704d+
     :         5*t145*t17*t41*t77-8.309415870541413d+3*t41*t46*t5*t76+2.
     ;         769805290180471d+3*t17*t44*t5*t76+5.539610580360942d+3*t3
     <         8*t43*t5*t76-1.0128444160767991d+1*t144*t44*t46*t76+3.787
     =         265459402013d+5*t145*t38*t46*t76+2.104036366334451d+4*t14
     >         5*t44*t76+1.0128444160767991d+1*t144*t41*t43*t76-2.104036
     ?         366334451d+5*t145*t35*t43*t76-1.8936327297010064d+5*t145*
     @         t17*t41*t76+5.539610580360942d+3*t41*t46*t5*t75-1.4772294
     1         880962508d+4*t38*t43*t5*t75+9.232684300601568d+3*t35*t40*
     2         t5*t75-5.049687279202681d+5*t145*t38*t46*t75-1.3504592214
     3         35732d+1*t144*t41*t43*t75+8.416145465337803d+5*t145*t35*t
     4         43*t75+8.416145465337804d+4*t145*t17*t41*t75+1.3504592214
     5         35732d+1*t144*t38*t40*t75-4.2080727326689016d+5*t145*t32*
     6         t40*t75+9.232684300601568d+3*t38*t43*t5*t74-2.30817107515
     7         0392d+4*t35*t40*t5*t74+1.3849026450902355d+4*t32*t37*t5*t
     8         74+2.1040363663344508d+5*t145*t38*t46*t74-1.0520181831672
     9         254d+6*t145*t35*t43*t74-1.6880740267946648d+1*t144*t38*t4
     :         0*t74+1.578027274750838d+6*t145*t32*t40*t74+1.68807402679
     ;         46648d+1*t144*t35*t37*t74-7.364127282170578d+5*t145*t29*t
     <         37*t74+1.3849026450902355d+4*t35*t40*t5*t73-3.32376634821
     =         6566d+4*t32*t37*t5*t73+1.9388637031263292d+4*t29*t34*t5*t
     >         73+4.208072732668902d+5*t145*t35*t43*t73-1.89363272970100
     ?         6d+6*t145*t32*t40*t73-2.0256888321535982d+1*t144*t35*t37*
     @         t73+2.6510858215814087d+6*t145*t29*t37*t73+2.025688832153
     1         5982d+1*t144*t32*t34*t73-1.1782603651472927d+6*t145*t26*t
     2         34*t73+1.9388637031263292d+4*t32*t37*t5*t72-4.52401530729
     3         47686d+4*t29*t34*t5*t72+2.585151604168439d+4*t26*t31*t5*t
     4         72+7.364127282170578d+5*t145*t32*t40*t72-3.09293345851164
     5         36d+6*t145*t29*t37*t72-2.3633036375125308d+1*t144*t32*t34
     6         *t72+4.123911278015524d+6*t145*t26*t34*t72+2.363303637512
     7         5308d+1*t144*t29*t31*t72-1.7673905477209387d+6*t145*t23*t
     8         31*t72+2.585151604168439d+4*t29*t34*t5*t71-5.908917952385
     9         003d+4*t26*t31*t5*t71+3.3237663482165647d+4*t23*t28*t5*t7
     :         1+1.1782603651472927d+6*t145*t29*t37*t71-4.71304146058917
     ;         1d+6*t145*t26*t34*t71-2.700918442871464d+1*t144*t29*t31*t
     <         71+6.059624735043219d+6*t145*t23*t31*t71+2.70091844287146
     =         4d+1*t144*t26*t28*t71-2.524843639601341d+6*t145*t20*t28*t
     >         71+3.3237663482165647d+4*t26*t31*t5*t70-7.478474283487271
     ?         d+4*t23*t28*t5*t70+4.1547079352707056d+4*t20*t25*t5*t70+1
     @         .767390547720939d+6*t145*t26*t34*t70-6.817077826923622d+6
     1         *t145*t23*t31*t70-3.0385332482303967d+1*t144*t26*t28*t70+
     2         8.521347283654526d+6*t145*t20*t28*t70+3.0385332482303967d
     3         +1*t144*t23*t25*t70-3.4716600044518436d+6*t137*t145*t25*t
     4         70+4.154707935270705d+4*t23*t28*t5*t69-9.232684300601568d
     5         +4*t20*t25*t5*t69+5.077976365330862d+4*t137*t22*t5*t69+2.
     6         524843639601341d+6*t145*t23*t31*t69-9.468163648505028d+6*
     7         t145*t20*t28*t69-3.3761480535893296d+1*t144*t23*t25*t69+1
     8         .1572200014839477d+7*t137*t145*t25*t69+3.3761480535893296
     9         d+1*t144*t20*t22*t69-4.628880005935792d+6*t145*t178*t22*t
     :         69+5.077976365330863d+4*t20*t25*t5*t68-1.1171548003727898
     ;         d+5*t137*t22*t5*t68+6.093571638397036d+4*t178*t18*t5*t68+
     <         3.4716600044518436d+6*t145*t20*t28*t68-6.01754400771653d+
     =         6*t145*t18*t250*t68-1.2729420016323426d+7*t137*t145*t25*t
     >         68-3.713762858948263d+1*t144*t20*t22*t68+1.52753040195881
     ?         12d+7*t145*t178*t22*t68+3.713762858948263d+1*t137*t144*t1
     @         8*t68)+t149*(-1.2407009817988002d+0*t151*t52*t65+2.240451
     1         7531258392d-3*gammaaa*t12*t152*t51*t65-1.2407009817988002
     2         d+0*t12*t139*t52-1.2407009817988002d+0*t151*t3*t50+3.9835
     3         92671062089d-3*gammaaa*t12*t142*t152*t50-1.24070098179880
     4         02d+0*t12*t138*t3)+t143*(1.5123049333599414d-2*gammaaa*t1
     5         91*t51*t65+9.894611731573306d-5*t151*t152*t183*t51*t65+9.
     6         894611731573306d-5*t12*t139*t152*t183*t51+1.5123049333599
     7         414d-2*gammaaa*t12*t180*t51+3.024609866719883d-2*gammaaa*
     8         t139*t151*t51)+t185*(4.947305865786653d-5*t151*t183*t51*t
     9         65+4.947305865786653d-5*t12*t139*t183*t51)+t186*(8.401694
     :         074221897d-3*gammaaa*t151*t51*t65+8.401694074221897d-3*ga
     ;         mmaaa*t12*t139*t51)-3.7221029453964005d+0*t191*t5*t52*t65
     <         -9.305257363491002d-1*t256*t4*t52*t65+1.6803388148443793d
     =         -2*gammaaa*t12*t255*t51*t65-3.4631141060506576d-4*t12*t18
     >         3*t254*t51*t65+4.855337331063556d-7*t12*t251*t253*t51*t65
     ?         -9.305257363491002d-1*t12*t4*t52*(-9.232684300601568d+2*t
     @         47*t5*t64+9.232684300601568d+2*t17*t44*t5*t64-3.376148053
     1         58933d+0*t144*t49*t64+3.37614805358933d+0*t144*t17*t47*t6
     2         4+2.104036366334451d+4*t145*t44*t64-2.104036366334451d+4*
     3         t145*t17*t41*t64+9.232684300601568d+2*t47*t5*t63+2.769805
     4         290180471d+3*t41*t46*t5*t63-3.693073720240627d+3*t17*t44*
     5         t5*t63-6.75229610717866d+0*t144*t17*t47*t63+6.75229610717
     6         866d+0*t144*t44*t46*t63-8.416145465337804d+4*t145*t38*t46
     7         *t63-4.208072732668902d+4*t145*t44*t63+1.2624218198006704
     8         d+5*t145*t17*t41*t63-8.309415870541413d+3*t41*t46*t5*t62+
     9         2.769805290180471d+3*t17*t44*t5*t62+5.539610580360942d+3*
     :         t38*t43*t5*t62-1.0128444160767991d+1*t144*t44*t46*t62+3.7
     ;         87265459402013d+5*t145*t38*t46*t62+2.104036366334451d+4*t
     <         145*t44*t62+1.0128444160767991d+1*t144*t41*t43*t62-2.1040
     =         36366334451d+5*t145*t35*t43*t62-1.8936327297010064d+5*t14
     >         5*t17*t41*t62+5.539610580360942d+3*t41*t46*t5*t61-1.47722
     ?         94880962508d+4*t38*t43*t5*t61+9.232684300601568d+3*t35*t4
     @         0*t5*t61-5.049687279202681d+5*t145*t38*t46*t61-1.35045922
     1         1435732d+1*t144*t41*t43*t61+8.416145465337803d+5*t145*t35
     2         *t43*t61+8.416145465337804d+4*t145*t17*t41*t61+1.35045922
     3         1435732d+1*t144*t38*t40*t61-4.2080727326689016d+5*t145*t3
     4         2*t40*t61+9.232684300601568d+3*t38*t43*t5*t60-2.308171075
     5         150392d+4*t35*t40*t5*t60+1.3849026450902355d+4*t32*t37*t5
     6         *t60+2.1040363663344508d+5*t145*t38*t46*t60-1.05201818316
     7         72254d+6*t145*t35*t43*t60-1.6880740267946648d+1*t144*t38*
     8         t40*t60+1.578027274750838d+6*t145*t32*t40*t60+1.688074026
     9         7946648d+1*t144*t35*t37*t60-7.364127282170578d+5*t145*t29
     :         *t37*t60+1.3849026450902355d+4*t35*t40*t5*t59-3.323766348
     ;         216566d+4*t32*t37*t5*t59+1.9388637031263292d+4*t29*t34*t5
     <         *t59+4.208072732668902d+5*t145*t35*t43*t59-1.893632729701
     =         006d+6*t145*t32*t40*t59-2.0256888321535982d+1*t144*t35*t3
     >         7*t59+2.6510858215814087d+6*t145*t29*t37*t59+2.0256888321
     ?         535982d+1*t144*t32*t34*t59-1.1782603651472927d+6*t145*t26
     @         *t34*t59+1.9388637031263292d+4*t32*t37*t5*t58-4.524015307
     1         2947686d+4*t29*t34*t5*t58+2.585151604168439d+4*t26*t31*t5
     2         *t58+7.364127282170578d+5*t145*t32*t40*t58-3.092933458511
     3         6436d+6*t145*t29*t37*t58-2.3633036375125308d+1*t144*t32*t
     4         34*t58+4.123911278015524d+6*t145*t26*t34*t58+2.3633036375
     5         125308d+1*t144*t29*t31*t58-1.7673905477209387d+6*t145*t23
     6         *t31*t58+2.585151604168439d+4*t29*t34*t5*t57-5.9089179523
     7         85003d+4*t26*t31*t5*t57+3.3237663482165647d+4*t23*t28*t5*
     8         t57+1.1782603651472927d+6*t145*t29*t37*t57-4.713041460589
     9         171d+6*t145*t26*t34*t57-2.700918442871464d+1*t144*t29*t31
     :         *t57+6.059624735043219d+6*t145*t23*t31*t57+2.700918442871
     ;         464d+1*t144*t26*t28*t57-2.524843639601341d+6*t145*t20*t28
     <         *t57+3.3237663482165647d+4*t26*t31*t5*t56-7.4784742834872
     =         71d+4*t23*t28*t5*t56+4.1547079352707056d+4*t20*t25*t5*t56
     >         +1.767390547720939d+6*t145*t26*t34*t56-6.817077826923622d
     ?         +6*t145*t23*t31*t56-3.0385332482303967d+1*t144*t26*t28*t5
     @         6+8.521347283654526d+6*t145*t20*t28*t56+3.038533248230396
     1         7d+1*t144*t23*t25*t56-3.4716600044518436d+6*t137*t145*t25
     2         *t56+4.154707935270705d+4*t23*t28*t5*t55-9.23268430060156
     3         8d+4*t20*t25*t5*t55+5.077976365330862d+4*t137*t22*t5*t55+
     4         2.524843639601341d+6*t145*t23*t31*t55-9.468163648505028d+
     5         6*t145*t20*t28*t55-3.3761480535893296d+1*t144*t23*t25*t55
     6         +1.1572200014839477d+7*t137*t145*t25*t55+3.37614805358932
     7         96d+1*t144*t20*t22*t55-4.628880005935792d+6*t145*t178*t22
     8         *t55+5.077976365330863d+4*t20*t25*t5*t54-1.11715480037278
     9         98d+5*t137*t22*t5*t54+6.093571638397036d+4*t178*t18*t5*t5
     :         4+3.4716600044518436d+6*t145*t20*t28*t54-6.01754400771653
     ;         d+6*t145*t18*t250*t54-1.2729420016323426d+7*t137*t145*t25
     <         *t54-3.713762858948263d+1*t144*t20*t22*t54+1.527530401958
     =         8112d+7*t145*t178*t22*t54+3.713762858948263d+1*t137*t144*
     >         t18*t54)-3.7221029453964005d+0*t12*t180*t5*t52-7.44420589
     ?         0792801d+0*t139*t151*t5*t52-2.7915772090473007d+0*t139*t1
     @         91*t4*t52-2.7915772090473007d+0*t151*t180*t4*t52+3*t141*t
     1         194*t52+3*t153*t182*t52+t142*t143*(2.6889250529669106d-2*
     2         gammaaa*t191*t50+2.6889250529669106d-2*gammaaa*t12*t179+5
     3         .377850105933821d-2*gammaaa*t138*t151)+t184*t185*(2.14763
     4         48525932504d-4*t151*t183*t50+2.3960893036683073d-2*gammaa
     5         a*t195+2.1476348525932504d-4*t12*t138*t183)+t142*t186*(1.
     6         4938472516482826d-2*gammaaa*t151*t50+1.4938472516482826d-
     7         2*gammaaa*t12*t138)-3.7221029453964005d+0*t191*t3*t5*t50-
     8         9.305257363491002d-1*t256*t3*t4*t50+2.987694503296569d-2*
     9         gammaaa*t12*t142*t255*t50-1.5033443968152754d-3*t12*t183*
     :         t184*t254*t50+7.718887347725925d-6*t12*t251*t252*t253*t50
     ;         -9.305257363491002d-1*t12*t3*t4*(-9.232684300601568d+2*t4
     <         7*t48*t5+9.232684300601568d+2*t17*t44*t48*t5+9.2326843006
     =         01568d+2*t45*t47*t5+2.769805290180471d+3*t41*t45*t46*t5-8
     >         .309415870541413d+3*t41*t42*t46*t5+5.539610580360942d+3*t
     ?         39*t41*t46*t5-3.693073720240627d+3*t17*t44*t45*t5+2.76980
     @         5290180471d+3*t17*t42*t44*t5+5.539610580360942d+3*t38*t42
     1         *t43*t5-1.4772294880962508d+4*t38*t39*t43*t5+9.2326843006
     2         01568d+3*t36*t38*t43*t5+9.232684300601568d+3*t35*t39*t40*
     3         t5-2.308171075150392d+4*t35*t36*t40*t5+1.3849026450902355
     4         d+4*t33*t35*t40*t5+1.3849026450902355d+4*t32*t36*t37*t5-3
     5         .323766348216566d+4*t32*t33*t37*t5+1.9388637031263292d+4*
     6         t30*t32*t37*t5+1.9388637031263292d+4*t29*t33*t34*t5-4.524
     7         0153072947686d+4*t29*t30*t34*t5+2.585151604168439d+4*t27*
     8         t29*t34*t5+2.585151604168439d+4*t26*t30*t31*t5-5.90891795
     9         2385003d+4*t26*t27*t31*t5+3.3237663482165647d+4*t24*t26*t
     :         31*t5+3.3237663482165647d+4*t23*t27*t28*t5-7.478474283487
     ;         271d+4*t23*t24*t28*t5+4.154707935270705d+4*t21*t23*t28*t5
     <         +4.1547079352707056d+4*t20*t24*t25*t5-9.232684300601568d+
     =         4*t20*t21*t25*t5+5.077976365330863d+4*t14*t20*t25*t5+5.07
     >         7976365330862d+4*t137*t21*t22*t5-1.1171548003727898d+5*t1
     ?         37*t14*t22*t5+6.093571638397036d+4*t14*t178*t18*t5-3.3761
     @         4805358933d+0*t144*t48*t49+3.37614805358933d+0*t144*t17*t
     1         47*t48+2.104036366334451d+4*t145*t44*t48-2.10403636633445
     2         1d+4*t145*t17*t41*t48-6.75229610717866d+0*t144*t17*t45*t4
     3         7+6.75229610717866d+0*t144*t44*t45*t46-8.416145465337804d
     4         +4*t145*t38*t45*t46-1.0128444160767991d+1*t144*t42*t44*t4
     5         6+3.787265459402013d+5*t145*t38*t42*t46-5.049687279202681
     6         d+5*t145*t38*t39*t46+2.1040363663344508d+5*t145*t36*t38*t
     7         46-4.208072732668902d+4*t145*t44*t45+1.2624218198006704d+
     8         5*t145*t17*t41*t45+2.104036366334451d+4*t145*t42*t44+1.01
     9         28444160767991d+1*t144*t41*t42*t43-2.104036366334451d+5*t
     :         145*t35*t42*t43-1.350459221435732d+1*t144*t39*t41*t43+8.4
     ;         16145465337803d+5*t145*t35*t39*t43-1.0520181831672254d+6*
     <         t145*t35*t36*t43+4.208072732668902d+5*t145*t33*t35*t43-1.
     =         8936327297010064d+5*t145*t17*t41*t42+8.416145465337804d+4
     >         *t145*t17*t39*t41+1.350459221435732d+1*t144*t38*t39*t40-4
     ?         .2080727326689016d+5*t145*t32*t39*t40-1.6880740267946648d
     @         +1*t144*t36*t38*t40+1.578027274750838d+6*t145*t32*t36*t40
     1         -1.893632729701006d+6*t145*t32*t33*t40+7.364127282170578d
     2         +5*t145*t30*t32*t40+1.6880740267946648d+1*t144*t35*t36*t3
     3         7-7.364127282170578d+5*t145*t29*t36*t37-2.025688832153598
     4         2d+1*t144*t33*t35*t37+2.6510858215814087d+6*t145*t29*t33*
     5         t37-3.0929334585116436d+6*t145*t29*t30*t37+1.178260365147
     6         2927d+6*t145*t27*t29*t37+2.0256888321535982d+1*t144*t32*t
     7         33*t34-1.1782603651472927d+6*t145*t26*t33*t34-2.363303637
     8         5125308d+1*t144*t30*t32*t34+4.123911278015524d+6*t145*t26
     9         *t30*t34-4.713041460589171d+6*t145*t26*t27*t34+1.76739054
     :         7720939d+6*t145*t24*t26*t34+2.3633036375125308d+1*t144*t2
     ;         9*t30*t31-1.7673905477209387d+6*t145*t23*t30*t31-2.700918
     <         442871464d+1*t144*t27*t29*t31+6.059624735043219d+6*t145*t
     =         23*t27*t31-6.817077826923622d+6*t145*t23*t24*t31+2.524843
     >         639601341d+6*t145*t21*t23*t31+2.700918442871464d+1*t144*t
     ?         26*t27*t28-2.524843639601341d+6*t145*t20*t27*t28-3.038533
     @         2482303967d+1*t144*t24*t26*t28+8.521347283654526d+6*t145*
     1         t20*t24*t28-9.468163648505028d+6*t145*t20*t21*t28+3.47166
     2         00044518436d+6*t14*t145*t20*t28-6.01754400771653d+6*t14*t
     3         145*t18*t250+3.0385332482303967d+1*t144*t23*t24*t25-3.471
     4         6600044518436d+6*t137*t145*t24*t25-3.3761480535893296d+1*
     5         t144*t21*t23*t25+1.1572200014839477d+7*t137*t145*t21*t25-
     6         1.2729420016323426d+7*t137*t14*t145*t25+3.376148053589329
     7         6d+1*t144*t20*t21*t22-4.628880005935792d+6*t145*t178*t21*
     8         t22-3.713762858948263d+1*t14*t144*t20*t22+1.5275304019588
     9         112d+7*t14*t145*t178*t22+3.713762858948263d+1*t137*t14*t1
     :         44*t18)-3.7221029453964005d+0*t12*t179*t3*t5-7.4442058907
     ;         92801d+0*t138*t151*t3*t5-2.7915772090473007d+0*t138*t191*
     <         t3*t4-2.7915772090473007d+0*t151*t179*t3*t4+3*t140*t194*t
     =         3+3*t153*t181*t3-3.6666666666666664d+0*t193*t199-3.666666
     >         6666666664d+0*t142*t193*t198-2.3333333333333334d+0*t186*t
     ?         197-6.666666666666666d-1*t189*t196-2.3333333333333334d+0*
     @         t142*t186*t195)*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = Amat3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = Amat3(iq,D3_RA_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*(t132*t134*(-9.23268430060156
     1         8d+2*t128*t91*t97+9.232684300601568d+2*t107*t126*t91*t97+
     2         9.232684300601568d+2*t128*t90*t97+2.769805290180471d+3*t1
     3         24*t127*t90*t97-3.693073720240627d+3*t107*t126*t90*t97-8.
     4         309415870541413d+3*t124*t127*t89*t97+2.769805290180471d+3
     5         *t107*t126*t89*t97+5.539610580360942d+3*t122*t125*t89*t97
     6         +5.539610580360942d+3*t124*t127*t88*t97-1.477229488096250
     7         8d+4*t122*t125*t88*t97+9.232684300601568d+3*t120*t123*t88
     8         *t97+9.232684300601568d+3*t122*t125*t87*t97-2.30817107515
     9         0392d+4*t120*t123*t87*t97+1.3849026450902355d+4*t118*t121
     :         *t87*t97+1.3849026450902355d+4*t120*t123*t86*t97-3.323766
     ;         348216566d+4*t118*t121*t86*t97+1.9388637031263292d+4*t116
     <         *t119*t86*t97+1.9388637031263292d+4*t118*t121*t85*t97-4.5
     =         240153072947686d+4*t116*t119*t85*t97+2.585151604168439d+4
     >         *t114*t117*t85*t97+2.585151604168439d+4*t116*t119*t84*t97
     ?         -5.908917952385003d+4*t114*t117*t84*t97+3.323766348216564
     @         7d+4*t112*t115*t84*t97+3.3237663482165647d+4*t114*t117*t8
     1         3*t97-7.478474283487271d+4*t112*t115*t83*t97+4.1547079352
     2         707056d+4*t110*t113*t83*t97+5.077976365330862d+4*t111*t15
     3         4*t82*t97+4.154707935270705d+4*t112*t115*t82*t97-9.232684
     4         300601568d+4*t110*t113*t82*t97+6.093571638397036d+4*t108*
     5         t200*t81*t97-1.1171548003727898d+5*t111*t154*t81*t97+5.07
     6         7976365330863d+4*t110*t113*t81*t97+2.104036366334451d+4*t
     7         126*t162*t91-2.104036366334451d+4*t107*t124*t162*t91-3.37
     8         614805358933d+0*t129*t161*t91+3.37614805358933d+0*t107*t1
     9         28*t161*t91-8.416145465337804d+4*t122*t127*t162*t90-4.208
     :         072732668902d+4*t126*t162*t90+1.2624218198006704d+5*t107*
     ;         t124*t162*t90-6.75229610717866d+0*t107*t128*t161*t90+6.75
     <         229610717866d+0*t126*t127*t161*t90+3.787265459402013d+5*t
     =         122*t127*t162*t89+2.104036366334451d+4*t126*t162*t89-2.10
     >         4036366334451d+5*t120*t125*t162*t89-1.8936327297010064d+5
     ?         *t107*t124*t162*t89-1.0128444160767991d+1*t126*t127*t161*
     @         t89+1.0128444160767991d+1*t124*t125*t161*t89-5.0496872792
     1         02681d+5*t122*t127*t162*t88+8.416145465337803d+5*t120*t12
     2         5*t162*t88+8.416145465337804d+4*t107*t124*t162*t88-4.2080
     3         727326689016d+5*t118*t123*t162*t88-1.350459221435732d+1*t
     4         124*t125*t161*t88+1.350459221435732d+1*t122*t123*t161*t88
     5         +2.1040363663344508d+5*t122*t127*t162*t87-1.0520181831672
     6         254d+6*t120*t125*t162*t87+1.578027274750838d+6*t118*t123*
     7         t162*t87-7.364127282170578d+5*t116*t121*t162*t87-1.688074
     8         0267946648d+1*t122*t123*t161*t87+1.6880740267946648d+1*t1
     9         20*t121*t161*t87+4.208072732668902d+5*t120*t125*t162*t86-
     :         1.893632729701006d+6*t118*t123*t162*t86+2.651085821581408
     ;         7d+6*t116*t121*t162*t86-1.1782603651472927d+6*t114*t119*t
     <         162*t86-2.0256888321535982d+1*t120*t121*t161*t86+2.025688
     =         8321535982d+1*t118*t119*t161*t86+7.364127282170578d+5*t11
     >         8*t123*t162*t85-3.0929334585116436d+6*t116*t121*t162*t85+
     ?         4.123911278015524d+6*t114*t119*t162*t85-1.767390547720938
     @         7d+6*t112*t117*t162*t85-2.3633036375125308d+1*t118*t119*t
     1         161*t85+2.3633036375125308d+1*t116*t117*t161*t85+1.178260
     2         3651472927d+6*t116*t121*t162*t84-4.713041460589171d+6*t11
     3         4*t119*t162*t84+6.059624735043219d+6*t112*t117*t162*t84-2
     4         .524843639601341d+6*t110*t115*t162*t84-2.700918442871464d
     5         +1*t116*t117*t161*t84+2.700918442871464d+1*t114*t115*t161
     6         *t84-3.4716600044518436d+6*t113*t154*t162*t83+1.767390547
     7         720939d+6*t114*t119*t162*t83-6.817077826923622d+6*t112*t1
     8         17*t162*t83+8.521347283654526d+6*t110*t115*t162*t83-3.038
     9         5332482303967d+1*t114*t115*t161*t83+3.0385332482303967d+1
     :         *t112*t113*t161*t83-4.628880005935792d+6*t111*t162*t200*t
     ;         82+1.1572200014839477d+7*t113*t154*t162*t82+2.52484363960
     <         1341d+6*t112*t117*t162*t82-9.468163648505028d+6*t110*t115
     =         *t162*t82-3.3761480535893296d+1*t112*t113*t161*t82+3.3761
     >         480535893296d+1*t110*t111*t161*t82-6.01754400771653d+6*t1
     ?         08*t162*t261*t81+1.5275304019588112d+7*t111*t162*t200*t81
     @         -1.2729420016323426d+7*t113*t154*t162*t81+3.4716600044518
     1         436d+6*t110*t115*t162*t81+3.713762858948263d+1*t108*t154*
     2         t161*t81-3.713762858948263d+1*t110*t111*t161*t81)+t134*t9
     3         5*(-9.232684300601568d+2*t128*t78*t97+9.232684300601568d+
     4         2*t107*t126*t78*t97+9.232684300601568d+2*t128*t77*t97+2.7
     5         69805290180471d+3*t124*t127*t77*t97-3.693073720240627d+3*
     6         t107*t126*t77*t97-8.309415870541413d+3*t124*t127*t76*t97+
     7         2.769805290180471d+3*t107*t126*t76*t97+5.539610580360942d
     8         +3*t122*t125*t76*t97+5.539610580360942d+3*t124*t127*t75*t
     9         97-1.4772294880962508d+4*t122*t125*t75*t97+9.232684300601
     :         568d+3*t120*t123*t75*t97+9.232684300601568d+3*t122*t125*t
     ;         74*t97-2.308171075150392d+4*t120*t123*t74*t97+1.384902645
     <         0902355d+4*t118*t121*t74*t97+1.3849026450902355d+4*t120*t
     =         123*t73*t97-3.323766348216566d+4*t118*t121*t73*t97+1.9388
     >         637031263292d+4*t116*t119*t73*t97+1.9388637031263292d+4*t
     ?         118*t121*t72*t97-4.5240153072947686d+4*t116*t119*t72*t97+
     @         2.585151604168439d+4*t114*t117*t72*t97+2.585151604168439d
     1         +4*t116*t119*t71*t97-5.908917952385003d+4*t114*t117*t71*t
     2         97+3.3237663482165647d+4*t112*t115*t71*t97+3.323766348216
     3         5647d+4*t114*t117*t70*t97-7.478474283487271d+4*t112*t115*
     4         t70*t97+4.1547079352707056d+4*t110*t113*t70*t97+5.0779763
     5         65330862d+4*t111*t154*t69*t97+4.154707935270705d+4*t112*t
     6         115*t69*t97-9.232684300601568d+4*t110*t113*t69*t97+6.0935
     7         71638397036d+4*t108*t200*t68*t97-1.1171548003727898d+5*t1
     8         11*t154*t68*t97+5.077976365330863d+4*t110*t113*t68*t97+2.
     9         104036366334451d+4*t126*t162*t78-2.104036366334451d+4*t10
     :         7*t124*t162*t78-3.37614805358933d+0*t129*t161*t78+3.37614
     ;         805358933d+0*t107*t128*t161*t78-8.416145465337804d+4*t122
     <         *t127*t162*t77-4.208072732668902d+4*t126*t162*t77+1.26242
     =         18198006704d+5*t107*t124*t162*t77-6.75229610717866d+0*t10
     >         7*t128*t161*t77+6.75229610717866d+0*t126*t127*t161*t77+3.
     ?         787265459402013d+5*t122*t127*t162*t76+2.104036366334451d+
     @         4*t126*t162*t76-2.104036366334451d+5*t120*t125*t162*t76-1
     1         .8936327297010064d+5*t107*t124*t162*t76-1.012844416076799
     2         1d+1*t126*t127*t161*t76+1.0128444160767991d+1*t124*t125*t
     3         161*t76-5.049687279202681d+5*t122*t127*t162*t75+8.4161454
     4         65337803d+5*t120*t125*t162*t75+8.416145465337804d+4*t107*
     5         t124*t162*t75-4.2080727326689016d+5*t118*t123*t162*t75-1.
     6         350459221435732d+1*t124*t125*t161*t75+1.350459221435732d+
     7         1*t122*t123*t161*t75+2.1040363663344508d+5*t122*t127*t162
     8         *t74-1.0520181831672254d+6*t120*t125*t162*t74+1.578027274
     9         750838d+6*t118*t123*t162*t74-7.364127282170578d+5*t116*t1
     :         21*t162*t74-1.6880740267946648d+1*t122*t123*t161*t74+1.68
     ;         80740267946648d+1*t120*t121*t161*t74+4.208072732668902d+5
     <         *t120*t125*t162*t73-1.893632729701006d+6*t118*t123*t162*t
     =         73+2.6510858215814087d+6*t116*t121*t162*t73-1.17826036514
     >         72927d+6*t114*t119*t162*t73-2.0256888321535982d+1*t120*t1
     ?         21*t161*t73+2.0256888321535982d+1*t118*t119*t161*t73+7.36
     @         4127282170578d+5*t118*t123*t162*t72-3.0929334585116436d+6
     1         *t116*t121*t162*t72+4.123911278015524d+6*t114*t119*t162*t
     2         72-1.7673905477209387d+6*t112*t117*t162*t72-2.36330363751
     3         25308d+1*t118*t119*t161*t72+2.3633036375125308d+1*t116*t1
     4         17*t161*t72+1.1782603651472927d+6*t116*t121*t162*t71-4.71
     5         3041460589171d+6*t114*t119*t162*t71+6.059624735043219d+6*
     6         t112*t117*t162*t71-2.524843639601341d+6*t110*t115*t162*t7
     7         1-2.700918442871464d+1*t116*t117*t161*t71+2.7009184428714
     8         64d+1*t114*t115*t161*t71-3.4716600044518436d+6*t113*t154*
     9         t162*t70+1.767390547720939d+6*t114*t119*t162*t70-6.817077
     :         826923622d+6*t112*t117*t162*t70+8.521347283654526d+6*t110
     ;         *t115*t162*t70-3.0385332482303967d+1*t114*t115*t161*t70+3
     <         .0385332482303967d+1*t112*t113*t161*t70-4.628880005935792
     =         d+6*t111*t162*t200*t69+1.1572200014839477d+7*t113*t154*t1
     >         62*t69+2.524843639601341d+6*t112*t117*t162*t69-9.46816364
     ?         8505028d+6*t110*t115*t162*t69-3.3761480535893296d+1*t112*
     @         t113*t161*t69+3.3761480535893296d+1*t110*t111*t161*t69-6.
     1         01754400771653d+6*t108*t162*t261*t68+1.5275304019588112d+
     2         7*t111*t162*t200*t68-1.2729420016323426d+7*t113*t154*t162
     3         *t68+3.4716600044518436d+6*t110*t115*t162*t68+3.713762858
     4         948263d+1*t108*t154*t161*t68-3.713762858948263d+1*t110*t1
     5         11*t161*t68)-9.305257363491002d-1*t104*t132*t96*(-9.23268
     6         4300601568d+2*t128*t64*t97+9.232684300601568d+2*t107*t126
     7         *t64*t97+9.232684300601568d+2*t128*t63*t97+2.769805290180
     8         471d+3*t124*t127*t63*t97-3.693073720240627d+3*t107*t126*t
     9         63*t97-8.309415870541413d+3*t124*t127*t62*t97+2.769805290
     :         180471d+3*t107*t126*t62*t97+5.539610580360942d+3*t122*t12
     ;         5*t62*t97+5.539610580360942d+3*t124*t127*t61*t97-1.477229
     <         4880962508d+4*t122*t125*t61*t97+9.232684300601568d+3*t120
     =         *t123*t61*t97+9.232684300601568d+3*t122*t125*t60*t97-2.30
     >         8171075150392d+4*t120*t123*t60*t97+1.3849026450902355d+4*
     ?         t118*t121*t60*t97+1.3849026450902355d+4*t120*t123*t59*t97
     @         -3.323766348216566d+4*t118*t121*t59*t97+1.938863703126329
     1         2d+4*t116*t119*t59*t97+1.9388637031263292d+4*t118*t121*t5
     2         8*t97-4.5240153072947686d+4*t116*t119*t58*t97+2.585151604
     3         168439d+4*t114*t117*t58*t97+2.585151604168439d+4*t116*t11
     4         9*t57*t97-5.908917952385003d+4*t114*t117*t57*t97+3.323766
     5         3482165647d+4*t112*t115*t57*t97+3.3237663482165647d+4*t11
     6         4*t117*t56*t97-7.478474283487271d+4*t112*t115*t56*t97+4.1
     7         547079352707056d+4*t110*t113*t56*t97+5.077976365330862d+4
     8         *t111*t154*t55*t97+4.154707935270705d+4*t112*t115*t55*t97
     9         -9.232684300601568d+4*t110*t113*t55*t97+6.093571638397036
     :         d+4*t108*t200*t54*t97-1.1171548003727898d+5*t111*t154*t54
     ;         *t97+5.077976365330863d+4*t110*t113*t54*t97+2.10403636633
     <         4451d+4*t126*t162*t64-2.104036366334451d+4*t107*t124*t162
     =         *t64-3.37614805358933d+0*t129*t161*t64+3.37614805358933d+
     >         0*t107*t128*t161*t64-8.416145465337804d+4*t122*t127*t162*
     ?         t63-4.208072732668902d+4*t126*t162*t63+1.2624218198006704
     @         d+5*t107*t124*t162*t63-6.75229610717866d+0*t107*t128*t161
     1         *t63+6.75229610717866d+0*t126*t127*t161*t63+3.78726545940
     2         2013d+5*t122*t127*t162*t62+2.104036366334451d+4*t126*t162
     3         *t62-2.104036366334451d+5*t120*t125*t162*t62-1.8936327297
     4         010064d+5*t107*t124*t162*t62-1.0128444160767991d+1*t126*t
     5         127*t161*t62+1.0128444160767991d+1*t124*t125*t161*t62-5.0
     6         49687279202681d+5*t122*t127*t162*t61+8.416145465337803d+5
     7         *t120*t125*t162*t61+8.416145465337804d+4*t107*t124*t162*t
     8         61-4.2080727326689016d+5*t118*t123*t162*t61-1.35045922143
     9         5732d+1*t124*t125*t161*t61+1.350459221435732d+1*t122*t123
     :         *t161*t61+2.1040363663344508d+5*t122*t127*t162*t60-1.0520
     ;         181831672254d+6*t120*t125*t162*t60+1.578027274750838d+6*t
     <         118*t123*t162*t60-7.364127282170578d+5*t116*t121*t162*t60
     =         -1.6880740267946648d+1*t122*t123*t161*t60+1.6880740267946
     >         648d+1*t120*t121*t161*t60+4.208072732668902d+5*t120*t125*
     ?         t162*t59-1.893632729701006d+6*t118*t123*t162*t59+2.651085
     @         8215814087d+6*t116*t121*t162*t59-1.1782603651472927d+6*t1
     1         14*t119*t162*t59-2.0256888321535982d+1*t120*t121*t161*t59
     2         +2.0256888321535982d+1*t118*t119*t161*t59+7.3641272821705
     3         78d+5*t118*t123*t162*t58-3.0929334585116436d+6*t116*t121*
     4         t162*t58+4.123911278015524d+6*t114*t119*t162*t58-1.767390
     5         5477209387d+6*t112*t117*t162*t58-2.3633036375125308d+1*t1
     6         18*t119*t161*t58+2.3633036375125308d+1*t116*t117*t161*t58
     7         +1.1782603651472927d+6*t116*t121*t162*t57-4.7130414605891
     8         71d+6*t114*t119*t162*t57+6.059624735043219d+6*t112*t117*t
     9         162*t57-2.524843639601341d+6*t110*t115*t162*t57-2.7009184
     :         42871464d+1*t116*t117*t161*t57+2.700918442871464d+1*t114*
     ;         t115*t161*t57-3.4716600044518436d+6*t113*t154*t162*t56+1.
     <         767390547720939d+6*t114*t119*t162*t56-6.817077826923622d+
     =         6*t112*t117*t162*t56+8.521347283654526d+6*t110*t115*t162*
     >         t56-3.0385332482303967d+1*t114*t115*t161*t56+3.0385332482
     ?         303967d+1*t112*t113*t161*t56-4.628880005935792d+6*t111*t1
     @         62*t200*t55+1.1572200014839477d+7*t113*t154*t162*t55+2.52
     1         4843639601341d+6*t112*t117*t162*t55-9.468163648505028d+6*
     2         t110*t115*t162*t55-3.3761480535893296d+1*t112*t113*t161*t
     3         55+3.3761480535893296d+1*t110*t111*t161*t55-6.01754400771
     4         653d+6*t108*t162*t261*t54+1.5275304019588112d+7*t111*t162
     5         *t200*t54-1.2729420016323426d+7*t113*t154*t162*t54+3.4716
     6         600044518436d+6*t110*t115*t162*t54+3.713762858948263d+1*t
     7         108*t154*t161*t54-3.713762858948263d+1*t110*t111*t161*t54
     8         )-9.305257363491002d-1*t104*t95*t96*(-9.232684300601568d+
     9         2*t128*t48*t97+9.232684300601568d+2*t107*t126*t48*t97+9.2
     :         32684300601568d+2*t128*t45*t97+2.769805290180471d+3*t124*
     ;         t127*t45*t97-3.693073720240627d+3*t107*t126*t45*t97-8.309
     <         415870541413d+3*t124*t127*t42*t97+2.769805290180471d+3*t1
     =         07*t126*t42*t97+5.539610580360942d+3*t122*t125*t42*t97+5.
     >         539610580360942d+3*t124*t127*t39*t97-1.4772294880962508d+
     ?         4*t122*t125*t39*t97+9.232684300601568d+3*t120*t123*t39*t9
     @         7+9.232684300601568d+3*t122*t125*t36*t97-2.30817107515039
     1         2d+4*t120*t123*t36*t97+1.3849026450902355d+4*t118*t121*t3
     2         6*t97+1.3849026450902355d+4*t120*t123*t33*t97-3.323766348
     3         216566d+4*t118*t121*t33*t97+1.9388637031263292d+4*t116*t1
     4         19*t33*t97+1.9388637031263292d+4*t118*t121*t30*t97-4.5240
     5         153072947686d+4*t116*t119*t30*t97+2.585151604168439d+4*t1
     6         14*t117*t30*t97+2.585151604168439d+4*t116*t119*t27*t97-5.
     7         908917952385003d+4*t114*t117*t27*t97+3.3237663482165647d+
     8         4*t112*t115*t27*t97+3.3237663482165647d+4*t114*t117*t24*t
     9         97-7.478474283487271d+4*t112*t115*t24*t97+4.1547079352707
     :         056d+4*t110*t113*t24*t97+5.077976365330862d+4*t111*t154*t
     ;         21*t97+4.154707935270705d+4*t112*t115*t21*t97-9.232684300
     <         601568d+4*t110*t113*t21*t97+6.093571638397036d+4*t108*t14
     =         *t200*t97-1.1171548003727898d+5*t111*t14*t154*t97+5.07797
     >         6365330863d+4*t110*t113*t14*t97+2.104036366334451d+4*t126
     ?         *t162*t48-2.104036366334451d+4*t107*t124*t162*t48-3.37614
     @         805358933d+0*t129*t161*t48+3.37614805358933d+0*t107*t128*
     1         t161*t48-8.416145465337804d+4*t122*t127*t162*t45-4.208072
     2         732668902d+4*t126*t162*t45+1.2624218198006704d+5*t107*t12
     3         4*t162*t45-6.75229610717866d+0*t107*t128*t161*t45+6.75229
     4         610717866d+0*t126*t127*t161*t45+3.787265459402013d+5*t122
     5         *t127*t162*t42+2.104036366334451d+4*t126*t162*t42-2.10403
     6         6366334451d+5*t120*t125*t162*t42-1.8936327297010064d+5*t1
     7         07*t124*t162*t42-1.0128444160767991d+1*t126*t127*t161*t42
     8         +1.0128444160767991d+1*t124*t125*t161*t42-5.0496872792026
     9         81d+5*t122*t127*t162*t39+8.416145465337803d+5*t120*t125*t
     :         162*t39+8.416145465337804d+4*t107*t124*t162*t39-4.2080727
     ;         326689016d+5*t118*t123*t162*t39-1.350459221435732d+1*t124
     <         *t125*t161*t39+1.350459221435732d+1*t122*t123*t161*t39+2.
     =         1040363663344508d+5*t122*t127*t162*t36-1.0520181831672254
     >         d+6*t120*t125*t162*t36+1.578027274750838d+6*t118*t123*t16
     ?         2*t36-7.364127282170578d+5*t116*t121*t162*t36-1.688074026
     @         7946648d+1*t122*t123*t161*t36+1.6880740267946648d+1*t120*
     1         t121*t161*t36+4.208072732668902d+5*t120*t125*t162*t33-1.8
     2         93632729701006d+6*t118*t123*t162*t33+2.6510858215814087d+
     3         6*t116*t121*t162*t33-1.1782603651472927d+6*t114*t119*t162
     4         *t33-2.0256888321535982d+1*t120*t121*t161*t33+2.025688832
     5         1535982d+1*t118*t119*t161*t33+7.364127282170578d+5*t118*t
     6         123*t162*t30-3.0929334585116436d+6*t116*t121*t162*t30+4.1
     7         23911278015524d+6*t114*t119*t162*t30-1.7673905477209387d+
     8         6*t112*t117*t162*t30-2.3633036375125308d+1*t118*t119*t161
     9         *t30+2.3633036375125308d+1*t116*t117*t161*t30+1.178260365
     :         1472927d+6*t116*t121*t162*t27-4.713041460589171d+6*t114*t
     ;         119*t162*t27+6.059624735043219d+6*t112*t117*t162*t27-2.52
     <         4843639601341d+6*t110*t115*t162*t27-2.700918442871464d+1*
     =         t116*t117*t161*t27+2.700918442871464d+1*t114*t115*t161*t2
     >         7-6.01754400771653d+6*t108*t14*t162*t261-3.47166000445184
     ?         36d+6*t113*t154*t162*t24+1.767390547720939d+6*t114*t119*t
     @         162*t24-6.817077826923622d+6*t112*t117*t162*t24+8.5213472
     1         83654526d+6*t110*t115*t162*t24-3.0385332482303967d+1*t114
     2         *t115*t161*t24+3.0385332482303967d+1*t112*t113*t161*t24-4
     3         .628880005935792d+6*t111*t162*t200*t21+1.1572200014839477
     4         d+7*t113*t154*t162*t21+2.524843639601341d+6*t112*t117*t16
     5         2*t21-9.468163648505028d+6*t110*t115*t162*t21-3.376148053
     6         5893296d+1*t112*t113*t161*t21+3.3761480535893296d+1*t110*
     7         t111*t161*t21+1.5275304019588112d+7*t111*t14*t162*t200-1.
     8         2729420016323426d+7*t113*t14*t154*t162+3.4716600044518436
     9         d+6*t110*t115*t14*t162+3.713762858948263d+1*t108*t14*t154
     :         *t161-3.713762858948263d+1*t110*t111*t14*t161)-3.72210294
     ;         53964005d+0*t130*t213*t95*t97-3.7221029453964005d+0*t104*
     <         t201*t95*t97-7.444205890792801d+0*t155*t167*t95*t97-3.722
     =         1029453964005d+0*t132*t133*t213*t97-3.7221029453964005d+0
     >         *t104*t132*t202*t97-7.444205890792801d+0*t132*t156*t167*t
     ?         97-9.305257363491002d-1*t130*t267*t95*t96-2.7915772090473
     @         007d+0*t155*t213*t95*t96-2.7915772090473007d+0*t167*t201*
     1         t95*t96-9.305257363491002d-1*t132*t133*t267*t96-2.7915772
     2         090473007d+0*t132*t156*t213*t96-2.7915772090473007d+0*t13
     3         2*t167*t202*t96+t165*(-1.2407009817988002d+0*t130*t167*t9
     4         5-1.2407009817988002d+0*t104*t155*t95+3.983592671062089d-
     5         3*gammabb*t104*t130*t159*t168+2.2404517531258392d-3*gamma
     6         bb*t104*t131*t133*t168-1.2407009817988002d+0*t132*t133*t1
     7         67-1.2407009817988002d+0*t104*t132*t156)+t135*t271*t95+3*
     8         t157*t216*t95+3*t169*t203*t95+t132*t136*t271-1.6481899623
     9         499732d-1*gammabb*t134*t135*t159*t270-9.269748178462429d-
     :         2*gammabb*t131*t134*t136*t270+2.5387780752001543d-3*t134*
     ;         t135*t205*t206*t269+5.84834598311815d-4*t131*t134*t136*t2
     <         05*t269-8.295189532329142d-6*t134*t135*t262*t263*t268-5.2
     =         17843141140167d-7*t131*t134*t136*t262*t268+2.987694503296
     >         569d-2*gammabb*t104*t130*t159*t266+1.6803388148443793d-2*
     ?         gammabb*t104*t131*t133*t266-1.5033443968152754d-3*t104*t1
     @         30*t205*t206*t265-3.4631141060506576d-4*t104*t131*t133*t2
     1         05*t265+7.718887347725925d-6*t104*t130*t262*t263*t264+4.8
     2         55337331063556d-7*t104*t131*t133*t262*t264-3.666666666666
     3         6664d+0*t215*t221+t206*t214*(2.3960893036683073d-2*gammab
     4         b*t220-2.3079800683637772d-4*t135*t169*t205-2.30798006836
     5         37772d-4*t134*t157*t205)-3.6666666666666664d+0*t159*t215*
     6         t220-2.3333333333333334d+0*t208*t219-6.666666666666666d-1
     7         *t211*t218+t206*t207*(2.3960893036683073d-2*gammabb*t217+
     8         2.1476348525932504d-4*t130*t167*t205+2.1476348525932504d-
     9         4*t104*t155*t205)-2.3333333333333334d+0*t159*t208*t217+t1
     :         68*(-1.6252155897304255d-2*gammabb*t131*t136*t216-1.06333
     ;         5633294209d-4*t131*t136*t168*t169*t205-1.063335633294209d
     <         -4*t131*t134*t158*t168*t205-1.6252155897304255d-2*gammabb
     =         *t131*t134*t204-3.250431179460851d-2*gammabb*t131*t158*t1
     >         69)+t159*t168*(-2.8896837002239784d-2*gammabb*t135*t216-2
     ?         .8896837002239784d-2*gammabb*t134*t203-5.779367400447957d
     @         -2*gammabb*t157*t169)+3*t132*t158*t216+(1.986374609670520
     1         4d-2*gammabb*t131*t136*t169+1.9863746096705204d-2*gammabb
     2         *t131*t134*t158)*t215+t159*(3.5318356336070855d-2*gammabb
     3         *t135*t169+3.5318356336070855d-2*gammabb*t134*t157)*t215+
     4         (-5.316678166471045d-5*t131*t136*t169*t205-5.316678166471
     5         045d-5*t131*t134*t158*t205)*t214+t160*(1.5123049333599414
     6         d-2*gammabb*t131*t133*t213+9.894611731573306d-5*t131*t133
     7         *t167*t168*t205+9.894611731573306d-5*t104*t131*t156*t168*
     8         t205+1.5123049333599414d-2*gammabb*t104*t131*t202+3.02460
     9         9866719883d-2*gammabb*t131*t156*t167)+t159*t160*(2.688925
     :         0529669106d-2*gammabb*t130*t213+2.6889250529669106d-2*gam
     ;         mabb*t104*t201+5.377850105933821d-2*gammabb*t155*t167)+(8
     <         .401694074221897d-3*gammabb*t131*t133*t167+8.401694074221
     =         897d-3*gammabb*t104*t131*t156)*t208+t159*(1.4938472516482
     >         826d-2*gammabb*t130*t167+1.4938472516482826d-2*gammabb*t1
     ?         04*t155)*t208+(4.947305865786653d-5*t131*t133*t167*t205+4
     @         .947305865786653d-5*t104*t131*t156*t205)*t207+3*t132*t169
     1         *t204)*wght+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RA_RA_GAA) = 1.0d+0*(t1*(2.0315194871630324d-3*t
     1         194*t51*t92+2.0315194871630324d-3*t182*t51*t66+4.06303897
     2         4326065d-3*t141*t153*t51)+t152*(3.9875086248532843d-5*gam
     3         maaa*t1*t153*t51*t92-1.0834770598202839d-2*t153*t51*t92+3
     4         .9875086248532843d-5*gammaaa*t1*t141*t51*t66-1.0834770598
     5         202839d-2*t141*t51*t66)+1.956691177927563d-7*t183*t273*t5
     6         1*t66*t92+1.9863746096705204d-2*t193*t51*t66*t92-1.794378
     7         8811839778d-4*gammaaa*t192*t51*t66*t92+t1*t142*(3.6121046
     8         25279974d-3*t194*t79+3.612104625279974d-3*t181*t66+7.2242
     9         09250559948d-3*t140*t153)+t142*t152*(-1.9264558001493193d
     :         -2*t153*t79-1.9264558001493193d-2*t140*t66)+3.11069607462
     ;         34286d-6*t183*t252*t273*t66*t79+3.5318356336070855d-2*t14
     <         2*t193*t66*t79-7.789432730727747d-4*gammaaa*t184*t192*t66
     =         *t79+t144*(-1.890381166699927d-3*t191*t51*t65-1.890381166
     >         699927d-3*t12*t180*t51-3.780762333399854d-3*t139*t151*t51
     ?         )+t143*(-3.71047939933999d-5*gammaaa*t1*t151*t51*t65+5.04
     @         1016444533138d-3*t151*t51*t65-3.71047939933999d-5*gammaaa
     1         *t1*t12*t139*t51+5.041016444533138d-3*t12*t139*t51)+t149*
     2         (-8.401694074221898d-4*t1*t12*t51*t65-1.4938472516482837d
     3         -3*t1*t12*t142*t50)-1.8207514991488338d-7*t12*t183*t272*t
     4         51*t65-5.041016444533138d-3*t12*t186*t51*t65+1.1749851431
     5         243302d-4*gammaaa*t12*t185*t51*t65+t142*t144*(-3.36115631
     6         6208638d-3*t191*t50-3.361156316208638d-3*t12*t179-6.72231
     7         2632417276d-3*t138*t151)+t142*t143*(8.963083509889702d-3*
     8         t151*t50+8.963083509889702d-3*t12*t138)-2.894582755397221
     9         4d-6*t12*t183*t252*t272*t50-8.963083509889707d-3*t12*t142
     :         *t186*t50+5.100632774908971d-4*gammaaa*t12*t184*t185*t50-
     ;         8.985334888756153d-3*t184*t198*t223-8.985334888756153d-3*
     <         t184*t195*t222)*wght+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_RB_GBB) = Cmat3(iq,D3_RA_RB_GBB)
            Cmat3(iq,D3_RB_RB_GAA) = Cmat3(iq,D3_RB_RB_GAA)
            Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
            Cmat3(iq,D3_RB_RB_GBB) = 1.0d+0*(t168*(3.9875086248532843d-5
     1         *gammabb*t131*t136*t169*t93+3.9875086248532843d-5*gammabb
     2         *t131*t134*t158*t93-1.0834770598202839d-2*t131*t136*t169-
     3         1.0834770598202839d-2*t131*t134*t158)+t160*(-3.7104793993
     4         3999d-5*gammabb*t131*t133*t167*t93-3.71047939933999d-5*ga
     5         mmabb*t104*t131*t156*t93+5.041016444533138d-3*t131*t133*t
     6         167+5.041016444533138d-3*t104*t131*t156)+t165*(-1.4938472
     7         516482837d-3*t104*t130*t159*t93-8.401694074221898d-4*t104
     8         *t131*t133*t93)+(2.0315194871630324d-3*t131*t136*t216+2.0
     9         315194871630324d-3*t131*t134*t204+4.063038974326065d-3*t1
     :         31*t158*t169)*t93+t159*(3.612104625279974d-3*t135*t216+3.
     ;         612104625279974d-3*t134*t203+7.224209250559948d-3*t157*t1
     <         69)*t93+3.1106960746234286d-6*t134*t135*t205*t263*t275+1.
     =         956691177927563d-7*t131*t134*t136*t205*t275-2.89458275539
     >         72214d-6*t104*t130*t205*t263*t274-1.8207514991488338d-7*t
     ?         104*t131*t133*t205*t274-8.985334888756153d-3*t206*t220*t2
     @         27-8.985334888756153d-3*t206*t217*t226+3.5318356336070855
     1         d-2*t134*t135*t159*t215+1.9863746096705204d-2*t131*t134*t
     2         136*t215-7.789432730727747d-4*gammabb*t134*t135*t206*t214
     3         -1.7943788811839778d-4*gammabb*t131*t134*t136*t214+t161*(
     4         -1.890381166699927d-3*t131*t133*t213-1.890381166699927d-3
     5         *t104*t131*t202-3.780762333399854d-3*t131*t156*t167)+t159
     6         *t161*(-3.361156316208638d-3*t130*t213-3.361156316208638d
     7         -3*t104*t201-6.722312632417276d-3*t155*t167)-8.9630835098
     8         89707d-3*t104*t130*t159*t208-5.041016444533138d-3*t104*t1
     9         31*t133*t208+5.100632774908971d-4*gammabb*t104*t130*t206*
     :         t207+1.1749851431243302d-4*gammabb*t104*t131*t133*t207+t1
     ;         59*t168*(-1.9264558001493193d-2*t135*t169-1.9264558001493
     <         193d-2*t134*t157)+t159*t160*(8.963083509889702d-3*t130*t1
     =         67+8.963083509889702d-3*t104*t155))*wght+Cmat3(iq,D3_RB_R
     >         B_GBB)
            Cmat3(iq,D3_RA_GAA_GAA) = 1.0d+0*(t1*(-7.476578671599909d-6*
     1         t1*t153*t51*t92-7.476578671599909d-6*t1*t141*t51*t66)-7.3
     2         37591917228362d-8*gammaaa*t277*t51*t66*t92+3.987508624853
     3         2843d-5*t223*t51*t66*t92-1.1665110279837858d-6*gammaaa*t2
     4         52*t277*t66*t79+1.7309850512728328d-4*t184*t223*t66*t79+t
     5         144*(6.957148873762482d-6*t1*t151*t51*t65+6.9571488737624
     6         82d-6*t1*t12*t139*t51)+6.827818121808127d-8*gammaaa*t12*t
     7         276*t51*t65-2.7828595495049924d-5*t12*t222*t51*t65+1.0854
     8         685332739583d-6*gammaaa*t12*t252*t276*t50-1.2080446045837
     9         034d-4*t12*t184*t222*t50-8.985334888756153d-3*t184*t225*t
     :         231-8.985334888756153d-3*t184*t224*t230)*wght+Cmat3(iq,D3
     ;         _RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_RB_GAA_GAA) = Cmat3(iq,D3_RB_GAA_GAA)
            Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
            Cmat3(iq,D3_RB_GAA_GBB) = Cmat3(iq,D3_RB_GAA_GBB)
            Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
            Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = 1.0d+0*(t93*(-7.476578671599909d-6
     1         *t131*t136*t169*t93-7.476578671599909d-6*t131*t134*t158*t
     2         93)+t161*(6.957148873762482d-6*t131*t133*t167*t93+6.95714
     3         8873762482d-6*t104*t131*t156*t93)-1.1665110279837858d-6*g
     4         ammabb*t134*t135*t263*t279-7.337591917228362d-8*gammabb*t
     5         131*t134*t136*t279+1.0854685332739583d-6*gammabb*t104*t13
     6         0*t263*t278+6.827818121808127d-8*gammabb*t104*t131*t133*t
     7         278-8.985334888756153d-3*t206*t229*t233-8.985334888756153
     8         d-3*t206*t228*t232+1.7309850512728328d-4*t134*t135*t206*t
     9         227+3.9875086248532843d-5*t131*t134*t136*t227-1.208044604
     :         5837034d-4*t104*t130*t206*t226-2.7828595495049924d-5*t104
     ;         *t131*t133*t226)*wght+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = 1.0d+0*(2.751596968960636d-8*t281
     1         *t51*t66*t92+4.374416354939197d-7*t252*t281*t66*t79-2.560
     2         431795678048d-8*t12*t280*t51*t65-4.070506999777343d-7*t12
     3         *t252*t280*t50)*wght+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
            Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
            Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = 1.0d+0*(4.374416354939197d-7*t134
     1         *t135*t263*t283+2.751596968960636d-8*t131*t134*t136*t283-
     2         4.070506999777343d-7*t104*t130*t263*t282-2.56043179567804
     3         8d-8*t104*t131*t133*t282)*wght+Cmat3(iq,D3_GBB_GBB_GBB)
            Mmat3(iq,D3_RA_RA_TA) = 1.0d+0*(t52*t66*(4.0513776643071964d
     1         +1*t17*t44*t6*t91+9.232684300601569d+2*t4*t44*t91-2.76980
     2         5290180471d+3*t17*t4*t41*t91-4.0513776643071964d+1*t47*t6
     3         *t90+1.2154132992921589d+2*t41*t46*t6*t90-1.1079221160721
     4         883d+4*t38*t4*t46*t90+1.846536860120314d+3*t4*t44*t90+5.5
     5         39610580360942d+3*t17*t4*t41*t90-1.2154132992921589d+2*t1
     6         7*t44*t6*t89+2.4308265985843178d+2*t38*t43*t6*t89+1.66188
     7         31741082832d+4*t38*t4*t46*t89-2.769805290180471d+3*t4*t44
     8         *t89-2.769805290180471d+4*t35*t4*t43*t89+8.30941587054141
     9         6d+3*t17*t4*t41*t89-2.4308265985843178d+2*t41*t46*t6*t88+
     :         4.0513776643071964d+2*t35*t40*t6*t88+2.2158442321443766d+
     ;         4*t38*t4*t46*t88+3.693073720240629d+4*t35*t4*t43*t88-1.10
     <         79221160721883d+4*t17*t4*t41*t88-5.539610580360941d+4*t32
     =         *t4*t40*t88-4.051377664307196d+2*t38*t43*t6*t87+6.0770664
     >         96460793d+2*t32*t37*t6*t87-2.7698052901804704d+4*t38*t4*t
     ?         46*t87+4.616342150300784d+4*t35*t4*t43*t87+6.924513225451
     @         174d+4*t32*t4*t40*t87-9.694318515631648d+4*t29*t37*t4*t87
     1         -6.077066496460795d+2*t35*t40*t6*t86+8.507893095045113d+2
     2         *t29*t34*t6*t86-5.539610580360942d+4*t35*t4*t43*t86+8.309
     3         415870541416d+4*t32*t4*t40*t86+1.1633182218757979d+5*t29*
     4         t37*t4*t86-1.5510909625010638d+5*t26*t34*t4*t86-8.5078930
     5         95045111d+2*t32*t37*t6*t85+1.1343857460060149d+3*t26*t31*
     6         t6*t85-9.694318515631648d+4*t32*t4*t40*t85+1.357204592188
     7         4307d+5*t29*t37*t4*t85+1.809606122917908d+5*t26*t34*t4*t8
     8         5-2.3266364437515955d+5*t23*t31*t4*t85-1.1343857460060149
     9         d+3*t29*t34*t6*t84+1.4584959591505908d+3*t23*t28*t6*t84-1
     :         .5510909625010635d+5*t29*t37*t4*t84+2.0681212833347515d+5
     ;         *t26*t34*t4*t84+2.659013078573252d+5*t23*t31*t4*t84-3.323
     <         766348216565d+5*t20*t28*t4*t84-1.4584959591505905d+3*t26*
     =         t31*t6*t83+1.8231199489382383d+3*t20*t25*t6*t83-2.3266364
     >         437515952d+5*t26*t34*t4*t83+2.9913897133949086d+5*t23*t31
     ?         *t4*t83+3.7392371417436354d+5*t20*t28*t4*t83-4.5701787287
     @         977763d+5*t137*t25*t4*t83-1.8231199489382383d+3*t23*t28*t
     1         6*t82+2.2282577153689576d+3*t137*t22*t6*t82-3.32376634821
     2         65647d+5*t23*t31*t4*t82+4.1547079352707056d+5*t20*t28*t4*
     3         t82+5.077976365330863d+5*t137*t25*t4*t82-6.09357163839703
     4         5d+5*t178*t22*t4*t82-2.228257715368958d+3*t20*t25*t6*t81+
     5         2.6739092584427493d+3*t178*t18*t6*t81-4.5701787287977763d
     6         +5*t20*t28*t4*t81-7.921643129916147d+5*t18*t250*t4*t81+5.
     7         585774001863949d+5*t137*t25*t4*t81+6.702928802236738d+5*t
     8         178*t22*t4*t81)+t3*t66*(4.0513776643071964d+1*t17*t44*t6*
     9         t78+9.232684300601569d+2*t4*t44*t78-2.769805290180471d+3*
     :         t17*t4*t41*t78-4.0513776643071964d+1*t47*t6*t77+1.2154132
     ;         992921589d+2*t41*t46*t6*t77-1.1079221160721883d+4*t38*t4*
     <         t46*t77+1.846536860120314d+3*t4*t44*t77+5.539610580360942
     =         d+3*t17*t4*t41*t77-1.2154132992921589d+2*t17*t44*t6*t76+2
     >         .4308265985843178d+2*t38*t43*t6*t76+1.6618831741082832d+4
     ?         *t38*t4*t46*t76-2.769805290180471d+3*t4*t44*t76-2.7698052
     @         90180471d+4*t35*t4*t43*t76+8.309415870541416d+3*t17*t4*t4
     1         1*t76-2.4308265985843178d+2*t41*t46*t6*t75+4.051377664307
     2         1964d+2*t35*t40*t6*t75+2.2158442321443766d+4*t38*t4*t46*t
     3         75+3.693073720240629d+4*t35*t4*t43*t75-1.1079221160721883
     4         d+4*t17*t4*t41*t75-5.539610580360941d+4*t32*t4*t40*t75-4.
     5         051377664307196d+2*t38*t43*t6*t74+6.077066496460793d+2*t3
     6         2*t37*t6*t74-2.7698052901804704d+4*t38*t4*t46*t74+4.61634
     7         2150300784d+4*t35*t4*t43*t74+6.924513225451174d+4*t32*t4*
     8         t40*t74-9.694318515631648d+4*t29*t37*t4*t74-6.07706649646
     9         0795d+2*t35*t40*t6*t73+8.507893095045113d+2*t29*t34*t6*t7
     :         3-5.539610580360942d+4*t35*t4*t43*t73+8.309415870541416d+
     ;         4*t32*t4*t40*t73+1.1633182218757979d+5*t29*t37*t4*t73-1.5
     <         510909625010638d+5*t26*t34*t4*t73-8.507893095045111d+2*t3
     =         2*t37*t6*t72+1.1343857460060149d+3*t26*t31*t6*t72-9.69431
     >         8515631648d+4*t32*t4*t40*t72+1.3572045921884307d+5*t29*t3
     ?         7*t4*t72+1.809606122917908d+5*t26*t34*t4*t72-2.3266364437
     @         515955d+5*t23*t31*t4*t72-1.1343857460060149d+3*t29*t34*t6
     1         *t71+1.4584959591505908d+3*t23*t28*t6*t71-1.5510909625010
     2         635d+5*t29*t37*t4*t71+2.0681212833347515d+5*t26*t34*t4*t7
     3         1+2.659013078573252d+5*t23*t31*t4*t71-3.323766348216565d+
     4         5*t20*t28*t4*t71-1.4584959591505905d+3*t26*t31*t6*t70+1.8
     5         231199489382383d+3*t20*t25*t6*t70-2.3266364437515952d+5*t
     6         26*t34*t4*t70+2.9913897133949086d+5*t23*t31*t4*t70+3.7392
     7         371417436354d+5*t20*t28*t4*t70-4.5701787287977763d+5*t137
     8         *t25*t4*t70-1.8231199489382383d+3*t23*t28*t6*t69+2.228257
     9         7153689576d+3*t137*t22*t6*t69-3.3237663482165647d+5*t23*t
     :         31*t4*t69+4.1547079352707056d+5*t20*t28*t4*t69+5.07797636
     ;         5330863d+5*t137*t25*t4*t69-6.093571638397035d+5*t178*t22*
     <         t4*t69-2.228257715368958d+3*t20*t25*t6*t68+2.673909258442
     =         7493d+3*t178*t18*t6*t68-4.5701787287977763d+5*t20*t28*t4*
     >         t68-7.921643129916147d+5*t18*t250*t4*t68+5.58577400186394
     ?         9d+5*t137*t25*t4*t68+6.702928802236738d+5*t178*t22*t4*t68
     @         )+t152*(-1.0834770598202839d-2*gammaaa*t237*t51*t66-1.083
     1         4770598202839d-2*gammaaa*t153*t173*t51)+t142*t152*(-1.926
     2         4558001493193d-2*gammaaa*t236*t66-1.9264558001493193d-2*g
     3         ammaaa*t153*t172)+1.9863746096705204d-2*gammaaa*t173*t193
     4         *t51*t66-5.316678166471045d-5*t173*t183*t192*t51*t66+3.53
     5         18356336070855d-2*gammaaa*t142*t172*t193*t66-2.3079800683
     6         637772d-4*t172*t183*t184*t192*t66-9.305257363491002d-1*t1
     7         2*t4*t52*(4.0513776643071964d+1*t17*t44*t6*t64+9.23268430
     8         0601569d+2*t4*t44*t64-2.769805290180471d+3*t17*t4*t41*t64
     9         -4.0513776643071964d+1*t47*t6*t63+1.2154132992921589d+2*t
     :         41*t46*t6*t63-1.1079221160721883d+4*t38*t4*t46*t63+1.8465
     ;         36860120314d+3*t4*t44*t63+5.539610580360942d+3*t17*t4*t41
     <         *t63-1.2154132992921589d+2*t17*t44*t6*t62+2.4308265985843
     =         178d+2*t38*t43*t6*t62+1.6618831741082832d+4*t38*t4*t46*t6
     >         2-2.769805290180471d+3*t4*t44*t62-2.769805290180471d+4*t3
     ?         5*t4*t43*t62+8.309415870541416d+3*t17*t4*t41*t62-2.430826
     @         5985843178d+2*t41*t46*t6*t61+4.0513776643071964d+2*t35*t4
     1         0*t6*t61+2.2158442321443766d+4*t38*t4*t46*t61+3.693073720
     2         240629d+4*t35*t4*t43*t61-1.1079221160721883d+4*t17*t4*t41
     3         *t61-5.539610580360941d+4*t32*t4*t40*t61-4.05137766430719
     4         6d+2*t38*t43*t6*t60+6.077066496460793d+2*t32*t37*t6*t60-2
     5         .7698052901804704d+4*t38*t4*t46*t60+4.616342150300784d+4*
     6         t35*t4*t43*t60+6.924513225451174d+4*t32*t4*t40*t60-9.6943
     7         18515631648d+4*t29*t37*t4*t60-6.077066496460795d+2*t35*t4
     8         0*t59*t6+8.507893095045113d+2*t29*t34*t59*t6-8.5078930950
     9         45111d+2*t32*t37*t58*t6+1.1343857460060149d+3*t26*t31*t58
     :         *t6-1.1343857460060149d+3*t29*t34*t57*t6+1.45849595915059
     ;         08d+3*t23*t28*t57*t6-1.4584959591505905d+3*t26*t31*t56*t6
     <         +1.8231199489382383d+3*t20*t25*t56*t6-1.8231199489382383d
     =         +3*t23*t28*t55*t6+2.2282577153689576d+3*t137*t22*t55*t6-2
     >         .228257715368958d+3*t20*t25*t54*t6+2.6739092584427493d+3*
     ?         t178*t18*t54*t6-5.539610580360942d+4*t35*t4*t43*t59+8.309
     @         415870541416d+4*t32*t4*t40*t59+1.1633182218757979d+5*t29*
     1         t37*t4*t59-1.5510909625010638d+5*t26*t34*t4*t59-9.6943185
     2         15631648d+4*t32*t4*t40*t58+1.3572045921884307d+5*t29*t37*
     3         t4*t58+1.809606122917908d+5*t26*t34*t4*t58-2.326636443751
     4         5955d+5*t23*t31*t4*t58-1.5510909625010635d+5*t29*t37*t4*t
     5         57+2.0681212833347515d+5*t26*t34*t4*t57+2.659013078573252
     6         d+5*t23*t31*t4*t57-3.323766348216565d+5*t20*t28*t4*t57-2.
     7         3266364437515952d+5*t26*t34*t4*t56+2.9913897133949086d+5*
     8         t23*t31*t4*t56+3.7392371417436354d+5*t20*t28*t4*t56-4.570
     9         1787287977763d+5*t137*t25*t4*t56-3.3237663482165647d+5*t2
     :         3*t31*t4*t55+4.1547079352707056d+5*t20*t28*t4*t55+5.07797
     ;         6365330863d+5*t137*t25*t4*t55-6.093571638397035d+5*t178*t
     <         22*t4*t55-4.5701787287977763d+5*t20*t28*t4*t54-7.92164312
     =         9916147d+5*t18*t250*t4*t54+5.585774001863949d+5*t137*t25*
     >         t4*t54+6.702928802236738d+5*t178*t22*t4*t54)-9.3052573634
     ?         91002d-1*t12*t3*t4*(4.0513776643071964d+1*t17*t44*t48*t6-
     @         4.0513776643071964d+1*t45*t47*t6+1.2154132992921589d+2*t4
     1         1*t45*t46*t6-2.4308265985843178d+2*t39*t41*t46*t6-1.21541
     2         32992921589d+2*t17*t42*t44*t6+2.4308265985843178d+2*t38*t
     3         42*t43*t6-4.051377664307196d+2*t36*t38*t43*t6+4.051377664
     4         3071964d+2*t35*t39*t40*t6-6.077066496460795d+2*t33*t35*t4
     5         0*t6+6.077066496460793d+2*t32*t36*t37*t6-8.50789309504511
     6         1d+2*t30*t32*t37*t6+8.507893095045113d+2*t29*t33*t34*t6-1
     7         .1343857460060149d+3*t27*t29*t34*t6+1.1343857460060149d+3
     8         *t26*t30*t31*t6-1.4584959591505905d+3*t24*t26*t31*t6+1.45
     9         84959591505908d+3*t23*t27*t28*t6-1.8231199489382383d+3*t2
     :         1*t23*t28*t6+1.8231199489382383d+3*t20*t24*t25*t6-2.22825
     ;         7715368958d+3*t14*t20*t25*t6+2.2282577153689576d+3*t137*t
     <         21*t22*t6+2.6739092584427493d+3*t14*t178*t18*t6+9.2326843
     =         00601569d+2*t4*t44*t48-2.769805290180471d+3*t17*t4*t41*t4
     >         8-1.1079221160721883d+4*t38*t4*t45*t46+1.6618831741082832
     ?         d+4*t38*t4*t42*t46+2.2158442321443766d+4*t38*t39*t4*t46-2
     @         .7698052901804704d+4*t36*t38*t4*t46+1.846536860120314d+3*
     1         t4*t44*t45+5.539610580360942d+3*t17*t4*t41*t45-2.76980529
     2         0180471d+3*t4*t42*t44-2.769805290180471d+4*t35*t4*t42*t43
     3         +3.693073720240629d+4*t35*t39*t4*t43+4.616342150300784d+4
     4         *t35*t36*t4*t43-5.539610580360942d+4*t33*t35*t4*t43+8.309
     5         415870541416d+3*t17*t4*t41*t42-1.1079221160721883d+4*t17*
     6         t39*t4*t41-5.539610580360941d+4*t32*t39*t4*t40+6.92451322
     7         5451174d+4*t32*t36*t4*t40+8.309415870541416d+4*t32*t33*t4
     8         *t40-9.694318515631648d+4*t30*t32*t4*t40-9.69431851563164
     9         8d+4*t29*t36*t37*t4+1.1633182218757979d+5*t29*t33*t37*t4+
     :         1.3572045921884307d+5*t29*t30*t37*t4-1.5510909625010635d+
     ;         5*t27*t29*t37*t4-1.5510909625010638d+5*t26*t33*t34*t4+1.8
     <         09606122917908d+5*t26*t30*t34*t4+2.0681212833347515d+5*t2
     =         6*t27*t34*t4-2.3266364437515952d+5*t24*t26*t34*t4-2.32663
     >         64437515955d+5*t23*t30*t31*t4+2.659013078573252d+5*t23*t2
     ?         7*t31*t4+2.9913897133949086d+5*t23*t24*t31*t4-3.323766348
     @         2165647d+5*t21*t23*t31*t4-3.323766348216565d+5*t20*t27*t2
     1         8*t4+3.7392371417436354d+5*t20*t24*t28*t4+4.1547079352707
     2         056d+5*t20*t21*t28*t4-4.5701787287977763d+5*t14*t20*t28*t
     3         4-7.921643129916147d+5*t14*t18*t250*t4-4.5701787287977763
     4         d+5*t137*t24*t25*t4+5.077976365330863d+5*t137*t21*t25*t4+
     5         5.585774001863949d+5*t137*t14*t25*t4-6.093571638397035d+5
     6         *t178*t21*t22*t4+6.702928802236738d+5*t14*t178*t22*t4)+t1
     7         49*(-4.135669939329334d-1*t12*t171*t52-4.135669939329334d
     8         -1*t12*t170*t3)-2.4814019635976003d+0*t12*t235*t5*t52-2.4
     9         814019635976003d+0*t151*t171*t5*t52-1.8610514726982003d+0
     :         *t151*t235*t4*t52-9.305257363491002d-1*t171*t191*t4*t52+2
     ;         *t153*t237*t52+t173*t194*t52+t143*(1.0082032889066277d-2*
     <         gammaaa*t12*t235*t51+1.0082032889066277d-2*gammaaa*t151*t
     =         171*t51)-5.041016444533138d-3*gammaaa*t12*t171*t186*t51+4
     >         .947305865786653d-5*t12*t171*t183*t185*t51-2.481401963597
     ?         6003d+0*t12*t234*t3*t5-2.4814019635976003d+0*t151*t170*t3
     @         *t5-1.8610514726982003d+0*t151*t234*t3*t4-9.3052573634910
     1         02d-1*t170*t191*t3*t4+2*t153*t236*t3+t172*t194*t3+t142*t1
     2         43*(1.7926167019779404d-2*gammaaa*t12*t234+1.792616701977
     3         9404d-2*gammaaa*t151*t170)-8.963083509889707d-3*gammaaa*t
     4         12*t142*t170*t186+2.1476348525932504d-4*t12*t170*t183*t18
     5         4*t185)*wght+Mmat3(iq,D3_RA_RA_TA)
            Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
            Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
            Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
            Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
            Mmat3(iq,D3_RB_RB_TB) = 1.0d+0*(t132*t134*(4.051377664307196
     1         4d+1*t107*t126*t91*t98-4.0513776643071964d+1*t128*t90*t98
     2         +1.2154132992921589d+2*t124*t127*t90*t98-1.21541329929215
     3         89d+2*t107*t126*t89*t98+2.4308265985843178d+2*t122*t125*t
     4         89*t98-2.4308265985843178d+2*t124*t127*t88*t98+4.05137766
     5         43071964d+2*t120*t123*t88*t98-4.051377664307196d+2*t122*t
     6         125*t87*t98+6.077066496460793d+2*t118*t121*t87*t98-6.0770
     7         66496460795d+2*t120*t123*t86*t98+8.507893095045113d+2*t11
     8         6*t119*t86*t98-8.507893095045111d+2*t118*t121*t85*t98+1.1
     9         343857460060149d+3*t114*t117*t85*t98-1.1343857460060149d+
     :         3*t116*t119*t84*t98+1.4584959591505908d+3*t112*t115*t84*t
     ;         98-1.4584959591505905d+3*t114*t117*t83*t98+1.823119948938
     <         2383d+3*t110*t113*t83*t98+2.2282577153689576d+3*t111*t154
     =         *t82*t98-1.8231199489382383d+3*t112*t115*t82*t98+2.673909
     >         2584427493d+3*t108*t200*t81*t98-2.228257715368958d+3*t110
     ?         *t113*t81*t98+9.232684300601569d+2*t126*t91*t96-2.7698052
     @         90180471d+3*t107*t124*t91*t96-1.1079221160721883d+4*t122*
     1         t127*t90*t96+1.846536860120314d+3*t126*t90*t96+5.53961058
     2         0360942d+3*t107*t124*t90*t96+1.6618831741082832d+4*t122*t
     3         127*t89*t96-2.769805290180471d+3*t126*t89*t96-2.769805290
     4         180471d+4*t120*t125*t89*t96+8.309415870541416d+3*t107*t12
     5         4*t89*t96+2.2158442321443766d+4*t122*t127*t88*t96+3.69307
     6         3720240629d+4*t120*t125*t88*t96-1.1079221160721883d+4*t10
     7         7*t124*t88*t96-5.539610580360941d+4*t118*t123*t88*t96-2.7
     8         698052901804704d+4*t122*t127*t87*t96+4.616342150300784d+4
     9         *t120*t125*t87*t96+6.924513225451174d+4*t118*t123*t87*t96
     :         -9.694318515631648d+4*t116*t121*t87*t96-5.539610580360942
     ;         d+4*t120*t125*t86*t96+8.309415870541416d+4*t118*t123*t86*
     <         t96+1.1633182218757979d+5*t116*t121*t86*t96-1.55109096250
     =         10638d+5*t114*t119*t86*t96-9.694318515631648d+4*t118*t123
     >         *t85*t96+1.3572045921884307d+5*t116*t121*t85*t96+1.809606
     ?         122917908d+5*t114*t119*t85*t96-2.3266364437515955d+5*t112
     @         *t117*t85*t96-1.5510909625010635d+5*t116*t121*t84*t96+2.0
     1         681212833347515d+5*t114*t119*t84*t96+2.659013078573252d+5
     2         *t112*t117*t84*t96-3.323766348216565d+5*t110*t115*t84*t96
     3         -4.5701787287977763d+5*t113*t154*t83*t96-2.32663644375159
     4         52d+5*t114*t119*t83*t96+2.9913897133949086d+5*t112*t117*t
     5         83*t96+3.7392371417436354d+5*t110*t115*t83*t96-6.09357163
     6         8397035d+5*t111*t200*t82*t96+5.077976365330863d+5*t113*t1
     7         54*t82*t96-3.3237663482165647d+5*t112*t117*t82*t96+4.1547
     8         079352707056d+5*t110*t115*t82*t96-7.921643129916147d+5*t1
     9         08*t261*t81*t96+6.702928802236738d+5*t111*t200*t81*t96+5.
     :         585774001863949d+5*t113*t154*t81*t96-4.5701787287977763d+
     ;         5*t110*t115*t81*t96)+t134*t95*(4.0513776643071964d+1*t107
     <         *t126*t78*t98-4.0513776643071964d+1*t128*t77*t98+1.215413
     =         2992921589d+2*t124*t127*t77*t98-1.2154132992921589d+2*t10
     >         7*t126*t76*t98+2.4308265985843178d+2*t122*t125*t76*t98-2.
     ?         4308265985843178d+2*t124*t127*t75*t98+4.0513776643071964d
     @         +2*t120*t123*t75*t98-4.051377664307196d+2*t122*t125*t74*t
     1         98+6.077066496460793d+2*t118*t121*t74*t98-6.0770664964607
     2         95d+2*t120*t123*t73*t98+8.507893095045113d+2*t116*t119*t7
     3         3*t98-8.507893095045111d+2*t118*t121*t72*t98+1.1343857460
     4         060149d+3*t114*t117*t72*t98-1.1343857460060149d+3*t116*t1
     5         19*t71*t98+1.4584959591505908d+3*t112*t115*t71*t98-1.4584
     6         959591505905d+3*t114*t117*t70*t98+1.8231199489382383d+3*t
     7         110*t113*t70*t98+2.2282577153689576d+3*t111*t154*t69*t98-
     8         1.8231199489382383d+3*t112*t115*t69*t98+2.673909258442749
     9         3d+3*t108*t200*t68*t98-2.228257715368958d+3*t110*t113*t68
     :         *t98+9.232684300601569d+2*t126*t78*t96-2.769805290180471d
     ;         +3*t107*t124*t78*t96-1.1079221160721883d+4*t122*t127*t77*
     <         t96+1.846536860120314d+3*t126*t77*t96+5.539610580360942d+
     =         3*t107*t124*t77*t96+1.6618831741082832d+4*t122*t127*t76*t
     >         96-2.769805290180471d+3*t126*t76*t96-2.769805290180471d+4
     ?         *t120*t125*t76*t96+8.309415870541416d+3*t107*t124*t76*t96
     @         +2.2158442321443766d+4*t122*t127*t75*t96+3.69307372024062
     1         9d+4*t120*t125*t75*t96-1.1079221160721883d+4*t107*t124*t7
     2         5*t96-5.539610580360941d+4*t118*t123*t75*t96-2.7698052901
     3         804704d+4*t122*t127*t74*t96+4.616342150300784d+4*t120*t12
     4         5*t74*t96+6.924513225451174d+4*t118*t123*t74*t96-9.694318
     5         515631648d+4*t116*t121*t74*t96-5.539610580360942d+4*t120*
     6         t125*t73*t96+8.309415870541416d+4*t118*t123*t73*t96+1.163
     7         3182218757979d+5*t116*t121*t73*t96-1.5510909625010638d+5*
     8         t114*t119*t73*t96-9.694318515631648d+4*t118*t123*t72*t96+
     9         1.3572045921884307d+5*t116*t121*t72*t96+1.809606122917908
     :         d+5*t114*t119*t72*t96-2.3266364437515955d+5*t112*t117*t72
     ;         *t96-1.5510909625010635d+5*t116*t121*t71*t96+2.0681212833
     <         347515d+5*t114*t119*t71*t96+2.659013078573252d+5*t112*t11
     =         7*t71*t96-3.323766348216565d+5*t110*t115*t71*t96-4.570178
     >         7287977763d+5*t113*t154*t70*t96-2.3266364437515952d+5*t11
     ?         4*t119*t70*t96+2.9913897133949086d+5*t112*t117*t70*t96+3.
     @         7392371417436354d+5*t110*t115*t70*t96-6.093571638397035d+
     1         5*t111*t200*t69*t96+5.077976365330863d+5*t113*t154*t69*t9
     2         6-3.3237663482165647d+5*t112*t117*t69*t96+4.1547079352707
     3         056d+5*t110*t115*t69*t96-7.921643129916147d+5*t108*t261*t
     4         68*t96+6.702928802236738d+5*t111*t200*t68*t96+5.585774001
     5         863949d+5*t113*t154*t68*t96-4.5701787287977763d+5*t110*t1
     6         15*t68*t96)-9.305257363491002d-1*t104*t132*t96*(4.0513776
     7         643071964d+1*t107*t126*t64*t98-4.0513776643071964d+1*t128
     8         *t63*t98+1.2154132992921589d+2*t124*t127*t63*t98-1.215413
     9         2992921589d+2*t107*t126*t62*t98+2.4308265985843178d+2*t12
     :         2*t125*t62*t98-2.4308265985843178d+2*t124*t127*t61*t98+4.
     ;         0513776643071964d+2*t120*t123*t61*t98-4.051377664307196d+
     <         2*t122*t125*t60*t98+6.077066496460793d+2*t118*t121*t60*t9
     =         8-6.077066496460795d+2*t120*t123*t59*t98+8.50789309504511
     >         3d+2*t116*t119*t59*t98-8.507893095045111d+2*t118*t121*t58
     ?         *t98+1.1343857460060149d+3*t114*t117*t58*t98-1.1343857460
     @         060149d+3*t116*t119*t57*t98+1.4584959591505908d+3*t112*t1
     1         15*t57*t98-1.4584959591505905d+3*t114*t117*t56*t98+1.8231
     2         199489382383d+3*t110*t113*t56*t98+2.2282577153689576d+3*t
     3         111*t154*t55*t98-1.8231199489382383d+3*t112*t115*t55*t98+
     4         2.6739092584427493d+3*t108*t200*t54*t98-2.228257715368958
     5         d+3*t110*t113*t54*t98+9.232684300601569d+2*t126*t64*t96-2
     6         .769805290180471d+3*t107*t124*t64*t96-1.1079221160721883d
     7         +4*t122*t127*t63*t96+1.846536860120314d+3*t126*t63*t96+5.
     8         539610580360942d+3*t107*t124*t63*t96+1.6618831741082832d+
     9         4*t122*t127*t62*t96-2.769805290180471d+3*t126*t62*t96-2.7
     :         69805290180471d+4*t120*t125*t62*t96+8.309415870541416d+3*
     ;         t107*t124*t62*t96+2.2158442321443766d+4*t122*t127*t61*t96
     <         +3.693073720240629d+4*t120*t125*t61*t96-1.107922116072188
     =         3d+4*t107*t124*t61*t96-5.539610580360941d+4*t118*t123*t61
     >         *t96-2.7698052901804704d+4*t122*t127*t60*t96+4.6163421503
     ?         00784d+4*t120*t125*t60*t96+6.924513225451174d+4*t118*t123
     @         *t60*t96-9.694318515631648d+4*t116*t121*t60*t96-5.5396105
     1         80360942d+4*t120*t125*t59*t96+8.309415870541416d+4*t118*t
     2         123*t59*t96+1.1633182218757979d+5*t116*t121*t59*t96-1.551
     3         0909625010638d+5*t114*t119*t59*t96-9.694318515631648d+4*t
     4         118*t123*t58*t96+1.3572045921884307d+5*t116*t121*t58*t96+
     5         1.809606122917908d+5*t114*t119*t58*t96-2.3266364437515955
     6         d+5*t112*t117*t58*t96-1.5510909625010635d+5*t116*t121*t57
     7         *t96+2.0681212833347515d+5*t114*t119*t57*t96+2.6590130785
     8         73252d+5*t112*t117*t57*t96-3.323766348216565d+5*t110*t115
     9         *t57*t96-4.5701787287977763d+5*t113*t154*t56*t96-2.326636
     :         4437515952d+5*t114*t119*t56*t96+2.9913897133949086d+5*t11
     ;         2*t117*t56*t96+3.7392371417436354d+5*t110*t115*t56*t96-6.
     <         093571638397035d+5*t111*t200*t55*t96+5.077976365330863d+5
     =         *t113*t154*t55*t96-3.3237663482165647d+5*t112*t117*t55*t9
     >         6+4.1547079352707056d+5*t110*t115*t55*t96-7.9216431299161
     ?         47d+5*t108*t261*t54*t96+6.702928802236738d+5*t111*t200*t5
     @         4*t96+5.585774001863949d+5*t113*t154*t54*t96-4.5701787287
     1         977763d+5*t110*t115*t54*t96)-9.305257363491002d-1*t104*t9
     2         5*t96*(4.0513776643071964d+1*t107*t126*t48*t98-4.05137766
     3         43071964d+1*t128*t45*t98+1.2154132992921589d+2*t124*t127*
     4         t45*t98-1.2154132992921589d+2*t107*t126*t42*t98+2.4308265
     5         985843178d+2*t122*t125*t42*t98-2.4308265985843178d+2*t124
     6         *t127*t39*t98+4.0513776643071964d+2*t120*t123*t39*t98-4.0
     7         51377664307196d+2*t122*t125*t36*t98+6.077066496460793d+2*
     8         t118*t121*t36*t98-6.077066496460795d+2*t120*t123*t33*t98+
     9         8.507893095045113d+2*t116*t119*t33*t98-8.507893095045111d
     :         +2*t118*t121*t30*t98+1.1343857460060149d+3*t114*t117*t30*
     ;         t98-1.1343857460060149d+3*t116*t119*t27*t98+1.45849595915
     <         05908d+3*t112*t115*t27*t98-1.4584959591505905d+3*t114*t11
     =         7*t24*t98+1.8231199489382383d+3*t110*t113*t24*t98+2.22825
     >         77153689576d+3*t111*t154*t21*t98-1.8231199489382383d+3*t1
     ?         12*t115*t21*t98+2.6739092584427493d+3*t108*t14*t200*t98-2
     @         .228257715368958d+3*t110*t113*t14*t98+9.232684300601569d+
     1         2*t126*t48*t96-2.769805290180471d+3*t107*t124*t48*t96-1.1
     2         079221160721883d+4*t122*t127*t45*t96+1.846536860120314d+3
     3         *t126*t45*t96+5.539610580360942d+3*t107*t124*t45*t96+1.66
     4         18831741082832d+4*t122*t127*t42*t96-2.769805290180471d+3*
     5         t126*t42*t96-2.769805290180471d+4*t120*t125*t42*t96+8.309
     6         415870541416d+3*t107*t124*t42*t96+2.2158442321443766d+4*t
     7         122*t127*t39*t96+3.693073720240629d+4*t120*t125*t39*t96-1
     8         .1079221160721883d+4*t107*t124*t39*t96-5.539610580360941d
     9         +4*t118*t123*t39*t96-2.7698052901804704d+4*t122*t127*t36*
     :         t96+4.616342150300784d+4*t120*t125*t36*t96+6.924513225451
     ;         174d+4*t118*t123*t36*t96-9.694318515631648d+4*t116*t121*t
     <         36*t96-5.539610580360942d+4*t120*t125*t33*t96+8.309415870
     =         541416d+4*t118*t123*t33*t96+1.1633182218757979d+5*t116*t1
     >         21*t33*t96-1.5510909625010638d+5*t114*t119*t33*t96-9.6943
     ?         18515631648d+4*t118*t123*t30*t96+1.3572045921884307d+5*t1
     @         16*t121*t30*t96+1.809606122917908d+5*t114*t119*t30*t96-2.
     1         3266364437515955d+5*t112*t117*t30*t96-1.5510909625010635d
     2         +5*t116*t121*t27*t96+2.0681212833347515d+5*t114*t119*t27*
     3         t96+2.659013078573252d+5*t112*t117*t27*t96-3.323766348216
     4         565d+5*t110*t115*t27*t96-7.921643129916147d+5*t108*t14*t2
     5         61*t96-4.5701787287977763d+5*t113*t154*t24*t96-2.32663644
     6         37515952d+5*t114*t119*t24*t96+2.9913897133949086d+5*t112*
     7         t117*t24*t96+3.7392371417436354d+5*t110*t115*t24*t96-6.09
     8         3571638397035d+5*t111*t200*t21*t96+5.077976365330863d+5*t
     9         113*t154*t21*t96-3.3237663482165647d+5*t112*t117*t21*t96+
     :         4.1547079352707056d+5*t110*t115*t21*t96+6.702928802236738
     ;         d+5*t111*t14*t200*t96+5.585774001863949d+5*t113*t14*t154*
     <         t96-4.5701787287977763d+5*t110*t115*t14*t96)-2.4814019635
     =         976003d+0*t104*t238*t95*t97-2.4814019635976003d+0*t167*t1
     >         74*t95*t97-2.4814019635976003d+0*t104*t132*t239*t97-2.481
     ?         4019635976003d+0*t132*t167*t175*t97-1.8610514726982003d+0
     @         *t167*t238*t95*t96-9.305257363491002d-1*t174*t213*t95*t96
     1         -1.8610514726982003d+0*t132*t167*t239*t96-9.3052573634910
     2         02d-1*t132*t175*t213*t96+t165*(-4.135669939329334d-1*t104
     3         *t174*t95-4.135669939329334d-1*t104*t132*t175)+2*t169*t24
     4         0*t95+t176*t216*t95+t168*(-1.0834770598202839d-2*gammabb*
     5         t131*t134*t241-1.0834770598202839d-2*gammabb*t131*t169*t1
     6         77)+2*t132*t169*t241+t159*t168*(-1.9264558001493193d-2*ga
     7         mmabb*t134*t240-1.9264558001493193d-2*gammabb*t169*t176)+
     8         t160*(1.0082032889066277d-2*gammabb*t104*t131*t239+1.0082
     9         032889066277d-2*gammabb*t131*t167*t175)+t159*t160*(1.7926
     :         167019779404d-2*gammabb*t104*t238+1.7926167019779404d-2*g
     ;         ammabb*t167*t174)+t132*t177*t216+1.9863746096705204d-2*ga
     <         mmabb*t131*t134*t177*t215+3.5318356336070855d-2*gammabb*t
     =         134*t159*t176*t215-2.3079800683637772d-4*t134*t176*t205*t
     >         206*t214-5.316678166471045d-5*t131*t134*t177*t205*t214-5.
     ?         041016444533138d-3*gammabb*t104*t131*t175*t208-8.96308350
     @         9889707d-3*gammabb*t104*t159*t174*t208+2.1476348525932504
     1         d-4*t104*t174*t205*t206*t207+4.947305865786653d-5*t104*t1
     2         31*t175*t205*t207)*wght+Mmat3(iq,D3_RB_RB_TB)
            Mmat3(iq,D3_RA_GAA_TA) = 1.0d+0*(t1*(2.0315194871630324d-3*t
     1         237*t51*t66+2.0315194871630324d-3*t153*t173*t51)+t1*t142*
     2         (3.612104625279974d-3*t236*t66+3.612104625279974d-3*t153*
     3         t172)+1.9937543124266421d-5*gammaaa*t173*t223*t51*t66-5.4
     4         17385299101419d-3*t152*t173*t51*t66+8.654925256364164d-5*
     5         gammaaa*t172*t184*t223*t66-9.632279000746596d-3*t142*t152
     6         *t172*t66+t144*(-1.890381166699927d-3*t12*t235*t51-1.8903
     7         81166699927d-3*t151*t171*t51)-1.855239699669995d-5*gammaa
     8         a*t12*t171*t222*t51+2.520508222266569d-3*t12*t143*t171*t5
     9         1+t142*t144*(-3.361156316208638d-3*t12*t234-3.36115631620
     :         8638d-3*t151*t170)-8.05363069722469d-5*gammaaa*t12*t170*t
     ;         184*t222+4.481541754944851d-3*t12*t142*t143*t170)*wght+Mm
     <         at3(iq,D3_RA_GAA_TA)
            Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
            Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
            Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
            Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
            Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
            Mmat3(iq,D3_RB_GAA_TA) = Mmat3(iq,D3_RB_GAA_TA)
            Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
            Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
            Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
            Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
            Mmat3(iq,D3_RB_GBB_TB) = 1.0d+0*((2.0315194871630324d-3*t131
     1         *t134*t241+2.0315194871630324d-3*t131*t169*t177)*t93+t159
     2         *(3.612104625279974d-3*t134*t240+3.612104625279974d-3*t16
     3         9*t176)*t93+t161*(-1.890381166699927d-3*t104*t131*t239-1.
     4         890381166699927d-3*t131*t167*t175)+t159*t161*(-3.36115631
     5         6208638d-3*t104*t238-3.361156316208638d-3*t167*t174)+8.65
     6         4925256364164d-5*gammabb*t134*t176*t206*t227+1.9937543124
     7         266421d-5*gammabb*t131*t134*t177*t227-8.05363069722469d-5
     8         *gammabb*t104*t174*t206*t226-1.855239699669995d-5*gammabb
     9         *t104*t131*t175*t226-5.417385299101419d-3*t131*t134*t168*
     :         t177-9.632279000746596d-3*t134*t159*t168*t176+2.520508222
     ;         266569d-3*t104*t131*t160*t175+4.481541754944851d-3*t104*t
     <         159*t160*t174)*wght+Mmat3(iq,D3_RB_GBB_TB)
            Mmat3(iq,D3_RA_TA_TA) = 1.0d+0*(-7.476578671599909d-6*t173*t
     1         231*t51*t66-3.245596971136562d-5*t172*t184*t231*t66+6.957
     2         148873762482d-6*t12*t171*t230*t51+3.020111511459258d-5*t1
     3         2*t170*t184*t230)*wght+Mmat3(iq,D3_RA_TA_TA)
            Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
            Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
            Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
            Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
            Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
            Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
            Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
            Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
            Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
            Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
            Mmat3(iq,D3_GAA_GBB_TB) = 1.0d+0*(-3.245596971136562d-5*t134
     1         *t176*t206*t233-7.476578671599909d-6*t131*t134*t177*t233+
     2         3.020111511459258d-5*t104*t174*t206*t232+6.95714887376248
     3         2d-6*t104*t131*t175*t232)*wght+Mmat3(iq,D3_GAA_GBB_TB)
            Mmat3(iq,D3_GAB_GAB_TA) = 1.0d+0*(2.0315194871630324d-3*t1*t
     1         245*t51*t66+3.612104625279974d-3*t1*t142*t244*t66-1.89038
     2         1166699927d-3*t12*t144*t243*t51-3.361156316208638d-3*t12*
     3         t142*t144*t242)*wght+Mmat3(iq,D3_GAB_GAB_TA)
            Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
            Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
            Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
            Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
            Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
            Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
            Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
            Mmat3(iq,D3_GAA_TB_TB) = 1.0d+0*(2.0315194871630324d-3*t131*
     1         t134*t249*t93+3.612104625279974d-3*t134*t159*t248*t93-1.8
     2         90381166699927d-3*t104*t131*t161*t247-3.361156316208638d-
     3         3*t104*t159*t161*t246)*wght+Mmat3(iq,D3_GAA_TB_TB)
            Mmat3(iq,D3_GAB_TA_TA) = 1.0d+0*(t52*t66*(-4.8d+1*t44*t91-4.
     1         8d+1*t17*t41*t91-1.92d+2*t38*t46*t90-9.6d+1*t44*t90-2.88d
     2         +2*t17*t41*t90-8.64d+2*t38*t46*t89-4.8d+1*t44*t89-4.8d+2*
     3         t35*t43*t89-4.32d+2*t17*t41*t89-1.152d+3*t38*t46*t88-1.92
     4         d+3*t35*t43*t88-1.92d+2*t17*t41*t88-9.6d+2*t32*t40*t88-4.
     5         8d+2*t38*t46*t87-2.4d+3*t35*t43*t87-3.6d+3*t32*t40*t87-1.
     6         68d+3*t29*t37*t87-9.6d+2*t35*t43*t86-4.32d+3*t32*t40*t86-
     7         6.048d+3*t29*t37*t86-2.688d+3*t26*t34*t86-1.68d+3*t32*t40
     8         *t85-7.056d+3*t29*t37*t85-9.408d+3*t26*t34*t85-4.032d+3*t
     9         23*t31*t85-2.688d+3*t29*t37*t84-1.0752d+4*t26*t34*t84-1.3
     :         824d+4*t23*t31*t84-5.76d+3*t20*t28*t84-4.032d+3*t26*t34*t
     ;         83-1.5552d+4*t23*t31*t83-1.944d+4*t20*t28*t83-7.92d+3*t13
     <         7*t25*t83-5.76d+3*t23*t31*t82-2.16d+4*t20*t28*t82-2.64d+4
     =         *t137*t25*t82-1.056d+4*t178*t22*t82-7.92d+3*t20*t28*t81-1
     >         .3728d+4*t18*t250*t81-2.904d+4*t137*t25*t81-3.4848d+4*t17
     ?         8*t22*t81)+t3*t66*(-4.8d+1*t44*t78-4.8d+1*t17*t41*t78-1.9
     @         2d+2*t38*t46*t77-9.6d+1*t44*t77-2.88d+2*t17*t41*t77-8.64d
     1         +2*t38*t46*t76-4.8d+1*t44*t76-4.8d+2*t35*t43*t76-4.32d+2*
     2         t17*t41*t76-1.152d+3*t38*t46*t75-1.92d+3*t35*t43*t75-1.92
     3         d+2*t17*t41*t75-9.6d+2*t32*t40*t75-4.8d+2*t38*t46*t74-2.4
     4         d+3*t35*t43*t74-3.6d+3*t32*t40*t74-1.68d+3*t29*t37*t74-9.
     5         6d+2*t35*t43*t73-4.32d+3*t32*t40*t73-6.048d+3*t29*t37*t73
     6         -2.688d+3*t26*t34*t73-1.68d+3*t32*t40*t72-7.056d+3*t29*t3
     7         7*t72-9.408d+3*t26*t34*t72-4.032d+3*t23*t31*t72-2.688d+3*
     8         t29*t37*t71-1.0752d+4*t26*t34*t71-1.3824d+4*t23*t31*t71-5
     9         .76d+3*t20*t28*t71-4.032d+3*t26*t34*t70-1.5552d+4*t23*t31
     :         *t70-1.944d+4*t20*t28*t70-7.92d+3*t137*t25*t70-5.76d+3*t2
     ;         3*t31*t69-2.16d+4*t20*t28*t69-2.64d+4*t137*t25*t69-1.056d
     <         +4*t178*t22*t69-7.92d+3*t20*t28*t68-1.3728d+4*t18*t250*t6
     =         8-2.904d+4*t137*t25*t68-3.4848d+4*t178*t22*t68)-9.3052573
     >         63491002d-1*t12*t4*t52*(-4.8d+1*t44*t64-4.8d+1*t17*t41*t6
     ?         4-1.92d+2*t38*t46*t63-9.6d+1*t44*t63-2.88d+2*t17*t41*t63-
     @         8.64d+2*t38*t46*t62-4.8d+1*t44*t62-4.8d+2*t35*t43*t62-4.3
     1         2d+2*t17*t41*t62-1.152d+3*t38*t46*t61-1.92d+3*t35*t43*t61
     2         -1.92d+2*t17*t41*t61-9.6d+2*t32*t40*t61-4.8d+2*t38*t46*t6
     3         0-2.4d+3*t35*t43*t60-3.6d+3*t32*t40*t60-1.68d+3*t29*t37*t
     4         60-9.6d+2*t35*t43*t59-4.32d+3*t32*t40*t59-6.048d+3*t29*t3
     5         7*t59-2.688d+3*t26*t34*t59-1.68d+3*t32*t40*t58-7.056d+3*t
     6         29*t37*t58-9.408d+3*t26*t34*t58-4.032d+3*t23*t31*t58-2.68
     7         8d+3*t29*t37*t57-1.0752d+4*t26*t34*t57-1.3824d+4*t23*t31*
     8         t57-5.76d+3*t20*t28*t57-4.032d+3*t26*t34*t56-1.5552d+4*t2
     9         3*t31*t56-1.944d+4*t20*t28*t56-7.92d+3*t137*t25*t56-5.76d
     :         +3*t23*t31*t55-2.16d+4*t20*t28*t55-2.64d+4*t137*t25*t55-1
     ;         .056d+4*t178*t22*t55-7.92d+3*t20*t28*t54-1.3728d+4*t18*t2
     <         50*t54-2.904d+4*t137*t25*t54-3.4848d+4*t178*t22*t54)-9.30
     =         5257363491002d-1*t12*t3*t4*(-4.8d+1*t44*t48-4.8d+1*t17*t4
     >         1*t48-1.92d+2*t38*t45*t46-8.64d+2*t38*t42*t46-1.152d+3*t3
     ?         8*t39*t46-4.8d+2*t36*t38*t46-9.6d+1*t44*t45-2.88d+2*t17*t
     @         41*t45-4.8d+1*t42*t44-4.8d+2*t35*t42*t43-1.92d+3*t35*t39*
     1         t43-2.4d+3*t35*t36*t43-9.6d+2*t33*t35*t43-4.32d+2*t17*t41
     2         *t42-1.92d+2*t17*t39*t41-9.6d+2*t32*t39*t40-3.6d+3*t32*t3
     3         6*t40-4.32d+3*t32*t33*t40-1.68d+3*t30*t32*t40-1.68d+3*t29
     4         *t36*t37-6.048d+3*t29*t33*t37-7.056d+3*t29*t30*t37-2.688d
     5         +3*t27*t29*t37-2.688d+3*t26*t33*t34-9.408d+3*t26*t30*t34-
     6         1.0752d+4*t26*t27*t34-4.032d+3*t24*t26*t34-4.032d+3*t23*t
     7         30*t31-1.3824d+4*t23*t27*t31-1.5552d+4*t23*t24*t31-5.76d+
     8         3*t21*t23*t31-5.76d+3*t20*t27*t28-1.944d+4*t20*t24*t28-2.
     9         16d+4*t20*t21*t28-7.92d+3*t14*t20*t28-1.3728d+4*t14*t18*t
     :         250-7.92d+3*t137*t24*t25-2.64d+4*t137*t21*t25-2.904d+4*t1
     ;         37*t14*t25-1.056d+4*t178*t21*t22-3.4848d+4*t14*t178*t22))
     <         *wght+Mmat3(iq,D3_GAB_TA_TA)
            Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
            Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
            Mmat3(iq,D3_GBB_TA_TA) = 1.0d+0*(-9.305257363491002d-1*t104*
     1         (-4.8d+1*t126*t48-4.8d+1*t107*t124*t48-1.92d+2*t122*t127*
     2         t45-9.6d+1*t126*t45-2.88d+2*t107*t124*t45-8.64d+2*t122*t1
     3         27*t42-4.8d+1*t126*t42-4.8d+2*t120*t125*t42-4.32d+2*t107*
     4         t124*t42-1.152d+3*t122*t127*t39-1.92d+3*t120*t125*t39-1.9
     5         2d+2*t107*t124*t39-9.6d+2*t118*t123*t39-4.8d+2*t122*t127*
     6         t36-2.4d+3*t120*t125*t36-3.6d+3*t118*t123*t36-1.68d+3*t11
     7         6*t121*t36-9.6d+2*t120*t125*t33-4.32d+3*t118*t123*t33-6.0
     8         48d+3*t116*t121*t33-2.688d+3*t114*t119*t33-1.68d+3*t118*t
     9         123*t30-7.056d+3*t116*t121*t30-9.408d+3*t114*t119*t30-4.0
     :         32d+3*t112*t117*t30-2.688d+3*t116*t121*t27-1.0752d+4*t114
     ;         *t119*t27-1.3824d+4*t112*t117*t27-5.76d+3*t110*t115*t27-1
     <         .3728d+4*t108*t14*t261-7.92d+3*t113*t154*t24-4.032d+3*t11
     =         4*t119*t24-1.5552d+4*t112*t117*t24-1.944d+4*t110*t115*t24
     >         -1.056d+4*t111*t200*t21-2.64d+4*t113*t154*t21-5.76d+3*t11
     ?         2*t117*t21-2.16d+4*t110*t115*t21-3.4848d+4*t111*t14*t200-
     @         2.904d+4*t113*t14*t154-7.92d+3*t110*t115*t14)*t95*t96-9.3
     1         05257363491002d-1*t104*t132*(-4.8d+1*t126*t64-4.8d+1*t107
     2         *t124*t64-1.92d+2*t122*t127*t63-9.6d+1*t126*t63-2.88d+2*t
     3         107*t124*t63-8.64d+2*t122*t127*t62-4.8d+1*t126*t62-4.8d+2
     4         *t120*t125*t62-4.32d+2*t107*t124*t62-1.152d+3*t122*t127*t
     5         61-1.92d+3*t120*t125*t61-1.92d+2*t107*t124*t61-9.6d+2*t11
     6         8*t123*t61-4.8d+2*t122*t127*t60-2.4d+3*t120*t125*t60-3.6d
     7         +3*t118*t123*t60-1.68d+3*t116*t121*t60-9.6d+2*t120*t125*t
     8         59-4.32d+3*t118*t123*t59-6.048d+3*t116*t121*t59-2.688d+3*
     9         t114*t119*t59-1.68d+3*t118*t123*t58-7.056d+3*t116*t121*t5
     :         8-9.408d+3*t114*t119*t58-4.032d+3*t112*t117*t58-2.688d+3*
     ;         t116*t121*t57-1.0752d+4*t114*t119*t57-1.3824d+4*t112*t117
     <         *t57-5.76d+3*t110*t115*t57-7.92d+3*t113*t154*t56-4.032d+3
     =         *t114*t119*t56-1.5552d+4*t112*t117*t56-1.944d+4*t110*t115
     >         *t56-1.056d+4*t111*t200*t55-2.64d+4*t113*t154*t55-5.76d+3
     ?         *t112*t117*t55-2.16d+4*t110*t115*t55-1.3728d+4*t108*t261*
     @         t54-3.4848d+4*t111*t200*t54-2.904d+4*t113*t154*t54-7.92d+
     1         3*t110*t115*t54)*t96+t134*(-4.8d+1*t126*t78-4.8d+1*t107*t
     2         124*t78-1.92d+2*t122*t127*t77-9.6d+1*t126*t77-2.88d+2*t10
     3         7*t124*t77-8.64d+2*t122*t127*t76-4.8d+1*t126*t76-4.8d+2*t
     4         120*t125*t76-4.32d+2*t107*t124*t76-1.152d+3*t122*t127*t75
     5         -1.92d+3*t120*t125*t75-1.92d+2*t107*t124*t75-9.6d+2*t118*
     6         t123*t75-4.8d+2*t122*t127*t74-2.4d+3*t120*t125*t74-3.6d+3
     7         *t118*t123*t74-1.68d+3*t116*t121*t74-9.6d+2*t120*t125*t73
     8         -4.32d+3*t118*t123*t73-6.048d+3*t116*t121*t73-2.688d+3*t1
     9         14*t119*t73-1.68d+3*t118*t123*t72-7.056d+3*t116*t121*t72-
     :         9.408d+3*t114*t119*t72-4.032d+3*t112*t117*t72-2.688d+3*t1
     ;         16*t121*t71-1.0752d+4*t114*t119*t71-1.3824d+4*t112*t117*t
     <         71-5.76d+3*t110*t115*t71-7.92d+3*t113*t154*t70-4.032d+3*t
     =         114*t119*t70-1.5552d+4*t112*t117*t70-1.944d+4*t110*t115*t
     >         70-1.056d+4*t111*t200*t69-2.64d+4*t113*t154*t69-5.76d+3*t
     ?         112*t117*t69-2.16d+4*t110*t115*t69-1.3728d+4*t108*t261*t6
     @         8-3.4848d+4*t111*t200*t68-2.904d+4*t113*t154*t68-7.92d+3*
     1         t110*t115*t68)*t95+t132*t134*(-4.8d+1*t126*t91-4.8d+1*t10
     2         7*t124*t91-1.92d+2*t122*t127*t90-9.6d+1*t126*t90-2.88d+2*
     3         t107*t124*t90-8.64d+2*t122*t127*t89-4.8d+1*t126*t89-4.8d+
     4         2*t120*t125*t89-4.32d+2*t107*t124*t89-1.152d+3*t122*t127*
     5         t88-1.92d+3*t120*t125*t88-1.92d+2*t107*t124*t88-9.6d+2*t1
     6         18*t123*t88-4.8d+2*t122*t127*t87-2.4d+3*t120*t125*t87-3.6
     7         d+3*t118*t123*t87-1.68d+3*t116*t121*t87-9.6d+2*t120*t125*
     8         t86-4.32d+3*t118*t123*t86-6.048d+3*t116*t121*t86-2.688d+3
     9         *t114*t119*t86-1.68d+3*t118*t123*t85-7.056d+3*t116*t121*t
     :         85-9.408d+3*t114*t119*t85-4.032d+3*t112*t117*t85-2.688d+3
     ;         *t116*t121*t84-1.0752d+4*t114*t119*t84-1.3824d+4*t112*t11
     <         7*t84-5.76d+3*t110*t115*t84-7.92d+3*t113*t154*t83-4.032d+
     =         3*t114*t119*t83-1.5552d+4*t112*t117*t83-1.944d+4*t110*t11
     >         5*t83-1.056d+4*t111*t200*t82-2.64d+4*t113*t154*t82-5.76d+
     ?         3*t112*t117*t82-2.16d+4*t110*t115*t82-1.3728d+4*t108*t261
     @         *t81-3.4848d+4*t111*t200*t81-2.904d+4*t113*t154*t81-7.92d
     1         +3*t110*t115*t81))*wght+Mmat3(iq,D3_GBB_TA_TA)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammaaa*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhoa**1.3333333333333333d+0
            t5 = rhoa**3.333333333333333d-1
            t6 = 1/t5
            t7 = 1/rhoa
            t8 = 1.282782438530422d-1*t6-2.63857249068588d-4*t7
            t9 = rhoa**6.666666666666666d-1
            t10 = exp(-2.4308265985843178d+2*t9)
            t11 = t10*t8+2.63857249068588d-4*t7-1.924173657795633d-1*t6+
     1         3.544907701811032d+0*erf(1.5591108358883013d+1*t5)
            t12 = 1.0d+0-4.275941461768073d-2*t11*t6
            t13 = param(12)
            t14 = rhoa**1.6666666666666669d+0
            t15 = 9.115599744691192d+0*t14
            t16 = t15-2.0d+0*taua
            t17 = t16**11
            t18 = 2.0d+0*taua+t15
            t19 = 1/t18**11
            t20 = param(11)
            t21 = t16**10
            t22 = 1/t18**10
            t23 = param(10)
            t24 = t16**9
            t25 = 1/t18**9
            t26 = param(9)
            t27 = t16**8
            t28 = 1/t18**8
            t29 = param(8)
            t30 = t16**7
            t31 = 1/t18**7
            t32 = param(7)
            t33 = t16**6
            t34 = 1/t18**6
            t35 = param(6)
            t36 = t16**5
            t37 = 1/t18**5
            t38 = param(5)
            t39 = t16**4
            t40 = 1/t18**4
            t41 = param(4)
            t42 = t16**3
            t43 = 1/t18**3
            t44 = param(3)
            t45 = t16**2
            t46 = 1/t18**2
            t47 = param(2)
            t48 = 1/t18
            t49 = t16*t47*t48+t44*t45*t46+t41*t42*t43+t38*t39*t40+t35*t3
     1         6*t37+t32*t33*t34+t29*t30*t31+t26*t27*t28+t23*t24*t25+t20
     2         *t21*t22+t13*t17*t19+param(1)
            t50 = exp(-3.6802889260199856d-3*gammaaa*t1)
            t51 = 5.52d-1*(1.0d+0-t50)+1.0d+0
            t52 = param(24)
            t53 = param(23)
            t54 = param(22)
            t55 = param(21)
            t56 = param(20)
            t57 = param(19)
            t58 = param(18)
            t59 = param(17)
            t60 = param(16)
            t61 = param(15)
            t62 = param(14)
            t63 = t16*t48*t62+t45*t46*t61+t42*t43*t60+t39*t40*t59+t36*t3
     1         7*t58+t33*t34*t57+t30*t31*t56+t27*t28*t55+t24*t25*t54+t21
     2         *t22*t53+t17*t19*t52+param(13)
            t64 = 9.305257363491002d-1*t12*t4-9.305257363491002d-1*t4
            t65 = param(36)
            t66 = param(35)
            t67 = param(34)
            t68 = param(33)
            t69 = param(32)
            t70 = param(31)
            t71 = param(30)
            t72 = param(29)
            t73 = param(28)
            t74 = param(27)
            t75 = param(26)
            t76 = t16*t48*t75+t45*t46*t74+t42*t43*t73+t39*t40*t72+t36*t3
     1         7*t71+t33*t34*t70+t30*t31*t69+t27*t28*t68+t24*t25*t67+t21
     2         *t22*t66+t17*t19*t65+param(25)
            t77 = param(48)
            t78 = param(47)
            t79 = param(46)
            t80 = param(45)
            t81 = param(44)
            t82 = param(43)
            t83 = param(42)
            t84 = param(41)
            t85 = param(40)
            t86 = param(39)
            t87 = param(38)
            t88 = t16*t48*t87+t45*t46*t86+t42*t43*t85+t39*t40*t84+t36*t3
     1         7*t83+t33*t34*t82+t30*t31*t81+t27*t28*t80+t24*t25*t79+t21
     2         *t22*t78+t17*t19*t77+param(37)
            t89 = 1/t18**12
            t90 = -1.6711932865267184d+2*t13*t17*t89*t9+1.51926662411519
     1         86d+1*t47*t48*t9-1.5192666241151986d+1*t16*t46*t47*t9+3.0
     2         38533248230397d+1*t16*t44*t46*t9-3.038533248230397d+1*t43
     3         *t44*t45*t9+4.5577998723455965d+1*t41*t43*t45*t9-4.557799
     4         8723455965d+1*t40*t41*t42*t9+6.077066496460795d+1*t38*t40
     5         *t42*t9-6.077066496460795d+1*t37*t38*t39*t9+7.59633312057
     6         5993d+1*t35*t37*t39*t9-7.596333120575993d+1*t34*t35*t36*t
     7         9+9.115599744691193d+1*t32*t34*t36*t9-9.115599744691193d+
     8         1*t31*t32*t33*t9+1.0634866368806391d+2*t29*t31*t33*t9-1.0
     9         634866368806391d+2*t28*t29*t30*t9+1.2154132992921589d+2*t
     :         26*t28*t30*t9-1.2154132992921589d+2*t25*t26*t27*t9+1.3673
     ;         399617036788d+2*t23*t25*t27*t9-1.3673399617036788d+2*t22*
     <         t23*t24*t9+1.5192666241151986d+2*t20*t22*t24*t9-1.5192666
     =         241151986d+2*t19*t20*t21*t9+1.6711932865267184d+2*t13*t19
     >         *t21*t9
            t91 = -1.6711932865267184d+2*t17*t52*t89*t9+1.51926662411519
     1         86d+1*t48*t62*t9-1.5192666241151986d+1*t16*t46*t62*t9+3.0
     2         38533248230397d+1*t16*t46*t61*t9-3.038533248230397d+1*t43
     3         *t45*t61*t9+4.5577998723455965d+1*t43*t45*t60*t9-4.557799
     4         8723455965d+1*t40*t42*t60*t9+6.077066496460795d+1*t40*t42
     5         *t59*t9-6.077066496460795d+1*t37*t39*t59*t9+7.59633312057
     6         5993d+1*t37*t39*t58*t9-7.596333120575993d+1*t34*t36*t58*t
     7         9+9.115599744691193d+1*t34*t36*t57*t9-9.115599744691193d+
     8         1*t31*t33*t57*t9+1.0634866368806391d+2*t31*t33*t56*t9-1.0
     9         634866368806391d+2*t28*t30*t56*t9+1.2154132992921589d+2*t
     :         28*t30*t55*t9-1.2154132992921589d+2*t25*t27*t55*t9+1.3673
     ;         399617036788d+2*t25*t27*t54*t9-1.3673399617036788d+2*t22*
     <         t24*t54*t9+1.5192666241151986d+2*t22*t24*t53*t9-1.5192666
     =         241151986d+2*t19*t21*t53*t9+1.6711932865267184d+2*t19*t21
     >         *t52*t9
            t92 = -1.6711932865267184d+2*t17*t65*t89*t9+1.51926662411519
     1         86d+1*t48*t75*t9-1.5192666241151986d+1*t16*t46*t75*t9+3.0
     2         38533248230397d+1*t16*t46*t74*t9-3.038533248230397d+1*t43
     3         *t45*t74*t9+4.5577998723455965d+1*t43*t45*t73*t9-4.557799
     4         8723455965d+1*t40*t42*t73*t9+6.077066496460795d+1*t40*t42
     5         *t72*t9-6.077066496460795d+1*t37*t39*t72*t9+7.59633312057
     6         5993d+1*t37*t39*t71*t9-7.596333120575993d+1*t34*t36*t71*t
     7         9+9.115599744691193d+1*t34*t36*t70*t9-9.115599744691193d+
     8         1*t31*t33*t70*t9+1.0634866368806391d+2*t31*t33*t69*t9-1.0
     9         634866368806391d+2*t28*t30*t69*t9+1.2154132992921589d+2*t
     :         28*t30*t68*t9-1.2154132992921589d+2*t25*t27*t68*t9+1.3673
     ;         399617036788d+2*t25*t27*t67*t9-1.3673399617036788d+2*t22*
     <         t24*t67*t9+1.5192666241151986d+2*t22*t24*t66*t9-1.5192666
     =         241151986d+2*t19*t21*t66*t9+1.6711932865267184d+2*t19*t21
     >         *t65*t9
            t93 = -1.6711932865267184d+2*t17*t77*t89*t9+1.51926662411519
     1         86d+1*t48*t87*t9-1.5192666241151986d+1*t16*t46*t87*t9+3.0
     2         38533248230397d+1*t16*t46*t86*t9-3.038533248230397d+1*t43
     3         *t45*t86*t9+4.5577998723455965d+1*t43*t45*t85*t9-4.557799
     4         8723455965d+1*t40*t42*t85*t9+6.077066496460795d+1*t40*t42
     5         *t84*t9-6.077066496460795d+1*t37*t39*t84*t9+7.59633312057
     6         5993d+1*t37*t39*t83*t9-7.596333120575993d+1*t34*t36*t83*t
     7         9+9.115599744691193d+1*t34*t36*t82*t9-9.115599744691193d+
     8         1*t31*t33*t82*t9+1.0634866368806391d+2*t31*t33*t81*t9-1.0
     9         634866368806391d+2*t28*t30*t81*t9+1.2154132992921589d+2*t
     :         28*t30*t80*t9-1.2154132992921589d+2*t25*t27*t80*t9+1.3673
     ;         399617036788d+2*t25*t27*t79*t9-1.3673399617036788d+2*t22*
     <         t24*t79*t9+1.5192666241151986d+2*t22*t24*t78*t9-1.5192666
     =         241151986d+2*t19*t21*t78*t9+1.6711932865267184d+2*t19*t21
     >         *t77*t9
            t94 = 1/t2**2
            t95 = 1/rhoa**2.3333333333333334d+0
            t96 = 1/t4
            t97 = rhoa**2
            t98 = 1/t97
            t99 = 2.63857249068588d-4*t98-4.2759414617680735d-2*t96
            t100 = 5.641895835477563d-1
            t101 = 1/t9
            t102 = t10*t99-2.63857249068588d-4*t98+6.41391219265211d-2*t
     1         96-1.6205510657228786d+2*t10*t6*t8+3.6846026734116505d+1*
     2         t10*t100*t101
            t103 = 1.4253138205893576d-2*t11*t96-4.275941461768073d-2*t1
     1         02*t6
            t104 = 1/rhoa**3.6666666666666664d+0
            t105 = 1.2407009817988002d+0*t12*t5-1.2407009817988002d+0*t5
     1         +9.305257363491002d-1*t103*t4
            t106 = -2.2d+1*t13*t17*t89-2.0d+0*t47*t48-2.0d+0*t16*t46*t47
     1         -4.0d+0*t16*t44*t46-4.0d+0*t43*t44*t45-6.0d+0*t41*t43*t45
     2         -6.0d+0*t40*t41*t42-8.0d+0*t38*t40*t42-8.0d+0*t37*t38*t39
     3         -1.0d+1*t35*t37*t39-1.0d+1*t34*t35*t36-1.2d+1*t32*t34*t36
     4         -1.2d+1*t31*t32*t33-1.4d+1*t29*t31*t33-1.4d+1*t28*t29*t30
     5         -1.6d+1*t26*t28*t30-1.6d+1*t25*t26*t27-1.8d+1*t23*t25*t27
     6         -1.8d+1*t22*t23*t24-2.0d+1*t20*t22*t24-2.0d+1*t19*t20*t21
     7         -2.2d+1*t13*t19*t21
            t107 = -2.2d+1*t17*t52*t89-2.0d+0*t48*t62-2.0d+0*t16*t46*t62
     1         -4.0d+0*t16*t46*t61-4.0d+0*t43*t45*t61-6.0d+0*t43*t45*t60
     2         -6.0d+0*t40*t42*t60-8.0d+0*t40*t42*t59-8.0d+0*t37*t39*t59
     3         -1.0d+1*t37*t39*t58-1.0d+1*t34*t36*t58-1.2d+1*t34*t36*t57
     4         -1.2d+1*t31*t33*t57-1.4d+1*t31*t33*t56-1.4d+1*t28*t30*t56
     5         -1.6d+1*t28*t30*t55-1.6d+1*t25*t27*t55-1.8d+1*t25*t27*t54
     6         -1.8d+1*t22*t24*t54-2.0d+1*t22*t24*t53-2.0d+1*t19*t21*t53
     7         -2.2d+1*t19*t21*t52
            t108 = -2.2d+1*t17*t65*t89-2.0d+0*t48*t75-2.0d+0*t16*t46*t75
     1         -4.0d+0*t16*t46*t74-4.0d+0*t43*t45*t74-6.0d+0*t43*t45*t73
     2         -6.0d+0*t40*t42*t73-8.0d+0*t40*t42*t72-8.0d+0*t37*t39*t72
     3         -1.0d+1*t37*t39*t71-1.0d+1*t34*t36*t71-1.2d+1*t34*t36*t70
     4         -1.2d+1*t31*t33*t70-1.4d+1*t31*t33*t69-1.4d+1*t28*t30*t69
     5         -1.6d+1*t28*t30*t68-1.6d+1*t25*t27*t68-1.8d+1*t25*t27*t67
     6         -1.8d+1*t22*t24*t67-2.0d+1*t22*t24*t66-2.0d+1*t19*t21*t66
     7         -2.2d+1*t19*t21*t65
            t109 = -2.2d+1*t17*t77*t89-2.0d+0*t48*t87-2.0d+0*t16*t46*t87
     1         -4.0d+0*t16*t46*t86-4.0d+0*t43*t45*t86-6.0d+0*t43*t45*t85
     2         -6.0d+0*t40*t42*t85-8.0d+0*t40*t42*t84-8.0d+0*t37*t39*t84
     3         -1.0d+1*t37*t39*t83-1.0d+1*t34*t36*t83-1.2d+1*t34*t36*t82
     4         -1.2d+1*t31*t33*t82-1.4d+1*t31*t33*t81-1.4d+1*t28*t30*t81
     5         -1.6d+1*t28*t30*t80-1.6d+1*t25*t27*t80-1.8d+1*t25*t27*t79
     6         -1.8d+1*t22*t24*t79-2.0d+1*t22*t24*t78-2.0d+1*t19*t21*t78
     7         -2.2d+1*t19*t21*t77
            t110 = 1/t18**13
            t111 = -1.1141288576844789d+2*t13*t17*t6*t89+2.5389881826654
     1         315d+4*t20*t21*t4*t89-5.585774001863949d+4*t13*t21*t4*t89
     2         +1.0128444160767991d+1*t47*t48*t6-1.0128444160767991d+1*t
     3         16*t46*t47*t6+2.0256888321535982d+1*t16*t44*t46*t6-2.0256
     4         888321535982d+1*t43*t44*t45*t6+3.038533248230397d+1*t41*t
     5         43*t45*t6-3.038533248230397d+1*t40*t41*t42*t6+4.051377664
     6         3071964d+1*t38*t40*t42*t6-4.0513776643071964d+1*t37*t38*t
     7         39*t6+5.064222080383994d+1*t35*t37*t39*t6-5.0642220803839
     8         94d+1*t34*t35*t36*t6+6.077066496460795d+1*t32*t34*t36*t6-
     9         6.077066496460795d+1*t31*t32*t33*t6+7.089910912537593d+1*
     :         t29*t31*t33*t6-7.089910912537593d+1*t28*t29*t30*t6+8.1027
     ;         55328614393d+1*t26*t28*t30*t6-8.102755328614393d+1*t25*t2
     <         6*t27*t6+9.115599744691191d+1*t23*t25*t27*t6-9.1155997446
     =         91191d+1*t22*t23*t24*t6+1.012844416076799d+2*t20*t22*t24*
     >         t6-1.012844416076799d+2*t19*t20*t21*t6+1.1141288576844789
     ?         d+2*t13*t19*t21*t6-4.6163421503007845d+2*t4*t46*t47+4.616
     @         3421503007845d+2*t16*t4*t43*t47+4.6163421503007845d+2*t4*
     1         t44*t46+1.3849026450902355d+3*t4*t40*t44*t45-4.1547079352
     2         707067d+3*t4*t40*t41*t45+2.769805290180471d+3*t38*t4*t40*
     3         t45-1.846536860120314d+3*t16*t4*t43*t44+1.384902645090235
     4         5d+3*t16*t4*t41*t43+2.769805290180471d+3*t37*t4*t41*t42-7
     5         .386147440481255d+3*t37*t38*t4*t42+4.616342150300784d+3*t
     6         35*t37*t4*t42+4.616342150300784d+3*t34*t38*t39*t4-1.15408
     7         5537575196d+4*t34*t35*t39*t4+6.924513225451178d+3*t32*t34
     8         *t39*t4+6.924513225451178d+3*t31*t35*t36*t4-1.66188317410
     9         8283d+4*t31*t32*t36*t4+9.694318515631648d+3*t29*t31*t36*t
     :         4+9.694318515631648d+3*t28*t32*t33*t4-2.2620076536473846d
     ;         +4*t28*t29*t33*t4+1.2925758020842196d+4*t26*t28*t33*t4+1.
     <         2925758020842196d+4*t25*t29*t30*t4-2.954458976192502d+4*t
     =         25*t26*t30*t4+1.6618831741082823d+4*t23*t25*t30*t4+1.6618
     >         831741082823d+4*t22*t26*t27*t4-3.7392371417436354d+4*t22*
     ?         t23*t27*t4+2.0773539676353528d+4*t20*t22*t27*t4+2.0773539
     @         676353528d+4*t19*t23*t24*t4-4.616342150300784d+4*t19*t20*
     1         t24*t4+2.5389881826654315d+4*t13*t19*t24*t4+3.04678581919
     2         8518d+4*t110*t13*t17*t4
            t112 = -1.1141288576844789d+2*t17*t52*t6*t89+2.5389881826654
     1         315d+4*t21*t4*t53*t89-5.585774001863949d+4*t21*t4*t52*t89
     2         +1.0128444160767991d+1*t48*t6*t62-1.0128444160767991d+1*t
     3         16*t46*t6*t62-4.6163421503007845d+2*t4*t46*t62+4.61634215
     4         03007845d+2*t16*t4*t43*t62+2.0256888321535982d+1*t16*t46*
     5         t6*t61-2.0256888321535982d+1*t43*t45*t6*t61+4.61634215030
     6         07845d+2*t4*t46*t61+1.3849026450902355d+3*t4*t40*t45*t61-
     7         1.846536860120314d+3*t16*t4*t43*t61+3.038533248230397d+1*
     8         t43*t45*t6*t60-3.038533248230397d+1*t40*t42*t6*t60-4.1547
     9         079352707067d+3*t4*t40*t45*t60+1.3849026450902355d+3*t16*
     :         t4*t43*t60+2.769805290180471d+3*t37*t4*t42*t60+4.05137766
     ;         43071964d+1*t40*t42*t59*t6-4.0513776643071964d+1*t37*t39*
     <         t59*t6+5.064222080383994d+1*t37*t39*t58*t6-5.064222080383
     =         994d+1*t34*t36*t58*t6+6.077066496460795d+1*t34*t36*t57*t6
     >         -6.077066496460795d+1*t31*t33*t57*t6+7.089910912537593d+1
     ?         *t31*t33*t56*t6-7.089910912537593d+1*t28*t30*t56*t6+8.102
     @         755328614393d+1*t28*t30*t55*t6-8.102755328614393d+1*t25*t
     1         27*t55*t6+9.115599744691191d+1*t25*t27*t54*t6-9.115599744
     2         691191d+1*t22*t24*t54*t6+1.012844416076799d+2*t22*t24*t53
     3         *t6-1.012844416076799d+2*t19*t21*t53*t6+1.114128857684478
     4         9d+2*t19*t21*t52*t6+2.769805290180471d+3*t4*t40*t45*t59-7
     5         .386147440481255d+3*t37*t4*t42*t59+4.616342150300784d+3*t
     6         34*t39*t4*t59+4.616342150300784d+3*t37*t4*t42*t58-1.15408
     7         5537575196d+4*t34*t39*t4*t58+6.924513225451178d+3*t31*t36
     8         *t4*t58+6.924513225451178d+3*t34*t39*t4*t57-1.66188317410
     9         8283d+4*t31*t36*t4*t57+9.694318515631648d+3*t28*t33*t4*t5
     :         7+9.694318515631648d+3*t31*t36*t4*t56-2.2620076536473846d
     ;         +4*t28*t33*t4*t56+1.2925758020842196d+4*t25*t30*t4*t56+1.
     <         2925758020842196d+4*t28*t33*t4*t55-2.954458976192502d+4*t
     =         25*t30*t4*t55+1.6618831741082823d+4*t22*t27*t4*t55+1.6618
     >         831741082823d+4*t25*t30*t4*t54-3.7392371417436354d+4*t22*
     ?         t27*t4*t54+2.0773539676353528d+4*t19*t24*t4*t54+2.0773539
     @         676353528d+4*t22*t27*t4*t53-4.616342150300784d+4*t19*t24*
     1         t4*t53+2.5389881826654315d+4*t19*t24*t4*t52+3.04678581919
     2         8518d+4*t110*t17*t4*t52
            t113 = 2.5389881826654315d+4*t21*t4*t66*t89-1.11412885768447
     1         89d+2*t17*t6*t65*t89-5.585774001863949d+4*t21*t4*t65*t89+
     2         1.0128444160767991d+1*t48*t6*t75-1.0128444160767991d+1*t1
     3         6*t46*t6*t75-4.6163421503007845d+2*t4*t46*t75+4.616342150
     4         3007845d+2*t16*t4*t43*t75+2.0256888321535982d+1*t16*t46*t
     5         6*t74-2.0256888321535982d+1*t43*t45*t6*t74+4.616342150300
     6         7845d+2*t4*t46*t74+1.3849026450902355d+3*t4*t40*t45*t74-1
     7         .846536860120314d+3*t16*t4*t43*t74+3.038533248230397d+1*t
     8         43*t45*t6*t73-3.038533248230397d+1*t40*t42*t6*t73-4.15470
     9         79352707067d+3*t4*t40*t45*t73+1.3849026450902355d+3*t16*t
     :         4*t43*t73+2.769805290180471d+3*t37*t4*t42*t73+4.051377664
     ;         3071964d+1*t40*t42*t6*t72-4.0513776643071964d+1*t37*t39*t
     <         6*t72+2.769805290180471d+3*t4*t40*t45*t72-7.3861474404812
     =         55d+3*t37*t4*t42*t72+4.616342150300784d+3*t34*t39*t4*t72+
     >         5.064222080383994d+1*t37*t39*t6*t71-5.064222080383994d+1*
     ?         t34*t36*t6*t71+4.616342150300784d+3*t37*t4*t42*t71-1.1540
     @         85537575196d+4*t34*t39*t4*t71+6.924513225451178d+3*t31*t3
     1         6*t4*t71+6.077066496460795d+1*t34*t36*t6*t70-6.0770664964
     2         60795d+1*t31*t33*t6*t70+6.924513225451178d+3*t34*t39*t4*t
     3         70-1.661883174108283d+4*t31*t36*t4*t70+9.694318515631648d
     4         +3*t28*t33*t4*t70+7.089910912537593d+1*t31*t33*t6*t69-7.0
     5         89910912537593d+1*t28*t30*t6*t69+9.694318515631648d+3*t31
     6         *t36*t4*t69-2.2620076536473846d+4*t28*t33*t4*t69+1.292575
     7         8020842196d+4*t25*t30*t4*t69+8.102755328614393d+1*t28*t30
     8         *t6*t68-8.102755328614393d+1*t25*t27*t6*t68+1.29257580208
     9         42196d+4*t28*t33*t4*t68-2.954458976192502d+4*t25*t30*t4*t
     :         68+1.6618831741082823d+4*t22*t27*t4*t68+9.115599744691191
     ;         d+1*t25*t27*t6*t67-9.115599744691191d+1*t22*t24*t6*t67+1.
     <         6618831741082823d+4*t25*t30*t4*t67-3.7392371417436354d+4*
     =         t22*t27*t4*t67+2.0773539676353528d+4*t19*t24*t4*t67+1.012
     >         844416076799d+2*t22*t24*t6*t66-1.012844416076799d+2*t19*t
     ?         21*t6*t66+2.0773539676353528d+4*t22*t27*t4*t66-4.61634215
     @         0300784d+4*t19*t24*t4*t66+1.1141288576844789d+2*t19*t21*t
     1         6*t65+2.5389881826654315d+4*t19*t24*t4*t65+3.046785819198
     2         518d+4*t110*t17*t4*t65
            t114 = 2.5389881826654315d+4*t21*t4*t78*t89-1.11412885768447
     1         89d+2*t17*t6*t77*t89-5.585774001863949d+4*t21*t4*t77*t89+
     2         1.0128444160767991d+1*t48*t6*t87-1.0128444160767991d+1*t1
     3         6*t46*t6*t87-4.6163421503007845d+2*t4*t46*t87+4.616342150
     4         3007845d+2*t16*t4*t43*t87+2.0256888321535982d+1*t16*t46*t
     5         6*t86-2.0256888321535982d+1*t43*t45*t6*t86+4.616342150300
     6         7845d+2*t4*t46*t86+1.3849026450902355d+3*t4*t40*t45*t86-1
     7         .846536860120314d+3*t16*t4*t43*t86+3.038533248230397d+1*t
     8         43*t45*t6*t85-3.038533248230397d+1*t40*t42*t6*t85-4.15470
     9         79352707067d+3*t4*t40*t45*t85+1.3849026450902355d+3*t16*t
     :         4*t43*t85+2.769805290180471d+3*t37*t4*t42*t85+4.051377664
     ;         3071964d+1*t40*t42*t6*t84-4.0513776643071964d+1*t37*t39*t
     <         6*t84+2.769805290180471d+3*t4*t40*t45*t84-7.3861474404812
     =         55d+3*t37*t4*t42*t84+4.616342150300784d+3*t34*t39*t4*t84+
     >         5.064222080383994d+1*t37*t39*t6*t83-5.064222080383994d+1*
     ?         t34*t36*t6*t83+4.616342150300784d+3*t37*t4*t42*t83-1.1540
     @         85537575196d+4*t34*t39*t4*t83+6.924513225451178d+3*t31*t3
     1         6*t4*t83+6.077066496460795d+1*t34*t36*t6*t82-6.0770664964
     2         60795d+1*t31*t33*t6*t82+6.924513225451178d+3*t34*t39*t4*t
     3         82-1.661883174108283d+4*t31*t36*t4*t82+9.694318515631648d
     4         +3*t28*t33*t4*t82+7.089910912537593d+1*t31*t33*t6*t81-7.0
     5         89910912537593d+1*t28*t30*t6*t81+9.694318515631648d+3*t31
     6         *t36*t4*t81-2.2620076536473846d+4*t28*t33*t4*t81+1.292575
     7         8020842196d+4*t25*t30*t4*t81+8.102755328614393d+1*t28*t30
     8         *t6*t80-8.102755328614393d+1*t25*t27*t6*t80+1.29257580208
     9         42196d+4*t28*t33*t4*t80-2.954458976192502d+4*t25*t30*t4*t
     :         80+1.6618831741082823d+4*t22*t27*t4*t80+9.115599744691191
     ;         d+1*t25*t27*t6*t79-9.115599744691191d+1*t22*t24*t6*t79+1.
     <         6618831741082823d+4*t25*t30*t4*t79-3.7392371417436354d+4*
     =         t22*t27*t4*t79+2.0773539676353528d+4*t19*t24*t4*t79+1.012
     >         844416076799d+2*t22*t24*t6*t78-1.012844416076799d+2*t19*t
     ?         21*t6*t78+2.0773539676353528d+4*t22*t27*t4*t78-4.61634215
     @         0300784d+4*t19*t24*t4*t78+1.1141288576844789d+2*t19*t21*t
     1         6*t77+2.5389881826654315d+4*t19*t24*t4*t77+3.046785819198
     2         518d+4*t110*t17*t4*t77
            t115 = gammaaa**2
            t116 = 1/t2**3
            t117 = 1/rhoa**6
            t118 = 1/rhoa**3.3333333333333337d+0
            t119 = 1/rhoa**3
            t120 = 5.701255282357431d-2*t95-5.27714498137176d-4*t119
            t121 = 1/t14
            t122 = -3.241102131445757d+2*t10*t6*t99+5.401836885742928d+1
     1         *t10*t8*t96-8.551882923536147d-2*t95+2.626185756615557d+4
     2         *t10*t101*t8-5.971086789162617d+3*t10*t100*t7-2.456401782
     3         2744336d+1*t10*t100*t121+t10*t120+5.27714498137176d-4*t11
     4         9
            t123 = 2.850627641178715d-2*t102*t96-1.9004184274524766d-2*t
     1         11*t95-4.275941461768073d-2*t122*t6
            t124 = 1/rhoa**7.333333333333333d+0
            t125 = 1/rhoa**4.666666666666667d+0
            t126 = 2.4814019635976003d+0*t103*t5+9.305257363491002d-1*t1
     1         23*t4+4.135669939329334d-1*t101*t12-4.135669939329334d-1*
     2         t101
            t127 = 1.7926167019779404d-2*gammaaa*t12*t90+1.7926167019779
     1         404d-2*gammaaa*t103*t49
            t128 = -4.135669939329334d-1*t12*t51*t63-4.135669939329334d-
     1         1*t12*t3*t49
            t129 = 1.0082032889066277d-2*gammaaa*t12*t50*t91+1.008203288
     1         9066277d-2*gammaaa*t103*t50*t63
            t130 = -1.9264558001493193d-2*gammaaa*t64*t92-1.926455800149
     1         3193d-2*gammaaa*t105*t76
            t131 = -1.0834770598202839d-2*gammaaa*t50*t64*t93-1.08347705
     1         98202839d-2*gammaaa*t105*t50*t88
            t132 = 1/rhoa**5
            t133 = 1/rhoa**6.333333333333333d+0
            t134 = -3.361156316208638d-3*t12*t90-3.361156316208638d-3*t1
     1         03*t49
            t135 = 3.612104625279974d-3*t64*t92+3.612104625279974d-3*t10
     1         5*t76
            t136 = 1/rhoa**4
            t137 = 1/rhoa**5.333333333333333d+0
            t138 = 3.342386573053437d+3*t20*t21*t89*t9+6.077066496460795
     1         d+1*t16*t43*t47*t9-6.077066496460795d+1*t44*t46*t9+1.8231
     2         199489382385d+2*t40*t44*t45*t9-3.646239897876477d+2*t38*t
     3         40*t45*t9-1.8231199489382385d+2*t16*t41*t43*t9+3.64623989
     4         7876477d+2*t37*t41*t42*t9-6.077066496460795d+2*t35*t37*t4
     5         2*t9+6.077066496460795d+2*t34*t38*t39*t9-9.11559974469119
     6         2d+2*t32*t34*t39*t9+9.115599744691192d+2*t31*t35*t36*t9-1
     7         .276183964256767d+3*t29*t31*t36*t9+1.276183964256767d+3*t
     8         28*t32*t33*t9-1.7015786190090226d+3*t26*t28*t33*t9+1.7015
     9         786190090226d+3*t25*t29*t30*t9-2.187743938725886d+3*t23*t
     :         25*t30*t9+2.187743938725886d+3*t22*t26*t27*t9-2.734679923
     ;         407357d+3*t20*t22*t27*t9+2.734679923407357d+3*t19*t23*t24
     <         *t9-3.342386573053437d+3*t13*t19*t24*t9+4.010863887664124
     =         5d+3*t110*t13*t17*t9
            t139 = 3.342386573053437d+3*t21*t53*t89*t9+6.077066496460795
     1         d+1*t16*t43*t62*t9-6.077066496460795d+1*t46*t61*t9+1.8231
     2         199489382385d+2*t40*t45*t61*t9-1.8231199489382385d+2*t16*
     3         t43*t60*t9+3.646239897876477d+2*t37*t42*t60*t9-3.64623989
     4         7876477d+2*t40*t45*t59*t9+6.077066496460795d+2*t34*t39*t5
     5         9*t9-6.077066496460795d+2*t37*t42*t58*t9+9.11559974469119
     6         2d+2*t31*t36*t58*t9-9.115599744691192d+2*t34*t39*t57*t9+1
     7         .276183964256767d+3*t28*t33*t57*t9-1.276183964256767d+3*t
     8         31*t36*t56*t9+1.7015786190090226d+3*t25*t30*t56*t9-1.7015
     9         786190090226d+3*t28*t33*t55*t9+2.187743938725886d+3*t22*t
     :         27*t55*t9-2.187743938725886d+3*t25*t30*t54*t9+2.734679923
     ;         407357d+3*t19*t24*t54*t9-2.734679923407357d+3*t22*t27*t53
     <         *t9-3.342386573053437d+3*t19*t24*t52*t9+4.010863887664124
     =         5d+3*t110*t17*t52*t9
            t140 = 3.342386573053437d+3*t21*t66*t89*t9+6.077066496460795
     1         d+1*t16*t43*t75*t9-6.077066496460795d+1*t46*t74*t9+1.8231
     2         199489382385d+2*t40*t45*t74*t9-1.8231199489382385d+2*t16*
     3         t43*t73*t9+3.646239897876477d+2*t37*t42*t73*t9-3.64623989
     4         7876477d+2*t40*t45*t72*t9+6.077066496460795d+2*t34*t39*t7
     5         2*t9-6.077066496460795d+2*t37*t42*t71*t9+9.11559974469119
     6         2d+2*t31*t36*t71*t9-9.115599744691192d+2*t34*t39*t70*t9+1
     7         .276183964256767d+3*t28*t33*t70*t9-1.276183964256767d+3*t
     8         31*t36*t69*t9+1.7015786190090226d+3*t25*t30*t69*t9-1.7015
     9         786190090226d+3*t28*t33*t68*t9+2.187743938725886d+3*t22*t
     :         27*t68*t9-2.187743938725886d+3*t25*t30*t67*t9+2.734679923
     ;         407357d+3*t19*t24*t67*t9-2.734679923407357d+3*t22*t27*t66
     <         *t9-3.342386573053437d+3*t19*t24*t65*t9+4.010863887664124
     =         5d+3*t110*t17*t65*t9
            t141 = 3.342386573053437d+3*t21*t78*t89*t9+6.077066496460795
     1         d+1*t16*t43*t87*t9-6.077066496460795d+1*t46*t86*t9+1.8231
     2         199489382385d+2*t40*t45*t86*t9-1.8231199489382385d+2*t16*
     3         t43*t85*t9+3.646239897876477d+2*t37*t42*t85*t9-3.64623989
     4         7876477d+2*t40*t45*t84*t9+6.077066496460795d+2*t34*t39*t8
     5         4*t9-6.077066496460795d+2*t37*t42*t83*t9+9.11559974469119
     6         2d+2*t31*t36*t83*t9-9.115599744691192d+2*t34*t39*t82*t9+1
     7         .276183964256767d+3*t28*t33*t82*t9-1.276183964256767d+3*t
     8         31*t36*t81*t9+1.7015786190090226d+3*t25*t30*t81*t9-1.7015
     9         786190090226d+3*t28*t33*t80*t9+2.187743938725886d+3*t22*t
     :         27*t80*t9-2.187743938725886d+3*t25*t30*t79*t9+2.734679923
     ;         407357d+3*t19*t24*t79*t9-2.734679923407357d+3*t22*t27*t78
     <         *t9-3.342386573053437d+3*t19*t24*t77*t9+4.010863887664124
     =         5d+3*t110*t17*t77*t9
            t142 = 4.4d+2*t20*t21*t89+9.68d+2*t13*t21*t89+8.0d+0*t46*t47
     1         +8.0d+0*t16*t43*t47+8.0d+0*t44*t46+2.4d+1*t40*t44*t45+7.2
     2         d+1*t40*t41*t45+4.8d+1*t38*t40*t45+3.2d+1*t16*t43*t44+2.4
     3         d+1*t16*t41*t43+4.8d+1*t37*t41*t42+1.28d+2*t37*t38*t42+8.
     4         0d+1*t35*t37*t42+8.0d+1*t34*t38*t39+2.0d+2*t34*t35*t39+1.
     5         2d+2*t32*t34*t39+1.2d+2*t31*t35*t36+2.88d+2*t31*t32*t36+1
     6         .68d+2*t29*t31*t36+1.68d+2*t28*t32*t33+3.92d+2*t28*t29*t3
     7         3+2.24d+2*t26*t28*t33+2.24d+2*t25*t29*t30+5.12d+2*t25*t26
     8         *t30+2.88d+2*t23*t25*t30+2.88d+2*t22*t26*t27+6.48d+2*t22*
     9         t23*t27+3.6d+2*t20*t22*t27+3.6d+2*t19*t23*t24+8.0d+2*t19*
     :         t20*t24+4.4d+2*t13*t19*t24+5.28d+2*t110*t13*t17
            t143 = 4.4d+2*t21*t53*t89+9.68d+2*t21*t52*t89+8.0d+0*t46*t62
     1         +8.0d+0*t16*t43*t62+8.0d+0*t46*t61+2.4d+1*t40*t45*t61+3.2
     2         d+1*t16*t43*t61+7.2d+1*t40*t45*t60+2.4d+1*t16*t43*t60+4.8
     3         d+1*t37*t42*t60+4.8d+1*t40*t45*t59+1.28d+2*t37*t42*t59+8.
     4         0d+1*t34*t39*t59+8.0d+1*t37*t42*t58+2.0d+2*t34*t39*t58+1.
     5         2d+2*t31*t36*t58+1.2d+2*t34*t39*t57+2.88d+2*t31*t36*t57+1
     6         .68d+2*t28*t33*t57+1.68d+2*t31*t36*t56+3.92d+2*t28*t33*t5
     7         6+2.24d+2*t25*t30*t56+2.24d+2*t28*t33*t55+5.12d+2*t25*t30
     8         *t55+2.88d+2*t22*t27*t55+2.88d+2*t25*t30*t54+6.48d+2*t22*
     9         t27*t54+3.6d+2*t19*t24*t54+3.6d+2*t22*t27*t53+8.0d+2*t19*
     :         t24*t53+4.4d+2*t19*t24*t52+5.28d+2*t110*t17*t52
            t144 = 4.4d+2*t21*t66*t89+9.68d+2*t21*t65*t89+8.0d+0*t46*t75
     1         +8.0d+0*t16*t43*t75+8.0d+0*t46*t74+2.4d+1*t40*t45*t74+3.2
     2         d+1*t16*t43*t74+7.2d+1*t40*t45*t73+2.4d+1*t16*t43*t73+4.8
     3         d+1*t37*t42*t73+4.8d+1*t40*t45*t72+1.28d+2*t37*t42*t72+8.
     4         0d+1*t34*t39*t72+8.0d+1*t37*t42*t71+2.0d+2*t34*t39*t71+1.
     5         2d+2*t31*t36*t71+1.2d+2*t34*t39*t70+2.88d+2*t31*t36*t70+1
     6         .68d+2*t28*t33*t70+1.68d+2*t31*t36*t69+3.92d+2*t28*t33*t6
     7         9+2.24d+2*t25*t30*t69+2.24d+2*t28*t33*t68+5.12d+2*t25*t30
     8         *t68+2.88d+2*t22*t27*t68+2.88d+2*t25*t30*t67+6.48d+2*t22*
     9         t27*t67+3.6d+2*t19*t24*t67+3.6d+2*t22*t27*t66+8.0d+2*t19*
     :         t24*t66+4.4d+2*t19*t24*t65+5.28d+2*t110*t17*t65
            t145 = 4.4d+2*t21*t78*t89+9.68d+2*t21*t77*t89+8.0d+0*t46*t87
     1         +8.0d+0*t16*t43*t87+8.0d+0*t46*t86+2.4d+1*t40*t45*t86+3.2
     2         d+1*t16*t43*t86+7.2d+1*t40*t45*t85+2.4d+1*t16*t43*t85+4.8
     3         d+1*t37*t42*t85+4.8d+1*t40*t45*t84+1.28d+2*t37*t42*t84+8.
     4         0d+1*t34*t39*t84+8.0d+1*t37*t42*t83+2.0d+2*t34*t39*t83+1.
     5         2d+2*t31*t36*t83+1.2d+2*t34*t39*t82+2.88d+2*t31*t36*t82+1
     6         .68d+2*t28*t33*t82+1.68d+2*t31*t36*t81+3.92d+2*t28*t33*t8
     7         1+2.24d+2*t25*t30*t81+2.24d+2*t28*t33*t80+5.12d+2*t25*t30
     8         *t80+2.88d+2*t22*t27*t80+2.88d+2*t25*t30*t79+6.48d+2*t22*
     9         t27*t79+3.6d+2*t19*t24*t79+3.6d+2*t22*t27*t78+8.0d+2*t19*
     :         t24*t78+4.4d+2*t19*t24*t77+5.28d+2*t110*t17*t77
            t146 = 1/t18**14
            t147 = gammaaa**3
            t148 = 1/t2**4
            t149 = 1/rhoa**9.666666666666666d+0
            t150 = 1/rhoa**7
            t151 = 1/rhoa**4.333333333333333d+0
            t152 = -4.275941461768073d-2*t6*(1.6205510657228786d+2*t10*t
     1         96*t99+7.878557269846671d+4*t10*t101*t99+9.95181131527102
     2         9d+3*t10*t100*t98+9.676451059701281d+5*t10*t100*t96-7.202
     3         44918099057d+1*t10*t8*t95-4.255868126669586d+6*t10*t7*t8-
     4         2.626185756615557d+4*t10*t121*t8-4.8616531971686355d+2*t1
     5         0*t120*t6-1.5831434944115283d-3*t136+t10*(1.5831434944115
     6         283d-3*t136-1.330292899216734d-1*t118)+1.995439348825101d
     7         -1*t118+4.0940029704573894d+1*t1*t10*t100)+4.275941461768
     8         0724d-2*t122*t96-5.701255282357429d-2*t102*t95+4.43430966
     9         4055779d-2*t11*t118
            t153 = 1/rhoa**11
            t154 = 1/rhoa**8.333333333333334d+0
            t155 = 1/rhoa**5.666666666666667d+0
            t156 = 3.7221029453964005d+0*t123*t5+9.305257363491002d-1*t1
     1         52*t4-2.7571132928862224d-1*t12*t121+2.7571132928862224d-
     2         1*t121+1.2407009817988002d+0*t101*t103
            t157 = 1/rhoa**8.666666666666666d+0
            t158 = 1/rhoa**10
            t159 = 1/rhoa**7.666666666666667d+0
            t160 = 1/rhoa**9
            t161 = 1/rhoa**6.666666666666667d+0
            t162 = 1/rhoa**8
            fnc(iq) = 1.0d+0*(t51*t64*t88+t3*t64*t76-9.305257363491002d-
     1         1*t12*t4*t51*t63-9.305257363491002d-1*t12*t3*t4*t49)*wght
     2         +fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(8.963083509889702d-3*gammaaa*t12*t4
     1         9*t94*t95+5.041016444533138d-3*gammaaa*t12*t50*t63*t95-9.
     2         632279000746596d-3*gammaaa*t104*t64*t76*t94+t51*t64*t93+t
     3         3*t64*t92-9.305257363491002d-1*t12*t4*t51*t91-9.305257363
     4         491002d-1*t12*t3*t4*t90-5.417385299101419d-3*gammaaa*t104
     5         *t50*t64*t88+t105*t51*t88+t105*t3*t76-1.2407009817988002d
     6         +0*t12*t5*t51*t63-9.305257363491002d-1*t103*t4*t51*t63-1.
     7         2407009817988002d+0*t12*t3*t49*t5-9.305257363491002d-1*t1
     8         03*t3*t4*t49)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*(-3.361156316208638d-3*t12*t49*t94*
     1         t96-1.890381166699927d-3*t12*t50*t63*t96+3.61210462527997
     2         4d-3*t1*t64*t76*t94+2.0315194871630324d-3*t1*t50*t64*t88)
     3         *wght+Cmat(iq,D1_GAA)
            Mmat(iq,D1_TA) = 1.0d+0*(t109*t51*t64+t108*t3*t64-9.30525736
     1         3491002d-1*t107*t12*t4*t51-9.305257363491002d-1*t106*t12*
     2         t3*t4)*wght+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(t127*t94*t95+t129*t95+3.5318356
     1         336070855d-2*gammaaa*t125*t64*t76*t94-8.963083509889707d-
     2         3*gammaaa*t118*t12*t49*t94+t104*t130*t94+2*t105*t51*t93+2
     3         *t105*t3*t92-2.4814019635976003d+0*t12*t5*t51*t91-1.86105
     4         14726982003d+0*t103*t4*t51*t91-2.4814019635976003d+0*t12*
     5         t3*t5*t90-1.8610514726982003d+0*t103*t3*t4*t90+1.98637460
     6         96705204d-2*gammaaa*t125*t50*t64*t88-5.316678166471045d-5
     7         *t115*t124*t50*t64*t88+t126*t51*t88-2.3079800683637772d-4
     8         *t115*t116*t124*t64*t76+t126*t3*t76+t114*t51*t64+t113*t3*
     9         t64-2.4814019635976003d+0*t103*t5*t51*t63-9.3052573634910
     :         02d-1*t123*t4*t51*t63-5.041016444533138d-3*gammaaa*t118*t
     ;         12*t50*t63+4.947305865786653d-5*t115*t117*t12*t50*t63-9.3
     <         05257363491002d-1*t112*t12*t4*t51-2.4814019635976003d+0*t
     =         103*t3*t49*t5-9.305257363491002d-1*t123*t3*t4*t49+2.14763
     >         48525932504d-4*t115*t116*t117*t12*t49-9.305257363491002d-
     ?         1*t111*t12*t3*t4+t104*t131+t101*t128)*wght+Amat2(iq,D2_RA
     @         _RA)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(t134*t94*t96+(-1.8903811666999
     1         27d-3*t12*t50*t91-1.890381166699927d-3*t103*t50*t63)*t96+
     2         4.481541754944851d-3*t12*t49*t94*t95+2.520508222266569d-3
     3         *t12*t50*t63*t95-9.632279000746596d-3*t104*t64*t76*t94+t1
     4         *t135*t94+t1*(2.0315194871630324d-3*t50*t64*t93+2.0315194
     5         871630324d-3*t105*t50*t88)+1.9937543124266421d-5*gammaaa*
     6         t133*t50*t64*t88-5.417385299101419d-3*t104*t50*t64*t88+8.
     7         654925256364164d-5*gammaaa*t116*t133*t64*t76-1.8552396996
     8         69995d-5*gammaaa*t12*t132*t50*t63-8.05363069722469d-5*gam
     9         maaa*t116*t12*t132*t49)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*(-7.476578671599909d-6*t137*t5
     1         0*t64*t88-3.245596971136562d-5*t116*t137*t64*t76+6.957148
     2         873762482d-6*t12*t136*t50*t63+3.020111511459258d-5*t116*t
     3         12*t136*t49)*wght+Cmat2(iq,D2_GAA_GAA)
            Mmat2(iq,D2_RA_TA) = 1.0d+0*(8.963083509889702d-3*gammaaa*t1
     1         06*t12*t94*t95+5.041016444533138d-3*gammaaa*t107*t12*t50*
     2         t95-9.632279000746596d-3*gammaaa*t104*t108*t64*t94+t141*t
     3         51*t64-5.417385299101419d-3*gammaaa*t104*t109*t50*t64+t14
     4         0*t3*t64-1.2407009817988002d+0*t107*t12*t5*t51-9.30525736
     5         3491002d-1*t12*t139*t4*t51-9.305257363491002d-1*t103*t107
     6         *t4*t51+t105*t109*t51-1.2407009817988002d+0*t106*t12*t3*t
     7         5-9.305257363491002d-1*t12*t138*t3*t4-9.305257363491002d-
     8         1*t103*t106*t3*t4+t105*t108*t3)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = 1.0d+0*(-3.361156316208638d-3*t106*t12
     1         *t94*t96-1.890381166699927d-3*t107*t12*t50*t96+3.61210462
     2         5279974d-3*t1*t108*t64*t94+2.0315194871630324d-3*t1*t109*
     3         t50*t64)*wght+Mmat2(iq,D2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_TA_TA) = 1.0d+0*(t145*t51*t64+t144*t3*t64-9.3052
     1         57363491002d-1*t12*t143*t4*t51-9.305257363491002d-1*t12*t
     2         142*t3*t4)*wght+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*(t51*t64*(-3.4716600044518436
     1         d+6*t24*t79*t89*t97+1.1572200014839477d+7*t24*t78*t89*t97
     2         -1.2729420016323426d+7*t24*t77*t89*t97+2.104036366334451d
     3         +4*t43*t87*t97-2.104036366334451d+4*t16*t40*t87*t97-8.416
     4         145465337804d+4*t37*t45*t86*t97-4.208072732668902d+4*t43*
     5         t86*t97+1.2624218198006704d+5*t16*t40*t86*t97+3.787265459
     6         402013d+5*t37*t45*t85*t97+2.104036366334451d+4*t43*t85*t9
     7         7-2.104036366334451d+5*t34*t42*t85*t97-1.8936327297010064
     8         d+5*t16*t40*t85*t97-5.049687279202681d+5*t37*t45*t84*t97+
     9         8.416145465337803d+5*t34*t42*t84*t97+8.416145465337804d+4
     :         *t16*t40*t84*t97-4.2080727326689016d+5*t31*t39*t84*t97+2.
     ;         1040363663344508d+5*t37*t45*t83*t97-1.0520181831672254d+6
     <         *t34*t42*t83*t97+1.578027274750838d+6*t31*t39*t83*t97-7.3
     =         64127282170578d+5*t28*t36*t83*t97+4.208072732668902d+5*t3
     >         4*t42*t82*t97-1.893632729701006d+6*t31*t39*t82*t97+2.6510
     ?         858215814087d+6*t28*t36*t82*t97-1.1782603651472927d+6*t25
     @         *t33*t82*t97+7.364127282170578d+5*t31*t39*t81*t97-3.09293
     1         34585116436d+6*t28*t36*t81*t97+4.123911278015524d+6*t25*t
     2         33*t81*t97-1.7673905477209387d+6*t22*t30*t81*t97+1.178260
     3         3651472927d+6*t28*t36*t80*t97-4.713041460589171d+6*t25*t3
     4         3*t80*t97+6.059624735043219d+6*t22*t30*t80*t97-2.52484363
     5         9601341d+6*t19*t27*t80*t97+1.767390547720939d+6*t25*t33*t
     6         79*t97-6.817077826923622d+6*t22*t30*t79*t97+8.52134728365
     7         4526d+6*t19*t27*t79*t97+2.524843639601341d+6*t22*t30*t78*
     8         t97-9.468163648505028d+6*t19*t27*t78*t97-4.62888000593579
     9         2d+6*t110*t21*t78*t97+3.4716600044518436d+6*t19*t27*t77*t
     :         97+1.5275304019588112d+7*t110*t21*t77*t97-6.0175440077165
     ;         3d+6*t146*t17*t77*t97+3.713762858948263d+1*t17*t77*t89*t9
     <         6-3.37614805358933d+0*t48*t87*t96+3.37614805358933d+0*t16
     =         *t46*t87*t96-6.75229610717866d+0*t16*t46*t86*t96+6.752296
     >         10717866d+0*t43*t45*t86*t96-1.0128444160767991d+1*t43*t45
     ?         *t85*t96+1.0128444160767991d+1*t40*t42*t85*t96-1.35045922
     @         1435732d+1*t40*t42*t84*t96+1.350459221435732d+1*t37*t39*t
     1         84*t96-1.6880740267946648d+1*t37*t39*t83*t96+1.6880740267
     2         946648d+1*t34*t36*t83*t96-2.0256888321535982d+1*t34*t36*t
     3         82*t96+2.0256888321535982d+1*t31*t33*t82*t96-2.3633036375
     4         125308d+1*t31*t33*t81*t96+2.3633036375125308d+1*t28*t30*t
     5         81*t96-2.700918442871464d+1*t28*t30*t80*t96+2.70091844287
     6         1464d+1*t25*t27*t80*t96-3.0385332482303967d+1*t25*t27*t79
     7         *t96+3.0385332482303967d+1*t22*t24*t79*t96-3.376148053589
     8         3296d+1*t22*t24*t78*t96+3.3761480535893296d+1*t19*t21*t78
     9         *t96-3.713762858948263d+1*t19*t21*t77*t96+5.0779763653308
     :         62d+4*t21*t5*t78*t89-1.1171548003727898d+5*t21*t5*t77*t89
     ;         -9.232684300601568d+2*t46*t5*t87+9.232684300601568d+2*t16
     <         *t43*t5*t87+9.232684300601568d+2*t46*t5*t86+2.76980529018
     =         0471d+3*t40*t45*t5*t86-3.693073720240627d+3*t16*t43*t5*t8
     >         6-8.309415870541413d+3*t40*t45*t5*t85+2.769805290180471d+
     ?         3*t16*t43*t5*t85+5.539610580360942d+3*t37*t42*t5*t85+5.53
     @         9610580360942d+3*t40*t45*t5*t84-1.4772294880962508d+4*t37
     1         *t42*t5*t84+9.232684300601568d+3*t34*t39*t5*t84+9.2326843
     2         00601568d+3*t37*t42*t5*t83-2.308171075150392d+4*t34*t39*t
     3         5*t83+1.3849026450902355d+4*t31*t36*t5*t83+1.384902645090
     4         2355d+4*t34*t39*t5*t82-3.323766348216566d+4*t31*t36*t5*t8
     5         2+1.9388637031263292d+4*t28*t33*t5*t82+1.9388637031263292
     6         d+4*t31*t36*t5*t81-4.5240153072947686d+4*t28*t33*t5*t81+2
     7         .585151604168439d+4*t25*t30*t5*t81+2.585151604168439d+4*t
     8         28*t33*t5*t80-5.908917952385003d+4*t25*t30*t5*t80+3.32376
     9         63482165647d+4*t22*t27*t5*t80+3.3237663482165647d+4*t25*t
     :         30*t5*t79-7.478474283487271d+4*t22*t27*t5*t79+4.154707935
     ;         2707056d+4*t19*t24*t5*t79+4.154707935270705d+4*t22*t27*t5
     <         *t78-9.232684300601568d+4*t19*t24*t5*t78+5.07797636533086
     =         3d+4*t19*t24*t5*t77+6.093571638397036d+4*t110*t17*t5*t77)
     >         +t3*t64*(-3.4716600044518436d+6*t24*t67*t89*t97+1.1572200
     ?         014839477d+7*t24*t66*t89*t97-1.2729420016323426d+7*t24*t6
     @         5*t89*t97+2.104036366334451d+4*t43*t75*t97-2.104036366334
     1         451d+4*t16*t40*t75*t97-8.416145465337804d+4*t37*t45*t74*t
     2         97-4.208072732668902d+4*t43*t74*t97+1.2624218198006704d+5
     3         *t16*t40*t74*t97+3.787265459402013d+5*t37*t45*t73*t97+2.1
     4         04036366334451d+4*t43*t73*t97-2.104036366334451d+5*t34*t4
     5         2*t73*t97-1.8936327297010064d+5*t16*t40*t73*t97-5.0496872
     6         79202681d+5*t37*t45*t72*t97+8.416145465337803d+5*t34*t42*
     7         t72*t97+8.416145465337804d+4*t16*t40*t72*t97-4.2080727326
     8         689016d+5*t31*t39*t72*t97+2.1040363663344508d+5*t37*t45*t
     9         71*t97-1.0520181831672254d+6*t34*t42*t71*t97+1.5780272747
     :         50838d+6*t31*t39*t71*t97-7.364127282170578d+5*t28*t36*t71
     ;         *t97+4.208072732668902d+5*t34*t42*t70*t97-1.8936327297010
     <         06d+6*t31*t39*t70*t97+2.6510858215814087d+6*t28*t36*t70*t
     =         97-1.1782603651472927d+6*t25*t33*t70*t97+7.36412728217057
     >         8d+5*t31*t39*t69*t97-3.0929334585116436d+6*t28*t36*t69*t9
     ?         7+4.123911278015524d+6*t25*t33*t69*t97-1.7673905477209387
     @         d+6*t22*t30*t69*t97+1.1782603651472927d+6*t28*t36*t68*t97
     1         -4.713041460589171d+6*t25*t33*t68*t97+6.059624735043219d+
     2         6*t22*t30*t68*t97-2.524843639601341d+6*t19*t27*t68*t97+1.
     3         767390547720939d+6*t25*t33*t67*t97-6.817077826923622d+6*t
     4         22*t30*t67*t97+8.521347283654526d+6*t19*t27*t67*t97+2.524
     5         843639601341d+6*t22*t30*t66*t97-9.468163648505028d+6*t19*
     6         t27*t66*t97-4.628880005935792d+6*t110*t21*t66*t97+3.47166
     7         00044518436d+6*t19*t27*t65*t97+1.5275304019588112d+7*t110
     8         *t21*t65*t97-6.01754400771653d+6*t146*t17*t65*t97+3.71376
     9         2858948263d+1*t17*t65*t89*t96-3.37614805358933d+0*t48*t75
     :         *t96+3.37614805358933d+0*t16*t46*t75*t96-6.75229610717866
     ;         d+0*t16*t46*t74*t96+6.75229610717866d+0*t43*t45*t74*t96-1
     <         .0128444160767991d+1*t43*t45*t73*t96+1.0128444160767991d+
     =         1*t40*t42*t73*t96-1.350459221435732d+1*t40*t42*t72*t96+1.
     >         350459221435732d+1*t37*t39*t72*t96-1.6880740267946648d+1*
     ?         t37*t39*t71*t96+1.6880740267946648d+1*t34*t36*t71*t96-2.0
     @         256888321535982d+1*t34*t36*t70*t96+2.0256888321535982d+1*
     1         t31*t33*t70*t96-2.3633036375125308d+1*t31*t33*t69*t96+2.3
     2         633036375125308d+1*t28*t30*t69*t96-2.700918442871464d+1*t
     3         28*t30*t68*t96+2.700918442871464d+1*t25*t27*t68*t96-3.038
     4         5332482303967d+1*t25*t27*t67*t96+3.0385332482303967d+1*t2
     5         2*t24*t67*t96-3.3761480535893296d+1*t22*t24*t66*t96+3.376
     6         1480535893296d+1*t19*t21*t66*t96-3.713762858948263d+1*t19
     7         *t21*t65*t96+5.077976365330862d+4*t21*t5*t66*t89-1.117154
     8         8003727898d+5*t21*t5*t65*t89-9.232684300601568d+2*t46*t5*
     9         t75+9.232684300601568d+2*t16*t43*t5*t75+9.232684300601568
     :         d+2*t46*t5*t74+2.769805290180471d+3*t40*t45*t5*t74-3.6930
     ;         73720240627d+3*t16*t43*t5*t74-8.309415870541413d+3*t40*t4
     <         5*t5*t73+2.769805290180471d+3*t16*t43*t5*t73+5.5396105803
     =         60942d+3*t37*t42*t5*t73+5.539610580360942d+3*t40*t45*t5*t
     >         72-1.4772294880962508d+4*t37*t42*t5*t72+9.232684300601568
     ?         d+3*t34*t39*t5*t72+9.232684300601568d+3*t37*t42*t5*t71-2.
     @         308171075150392d+4*t34*t39*t5*t71+1.3849026450902355d+4*t
     1         31*t36*t5*t71+1.3849026450902355d+4*t34*t39*t5*t70-3.3237
     2         66348216566d+4*t31*t36*t5*t70+1.9388637031263292d+4*t28*t
     3         33*t5*t70+1.9388637031263292d+4*t31*t36*t5*t69-4.52401530
     4         72947686d+4*t28*t33*t5*t69+2.585151604168439d+4*t25*t30*t
     5         5*t69+2.585151604168439d+4*t28*t33*t5*t68-5.9089179523850
     6         03d+4*t25*t30*t5*t68+3.3237663482165647d+4*t22*t27*t5*t68
     7         +3.3237663482165647d+4*t25*t30*t5*t67-7.478474283487271d+
     8         4*t22*t27*t5*t67+4.1547079352707056d+4*t19*t24*t5*t67+4.1
     9         54707935270705d+4*t22*t27*t5*t66-9.232684300601568d+4*t19
     :         *t24*t5*t66+5.077976365330863d+4*t19*t24*t5*t65+6.0935716
     ;         38397036d+4*t110*t17*t5*t65)-9.305257363491002d-1*t12*t4*
     <         t51*(-3.4716600044518436d+6*t24*t54*t89*t97+1.15722000148
     =         39477d+7*t24*t53*t89*t97-1.2729420016323426d+7*t24*t52*t8
     >         9*t97+2.104036366334451d+4*t43*t62*t97-2.104036366334451d
     ?         +4*t16*t40*t62*t97-8.416145465337804d+4*t37*t45*t61*t97-4
     @         .208072732668902d+4*t43*t61*t97+1.2624218198006704d+5*t16
     1         *t40*t61*t97+3.787265459402013d+5*t37*t45*t60*t97+2.10403
     2         6366334451d+4*t43*t60*t97-2.104036366334451d+5*t34*t42*t6
     3         0*t97-1.8936327297010064d+5*t16*t40*t60*t97-5.04968727920
     4         2681d+5*t37*t45*t59*t97+8.416145465337803d+5*t34*t42*t59*
     5         t97+8.416145465337804d+4*t16*t40*t59*t97-4.20807273266890
     6         16d+5*t31*t39*t59*t97+2.1040363663344508d+5*t37*t45*t58*t
     7         97-1.0520181831672254d+6*t34*t42*t58*t97+1.57802727475083
     8         8d+6*t31*t39*t58*t97-7.364127282170578d+5*t28*t36*t58*t97
     9         +4.208072732668902d+5*t34*t42*t57*t97-1.893632729701006d+
     :         6*t31*t39*t57*t97+2.6510858215814087d+6*t28*t36*t57*t97-1
     ;         .1782603651472927d+6*t25*t33*t57*t97+7.364127282170578d+5
     <         *t31*t39*t56*t97-3.0929334585116436d+6*t28*t36*t56*t97+4.
     =         123911278015524d+6*t25*t33*t56*t97-1.7673905477209387d+6*
     >         t22*t30*t56*t97+1.1782603651472927d+6*t28*t36*t55*t97-4.7
     ?         13041460589171d+6*t25*t33*t55*t97+6.059624735043219d+6*t2
     @         2*t30*t55*t97-2.524843639601341d+6*t19*t27*t55*t97+1.7673
     1         90547720939d+6*t25*t33*t54*t97-6.817077826923622d+6*t22*t
     2         30*t54*t97+8.521347283654526d+6*t19*t27*t54*t97+2.5248436
     3         39601341d+6*t22*t30*t53*t97-9.468163648505028d+6*t19*t27*
     4         t53*t97-4.628880005935792d+6*t110*t21*t53*t97+3.471660004
     5         4518436d+6*t19*t27*t52*t97+1.5275304019588112d+7*t110*t21
     6         *t52*t97-6.01754400771653d+6*t146*t17*t52*t97+3.713762858
     7         948263d+1*t17*t52*t89*t96-3.37614805358933d+0*t48*t62*t96
     8         +3.37614805358933d+0*t16*t46*t62*t96-6.75229610717866d+0*
     9         t16*t46*t61*t96+6.75229610717866d+0*t43*t45*t61*t96-1.012
     :         8444160767991d+1*t43*t45*t60*t96+1.0128444160767991d+1*t4
     ;         0*t42*t60*t96-1.350459221435732d+1*t40*t42*t59*t96+1.3504
     <         59221435732d+1*t37*t39*t59*t96-1.6880740267946648d+1*t37*
     =         t39*t58*t96+1.6880740267946648d+1*t34*t36*t58*t96-2.02568
     >         88321535982d+1*t34*t36*t57*t96+2.0256888321535982d+1*t31*
     ?         t33*t57*t96-2.3633036375125308d+1*t31*t33*t56*t96+2.36330
     @         36375125308d+1*t28*t30*t56*t96-2.700918442871464d+1*t28*t
     1         30*t55*t96+2.700918442871464d+1*t25*t27*t55*t96-3.0385332
     2         482303967d+1*t25*t27*t54*t96+3.0385332482303967d+1*t22*t2
     3         4*t54*t96-3.3761480535893296d+1*t22*t24*t53*t96+3.3761480
     4         535893296d+1*t19*t21*t53*t96-3.713762858948263d+1*t19*t21
     5         *t52*t96+5.077976365330862d+4*t21*t5*t53*t89-1.1171548003
     6         727898d+5*t21*t5*t52*t89-9.232684300601568d+2*t46*t5*t62+
     7         9.232684300601568d+2*t16*t43*t5*t62+9.232684300601568d+2*
     8         t46*t5*t61+2.769805290180471d+3*t40*t45*t5*t61-3.69307372
     9         0240627d+3*t16*t43*t5*t61-8.309415870541413d+3*t40*t45*t5
     :         *t60+2.769805290180471d+3*t16*t43*t5*t60+5.53961058036094
     ;         2d+3*t37*t42*t5*t60+5.539610580360942d+3*t40*t45*t5*t59-1
     <         .4772294880962508d+4*t37*t42*t5*t59+9.232684300601568d+3*
     =         t34*t39*t5*t59+9.232684300601568d+3*t37*t42*t5*t58-2.3081
     >         71075150392d+4*t34*t39*t5*t58+1.3849026450902355d+4*t31*t
     ?         36*t5*t58+1.3849026450902355d+4*t34*t39*t5*t57-3.32376634
     @         8216566d+4*t31*t36*t5*t57+1.9388637031263292d+4*t28*t33*t
     1         5*t57+1.9388637031263292d+4*t31*t36*t5*t56-4.524015307294
     2         7686d+4*t28*t33*t5*t56+2.585151604168439d+4*t25*t30*t5*t5
     3         6+2.585151604168439d+4*t28*t33*t5*t55-5.908917952385003d+
     4         4*t25*t30*t5*t55+3.3237663482165647d+4*t22*t27*t5*t55+3.3
     5         237663482165647d+4*t25*t30*t5*t54-7.478474283487271d+4*t2
     6         2*t27*t5*t54+4.1547079352707056d+4*t19*t24*t5*t54+4.15470
     7         7935270705d+4*t22*t27*t5*t53-9.232684300601568d+4*t19*t24
     8         *t5*t53+5.077976365330863d+4*t19*t24*t5*t52+6.09357163839
     9         7036d+4*t110*t17*t5*t52)-9.305257363491002d-1*t12*t3*t4*(
     :         -3.4716600044518436d+6*t23*t24*t89*t97+1.1572200014839477
     ;         d+7*t20*t24*t89*t97-1.2729420016323426d+7*t13*t24*t89*t97
     <         +2.104036366334451d+4*t43*t47*t97-2.104036366334451d+4*t1
     =         6*t40*t47*t97-8.416145465337804d+4*t37*t44*t45*t97+3.7872
     >         65459402013d+5*t37*t41*t45*t97-5.049687279202681d+5*t37*t
     ?         38*t45*t97+2.1040363663344508d+5*t35*t37*t45*t97-4.208072
     @         732668902d+4*t43*t44*t97+1.2624218198006704d+5*t16*t40*t4
     1         4*t97+2.104036366334451d+4*t41*t43*t97-2.104036366334451d
     2         +5*t34*t41*t42*t97+8.416145465337803d+5*t34*t38*t42*t97-1
     3         .0520181831672254d+6*t34*t35*t42*t97+4.208072732668902d+5
     4         *t32*t34*t42*t97-1.8936327297010064d+5*t16*t40*t41*t97+8.
     5         416145465337804d+4*t16*t38*t40*t97-4.2080727326689016d+5*
     6         t31*t38*t39*t97+1.578027274750838d+6*t31*t35*t39*t97-1.89
     7         3632729701006d+6*t31*t32*t39*t97+7.364127282170578d+5*t29
     8         *t31*t39*t97-7.364127282170578d+5*t28*t35*t36*t97+2.65108
     9         58215814087d+6*t28*t32*t36*t97-3.0929334585116436d+6*t28*
     :         t29*t36*t97+1.1782603651472927d+6*t26*t28*t36*t97-1.17826
     ;         03651472927d+6*t25*t32*t33*t97+4.123911278015524d+6*t25*t
     <         29*t33*t97-4.713041460589171d+6*t25*t26*t33*t97+1.7673905
     =         47720939d+6*t23*t25*t33*t97-1.7673905477209387d+6*t22*t29
     >         *t30*t97+6.059624735043219d+6*t22*t26*t30*t97-6.817077826
     ?         923622d+6*t22*t23*t30*t97+2.524843639601341d+6*t20*t22*t3
     @         0*t97-2.524843639601341d+6*t19*t26*t27*t97+8.521347283654
     1         526d+6*t19*t23*t27*t97-9.468163648505028d+6*t19*t20*t27*t
     2         97+3.4716600044518436d+6*t13*t19*t27*t97-4.62888000593579
     3         2d+6*t110*t20*t21*t97+1.5275304019588112d+7*t110*t13*t21*
     4         t97-6.01754400771653d+6*t13*t146*t17*t97+3.71376285894826
     5         3d+1*t13*t17*t89*t96-3.37614805358933d+0*t47*t48*t96+3.37
     6         614805358933d+0*t16*t46*t47*t96-6.75229610717866d+0*t16*t
     7         44*t46*t96+6.75229610717866d+0*t43*t44*t45*t96-1.01284441
     8         60767991d+1*t41*t43*t45*t96+1.0128444160767991d+1*t40*t41
     9         *t42*t96-1.350459221435732d+1*t38*t40*t42*t96+1.350459221
     :         435732d+1*t37*t38*t39*t96-1.6880740267946648d+1*t35*t37*t
     ;         39*t96+1.6880740267946648d+1*t34*t35*t36*t96-2.0256888321
     <         535982d+1*t32*t34*t36*t96+2.0256888321535982d+1*t31*t32*t
     =         33*t96-2.3633036375125308d+1*t29*t31*t33*t96+2.3633036375
     >         125308d+1*t28*t29*t30*t96-2.700918442871464d+1*t26*t28*t3
     ?         0*t96+2.700918442871464d+1*t25*t26*t27*t96-3.038533248230
     @         3967d+1*t23*t25*t27*t96+3.0385332482303967d+1*t22*t23*t24
     1         *t96-3.3761480535893296d+1*t20*t22*t24*t96+3.376148053589
     2         3296d+1*t19*t20*t21*t96-3.713762858948263d+1*t13*t19*t21*
     3         t96+5.077976365330862d+4*t20*t21*t5*t89-1.117154800372789
     4         8d+5*t13*t21*t5*t89-9.232684300601568d+2*t46*t47*t5+9.232
     5         684300601568d+2*t16*t43*t47*t5+9.232684300601568d+2*t44*t
     6         46*t5+2.769805290180471d+3*t40*t44*t45*t5-8.3094158705414
     7         13d+3*t40*t41*t45*t5+5.539610580360942d+3*t38*t40*t45*t5-
     8         3.693073720240627d+3*t16*t43*t44*t5+2.769805290180471d+3*
     9         t16*t41*t43*t5+5.539610580360942d+3*t37*t41*t42*t5-1.4772
     :         294880962508d+4*t37*t38*t42*t5+9.232684300601568d+3*t35*t
     ;         37*t42*t5+9.232684300601568d+3*t34*t38*t39*t5-2.308171075
     <         150392d+4*t34*t35*t39*t5+1.3849026450902355d+4*t32*t34*t3
     =         9*t5+1.3849026450902355d+4*t31*t35*t36*t5-3.3237663482165
     >         66d+4*t31*t32*t36*t5+1.9388637031263292d+4*t29*t31*t36*t5
     ?         +1.9388637031263292d+4*t28*t32*t33*t5-4.5240153072947686d
     @         +4*t28*t29*t33*t5+2.585151604168439d+4*t26*t28*t33*t5+2.5
     1         85151604168439d+4*t25*t29*t30*t5-5.908917952385003d+4*t25
     2         *t26*t30*t5+3.3237663482165647d+4*t23*t25*t30*t5+3.323766
     3         3482165647d+4*t22*t26*t27*t5-7.478474283487271d+4*t22*t23
     4         *t27*t5+4.154707935270705d+4*t20*t22*t27*t5+4.15470793527
     5         07056d+4*t19*t23*t24*t5-9.232684300601568d+4*t19*t20*t24*
     6         t5+5.077976365330863d+4*t13*t19*t24*t5+6.093571638397036d
     7         +4*t110*t13*t17*t5)+(5.377850105933821d-2*gammaaa*t103*t9
     8         0+2.6889250529669106d-2*gammaaa*t123*t49+2.68892505296691
     9         06d-2*gammaaa*t111*t12)*t94*t95+(9.894611731573306d-5*t10
     :         4*t115*t12*t50*t91+3.024609866719883d-2*gammaaa*t103*t50*
     ;         t91+1.5123049333599414d-2*gammaaa*t123*t50*t63+9.89461173
     <         1573306d-5*t103*t104*t115*t50*t63+1.5123049333599414d-2*g
     =         ammaaa*t112*t12*t50)*t95+t101*(3.983592671062089d-3*gamma
     >         aa*t104*t12*t49*t94-1.2407009817988002d+0*t12*t51*t91-1.2
     ?         407009817988002d+0*t12*t3*t90-1.2407009817988002d+0*t103*
     @         t51*t63+2.2404517531258392d-3*gammaaa*t104*t12*t50*t63-1.
     1         2407009817988002d+0*t103*t3*t49)+t125*(3.5318356336070855
     2         d-2*gammaaa*t64*t92+3.5318356336070855d-2*gammaaa*t105*t7
     3         6)*t94+t104*(-5.779367400447957d-2*gammaaa*t105*t92-2.889
     4         6837002239784d-2*gammaaa*t126*t76-2.8896837002239784d-2*g
     5         ammaaa*t113*t64)*t94+t118*(1.4938472516482826d-2*gammaaa*
     6         t12*t90+1.4938472516482826d-2*gammaaa*t103*t49)*t94-1.648
     7         1899623499732d-1*gammaaa*t155*t64*t76*t94+2.9876945032965
     8         69d-2*gammaaa*t12*t151*t49*t94-3.6666666666666664d+0*t125
     9         *t130*t94-2.3333333333333334d+0*t118*t127*t94+t104*(-1.06
     :         3335633294209d-4*t104*t115*t50*t64*t93-3.250431179460851d
     ;         -2*gammaaa*t105*t50*t93-1.6252155897304255d-2*gammaaa*t12
     <         6*t50*t88-1.063335633294209d-4*t104*t105*t115*t50*t88-1.6
     =         252155897304255d-2*gammaaa*t114*t50*t64)+t124*(-5.3166781
     >         66471045d-5*t115*t50*t64*t93-5.316678166471045d-5*t105*t1
     ?         15*t50*t88)+t125*(1.9863746096705204d-2*gammaaa*t50*t64*t
     @         93+1.9863746096705204d-2*gammaaa*t105*t50*t88)+3*t126*t51
     1         *t93+t116*t124*(-2.3079800683637772d-4*t115*t64*t92-2.307
     2         9800683637772d-4*t105*t115*t76+2.3960893036683073d-2*gamm
     3         aaa*t130)+3*t126*t3*t92+t117*(4.947305865786653d-5*t115*t
     4         12*t50*t91+4.947305865786653d-5*t103*t115*t50*t63)+t118*(
     5         8.401694074221897d-3*gammaaa*t12*t50*t91+8.40169407422189
     6         7d-3*gammaaa*t103*t50*t63)-7.444205890792801d+0*t103*t5*t
     7         51*t91-2.7915772090473007d+0*t123*t4*t51*t91+t116*t117*(2
     8         .1476348525932504d-4*t115*t12*t90+2.1476348525932504d-4*t
     9         103*t115*t49+2.3960893036683073d-2*gammaaa*t127)-7.444205
     :         890792801d+0*t103*t3*t5*t90-2.7915772090473007d+0*t123*t3
     ;         *t4*t90-9.269748178462429d-2*gammaaa*t155*t50*t64*t88+5.8
     <         4834598311815d-4*t115*t154*t50*t64*t88-5.217843141140167d
     =         -7*t147*t153*t50*t64*t88+t156*t51*t88+2.5387780752001543d
     >         -3*t115*t116*t154*t64*t76-8.295189532329142d-6*t147*t148*
     ?         t153*t64*t76+t156*t3*t76-3.7221029453964005d+0*t123*t5*t5
     @         1*t63-9.305257363491002d-1*t152*t4*t51*t63+1.680338814844
     1         3793d-2*gammaaa*t12*t151*t50*t63-3.4631141060506576d-4*t1
     2         15*t12*t150*t50*t63+4.855337331063556d-7*t12*t147*t149*t5
     3         0*t63-3.7221029453964005d+0*t112*t12*t5*t51-2.79157720904
     4         73007d+0*t103*t112*t4*t51+3*t105*t114*t51-3.7221029453964
     5         005d+0*t123*t3*t49*t5-3.7221029453964005d+0*t111*t12*t3*t
     6         5-9.305257363491002d-1*t152*t3*t4*t49-1.5033443968152754d
     7         -3*t115*t116*t12*t150*t49+7.718887347725925d-6*t12*t147*t
     8         148*t149*t49-2.7915772090473007d+0*t103*t111*t3*t4+3*t105
     9         *t113*t3-3.6666666666666664d+0*t125*t131-2.33333333333333
     :         34d+0*t118*t129-6.666666666666666d-1*t121*t128)*wght+Amat
     ;         3(iq,D3_RA_RA_RA)
            Cmat3(iq,D3_RA_RA_GAA) = 1.0d+0*((-6.722312632417276d-3*t103
     1         *t90-3.361156316208638d-3*t123*t49-3.361156316208638d-3*t
     2         111*t12)*t94*t96+(-3.780762333399854d-3*t103*t50*t91-1.89
     3         0381166699927d-3*t123*t50*t63-1.890381166699927d-3*t112*t
     4         12*t50)*t96+(8.963083509889702d-3*t12*t90+8.9630835098897
     5         02d-3*t103*t49)*t94*t95+(-3.71047939933999d-5*gammaaa*t1*
     6         t12*t50*t91+5.041016444533138d-3*t12*t50*t91-3.7104793993
     7         3999d-5*gammaaa*t1*t103*t50*t63+5.041016444533138d-3*t103
     8         *t50*t63)*t95+t101*(-1.4938472516482837d-3*t1*t12*t49*t94
     9         -8.401694074221898d-4*t1*t12*t50*t63)+t104*(-1.9264558001
     :         493193d-2*t64*t92-1.9264558001493193d-2*t105*t76)*t94+t1*
     ;         (7.224209250559948d-3*t105*t92+3.612104625279974d-3*t126*
     <         t76+3.612104625279974d-3*t113*t64)*t94+3.5318356336070855
     =         d-2*t125*t64*t76*t94-8.963083509889707d-3*t118*t12*t49*t9
     >         4+t104*(3.9875086248532843d-5*gammaaa*t1*t50*t64*t93-1.08
     ?         34770598202839d-2*t50*t64*t93+3.9875086248532843d-5*gamma
     @         aa*t1*t105*t50*t88-1.0834770598202839d-2*t105*t50*t88)+t1
     1         *(4.063038974326065d-3*t105*t50*t93+2.0315194871630324d-3
     2         *t126*t50*t88+2.0315194871630324d-3*t114*t50*t64)+1.95669
     3         1177927563d-7*t115*t158*t50*t64*t88+1.9863746096705204d-2
     4         *t125*t50*t64*t88-1.7943788811839778d-4*gammaaa*t124*t50*
     5         t64*t88+3.1106960746234286d-6*t115*t148*t158*t64*t76-7.78
     6         9432730727747d-4*gammaaa*t116*t124*t64*t76-1.820751499148
     7         8338d-7*t115*t12*t157*t50*t63-5.041016444533138d-3*t118*t
     8         12*t50*t63+1.1749851431243302d-4*gammaaa*t117*t12*t50*t63
     9         -2.8945827553972214d-6*t115*t12*t148*t157*t49+5.100632774
     :         908971d-4*gammaaa*t116*t117*t12*t49-8.985334888756153d-3*
     ;         t116*t130*t133-8.985334888756153d-3*t116*t127*t132)*wght+
     <         Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_GAA_GAA) = 1.0d+0*((6.957148873762482d-6*t1*t
     1         12*t50*t91+6.957148873762482d-6*t1*t103*t50*t63)*t96+t1*(
     2         -7.476578671599909d-6*t1*t50*t64*t93-7.476578671599909d-6
     3         *t1*t105*t50*t88)-7.337591917228362d-8*gammaaa*t160*t50*t
     4         64*t88+3.9875086248532843d-5*t133*t50*t64*t88-1.166511027
     5         9837858d-6*gammaaa*t148*t160*t64*t76+1.7309850512728328d-
     6         4*t116*t133*t64*t76+6.827818121808127d-8*gammaaa*t12*t159
     7         *t50*t63-2.7828595495049924d-5*t12*t132*t50*t63+1.0854685
     8         332739583d-6*gammaaa*t12*t148*t159*t49-1.2080446045837034
     9         d-4*t116*t12*t132*t49-8.985334888756153d-3*t116*t135*t137
     :         -8.985334888756153d-3*t116*t134*t136)*wght+Cmat3(iq,D3_RA
     ;         _GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAA) = 1.0d+0*(2.751596968960636d-8*t162
     1         *t50*t64*t88+4.374416354939197d-7*t148*t162*t64*t76-2.560
     2         431795678048d-8*t12*t161*t50*t63-4.070506999777343d-7*t12
     3         *t148*t161*t49)*wght+Cmat3(iq,D3_GAA_GAA_GAA)
            Mmat3(iq,D3_RA_RA_TA) = 1.0d+0*((1.7926167019779404d-2*gamma
     1         aa*t12*t138+1.7926167019779404d-2*gammaaa*t103*t106)*t94*
     2         t95+(1.0082032889066277d-2*gammaaa*t12*t139*t50+1.0082032
     3         889066277d-2*gammaaa*t103*t107*t50)*t95+t104*(-1.92645580
     4         01493193d-2*gammaaa*t140*t64-1.9264558001493193d-2*gammaa
     5         a*t105*t108)*t94+3.5318356336070855d-2*gammaaa*t108*t125*
     6         t64*t94-8.963083509889707d-3*gammaaa*t106*t118*t12*t94+t5
     7         1*t64*(-4.5701787287977763d+5*t24*t4*t79*t89+2.2282577153
     8         689576d+3*t21*t6*t78*t89+5.077976365330863d+5*t24*t4*t78*
     9         t89+5.585774001863949d+5*t24*t4*t77*t89+4.051377664307196
     :         4d+1*t16*t43*t6*t87+9.232684300601569d+2*t4*t43*t87-2.769
     ;         805290180471d+3*t16*t4*t40*t87-4.0513776643071964d+1*t46*
     <         t6*t86+1.2154132992921589d+2*t40*t45*t6*t86-1.10792211607
     =         21883d+4*t37*t4*t45*t86+1.846536860120314d+3*t4*t43*t86+5
     >         .539610580360942d+3*t16*t4*t40*t86-1.2154132992921589d+2*
     ?         t16*t43*t6*t85+2.4308265985843178d+2*t37*t42*t6*t85+1.661
     @         8831741082832d+4*t37*t4*t45*t85-2.769805290180471d+3*t4*t
     1         43*t85-2.769805290180471d+4*t34*t4*t42*t85+8.309415870541
     2         416d+3*t16*t4*t40*t85-2.4308265985843178d+2*t40*t45*t6*t8
     3         4+4.0513776643071964d+2*t34*t39*t6*t84+2.2158442321443766
     4         d+4*t37*t4*t45*t84+3.693073720240629d+4*t34*t4*t42*t84-1.
     5         1079221160721883d+4*t16*t4*t40*t84-5.539610580360941d+4*t
     6         31*t39*t4*t84-4.051377664307196d+2*t37*t42*t6*t83+6.07706
     7         6496460793d+2*t31*t36*t6*t83-2.7698052901804704d+4*t37*t4
     8         *t45*t83+4.616342150300784d+4*t34*t4*t42*t83+6.9245132254
     9         51174d+4*t31*t39*t4*t83-9.694318515631648d+4*t28*t36*t4*t
     :         83-6.077066496460795d+2*t34*t39*t6*t82+8.507893095045113d
     ;         +2*t28*t33*t6*t82-5.539610580360942d+4*t34*t4*t42*t82+8.3
     <         09415870541416d+4*t31*t39*t4*t82+1.1633182218757979d+5*t2
     =         8*t36*t4*t82-1.5510909625010638d+5*t25*t33*t4*t82-8.50789
     >         3095045111d+2*t31*t36*t6*t81+1.1343857460060149d+3*t25*t3
     ?         0*t6*t81-9.694318515631648d+4*t31*t39*t4*t81+1.3572045921
     @         884307d+5*t28*t36*t4*t81+1.809606122917908d+5*t25*t33*t4*
     1         t81-2.3266364437515955d+5*t22*t30*t4*t81-1.13438574600601
     2         49d+3*t28*t33*t6*t80+1.4584959591505908d+3*t22*t27*t6*t80
     3         -1.5510909625010635d+5*t28*t36*t4*t80+2.0681212833347515d
     4         +5*t25*t33*t4*t80+2.659013078573252d+5*t22*t30*t4*t80-3.3
     5         23766348216565d+5*t19*t27*t4*t80-1.4584959591505905d+3*t2
     6         5*t30*t6*t79+1.8231199489382383d+3*t19*t24*t6*t79-2.32663
     7         64437515952d+5*t25*t33*t4*t79+2.9913897133949086d+5*t22*t
     8         30*t4*t79+3.7392371417436354d+5*t19*t27*t4*t79-1.82311994
     9         89382383d+3*t22*t27*t6*t78-3.3237663482165647d+5*t22*t30*
     :         t4*t78+4.1547079352707056d+5*t19*t27*t4*t78-6.09357163839
     ;         7035d+5*t110*t21*t4*t78-2.228257715368958d+3*t19*t24*t6*t
     <         77+2.6739092584427493d+3*t110*t17*t6*t77-4.57017872879777
     =         63d+5*t19*t27*t4*t77+6.702928802236738d+5*t110*t21*t4*t77
     >         -7.921643129916147d+5*t146*t17*t4*t77)+t3*t64*(-4.5701787
     ?         287977763d+5*t24*t4*t67*t89+2.2282577153689576d+3*t21*t6*
     @         t66*t89+5.077976365330863d+5*t24*t4*t66*t89+5.58577400186
     1         3949d+5*t24*t4*t65*t89+4.0513776643071964d+1*t16*t43*t6*t
     2         75+9.232684300601569d+2*t4*t43*t75-2.769805290180471d+3*t
     3         16*t4*t40*t75-4.0513776643071964d+1*t46*t6*t74+1.21541329
     4         92921589d+2*t40*t45*t6*t74-1.1079221160721883d+4*t37*t4*t
     5         45*t74+1.846536860120314d+3*t4*t43*t74+5.539610580360942d
     6         +3*t16*t4*t40*t74-1.2154132992921589d+2*t16*t43*t6*t73+2.
     7         4308265985843178d+2*t37*t42*t6*t73+1.6618831741082832d+4*
     8         t37*t4*t45*t73-2.769805290180471d+3*t4*t43*t73-2.76980529
     9         0180471d+4*t34*t4*t42*t73+8.309415870541416d+3*t16*t4*t40
     :         *t73-2.4308265985843178d+2*t40*t45*t6*t72+4.0513776643071
     ;         964d+2*t34*t39*t6*t72+2.2158442321443766d+4*t37*t4*t45*t7
     <         2+3.693073720240629d+4*t34*t4*t42*t72-1.1079221160721883d
     =         +4*t16*t4*t40*t72-5.539610580360941d+4*t31*t39*t4*t72-4.0
     >         51377664307196d+2*t37*t42*t6*t71+6.077066496460793d+2*t31
     ?         *t36*t6*t71-2.7698052901804704d+4*t37*t4*t45*t71+4.616342
     @         150300784d+4*t34*t4*t42*t71+6.924513225451174d+4*t31*t39*
     1         t4*t71-9.694318515631648d+4*t28*t36*t4*t71-6.077066496460
     2         795d+2*t34*t39*t6*t70+8.507893095045113d+2*t28*t33*t6*t70
     3         -5.539610580360942d+4*t34*t4*t42*t70+8.309415870541416d+4
     4         *t31*t39*t4*t70+1.1633182218757979d+5*t28*t36*t4*t70-1.55
     5         10909625010638d+5*t25*t33*t4*t70-8.507893095045111d+2*t31
     6         *t36*t6*t69+1.1343857460060149d+3*t25*t30*t6*t69-9.694318
     7         515631648d+4*t31*t39*t4*t69+1.3572045921884307d+5*t28*t36
     8         *t4*t69+1.809606122917908d+5*t25*t33*t4*t69-2.32663644375
     9         15955d+5*t22*t30*t4*t69-1.1343857460060149d+3*t28*t33*t6*
     :         t68+1.4584959591505908d+3*t22*t27*t6*t68-1.55109096250106
     ;         35d+5*t28*t36*t4*t68+2.0681212833347515d+5*t25*t33*t4*t68
     <         +2.659013078573252d+5*t22*t30*t4*t68-3.323766348216565d+5
     =         *t19*t27*t4*t68-1.4584959591505905d+3*t25*t30*t6*t67+1.82
     >         31199489382383d+3*t19*t24*t6*t67-2.3266364437515952d+5*t2
     ?         5*t33*t4*t67+2.9913897133949086d+5*t22*t30*t4*t67+3.73923
     @         71417436354d+5*t19*t27*t4*t67-1.8231199489382383d+3*t22*t
     1         27*t6*t66-3.3237663482165647d+5*t22*t30*t4*t66+4.15470793
     2         52707056d+5*t19*t27*t4*t66-6.093571638397035d+5*t110*t21*
     3         t4*t66-2.228257715368958d+3*t19*t24*t6*t65+2.673909258442
     4         7493d+3*t110*t17*t6*t65-4.5701787287977763d+5*t19*t27*t4*
     5         t65+6.702928802236738d+5*t110*t21*t4*t65-7.92164312991614
     6         7d+5*t146*t17*t4*t65)-9.305257363491002d-1*t12*t4*t51*(2.
     7         2282577153689576d+3*t21*t53*t6*t89-4.5701787287977763d+5*
     8         t24*t4*t54*t89+5.077976365330863d+5*t24*t4*t53*t89+5.5857
     9         74001863949d+5*t24*t4*t52*t89+4.0513776643071964d+1*t16*t
     :         43*t6*t62+9.232684300601569d+2*t4*t43*t62-2.7698052901804
     ;         71d+3*t16*t4*t40*t62-4.0513776643071964d+1*t46*t6*t61+1.2
     <         154132992921589d+2*t40*t45*t6*t61-1.1079221160721883d+4*t
     =         37*t4*t45*t61+1.846536860120314d+3*t4*t43*t61+5.539610580
     >         360942d+3*t16*t4*t40*t61-1.2154132992921589d+2*t16*t43*t6
     ?         *t60+2.4308265985843178d+2*t37*t42*t6*t60+1.6618831741082
     @         832d+4*t37*t4*t45*t60-2.769805290180471d+3*t4*t43*t60-2.7
     1         69805290180471d+4*t34*t4*t42*t60+8.309415870541416d+3*t16
     2         *t4*t40*t60-2.4308265985843178d+2*t40*t45*t59*t6+4.051377
     3         6643071964d+2*t34*t39*t59*t6-4.051377664307196d+2*t37*t42
     4         *t58*t6+6.077066496460793d+2*t31*t36*t58*t6-6.07706649646
     5         0795d+2*t34*t39*t57*t6+8.507893095045113d+2*t28*t33*t57*t
     6         6-8.507893095045111d+2*t31*t36*t56*t6+1.1343857460060149d
     7         +3*t25*t30*t56*t6-1.1343857460060149d+3*t28*t33*t55*t6+1.
     8         4584959591505908d+3*t22*t27*t55*t6-1.4584959591505905d+3*
     9         t25*t30*t54*t6+1.8231199489382383d+3*t19*t24*t54*t6-1.823
     :         1199489382383d+3*t22*t27*t53*t6-2.228257715368958d+3*t19*
     ;         t24*t52*t6+2.6739092584427493d+3*t110*t17*t52*t6+2.215844
     <         2321443766d+4*t37*t4*t45*t59+3.693073720240629d+4*t34*t4*
     =         t42*t59-1.1079221160721883d+4*t16*t4*t40*t59-5.5396105803
     >         60941d+4*t31*t39*t4*t59-2.7698052901804704d+4*t37*t4*t45*
     ?         t58+4.616342150300784d+4*t34*t4*t42*t58+6.924513225451174
     @         d+4*t31*t39*t4*t58-9.694318515631648d+4*t28*t36*t4*t58-5.
     1         539610580360942d+4*t34*t4*t42*t57+8.309415870541416d+4*t3
     2         1*t39*t4*t57+1.1633182218757979d+5*t28*t36*t4*t57-1.55109
     3         09625010638d+5*t25*t33*t4*t57-9.694318515631648d+4*t31*t3
     4         9*t4*t56+1.3572045921884307d+5*t28*t36*t4*t56+1.809606122
     5         917908d+5*t25*t33*t4*t56-2.3266364437515955d+5*t22*t30*t4
     6         *t56-1.5510909625010635d+5*t28*t36*t4*t55+2.0681212833347
     7         515d+5*t25*t33*t4*t55+2.659013078573252d+5*t22*t30*t4*t55
     8         -3.323766348216565d+5*t19*t27*t4*t55-2.3266364437515952d+
     9         5*t25*t33*t4*t54+2.9913897133949086d+5*t22*t30*t4*t54+3.7
     :         392371417436354d+5*t19*t27*t4*t54-3.3237663482165647d+5*t
     ;         22*t30*t4*t53+4.1547079352707056d+5*t19*t27*t4*t53-6.0935
     <         71638397035d+5*t110*t21*t4*t53-4.5701787287977763d+5*t19*
     =         t27*t4*t52+6.702928802236738d+5*t110*t21*t4*t52-7.9216431
     >         29916147d+5*t146*t17*t4*t52)-9.305257363491002d-1*t12*t3*
     ?         t4*(2.2282577153689576d+3*t20*t21*t6*t89-4.57017872879777
     @         63d+5*t23*t24*t4*t89+5.077976365330863d+5*t20*t24*t4*t89+
     1         5.585774001863949d+5*t13*t24*t4*t89+4.0513776643071964d+1
     2         *t16*t43*t47*t6-4.0513776643071964d+1*t44*t46*t6+1.215413
     3         2992921589d+2*t40*t44*t45*t6-2.4308265985843178d+2*t38*t4
     4         0*t45*t6-1.2154132992921589d+2*t16*t41*t43*t6+2.430826598
     5         5843178d+2*t37*t41*t42*t6-4.051377664307196d+2*t35*t37*t4
     6         2*t6+4.0513776643071964d+2*t34*t38*t39*t6-6.0770664964607
     7         95d+2*t32*t34*t39*t6+6.077066496460793d+2*t31*t35*t36*t6-
     8         8.507893095045111d+2*t29*t31*t36*t6+8.507893095045113d+2*
     9         t28*t32*t33*t6-1.1343857460060149d+3*t26*t28*t33*t6+1.134
     :         3857460060149d+3*t25*t29*t30*t6-1.4584959591505905d+3*t23
     ;         *t25*t30*t6+1.4584959591505908d+3*t22*t26*t27*t6-1.823119
     <         9489382383d+3*t20*t22*t27*t6+1.8231199489382383d+3*t19*t2
     =         3*t24*t6-2.228257715368958d+3*t13*t19*t24*t6+2.6739092584
     >         427493d+3*t110*t13*t17*t6+9.232684300601569d+2*t4*t43*t47
     ?         -2.769805290180471d+3*t16*t4*t40*t47-1.1079221160721883d+
     @         4*t37*t4*t44*t45+1.6618831741082832d+4*t37*t4*t41*t45+2.2
     1         158442321443766d+4*t37*t38*t4*t45-2.7698052901804704d+4*t
     2         35*t37*t4*t45+1.846536860120314d+3*t4*t43*t44+5.539610580
     3         360942d+3*t16*t4*t40*t44-2.769805290180471d+3*t4*t41*t43-
     4         2.769805290180471d+4*t34*t4*t41*t42+3.693073720240629d+4*
     5         t34*t38*t4*t42+4.616342150300784d+4*t34*t35*t4*t42-5.5396
     6         10580360942d+4*t32*t34*t4*t42+8.309415870541416d+3*t16*t4
     7         *t40*t41-1.1079221160721883d+4*t16*t38*t4*t40-5.539610580
     8         360941d+4*t31*t38*t39*t4+6.924513225451174d+4*t31*t35*t39
     9         *t4+8.309415870541416d+4*t31*t32*t39*t4-9.694318515631648
     :         d+4*t29*t31*t39*t4-9.694318515631648d+4*t28*t35*t36*t4+1.
     ;         1633182218757979d+5*t28*t32*t36*t4+1.3572045921884307d+5*
     <         t28*t29*t36*t4-1.5510909625010635d+5*t26*t28*t36*t4-1.551
     =         0909625010638d+5*t25*t32*t33*t4+1.809606122917908d+5*t25*
     >         t29*t33*t4+2.0681212833347515d+5*t25*t26*t33*t4-2.3266364
     ?         437515952d+5*t23*t25*t33*t4-2.3266364437515955d+5*t22*t29
     @         *t30*t4+2.659013078573252d+5*t22*t26*t30*t4+2.99138971339
     1         49086d+5*t22*t23*t30*t4-3.3237663482165647d+5*t20*t22*t30
     2         *t4-3.323766348216565d+5*t19*t26*t27*t4+3.739237141743635
     3         4d+5*t19*t23*t27*t4+4.1547079352707056d+5*t19*t20*t27*t4-
     4         4.5701787287977763d+5*t13*t19*t27*t4-6.093571638397035d+5
     5         *t110*t20*t21*t4+6.702928802236738d+5*t110*t13*t21*t4-7.9
     6         21643129916147d+5*t13*t146*t17*t4)+t104*(-1.0834770598202
     7         839d-2*gammaaa*t141*t50*t64-1.0834770598202839d-2*gammaaa
     8         *t105*t109*t50)+1.9863746096705204d-2*gammaaa*t109*t125*t
     9         50*t64-5.316678166471045d-5*t109*t115*t124*t50*t64-2.3079
     :         800683637772d-4*t108*t115*t116*t124*t64+t101*(-4.13566993
     ;         9329334d-1*t107*t12*t51-4.135669939329334d-1*t106*t12*t3)
     <         -2.4814019635976003d+0*t12*t139*t5*t51-2.4814019635976003
     =         d+0*t103*t107*t5*t51-1.8610514726982003d+0*t103*t139*t4*t
     >         51-9.305257363491002d-1*t107*t123*t4*t51+2*t105*t141*t51+
     ?         t109*t126*t51-5.041016444533138d-3*gammaaa*t107*t118*t12*
     @         t50+4.947305865786653d-5*t107*t115*t117*t12*t50-2.4814019
     1         635976003d+0*t12*t138*t3*t5-2.4814019635976003d+0*t103*t1
     2         06*t3*t5-1.8610514726982003d+0*t103*t138*t3*t4-9.30525736
     3         3491002d-1*t106*t123*t3*t4+2*t105*t140*t3+t108*t126*t3+2.
     4         1476348525932504d-4*t106*t115*t116*t117*t12)*wght+Mmat3(i
     5         q,D3_RA_RA_TA)
            Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
            Mmat3(iq,D3_RA_GAA_TA) = 1.0d+0*((-3.361156316208638d-3*t12*
     1         t138-3.361156316208638d-3*t103*t106)*t94*t96+(-1.89038116
     2         6699927d-3*t12*t139*t50-1.890381166699927d-3*t103*t107*t5
     3         0)*t96+4.481541754944851d-3*t106*t12*t94*t95+2.5205082222
     4         66569d-3*t107*t12*t50*t95+t1*(3.612104625279974d-3*t140*t
     5         64+3.612104625279974d-3*t105*t108)*t94-9.632279000746596d
     6         -3*t104*t108*t64*t94+t1*(2.0315194871630324d-3*t141*t50*t
     7         64+2.0315194871630324d-3*t105*t109*t50)+1.993754312426642
     8         1d-5*gammaaa*t109*t133*t50*t64-5.417385299101419d-3*t104*
     9         t109*t50*t64+8.654925256364164d-5*gammaaa*t108*t116*t133*
     :         t64-1.855239699669995d-5*gammaaa*t107*t12*t132*t50-8.0536
     ;         3069722469d-5*gammaaa*t106*t116*t12*t132)*wght+Mmat3(iq,D
     <         3_RA_GAA_TA)
            Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
            Mmat3(iq,D3_GAA_GAA_TA) = 1.0d+0*(-7.476578671599909d-6*t109
     1         *t137*t50*t64-3.245596971136562d-5*t108*t116*t137*t64+6.9
     2         57148873762482d-6*t107*t12*t136*t50+3.020111511459258d-5*
     3         t106*t116*t12*t136)*wght+Mmat3(iq,D3_GAA_GAA_TA)
            Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
            Mmat3(iq,D3_RA_TA_TA) = 1.0d+0*(8.963083509889702d-3*gammaaa
     1         *t12*t142*t94*t95+5.041016444533138d-3*gammaaa*t12*t143*t
     2         50*t95-9.632279000746596d-3*gammaaa*t104*t144*t64*t94+t51
     3         *t64*(-6.016295831496187d+4*t24*t79*t89*t9-6.684773146106
     4         873d+4*t24*t78*t89*t9+7.353250460717561d+4*t24*t77*t89*t9
     5         -1.2154132992921589d+2*t43*t87*t9-3.646239897876477d+2*t1
     6         6*t40*t87*t9-1.4584959591505908d+3*t37*t45*t86*t9+2.43082
     7         65985843178d+2*t43*t86*t9-7.292479795752954d+2*t16*t40*t8
     8         6*t9-2.1877439387258865d+3*t37*t45*t85*t9+3.6462398978764
     9         77d+2*t43*t85*t9-3.646239897876477d+3*t34*t42*t85*t9+1.09
     :         38719693629433d+3*t16*t40*t85*t9+2.9169919183011817d+3*t3
     ;         7*t45*t84*t9-4.8616531971686355d+3*t34*t42*t84*t9+1.45849
     <         59591505908d+3*t16*t40*t84*t9-7.292479795752954d+3*t31*t3
     =         9*t84*t9+3.646239897876477d+3*t37*t45*t83*t9+6.0770664964
     >         60795d+3*t34*t42*t83*t9-9.115599744691192d+3*t31*t39*t83*
     ?         t9-1.2761839642567668d+4*t28*t36*t83*t9+7.292479795752954
     @         d+3*t34*t42*t82*t9+1.0938719693629431d+4*t31*t39*t82*t9-1
     1         .5314207571081204d+4*t28*t36*t82*t9-2.0418943428108272d+4
     2         *t25*t33*t82*t9+1.2761839642567668d+4*t31*t39*t81*t9+1.78
     3         6657549959474d+4*t28*t36*t81*t9-2.3822100666126317d+4*t25
     4         *t33*t81*t9-3.062841514216241d+4*t22*t30*t81*t9+2.0418943
     5         428108272d+4*t28*t36*t80*t9+2.722525790414436d+4*t25*t33*
     6         t80*t9-3.5003903019614174d+4*t22*t30*t80*t9-4.37548787745
     7         1772d+4*t19*t27*t80*t9+3.062841514216241d+4*t25*t33*t79*t
     8         9+3.9379390897065947d+4*t22*t30*t79*t9-4.9224238621332433
     9         d+4*t19*t27*t79*t9+4.375487877451772d+4*t22*t30*t78*t9+5.
     :         469359846814714d+4*t19*t27*t78*t9-8.021727775328248d+4*t1
     ;         10*t21*t78*t9+6.016295831496187d+4*t19*t27*t77*t9-8.82390
     <         0552861074d+4*t110*t21*t77*t9-1.0428246107926724d+5*t146*
     =         t17*t77*t9)+t3*t64*(-6.016295831496187d+4*t24*t67*t89*t9-
     >         6.684773146106873d+4*t24*t66*t89*t9+7.353250460717561d+4*
     ?         t24*t65*t89*t9-1.2154132992921589d+2*t43*t75*t9-3.6462398
     @         97876477d+2*t16*t40*t75*t9-1.4584959591505908d+3*t37*t45*
     1         t74*t9+2.4308265985843178d+2*t43*t74*t9-7.292479795752954
     2         d+2*t16*t40*t74*t9-2.1877439387258865d+3*t37*t45*t73*t9+3
     3         .646239897876477d+2*t43*t73*t9-3.646239897876477d+3*t34*t
     4         42*t73*t9+1.0938719693629433d+3*t16*t40*t73*t9+2.91699191
     5         83011817d+3*t37*t45*t72*t9-4.8616531971686355d+3*t34*t42*
     6         t72*t9+1.4584959591505908d+3*t16*t40*t72*t9-7.29247979575
     7         2954d+3*t31*t39*t72*t9+3.646239897876477d+3*t37*t45*t71*t
     8         9+6.077066496460795d+3*t34*t42*t71*t9-9.115599744691192d+
     9         3*t31*t39*t71*t9-1.2761839642567668d+4*t28*t36*t71*t9+7.2
     :         92479795752954d+3*t34*t42*t70*t9+1.0938719693629431d+4*t3
     ;         1*t39*t70*t9-1.5314207571081204d+4*t28*t36*t70*t9-2.04189
     <         43428108272d+4*t25*t33*t70*t9+1.2761839642567668d+4*t31*t
     =         39*t69*t9+1.786657549959474d+4*t28*t36*t69*t9-2.382210066
     >         6126317d+4*t25*t33*t69*t9-3.062841514216241d+4*t22*t30*t6
     ?         9*t9+2.0418943428108272d+4*t28*t36*t68*t9+2.7225257904144
     @         36d+4*t25*t33*t68*t9-3.5003903019614174d+4*t22*t30*t68*t9
     1         -4.375487877451772d+4*t19*t27*t68*t9+3.062841514216241d+4
     2         *t25*t33*t67*t9+3.9379390897065947d+4*t22*t30*t67*t9-4.92
     3         24238621332433d+4*t19*t27*t67*t9+4.375487877451772d+4*t22
     4         *t30*t66*t9+5.469359846814714d+4*t19*t27*t66*t9-8.0217277
     5         75328248d+4*t110*t21*t66*t9+6.016295831496187d+4*t19*t27*
     6         t65*t9-8.823900552861074d+4*t110*t21*t65*t9-1.04282461079
     7         26724d+5*t146*t17*t65*t9)-9.305257363491002d-1*t12*t4*t51
     8         *(-6.016295831496187d+4*t24*t54*t89*t9-6.684773146106873d
     9         +4*t24*t53*t89*t9+7.353250460717561d+4*t24*t52*t89*t9-1.2
     :         154132992921589d+2*t43*t62*t9-3.646239897876477d+2*t16*t4
     ;         0*t62*t9-1.4584959591505908d+3*t37*t45*t61*t9+2.430826598
     <         5843178d+2*t43*t61*t9-7.292479795752954d+2*t16*t40*t61*t9
     =         -2.1877439387258865d+3*t37*t45*t60*t9+3.646239897876477d+
     >         2*t43*t60*t9-3.646239897876477d+3*t34*t42*t60*t9+1.093871
     ?         9693629433d+3*t16*t40*t60*t9+2.9169919183011817d+3*t37*t4
     @         5*t59*t9-4.8616531971686355d+3*t34*t42*t59*t9+1.458495959
     1         1505908d+3*t16*t40*t59*t9-7.292479795752954d+3*t31*t39*t5
     2         9*t9+3.646239897876477d+3*t37*t45*t58*t9+6.07706649646079
     3         5d+3*t34*t42*t58*t9-9.115599744691192d+3*t31*t39*t58*t9-1
     4         .2761839642567668d+4*t28*t36*t58*t9+7.292479795752954d+3*
     5         t34*t42*t57*t9+1.0938719693629431d+4*t31*t39*t57*t9-1.531
     6         4207571081204d+4*t28*t36*t57*t9-2.0418943428108272d+4*t25
     7         *t33*t57*t9+1.2761839642567668d+4*t31*t39*t56*t9+1.786657
     8         549959474d+4*t28*t36*t56*t9-2.3822100666126317d+4*t25*t33
     9         *t56*t9-3.062841514216241d+4*t22*t30*t56*t9+2.04189434281
     :         08272d+4*t28*t36*t55*t9+2.722525790414436d+4*t25*t33*t55*
     ;         t9-3.5003903019614174d+4*t22*t30*t55*t9-4.375487877451772
     <         d+4*t19*t27*t55*t9+3.062841514216241d+4*t25*t33*t54*t9+3.
     =         9379390897065947d+4*t22*t30*t54*t9-4.9224238621332433d+4*
     >         t19*t27*t54*t9+4.375487877451772d+4*t22*t30*t53*t9+5.4693
     ?         59846814714d+4*t19*t27*t53*t9-8.021727775328248d+4*t110*t
     @         21*t53*t9+6.016295831496187d+4*t19*t27*t52*t9-8.823900552
     1         861074d+4*t110*t21*t52*t9-1.0428246107926724d+5*t146*t17*
     2         t52*t9)-9.305257363491002d-1*t12*t3*t4*(-6.01629583149618
     3         7d+4*t23*t24*t89*t9-6.684773146106873d+4*t20*t24*t89*t9+7
     4         .353250460717561d+4*t13*t24*t89*t9-1.2154132992921589d+2*
     5         t43*t47*t9-3.646239897876477d+2*t16*t40*t47*t9-1.45849595
     6         91505908d+3*t37*t44*t45*t9-2.1877439387258865d+3*t37*t41*
     7         t45*t9+2.9169919183011817d+3*t37*t38*t45*t9+3.64623989787
     8         6477d+3*t35*t37*t45*t9+2.4308265985843178d+2*t43*t44*t9-7
     9         .292479795752954d+2*t16*t40*t44*t9+3.646239897876477d+2*t
     :         41*t43*t9-3.646239897876477d+3*t34*t41*t42*t9-4.861653197
     ;         1686355d+3*t34*t38*t42*t9+6.077066496460795d+3*t34*t35*t4
     <         2*t9+7.292479795752954d+3*t32*t34*t42*t9+1.09387196936294
     =         33d+3*t16*t40*t41*t9+1.4584959591505908d+3*t16*t38*t40*t9
     >         -7.292479795752954d+3*t31*t38*t39*t9-9.115599744691192d+3
     ?         *t31*t35*t39*t9+1.0938719693629431d+4*t31*t32*t39*t9+1.27
     @         61839642567668d+4*t29*t31*t39*t9-1.2761839642567668d+4*t2
     1         8*t35*t36*t9-1.5314207571081204d+4*t28*t32*t36*t9+1.78665
     2         7549959474d+4*t28*t29*t36*t9+2.0418943428108272d+4*t26*t2
     3         8*t36*t9-2.0418943428108272d+4*t25*t32*t33*t9-2.382210066
     4         6126317d+4*t25*t29*t33*t9+2.722525790414436d+4*t25*t26*t3
     5         3*t9+3.062841514216241d+4*t23*t25*t33*t9-3.06284151421624
     6         1d+4*t22*t29*t30*t9-3.5003903019614174d+4*t22*t26*t30*t9+
     7         3.9379390897065947d+4*t22*t23*t30*t9+4.375487877451772d+4
     8         *t20*t22*t30*t9-4.375487877451772d+4*t19*t26*t27*t9-4.922
     9         4238621332433d+4*t19*t23*t27*t9+5.469359846814714d+4*t19*
     :         t20*t27*t9+6.016295831496187d+4*t13*t19*t27*t9-8.02172777
     ;         5328248d+4*t110*t20*t21*t9-8.823900552861074d+4*t110*t13*
     <         t21*t9-1.0428246107926724d+5*t13*t146*t17*t9)-5.417385299
     =         101419d-3*gammaaa*t104*t145*t50*t64-1.2407009817988002d+0
     >         *t12*t143*t5*t51-9.305257363491002d-1*t103*t143*t4*t51+t1
     ?         05*t145*t51-1.2407009817988002d+0*t12*t142*t3*t5-9.305257
     @         363491002d-1*t103*t142*t3*t4+t105*t144*t3)*wght+Mmat3(iq,
     1         D3_RA_TA_TA)
            Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
            Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
            Mmat3(iq,D3_GAA_TA_TA) = 1.0d+0*(-3.361156316208638d-3*t12*t
     1         142*t94*t96-1.890381166699927d-3*t12*t143*t50*t96+3.61210
     2         4625279974d-3*t1*t144*t64*t94+2.0315194871630324d-3*t1*t1
     3         45*t50*t64)*wght+Mmat3(iq,D3_GAA_TA_TA)
            Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
            Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
            Mmat3(iq,D3_TA_TA_TA) = 1.0d+0*(t51*t64*(-7.92d+3*t24*t79*t8
     1         9-2.64d+4*t24*t78*t89-2.904d+4*t24*t77*t89-4.8d+1*t43*t87
     2         -4.8d+1*t16*t40*t87-1.92d+2*t37*t45*t86-9.6d+1*t43*t86-2.
     3         88d+2*t16*t40*t86-8.64d+2*t37*t45*t85-4.8d+1*t43*t85-4.8d
     4         +2*t34*t42*t85-4.32d+2*t16*t40*t85-1.152d+3*t37*t45*t84-1
     5         .92d+3*t34*t42*t84-1.92d+2*t16*t40*t84-9.6d+2*t31*t39*t84
     6         -4.8d+2*t37*t45*t83-2.4d+3*t34*t42*t83-3.6d+3*t31*t39*t83
     7         -1.68d+3*t28*t36*t83-9.6d+2*t34*t42*t82-4.32d+3*t31*t39*t
     8         82-6.048d+3*t28*t36*t82-2.688d+3*t25*t33*t82-1.68d+3*t31*
     9         t39*t81-7.056d+3*t28*t36*t81-9.408d+3*t25*t33*t81-4.032d+
     :         3*t22*t30*t81-2.688d+3*t28*t36*t80-1.0752d+4*t25*t33*t80-
     ;         1.3824d+4*t22*t30*t80-5.76d+3*t19*t27*t80-4.032d+3*t25*t3
     <         3*t79-1.5552d+4*t22*t30*t79-1.944d+4*t19*t27*t79-5.76d+3*
     =         t22*t30*t78-2.16d+4*t19*t27*t78-1.056d+4*t110*t21*t78-7.9
     >         2d+3*t19*t27*t77-3.4848d+4*t110*t21*t77-1.3728d+4*t146*t1
     ?         7*t77)+t3*t64*(-7.92d+3*t24*t67*t89-2.64d+4*t24*t66*t89-2
     @         .904d+4*t24*t65*t89-4.8d+1*t43*t75-4.8d+1*t16*t40*t75-1.9
     1         2d+2*t37*t45*t74-9.6d+1*t43*t74-2.88d+2*t16*t40*t74-8.64d
     2         +2*t37*t45*t73-4.8d+1*t43*t73-4.8d+2*t34*t42*t73-4.32d+2*
     3         t16*t40*t73-1.152d+3*t37*t45*t72-1.92d+3*t34*t42*t72-1.92
     4         d+2*t16*t40*t72-9.6d+2*t31*t39*t72-4.8d+2*t37*t45*t71-2.4
     5         d+3*t34*t42*t71-3.6d+3*t31*t39*t71-1.68d+3*t28*t36*t71-9.
     6         6d+2*t34*t42*t70-4.32d+3*t31*t39*t70-6.048d+3*t28*t36*t70
     7         -2.688d+3*t25*t33*t70-1.68d+3*t31*t39*t69-7.056d+3*t28*t3
     8         6*t69-9.408d+3*t25*t33*t69-4.032d+3*t22*t30*t69-2.688d+3*
     9         t28*t36*t68-1.0752d+4*t25*t33*t68-1.3824d+4*t22*t30*t68-5
     :         .76d+3*t19*t27*t68-4.032d+3*t25*t33*t67-1.5552d+4*t22*t30
     ;         *t67-1.944d+4*t19*t27*t67-5.76d+3*t22*t30*t66-2.16d+4*t19
     <         *t27*t66-1.056d+4*t110*t21*t66-7.92d+3*t19*t27*t65-3.4848
     =         d+4*t110*t21*t65-1.3728d+4*t146*t17*t65)-9.30525736349100
     >         2d-1*t12*t4*t51*(-7.92d+3*t24*t54*t89-2.64d+4*t24*t53*t89
     ?         -2.904d+4*t24*t52*t89-4.8d+1*t43*t62-4.8d+1*t16*t40*t62-1
     @         .92d+2*t37*t45*t61-9.6d+1*t43*t61-2.88d+2*t16*t40*t61-8.6
     1         4d+2*t37*t45*t60-4.8d+1*t43*t60-4.8d+2*t34*t42*t60-4.32d+
     2         2*t16*t40*t60-1.152d+3*t37*t45*t59-1.92d+3*t34*t42*t59-1.
     3         92d+2*t16*t40*t59-9.6d+2*t31*t39*t59-4.8d+2*t37*t45*t58-2
     4         .4d+3*t34*t42*t58-3.6d+3*t31*t39*t58-1.68d+3*t28*t36*t58-
     5         9.6d+2*t34*t42*t57-4.32d+3*t31*t39*t57-6.048d+3*t28*t36*t
     6         57-2.688d+3*t25*t33*t57-1.68d+3*t31*t39*t56-7.056d+3*t28*
     7         t36*t56-9.408d+3*t25*t33*t56-4.032d+3*t22*t30*t56-2.688d+
     8         3*t28*t36*t55-1.0752d+4*t25*t33*t55-1.3824d+4*t22*t30*t55
     9         -5.76d+3*t19*t27*t55-4.032d+3*t25*t33*t54-1.5552d+4*t22*t
     :         30*t54-1.944d+4*t19*t27*t54-5.76d+3*t22*t30*t53-2.16d+4*t
     ;         19*t27*t53-1.056d+4*t110*t21*t53-7.92d+3*t19*t27*t52-3.48
     <         48d+4*t110*t21*t52-1.3728d+4*t146*t17*t52)-9.305257363491
     =         002d-1*t12*t3*t4*(-7.92d+3*t23*t24*t89-2.64d+4*t20*t24*t8
     >         9-2.904d+4*t13*t24*t89-4.8d+1*t43*t47-4.8d+1*t16*t40*t47-
     ?         1.92d+2*t37*t44*t45-8.64d+2*t37*t41*t45-1.152d+3*t37*t38*
     @         t45-4.8d+2*t35*t37*t45-9.6d+1*t43*t44-2.88d+2*t16*t40*t44
     1         -4.8d+1*t41*t43-4.8d+2*t34*t41*t42-1.92d+3*t34*t38*t42-2.
     2         4d+3*t34*t35*t42-9.6d+2*t32*t34*t42-4.32d+2*t16*t40*t41-1
     3         .92d+2*t16*t38*t40-9.6d+2*t31*t38*t39-3.6d+3*t31*t35*t39-
     4         4.32d+3*t31*t32*t39-1.68d+3*t29*t31*t39-1.68d+3*t28*t35*t
     5         36-6.048d+3*t28*t32*t36-7.056d+3*t28*t29*t36-2.688d+3*t26
     6         *t28*t36-2.688d+3*t25*t32*t33-9.408d+3*t25*t29*t33-1.0752
     7         d+4*t25*t26*t33-4.032d+3*t23*t25*t33-4.032d+3*t22*t29*t30
     8         -1.3824d+4*t22*t26*t30-1.5552d+4*t22*t23*t30-5.76d+3*t20*
     9         t22*t30-5.76d+3*t19*t26*t27-1.944d+4*t19*t23*t27-2.16d+4*
     :         t19*t20*t27-7.92d+3*t13*t19*t27-1.056d+4*t110*t20*t21-3.4
     ;         848d+4*t110*t13*t21-1.3728d+4*t13*t146*t17))*wght+Mmat3(i
     <         q,D3_TA_TA_TA)
            Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
            Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhob**2.6666666666666666d+0
            t2 = 4.492667444378077d-3*gammabb*t1+1.0d+0
            t3 = 8.04d-1*(1.0d+0-1.0d+0/t2)+1.0d+0
            t4 = rhob**1.3333333333333333d+0
            t5 = rhob**3.333333333333333d-1
            t6 = 1/t5
            t7 = 1/rhob
            t8 = 1.282782438530422d-1*t6-2.63857249068588d-4*t7
            t9 = rhob**6.666666666666666d-1
            t10 = exp(-2.4308265985843178d+2*t9)
            t11 = t10*t8+2.63857249068588d-4*t7-1.924173657795633d-1*t6+
     1         3.544907701811032d+0*erf(1.5591108358883013d+1*t5)
            t12 = 1.0d+0-4.275941461768073d-2*t11*t6
            t13 = param(12)
            t14 = rhob**1.6666666666666669d+0
            t15 = 9.115599744691192d+0*t14
            t16 = t15-2.0d+0*taub
            t17 = t16**11
            t18 = 2.0d+0*taub+t15
            t19 = 1/t18**11
            t20 = param(11)
            t21 = t16**10
            t22 = 1/t18**10
            t23 = param(10)
            t24 = t16**9
            t25 = 1/t18**9
            t26 = param(9)
            t27 = t16**8
            t28 = 1/t18**8
            t29 = param(8)
            t30 = t16**7
            t31 = 1/t18**7
            t32 = param(7)
            t33 = t16**6
            t34 = 1/t18**6
            t35 = param(6)
            t36 = t16**5
            t37 = 1/t18**5
            t38 = param(5)
            t39 = t16**4
            t40 = 1/t18**4
            t41 = param(4)
            t42 = t16**3
            t43 = 1/t18**3
            t44 = param(3)
            t45 = t16**2
            t46 = 1/t18**2
            t47 = param(2)
            t48 = 1/t18
            t49 = t16*t47*t48+t44*t45*t46+t41*t42*t43+t38*t39*t40+t35*t3
     1         6*t37+t32*t33*t34+t29*t30*t31+t26*t27*t28+t23*t24*t25+t20
     2         *t21*t22+t13*t17*t19+param(1)
            t50 = exp(-3.6802889260199856d-3*gammabb*t1)
            t51 = 5.52d-1*(1.0d+0-t50)+1.0d+0
            t52 = param(24)
            t53 = param(23)
            t54 = param(22)
            t55 = param(21)
            t56 = param(20)
            t57 = param(19)
            t58 = param(18)
            t59 = param(17)
            t60 = param(16)
            t61 = param(15)
            t62 = param(14)
            t63 = t16*t48*t62+t45*t46*t61+t42*t43*t60+t39*t40*t59+t36*t3
     1         7*t58+t33*t34*t57+t30*t31*t56+t27*t28*t55+t24*t25*t54+t21
     2         *t22*t53+t17*t19*t52+param(13)
            t64 = 9.305257363491002d-1*t12*t4-9.305257363491002d-1*t4
            t65 = param(36)
            t66 = param(35)
            t67 = param(34)
            t68 = param(33)
            t69 = param(32)
            t70 = param(31)
            t71 = param(30)
            t72 = param(29)
            t73 = param(28)
            t74 = param(27)
            t75 = param(26)
            t76 = t16*t48*t75+t45*t46*t74+t42*t43*t73+t39*t40*t72+t36*t3
     1         7*t71+t33*t34*t70+t30*t31*t69+t27*t28*t68+t24*t25*t67+t21
     2         *t22*t66+t17*t19*t65+param(25)
            t77 = param(48)
            t78 = param(47)
            t79 = param(46)
            t80 = param(45)
            t81 = param(44)
            t82 = param(43)
            t83 = param(42)
            t84 = param(41)
            t85 = param(40)
            t86 = param(39)
            t87 = param(38)
            t88 = t16*t48*t87+t45*t46*t86+t42*t43*t85+t39*t40*t84+t36*t3
     1         7*t83+t33*t34*t82+t30*t31*t81+t27*t28*t80+t24*t25*t79+t21
     2         *t22*t78+t17*t19*t77+param(37)
            t89 = 1/t18**12
            t90 = -1.6711932865267184d+2*t13*t17*t89*t9+1.51926662411519
     1         86d+1*t47*t48*t9-1.5192666241151986d+1*t16*t46*t47*t9+3.0
     2         38533248230397d+1*t16*t44*t46*t9-3.038533248230397d+1*t43
     3         *t44*t45*t9+4.5577998723455965d+1*t41*t43*t45*t9-4.557799
     4         8723455965d+1*t40*t41*t42*t9+6.077066496460795d+1*t38*t40
     5         *t42*t9-6.077066496460795d+1*t37*t38*t39*t9+7.59633312057
     6         5993d+1*t35*t37*t39*t9-7.596333120575993d+1*t34*t35*t36*t
     7         9+9.115599744691193d+1*t32*t34*t36*t9-9.115599744691193d+
     8         1*t31*t32*t33*t9+1.0634866368806391d+2*t29*t31*t33*t9-1.0
     9         634866368806391d+2*t28*t29*t30*t9+1.2154132992921589d+2*t
     :         26*t28*t30*t9-1.2154132992921589d+2*t25*t26*t27*t9+1.3673
     ;         399617036788d+2*t23*t25*t27*t9-1.3673399617036788d+2*t22*
     <         t23*t24*t9+1.5192666241151986d+2*t20*t22*t24*t9-1.5192666
     =         241151986d+2*t19*t20*t21*t9+1.6711932865267184d+2*t13*t19
     >         *t21*t9
            t91 = -1.6711932865267184d+2*t17*t52*t89*t9+1.51926662411519
     1         86d+1*t48*t62*t9-1.5192666241151986d+1*t16*t46*t62*t9+3.0
     2         38533248230397d+1*t16*t46*t61*t9-3.038533248230397d+1*t43
     3         *t45*t61*t9+4.5577998723455965d+1*t43*t45*t60*t9-4.557799
     4         8723455965d+1*t40*t42*t60*t9+6.077066496460795d+1*t40*t42
     5         *t59*t9-6.077066496460795d+1*t37*t39*t59*t9+7.59633312057
     6         5993d+1*t37*t39*t58*t9-7.596333120575993d+1*t34*t36*t58*t
     7         9+9.115599744691193d+1*t34*t36*t57*t9-9.115599744691193d+
     8         1*t31*t33*t57*t9+1.0634866368806391d+2*t31*t33*t56*t9-1.0
     9         634866368806391d+2*t28*t30*t56*t9+1.2154132992921589d+2*t
     :         28*t30*t55*t9-1.2154132992921589d+2*t25*t27*t55*t9+1.3673
     ;         399617036788d+2*t25*t27*t54*t9-1.3673399617036788d+2*t22*
     <         t24*t54*t9+1.5192666241151986d+2*t22*t24*t53*t9-1.5192666
     =         241151986d+2*t19*t21*t53*t9+1.6711932865267184d+2*t19*t21
     >         *t52*t9
            t92 = -1.6711932865267184d+2*t17*t65*t89*t9+1.51926662411519
     1         86d+1*t48*t75*t9-1.5192666241151986d+1*t16*t46*t75*t9+3.0
     2         38533248230397d+1*t16*t46*t74*t9-3.038533248230397d+1*t43
     3         *t45*t74*t9+4.5577998723455965d+1*t43*t45*t73*t9-4.557799
     4         8723455965d+1*t40*t42*t73*t9+6.077066496460795d+1*t40*t42
     5         *t72*t9-6.077066496460795d+1*t37*t39*t72*t9+7.59633312057
     6         5993d+1*t37*t39*t71*t9-7.596333120575993d+1*t34*t36*t71*t
     7         9+9.115599744691193d+1*t34*t36*t70*t9-9.115599744691193d+
     8         1*t31*t33*t70*t9+1.0634866368806391d+2*t31*t33*t69*t9-1.0
     9         634866368806391d+2*t28*t30*t69*t9+1.2154132992921589d+2*t
     :         28*t30*t68*t9-1.2154132992921589d+2*t25*t27*t68*t9+1.3673
     ;         399617036788d+2*t25*t27*t67*t9-1.3673399617036788d+2*t22*
     <         t24*t67*t9+1.5192666241151986d+2*t22*t24*t66*t9-1.5192666
     =         241151986d+2*t19*t21*t66*t9+1.6711932865267184d+2*t19*t21
     >         *t65*t9
            t93 = -1.6711932865267184d+2*t17*t77*t89*t9+1.51926662411519
     1         86d+1*t48*t87*t9-1.5192666241151986d+1*t16*t46*t87*t9+3.0
     2         38533248230397d+1*t16*t46*t86*t9-3.038533248230397d+1*t43
     3         *t45*t86*t9+4.5577998723455965d+1*t43*t45*t85*t9-4.557799
     4         8723455965d+1*t40*t42*t85*t9+6.077066496460795d+1*t40*t42
     5         *t84*t9-6.077066496460795d+1*t37*t39*t84*t9+7.59633312057
     6         5993d+1*t37*t39*t83*t9-7.596333120575993d+1*t34*t36*t83*t
     7         9+9.115599744691193d+1*t34*t36*t82*t9-9.115599744691193d+
     8         1*t31*t33*t82*t9+1.0634866368806391d+2*t31*t33*t81*t9-1.0
     9         634866368806391d+2*t28*t30*t81*t9+1.2154132992921589d+2*t
     :         28*t30*t80*t9-1.2154132992921589d+2*t25*t27*t80*t9+1.3673
     ;         399617036788d+2*t25*t27*t79*t9-1.3673399617036788d+2*t22*
     <         t24*t79*t9+1.5192666241151986d+2*t22*t24*t78*t9-1.5192666
     =         241151986d+2*t19*t21*t78*t9+1.6711932865267184d+2*t19*t21
     >         *t77*t9
            t94 = 1/t2**2
            t95 = 1/rhob**2.3333333333333334d+0
            t96 = 1/t4
            t97 = rhob**2
            t98 = 1/t97
            t99 = 2.63857249068588d-4*t98-4.2759414617680735d-2*t96
            t100 = 5.641895835477563d-1
            t101 = 1/t9
            t102 = t10*t99-2.63857249068588d-4*t98+6.41391219265211d-2*t
     1         96-1.6205510657228786d+2*t10*t6*t8+3.6846026734116505d+1*
     2         t10*t100*t101
            t103 = 1.4253138205893576d-2*t11*t96-4.275941461768073d-2*t1
     1         02*t6
            t104 = 1/rhob**3.6666666666666664d+0
            t105 = 1.2407009817988002d+0*t12*t5-1.2407009817988002d+0*t5
     1         +9.305257363491002d-1*t103*t4
            t106 = -2.2d+1*t13*t17*t89-2.0d+0*t47*t48-2.0d+0*t16*t46*t47
     1         -4.0d+0*t16*t44*t46-4.0d+0*t43*t44*t45-6.0d+0*t41*t43*t45
     2         -6.0d+0*t40*t41*t42-8.0d+0*t38*t40*t42-8.0d+0*t37*t38*t39
     3         -1.0d+1*t35*t37*t39-1.0d+1*t34*t35*t36-1.2d+1*t32*t34*t36
     4         -1.2d+1*t31*t32*t33-1.4d+1*t29*t31*t33-1.4d+1*t28*t29*t30
     5         -1.6d+1*t26*t28*t30-1.6d+1*t25*t26*t27-1.8d+1*t23*t25*t27
     6         -1.8d+1*t22*t23*t24-2.0d+1*t20*t22*t24-2.0d+1*t19*t20*t21
     7         -2.2d+1*t13*t19*t21
            t107 = -2.2d+1*t17*t52*t89-2.0d+0*t48*t62-2.0d+0*t16*t46*t62
     1         -4.0d+0*t16*t46*t61-4.0d+0*t43*t45*t61-6.0d+0*t43*t45*t60
     2         -6.0d+0*t40*t42*t60-8.0d+0*t40*t42*t59-8.0d+0*t37*t39*t59
     3         -1.0d+1*t37*t39*t58-1.0d+1*t34*t36*t58-1.2d+1*t34*t36*t57
     4         -1.2d+1*t31*t33*t57-1.4d+1*t31*t33*t56-1.4d+1*t28*t30*t56
     5         -1.6d+1*t28*t30*t55-1.6d+1*t25*t27*t55-1.8d+1*t25*t27*t54
     6         -1.8d+1*t22*t24*t54-2.0d+1*t22*t24*t53-2.0d+1*t19*t21*t53
     7         -2.2d+1*t19*t21*t52
            t108 = -2.2d+1*t17*t65*t89-2.0d+0*t48*t75-2.0d+0*t16*t46*t75
     1         -4.0d+0*t16*t46*t74-4.0d+0*t43*t45*t74-6.0d+0*t43*t45*t73
     2         -6.0d+0*t40*t42*t73-8.0d+0*t40*t42*t72-8.0d+0*t37*t39*t72
     3         -1.0d+1*t37*t39*t71-1.0d+1*t34*t36*t71-1.2d+1*t34*t36*t70
     4         -1.2d+1*t31*t33*t70-1.4d+1*t31*t33*t69-1.4d+1*t28*t30*t69
     5         -1.6d+1*t28*t30*t68-1.6d+1*t25*t27*t68-1.8d+1*t25*t27*t67
     6         -1.8d+1*t22*t24*t67-2.0d+1*t22*t24*t66-2.0d+1*t19*t21*t66
     7         -2.2d+1*t19*t21*t65
            t109 = -2.2d+1*t17*t77*t89-2.0d+0*t48*t87-2.0d+0*t16*t46*t87
     1         -4.0d+0*t16*t46*t86-4.0d+0*t43*t45*t86-6.0d+0*t43*t45*t85
     2         -6.0d+0*t40*t42*t85-8.0d+0*t40*t42*t84-8.0d+0*t37*t39*t84
     3         -1.0d+1*t37*t39*t83-1.0d+1*t34*t36*t83-1.2d+1*t34*t36*t82
     4         -1.2d+1*t31*t33*t82-1.4d+1*t31*t33*t81-1.4d+1*t28*t30*t81
     5         -1.6d+1*t28*t30*t80-1.6d+1*t25*t27*t80-1.8d+1*t25*t27*t79
     6         -1.8d+1*t22*t24*t79-2.0d+1*t22*t24*t78-2.0d+1*t19*t21*t78
     7         -2.2d+1*t19*t21*t77
            t110 = 1/t18**13
            t111 = -1.1141288576844789d+2*t13*t17*t6*t89+2.5389881826654
     1         315d+4*t20*t21*t4*t89-5.585774001863949d+4*t13*t21*t4*t89
     2         +1.0128444160767991d+1*t47*t48*t6-1.0128444160767991d+1*t
     3         16*t46*t47*t6+2.0256888321535982d+1*t16*t44*t46*t6-2.0256
     4         888321535982d+1*t43*t44*t45*t6+3.038533248230397d+1*t41*t
     5         43*t45*t6-3.038533248230397d+1*t40*t41*t42*t6+4.051377664
     6         3071964d+1*t38*t40*t42*t6-4.0513776643071964d+1*t37*t38*t
     7         39*t6+5.064222080383994d+1*t35*t37*t39*t6-5.0642220803839
     8         94d+1*t34*t35*t36*t6+6.077066496460795d+1*t32*t34*t36*t6-
     9         6.077066496460795d+1*t31*t32*t33*t6+7.089910912537593d+1*
     :         t29*t31*t33*t6-7.089910912537593d+1*t28*t29*t30*t6+8.1027
     ;         55328614393d+1*t26*t28*t30*t6-8.102755328614393d+1*t25*t2
     <         6*t27*t6+9.115599744691191d+1*t23*t25*t27*t6-9.1155997446
     =         91191d+1*t22*t23*t24*t6+1.012844416076799d+2*t20*t22*t24*
     >         t6-1.012844416076799d+2*t19*t20*t21*t6+1.1141288576844789
     ?         d+2*t13*t19*t21*t6-4.6163421503007845d+2*t4*t46*t47+4.616
     @         3421503007845d+2*t16*t4*t43*t47+4.6163421503007845d+2*t4*
     1         t44*t46+1.3849026450902355d+3*t4*t40*t44*t45-4.1547079352
     2         707067d+3*t4*t40*t41*t45+2.769805290180471d+3*t38*t4*t40*
     3         t45-1.846536860120314d+3*t16*t4*t43*t44+1.384902645090235
     4         5d+3*t16*t4*t41*t43+2.769805290180471d+3*t37*t4*t41*t42-7
     5         .386147440481255d+3*t37*t38*t4*t42+4.616342150300784d+3*t
     6         35*t37*t4*t42+4.616342150300784d+3*t34*t38*t39*t4-1.15408
     7         5537575196d+4*t34*t35*t39*t4+6.924513225451178d+3*t32*t34
     8         *t39*t4+6.924513225451178d+3*t31*t35*t36*t4-1.66188317410
     9         8283d+4*t31*t32*t36*t4+9.694318515631648d+3*t29*t31*t36*t
     :         4+9.694318515631648d+3*t28*t32*t33*t4-2.2620076536473846d
     ;         +4*t28*t29*t33*t4+1.2925758020842196d+4*t26*t28*t33*t4+1.
     <         2925758020842196d+4*t25*t29*t30*t4-2.954458976192502d+4*t
     =         25*t26*t30*t4+1.6618831741082823d+4*t23*t25*t30*t4+1.6618
     >         831741082823d+4*t22*t26*t27*t4-3.7392371417436354d+4*t22*
     ?         t23*t27*t4+2.0773539676353528d+4*t20*t22*t27*t4+2.0773539
     @         676353528d+4*t19*t23*t24*t4-4.616342150300784d+4*t19*t20*
     1         t24*t4+2.5389881826654315d+4*t13*t19*t24*t4+3.04678581919
     2         8518d+4*t110*t13*t17*t4
            t112 = -1.1141288576844789d+2*t17*t52*t6*t89+2.5389881826654
     1         315d+4*t21*t4*t53*t89-5.585774001863949d+4*t21*t4*t52*t89
     2         +1.0128444160767991d+1*t48*t6*t62-1.0128444160767991d+1*t
     3         16*t46*t6*t62-4.6163421503007845d+2*t4*t46*t62+4.61634215
     4         03007845d+2*t16*t4*t43*t62+2.0256888321535982d+1*t16*t46*
     5         t6*t61-2.0256888321535982d+1*t43*t45*t6*t61+4.61634215030
     6         07845d+2*t4*t46*t61+1.3849026450902355d+3*t4*t40*t45*t61-
     7         1.846536860120314d+3*t16*t4*t43*t61+3.038533248230397d+1*
     8         t43*t45*t6*t60-3.038533248230397d+1*t40*t42*t6*t60-4.1547
     9         079352707067d+3*t4*t40*t45*t60+1.3849026450902355d+3*t16*
     :         t4*t43*t60+2.769805290180471d+3*t37*t4*t42*t60+4.05137766
     ;         43071964d+1*t40*t42*t59*t6-4.0513776643071964d+1*t37*t39*
     <         t59*t6+5.064222080383994d+1*t37*t39*t58*t6-5.064222080383
     =         994d+1*t34*t36*t58*t6+6.077066496460795d+1*t34*t36*t57*t6
     >         -6.077066496460795d+1*t31*t33*t57*t6+7.089910912537593d+1
     ?         *t31*t33*t56*t6-7.089910912537593d+1*t28*t30*t56*t6+8.102
     @         755328614393d+1*t28*t30*t55*t6-8.102755328614393d+1*t25*t
     1         27*t55*t6+9.115599744691191d+1*t25*t27*t54*t6-9.115599744
     2         691191d+1*t22*t24*t54*t6+1.012844416076799d+2*t22*t24*t53
     3         *t6-1.012844416076799d+2*t19*t21*t53*t6+1.114128857684478
     4         9d+2*t19*t21*t52*t6+2.769805290180471d+3*t4*t40*t45*t59-7
     5         .386147440481255d+3*t37*t4*t42*t59+4.616342150300784d+3*t
     6         34*t39*t4*t59+4.616342150300784d+3*t37*t4*t42*t58-1.15408
     7         5537575196d+4*t34*t39*t4*t58+6.924513225451178d+3*t31*t36
     8         *t4*t58+6.924513225451178d+3*t34*t39*t4*t57-1.66188317410
     9         8283d+4*t31*t36*t4*t57+9.694318515631648d+3*t28*t33*t4*t5
     :         7+9.694318515631648d+3*t31*t36*t4*t56-2.2620076536473846d
     ;         +4*t28*t33*t4*t56+1.2925758020842196d+4*t25*t30*t4*t56+1.
     <         2925758020842196d+4*t28*t33*t4*t55-2.954458976192502d+4*t
     =         25*t30*t4*t55+1.6618831741082823d+4*t22*t27*t4*t55+1.6618
     >         831741082823d+4*t25*t30*t4*t54-3.7392371417436354d+4*t22*
     ?         t27*t4*t54+2.0773539676353528d+4*t19*t24*t4*t54+2.0773539
     @         676353528d+4*t22*t27*t4*t53-4.616342150300784d+4*t19*t24*
     1         t4*t53+2.5389881826654315d+4*t19*t24*t4*t52+3.04678581919
     2         8518d+4*t110*t17*t4*t52
            t113 = 2.5389881826654315d+4*t21*t4*t66*t89-1.11412885768447
     1         89d+2*t17*t6*t65*t89-5.585774001863949d+4*t21*t4*t65*t89+
     2         1.0128444160767991d+1*t48*t6*t75-1.0128444160767991d+1*t1
     3         6*t46*t6*t75-4.6163421503007845d+2*t4*t46*t75+4.616342150
     4         3007845d+2*t16*t4*t43*t75+2.0256888321535982d+1*t16*t46*t
     5         6*t74-2.0256888321535982d+1*t43*t45*t6*t74+4.616342150300
     6         7845d+2*t4*t46*t74+1.3849026450902355d+3*t4*t40*t45*t74-1
     7         .846536860120314d+3*t16*t4*t43*t74+3.038533248230397d+1*t
     8         43*t45*t6*t73-3.038533248230397d+1*t40*t42*t6*t73-4.15470
     9         79352707067d+3*t4*t40*t45*t73+1.3849026450902355d+3*t16*t
     :         4*t43*t73+2.769805290180471d+3*t37*t4*t42*t73+4.051377664
     ;         3071964d+1*t40*t42*t6*t72-4.0513776643071964d+1*t37*t39*t
     <         6*t72+2.769805290180471d+3*t4*t40*t45*t72-7.3861474404812
     =         55d+3*t37*t4*t42*t72+4.616342150300784d+3*t34*t39*t4*t72+
     >         5.064222080383994d+1*t37*t39*t6*t71-5.064222080383994d+1*
     ?         t34*t36*t6*t71+4.616342150300784d+3*t37*t4*t42*t71-1.1540
     @         85537575196d+4*t34*t39*t4*t71+6.924513225451178d+3*t31*t3
     1         6*t4*t71+6.077066496460795d+1*t34*t36*t6*t70-6.0770664964
     2         60795d+1*t31*t33*t6*t70+6.924513225451178d+3*t34*t39*t4*t
     3         70-1.661883174108283d+4*t31*t36*t4*t70+9.694318515631648d
     4         +3*t28*t33*t4*t70+7.089910912537593d+1*t31*t33*t6*t69-7.0
     5         89910912537593d+1*t28*t30*t6*t69+9.694318515631648d+3*t31
     6         *t36*t4*t69-2.2620076536473846d+4*t28*t33*t4*t69+1.292575
     7         8020842196d+4*t25*t30*t4*t69+8.102755328614393d+1*t28*t30
     8         *t6*t68-8.102755328614393d+1*t25*t27*t6*t68+1.29257580208
     9         42196d+4*t28*t33*t4*t68-2.954458976192502d+4*t25*t30*t4*t
     :         68+1.6618831741082823d+4*t22*t27*t4*t68+9.115599744691191
     ;         d+1*t25*t27*t6*t67-9.115599744691191d+1*t22*t24*t6*t67+1.
     <         6618831741082823d+4*t25*t30*t4*t67-3.7392371417436354d+4*
     =         t22*t27*t4*t67+2.0773539676353528d+4*t19*t24*t4*t67+1.012
     >         844416076799d+2*t22*t24*t6*t66-1.012844416076799d+2*t19*t
     ?         21*t6*t66+2.0773539676353528d+4*t22*t27*t4*t66-4.61634215
     @         0300784d+4*t19*t24*t4*t66+1.1141288576844789d+2*t19*t21*t
     1         6*t65+2.5389881826654315d+4*t19*t24*t4*t65+3.046785819198
     2         518d+4*t110*t17*t4*t65
            t114 = 2.5389881826654315d+4*t21*t4*t78*t89-1.11412885768447
     1         89d+2*t17*t6*t77*t89-5.585774001863949d+4*t21*t4*t77*t89+
     2         1.0128444160767991d+1*t48*t6*t87-1.0128444160767991d+1*t1
     3         6*t46*t6*t87-4.6163421503007845d+2*t4*t46*t87+4.616342150
     4         3007845d+2*t16*t4*t43*t87+2.0256888321535982d+1*t16*t46*t
     5         6*t86-2.0256888321535982d+1*t43*t45*t6*t86+4.616342150300
     6         7845d+2*t4*t46*t86+1.3849026450902355d+3*t4*t40*t45*t86-1
     7         .846536860120314d+3*t16*t4*t43*t86+3.038533248230397d+1*t
     8         43*t45*t6*t85-3.038533248230397d+1*t40*t42*t6*t85-4.15470
     9         79352707067d+3*t4*t40*t45*t85+1.3849026450902355d+3*t16*t
     :         4*t43*t85+2.769805290180471d+3*t37*t4*t42*t85+4.051377664
     ;         3071964d+1*t40*t42*t6*t84-4.0513776643071964d+1*t37*t39*t
     <         6*t84+2.769805290180471d+3*t4*t40*t45*t84-7.3861474404812
     =         55d+3*t37*t4*t42*t84+4.616342150300784d+3*t34*t39*t4*t84+
     >         5.064222080383994d+1*t37*t39*t6*t83-5.064222080383994d+1*
     ?         t34*t36*t6*t83+4.616342150300784d+3*t37*t4*t42*t83-1.1540
     @         85537575196d+4*t34*t39*t4*t83+6.924513225451178d+3*t31*t3
     1         6*t4*t83+6.077066496460795d+1*t34*t36*t6*t82-6.0770664964
     2         60795d+1*t31*t33*t6*t82+6.924513225451178d+3*t34*t39*t4*t
     3         82-1.661883174108283d+4*t31*t36*t4*t82+9.694318515631648d
     4         +3*t28*t33*t4*t82+7.089910912537593d+1*t31*t33*t6*t81-7.0
     5         89910912537593d+1*t28*t30*t6*t81+9.694318515631648d+3*t31
     6         *t36*t4*t81-2.2620076536473846d+4*t28*t33*t4*t81+1.292575
     7         8020842196d+4*t25*t30*t4*t81+8.102755328614393d+1*t28*t30
     8         *t6*t80-8.102755328614393d+1*t25*t27*t6*t80+1.29257580208
     9         42196d+4*t28*t33*t4*t80-2.954458976192502d+4*t25*t30*t4*t
     :         80+1.6618831741082823d+4*t22*t27*t4*t80+9.115599744691191
     ;         d+1*t25*t27*t6*t79-9.115599744691191d+1*t22*t24*t6*t79+1.
     <         6618831741082823d+4*t25*t30*t4*t79-3.7392371417436354d+4*
     =         t22*t27*t4*t79+2.0773539676353528d+4*t19*t24*t4*t79+1.012
     >         844416076799d+2*t22*t24*t6*t78-1.012844416076799d+2*t19*t
     ?         21*t6*t78+2.0773539676353528d+4*t22*t27*t4*t78-4.61634215
     @         0300784d+4*t19*t24*t4*t78+1.1141288576844789d+2*t19*t21*t
     1         6*t77+2.5389881826654315d+4*t19*t24*t4*t77+3.046785819198
     2         518d+4*t110*t17*t4*t77
            t115 = gammabb**2
            t116 = 1/t2**3
            t117 = 1/rhob**6
            t118 = 1/rhob**3.3333333333333337d+0
            t119 = 1/rhob**3
            t120 = 5.701255282357431d-2*t95-5.27714498137176d-4*t119
            t121 = 1/t14
            t122 = -3.241102131445757d+2*t10*t6*t99+5.401836885742928d+1
     1         *t10*t8*t96-8.551882923536147d-2*t95+2.626185756615557d+4
     2         *t10*t101*t8-5.971086789162617d+3*t10*t100*t7-2.456401782
     3         2744336d+1*t10*t100*t121+t10*t120+5.27714498137176d-4*t11
     4         9
            t123 = 2.850627641178715d-2*t102*t96-1.9004184274524766d-2*t
     1         11*t95-4.275941461768073d-2*t122*t6
            t124 = 1/rhob**7.333333333333333d+0
            t125 = 1/rhob**4.666666666666667d+0
            t126 = 2.4814019635976003d+0*t103*t5+9.305257363491002d-1*t1
     1         23*t4+4.135669939329334d-1*t101*t12-4.135669939329334d-1*
     2         t101
            t127 = 1.7926167019779404d-2*gammabb*t12*t90+1.7926167019779
     1         404d-2*gammabb*t103*t49
            t128 = -4.135669939329334d-1*t12*t51*t63-4.135669939329334d-
     1         1*t12*t3*t49
            t129 = 1.0082032889066277d-2*gammabb*t12*t50*t91+1.008203288
     1         9066277d-2*gammabb*t103*t50*t63
            t130 = -1.9264558001493193d-2*gammabb*t64*t92-1.926455800149
     1         3193d-2*gammabb*t105*t76
            t131 = -1.0834770598202839d-2*gammabb*t50*t64*t93-1.08347705
     1         98202839d-2*gammabb*t105*t50*t88
            t132 = 1/rhob**5
            t133 = 1/rhob**6.333333333333333d+0
            t134 = -3.361156316208638d-3*t12*t90-3.361156316208638d-3*t1
     1         03*t49
            t135 = 3.612104625279974d-3*t64*t92+3.612104625279974d-3*t10
     1         5*t76
            t136 = 1/rhob**4
            t137 = 1/rhob**5.333333333333333d+0
            t138 = 3.342386573053437d+3*t20*t21*t89*t9+6.077066496460795
     1         d+1*t16*t43*t47*t9-6.077066496460795d+1*t44*t46*t9+1.8231
     2         199489382385d+2*t40*t44*t45*t9-3.646239897876477d+2*t38*t
     3         40*t45*t9-1.8231199489382385d+2*t16*t41*t43*t9+3.64623989
     4         7876477d+2*t37*t41*t42*t9-6.077066496460795d+2*t35*t37*t4
     5         2*t9+6.077066496460795d+2*t34*t38*t39*t9-9.11559974469119
     6         2d+2*t32*t34*t39*t9+9.115599744691192d+2*t31*t35*t36*t9-1
     7         .276183964256767d+3*t29*t31*t36*t9+1.276183964256767d+3*t
     8         28*t32*t33*t9-1.7015786190090226d+3*t26*t28*t33*t9+1.7015
     9         786190090226d+3*t25*t29*t30*t9-2.187743938725886d+3*t23*t
     :         25*t30*t9+2.187743938725886d+3*t22*t26*t27*t9-2.734679923
     ;         407357d+3*t20*t22*t27*t9+2.734679923407357d+3*t19*t23*t24
     <         *t9-3.342386573053437d+3*t13*t19*t24*t9+4.010863887664124
     =         5d+3*t110*t13*t17*t9
            t139 = 3.342386573053437d+3*t21*t53*t89*t9+6.077066496460795
     1         d+1*t16*t43*t62*t9-6.077066496460795d+1*t46*t61*t9+1.8231
     2         199489382385d+2*t40*t45*t61*t9-1.8231199489382385d+2*t16*
     3         t43*t60*t9+3.646239897876477d+2*t37*t42*t60*t9-3.64623989
     4         7876477d+2*t40*t45*t59*t9+6.077066496460795d+2*t34*t39*t5
     5         9*t9-6.077066496460795d+2*t37*t42*t58*t9+9.11559974469119
     6         2d+2*t31*t36*t58*t9-9.115599744691192d+2*t34*t39*t57*t9+1
     7         .276183964256767d+3*t28*t33*t57*t9-1.276183964256767d+3*t
     8         31*t36*t56*t9+1.7015786190090226d+3*t25*t30*t56*t9-1.7015
     9         786190090226d+3*t28*t33*t55*t9+2.187743938725886d+3*t22*t
     :         27*t55*t9-2.187743938725886d+3*t25*t30*t54*t9+2.734679923
     ;         407357d+3*t19*t24*t54*t9-2.734679923407357d+3*t22*t27*t53
     <         *t9-3.342386573053437d+3*t19*t24*t52*t9+4.010863887664124
     =         5d+3*t110*t17*t52*t9
            t140 = 3.342386573053437d+3*t21*t66*t89*t9+6.077066496460795
     1         d+1*t16*t43*t75*t9-6.077066496460795d+1*t46*t74*t9+1.8231
     2         199489382385d+2*t40*t45*t74*t9-1.8231199489382385d+2*t16*
     3         t43*t73*t9+3.646239897876477d+2*t37*t42*t73*t9-3.64623989
     4         7876477d+2*t40*t45*t72*t9+6.077066496460795d+2*t34*t39*t7
     5         2*t9-6.077066496460795d+2*t37*t42*t71*t9+9.11559974469119
     6         2d+2*t31*t36*t71*t9-9.115599744691192d+2*t34*t39*t70*t9+1
     7         .276183964256767d+3*t28*t33*t70*t9-1.276183964256767d+3*t
     8         31*t36*t69*t9+1.7015786190090226d+3*t25*t30*t69*t9-1.7015
     9         786190090226d+3*t28*t33*t68*t9+2.187743938725886d+3*t22*t
     :         27*t68*t9-2.187743938725886d+3*t25*t30*t67*t9+2.734679923
     ;         407357d+3*t19*t24*t67*t9-2.734679923407357d+3*t22*t27*t66
     <         *t9-3.342386573053437d+3*t19*t24*t65*t9+4.010863887664124
     =         5d+3*t110*t17*t65*t9
            t141 = 3.342386573053437d+3*t21*t78*t89*t9+6.077066496460795
     1         d+1*t16*t43*t87*t9-6.077066496460795d+1*t46*t86*t9+1.8231
     2         199489382385d+2*t40*t45*t86*t9-1.8231199489382385d+2*t16*
     3         t43*t85*t9+3.646239897876477d+2*t37*t42*t85*t9-3.64623989
     4         7876477d+2*t40*t45*t84*t9+6.077066496460795d+2*t34*t39*t8
     5         4*t9-6.077066496460795d+2*t37*t42*t83*t9+9.11559974469119
     6         2d+2*t31*t36*t83*t9-9.115599744691192d+2*t34*t39*t82*t9+1
     7         .276183964256767d+3*t28*t33*t82*t9-1.276183964256767d+3*t
     8         31*t36*t81*t9+1.7015786190090226d+3*t25*t30*t81*t9-1.7015
     9         786190090226d+3*t28*t33*t80*t9+2.187743938725886d+3*t22*t
     :         27*t80*t9-2.187743938725886d+3*t25*t30*t79*t9+2.734679923
     ;         407357d+3*t19*t24*t79*t9-2.734679923407357d+3*t22*t27*t78
     <         *t9-3.342386573053437d+3*t19*t24*t77*t9+4.010863887664124
     =         5d+3*t110*t17*t77*t9
            t142 = 4.4d+2*t20*t21*t89+9.68d+2*t13*t21*t89+8.0d+0*t46*t47
     1         +8.0d+0*t16*t43*t47+8.0d+0*t44*t46+2.4d+1*t40*t44*t45+7.2
     2         d+1*t40*t41*t45+4.8d+1*t38*t40*t45+3.2d+1*t16*t43*t44+2.4
     3         d+1*t16*t41*t43+4.8d+1*t37*t41*t42+1.28d+2*t37*t38*t42+8.
     4         0d+1*t35*t37*t42+8.0d+1*t34*t38*t39+2.0d+2*t34*t35*t39+1.
     5         2d+2*t32*t34*t39+1.2d+2*t31*t35*t36+2.88d+2*t31*t32*t36+1
     6         .68d+2*t29*t31*t36+1.68d+2*t28*t32*t33+3.92d+2*t28*t29*t3
     7         3+2.24d+2*t26*t28*t33+2.24d+2*t25*t29*t30+5.12d+2*t25*t26
     8         *t30+2.88d+2*t23*t25*t30+2.88d+2*t22*t26*t27+6.48d+2*t22*
     9         t23*t27+3.6d+2*t20*t22*t27+3.6d+2*t19*t23*t24+8.0d+2*t19*
     :         t20*t24+4.4d+2*t13*t19*t24+5.28d+2*t110*t13*t17
            t143 = 4.4d+2*t21*t53*t89+9.68d+2*t21*t52*t89+8.0d+0*t46*t62
     1         +8.0d+0*t16*t43*t62+8.0d+0*t46*t61+2.4d+1*t40*t45*t61+3.2
     2         d+1*t16*t43*t61+7.2d+1*t40*t45*t60+2.4d+1*t16*t43*t60+4.8
     3         d+1*t37*t42*t60+4.8d+1*t40*t45*t59+1.28d+2*t37*t42*t59+8.
     4         0d+1*t34*t39*t59+8.0d+1*t37*t42*t58+2.0d+2*t34*t39*t58+1.
     5         2d+2*t31*t36*t58+1.2d+2*t34*t39*t57+2.88d+2*t31*t36*t57+1
     6         .68d+2*t28*t33*t57+1.68d+2*t31*t36*t56+3.92d+2*t28*t33*t5
     7         6+2.24d+2*t25*t30*t56+2.24d+2*t28*t33*t55+5.12d+2*t25*t30
     8         *t55+2.88d+2*t22*t27*t55+2.88d+2*t25*t30*t54+6.48d+2*t22*
     9         t27*t54+3.6d+2*t19*t24*t54+3.6d+2*t22*t27*t53+8.0d+2*t19*
     :         t24*t53+4.4d+2*t19*t24*t52+5.28d+2*t110*t17*t52
            t144 = 4.4d+2*t21*t66*t89+9.68d+2*t21*t65*t89+8.0d+0*t46*t75
     1         +8.0d+0*t16*t43*t75+8.0d+0*t46*t74+2.4d+1*t40*t45*t74+3.2
     2         d+1*t16*t43*t74+7.2d+1*t40*t45*t73+2.4d+1*t16*t43*t73+4.8
     3         d+1*t37*t42*t73+4.8d+1*t40*t45*t72+1.28d+2*t37*t42*t72+8.
     4         0d+1*t34*t39*t72+8.0d+1*t37*t42*t71+2.0d+2*t34*t39*t71+1.
     5         2d+2*t31*t36*t71+1.2d+2*t34*t39*t70+2.88d+2*t31*t36*t70+1
     6         .68d+2*t28*t33*t70+1.68d+2*t31*t36*t69+3.92d+2*t28*t33*t6
     7         9+2.24d+2*t25*t30*t69+2.24d+2*t28*t33*t68+5.12d+2*t25*t30
     8         *t68+2.88d+2*t22*t27*t68+2.88d+2*t25*t30*t67+6.48d+2*t22*
     9         t27*t67+3.6d+2*t19*t24*t67+3.6d+2*t22*t27*t66+8.0d+2*t19*
     :         t24*t66+4.4d+2*t19*t24*t65+5.28d+2*t110*t17*t65
            t145 = 4.4d+2*t21*t78*t89+9.68d+2*t21*t77*t89+8.0d+0*t46*t87
     1         +8.0d+0*t16*t43*t87+8.0d+0*t46*t86+2.4d+1*t40*t45*t86+3.2
     2         d+1*t16*t43*t86+7.2d+1*t40*t45*t85+2.4d+1*t16*t43*t85+4.8
     3         d+1*t37*t42*t85+4.8d+1*t40*t45*t84+1.28d+2*t37*t42*t84+8.
     4         0d+1*t34*t39*t84+8.0d+1*t37*t42*t83+2.0d+2*t34*t39*t83+1.
     5         2d+2*t31*t36*t83+1.2d+2*t34*t39*t82+2.88d+2*t31*t36*t82+1
     6         .68d+2*t28*t33*t82+1.68d+2*t31*t36*t81+3.92d+2*t28*t33*t8
     7         1+2.24d+2*t25*t30*t81+2.24d+2*t28*t33*t80+5.12d+2*t25*t30
     8         *t80+2.88d+2*t22*t27*t80+2.88d+2*t25*t30*t79+6.48d+2*t22*
     9         t27*t79+3.6d+2*t19*t24*t79+3.6d+2*t22*t27*t78+8.0d+2*t19*
     :         t24*t78+4.4d+2*t19*t24*t77+5.28d+2*t110*t17*t77
            t146 = 1/t18**14
            t147 = gammabb**3
            t148 = 1/t2**4
            t149 = 1/rhob**9.666666666666666d+0
            t150 = 1/rhob**7
            t151 = 1/rhob**4.333333333333333d+0
            t152 = -4.275941461768073d-2*t6*(1.6205510657228786d+2*t10*t
     1         96*t99+7.878557269846671d+4*t10*t101*t99+9.95181131527102
     2         9d+3*t10*t100*t98+9.676451059701281d+5*t10*t100*t96-7.202
     3         44918099057d+1*t10*t8*t95-4.255868126669586d+6*t10*t7*t8-
     4         2.626185756615557d+4*t10*t121*t8-4.8616531971686355d+2*t1
     5         0*t120*t6-1.5831434944115283d-3*t136+t10*(1.5831434944115
     6         283d-3*t136-1.330292899216734d-1*t118)+1.995439348825101d
     7         -1*t118+4.0940029704573894d+1*t1*t10*t100)+4.275941461768
     8         0724d-2*t122*t96-5.701255282357429d-2*t102*t95+4.43430966
     9         4055779d-2*t11*t118
            t153 = 1/rhob**11
            t154 = 1/rhob**8.333333333333334d+0
            t155 = 1/rhob**5.666666666666667d+0
            t156 = 3.7221029453964005d+0*t123*t5+9.305257363491002d-1*t1
     1         52*t4-2.7571132928862224d-1*t12*t121+2.7571132928862224d-
     2         1*t121+1.2407009817988002d+0*t101*t103
            t157 = 1/rhob**8.666666666666666d+0
            t158 = 1/rhob**10
            t159 = 1/rhob**7.666666666666667d+0
            t160 = 1/rhob**9
            t161 = 1/rhob**6.666666666666667d+0
            t162 = 1/rhob**8
            fnc(iq) = 1.0d+0*(t51*t64*t88+t3*t64*t76-9.305257363491002d-
     1         1*t12*t4*t51*t63-9.305257363491002d-1*t12*t3*t4*t49)*wght
     2         +fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*(8.963083509889702d-3*gammabb*t12*t4
     1         9*t94*t95+5.041016444533138d-3*gammabb*t12*t50*t63*t95-9.
     2         632279000746596d-3*gammabb*t104*t64*t76*t94+t51*t64*t93+t
     3         3*t64*t92-9.305257363491002d-1*t12*t4*t51*t91-9.305257363
     4         491002d-1*t12*t3*t4*t90-5.417385299101419d-3*gammabb*t104
     5         *t50*t64*t88+t105*t51*t88+t105*t3*t76-1.2407009817988002d
     6         +0*t12*t5*t51*t63-9.305257363491002d-1*t103*t4*t51*t63-1.
     7         2407009817988002d+0*t12*t3*t49*t5-9.305257363491002d-1*t1
     8         03*t3*t4*t49)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*(-3.361156316208638d-3*t12*t49*t94*
     1         t96-1.890381166699927d-3*t12*t50*t63*t96+3.61210462527997
     2         4d-3*t1*t64*t76*t94+2.0315194871630324d-3*t1*t50*t64*t88)
     3         *wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TB) = 1.0d+0*(t109*t51*t64+t108*t3*t64-9.30525736
     1         3491002d-1*t107*t12*t4*t51-9.305257363491002d-1*t106*t12*
     2         t3*t4)*wght+Mmat(iq,D1_TB)
            Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            Amat2(iq,D2_RB_RB) = 1.0d+0*(t127*t94*t95+t129*t95+3.5318356
     1         336070855d-2*gammabb*t125*t64*t76*t94-8.963083509889707d-
     2         3*gammabb*t118*t12*t49*t94+t104*t130*t94+2*t105*t51*t93+2
     3         *t105*t3*t92-2.4814019635976003d+0*t12*t5*t51*t91-1.86105
     4         14726982003d+0*t103*t4*t51*t91-2.4814019635976003d+0*t12*
     5         t3*t5*t90-1.8610514726982003d+0*t103*t3*t4*t90+1.98637460
     6         96705204d-2*gammabb*t125*t50*t64*t88-5.316678166471045d-5
     7         *t115*t124*t50*t64*t88+t126*t51*t88-2.3079800683637772d-4
     8         *t115*t116*t124*t64*t76+t126*t3*t76+t114*t51*t64+t113*t3*
     9         t64-2.4814019635976003d+0*t103*t5*t51*t63-9.3052573634910
     :         02d-1*t123*t4*t51*t63-5.041016444533138d-3*gammabb*t118*t
     ;         12*t50*t63+4.947305865786653d-5*t115*t117*t12*t50*t63-9.3
     <         05257363491002d-1*t112*t12*t4*t51-2.4814019635976003d+0*t
     =         103*t3*t49*t5-9.305257363491002d-1*t123*t3*t4*t49+2.14763
     >         48525932504d-4*t115*t116*t117*t12*t49-9.305257363491002d-
     ?         1*t111*t12*t3*t4+t104*t131+t101*t128)*wght+Amat2(iq,D2_RB
     @         _RB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*(t134*t94*t96+(-1.8903811666999
     1         27d-3*t12*t50*t91-1.890381166699927d-3*t103*t50*t63)*t96+
     2         4.481541754944851d-3*t12*t49*t94*t95+2.520508222266569d-3
     3         *t12*t50*t63*t95-9.632279000746596d-3*t104*t64*t76*t94+t1
     4         *t135*t94+t1*(2.0315194871630324d-3*t50*t64*t93+2.0315194
     5         871630324d-3*t105*t50*t88)+1.9937543124266421d-5*gammabb*
     6         t133*t50*t64*t88-5.417385299101419d-3*t104*t50*t64*t88+8.
     7         654925256364164d-5*gammabb*t116*t133*t64*t76-1.8552396996
     8         69995d-5*gammabb*t12*t132*t50*t63-8.05363069722469d-5*gam
     9         mabb*t116*t12*t132*t49)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*(-7.476578671599909d-6*t137*t5
     1         0*t64*t88-3.245596971136562d-5*t116*t137*t64*t76+6.957148
     2         873762482d-6*t12*t136*t50*t63+3.020111511459258d-5*t116*t
     3         12*t136*t49)*wght+Cmat2(iq,D2_GBB_GBB)
            Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = 1.0d+0*(8.963083509889702d-3*gammabb*t1
     1         06*t12*t94*t95+5.041016444533138d-3*gammabb*t107*t12*t50*
     2         t95-9.632279000746596d-3*gammabb*t104*t108*t64*t94+t141*t
     3         51*t64-5.417385299101419d-3*gammabb*t104*t109*t50*t64+t14
     4         0*t3*t64-1.2407009817988002d+0*t107*t12*t5*t51-9.30525736
     5         3491002d-1*t12*t139*t4*t51-9.305257363491002d-1*t103*t107
     6         *t4*t51+t105*t109*t51-1.2407009817988002d+0*t106*t12*t3*t
     7         5-9.305257363491002d-1*t12*t138*t3*t4-9.305257363491002d-
     8         1*t103*t106*t3*t4+t105*t108*t3)*wght+Mmat2(iq,D2_RB_TB)
            Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = 1.0d+0*(-3.361156316208638d-3*t106*t12
     1         *t94*t96-1.890381166699927d-3*t107*t12*t50*t96+3.61210462
     2         5279974d-3*t1*t108*t64*t94+2.0315194871630324d-3*t1*t109*
     3         t50*t64)*wght+Mmat2(iq,D2_GBB_TB)
            Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = 1.0d+0*(t145*t51*t64+t144*t3*t64-9.3052
     1         57363491002d-1*t12*t143*t4*t51-9.305257363491002d-1*t12*t
     2         142*t3*t4)*wght+Mmat2(iq,D2_TB_TB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*(t51*t64*(-3.4716600044518436
     1         d+6*t24*t79*t89*t97+1.1572200014839477d+7*t24*t78*t89*t97
     2         -1.2729420016323426d+7*t24*t77*t89*t97+2.104036366334451d
     3         +4*t43*t87*t97-2.104036366334451d+4*t16*t40*t87*t97-8.416
     4         145465337804d+4*t37*t45*t86*t97-4.208072732668902d+4*t43*
     5         t86*t97+1.2624218198006704d+5*t16*t40*t86*t97+3.787265459
     6         402013d+5*t37*t45*t85*t97+2.104036366334451d+4*t43*t85*t9
     7         7-2.104036366334451d+5*t34*t42*t85*t97-1.8936327297010064
     8         d+5*t16*t40*t85*t97-5.049687279202681d+5*t37*t45*t84*t97+
     9         8.416145465337803d+5*t34*t42*t84*t97+8.416145465337804d+4
     :         *t16*t40*t84*t97-4.2080727326689016d+5*t31*t39*t84*t97+2.
     ;         1040363663344508d+5*t37*t45*t83*t97-1.0520181831672254d+6
     <         *t34*t42*t83*t97+1.578027274750838d+6*t31*t39*t83*t97-7.3
     =         64127282170578d+5*t28*t36*t83*t97+4.208072732668902d+5*t3
     >         4*t42*t82*t97-1.893632729701006d+6*t31*t39*t82*t97+2.6510
     ?         858215814087d+6*t28*t36*t82*t97-1.1782603651472927d+6*t25
     @         *t33*t82*t97+7.364127282170578d+5*t31*t39*t81*t97-3.09293
     1         34585116436d+6*t28*t36*t81*t97+4.123911278015524d+6*t25*t
     2         33*t81*t97-1.7673905477209387d+6*t22*t30*t81*t97+1.178260
     3         3651472927d+6*t28*t36*t80*t97-4.713041460589171d+6*t25*t3
     4         3*t80*t97+6.059624735043219d+6*t22*t30*t80*t97-2.52484363
     5         9601341d+6*t19*t27*t80*t97+1.767390547720939d+6*t25*t33*t
     6         79*t97-6.817077826923622d+6*t22*t30*t79*t97+8.52134728365
     7         4526d+6*t19*t27*t79*t97+2.524843639601341d+6*t22*t30*t78*
     8         t97-9.468163648505028d+6*t19*t27*t78*t97-4.62888000593579
     9         2d+6*t110*t21*t78*t97+3.4716600044518436d+6*t19*t27*t77*t
     :         97+1.5275304019588112d+7*t110*t21*t77*t97-6.0175440077165
     ;         3d+6*t146*t17*t77*t97+3.713762858948263d+1*t17*t77*t89*t9
     <         6-3.37614805358933d+0*t48*t87*t96+3.37614805358933d+0*t16
     =         *t46*t87*t96-6.75229610717866d+0*t16*t46*t86*t96+6.752296
     >         10717866d+0*t43*t45*t86*t96-1.0128444160767991d+1*t43*t45
     ?         *t85*t96+1.0128444160767991d+1*t40*t42*t85*t96-1.35045922
     @         1435732d+1*t40*t42*t84*t96+1.350459221435732d+1*t37*t39*t
     1         84*t96-1.6880740267946648d+1*t37*t39*t83*t96+1.6880740267
     2         946648d+1*t34*t36*t83*t96-2.0256888321535982d+1*t34*t36*t
     3         82*t96+2.0256888321535982d+1*t31*t33*t82*t96-2.3633036375
     4         125308d+1*t31*t33*t81*t96+2.3633036375125308d+1*t28*t30*t
     5         81*t96-2.700918442871464d+1*t28*t30*t80*t96+2.70091844287
     6         1464d+1*t25*t27*t80*t96-3.0385332482303967d+1*t25*t27*t79
     7         *t96+3.0385332482303967d+1*t22*t24*t79*t96-3.376148053589
     8         3296d+1*t22*t24*t78*t96+3.3761480535893296d+1*t19*t21*t78
     9         *t96-3.713762858948263d+1*t19*t21*t77*t96+5.0779763653308
     :         62d+4*t21*t5*t78*t89-1.1171548003727898d+5*t21*t5*t77*t89
     ;         -9.232684300601568d+2*t46*t5*t87+9.232684300601568d+2*t16
     <         *t43*t5*t87+9.232684300601568d+2*t46*t5*t86+2.76980529018
     =         0471d+3*t40*t45*t5*t86-3.693073720240627d+3*t16*t43*t5*t8
     >         6-8.309415870541413d+3*t40*t45*t5*t85+2.769805290180471d+
     ?         3*t16*t43*t5*t85+5.539610580360942d+3*t37*t42*t5*t85+5.53
     @         9610580360942d+3*t40*t45*t5*t84-1.4772294880962508d+4*t37
     1         *t42*t5*t84+9.232684300601568d+3*t34*t39*t5*t84+9.2326843
     2         00601568d+3*t37*t42*t5*t83-2.308171075150392d+4*t34*t39*t
     3         5*t83+1.3849026450902355d+4*t31*t36*t5*t83+1.384902645090
     4         2355d+4*t34*t39*t5*t82-3.323766348216566d+4*t31*t36*t5*t8
     5         2+1.9388637031263292d+4*t28*t33*t5*t82+1.9388637031263292
     6         d+4*t31*t36*t5*t81-4.5240153072947686d+4*t28*t33*t5*t81+2
     7         .585151604168439d+4*t25*t30*t5*t81+2.585151604168439d+4*t
     8         28*t33*t5*t80-5.908917952385003d+4*t25*t30*t5*t80+3.32376
     9         63482165647d+4*t22*t27*t5*t80+3.3237663482165647d+4*t25*t
     :         30*t5*t79-7.478474283487271d+4*t22*t27*t5*t79+4.154707935
     ;         2707056d+4*t19*t24*t5*t79+4.154707935270705d+4*t22*t27*t5
     <         *t78-9.232684300601568d+4*t19*t24*t5*t78+5.07797636533086
     =         3d+4*t19*t24*t5*t77+6.093571638397036d+4*t110*t17*t5*t77)
     >         +t3*t64*(-3.4716600044518436d+6*t24*t67*t89*t97+1.1572200
     ?         014839477d+7*t24*t66*t89*t97-1.2729420016323426d+7*t24*t6
     @         5*t89*t97+2.104036366334451d+4*t43*t75*t97-2.104036366334
     1         451d+4*t16*t40*t75*t97-8.416145465337804d+4*t37*t45*t74*t
     2         97-4.208072732668902d+4*t43*t74*t97+1.2624218198006704d+5
     3         *t16*t40*t74*t97+3.787265459402013d+5*t37*t45*t73*t97+2.1
     4         04036366334451d+4*t43*t73*t97-2.104036366334451d+5*t34*t4
     5         2*t73*t97-1.8936327297010064d+5*t16*t40*t73*t97-5.0496872
     6         79202681d+5*t37*t45*t72*t97+8.416145465337803d+5*t34*t42*
     7         t72*t97+8.416145465337804d+4*t16*t40*t72*t97-4.2080727326
     8         689016d+5*t31*t39*t72*t97+2.1040363663344508d+5*t37*t45*t
     9         71*t97-1.0520181831672254d+6*t34*t42*t71*t97+1.5780272747
     :         50838d+6*t31*t39*t71*t97-7.364127282170578d+5*t28*t36*t71
     ;         *t97+4.208072732668902d+5*t34*t42*t70*t97-1.8936327297010
     <         06d+6*t31*t39*t70*t97+2.6510858215814087d+6*t28*t36*t70*t
     =         97-1.1782603651472927d+6*t25*t33*t70*t97+7.36412728217057
     >         8d+5*t31*t39*t69*t97-3.0929334585116436d+6*t28*t36*t69*t9
     ?         7+4.123911278015524d+6*t25*t33*t69*t97-1.7673905477209387
     @         d+6*t22*t30*t69*t97+1.1782603651472927d+6*t28*t36*t68*t97
     1         -4.713041460589171d+6*t25*t33*t68*t97+6.059624735043219d+
     2         6*t22*t30*t68*t97-2.524843639601341d+6*t19*t27*t68*t97+1.
     3         767390547720939d+6*t25*t33*t67*t97-6.817077826923622d+6*t
     4         22*t30*t67*t97+8.521347283654526d+6*t19*t27*t67*t97+2.524
     5         843639601341d+6*t22*t30*t66*t97-9.468163648505028d+6*t19*
     6         t27*t66*t97-4.628880005935792d+6*t110*t21*t66*t97+3.47166
     7         00044518436d+6*t19*t27*t65*t97+1.5275304019588112d+7*t110
     8         *t21*t65*t97-6.01754400771653d+6*t146*t17*t65*t97+3.71376
     9         2858948263d+1*t17*t65*t89*t96-3.37614805358933d+0*t48*t75
     :         *t96+3.37614805358933d+0*t16*t46*t75*t96-6.75229610717866
     ;         d+0*t16*t46*t74*t96+6.75229610717866d+0*t43*t45*t74*t96-1
     <         .0128444160767991d+1*t43*t45*t73*t96+1.0128444160767991d+
     =         1*t40*t42*t73*t96-1.350459221435732d+1*t40*t42*t72*t96+1.
     >         350459221435732d+1*t37*t39*t72*t96-1.6880740267946648d+1*
     ?         t37*t39*t71*t96+1.6880740267946648d+1*t34*t36*t71*t96-2.0
     @         256888321535982d+1*t34*t36*t70*t96+2.0256888321535982d+1*
     1         t31*t33*t70*t96-2.3633036375125308d+1*t31*t33*t69*t96+2.3
     2         633036375125308d+1*t28*t30*t69*t96-2.700918442871464d+1*t
     3         28*t30*t68*t96+2.700918442871464d+1*t25*t27*t68*t96-3.038
     4         5332482303967d+1*t25*t27*t67*t96+3.0385332482303967d+1*t2
     5         2*t24*t67*t96-3.3761480535893296d+1*t22*t24*t66*t96+3.376
     6         1480535893296d+1*t19*t21*t66*t96-3.713762858948263d+1*t19
     7         *t21*t65*t96+5.077976365330862d+4*t21*t5*t66*t89-1.117154
     8         8003727898d+5*t21*t5*t65*t89-9.232684300601568d+2*t46*t5*
     9         t75+9.232684300601568d+2*t16*t43*t5*t75+9.232684300601568
     :         d+2*t46*t5*t74+2.769805290180471d+3*t40*t45*t5*t74-3.6930
     ;         73720240627d+3*t16*t43*t5*t74-8.309415870541413d+3*t40*t4
     <         5*t5*t73+2.769805290180471d+3*t16*t43*t5*t73+5.5396105803
     =         60942d+3*t37*t42*t5*t73+5.539610580360942d+3*t40*t45*t5*t
     >         72-1.4772294880962508d+4*t37*t42*t5*t72+9.232684300601568
     ?         d+3*t34*t39*t5*t72+9.232684300601568d+3*t37*t42*t5*t71-2.
     @         308171075150392d+4*t34*t39*t5*t71+1.3849026450902355d+4*t
     1         31*t36*t5*t71+1.3849026450902355d+4*t34*t39*t5*t70-3.3237
     2         66348216566d+4*t31*t36*t5*t70+1.9388637031263292d+4*t28*t
     3         33*t5*t70+1.9388637031263292d+4*t31*t36*t5*t69-4.52401530
     4         72947686d+4*t28*t33*t5*t69+2.585151604168439d+4*t25*t30*t
     5         5*t69+2.585151604168439d+4*t28*t33*t5*t68-5.9089179523850
     6         03d+4*t25*t30*t5*t68+3.3237663482165647d+4*t22*t27*t5*t68
     7         +3.3237663482165647d+4*t25*t30*t5*t67-7.478474283487271d+
     8         4*t22*t27*t5*t67+4.1547079352707056d+4*t19*t24*t5*t67+4.1
     9         54707935270705d+4*t22*t27*t5*t66-9.232684300601568d+4*t19
     :         *t24*t5*t66+5.077976365330863d+4*t19*t24*t5*t65+6.0935716
     ;         38397036d+4*t110*t17*t5*t65)-9.305257363491002d-1*t12*t4*
     <         t51*(-3.4716600044518436d+6*t24*t54*t89*t97+1.15722000148
     =         39477d+7*t24*t53*t89*t97-1.2729420016323426d+7*t24*t52*t8
     >         9*t97+2.104036366334451d+4*t43*t62*t97-2.104036366334451d
     ?         +4*t16*t40*t62*t97-8.416145465337804d+4*t37*t45*t61*t97-4
     @         .208072732668902d+4*t43*t61*t97+1.2624218198006704d+5*t16
     1         *t40*t61*t97+3.787265459402013d+5*t37*t45*t60*t97+2.10403
     2         6366334451d+4*t43*t60*t97-2.104036366334451d+5*t34*t42*t6
     3         0*t97-1.8936327297010064d+5*t16*t40*t60*t97-5.04968727920
     4         2681d+5*t37*t45*t59*t97+8.416145465337803d+5*t34*t42*t59*
     5         t97+8.416145465337804d+4*t16*t40*t59*t97-4.20807273266890
     6         16d+5*t31*t39*t59*t97+2.1040363663344508d+5*t37*t45*t58*t
     7         97-1.0520181831672254d+6*t34*t42*t58*t97+1.57802727475083
     8         8d+6*t31*t39*t58*t97-7.364127282170578d+5*t28*t36*t58*t97
     9         +4.208072732668902d+5*t34*t42*t57*t97-1.893632729701006d+
     :         6*t31*t39*t57*t97+2.6510858215814087d+6*t28*t36*t57*t97-1
     ;         .1782603651472927d+6*t25*t33*t57*t97+7.364127282170578d+5
     <         *t31*t39*t56*t97-3.0929334585116436d+6*t28*t36*t56*t97+4.
     =         123911278015524d+6*t25*t33*t56*t97-1.7673905477209387d+6*
     >         t22*t30*t56*t97+1.1782603651472927d+6*t28*t36*t55*t97-4.7
     ?         13041460589171d+6*t25*t33*t55*t97+6.059624735043219d+6*t2
     @         2*t30*t55*t97-2.524843639601341d+6*t19*t27*t55*t97+1.7673
     1         90547720939d+6*t25*t33*t54*t97-6.817077826923622d+6*t22*t
     2         30*t54*t97+8.521347283654526d+6*t19*t27*t54*t97+2.5248436
     3         39601341d+6*t22*t30*t53*t97-9.468163648505028d+6*t19*t27*
     4         t53*t97-4.628880005935792d+6*t110*t21*t53*t97+3.471660004
     5         4518436d+6*t19*t27*t52*t97+1.5275304019588112d+7*t110*t21
     6         *t52*t97-6.01754400771653d+6*t146*t17*t52*t97+3.713762858
     7         948263d+1*t17*t52*t89*t96-3.37614805358933d+0*t48*t62*t96
     8         +3.37614805358933d+0*t16*t46*t62*t96-6.75229610717866d+0*
     9         t16*t46*t61*t96+6.75229610717866d+0*t43*t45*t61*t96-1.012
     :         8444160767991d+1*t43*t45*t60*t96+1.0128444160767991d+1*t4
     ;         0*t42*t60*t96-1.350459221435732d+1*t40*t42*t59*t96+1.3504
     <         59221435732d+1*t37*t39*t59*t96-1.6880740267946648d+1*t37*
     =         t39*t58*t96+1.6880740267946648d+1*t34*t36*t58*t96-2.02568
     >         88321535982d+1*t34*t36*t57*t96+2.0256888321535982d+1*t31*
     ?         t33*t57*t96-2.3633036375125308d+1*t31*t33*t56*t96+2.36330
     @         36375125308d+1*t28*t30*t56*t96-2.700918442871464d+1*t28*t
     1         30*t55*t96+2.700918442871464d+1*t25*t27*t55*t96-3.0385332
     2         482303967d+1*t25*t27*t54*t96+3.0385332482303967d+1*t22*t2
     3         4*t54*t96-3.3761480535893296d+1*t22*t24*t53*t96+3.3761480
     4         535893296d+1*t19*t21*t53*t96-3.713762858948263d+1*t19*t21
     5         *t52*t96+5.077976365330862d+4*t21*t5*t53*t89-1.1171548003
     6         727898d+5*t21*t5*t52*t89-9.232684300601568d+2*t46*t5*t62+
     7         9.232684300601568d+2*t16*t43*t5*t62+9.232684300601568d+2*
     8         t46*t5*t61+2.769805290180471d+3*t40*t45*t5*t61-3.69307372
     9         0240627d+3*t16*t43*t5*t61-8.309415870541413d+3*t40*t45*t5
     :         *t60+2.769805290180471d+3*t16*t43*t5*t60+5.53961058036094
     ;         2d+3*t37*t42*t5*t60+5.539610580360942d+3*t40*t45*t5*t59-1
     <         .4772294880962508d+4*t37*t42*t5*t59+9.232684300601568d+3*
     =         t34*t39*t5*t59+9.232684300601568d+3*t37*t42*t5*t58-2.3081
     >         71075150392d+4*t34*t39*t5*t58+1.3849026450902355d+4*t31*t
     ?         36*t5*t58+1.3849026450902355d+4*t34*t39*t5*t57-3.32376634
     @         8216566d+4*t31*t36*t5*t57+1.9388637031263292d+4*t28*t33*t
     1         5*t57+1.9388637031263292d+4*t31*t36*t5*t56-4.524015307294
     2         7686d+4*t28*t33*t5*t56+2.585151604168439d+4*t25*t30*t5*t5
     3         6+2.585151604168439d+4*t28*t33*t5*t55-5.908917952385003d+
     4         4*t25*t30*t5*t55+3.3237663482165647d+4*t22*t27*t5*t55+3.3
     5         237663482165647d+4*t25*t30*t5*t54-7.478474283487271d+4*t2
     6         2*t27*t5*t54+4.1547079352707056d+4*t19*t24*t5*t54+4.15470
     7         7935270705d+4*t22*t27*t5*t53-9.232684300601568d+4*t19*t24
     8         *t5*t53+5.077976365330863d+4*t19*t24*t5*t52+6.09357163839
     9         7036d+4*t110*t17*t5*t52)-9.305257363491002d-1*t12*t3*t4*(
     :         -3.4716600044518436d+6*t23*t24*t89*t97+1.1572200014839477
     ;         d+7*t20*t24*t89*t97-1.2729420016323426d+7*t13*t24*t89*t97
     <         +2.104036366334451d+4*t43*t47*t97-2.104036366334451d+4*t1
     =         6*t40*t47*t97-8.416145465337804d+4*t37*t44*t45*t97+3.7872
     >         65459402013d+5*t37*t41*t45*t97-5.049687279202681d+5*t37*t
     ?         38*t45*t97+2.1040363663344508d+5*t35*t37*t45*t97-4.208072
     @         732668902d+4*t43*t44*t97+1.2624218198006704d+5*t16*t40*t4
     1         4*t97+2.104036366334451d+4*t41*t43*t97-2.104036366334451d
     2         +5*t34*t41*t42*t97+8.416145465337803d+5*t34*t38*t42*t97-1
     3         .0520181831672254d+6*t34*t35*t42*t97+4.208072732668902d+5
     4         *t32*t34*t42*t97-1.8936327297010064d+5*t16*t40*t41*t97+8.
     5         416145465337804d+4*t16*t38*t40*t97-4.2080727326689016d+5*
     6         t31*t38*t39*t97+1.578027274750838d+6*t31*t35*t39*t97-1.89
     7         3632729701006d+6*t31*t32*t39*t97+7.364127282170578d+5*t29
     8         *t31*t39*t97-7.364127282170578d+5*t28*t35*t36*t97+2.65108
     9         58215814087d+6*t28*t32*t36*t97-3.0929334585116436d+6*t28*
     :         t29*t36*t97+1.1782603651472927d+6*t26*t28*t36*t97-1.17826
     ;         03651472927d+6*t25*t32*t33*t97+4.123911278015524d+6*t25*t
     <         29*t33*t97-4.713041460589171d+6*t25*t26*t33*t97+1.7673905
     =         47720939d+6*t23*t25*t33*t97-1.7673905477209387d+6*t22*t29
     >         *t30*t97+6.059624735043219d+6*t22*t26*t30*t97-6.817077826
     ?         923622d+6*t22*t23*t30*t97+2.524843639601341d+6*t20*t22*t3
     @         0*t97-2.524843639601341d+6*t19*t26*t27*t97+8.521347283654
     1         526d+6*t19*t23*t27*t97-9.468163648505028d+6*t19*t20*t27*t
     2         97+3.4716600044518436d+6*t13*t19*t27*t97-4.62888000593579
     3         2d+6*t110*t20*t21*t97+1.5275304019588112d+7*t110*t13*t21*
     4         t97-6.01754400771653d+6*t13*t146*t17*t97+3.71376285894826
     5         3d+1*t13*t17*t89*t96-3.37614805358933d+0*t47*t48*t96+3.37
     6         614805358933d+0*t16*t46*t47*t96-6.75229610717866d+0*t16*t
     7         44*t46*t96+6.75229610717866d+0*t43*t44*t45*t96-1.01284441
     8         60767991d+1*t41*t43*t45*t96+1.0128444160767991d+1*t40*t41
     9         *t42*t96-1.350459221435732d+1*t38*t40*t42*t96+1.350459221
     :         435732d+1*t37*t38*t39*t96-1.6880740267946648d+1*t35*t37*t
     ;         39*t96+1.6880740267946648d+1*t34*t35*t36*t96-2.0256888321
     <         535982d+1*t32*t34*t36*t96+2.0256888321535982d+1*t31*t32*t
     =         33*t96-2.3633036375125308d+1*t29*t31*t33*t96+2.3633036375
     >         125308d+1*t28*t29*t30*t96-2.700918442871464d+1*t26*t28*t3
     ?         0*t96+2.700918442871464d+1*t25*t26*t27*t96-3.038533248230
     @         3967d+1*t23*t25*t27*t96+3.0385332482303967d+1*t22*t23*t24
     1         *t96-3.3761480535893296d+1*t20*t22*t24*t96+3.376148053589
     2         3296d+1*t19*t20*t21*t96-3.713762858948263d+1*t13*t19*t21*
     3         t96+5.077976365330862d+4*t20*t21*t5*t89-1.117154800372789
     4         8d+5*t13*t21*t5*t89-9.232684300601568d+2*t46*t47*t5+9.232
     5         684300601568d+2*t16*t43*t47*t5+9.232684300601568d+2*t44*t
     6         46*t5+2.769805290180471d+3*t40*t44*t45*t5-8.3094158705414
     7         13d+3*t40*t41*t45*t5+5.539610580360942d+3*t38*t40*t45*t5-
     8         3.693073720240627d+3*t16*t43*t44*t5+2.769805290180471d+3*
     9         t16*t41*t43*t5+5.539610580360942d+3*t37*t41*t42*t5-1.4772
     :         294880962508d+4*t37*t38*t42*t5+9.232684300601568d+3*t35*t
     ;         37*t42*t5+9.232684300601568d+3*t34*t38*t39*t5-2.308171075
     <         150392d+4*t34*t35*t39*t5+1.3849026450902355d+4*t32*t34*t3
     =         9*t5+1.3849026450902355d+4*t31*t35*t36*t5-3.3237663482165
     >         66d+4*t31*t32*t36*t5+1.9388637031263292d+4*t29*t31*t36*t5
     ?         +1.9388637031263292d+4*t28*t32*t33*t5-4.5240153072947686d
     @         +4*t28*t29*t33*t5+2.585151604168439d+4*t26*t28*t33*t5+2.5
     1         85151604168439d+4*t25*t29*t30*t5-5.908917952385003d+4*t25
     2         *t26*t30*t5+3.3237663482165647d+4*t23*t25*t30*t5+3.323766
     3         3482165647d+4*t22*t26*t27*t5-7.478474283487271d+4*t22*t23
     4         *t27*t5+4.154707935270705d+4*t20*t22*t27*t5+4.15470793527
     5         07056d+4*t19*t23*t24*t5-9.232684300601568d+4*t19*t20*t24*
     6         t5+5.077976365330863d+4*t13*t19*t24*t5+6.093571638397036d
     7         +4*t110*t13*t17*t5)+(5.377850105933821d-2*gammabb*t103*t9
     8         0+2.6889250529669106d-2*gammabb*t123*t49+2.68892505296691
     9         06d-2*gammabb*t111*t12)*t94*t95+(9.894611731573306d-5*t10
     :         4*t115*t12*t50*t91+3.024609866719883d-2*gammabb*t103*t50*
     ;         t91+1.5123049333599414d-2*gammabb*t123*t50*t63+9.89461173
     <         1573306d-5*t103*t104*t115*t50*t63+1.5123049333599414d-2*g
     =         ammabb*t112*t12*t50)*t95+t101*(3.983592671062089d-3*gamma
     >         bb*t104*t12*t49*t94-1.2407009817988002d+0*t12*t51*t91-1.2
     ?         407009817988002d+0*t12*t3*t90-1.2407009817988002d+0*t103*
     @         t51*t63+2.2404517531258392d-3*gammabb*t104*t12*t50*t63-1.
     1         2407009817988002d+0*t103*t3*t49)+t125*(3.5318356336070855
     2         d-2*gammabb*t64*t92+3.5318356336070855d-2*gammabb*t105*t7
     3         6)*t94+t104*(-5.779367400447957d-2*gammabb*t105*t92-2.889
     4         6837002239784d-2*gammabb*t126*t76-2.8896837002239784d-2*g
     5         ammabb*t113*t64)*t94+t118*(1.4938472516482826d-2*gammabb*
     6         t12*t90+1.4938472516482826d-2*gammabb*t103*t49)*t94-1.648
     7         1899623499732d-1*gammabb*t155*t64*t76*t94+2.9876945032965
     8         69d-2*gammabb*t12*t151*t49*t94-3.6666666666666664d+0*t125
     9         *t130*t94-2.3333333333333334d+0*t118*t127*t94+t104*(-1.06
     :         3335633294209d-4*t104*t115*t50*t64*t93-3.250431179460851d
     ;         -2*gammabb*t105*t50*t93-1.6252155897304255d-2*gammabb*t12
     <         6*t50*t88-1.063335633294209d-4*t104*t105*t115*t50*t88-1.6
     =         252155897304255d-2*gammabb*t114*t50*t64)+t124*(-5.3166781
     >         66471045d-5*t115*t50*t64*t93-5.316678166471045d-5*t105*t1
     ?         15*t50*t88)+t125*(1.9863746096705204d-2*gammabb*t50*t64*t
     @         93+1.9863746096705204d-2*gammabb*t105*t50*t88)+3*t126*t51
     1         *t93+t116*t124*(-2.3079800683637772d-4*t115*t64*t92-2.307
     2         9800683637772d-4*t105*t115*t76+2.3960893036683073d-2*gamm
     3         abb*t130)+3*t126*t3*t92+t117*(4.947305865786653d-5*t115*t
     4         12*t50*t91+4.947305865786653d-5*t103*t115*t50*t63)+t118*(
     5         8.401694074221897d-3*gammabb*t12*t50*t91+8.40169407422189
     6         7d-3*gammabb*t103*t50*t63)-7.444205890792801d+0*t103*t5*t
     7         51*t91-2.7915772090473007d+0*t123*t4*t51*t91+t116*t117*(2
     8         .1476348525932504d-4*t115*t12*t90+2.1476348525932504d-4*t
     9         103*t115*t49+2.3960893036683073d-2*gammabb*t127)-7.444205
     :         890792801d+0*t103*t3*t5*t90-2.7915772090473007d+0*t123*t3
     ;         *t4*t90-9.269748178462429d-2*gammabb*t155*t50*t64*t88+5.8
     <         4834598311815d-4*t115*t154*t50*t64*t88-5.217843141140167d
     =         -7*t147*t153*t50*t64*t88+t156*t51*t88+2.5387780752001543d
     >         -3*t115*t116*t154*t64*t76-8.295189532329142d-6*t147*t148*
     ?         t153*t64*t76+t156*t3*t76-3.7221029453964005d+0*t123*t5*t5
     @         1*t63-9.305257363491002d-1*t152*t4*t51*t63+1.680338814844
     1         3793d-2*gammabb*t12*t151*t50*t63-3.4631141060506576d-4*t1
     2         15*t12*t150*t50*t63+4.855337331063556d-7*t12*t147*t149*t5
     3         0*t63-3.7221029453964005d+0*t112*t12*t5*t51-2.79157720904
     4         73007d+0*t103*t112*t4*t51+3*t105*t114*t51-3.7221029453964
     5         005d+0*t123*t3*t49*t5-3.7221029453964005d+0*t111*t12*t3*t
     6         5-9.305257363491002d-1*t152*t3*t4*t49-1.5033443968152754d
     7         -3*t115*t116*t12*t150*t49+7.718887347725925d-6*t12*t147*t
     8         148*t149*t49-2.7915772090473007d+0*t103*t111*t3*t4+3*t105
     9         *t113*t3-3.6666666666666664d+0*t125*t131-2.33333333333333
     :         34d+0*t118*t129-6.666666666666666d-1*t121*t128)*wght+Amat
     ;         3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RB_RB_GBB) = 1.0d+0*((-6.722312632417276d-3*t103
     1         *t90-3.361156316208638d-3*t123*t49-3.361156316208638d-3*t
     2         111*t12)*t94*t96+(-3.780762333399854d-3*t103*t50*t91-1.89
     3         0381166699927d-3*t123*t50*t63-1.890381166699927d-3*t112*t
     4         12*t50)*t96+(8.963083509889702d-3*t12*t90+8.9630835098897
     5         02d-3*t103*t49)*t94*t95+(-3.71047939933999d-5*gammabb*t1*
     6         t12*t50*t91+5.041016444533138d-3*t12*t50*t91-3.7104793993
     7         3999d-5*gammabb*t1*t103*t50*t63+5.041016444533138d-3*t103
     8         *t50*t63)*t95+t101*(-1.4938472516482837d-3*t1*t12*t49*t94
     9         -8.401694074221898d-4*t1*t12*t50*t63)+t104*(-1.9264558001
     :         493193d-2*t64*t92-1.9264558001493193d-2*t105*t76)*t94+t1*
     ;         (7.224209250559948d-3*t105*t92+3.612104625279974d-3*t126*
     <         t76+3.612104625279974d-3*t113*t64)*t94+3.5318356336070855
     =         d-2*t125*t64*t76*t94-8.963083509889707d-3*t118*t12*t49*t9
     >         4+t104*(3.9875086248532843d-5*gammabb*t1*t50*t64*t93-1.08
     ?         34770598202839d-2*t50*t64*t93+3.9875086248532843d-5*gamma
     @         bb*t1*t105*t50*t88-1.0834770598202839d-2*t105*t50*t88)+t1
     1         *(4.063038974326065d-3*t105*t50*t93+2.0315194871630324d-3
     2         *t126*t50*t88+2.0315194871630324d-3*t114*t50*t64)+1.95669
     3         1177927563d-7*t115*t158*t50*t64*t88+1.9863746096705204d-2
     4         *t125*t50*t64*t88-1.7943788811839778d-4*gammabb*t124*t50*
     5         t64*t88+3.1106960746234286d-6*t115*t148*t158*t64*t76-7.78
     6         9432730727747d-4*gammabb*t116*t124*t64*t76-1.820751499148
     7         8338d-7*t115*t12*t157*t50*t63-5.041016444533138d-3*t118*t
     8         12*t50*t63+1.1749851431243302d-4*gammabb*t117*t12*t50*t63
     9         -2.8945827553972214d-6*t115*t12*t148*t157*t49+5.100632774
     :         908971d-4*gammabb*t116*t117*t12*t49-8.985334888756153d-3*
     ;         t116*t130*t133-8.985334888756153d-3*t116*t127*t132)*wght+
     <         Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = 1.0d+0*((6.957148873762482d-6*t1*t
     1         12*t50*t91+6.957148873762482d-6*t1*t103*t50*t63)*t96+t1*(
     2         -7.476578671599909d-6*t1*t50*t64*t93-7.476578671599909d-6
     3         *t1*t105*t50*t88)-7.337591917228362d-8*gammabb*t160*t50*t
     4         64*t88+3.9875086248532843d-5*t133*t50*t64*t88-1.166511027
     5         9837858d-6*gammabb*t148*t160*t64*t76+1.7309850512728328d-
     6         4*t116*t133*t64*t76+6.827818121808127d-8*gammabb*t12*t159
     7         *t50*t63-2.7828595495049924d-5*t12*t132*t50*t63+1.0854685
     8         332739583d-6*gammabb*t12*t148*t159*t49-1.2080446045837034
     9         d-4*t116*t12*t132*t49-8.985334888756153d-3*t116*t135*t137
     :         -8.985334888756153d-3*t116*t134*t136)*wght+Cmat3(iq,D3_RB
     ;         _GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = 1.0d+0*(2.751596968960636d-8*t162
     1         *t50*t64*t88+4.374416354939197d-7*t148*t162*t64*t76-2.560
     2         431795678048d-8*t12*t161*t50*t63-4.070506999777343d-7*t12
     3         *t148*t161*t49)*wght+Cmat3(iq,D3_GBB_GBB_GBB)
            Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
            Mmat3(iq,D3_RB_RB_TB) = 1.0d+0*((1.7926167019779404d-2*gamma
     1         bb*t12*t138+1.7926167019779404d-2*gammabb*t103*t106)*t94*
     2         t95+(1.0082032889066277d-2*gammabb*t12*t139*t50+1.0082032
     3         889066277d-2*gammabb*t103*t107*t50)*t95+t104*(-1.92645580
     4         01493193d-2*gammabb*t140*t64-1.9264558001493193d-2*gammab
     5         b*t105*t108)*t94+3.5318356336070855d-2*gammabb*t108*t125*
     6         t64*t94-8.963083509889707d-3*gammabb*t106*t118*t12*t94+t5
     7         1*t64*(-4.5701787287977763d+5*t24*t4*t79*t89+2.2282577153
     8         689576d+3*t21*t6*t78*t89+5.077976365330863d+5*t24*t4*t78*
     9         t89+5.585774001863949d+5*t24*t4*t77*t89+4.051377664307196
     :         4d+1*t16*t43*t6*t87+9.232684300601569d+2*t4*t43*t87-2.769
     ;         805290180471d+3*t16*t4*t40*t87-4.0513776643071964d+1*t46*
     <         t6*t86+1.2154132992921589d+2*t40*t45*t6*t86-1.10792211607
     =         21883d+4*t37*t4*t45*t86+1.846536860120314d+3*t4*t43*t86+5
     >         .539610580360942d+3*t16*t4*t40*t86-1.2154132992921589d+2*
     ?         t16*t43*t6*t85+2.4308265985843178d+2*t37*t42*t6*t85+1.661
     @         8831741082832d+4*t37*t4*t45*t85-2.769805290180471d+3*t4*t
     1         43*t85-2.769805290180471d+4*t34*t4*t42*t85+8.309415870541
     2         416d+3*t16*t4*t40*t85-2.4308265985843178d+2*t40*t45*t6*t8
     3         4+4.0513776643071964d+2*t34*t39*t6*t84+2.2158442321443766
     4         d+4*t37*t4*t45*t84+3.693073720240629d+4*t34*t4*t42*t84-1.
     5         1079221160721883d+4*t16*t4*t40*t84-5.539610580360941d+4*t
     6         31*t39*t4*t84-4.051377664307196d+2*t37*t42*t6*t83+6.07706
     7         6496460793d+2*t31*t36*t6*t83-2.7698052901804704d+4*t37*t4
     8         *t45*t83+4.616342150300784d+4*t34*t4*t42*t83+6.9245132254
     9         51174d+4*t31*t39*t4*t83-9.694318515631648d+4*t28*t36*t4*t
     :         83-6.077066496460795d+2*t34*t39*t6*t82+8.507893095045113d
     ;         +2*t28*t33*t6*t82-5.539610580360942d+4*t34*t4*t42*t82+8.3
     <         09415870541416d+4*t31*t39*t4*t82+1.1633182218757979d+5*t2
     =         8*t36*t4*t82-1.5510909625010638d+5*t25*t33*t4*t82-8.50789
     >         3095045111d+2*t31*t36*t6*t81+1.1343857460060149d+3*t25*t3
     ?         0*t6*t81-9.694318515631648d+4*t31*t39*t4*t81+1.3572045921
     @         884307d+5*t28*t36*t4*t81+1.809606122917908d+5*t25*t33*t4*
     1         t81-2.3266364437515955d+5*t22*t30*t4*t81-1.13438574600601
     2         49d+3*t28*t33*t6*t80+1.4584959591505908d+3*t22*t27*t6*t80
     3         -1.5510909625010635d+5*t28*t36*t4*t80+2.0681212833347515d
     4         +5*t25*t33*t4*t80+2.659013078573252d+5*t22*t30*t4*t80-3.3
     5         23766348216565d+5*t19*t27*t4*t80-1.4584959591505905d+3*t2
     6         5*t30*t6*t79+1.8231199489382383d+3*t19*t24*t6*t79-2.32663
     7         64437515952d+5*t25*t33*t4*t79+2.9913897133949086d+5*t22*t
     8         30*t4*t79+3.7392371417436354d+5*t19*t27*t4*t79-1.82311994
     9         89382383d+3*t22*t27*t6*t78-3.3237663482165647d+5*t22*t30*
     :         t4*t78+4.1547079352707056d+5*t19*t27*t4*t78-6.09357163839
     ;         7035d+5*t110*t21*t4*t78-2.228257715368958d+3*t19*t24*t6*t
     <         77+2.6739092584427493d+3*t110*t17*t6*t77-4.57017872879777
     =         63d+5*t19*t27*t4*t77+6.702928802236738d+5*t110*t21*t4*t77
     >         -7.921643129916147d+5*t146*t17*t4*t77)+t3*t64*(-4.5701787
     ?         287977763d+5*t24*t4*t67*t89+2.2282577153689576d+3*t21*t6*
     @         t66*t89+5.077976365330863d+5*t24*t4*t66*t89+5.58577400186
     1         3949d+5*t24*t4*t65*t89+4.0513776643071964d+1*t16*t43*t6*t
     2         75+9.232684300601569d+2*t4*t43*t75-2.769805290180471d+3*t
     3         16*t4*t40*t75-4.0513776643071964d+1*t46*t6*t74+1.21541329
     4         92921589d+2*t40*t45*t6*t74-1.1079221160721883d+4*t37*t4*t
     5         45*t74+1.846536860120314d+3*t4*t43*t74+5.539610580360942d
     6         +3*t16*t4*t40*t74-1.2154132992921589d+2*t16*t43*t6*t73+2.
     7         4308265985843178d+2*t37*t42*t6*t73+1.6618831741082832d+4*
     8         t37*t4*t45*t73-2.769805290180471d+3*t4*t43*t73-2.76980529
     9         0180471d+4*t34*t4*t42*t73+8.309415870541416d+3*t16*t4*t40
     :         *t73-2.4308265985843178d+2*t40*t45*t6*t72+4.0513776643071
     ;         964d+2*t34*t39*t6*t72+2.2158442321443766d+4*t37*t4*t45*t7
     <         2+3.693073720240629d+4*t34*t4*t42*t72-1.1079221160721883d
     =         +4*t16*t4*t40*t72-5.539610580360941d+4*t31*t39*t4*t72-4.0
     >         51377664307196d+2*t37*t42*t6*t71+6.077066496460793d+2*t31
     ?         *t36*t6*t71-2.7698052901804704d+4*t37*t4*t45*t71+4.616342
     @         150300784d+4*t34*t4*t42*t71+6.924513225451174d+4*t31*t39*
     1         t4*t71-9.694318515631648d+4*t28*t36*t4*t71-6.077066496460
     2         795d+2*t34*t39*t6*t70+8.507893095045113d+2*t28*t33*t6*t70
     3         -5.539610580360942d+4*t34*t4*t42*t70+8.309415870541416d+4
     4         *t31*t39*t4*t70+1.1633182218757979d+5*t28*t36*t4*t70-1.55
     5         10909625010638d+5*t25*t33*t4*t70-8.507893095045111d+2*t31
     6         *t36*t6*t69+1.1343857460060149d+3*t25*t30*t6*t69-9.694318
     7         515631648d+4*t31*t39*t4*t69+1.3572045921884307d+5*t28*t36
     8         *t4*t69+1.809606122917908d+5*t25*t33*t4*t69-2.32663644375
     9         15955d+5*t22*t30*t4*t69-1.1343857460060149d+3*t28*t33*t6*
     :         t68+1.4584959591505908d+3*t22*t27*t6*t68-1.55109096250106
     ;         35d+5*t28*t36*t4*t68+2.0681212833347515d+5*t25*t33*t4*t68
     <         +2.659013078573252d+5*t22*t30*t4*t68-3.323766348216565d+5
     =         *t19*t27*t4*t68-1.4584959591505905d+3*t25*t30*t6*t67+1.82
     >         31199489382383d+3*t19*t24*t6*t67-2.3266364437515952d+5*t2
     ?         5*t33*t4*t67+2.9913897133949086d+5*t22*t30*t4*t67+3.73923
     @         71417436354d+5*t19*t27*t4*t67-1.8231199489382383d+3*t22*t
     1         27*t6*t66-3.3237663482165647d+5*t22*t30*t4*t66+4.15470793
     2         52707056d+5*t19*t27*t4*t66-6.093571638397035d+5*t110*t21*
     3         t4*t66-2.228257715368958d+3*t19*t24*t6*t65+2.673909258442
     4         7493d+3*t110*t17*t6*t65-4.5701787287977763d+5*t19*t27*t4*
     5         t65+6.702928802236738d+5*t110*t21*t4*t65-7.92164312991614
     6         7d+5*t146*t17*t4*t65)-9.305257363491002d-1*t12*t4*t51*(2.
     7         2282577153689576d+3*t21*t53*t6*t89-4.5701787287977763d+5*
     8         t24*t4*t54*t89+5.077976365330863d+5*t24*t4*t53*t89+5.5857
     9         74001863949d+5*t24*t4*t52*t89+4.0513776643071964d+1*t16*t
     :         43*t6*t62+9.232684300601569d+2*t4*t43*t62-2.7698052901804
     ;         71d+3*t16*t4*t40*t62-4.0513776643071964d+1*t46*t6*t61+1.2
     <         154132992921589d+2*t40*t45*t6*t61-1.1079221160721883d+4*t
     =         37*t4*t45*t61+1.846536860120314d+3*t4*t43*t61+5.539610580
     >         360942d+3*t16*t4*t40*t61-1.2154132992921589d+2*t16*t43*t6
     ?         *t60+2.4308265985843178d+2*t37*t42*t6*t60+1.6618831741082
     @         832d+4*t37*t4*t45*t60-2.769805290180471d+3*t4*t43*t60-2.7
     1         69805290180471d+4*t34*t4*t42*t60+8.309415870541416d+3*t16
     2         *t4*t40*t60-2.4308265985843178d+2*t40*t45*t59*t6+4.051377
     3         6643071964d+2*t34*t39*t59*t6-4.051377664307196d+2*t37*t42
     4         *t58*t6+6.077066496460793d+2*t31*t36*t58*t6-6.07706649646
     5         0795d+2*t34*t39*t57*t6+8.507893095045113d+2*t28*t33*t57*t
     6         6-8.507893095045111d+2*t31*t36*t56*t6+1.1343857460060149d
     7         +3*t25*t30*t56*t6-1.1343857460060149d+3*t28*t33*t55*t6+1.
     8         4584959591505908d+3*t22*t27*t55*t6-1.4584959591505905d+3*
     9         t25*t30*t54*t6+1.8231199489382383d+3*t19*t24*t54*t6-1.823
     :         1199489382383d+3*t22*t27*t53*t6-2.228257715368958d+3*t19*
     ;         t24*t52*t6+2.6739092584427493d+3*t110*t17*t52*t6+2.215844
     <         2321443766d+4*t37*t4*t45*t59+3.693073720240629d+4*t34*t4*
     =         t42*t59-1.1079221160721883d+4*t16*t4*t40*t59-5.5396105803
     >         60941d+4*t31*t39*t4*t59-2.7698052901804704d+4*t37*t4*t45*
     ?         t58+4.616342150300784d+4*t34*t4*t42*t58+6.924513225451174
     @         d+4*t31*t39*t4*t58-9.694318515631648d+4*t28*t36*t4*t58-5.
     1         539610580360942d+4*t34*t4*t42*t57+8.309415870541416d+4*t3
     2         1*t39*t4*t57+1.1633182218757979d+5*t28*t36*t4*t57-1.55109
     3         09625010638d+5*t25*t33*t4*t57-9.694318515631648d+4*t31*t3
     4         9*t4*t56+1.3572045921884307d+5*t28*t36*t4*t56+1.809606122
     5         917908d+5*t25*t33*t4*t56-2.3266364437515955d+5*t22*t30*t4
     6         *t56-1.5510909625010635d+5*t28*t36*t4*t55+2.0681212833347
     7         515d+5*t25*t33*t4*t55+2.659013078573252d+5*t22*t30*t4*t55
     8         -3.323766348216565d+5*t19*t27*t4*t55-2.3266364437515952d+
     9         5*t25*t33*t4*t54+2.9913897133949086d+5*t22*t30*t4*t54+3.7
     :         392371417436354d+5*t19*t27*t4*t54-3.3237663482165647d+5*t
     ;         22*t30*t4*t53+4.1547079352707056d+5*t19*t27*t4*t53-6.0935
     <         71638397035d+5*t110*t21*t4*t53-4.5701787287977763d+5*t19*
     =         t27*t4*t52+6.702928802236738d+5*t110*t21*t4*t52-7.9216431
     >         29916147d+5*t146*t17*t4*t52)-9.305257363491002d-1*t12*t3*
     ?         t4*(2.2282577153689576d+3*t20*t21*t6*t89-4.57017872879777
     @         63d+5*t23*t24*t4*t89+5.077976365330863d+5*t20*t24*t4*t89+
     1         5.585774001863949d+5*t13*t24*t4*t89+4.0513776643071964d+1
     2         *t16*t43*t47*t6-4.0513776643071964d+1*t44*t46*t6+1.215413
     3         2992921589d+2*t40*t44*t45*t6-2.4308265985843178d+2*t38*t4
     4         0*t45*t6-1.2154132992921589d+2*t16*t41*t43*t6+2.430826598
     5         5843178d+2*t37*t41*t42*t6-4.051377664307196d+2*t35*t37*t4
     6         2*t6+4.0513776643071964d+2*t34*t38*t39*t6-6.0770664964607
     7         95d+2*t32*t34*t39*t6+6.077066496460793d+2*t31*t35*t36*t6-
     8         8.507893095045111d+2*t29*t31*t36*t6+8.507893095045113d+2*
     9         t28*t32*t33*t6-1.1343857460060149d+3*t26*t28*t33*t6+1.134
     :         3857460060149d+3*t25*t29*t30*t6-1.4584959591505905d+3*t23
     ;         *t25*t30*t6+1.4584959591505908d+3*t22*t26*t27*t6-1.823119
     <         9489382383d+3*t20*t22*t27*t6+1.8231199489382383d+3*t19*t2
     =         3*t24*t6-2.228257715368958d+3*t13*t19*t24*t6+2.6739092584
     >         427493d+3*t110*t13*t17*t6+9.232684300601569d+2*t4*t43*t47
     ?         -2.769805290180471d+3*t16*t4*t40*t47-1.1079221160721883d+
     @         4*t37*t4*t44*t45+1.6618831741082832d+4*t37*t4*t41*t45+2.2
     1         158442321443766d+4*t37*t38*t4*t45-2.7698052901804704d+4*t
     2         35*t37*t4*t45+1.846536860120314d+3*t4*t43*t44+5.539610580
     3         360942d+3*t16*t4*t40*t44-2.769805290180471d+3*t4*t41*t43-
     4         2.769805290180471d+4*t34*t4*t41*t42+3.693073720240629d+4*
     5         t34*t38*t4*t42+4.616342150300784d+4*t34*t35*t4*t42-5.5396
     6         10580360942d+4*t32*t34*t4*t42+8.309415870541416d+3*t16*t4
     7         *t40*t41-1.1079221160721883d+4*t16*t38*t4*t40-5.539610580
     8         360941d+4*t31*t38*t39*t4+6.924513225451174d+4*t31*t35*t39
     9         *t4+8.309415870541416d+4*t31*t32*t39*t4-9.694318515631648
     :         d+4*t29*t31*t39*t4-9.694318515631648d+4*t28*t35*t36*t4+1.
     ;         1633182218757979d+5*t28*t32*t36*t4+1.3572045921884307d+5*
     <         t28*t29*t36*t4-1.5510909625010635d+5*t26*t28*t36*t4-1.551
     =         0909625010638d+5*t25*t32*t33*t4+1.809606122917908d+5*t25*
     >         t29*t33*t4+2.0681212833347515d+5*t25*t26*t33*t4-2.3266364
     ?         437515952d+5*t23*t25*t33*t4-2.3266364437515955d+5*t22*t29
     @         *t30*t4+2.659013078573252d+5*t22*t26*t30*t4+2.99138971339
     1         49086d+5*t22*t23*t30*t4-3.3237663482165647d+5*t20*t22*t30
     2         *t4-3.323766348216565d+5*t19*t26*t27*t4+3.739237141743635
     3         4d+5*t19*t23*t27*t4+4.1547079352707056d+5*t19*t20*t27*t4-
     4         4.5701787287977763d+5*t13*t19*t27*t4-6.093571638397035d+5
     5         *t110*t20*t21*t4+6.702928802236738d+5*t110*t13*t21*t4-7.9
     6         21643129916147d+5*t13*t146*t17*t4)+t104*(-1.0834770598202
     7         839d-2*gammabb*t141*t50*t64-1.0834770598202839d-2*gammabb
     8         *t105*t109*t50)+1.9863746096705204d-2*gammabb*t109*t125*t
     9         50*t64-5.316678166471045d-5*t109*t115*t124*t50*t64-2.3079
     :         800683637772d-4*t108*t115*t116*t124*t64+t101*(-4.13566993
     ;         9329334d-1*t107*t12*t51-4.135669939329334d-1*t106*t12*t3)
     <         -2.4814019635976003d+0*t12*t139*t5*t51-2.4814019635976003
     =         d+0*t103*t107*t5*t51-1.8610514726982003d+0*t103*t139*t4*t
     >         51-9.305257363491002d-1*t107*t123*t4*t51+2*t105*t141*t51+
     ?         t109*t126*t51-5.041016444533138d-3*gammabb*t107*t118*t12*
     @         t50+4.947305865786653d-5*t107*t115*t117*t12*t50-2.4814019
     1         635976003d+0*t12*t138*t3*t5-2.4814019635976003d+0*t103*t1
     2         06*t3*t5-1.8610514726982003d+0*t103*t138*t3*t4-9.30525736
     3         3491002d-1*t106*t123*t3*t4+2*t105*t140*t3+t108*t126*t3+2.
     4         1476348525932504d-4*t106*t115*t116*t117*t12)*wght+Mmat3(i
     5         q,D3_RB_RB_TB)
            Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
            Mmat3(iq,D3_RB_GBB_TB) = 1.0d+0*((-3.361156316208638d-3*t12*
     1         t138-3.361156316208638d-3*t103*t106)*t94*t96+(-1.89038116
     2         6699927d-3*t12*t139*t50-1.890381166699927d-3*t103*t107*t5
     3         0)*t96+4.481541754944851d-3*t106*t12*t94*t95+2.5205082222
     4         66569d-3*t107*t12*t50*t95+t1*(3.612104625279974d-3*t140*t
     5         64+3.612104625279974d-3*t105*t108)*t94-9.632279000746596d
     6         -3*t104*t108*t64*t94+t1*(2.0315194871630324d-3*t141*t50*t
     7         64+2.0315194871630324d-3*t105*t109*t50)+1.993754312426642
     8         1d-5*gammabb*t109*t133*t50*t64-5.417385299101419d-3*t104*
     9         t109*t50*t64+8.654925256364164d-5*gammabb*t108*t116*t133*
     :         t64-1.855239699669995d-5*gammabb*t107*t12*t132*t50-8.0536
     ;         3069722469d-5*gammabb*t106*t116*t12*t132)*wght+Mmat3(iq,D
     <         3_RB_GBB_TB)
            Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
            Mmat3(iq,D3_GBB_GBB_TB) = 1.0d+0*(-7.476578671599909d-6*t109
     1         *t137*t50*t64-3.245596971136562d-5*t108*t116*t137*t64+6.9
     2         57148873762482d-6*t107*t12*t136*t50+3.020111511459258d-5*
     3         t106*t116*t12*t136)*wght+Mmat3(iq,D3_GBB_GBB_TB)
            Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
            Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
            Mmat3(iq,D3_RB_TB_TB) = 1.0d+0*(8.963083509889702d-3*gammabb
     1         *t12*t142*t94*t95+5.041016444533138d-3*gammabb*t12*t143*t
     2         50*t95-9.632279000746596d-3*gammabb*t104*t144*t64*t94+t51
     3         *t64*(-6.016295831496187d+4*t24*t79*t89*t9-6.684773146106
     4         873d+4*t24*t78*t89*t9+7.353250460717561d+4*t24*t77*t89*t9
     5         -1.2154132992921589d+2*t43*t87*t9-3.646239897876477d+2*t1
     6         6*t40*t87*t9-1.4584959591505908d+3*t37*t45*t86*t9+2.43082
     7         65985843178d+2*t43*t86*t9-7.292479795752954d+2*t16*t40*t8
     8         6*t9-2.1877439387258865d+3*t37*t45*t85*t9+3.6462398978764
     9         77d+2*t43*t85*t9-3.646239897876477d+3*t34*t42*t85*t9+1.09
     :         38719693629433d+3*t16*t40*t85*t9+2.9169919183011817d+3*t3
     ;         7*t45*t84*t9-4.8616531971686355d+3*t34*t42*t84*t9+1.45849
     <         59591505908d+3*t16*t40*t84*t9-7.292479795752954d+3*t31*t3
     =         9*t84*t9+3.646239897876477d+3*t37*t45*t83*t9+6.0770664964
     >         60795d+3*t34*t42*t83*t9-9.115599744691192d+3*t31*t39*t83*
     ?         t9-1.2761839642567668d+4*t28*t36*t83*t9+7.292479795752954
     @         d+3*t34*t42*t82*t9+1.0938719693629431d+4*t31*t39*t82*t9-1
     1         .5314207571081204d+4*t28*t36*t82*t9-2.0418943428108272d+4
     2         *t25*t33*t82*t9+1.2761839642567668d+4*t31*t39*t81*t9+1.78
     3         6657549959474d+4*t28*t36*t81*t9-2.3822100666126317d+4*t25
     4         *t33*t81*t9-3.062841514216241d+4*t22*t30*t81*t9+2.0418943
     5         428108272d+4*t28*t36*t80*t9+2.722525790414436d+4*t25*t33*
     6         t80*t9-3.5003903019614174d+4*t22*t30*t80*t9-4.37548787745
     7         1772d+4*t19*t27*t80*t9+3.062841514216241d+4*t25*t33*t79*t
     8         9+3.9379390897065947d+4*t22*t30*t79*t9-4.9224238621332433
     9         d+4*t19*t27*t79*t9+4.375487877451772d+4*t22*t30*t78*t9+5.
     :         469359846814714d+4*t19*t27*t78*t9-8.021727775328248d+4*t1
     ;         10*t21*t78*t9+6.016295831496187d+4*t19*t27*t77*t9-8.82390
     <         0552861074d+4*t110*t21*t77*t9-1.0428246107926724d+5*t146*
     =         t17*t77*t9)+t3*t64*(-6.016295831496187d+4*t24*t67*t89*t9-
     >         6.684773146106873d+4*t24*t66*t89*t9+7.353250460717561d+4*
     ?         t24*t65*t89*t9-1.2154132992921589d+2*t43*t75*t9-3.6462398
     @         97876477d+2*t16*t40*t75*t9-1.4584959591505908d+3*t37*t45*
     1         t74*t9+2.4308265985843178d+2*t43*t74*t9-7.292479795752954
     2         d+2*t16*t40*t74*t9-2.1877439387258865d+3*t37*t45*t73*t9+3
     3         .646239897876477d+2*t43*t73*t9-3.646239897876477d+3*t34*t
     4         42*t73*t9+1.0938719693629433d+3*t16*t40*t73*t9+2.91699191
     5         83011817d+3*t37*t45*t72*t9-4.8616531971686355d+3*t34*t42*
     6         t72*t9+1.4584959591505908d+3*t16*t40*t72*t9-7.29247979575
     7         2954d+3*t31*t39*t72*t9+3.646239897876477d+3*t37*t45*t71*t
     8         9+6.077066496460795d+3*t34*t42*t71*t9-9.115599744691192d+
     9         3*t31*t39*t71*t9-1.2761839642567668d+4*t28*t36*t71*t9+7.2
     :         92479795752954d+3*t34*t42*t70*t9+1.0938719693629431d+4*t3
     ;         1*t39*t70*t9-1.5314207571081204d+4*t28*t36*t70*t9-2.04189
     <         43428108272d+4*t25*t33*t70*t9+1.2761839642567668d+4*t31*t
     =         39*t69*t9+1.786657549959474d+4*t28*t36*t69*t9-2.382210066
     >         6126317d+4*t25*t33*t69*t9-3.062841514216241d+4*t22*t30*t6
     ?         9*t9+2.0418943428108272d+4*t28*t36*t68*t9+2.7225257904144
     @         36d+4*t25*t33*t68*t9-3.5003903019614174d+4*t22*t30*t68*t9
     1         -4.375487877451772d+4*t19*t27*t68*t9+3.062841514216241d+4
     2         *t25*t33*t67*t9+3.9379390897065947d+4*t22*t30*t67*t9-4.92
     3         24238621332433d+4*t19*t27*t67*t9+4.375487877451772d+4*t22
     4         *t30*t66*t9+5.469359846814714d+4*t19*t27*t66*t9-8.0217277
     5         75328248d+4*t110*t21*t66*t9+6.016295831496187d+4*t19*t27*
     6         t65*t9-8.823900552861074d+4*t110*t21*t65*t9-1.04282461079
     7         26724d+5*t146*t17*t65*t9)-9.305257363491002d-1*t12*t4*t51
     8         *(-6.016295831496187d+4*t24*t54*t89*t9-6.684773146106873d
     9         +4*t24*t53*t89*t9+7.353250460717561d+4*t24*t52*t89*t9-1.2
     :         154132992921589d+2*t43*t62*t9-3.646239897876477d+2*t16*t4
     ;         0*t62*t9-1.4584959591505908d+3*t37*t45*t61*t9+2.430826598
     <         5843178d+2*t43*t61*t9-7.292479795752954d+2*t16*t40*t61*t9
     =         -2.1877439387258865d+3*t37*t45*t60*t9+3.646239897876477d+
     >         2*t43*t60*t9-3.646239897876477d+3*t34*t42*t60*t9+1.093871
     ?         9693629433d+3*t16*t40*t60*t9+2.9169919183011817d+3*t37*t4
     @         5*t59*t9-4.8616531971686355d+3*t34*t42*t59*t9+1.458495959
     1         1505908d+3*t16*t40*t59*t9-7.292479795752954d+3*t31*t39*t5
     2         9*t9+3.646239897876477d+3*t37*t45*t58*t9+6.07706649646079
     3         5d+3*t34*t42*t58*t9-9.115599744691192d+3*t31*t39*t58*t9-1
     4         .2761839642567668d+4*t28*t36*t58*t9+7.292479795752954d+3*
     5         t34*t42*t57*t9+1.0938719693629431d+4*t31*t39*t57*t9-1.531
     6         4207571081204d+4*t28*t36*t57*t9-2.0418943428108272d+4*t25
     7         *t33*t57*t9+1.2761839642567668d+4*t31*t39*t56*t9+1.786657
     8         549959474d+4*t28*t36*t56*t9-2.3822100666126317d+4*t25*t33
     9         *t56*t9-3.062841514216241d+4*t22*t30*t56*t9+2.04189434281
     :         08272d+4*t28*t36*t55*t9+2.722525790414436d+4*t25*t33*t55*
     ;         t9-3.5003903019614174d+4*t22*t30*t55*t9-4.375487877451772
     <         d+4*t19*t27*t55*t9+3.062841514216241d+4*t25*t33*t54*t9+3.
     =         9379390897065947d+4*t22*t30*t54*t9-4.9224238621332433d+4*
     >         t19*t27*t54*t9+4.375487877451772d+4*t22*t30*t53*t9+5.4693
     ?         59846814714d+4*t19*t27*t53*t9-8.021727775328248d+4*t110*t
     @         21*t53*t9+6.016295831496187d+4*t19*t27*t52*t9-8.823900552
     1         861074d+4*t110*t21*t52*t9-1.0428246107926724d+5*t146*t17*
     2         t52*t9)-9.305257363491002d-1*t12*t3*t4*(-6.01629583149618
     3         7d+4*t23*t24*t89*t9-6.684773146106873d+4*t20*t24*t89*t9+7
     4         .353250460717561d+4*t13*t24*t89*t9-1.2154132992921589d+2*
     5         t43*t47*t9-3.646239897876477d+2*t16*t40*t47*t9-1.45849595
     6         91505908d+3*t37*t44*t45*t9-2.1877439387258865d+3*t37*t41*
     7         t45*t9+2.9169919183011817d+3*t37*t38*t45*t9+3.64623989787
     8         6477d+3*t35*t37*t45*t9+2.4308265985843178d+2*t43*t44*t9-7
     9         .292479795752954d+2*t16*t40*t44*t9+3.646239897876477d+2*t
     :         41*t43*t9-3.646239897876477d+3*t34*t41*t42*t9-4.861653197
     ;         1686355d+3*t34*t38*t42*t9+6.077066496460795d+3*t34*t35*t4
     <         2*t9+7.292479795752954d+3*t32*t34*t42*t9+1.09387196936294
     =         33d+3*t16*t40*t41*t9+1.4584959591505908d+3*t16*t38*t40*t9
     >         -7.292479795752954d+3*t31*t38*t39*t9-9.115599744691192d+3
     ?         *t31*t35*t39*t9+1.0938719693629431d+4*t31*t32*t39*t9+1.27
     @         61839642567668d+4*t29*t31*t39*t9-1.2761839642567668d+4*t2
     1         8*t35*t36*t9-1.5314207571081204d+4*t28*t32*t36*t9+1.78665
     2         7549959474d+4*t28*t29*t36*t9+2.0418943428108272d+4*t26*t2
     3         8*t36*t9-2.0418943428108272d+4*t25*t32*t33*t9-2.382210066
     4         6126317d+4*t25*t29*t33*t9+2.722525790414436d+4*t25*t26*t3
     5         3*t9+3.062841514216241d+4*t23*t25*t33*t9-3.06284151421624
     6         1d+4*t22*t29*t30*t9-3.5003903019614174d+4*t22*t26*t30*t9+
     7         3.9379390897065947d+4*t22*t23*t30*t9+4.375487877451772d+4
     8         *t20*t22*t30*t9-4.375487877451772d+4*t19*t26*t27*t9-4.922
     9         4238621332433d+4*t19*t23*t27*t9+5.469359846814714d+4*t19*
     :         t20*t27*t9+6.016295831496187d+4*t13*t19*t27*t9-8.02172777
     ;         5328248d+4*t110*t20*t21*t9-8.823900552861074d+4*t110*t13*
     <         t21*t9-1.0428246107926724d+5*t13*t146*t17*t9)-5.417385299
     =         101419d-3*gammabb*t104*t145*t50*t64-1.2407009817988002d+0
     >         *t12*t143*t5*t51-9.305257363491002d-1*t103*t143*t4*t51+t1
     ?         05*t145*t51-1.2407009817988002d+0*t12*t142*t3*t5-9.305257
     @         363491002d-1*t103*t142*t3*t4+t105*t144*t3)*wght+Mmat3(iq,
     1         D3_RB_TB_TB)
            Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
            Mmat3(iq,D3_GBB_TA_TB) = Mmat3(iq,D3_GBB_TA_TB)
            Mmat3(iq,D3_GBB_TB_TB) = 1.0d+0*(-3.361156316208638d-3*t12*t
     1         142*t94*t96-1.890381166699927d-3*t12*t143*t50*t96+3.61210
     2         4625279974d-3*t1*t144*t64*t94+2.0315194871630324d-3*t1*t1
     3         45*t50*t64)*wght+Mmat3(iq,D3_GBB_TB_TB)
            Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
            Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
            Mmat3(iq,D3_TB_TB_TB) = 1.0d+0*(t51*t64*(-7.92d+3*t24*t79*t8
     1         9-2.64d+4*t24*t78*t89-2.904d+4*t24*t77*t89-4.8d+1*t43*t87
     2         -4.8d+1*t16*t40*t87-1.92d+2*t37*t45*t86-9.6d+1*t43*t86-2.
     3         88d+2*t16*t40*t86-8.64d+2*t37*t45*t85-4.8d+1*t43*t85-4.8d
     4         +2*t34*t42*t85-4.32d+2*t16*t40*t85-1.152d+3*t37*t45*t84-1
     5         .92d+3*t34*t42*t84-1.92d+2*t16*t40*t84-9.6d+2*t31*t39*t84
     6         -4.8d+2*t37*t45*t83-2.4d+3*t34*t42*t83-3.6d+3*t31*t39*t83
     7         -1.68d+3*t28*t36*t83-9.6d+2*t34*t42*t82-4.32d+3*t31*t39*t
     8         82-6.048d+3*t28*t36*t82-2.688d+3*t25*t33*t82-1.68d+3*t31*
     9         t39*t81-7.056d+3*t28*t36*t81-9.408d+3*t25*t33*t81-4.032d+
     :         3*t22*t30*t81-2.688d+3*t28*t36*t80-1.0752d+4*t25*t33*t80-
     ;         1.3824d+4*t22*t30*t80-5.76d+3*t19*t27*t80-4.032d+3*t25*t3
     <         3*t79-1.5552d+4*t22*t30*t79-1.944d+4*t19*t27*t79-5.76d+3*
     =         t22*t30*t78-2.16d+4*t19*t27*t78-1.056d+4*t110*t21*t78-7.9
     >         2d+3*t19*t27*t77-3.4848d+4*t110*t21*t77-1.3728d+4*t146*t1
     ?         7*t77)+t3*t64*(-7.92d+3*t24*t67*t89-2.64d+4*t24*t66*t89-2
     @         .904d+4*t24*t65*t89-4.8d+1*t43*t75-4.8d+1*t16*t40*t75-1.9
     1         2d+2*t37*t45*t74-9.6d+1*t43*t74-2.88d+2*t16*t40*t74-8.64d
     2         +2*t37*t45*t73-4.8d+1*t43*t73-4.8d+2*t34*t42*t73-4.32d+2*
     3         t16*t40*t73-1.152d+3*t37*t45*t72-1.92d+3*t34*t42*t72-1.92
     4         d+2*t16*t40*t72-9.6d+2*t31*t39*t72-4.8d+2*t37*t45*t71-2.4
     5         d+3*t34*t42*t71-3.6d+3*t31*t39*t71-1.68d+3*t28*t36*t71-9.
     6         6d+2*t34*t42*t70-4.32d+3*t31*t39*t70-6.048d+3*t28*t36*t70
     7         -2.688d+3*t25*t33*t70-1.68d+3*t31*t39*t69-7.056d+3*t28*t3
     8         6*t69-9.408d+3*t25*t33*t69-4.032d+3*t22*t30*t69-2.688d+3*
     9         t28*t36*t68-1.0752d+4*t25*t33*t68-1.3824d+4*t22*t30*t68-5
     :         .76d+3*t19*t27*t68-4.032d+3*t25*t33*t67-1.5552d+4*t22*t30
     ;         *t67-1.944d+4*t19*t27*t67-5.76d+3*t22*t30*t66-2.16d+4*t19
     <         *t27*t66-1.056d+4*t110*t21*t66-7.92d+3*t19*t27*t65-3.4848
     =         d+4*t110*t21*t65-1.3728d+4*t146*t17*t65)-9.30525736349100
     >         2d-1*t12*t4*t51*(-7.92d+3*t24*t54*t89-2.64d+4*t24*t53*t89
     ?         -2.904d+4*t24*t52*t89-4.8d+1*t43*t62-4.8d+1*t16*t40*t62-1
     @         .92d+2*t37*t45*t61-9.6d+1*t43*t61-2.88d+2*t16*t40*t61-8.6
     1         4d+2*t37*t45*t60-4.8d+1*t43*t60-4.8d+2*t34*t42*t60-4.32d+
     2         2*t16*t40*t60-1.152d+3*t37*t45*t59-1.92d+3*t34*t42*t59-1.
     3         92d+2*t16*t40*t59-9.6d+2*t31*t39*t59-4.8d+2*t37*t45*t58-2
     4         .4d+3*t34*t42*t58-3.6d+3*t31*t39*t58-1.68d+3*t28*t36*t58-
     5         9.6d+2*t34*t42*t57-4.32d+3*t31*t39*t57-6.048d+3*t28*t36*t
     6         57-2.688d+3*t25*t33*t57-1.68d+3*t31*t39*t56-7.056d+3*t28*
     7         t36*t56-9.408d+3*t25*t33*t56-4.032d+3*t22*t30*t56-2.688d+
     8         3*t28*t36*t55-1.0752d+4*t25*t33*t55-1.3824d+4*t22*t30*t55
     9         -5.76d+3*t19*t27*t55-4.032d+3*t25*t33*t54-1.5552d+4*t22*t
     :         30*t54-1.944d+4*t19*t27*t54-5.76d+3*t22*t30*t53-2.16d+4*t
     ;         19*t27*t53-1.056d+4*t110*t21*t53-7.92d+3*t19*t27*t52-3.48
     <         48d+4*t110*t21*t52-1.3728d+4*t146*t17*t52)-9.305257363491
     =         002d-1*t12*t3*t4*(-7.92d+3*t23*t24*t89-2.64d+4*t20*t24*t8
     >         9-2.904d+4*t13*t24*t89-4.8d+1*t43*t47-4.8d+1*t16*t40*t47-
     ?         1.92d+2*t37*t44*t45-8.64d+2*t37*t41*t45-1.152d+3*t37*t38*
     @         t45-4.8d+2*t35*t37*t45-9.6d+1*t43*t44-2.88d+2*t16*t40*t44
     1         -4.8d+1*t41*t43-4.8d+2*t34*t41*t42-1.92d+3*t34*t38*t42-2.
     2         4d+3*t34*t35*t42-9.6d+2*t32*t34*t42-4.32d+2*t16*t40*t41-1
     3         .92d+2*t16*t38*t40-9.6d+2*t31*t38*t39-3.6d+3*t31*t35*t39-
     4         4.32d+3*t31*t32*t39-1.68d+3*t29*t31*t39-1.68d+3*t28*t35*t
     5         36-6.048d+3*t28*t32*t36-7.056d+3*t28*t29*t36-2.688d+3*t26
     6         *t28*t36-2.688d+3*t25*t32*t33-9.408d+3*t25*t29*t33-1.0752
     7         d+4*t25*t26*t33-4.032d+3*t23*t25*t33-4.032d+3*t22*t29*t30
     8         -1.3824d+4*t22*t26*t30-1.5552d+4*t22*t23*t30-5.76d+3*t20*
     9         t22*t30-5.76d+3*t19*t26*t27-1.944d+4*t19*t23*t27-2.16d+4*
     :         t19*t20*t27-7.92d+3*t13*t19*t27-1.056d+4*t110*t20*t21-3.4
     ;         848d+4*t110*t13*t21-1.3728d+4*t13*t146*t17))*wght+Mmat3(i
     <         q,D3_TB_TB_TB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
