/* $Id: nws_sensor.h,v 1.14 2004/10/21 05:49:26 graziano Exp $ */

#ifndef NWS_SENSOR_H
#define NWS_SENSOR_H

#include "register.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Initializes all the sensors & skills. #options# is a list of tab
 * separated name:value (most notably for:yes or fork:no). It register
 * the ACTIVITY_{START|STOP} messages that will let remote start and stop
 * of activities. To have a full sensor capabilities you will have to
 * call EstablishHost and ListenForMessages.
 *
 * Returns 1 on success.
 */
int
NwsSensorInit(const char *options);

/**
 * to be called to shut down the sensor. Returns 1 on success.
 */
int 
NwsSensorExit();

/**
 * Tell the time where next experiment should take place. A value of 0
 * means no experiment is scheduled, any different values is the time (as
 * # of seconds from 1 Jan 1970) when SensorsWork() should be called.
 */
double
NwsSensorNextWork();

/**
 * Do all the experiments due by this time. It stores (or tries to) the
 * measurements with the memory and register with the nameserver the
 * series (the namesever and memory as registered with EstablishHost()).
 * You need to call this one even though you specified doFork in
 * NwsSensorInit().
 */
void
NwsSensorWork();

/**
 * These functions return default registration names for Control, Series
 * and Activity. Although registrations may use any name, using these
 * functions will make retrieval easier. The returned value *need* to be
 * freed.
 */
char *
NameOfControl_r(        const char *host,
                        const char *controlName);
char *
NameOfSeries_r(         const char *host,
                        const char *resource,
                        const char *options);
char *
NameOfActivity_r(       const char *host,
                        const char *skillName,
                        const char *options);

/**
 * These functions are convenience functions for generating objects
 * suitable to be registered with a nameserver for controls, activities
 * and series. If #name# is NULL, default names are generated.
 * The caller is responsible for freeing the Objects returned by the
 * these function when they are no longer needed.
 */
Object
CreateActivityObject(   const char *name,
                        const char *controlName,
                        const char *host,
                        const char *options,
                        const char *resources,
                        const char *skillName);
Object
CreateControlObject(    const char *name,
                        const char *controlName,
                        const char *host,
                        const char *options,
                        const char *skills);
Object
CreateSeriesObject(     const char *name,
                        const char *host,
                        const char *label,
                        const char *memory,
                        const char *options,
                        const char *resource,
                        const char *activity);


#ifdef __cplusplus
}
#endif

#endif
