/* $Id: disk.c,v 1.2 2004/06/15 20:58:31 graziano Exp $ */

#include "config_nws.h"

#include <stdio.h>
#include <sys/types.h>

#include "diagnostic.h"
#include "disk.h"
#include "strutil.h"


#ifdef GetFileSystemStats
#	undef GetFileSystemStats
#endif
#ifdef HAVE_STATVFS
#	include <sys/statvfs.h>
	typedef struct statvfs FileSystemStats;
#	define GetFileSystemStats statvfs
#	define BlockSizeField f_frsize
#else
#	ifdef HAVE_SYS_VFS_H
#		include <sys/vfs.h>
		typedef struct statfs FileSystemStats;
#		define GetFileSystemStats statfs
#		define BlockSizeField f_bsize
#	else
#		ifdef HAVE_SYS_STATFS_H
#			include <sys/statfs.h>
			typedef struct statfs FileSystemStats;
#			define GetFileSystemStats statfs
#			define BlockSizeField f_bsize
#		else
#			if defined HAVE_SYS_PARAM_H && HAVE_SYS_MOUNT_H
#				include <sys/param.h>
#				include <sys/mount.h>
				typedef struct statfs FileSystemStats;
#				define GetFileSystemStats statfs
#				define BlockSizeField f_bsize
#			endif
#		endif
#	endif
#endif

int
DiskFreeAvailable(const char *options) {
#ifdef GetFileSystemStats
	return 1;
#else
	return 0;
#endif
}

#define ONE_MEG 1048576
void
DiskFreeUseSkill(	const char *options,
			int *length,
			SkillResult **results) {
	FileSystemStats fsStats;
	const char *c;
	char opts[255 + 1], path[255 + 1], *tmp;
	double d;

	tmp = GetOptionValue(options, "path", "");
	for(c = tmp; GETTOK(path, c, ",", &c);) {
		vstrncpy(opts, sizeof(opts), 2, "path:", path);
		if(GetFileSystemStats(path, &fsStats) < 0) {
			LOG("DiskGetFree: status retrieval failed\n");
			AppendResult(freeDisk, opts, 0, 0.0, length, results);
		} else {
			d = (double)fsStats.f_bavail * (double)fsStats.BlockSizeField;
			AppendResult(freeDisk, opts, 1, d/ONE_MEG, length, results);
		}
	}
	FREE(tmp);
}
