#ifndef _LDAP_NWS_BACKEND_H
#define _LDAP_NWS_BACKEND_H

LDAP_BEGIN_DECL

extern int nws_back_initialize LDAP_P(( BackendInfo *bi ));

extern int nws_back_search LDAP_P((
						   BackendDB *be,
						   Connection *c, Operation *o,
						   const char *base, const char *nbase,
						   int scope, int deref, int slimit, int tlimit,
						   Filter *f, const char *filterstr,
						   char **attrs, int attrsonly ));

extern int nws_back_modify LDAP_P((
						   BackendDB *bd,
						   Connection *conn, Operation *op,
						   const char *dn, const char *ndn,
						   Modifications *ml ));

extern int nws_back_db_config LDAP_P(( BackendDB *be, const char *fname, int lineno, int argc, char **argv ));

extern int nws_back_unbind LDAP_P(( BackendDB *bd,
        Connection *conn, Operation *op ));

extern int nws_back_init LDAP_P(( BackendDB *be ));

extern int nws_back_db_open LDAP_P(( BackendDB *be ));

LDAP_END_DECL

#endif /* _LDAP_NWS_BACKEND_H */

