/*
 * nzb
 *
 * Copyright (C) 2004-2005 Mattias Nordstrom <matta at ftlight net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * Authors:
 *   Mattias Nordstrom <matta at ftlight net>
 *
 * $Id: nzbdata.cpp,v 1.6 2005/09/25 11:23:26 mnordstr Exp $
 *   This file provides the nzb data classes.
 */


#include "nzbdata.h"

void NzbList::importNzb(QFile *nzbfile)
{
	QXmlSimpleReader xmlReader;
	QXmlInputSource *source = new QXmlInputSource(nzbfile);
	
	NzbHandler *handler = new NzbHandler(this, nzbfile->fileName());
	xmlReader.setContentHandler(handler);
	xmlReader.setErrorHandler(handler);
	
	xmlReader.parse(source);
}

void NzbList::sortList()
{
	qSort(files.begin(), files.end(), NzbFile::subjectLessThan);
}

int NzbList::totalParts()
{
	int parts = 0;
	
	for (int i=0; i<files.size(); i++) {
		parts += files[i].getSegments()->size();
	}
	
	return parts;
}

qint64 NzbList::totalSize()
{
	qint64 size = Q_INT64_C(0);
	
	for (int i=0; i<files.size(); i++) {
		size += files[i].getBytes();
	}
	
	return size;
}

NzbFile::NzbFile()
{
}

NzbFile::NzbFile(QString poster, QDateTime date, QString subject)
{
	this->poster = poster;
	this->date = date;
	this->subject = subject;
	this->bytes = 0;
	this->encoding = NZB_UNDEF;
}

void NzbFile::addSegment(NzbSeg newseg)
{
	segments.append(newseg);
	bytes += newseg.getBytes();
}

/*static bool NzbFile::subjectLessThan(const NzbFile &nf1, const NzbFile &nf2)
{
	return (nf1.subject < nf2.subject);
}*/

NzbSeg::NzbSeg(int bytes, QString msgid)
{
	this->bytes = bytes;
	this->msgid = msgid;
	this->status = NZB_NONE;
}

NzbHandler::NzbHandler(NzbList *parent, QString nzbfile)
{
	metNzbTag = false;
	this->parent = parent;
	nzbFileName = nzbfile;
}

bool NzbHandler::startElement(const QString &, const QString &, const QString &qName, const QXmlAttributes &attributes)
{
	if (!metNzbTag && qName != "nzb") {
		errorStr = "The file is not an NZB file.";
		return false;
	}

	if (qName == "nzb") {
		metNzbTag = true;
	} else if (qName == "file") {
		QDateTime epoch;
		epoch.setTime_t((attributes.value("date")).toInt());
		NzbFile newfile(attributes.value("poster"), epoch, attributes.value("subject"));
		currentFile = newfile;
	} else if (qName == "segment") {
		currentBytes = attributes.value("bytes").toInt();
	}

	currentText.clear();
	return true;
}

bool NzbHandler::endElement(const QString &, const QString &, const QString &qName)
{
	if (qName == "group") {
		currentFile.addGroup(currentText);
	} else if (qName == "segment") {
		NzbSeg newseg(currentBytes, "<"+currentText+">");
		currentFile.addSegment(newseg);
		currentFile.setNzbFileName(nzbFileName);
        } else if (qName == "file") {
		parent->addFile(currentFile);
	}
	
        return true;
    }

bool NzbHandler::characters(const QString &str)
{
	currentText += str;
	return true;
}

bool NzbHandler::fatalError(const QXmlParseException &exception)
{
	QMessageBox::information(NULL, "nzb", QObject::tr("Parse error at line %1, column %2:\n%3").arg(exception.lineNumber()).arg(exception.columnNumber()).arg(exception.message()));
	return false;
}

QString NzbHandler::errorString() const
{
	return errorStr;
}
