(* $Id: date-and-time.ml,v 1.1 2004/08/05 13:40:59 rwmj Exp $ *)

open Printf

open Dbi

open ExamplesLib

let () =
  (* Supply the name of the database on the command line. *)
  let dbname = if Array.length Sys.argv > 1 then Sys.argv.(1) else "rich" in

  let dbh = set_up_database dbname in

  (* Simple example demonstrating date, time and intervals. *)
  let sth = dbh#prepare "select current_timestamp,
                                current_timestamp - '1/1/2004' :: date" in

  sth#execute [];

  match sth#fetch1 () with
      [ `Timestamp ({ year = t_year; month = t_month; day = t_day },
		    { hour = t_hour; min = t_min; sec = t_sec });
	`Interval ({ day = i_day }, _) ] ->
	printf "Time on the database server is: %d/%d/%d %02d:%02d:%02d\n"
	  t_year t_month t_day t_hour t_min t_sec;
	printf
	  "Time passed since Jan 1 2004 is: %d days\n" i_day
    | _ -> assert false
