open Gsl_fft.Complex

let _ =
  Gsl_error.init () ;

  let leng = 16 in

  let fill n =
    let x = 0.5 *. (float_of_int n) /. (float_of_int leng) in
      if n mod 2 = 0 then 1.0 /. (1.0 +. x) else 0.0 in

  let space = make_workspace leng and
      table = make_wavetable leng and
      array = Array.init (2 * leng) fill in

  Printf.printf "\nOriginal array:\n" ;
  for n=0 to leng-1 do
    Printf.printf "%4d  %13.6e %13.6e\n" n array.(2*n) array.(2*n+1)
  done ;

  transform array table space Forward ;
  Printf.printf "\nArray after FFT:\n" ;
  for n=0 to leng-1 do
    Printf.printf "%4d  %13.6e %13.6e\n" n array.(2*n) array.(2*n+1)
  done ;

  inverse array table space ;
  Printf.printf "\nArray after Inverse FFT:\n" ;
  for n=0 to leng-1 do
    Printf.printf "%4d  %13.6e %13.6e\n" n array.(2*n) array.(2*n+1)
  done
