(* $Id: netcgi.mli,v 1.7 2002/02/03 21:27:50 stolpmann Exp $
 * ----------------------------------------------------------------------
 *
 *)

open Netcgi_env
open Netcgi_types


class simple_argument : 
  ?ro:bool -> string -> string -> cgi_argument
  (* new simple_argument name value *)

(* ~ro: If true, the argument/message is read-only (set_value will raise
 * Value_is_immutable). The default is false.
 *)

(* The classes [memory_mime_message] and [file_mime_message] have been removed.
 * The Netmime module implements this functionality in a much better way.
 *)


class mime_argument :
  ?work_around_backslash_bug:bool ->  (* default: true *)
  string ->                           (* name *)
  Netmime.mime_message ->
    cgi_argument


type argument_processing = 
  [ `Memory        (* Keep the value of the argument in memory *)
  | `File          (* Store the value of the argument into a temporary file *)
  | `Automatic ]   (* Store only arguments with filenames into files.
		    * THE MEANING OF THIS OPTION CHANGES IN OCAMLNET-0.92!
		    *)

type operating_type = 
  [ `Direct of string (* separator *)
  | `Transactional of 
        (cgi_config -> Netchannels.out_obj_channel -> 
	                                     Netchannels.trans_out_obj_channel)
  ]


class std_activation : 
  ?env:cgi_environment ->
  ?processing:(string -> Netmime.mime_header -> argument_processing) ->   
                                         (* default: (fun _ _ -> `Memory) *)
  ?operating_type:operating_type ->                (* default: `Direct "" *)
  unit ->
    cgi_activation

(* Direct activation: When writing to the output channel, the data are directly
 * sent to stdout. The commit_work method has no effect. The rollback_work
 * method causes that the separator string is sent, but it actually does not
 * roll back.
 * Transactional activation: When writing to the output channel, the data
 * are buffered, and only when the data are committed they are written to
 * stdout
 * (Here, "stdout" is a metaphor for the output channel provided by
 * cgi_environment, so you can redirect the output to wherever you want.)
 * The function passed with `Transactional turns an ordinary channel into
 * a transactional channel. Examples: 
 * - `Transactional(new buffered_output_channel), or
 * - `Transactional(new tempfile_output_channel).
 *)

(* default for ~env: first try std_environment, if not possible, fall
 *    back to test_environment
 *)

(* THE FOLLOWING OPTION HAS BEEN WITHDRAWN:
 *
 * ~decl: If the list contains [ "*", Optional ], all arguments not
 *    mentioned in the list are treated as optional. If the list contains
 *    [ "*", Default _ ], all arguments not mentioned in the list have
 *    this default value. Without "*" declaration, unknown arguments
 *    are rejected.
 *    The default is [ "*", Optional ].
 *)

val buffered_transactional_optype : operating_type 
  (* A predefined transactional [operating_type] using a Buffer.t to store
   * the not yet completed transaction
   *)

val tempfile_transactional_optype : operating_type
  (* A predefined transactional [operating_type] using a temporary file to store
   * the not yet completed transaction
   *)
  


class custom_activation :
  ?env:cgi_environment ->
  ?args:cgi_argument list ->                    (* default: [] *)
  ?meth:request_method ->                       (* default: `GET *)
  ?operating_type:operating_type ->             (* default: Direct *)
  unit ->
    cgi_activation

(* Custom activation:
 *
 * This class does not read from the input channel. The method and the
 * arguments can be passed when the object is created. The output channel
 * of the environment is used, however.
 *
 * The class does not modify any property of the environment, and it does
 * not check whether the environment is compatible with the passed method
 * and arguments. This is up to the user.
 *
 * The purpose of the custom activation class is that CGI environments
 * can be created that do not communicate over stdin/stdout, but use other
 * means to get their input and to deliver their output. You could do
 * that by providing a customized cgi_environment as well, but this alternate
 * solution might be ineffective because CGI arguments must be encoded
 * for the only purpose to be immediately decoded by cgi_activation. So
 * the simulated activations have been invented to have another, shorter
 * way to mimick CGI.
 *
 * Note: Unlike std_activation, this class sets the set of current arguments
 * and the set of initial arguments to the same list. This means: if you
 * modify an argument directly (set_value, for instace) this will change
 * both sets. It is recommended to pass only read-only arguments to
 * this class in order to avoid this surprising behaviour.
 *
 * ~env: Default is to first try std_environment; if not possible, fall
 *    back to test_environment
 *)


(* ======================================================================
 * History:
 * 
 * $Log: netcgi.mli,v $
 * Revision 1.7  2002/02/03 21:27:50  stolpmann
 * 	Added: custom_activation.
 *
 * Revision 1.6  2002/01/14 01:14:49  stolpmann
 * 	Removed the classes memory_mime_message and file_mime_message.
 * The corresponding classes in Netmime can be used instead.
 * 	The meaning of the `Automatic option has changed. (See comment).
 * 	The ~processing argument has now also the whole header as
 * parameter.
 *
 * Revision 1.5  2001/10/04 01:04:58  stolpmann
 * 	Moved from directory /src/netstring to /src/cgi.
 *
 * Revision 1.4  2001/10/04 00:54:42  stolpmann
 * 	~ro: CGI argument can now be read-only. Mainly for the
 * set of initial arguments that should be immutable.
 * 	Fixed method [url].
 *
 * Revision 1.3  2001/09/30 00:06:47  stolpmann
 * 	The class mime_argument has now a workaround option.
 * 	Changed the [operating_type], the config is now passed
 * to the function creating the transactional channel.
 * 	New functions [buffered_transactional_optype] and
 * [tempfile_transactional_optype].
 *
 * Revision 1.2  2001/09/28 21:23:11  stolpmann
 * 	Improved MIME arguments.
 *
 * Revision 1.1  2001/09/27 21:59:00  stolpmann
 * 	Initial revision
 *
 * 
 *)
