// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BOPTools_Tools_HeaderFile
#define _BOPTools_Tools_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_IntTools_Context_HeaderFile
#include <Handle_IntTools_Context.hxx>
#endif
class gp_Pnt;
class TopoDS_Vertex;
class TopoDS_Edge;
class TopoDS_Face;
class IntTools_Curve;
class BOPTools_PaveBlock;
class IntTools_Context;
class TopoDS_Shape;
class TopTools_IndexedMapOfShape;
class IntTools_Range;



//!  The class contains handy static functions <br>
//!  dealing with the topology <br>
class BOPTools_Tools  {
public:

  DEFINE_STANDARD_ALLOC

  
//! Make a vertex using 3D-point <aP1> and 3D-tolerance value <aTol> <br>
  Standard_EXPORT   static  void MakeNewVertex(const gp_Pnt& aP1,const Standard_Real aTol,TopoDS_Vertex& aNewVertex) ;
  
//! Make a vertex using couple of vertices  <aV1, aV2> <br>
  Standard_EXPORT   static  void MakeNewVertex(const TopoDS_Vertex& aV1,const TopoDS_Vertex& aV2,TopoDS_Vertex& aNewVertex) ;
  
//! Make a vertex in place of intersection between two edges <br>
//! <aE1, aE2> with parameters <aP1, aP2> <br>
  Standard_EXPORT   static  void MakeNewVertex(const TopoDS_Edge& aE1,const Standard_Real aP1,const TopoDS_Edge& aE2,const Standard_Real aP2,TopoDS_Vertex& aNewVertex) ;
  
//! Make a vertex in place of intersection between the edge <aE1> <br>
//! with parameter <aP1> and the face <aF2> <br>
  Standard_EXPORT   static  void MakeNewVertex(const TopoDS_Edge& aE1,const Standard_Real aP1,const TopoDS_Face& aF2,TopoDS_Vertex& aNewVertex) ;
  
//! Compute a 3D-point on the edge <aEdge> at parameter <aPrm> <br>
  Standard_EXPORT   static  void PointOnEdge(const TopoDS_Edge& aEdge,const Standard_Real aPrm,gp_Pnt& aP) ;
  
//! Make the edge from base edge <aE1> and two vertices <aV1,aV2> <br>
//! at parameters <aP1,aP2> <br>
  Standard_EXPORT   static  void MakeSplitEdge(const TopoDS_Edge& aE1,const TopoDS_Vertex& aV1,const Standard_Real aP1,const TopoDS_Vertex& aV2,const Standard_Real aP2,TopoDS_Edge& aNewEdge) ;
  
//! Make the edge from 3D-Curve <aIC>  and two vertices <aV1,aV2> <br>
//! at parameters <aP1,aP2> <br>
  Standard_EXPORT   static  void MakeSectEdge(const IntTools_Curve& aIC,const TopoDS_Vertex& aV1,const Standard_Real aP1,const TopoDS_Vertex& aV2,const Standard_Real aP2,TopoDS_Edge& aNewEdge) ;
  
//! Update the tolerance value for vertex  <aV> <br>
//! taking into account the fact that <aV> lays on <br>
//! the curve <aIC> <br>
  Standard_EXPORT   static  void UpdateVertex(const IntTools_Curve& aIC,const Standard_Real aT,const TopoDS_Vertex& aV) ;
  
//! Update the tolerance value for vertex  <aV> <br>
//! taking into account the fact that <aV> lays on <br>
//! the edge <aE> <br>
  Standard_EXPORT   static  void UpdateVertex(const TopoDS_Edge& aE,const Standard_Real aT,const TopoDS_Vertex& aV) ;
  
//! Update the tolerance value for vertex  <aVN> <br>
//! taking into account the fact that <aVN> should <br>
//! cover tolerance zone of <aVF> <br>
  Standard_EXPORT   static  void UpdateVertex(const TopoDS_Vertex& aVF,const TopoDS_Vertex& aVN) ;
  
//! Returns TRUE if PaveBlocks  <aPB1>,<aPB2> coinside in 3D <br>
//! taking into account corresp. tolerances' values of vertices, <br>
//! edges <br>
  Standard_EXPORT   static  Standard_Boolean IsBlocksCoinside(const BOPTools_PaveBlock& aPB1,const BOPTools_PaveBlock& aPB2) ;
  
//! Returns TRUE if PaveBlock <aPB> lays on the face <aF>, i.e <br>
//! the <PB> is IN or ON in 2D of <aF> <br>
  Standard_EXPORT   static  Standard_Boolean IsBlockInOnFace(const BOPTools_PaveBlock& aPB,const TopoDS_Face& aF,const Handle(IntTools_Context)& aContext) ;
  
//! Get a  Map <aM> containing the shape itself and all its subshapes <br>
  Standard_EXPORT   static  void MapShapes(const TopoDS_Shape& aS,TopTools_IndexedMapOfShape& aM) ;
  
//! Correct shrunk range <aSR> taking into account 3D-curve <br>
//! resolution and corresp. tolerances' values of <aE1>, <aE2> <br>
  Standard_EXPORT   static  void CorrectRange(const TopoDS_Edge& aE1,const TopoDS_Edge& aE2,const IntTools_Range& aSR,IntTools_Range& aNewSR) ;
  
//! Correct shrunk range <aSR> taking into account 3D-curve <br>
//! resolution and corresp. tolerances' values of <aE>, <aF> <br>
  Standard_EXPORT   static  void CorrectRange(const TopoDS_Edge& aE,const TopoDS_Face& aF,const IntTools_Range& aSR,IntTools_Range& aNewSR) ;
  
//! Make a copy of <aSourceShape> <br>
  Standard_EXPORT   static  void CopySource(const TopoDS_Shape& aSourceShape,TopoDS_Shape& aDestShape) ;





protected:





private:





};





// other Inline functions and methods (like "C++: function call" methods)


#endif
