// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Graphic2d_Paragraph_HeaderFile
#define _Graphic2d_Paragraph_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Graphic2d_Paragraph_HeaderFile
#include <Handle_Graphic2d_Paragraph.hxx>
#endif

#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Aspect_CardinalPoints_HeaderFile
#include <Aspect_CardinalPoints.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Graphic2d_TypeOfAlignment_HeaderFile
#include <Graphic2d_TypeOfAlignment.hxx>
#endif
#ifndef _TColStd_SequenceOfExtendedString_HeaderFile
#include <TColStd_SequenceOfExtendedString.hxx>
#endif
#ifndef _TColStd_SequenceOfInteger_HeaderFile
#include <TColStd_SequenceOfInteger.hxx>
#endif
#ifndef _TShort_SequenceOfShortReal_HeaderFile
#include <TShort_SequenceOfShortReal.hxx>
#endif
#ifndef _Graphic2d_Primitive_HeaderFile
#include <Graphic2d_Primitive.hxx>
#endif
#ifndef _Handle_Graphic2d_GraphicObject_HeaderFile
#include <Handle_Graphic2d_GraphicObject.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
#ifndef _Quantity_Factor_HeaderFile
#include <Quantity_Factor.hxx>
#endif
#ifndef _Quantity_Ratio_HeaderFile
#include <Quantity_Ratio.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Handle_Graphic2d_Drawer_HeaderFile
#include <Handle_Graphic2d_Drawer.hxx>
#endif
#ifndef _Aspect_FStream_HeaderFile
#include <Aspect_FStream.hxx>
#endif
class Standard_OutOfRange;
class Graphic2d_GraphicObject;
class TCollection_ExtendedString;
class Graphic2d_Drawer;


//! The primitive Paragraph <br>
//!	    contains a row column of editable texts <br>
//!	    each text can have a different color and font index. <br>
class Graphic2d_Paragraph : public Graphic2d_Primitive {

public:

  //! Creates a paragraph in a graphic object <aGraphicObject> <br>
//!	    The reference point is <X>, <Y>. <br>
//!	    The orientation angle is <anAngle>. <br>
//!	    The offset position of the reference point is <aPosition> <br>
//!	    depending of the size of paragraph. <br>
//!	    The paragraph scale. <br>
//!	    Angles are measured counterclockwise with 0 radian <br>
//!	    at 3 o'clock. <br>
//!  Warning: a paragraph can be orientable.slantable and zoomable <br>
//! only when this options are enable regardless of the graphic driver. <br>
//! i.e: Xw driver does not,but Xdps or PS driver does. <br>
  Standard_EXPORT   Graphic2d_Paragraph(const Handle(Graphic2d_GraphicObject)& aGraphicObject,const Standard_Real X,const Standard_Real Y,const Quantity_PlaneAngle anAngle = 0.0,const Aspect_CardinalPoints anOffset = Aspect_CP_Center,const Quantity_Factor aScale = 1.0);
  //! Sets the slant angle of the paragraph <me>. <br>
  Standard_EXPORT     void SetSlant(const Quantity_PlaneAngle aSlant = 0.0) ;
  //! Sets the line spacing ratio for the paragraph <me>. <br>
//!	    the spacing height between two lines depends of <br>
//!	    the spacing factor apply on the height of the line currently	--	    writen. <br>
  Standard_EXPORT     void SetSpacing(const Quantity_Ratio aSpacing = 0.5) ;
  //! Sets the fixed margin for the paragraph <me>. <br>
  Standard_EXPORT     void SetMargin(const Quantity_Length aMargin = 0.0) ;
  //! The paragraph <me> follows the scale factor of the view <br>
//!          if the flag is Standard_True. <br>
  Standard_EXPORT     void SetZoomable(const Standard_Boolean aFlag = Standard_False) ;
  //! Sets the frame color index for the paragraph <me>. <br>
//!  Warning: Note that the paragraph frame is drawn only when index <br>
//!	   is > 0. <br>
  Standard_EXPORT     void SetFrameColorIndex(const Standard_Integer anIndex = 0) ;
  //! Sets the width index for the frame of the paragraph <me>. <br>
//!          default width is 0 (1 pixel out line frame is drawn). <br>
  Standard_EXPORT     void SetFrameWidthIndex(const Standard_Integer anIndex = 0) ;
  //! Sets the hiding color index for the paragraph <me>. <br>
//!  Warning: Note that the paragraph background is filled only when index <br>
//!	is >= 0. <br>
//!	 A value of 0 permits to drawn the paragraph background with <br>
//!	the current view background color. <br>
  Standard_EXPORT     void SetHidingColorIndex(const Standard_Integer anIndex = 0) ;
  //! Sets the current color index for the paragraph <me>. <br>
//!  Warning: Note that the index 0 can be undefined as a ColorMapEntry, <br>
//!        in this case the default color is taken. <br>
  Standard_EXPORT     void SetCurrentColorIndex(const Standard_Integer anIndex = 1) ;
  //! Sets the current font index and scales for the paragraph <me>. <br>
//!  Warning: Note that the index 0 can be undefined as a FontMapEntry , <br>
//!         in this case the default system text font is taken. <br>
  Standard_EXPORT     void SetCurrentFontIndex(const Standard_Integer anIndex = 0,const Quantity_Length aHScale = 1.0,const Quantity_Length aWScale = 1.0) ;
  //! Sets the current text alignment for the paragraph <me>. <br>
  Standard_EXPORT     void SetCurrentAlignment(const Graphic2d_TypeOfAlignment anAlignment = Graphic2d_TOA_LEFT) ;
  //! Sets the current text underline flag for the paragraph <me>. <br>
  Standard_EXPORT     void SetCurrentUnderline(const Standard_Boolean isUnderlined = Standard_False) ;
  //! Adds a text at a row-column position in the paragraph <me> <br>
//! with the current Color,Font,Alignment attributes <br>
//! at the position <aColumn,aRow> if <aColumn> and <aRow> are > 0 <br>
//!  or at the end of the line if <aColumn> is 0, <br>
//!  or at the end of the paragraph if <aRow> is 0. <br>
  Standard_EXPORT     void AddText(const TCollection_ExtendedString& aText,const Standard_Integer aRow = 0,const Standard_Integer aColumn = 0) ;
  //! Changes a text in the paragraph at a row-column position, <br>
//!	    don't change the attributes of the text. <br>
//!  Warning: May do nothing if the row-column don't exist in the <br>
//!	   paragraph. <br>
  Standard_EXPORT     void ChangeText(const TCollection_ExtendedString& aText,const Standard_Integer aRow,const Standard_Integer aColumn) ;
  //! Clear ALL the text in the paragraph <me>. <br>
  Standard_EXPORT     void Clear() ;
  //! Returns Standard_True if the Paragraph <me> follows <br>
//!          the scale factor of the view. <br>
  Standard_EXPORT     Standard_Boolean IsZoomable() const;
  //! Returns the size of the paragraph <me> . <br>
  Standard_EXPORT     void Size(Quantity_Length& aWidth,Quantity_Length& aHeight) const;
  //! Returns the paragraph position. <br>
  Standard_EXPORT     void Position(Quantity_Length& X,Quantity_Length& Y) const;
  //! Returns the paragraph Offset. <br>
  Standard_EXPORT     Aspect_CardinalPoints Offset(Quantity_Length& Dx,Quantity_Length& Dy) const;
  //! Returns the paragraph orientation. <br>
  Standard_EXPORT     Quantity_PlaneAngle Angle() const;
  //! Returns the paragraph slant. <br>
  Standard_EXPORT     Quantity_PlaneAngle Slant() const;
  //! Returns the paragraph spacing ratio. <br>
  Standard_EXPORT     Quantity_Ratio Spacing() const;
  //! Returns the paragraph margin value. <br>
  Standard_EXPORT     Quantity_Length Margin() const;
  //! Returns the paragraph hiding color index. <br>
  Standard_EXPORT     Standard_Integer HidingColorIndex() const;
  //! Returns the paragraph frame color index. <br>
  Standard_EXPORT     Standard_Integer FrameColorIndex() const;
  //! Returns the paragraph frame width index. <br>
  Standard_EXPORT     Standard_Integer FrameWidthIndex() const;
  //! Returns the text string and attributes of rank <aRank>. <br>
  Standard_EXPORT     TCollection_ExtendedString Text(const Standard_Integer aRank,Standard_Integer& aRow,Standard_Integer& aColumn,Standard_Integer& aColorIndex,Standard_Integer& aFontIndex,Graphic2d_TypeOfAlignment& anAlignment) const;
  //! Returns Standard_True if the current Driver used is enabled <br>
//!         to get the right size and offsets in the <br>
//!         world size parameter <aWidth>,<aHeight>,<anXoffset>,<anYoffset> <br>
//!         depending of the attributes of the paragraph text position <br>
//!	    <aRank> and the current scale of the view. <br>
//!          NOTE that the text offsets defines the relative position of the <br>
//!         of the text string origin from the lower left corner of the text <br>
//!         boundary limits. <br>
  Standard_EXPORT     Standard_Boolean TextSize(const Standard_Integer aRank,Quantity_Length& aWidth,Quantity_Length& aHeight,Quantity_Length& anXoffset,Quantity_Length& anYoffset) const;
  //! Returns the number of Text of the paragraph <me>. <br>
  Standard_EXPORT     Standard_Integer Length() const;
  //! Returns the number of Row of the paragraph <me>. <br>
  Standard_EXPORT     Standard_Integer MaxRow() const;
  //! Returns the number of Column of the paragraph <me>. <br>
  Standard_EXPORT     Standard_Integer MaxColumn() const;
  //! Computes the MinMax of the paragraph if possible. <br>
  Standard_EXPORT     Standard_Boolean ComputeMinMax() ;
  
  Standard_EXPORT   virtual  void Save(Aspect_FStream& aFStream) const;




  DEFINE_STANDARD_RTTI(Graphic2d_Paragraph)

protected:

  //! Draws the paragraph <me>. <br>
  Standard_EXPORT     void Draw(const Handle(Graphic2d_Drawer)& aDrawer) ;
  //! Returns Standard_True if the paragraph <me> is picked, <br>
//!	    Standard_False if not. <br>
  Standard_EXPORT     Standard_Boolean Pick(const Standard_ShortReal X,const Standard_ShortReal Y,const Standard_ShortReal aPrecision,const Handle(Graphic2d_Drawer)& aDrawer) ;



private: 


Standard_ShortReal myX;
Standard_ShortReal myY;
Standard_ShortReal myXoffset;
Standard_ShortReal myYoffset;
Aspect_CardinalPoints myOffset;
Standard_ShortReal myWidth;
Standard_ShortReal myHeight;
Standard_ShortReal myAngle;
Standard_ShortReal mySlant;
Standard_ShortReal mySpacing;
Standard_ShortReal myMargin;
Standard_ShortReal myScale;
Standard_Boolean myIsZoomable;
Standard_Integer myFrameColorIndex;
Standard_Integer myFrameWidthIndex;
Standard_Integer myHidingColorIndex;
Standard_Integer myCurrentColorIndex;
Standard_Integer myCurrentFontIndex;
Standard_ShortReal myCurrentFontHScale;
Standard_ShortReal myCurrentFontWScale;
Graphic2d_TypeOfAlignment myCurrentAlignment;
Standard_Boolean myCurrentUnderline;
TColStd_SequenceOfExtendedString myTextStringList;
TColStd_SequenceOfInteger myTextDescriptorList;
TShort_SequenceOfShortReal myTextXpositionList;
TShort_SequenceOfShortReal myTextYpositionList;
TShort_SequenceOfShortReal myTextFheightList;
TShort_SequenceOfShortReal myTextFoffsetList;
TShort_SequenceOfShortReal myTextHScaleList;
TShort_SequenceOfShortReal myTextWScaleList;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
