// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IntTools_ShrunkRange_HeaderFile
#define _IntTools_ShrunkRange_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _TopoDS_Edge_HeaderFile
#include <TopoDS_Edge.hxx>
#endif
#ifndef _TopoDS_Vertex_HeaderFile
#include <TopoDS_Vertex.hxx>
#endif
#ifndef _IntTools_Range_HeaderFile
#include <IntTools_Range.hxx>
#endif
#ifndef _Bnd_Box_HeaderFile
#include <Bnd_Box.hxx>
#endif
#ifndef _Handle_IntTools_Context_HeaderFile
#include <Handle_IntTools_Context.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class IntTools_Context;
class TopoDS_Edge;
class TopoDS_Vertex;
class IntTools_Range;
class Bnd_Box;



//!  The class provides the computation of <br>
//!  a working (shrunk) range [t1, t2] for <br>
//!  the 3D-curve of the edge. <br>
class IntTools_ShrunkRange  {
public:

  DEFINE_STANDARD_ALLOC

  
//! Empty constructor <br>
  Standard_EXPORT   IntTools_ShrunkRange();
  
  Standard_EXPORT   IntTools_ShrunkRange(const TopoDS_Edge& aE,const TopoDS_Vertex& aV1,const TopoDS_Vertex& aV2,const IntTools_Range& aR,const Handle(IntTools_Context)& ICtx);
  
//! Sets the intersecton context <br>
//! <br>
  Standard_EXPORT     void SetContext(const Handle(IntTools_Context)& aContext) ;
  
//! Gets the intersecton context <br>
  Standard_EXPORT    const Handle_IntTools_Context& Context() const;
  
//! Sets an shrunk range <br>
  Standard_EXPORT     void SetShrunkRange(const IntTools_Range& aR) ;
  
//! Returns shrunk range <br>
  Standard_EXPORT    const IntTools_Range& ShrunkRange() const;
  
//! Returns bounding box for edge restricted <br>
//! by shrunk range <br>
  Standard_EXPORT    const Bnd_Box& BndBox() const;
  
//! Returns edge for which <br>
//! the shrunk range is computed <br>
  Standard_EXPORT    const TopoDS_Edge& Edge() const;
  
//! Computes shrunk range for <br>
//! an edge given in constructor <br>
//! <br>
  Standard_EXPORT     void Perform() ;
  
//! Returns true if no error occured <br>
//! during shrunk range computation <br>
  Standard_EXPORT     Standard_Boolean IsDone() const;
  
//! Returns code of computing shrunk range <br>
//! completion <br>
//! 0 - means successful completion <br>
//! 1 - nothing has been done <br>
//! 2 - initial range is out of edge's range <br>
//! 3 - first boundary of initial range is more than <br>
//!     last boundary <br>
//! 4 - projection of first vertex failed <br>
//! 5 - projection of second vertex failed <br>
//! 6 - shrunk range can not be computed <br>
//!     shrunk range is setted to initial range <br>
  Standard_EXPORT     Standard_Integer ErrorStatus() const;





protected:





private:



TopoDS_Edge myEdge;
TopoDS_Vertex myV1;
TopoDS_Vertex myV2;
IntTools_Range myRange;
IntTools_Range myShrunkRange;
Bnd_Box myBndBox;
Handle_IntTools_Context myContext;
Standard_Boolean myIsDone;
Standard_Integer myErrorStatus;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
