// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _MMgt_StackManager_HeaderFile
#define _MMgt_StackManager_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Standard_OutOfMemory;
class Standard_ProgramError;



//!   The class <StackManager> provides primitive facilities for managing <br>
//!   stack-based storage. <br>
//! <br>
class MMgt_StackManager  {
public:

  DEFINE_STANDARD_ALLOC

  
//!   Constructs a StackManager with an empty free stack. <br>
  Standard_EXPORT   MMgt_StackManager();
  
//!   Returns the address of a storage of the given size located on <br>
//!   the top of the free stack. <br>
  Standard_EXPORT     Standard_Address Allocate(const Standard_Integer size) ;
  
//!   Deallocates the storage of the given size from the free stack <br>
//!   and nullify the address. <br>
  Standard_EXPORT     void Free(Standard_Address& aStack,const Standard_Integer aSize) ;
  
//!   There is no way to have a "ShallowCopy" of a "StackManager" <br>
  Standard_EXPORT     MMgt_StackManager ShallowCopy() const;
  
//!   Prints the contents of <me> on the stream <s>. <br>
  Standard_EXPORT     void ShallowDump(Standard_OStream& S) const;
  
//!    Deallocates the storage associated to stack. <br>
//!    Delete <me>. <br>
  Standard_EXPORT     void Destructor() ;
~MMgt_StackManager()
{
  Destructor();
}





protected:





private:

  
//!   Deallocates the storage associated to stack. <br>
  Standard_EXPORT     void Purge() ;


Standard_Integer myFreeListSize;
Standard_Address myFreeList;


};





// other Inline functions and methods (like "C++: function call" methods)
inline MMgt_StackManager ShallowCopy(const MMgt_StackManager& me) {
 return me.ShallowCopy();
}

inline void ShallowDump(const MMgt_StackManager& me,Standard_OStream& S) {
 me.ShallowDump(S);
}



#endif
