// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _OSD_HeaderFile
#define _OSD_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _OSD_Signals_HeaderFile
#include <OSD_Signals.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_PCharacter_HeaderFile
#include <Standard_PCharacter.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
class OSD_Error;
class OSD_Protection;
class OSD_Path;
class OSD_FileNode;
class OSD_Disk;
class OSD_File;
class OSD_FileIterator;
class OSD_Directory;
class OSD_DirectoryIterator;
class OSD_Chronometer;
class OSD_Timer;
class OSD_Printer;
class OSD_Host;
class OSD_Environment;
class OSD_EnvironmentIterator;
class OSD_Process;
class OSD_SharedMemory;
class OSD_Semaphore;
class OSD_MailBox;
class OSD_SharedLibrary;
class OSD_Thread;
class OSD_Real2String;
class OSD_Localizer;


//! Set of Operating Sytem Dependent Tools <br>
//!         (O)perating (S)ystem (D)ependent <br>
class OSD  {
public:

  DEFINE_STANDARD_ALLOC

  
//!   1) Arms some floating point signals, and sets a "Handler" for them. <br>
//!   2) Sets a "Handler" for the "Hardware" signals. <br>
//!   For Win32 users: under VC++ you can control which method of handling <br>
//!   exceptions is used by means of UseSETranslator method before calling <br>
//!   SetSignal <br>
  Standard_EXPORT   static  void SetSignal(const Standard_Boolean aFloatingSignal = Standard_True) ;
  //! Returns available memory in Kilobytes. <br>
  Standard_EXPORT   static  Standard_Integer AvailableMemory() ;
  //! Commands the process to sleep for a number of seconds. <br>
  Standard_EXPORT   static  void SecSleep(const Standard_Integer aDelay) ;
  //! Commands the process to sleep for a number of milliseconds <br>
  Standard_EXPORT   static  void MilliSecSleep(const Standard_Integer aDelay) ;
  
//!  Converts aReal into aCstring in exponential format with a period as <br>
//!  decimal point, no thousand separator and no grouping of digits. <br>
//!  The conversion is independant from the current locale <br>
  Standard_EXPORT   static  Standard_Boolean RealToCString(const Standard_Real aReal,Standard_PCharacter& aString) ;
  
//!  Converts aCstring representing a real with a period as <br>
//!  decimal point, no thousand separator and no grouping of digits <br>
//!  into aReal . <br>
//!  The conversion is independant from the current locale. <br>
  Standard_EXPORT   static  Standard_Boolean CStringToReal(const Standard_CString aString,Standard_Real& aReal) ;
  //! Tests if the quotient theDividend/theDivisor <br>
//!          does not overflow <br>
  Standard_EXPORT   static  Standard_Boolean IsDivisible(const Standard_Real aDividend,const Standard_Real aDivisor) ;
  //! Returns the exponent in base 2 of a floating-point number. <br>
  Standard_EXPORT   static  Standard_Integer GetExponent(const Standard_Real aReal) ;
  //! Returns the mantissa of a floating-point number. <br>
  Standard_EXPORT   static  Standard_Real GetMantissa(const Standard_Real aReal) ;
  //! since Windows NT does not support 'SIGINT' signal like UNIX, <br>
//!          then this method checks whether Ctrl-Break keystroke was or <br>
//!          not. If yes then raises Exception_CTRL_BREAK. <br>
  Standard_EXPORT   static  void ControlBreak() ;
  //! Defines whether SetSignal must use _se_translator_function or <br>
//!          SetUnhandledExceptionFilter and signal to catch system <br>
//!          exceptions. The default behaviour is to use SE translator. <br>
//!  Warning: Using SE translator method SetSignal should be called for each <br>
//!          new created thread, while using the alternative method <br>
//!          the exception handler is established once for the whole <br>
//!          process and all its threads. <br>
//!          This function takes effect only under VC++ compiler. <br>
  Standard_EXPORT   static  void UseSETranslator(const Standard_Boolean useSE) ;
  //! Returns the current value of the flag set by above method. <br>
  Standard_EXPORT   static  Standard_Boolean UseSETranslator() ;





protected:





private:

  
  Standard_EXPORT   static  void Handler(const OSD_Signals aSignal,const Standard_Address aSigInfo,const Standard_Address aContext) ;
  
  Standard_EXPORT   static  void SegvHandler(const OSD_Signals aSignal,const Standard_Address aSigInfo,const Standard_Address aContext) ;
  
//!  1) Raises an exception if the exception due to floating point errors. <br>
//!     Flosting point errors: <br>
//!     EXCEPTION_FLT_DENORMAL_OPERAND <br>
//!     EXCEPTION_FLT_DIVIDE_BY_ZERO <br>
//!     EXCEPTION_FLT_INEXACT_RESULT <br>
//!     EXCEPTION_FLT_INVALID_OPERATION <br>
//!     EXCEPTOPN_FLT_OVERFLOW <br>
//!     EXCEPTION_FLT_STACK_CHECK <br>
//!     EXCEPTION_FLT_UNDERFLOW <br>
//!  2) Displays a message box 'Continue' - 'Debugger' - 'Stop' if the environment <br>
//!     variable 'CSF_EXCEPTION_PROMPT' is set and takes appropriate action. <br>
//!     Raises an exception otherwise. <br>
  Standard_EXPORT   static  Standard_Integer WntHandler(const Standard_Address exceptionInfo) ;



friend class OSD_Error;
friend class OSD_Protection;
friend class OSD_Path;
friend class OSD_FileNode;
friend class OSD_Disk;
friend class OSD_File;
friend class OSD_FileIterator;
friend class OSD_Directory;
friend class OSD_DirectoryIterator;
friend class OSD_Chronometer;
friend class OSD_Timer;
friend class OSD_Printer;
friend class OSD_Host;
friend class OSD_Environment;
friend class OSD_EnvironmentIterator;
friend class OSD_Process;
friend class OSD_SharedMemory;
friend class OSD_Semaphore;
friend class OSD_MailBox;
friend class OSD_SharedLibrary;
friend class OSD_Thread;
friend class OSD_Real2String;
friend class OSD_Localizer;

};





// other Inline functions and methods (like "C++: function call" methods)


#endif
