// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Visual3d_ContextView_HeaderFile
#define _Visual3d_ContextView_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Visual3d_TypeOfModel_HeaderFile
#include <Visual3d_TypeOfModel.hxx>
#endif
#ifndef _Visual3d_TypeOfVisualization_HeaderFile
#include <Visual3d_TypeOfVisualization.hxx>
#endif
#ifndef _TColStd_SequenceOfAddress_HeaderFile
#include <TColStd_SequenceOfAddress.hxx>
#endif
#ifndef _Handle_Graphic3d_TextureEnv_HeaderFile
#include <Handle_Graphic3d_TextureEnv.hxx>
#endif
#ifndef _Visual3d_TypeOfSurfaceDetail_HeaderFile
#include <Visual3d_TypeOfSurfaceDetail.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Visual3d_ClipPlane_HeaderFile
#include <Handle_Visual3d_ClipPlane.hxx>
#endif
#ifndef _Handle_Visual3d_Light_HeaderFile
#include <Handle_Visual3d_Light.hxx>
#endif
#ifndef _Handle_Visual3d_HSetOfClipPlane_HeaderFile
#include <Handle_Visual3d_HSetOfClipPlane.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Visual3d_HSetOfLight_HeaderFile
#include <Handle_Visual3d_HSetOfLight.hxx>
#endif
class Graphic3d_TextureEnv;
class Visual3d_ClipDefinitionError;
class Visual3d_DepthCueingDefinitionError;
class Visual3d_LightDefinitionError;
class Visual3d_ZClippingDefinitionError;
class Visual3d_ClipPlane;
class Visual3d_Light;
class Visual3d_HSetOfClipPlane;
class Visual3d_HSetOfLight;


//! This class manages the creation and update of <br>
//!	    a visualization context for one view in the viewer. <br>
//!	    A context is defined by : <br>
//!	    Antialiasing. <br>
//!	    ZClipping. <br>
//!	    Depth-cueing. <br>
//!	    The type of visualization. <br>
//!	    The light sources. <br>
class Visual3d_ContextView  {
public:

  DEFINE_STANDARD_ALLOC

  //! Creates a context from default values <br>
  Standard_EXPORT   Visual3d_ContextView();
  //! Selects the kind of rendering <br>
//!          default to: TOSD_NONE <br>
  Standard_EXPORT     void SetSurfaceDetail(const Visual3d_TypeOfSurfaceDetail TOSD) ;
  //! Sets the environment texture to use <br>
//!          no environment texture by default <br>
  Standard_EXPORT     void SetTextureEnv(const Handle(Graphic3d_TextureEnv)& ATexture) ;
  //! Activates antialiasing. <br>
//!	Antialiasing can be activated on all the structures <br>
//!	in the view <br>
  Standard_EXPORT     void SetAliasingOn() ;
  //! Deactivates the antialiasing. <br>
  Standard_EXPORT     void SetAliasingOff() ;
  //! Modifies the back depth-cueing plane. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises DepthCueingDefinitionError if <BackPlane> <br>
//!	    is front of <FrontPlane> and DepthCueing is ON. <br>
  Standard_EXPORT     void SetDepthCueingBackPlane(const Standard_Real ABack) ;
  //! Modifies the front depth-cueing plane. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises DepthCueingDefinitionError if <BackPlane> is <br>
//!	    front of <FrontPlane> and DepthCueing is ON. <br>
  Standard_EXPORT     void SetDepthCueingFrontPlane(const Standard_Real ABack) ;
  //! Activates the depth-cueing. <br>
//!	Depth-cueing can be activated on all structures <br>
//!	present in the view. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises DepthCueingDefinitionError if <BackPlane> is <br>
//!	    front of <FrontPlane>. <br>
  Standard_EXPORT     void SetDepthCueingOn() ;
  //! Deactivates the depth-cueing. <br>
  Standard_EXPORT     void SetDepthCueingOff() ;
  //! Activates the clipping plane <AClipPlane> <br>
  Standard_EXPORT     void SetClipPlaneOn(const Handle(Visual3d_ClipPlane)& AClipPlane) ;
  //! Deactivates the clipping plane <AClipPlane> <br>
  Standard_EXPORT     void SetClipPlaneOff(const Handle(Visual3d_ClipPlane)& AClipPlane) ;
  //! Activates the light source <ALight> <br>
  Standard_EXPORT     void SetLightOn(const Handle(Visual3d_Light)& ALight) ;
  //! Deactivates the light source <ALight> <br>
  Standard_EXPORT     void SetLightOff(const Handle(Visual3d_Light)& ALight) ;
  //! Modifies the shading model when the type of <br>
//!	    visualization is TOV_SHADING <br>
  Standard_EXPORT     void SetModel(const Visual3d_TypeOfModel AModel) ;
  //! Modifies the mode of visualization. <br>
  Standard_EXPORT     void SetVisualization(const Visual3d_TypeOfVisualization AVisual) ;
  //! Modifies the back Z-clipping plane. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises ZClippingDefinitionError if <BackPlane> is <br>
//!	    front of <FrontPlane> and ZClipping is ON. <br>
  Standard_EXPORT     void SetZClippingBackPlane(const Standard_Real ABack) ;
  //! Modifies the front Z-clipping plane. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises ZClippingDefinitionError if <BackPlane> is <br>
//!	    front of <FrontPlane> and ZClipping is ON. <br>
  Standard_EXPORT     void SetZClippingFrontPlane(const Standard_Real AFront) ;
  //! Activates the Z-clipping planes defined by <br>
//!	    SetZClippingFrontPlane and SetZClippingBackPlane. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises ZClippingDefinitionError if <BackPlane> is <br>
//!	    front of <FrontPlane>. <br>
  Standard_EXPORT     void SetZClippingOn() ;
  //! Deactivates the Z-clipping planes defined by <br>
//!	    SetFrontPlane and SetBackPlane. <br>
  Standard_EXPORT     void SetZClippingOff() ;
  //! Activates the front Z-clipping plane defined by <br>
//!	    SetFrontPlane method. <br>
  Standard_EXPORT     void SetFrontZClippingOn() ;
  //! Deactivates the front Z-clipping plane defined by <br>
//!	    SetFrontPlane method. <br>
  Standard_EXPORT     void SetFrontZClippingOff() ;
  //! Activates the back Z-clipping plane defined by <br>
//!	    SetBackPlane method. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises ZClippingDefinitionError if <BackPlane> is <br>
//!	    front of <FrontPlane>. <br>
  Standard_EXPORT     void SetBackZClippingOn() ;
  //! Deactivates the back Z-clipping plane defined by <br>
//!	    SetBackPlane method. <br>
  Standard_EXPORT     void SetBackZClippingOff() ;
  //! Returns the group of active clipping planes <br>
//!	    in the view of context <me>. <br>
  Standard_EXPORT     Handle_Visual3d_HSetOfClipPlane ActivatedClipPlanes() const;
  //! Returns the number of active clipping planes <br>
//!	    in the view of context <me>. <br>
  Standard_EXPORT     Standard_Integer NumberOfActivatedClipPlanes() const;
  
  Standard_EXPORT     Handle_Visual3d_ClipPlane ActivatedClipPlane(const Standard_Integer AnIndex) const;
  //! Returns the group of active light sources <br>
//!	    in the view of context <me>. <br>
  Standard_EXPORT     Handle_Visual3d_HSetOfLight ActivatedLights() const;
  //! Returns the number of active light sources <br>
//!	    in the view of context <me>. <br>
  Standard_EXPORT     Standard_Integer NumberOfActivatedLights() const;
  
  Standard_EXPORT     Handle_Visual3d_Light ActivatedLight(const Standard_Integer AnIndex) const;
  //! Returns the activity of the aliasing. <br>
  Standard_EXPORT     Standard_Boolean AliasingIsOn() const;
  //! Returns the activity of the ZClipping. <br>
  Standard_EXPORT     Standard_Boolean BackZClippingIsOn() const;
  //! Returns the definition of the back depth-cueing plane. <br>
  Standard_EXPORT     Standard_Real DepthCueingBackPlane() const;
  //! Returns the definition of the front depth-cueing plane. <br>
  Standard_EXPORT     Standard_Real DepthCueingFrontPlane() const;
  //! Returns the activity of the depth-cueing. <br>
  Standard_EXPORT     Standard_Boolean DepthCueingIsOn() const;
  //! Returns the activity of the ZClipping. <br>
  Standard_EXPORT     Standard_Boolean FrontZClippingIsOn() const;
  //! Returns the shading model. <br>
  Standard_EXPORT     Visual3d_TypeOfModel Model() const;
  //! Returns the mode of visualization. <br>
  Standard_EXPORT     Visual3d_TypeOfVisualization Visualization() const;
  //! Returns the definition of the back Z-clipping plane. <br>
  Standard_EXPORT     Standard_Real ZClippingBackPlane() const;
  //! Returns the definition of the front Z-clipping plane. <br>
  Standard_EXPORT     Standard_Real ZClippingFrontPlane() const;
  
  Standard_EXPORT     Visual3d_TypeOfSurfaceDetail SurfaceDetail() const;
  
  Standard_EXPORT     Handle_Graphic3d_TextureEnv TextureEnv() const;





protected:





private:



Standard_Boolean AliasingIsActive;
Standard_Boolean ZcueingIsActive;
Standard_Boolean FrontZclippingIsActive;
Standard_Boolean BackZclippingIsActive;
Standard_ShortReal MyZclippingFrontPlane;
Standard_ShortReal MyZclippingBackPlane;
Standard_ShortReal MyDepthCueingFrontPlane;
Standard_ShortReal MyDepthCueingBackPlane;
Visual3d_TypeOfModel MyModel;
Visual3d_TypeOfVisualization MyVisual;
TColStd_SequenceOfAddress MyLights;
TColStd_SequenceOfAddress MyClipPlanes;
Handle_Graphic3d_TextureEnv MyTextureEnv;
Visual3d_TypeOfSurfaceDetail MySurfaceDetail;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
