// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _TDF_CopyTool_HeaderFile
#define _TDF_CopyTool_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Handle_TDF_DataSet_HeaderFile
#include <Handle_TDF_DataSet.hxx>
#endif
#ifndef _Handle_TDF_RelocationTable_HeaderFile
#include <Handle_TDF_RelocationTable.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TDF_DataSet;
class TDF_RelocationTable;
class TDF_IDFilter;
class TDF_Label;
class TDF_LabelDataMap;
class TDF_AttributeDataMap;
class TDF_LabelMap;
class TDF_AttributeMap;


//! This class provides services to build, copy or <br>
//!          paste a set of information. <br>
//! <br>
//!          Copy methods: <br>
//!          ------------- <br>
//! <br>
//!          * Copy(aSourceDataSet, aTargetLabel, <br>
//!          aRelocationTable) copies a source DataSet under <br>
//!          its target place (see below: IMPORTANT NOTICE 1). <br>
//! <br>
//!          * Copy(aSourceDataSet, anTargetLabel, <br>
//!          aRelocationTable, aFilter) does the same job as <br>
//!          the previous method. But <aFilter> gives a list of <br>
//!          IDs for which a target attribute prevails over a <br>
//!          source one. In this special case, the source <br>
//!          attribute will be copied only if there will be no <br>
//!          target attribute. <br>
//! <br>
//! <br>
//!          IMPORTANT NOTICE : Label pre-binding <br>
//!          ------------------ <br>
//! <br>
//!          For it is possible to copy root labels in another <br>
//!          place in the same Data or in a different one with <br>
//!          other tags, it is necessary to inform the Copy <br>
//!          algorithm about the target place. To do so: <br>
//! <br>
//!          * first get or create new target root labels; <br>
//! <br>
//!          * then bind them with the source root labels using <br>
//!          the relocation table method: <br>
//!          SetRelocation(aSourceLabel, aTargetLabel); <br>
//! <br>
//!          * finally call Copy(...) with the relocation table <br>
//!          previously set. In this way, this method will take <br>
//!          these relocations in account. <br>
class TDF_CopyTool  {
public:

  DEFINE_STANDARD_ALLOC

  //!  Copy   <aSourceDataSet> with using  and  updating <br>
//!           <aRelocationTable>. This  method ignores   target <br>
//!          attributes privilege over source ones. <br>
  Standard_EXPORT   static  void Copy(const Handle(TDF_DataSet)& aSourceDataSet,const Handle(TDF_RelocationTable)& aRelocationTable) ;
  //!    Copy  <aSourceDataSet>  using      and updating <br>
//!          <aRelocationTable>. Use <aPrivilegeFilter> to give <br>
//!           a list  of   IDs for which  the target  attribute <br>
//!          prevails over the source one. <br>
  Standard_EXPORT   static  void Copy(const Handle(TDF_DataSet)& aSourceDataSet,const Handle(TDF_RelocationTable)& aRelocationTable,const TDF_IDFilter& aPrivilegeFilter) ;
  //!   Copy    <aSourceDataSet>   using and    updating <br>
//!          <aRelocationTable>. Use <aPrivilegeFilter> to give <br>
//!           a  list of IDs   for which  the target  attribute <br>
//!             prevails    over    the    source     one.   If <br>
//!            <setSelfContained>   is   set  to   true,  every <br>
//!          TDF_Reference will  be replaced  by the referenced <br>
//!          structure according to <aRefFilter>. <br>
//! <br>
//!          NB: <aRefFilter> is used only if <br>
//!          <setSelfContained> is true. <br>//! Internal root label copy recursive method. <br>
  Standard_EXPORT   static  void Copy(const Handle(TDF_DataSet)& aSourceDataSet,const Handle(TDF_RelocationTable)& aRelocationTable,const TDF_IDFilter& aPrivilegeFilter,const TDF_IDFilter& aRefFilter,const Standard_Boolean setSelfContained) ;





protected:





private:

  //! Internal root label copy recursive method. <br>
  Standard_EXPORT   static  void CopyLabels(const TDF_Label& aSLabel,TDF_Label& aTargetLabel,TDF_LabelDataMap& aLabMap,TDF_AttributeDataMap& aAttMap,const TDF_LabelMap& aSrcLabelMap,const TDF_AttributeMap& aSrcAttributeMap) ;
  //! Internal attribute copy method. <br>
  Standard_EXPORT   static  void CopyAttributes(const TDF_Label& aSLabel,TDF_Label& aTargetLabel,TDF_AttributeDataMap& aAttMap,const TDF_AttributeMap& aSrcAttributeMap) ;




};





// other Inline functions and methods (like "C++: function call" methods)


#endif
