// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _gce_MakeCylinder_HeaderFile
#define _gce_MakeCylinder_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _gp_Cylinder_HeaderFile
#include <gp_Cylinder.hxx>
#endif
#ifndef _gce_Root_HeaderFile
#include <gce_Root.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class StdFail_NotDone;
class gp_Ax2;
class gp_Cylinder;
class gp_Pnt;
class gp_Ax1;
class gp_Circ;


//! This class implements the following algorithms used <br>
//!           to create a Cylinder from gp. <br>
//!           * Create a Cylinder coaxial to another and passing <br>
//!             through a point. <br>
//!           * Create a Cylinder coaxial to another at a distance <br>
//!             <Dist>. <br>
//!           * Create a Cylinder with 3 points. <br>
//!           * Create a Cylinder by its axis and radius. <br>
//!           * Create a cylinder by its circular base. <br>
class gce_MakeCylinder  : public gce_Root {
public:

  DEFINE_STANDARD_ALLOC

  //!<A2> is the local cartesian coordinate system of <me>. <br>
//!           The status is "NegativeRadius" if R < 0.0 <br>
  Standard_EXPORT   gce_MakeCylinder(const gp_Ax2& A2,const Standard_Real Radius);
  //! Makes a Cylinder from gp <TheCylinder> coaxial to another <br>
//!           Cylinder <Cylinder> and passing through a Pnt <Point>. <br>
  Standard_EXPORT   gce_MakeCylinder(const gp_Cylinder& Cyl,const gp_Pnt& Point);
  //! Makes a Cylinder from gp <TheCylinder> coaxial to another <br>
//!           Cylinder <Cylinder> at the distance <Dist> which can <br>
//!           be greater or lower than zero. <br>
//!           The radius of the result is the absolute value of the <br>
//!           radius of <Cyl> plus <Dist> <br>
  Standard_EXPORT   gce_MakeCylinder(const gp_Cylinder& Cyl,const Standard_Real Dist);
  //! Makes a Cylinder from gp <TheCylinder> with 3 points <br>
//!           <P1>,<P2>,<P3>. <br>
//!           Its axis is <P1P2> and its radius is the distance <br>
//!           between <P3> and <P1P2> <br>
  Standard_EXPORT   gce_MakeCylinder(const gp_Pnt& P1,const gp_Pnt& P2,const gp_Pnt& P3);
  //! Makes a Cylinder by its axis <Axis> and radius <Radius>. <br>
  Standard_EXPORT   gce_MakeCylinder(const gp_Ax1& Axis,const Standard_Real Radius);
  //! Makes a Cylinder by its circular base. <br>
//! Warning <br>
//! If an error occurs (that is, when IsDone returns <br>
//! false), the Status function returns: <br>
//! -   gce_NegativeRadius if: <br>
//!   -   Radius is less than 0.0, or <br>
//!   -   Dist is negative and has an absolute value <br>
//!    which is greater than the radius of Cyl; or <br>
//! -   gce_ConfusedPoints if points P1 and P2 are coincident. <br>
  Standard_EXPORT   gce_MakeCylinder(const gp_Circ& Circ);
  //! Returns the constructed cylinder. <br>
//! Exceptions StdFail_NotDone if no cylinder is constructed. <br>
  Standard_EXPORT    const gp_Cylinder& Value() const;
  
  Standard_EXPORT    const gp_Cylinder& Operator() const;
Standard_EXPORT operator gp_Cylinder() const;





protected:





private:



gp_Cylinder TheCylinder;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
