// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BOPTools_RoughShapeIntersector_HeaderFile
#define _BOPTools_RoughShapeIntersector_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _BooleanOperations_PShapesDataStructure_HeaderFile
#include <BooleanOperations_PShapesDataStructure.hxx>
#endif
#ifndef _Handle_Bnd_HArray1OfBox_HeaderFile
#include <Handle_Bnd_HArray1OfBox.hxx>
#endif
#ifndef _Handle_BOPTools_HArray2OfIntersectionStatus_HeaderFile
#include <Handle_BOPTools_HArray2OfIntersectionStatus.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _BOPTools_IntersectionStatus_HeaderFile
#include <BOPTools_IntersectionStatus.hxx>
#endif
class Bnd_HArray1OfBox;
class BOPTools_HArray2OfIntersectionStatus;


//! The class RoughShapeIntersector describes the algorithm of <br>
//!         intersection of bounding boxes of <br>
//!         shapes stored in ShapesDataStructure. <br>
//!         It stores statuses of intersection in 2 dimension array. <br>
class BOPTools_RoughShapeIntersector  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
//! Initializes algorithm by shapes data structure <br>
  Standard_EXPORT   BOPTools_RoughShapeIntersector(const BooleanOperations_PShapesDataStructure& PDS);
  
//! Perform computations. <br>
  Standard_EXPORT     void Perform() ;
  
//!  Returns 2 dimension array of status flags. <br>
//! First indices of the array corresponds to indices of <br>
//! subshapes of Object of myPDS. <br>
//! Second indices of array corresponds to indices of <br>
//! subshapes of Tool of myPDS. <br>
  Standard_EXPORT    const Handle_BOPTools_HArray2OfIntersectionStatus& TableOfStatus() const;
  
//! Returns False if some errors occured during <br>
//! computations or method Perform <br>
//! was not invoked before, <br>
//! otherwise returns True. <br>
  Standard_EXPORT     Standard_Boolean IsDone() const;





protected:





private:

  
  Standard_EXPORT     void Prepare() ;
  
  Standard_EXPORT     void PropagateForSuccessors1(const Standard_Integer AncestorsIndex1,const Standard_Integer AncestorsIndex2,const BOPTools_IntersectionStatus theStatus) ;
  
  Standard_EXPORT     void PropagateForSuccessors2(const Standard_Integer AncestorsIndex1,const Standard_Integer AncestorsIndex2,const BOPTools_IntersectionStatus theStatus) ;


BooleanOperations_PShapesDataStructure myPDS;
Handle_Bnd_HArray1OfBox myBoundingBoxes;
Handle_BOPTools_HArray2OfIntersectionStatus myTableOfStatus;
Standard_Boolean myIsDone;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
