// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepTools_Quilt_HeaderFile
#define _BRepTools_Quilt_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _TopTools_IndexedDataMapOfShapeShape_HeaderFile
#include <TopTools_IndexedDataMapOfShapeShape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_NoSuchObject;
class TopoDS_Edge;
class TopoDS_Vertex;
class TopoDS_Shape;


//! A  Tool    to  glue faces  at  common    edges and <br>
//!          reconstruct shells. <br>
//! <br>
//!          The user designate pairs of common edges using the <br>
//!          method Bind. One edge is designated as the edge to <br>
//!          use  in place of the  other one (they are supposed <br>
//!          to   be    geometrically confused,  but  this  not <br>
//!          checked). They can be of opposite directions, this <br>
//!          is specified by the orientations. <br>
//! <br>
//!          The user can add  shapes with the Add method,  all <br>
//!          the faces are  registred and  copies of faces  and <br>
//!          edges are made to glue at the bound edges. <br>
//! <br>
//!          The user can call the Shells  methods to compute a <br>
//!          compound of shells from the current set of faces. <br>
//! <br>
//!          If no  binding is made  this class can  be used to <br>
//!          make shell from faces already sharing their edges. <br>
class BRepTools_Quilt  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
  Standard_EXPORT   BRepTools_Quilt();
  //! Binds <Enew> to   be  the  new edge  instead   of <br>
//!          <Eold>. <br>
//! <br>
//!          The faces  of  the added  shape containing  <Eold> <br>
//!          will be copied to substitute <Eold> by <Enew>. <br>
//! <br>
//!          The vertices  of   <Eold> will   be bound to   the <br>
//!          vertices of <Enew> with the same orientation. <br>
//! <br>
//!          If <Eold>  and <Enew>  have different orientations <br>
//!          the curves are considered  to be opposite  and the <br>
//!          pcurves of <Eold>  will be copied  and reversed in <br>
//!          the new faces. <br>
//! <br>
//!          <Eold> must belong to the next added shape, <Enew> must belong <br>
//!          to a Shape added before. <br>
  Standard_EXPORT     void Bind(const TopoDS_Edge& Eold,const TopoDS_Edge& Enew) ;
  //! Binds <VNew> to be a new vertex instead of <Vold>. <br>
//! <br>
//!          The faces  of  the added  shape containing  <Vold> <br>
//!          will be copied to substitute <Vold> by <Vnew>. <br>
  Standard_EXPORT     void Bind(const TopoDS_Vertex& Vold,const TopoDS_Vertex& Vnew) ;
  //! Add   the faces of  <S>  to  the Quilt,  the faces <br>
//!          containing bounded edges are copied. <br>
  Standard_EXPORT     void Add(const TopoDS_Shape& S) ;
  //! Returns   True if <S> has   been  copied (<S> is a <br>
//!          vertex, an edge or a face) <br>
  Standard_EXPORT     Standard_Boolean IsCopied(const TopoDS_Shape& S) const;
  //! Returns the shape  substitued to <S> in the Quilt. <br>
//! <br>
  Standard_EXPORT    const TopoDS_Shape& Copy(const TopoDS_Shape& S) const;
  //! Returns a Compound of shells made from the current <br>
//!          set of faces. The shells will be flagged as closed <br>
//!          or not closed. <br>
  Standard_EXPORT     TopoDS_Shape Shells() const;





protected:





private:



TopTools_IndexedDataMapOfShapeShape myBounds;
Standard_Boolean hasCopy;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
