// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GC_MakeMirror_HeaderFile
#define _GC_MakeMirror_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Handle_Geom_Transformation_HeaderFile
#include <Handle_Geom_Transformation.hxx>
#endif
class Geom_Transformation;
class gp_Pnt;
class gp_Ax1;
class gp_Lin;
class gp_Dir;
class gp_Pln;
class gp_Ax2;


//! This class implements elementary construction algorithms for a <br>
//! symmetrical transformation in 3D space about a point, <br>
//! axis or plane. The result is a Geom_Transformation transformation. <br>
//! A MakeMirror object provides a framework for: <br>
//! -   defining the construction of the transformation, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the result. <br>
class GC_MakeMirror  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
  Standard_EXPORT   GC_MakeMirror(const gp_Pnt& Point);
  
  Standard_EXPORT   GC_MakeMirror(const gp_Ax1& Axis);
  
  Standard_EXPORT   GC_MakeMirror(const gp_Lin& Line);
  //! Make a symetry transformation af axis defined by <br>
//!          <Point> and <Direc>. <br>
  Standard_EXPORT   GC_MakeMirror(const gp_Pnt& Point,const gp_Dir& Direc);
  //! Make a symetry transformation of plane <Plane>. <br>
  Standard_EXPORT   GC_MakeMirror(const gp_Pln& Plane);
  //! Make a symetry transformation of plane <Plane>. <br>
  Standard_EXPORT   GC_MakeMirror(const gp_Ax2& Plane);
  //! Returns the constructed transformation. <br>
  Standard_EXPORT    const Handle_Geom_Transformation& Value() const;
  
  Standard_EXPORT    const Handle_Geom_Transformation& Operator() const;
Standard_EXPORT operator Handle_Geom_Transformation() const;





protected:





private:



Handle_Geom_Transformation TheMirror;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
