// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _gp_Ax3_HeaderFile
#define _gp_Ax3_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _gp_Ax1_HeaderFile
#include <gp_Ax1.hxx>
#endif
#ifndef _gp_Dir_HeaderFile
#include <gp_Dir.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif
class Standard_ConstructionError;
class gp_Ax2;
class gp_Pnt;
class gp_Dir;
class gp_Ax1;
class gp_Trsf;
class gp_Vec;


Standard_EXPORT const Handle(Standard_Type)& STANDARD_TYPE(gp_Ax3);

//! Describes a coordinate system in 3D space. Unlike a <br>
//!  gp_Ax2 coordinate system, a gp_Ax3 can be <br>
//! right-handed ("direct sense") or left-handed ("indirect sense"). <br>
//! A coordinate system is defined by: <br>
//! -   its origin (also referred to as its "Location point"), and <br>
//! -   three orthogonal unit vectors, termed the "X <br>
//!   Direction", the "Y Direction" and the "Direction" (also <br>
//!   referred to as the "main Direction"). <br>
//! The "Direction" of the coordinate system is called its <br>
//! "main Direction" because whenever this unit vector is <br>
//! modified, the "X Direction" and the "Y Direction" are <br>
//! recomputed. However, when we modify either the "X <br>
//! Direction" or the "Y Direction", "Direction" is not modified. <br>
//! "Direction" is also the "Z Direction". <br>
//! The "main Direction" is always parallel to the cross <br>
//! product of its "X Direction" and "Y Direction". <br>
//! If the coordinate system is right-handed, it satisfies the equation: <br>
//! "main Direction" = "X Direction" ^ "Y Direction" <br>
//! and if it is left-handed, it satisfies the equation: <br>
//! "main Direction" = -"X Direction" ^ "Y Direction" <br>
//! A coordinate system is used: <br>
//! -   to describe geometric entities, in particular to position <br>
//!   them. The local coordinate system of a geometric <br>
//!   entity serves the same purpose as the STEP function <br>
//!   "axis placement three axes", or <br>
//! -   to define geometric transformations. <br>
//! Note: <br>
//! -   We refer to the "X Axis", "Y Axis" and "Z Axis", <br>
//!   respectively, as the axes having: <br>
//! -   the origin of the coordinate system as their origin, and <br>
//! -   the unit vectors "X Direction", "Y Direction" and <br>
//!    "main Direction", respectively, as their unit vectors. <br>
//! -   The "Z Axis" is also the "main Axis". <br>
//! -   gp_Ax2 is used to define a coordinate system that must be always right-handed. <br>
class gp_Ax3  {

public:
  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Creates an object corresponding to the reference <br>
//!            coordinate system (OXYZ). <br>
  Standard_EXPORT   gp_Ax3();
  //! Creates  a  coordinate  system from a right-handed <br>
//!          coordinate system. <br>
  Standard_EXPORT   gp_Ax3(const gp_Ax2& A);
  //!  Creates a  right handed axis placement with the <br>
//!  "Location"  point  P  and  two  directions, N    gives the <br>
//!  "Direction" and Vx gives the "XDirection". <br>
//!  Raises ConstructionError if N and Vx are parallel (same or opposite orientation). <br>
  Standard_EXPORT   gp_Ax3(const gp_Pnt& P,const gp_Dir& N,const gp_Dir& Vx);
  
//!  Creates an axis placement with the  "Location" point <P> <br>
//!  and the normal direction <V>. <br>
  Standard_EXPORT   gp_Ax3(const gp_Pnt& P,const gp_Dir& V);
  //! Reverses the X direction of <me>. <br>
  Standard_EXPORT     void XReverse() ;
  //! Reverses the Y direction of <me>. <br>
  Standard_EXPORT     void YReverse() ;
  //! Reverses the Z direction of <me>. <br>
  Standard_EXPORT     void ZReverse() ;
  //! Assigns the origin and "main Direction" of the axis A1 to <br>
//! this coordinate system, then recomputes its "X Direction" and "Y Direction". <br>
//! Note: <br>
//! -   The new "X Direction" is computed as follows: <br>
//! new "X Direction" = V1 ^(previous "X Direction" ^ V) <br>
//! where V is the "Direction" of A1. <br>
//! -   The orientation of this coordinate system <br>
//!   (right-handed or left-handed) is not modified. <br>
//!  Raises ConstructionError  if the "Direction" of <A1> and the "XDirection" of <me> <br>
//!  are parallel (same or opposite orientation) because it is <br>
//!  impossible to calculate the new "XDirection" and the new <br>
//!  "YDirection". <br>
  Standard_EXPORT     void SetAxis(const gp_Ax1& A1) ;
  
//!  Changes the main direction of this coordinate system, <br>
//! then recomputes its "X Direction" and "Y Direction". <br>
//! Note: <br>
//! -   The new "X Direction" is computed as follows: <br>
//! new "X Direction" = V ^ (previous "X Direction" ^ V). <br>
//! -   The orientation of this coordinate system (left- or right-handed) is not modified. <br>
//! Raises ConstructionError if <V< and the previous "XDirection" are parallel <br>
//!  because it is impossible to calculate the new "XDirection" <br>
//!  and the new "YDirection". <br>
  Standard_EXPORT     void SetDirection(const gp_Dir& V) ;
  
//!  Changes the "Location" point (origin) of <me>. <br>
  Standard_EXPORT     void SetLocation(const gp_Pnt& P) ;
  
//!  Changes the "Xdirection" of <me>. The main direction <br>
//!  "Direction" is not modified, the "Ydirection" is modified. <br>
//!  If <Vx> is not normal to the main direction then <XDirection> <br>
//!  is computed as follows XDirection = Direction ^ (Vx ^ Direction). <br>
//! Raises ConstructionError if <Vx> is parallel (same or opposite <br>
//! orientation) to the main direction of <me> <br>
  Standard_EXPORT     void SetXDirection(const gp_Dir& Vx) ;
  
//!  Changes the "Ydirection" of <me>. The main direction is not <br>
//!  modified but the "Xdirection" is changed. <br>
//!  If <Vy> is not normal to the main direction then "YDirection" <br>
//!  is computed as  follows <br>
//!  YDirection = Direction ^ (<Vy> ^ Direction). <br>
//! Raises ConstructionError if <Vy> is parallel to the main direction of <me> <br>
        void SetYDirection(const gp_Dir& Vy) ;
  
//!  Computes the angular value between the main direction of <br>
//!  <me> and the main direction of <Other>. Returns the angle <br>
//!  between 0 and PI in radians. <br>
        Standard_Real Angle(const gp_Ax3& Other) const;
  
//!  Returns the main axis of <me>. It is the "Location" point <br>
//!  and the main "Direction". <br>
       const gp_Ax1& Axis() const;
  //! Computes a right-handed coordinate system with the <br>
//! same "X Direction" and "Y Direction" as those of this <br>
//! coordinate system, then recomputes the "main Direction". <br>
//! If this coordinate system is right-handed, the result <br>
//! returned is the same coordinate system. If this <br>
//! coordinate system is left-handed, the result is reversed. <br>
  Standard_EXPORT     gp_Ax2 Ax2() const;
  
//!  Returns the main direction of <me>. <br>
       const gp_Dir& Direction() const;
  
//!  Returns the "Location" point (origin) of <me>. <br>
       const gp_Pnt& Location() const;
  
//!  Returns the "XDirection" of <me>. <br>
       const gp_Dir& XDirection() const;
  
//!  Returns the "YDirection" of <me>. <br>
       const gp_Dir& YDirection() const;
  //! Returns  True if  the  coordinate  system is right-handed. i.e. <br>
//!          XDirection().Crossed(YDirection()).Dot(Direction()) > 0 <br>
        Standard_Boolean Direct() const;
  
//!  Returns True if <br>
//!  . the distance between the "Location" point of <me> and <br>
//!    <Other> is lower or equal to LinearTolerance and <br>
//!  . the distance between the "Location" point of <Other> and <br>
//!    <me> is lower or equal to LinearTolerance and <br>
//!  . the main direction of <me> and the main direction of <br>
//!    <Other> are parallel (same or opposite orientation). <br>
        Standard_Boolean IsCoplanar(const gp_Ax3& Other,const Standard_Real LinearTolerance,const Standard_Real AngularTolerance) const;
  //! Returns True if <br>
//!  . the distance between <me> and the "Location" point of A1 <br>
//!    is lower of equal to LinearTolerance and <br>
//!  . the distance between A1 and the "Location" point of <me> <br>
//!    is lower or equal to LinearTolerance and <br>
//!  . the main direction of <me> and the direction of A1 are normal. <br>
        Standard_Boolean IsCoplanar(const gp_Ax1& A1,const Standard_Real LinearTolerance,const Standard_Real AngularTolerance) const;
  
  Standard_EXPORT     void Mirror(const gp_Pnt& P) ;
  
//!  Performs the symmetrical transformation of an axis <br>
//!  placement with respect to the point P which is the <br>
//!  center of the symmetry. <br>
//!  Warnings : <br>
//!  The main direction of the axis placement is not changed. <br>
//!  The "XDirection" and the "YDirection" are reversed. <br>
//!  So the axis placement stay right handed. <br>
  Standard_EXPORT     gp_Ax3 Mirrored(const gp_Pnt& P) const;
  
  Standard_EXPORT     void Mirror(const gp_Ax1& A1) ;
  
//!  Performs the symmetrical transformation of an axis <br>
//!  placement with respect to an axis placement which <br>
//!  is the axis of the symmetry. <br>
//!  The transformation is performed on the "Location" <br>
//!  point, on the "XDirection" and "YDirection". <br>
//!  The resulting main "Direction" is the cross product between <br>
//!  the "XDirection" and the "YDirection" after transformation. <br>
  Standard_EXPORT     gp_Ax3 Mirrored(const gp_Ax1& A1) const;
  
  Standard_EXPORT     void Mirror(const gp_Ax2& A2) ;
  
//!  Performs the symmetrical transformation of an axis <br>
//!  placement with respect to a plane. <br>
//!  The axis placement  <A2> locates the plane of the symmetry : <br>
//!  (Location, XDirection, YDirection). <br>
//!  The transformation is performed on the "Location" <br>
//!  point, on the "XDirection" and "YDirection". <br>
//!  The resulting main "Direction" is the cross product between <br>
//!  the "XDirection" and the "YDirection" after transformation. <br>
  Standard_EXPORT     gp_Ax3 Mirrored(const gp_Ax2& A2) const;
  
  Standard_EXPORT     void Rotate(const gp_Ax1& A1,const Standard_Real Ang) ;
  
//!  Rotates an axis placement. <A1> is the axis of the <br>
//!  rotation . Ang is the angular value of the rotation <br>
//!  in radians. <br>
  Standard_EXPORT     gp_Ax3 Rotated(const gp_Ax1& A1,const Standard_Real Ang) const;
  
  Standard_EXPORT     void Scale(const gp_Pnt& P,const Standard_Real S) ;
  
//!  Applies a scaling transformation on the axis placement. <br>
//!  The "Location" point of the axisplacement is modified. <br>
//! Warnings : <br>
//!  If the scale <S> is negative : <br>
//!   . the main direction of the axis placement is not changed. <br>
//!   . The "XDirection" and the "YDirection" are reversed. <br>
//!  So the axis placement stay right handed. <br>
  Standard_EXPORT     gp_Ax3 Scaled(const gp_Pnt& P,const Standard_Real S) const;
  
  Standard_EXPORT     void Transform(const gp_Trsf& T) ;
  
//!  Transforms an axis placement with a Trsf. <br>
//!  The "Location" point, the "XDirection" and the <br>
//!  "YDirection" are transformed with T.  The resulting <br>
//!  main "Direction" of <me> is the cross product between <br>
//!  the "XDirection" and the "YDirection" after transformation. <br>
  Standard_EXPORT     gp_Ax3 Transformed(const gp_Trsf& T) const;
  
  Standard_EXPORT     void Translate(const gp_Vec& V) ;
  
//!  Translates an axis plaxement in the direction of the vector <br>
//!  <V>. The magnitude of the translation is the vector's magnitude. <br>
  Standard_EXPORT     gp_Ax3 Translated(const gp_Vec& V) const;
  
  Standard_EXPORT     void Translate(const gp_Pnt& P1,const gp_Pnt& P2) ;
  
//!  Translates an axis placement from the point <P1> to the <br>
//!  point <P2>. <br>
  Standard_EXPORT     gp_Ax3 Translated(const gp_Pnt& P1,const gp_Pnt& P2) const;
    const gp_Ax1& _CSFDB_Getgp_Ax3axis() const { return axis; }
    const gp_Dir& _CSFDB_Getgp_Ax3vydir() const { return vydir; }
    const gp_Dir& _CSFDB_Getgp_Ax3vxdir() const { return vxdir; }



protected:




private: 


gp_Ax1 axis;
gp_Dir vydir;
gp_Dir vxdir;


};


#include <gp_Ax3.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
