#ifndef __MIX_H
#define __MIX_H

struct mixchannel
{
	void *samp;
	unsigned long length;
	unsigned long loopstart;
	unsigned long loopend;
	unsigned long replen;
	signed long step;
	unsigned long pos;
	unsigned short fpos;
	unsigned short status;
	union
	{
		void *voltabs[2];
		short vols[2];
		float volfs[2];
	} vol;
};

extern int mixInit(void (*getchan)(int ch, struct mixchannel *chn, int rate), int resamp, int chan, int amp);
extern void mixClose(void);
extern void mixSetAmplify(int amp);
extern void mixGetRealVolume(int ch, int *l, int *r);
extern void mixGetMasterSample(short *s, int len, int rate, int opt);
extern int mixGetChanSample(int ch, short *s, int len, int rate, int opt);
extern int mixAddChanSample(int ch, short *s, int len, int rate);
extern void mixGetRealMasterVolume(int *l, int *r);

#define MIX_PLAYING 1
#define MIX_MUTE 2
#define MIX_LOOPED 4
#define MIX_PINGPONGLOOP 8
#define MIX_PLAY16BIT 16
#define MIX_INTERPOLATE 32
#define MIX_MAX 64
#define MIX_PLAY32BIT 128

#endif
