/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * assembler routines for FPU mixer
 *
 * revision history: (please note changes here)
 *  -kbwhenever Tammo Hinrichs <opencp@gmx.net>
 *    -first release
 *  -ryg990426  Fabian Giesen  <fabian@jdcs.su.nw.schule.de>
 *    -extreeeeem kbchangesapplying+sklavenarbeitverrichting
 *     (was mir angst macht, ich finds nichmal schlimm)
 *  -ryg990504  Fabian Giesen  <fabian@jdcs.su.nw.schule.de>
 *    -added float postprocs, the key to player realtimeruling
 *  -kb990531   Tammo Hinrichs <opengp@gmx.net>
 *    -fixed mono playback
 *    -cubic spline interpolation now works
 *  -ss04????   Stian Skjelstad <stian@nixia.no>
 *    -ported to gcc
 *  -ss040908   Stian Skjelstad <stian@nixia.no>
 *    -made it optimizesafe
 *
 * dominators und doc rooles geiler floating point mixer mit volume ramps
 * (die man gar nicht benutzen kann (kb sagt man kann). und mit
 * ultra-rauschabstand und viel geil interpolation.
 * wir sind besser als ihr...
 */

#include "config.h"
#include "types.h"
#include "dwmixfa.h"

#define MAXVOICES MIXF_MAXCHAN
#define FLAG_DISABLED (~MIXF_PLAYING)
float   *tempbuf;               /* pointer to 32 bit mix buffer (nsamples * 4) */
void    *outbuf;                /* pointer to mixed buffer (nsamples * 2) */
uint32_t nsamples;              /* # of samples to mix */
uint32_t nvoices;               /* # of voices to mix */
uint32_t freqw[MAXVOICES];      /* frequency (whole part) */
uint32_t freqf[MAXVOICES];      /* frequency (fractional part) */
float   *smpposw[MAXVOICES];    /* sample position (whole part (pointer!)) */
uint32_t smpposf[MAXVOICES];    /* sample position (fractional part) */
float   *loopend[MAXVOICES];    /* pointer to loop end */
uint32_t looplen[MAXVOICES];    /* loop length in samples */
float    volleft[MAXVOICES];    /* float: left volume (1.0=normal) */
float    volright[MAXVOICES];   /* float: rite volume (1.0=normal) */
float    rampleft[MAXVOICES];   /* float: left volramp (dvol/sample) */
float    rampright[MAXVOICES];  /* float: rite volramp (dvol/sample) */
uint32_t voiceflags[MAXVOICES]; /* voice status flags */
float    ffreq[MAXVOICES];      /* filter frequency (0<=x<=1) */
float    freso[MAXVOICES];      /* filter resonance (0<=x<1) */
float    fadeleft=0.0;          /* 0 */
float    fl1[MAXVOICES];        /* filter lp buffer */
float    fb1[MAXVOICES];        /* filter bp buffer */
float    faderight=0.0;         /* 0 */
int      isstereo;              /* flag for stereo output */
int      outfmt;                /* output format */
float    voll;
float    volr;
float    ct0[256];              /* interpolation tab for s[-1] */
float    ct1[256];              /* interpolation tab for s[0] */
float    ct2[256];              /* interpolation tab for s[1] */
float    ct3[256];              /* interpolation tab for s[2] */
struct mixfpostprocregstruct *postprocs;
                                /* pointer to postproc list */
uint32_t samprate;              /* sampling rate */




static float volrl;
static float volrr;

static float eins=1.0;
static float minuseins=-1.0;
static float clampmax=32767.0;
static float clampmin=-32767.0;
static float cremoveconst=0.992;
static float minampl=0.0001; /* what the fuck? why is this a float? - stian */
static float magic1;  /* 32bit in assembler used */
static int clipval; /* 16bit in assembler used */
static int mixlooplen; /* 32bit in assembler used, decimal. lenght of loop in samples*/
static int looptype; /* 32bit in assembler used */
static float ffrq;
static float frez;
static float __fl1;
static float __fb1;

void start_dwmixfa(void)
{
	volrl=volrl;
	volrr=volrr;
	eins=eins;
	minuseins=minuseins;
	clampmin=clampmin;
	clampmax=clampmax;
	cremoveconst=cremoveconst;
	minampl=minampl;
	magic1=magic1;
	clipval=clipval;
	mixlooplen=mixlooplen;
	looptype=looptype;
	ffrq=ffrq;
	frez=frez;
	__fl1=__fl1;
	__fb1=__fb1;
}

void prepare_mixer (void)
{
	__asm__ __volatile__
	(
		"xorl %%eax, %%eax\n"
		"movl %%eax, fadeleft\n"
		"movl %%eax, faderight\n"
		"movl %%eax, volrl\n"
		"movl %%eax, volrr\n"
		:
		: "n" (MAXVOICES)
		: "eax"
	);
}


void mixer (void)
{
	__asm__ __volatile__
	(
#ifdef __PIC__
	 	"pushl %%ebx\n"
#endif
	 	"pushl %%ebp\n"
		"finit\n"

		/* range check for declick values */
		"  xorl %%ebx, %%ebx\n"
		"  movl fadeleft, %%eax\n"
		"  andl $0x7fffffff, %%eax\n"
		"  cmpl %%eax, minampl\n"
		"  ja mixer_nocutfl\n"
		"  movl %%ebx, fadeleft\n"
	"  mixer_nocutfl:\n"
		"  movl faderight, %%eax\n"
		"  andl $0x7fffffff, %%eax\n"
		"  cmpl %%eax, minampl\n"
		"  ja mixer_nocutfr\n"
		"  movl %%ebx, faderight\n"
	"  mixer_nocutfr:\n"

		/* clear and declick buffer */
		"  movl tempbuf, %%edi\n"
		"  movl nsamples, %%ecx\n"
		"  orl %%ecx, %%ecx\n"
		"  jz mixer_endall\n"
		"  movl isstereo, %%eax\n"
		"  orl %%eax, %%eax\n"
		"  jnz mixer_clearst\n"
		"    call clearbufm\n"
		"    jmp mixer_clearend\n"
	"  mixer_clearst:\n"
		"  call clearbufs\n"
	"  mixer_clearend:\n"

		"  movl nvoices, %%ecx\n"
		"  decl %%ecx\n"

	"  mixer_MixNext:\n"

		"    movl voiceflags(,%%ecx,4), %%eax\n"
		"    testl %0, %%eax\n"
		"    jz mixer_SkipVoice\n"
  
		/* set loop type */
		"    movl %%eax, looptype\n"

		/* calc l/r relative vols from vol/panning/amplification */
		"    movl volleft(,%%ecx,4), %%eax\n"
		"    movl volright(,%%ecx,4), %%ebx\n"
		"    movl %%eax, voll\n"
		"    movl %%ebx, volr\n"

		"    movl rampleft(,%%ecx,4), %%eax\n"
		"    movl rampright(,%%ecx,4), %%ebx\n"
		"    movl %%eax, volrl\n"
		"    movl %%ebx, volrr\n"

		/* set up filter vals */
		"    movl ffreq(,%%ecx,4), %%eax\n"
		"    movl %%eax, ffrq\n"
		"    movl freso(,%%ecx,4), %%eax\n"
		"    movl %%eax, frez\n"
		"    movl fl1(,%%ecx,4), %%eax\n"
		"    movl %%eax, __fl1\n"
		"    movl fb1(,%%ecx,4), %%eax\n"
		"    movl %%eax, __fb1\n"
  
		/* length of loop */
		"    movl looplen(,%%ecx,4), %%eax\n"
		"    movl %%eax, mixlooplen\n"
  
		/* sample delta: */
		"    movl freqw(,%%ecx,4), %%ebx\n"
		"    movl freqf(,%%ecx,4), %%esi\n"

		/* Sample base Pointer */
		"    movl smpposw(,%%ecx,4), %%eax\n"
  
		/* sample base ptr fraction part */
		"    movl smpposf(,%%ecx,4), %%edx\n"

		/* Loop end Pointer */
		"    movl loopend(,%%ecx,4), %%ebp\n"

		"    pushl %%ecx\n"
		"    movl tempbuf, %%edi\n"
		"    movl voiceflags(,%%ecx,4), %%ecx\n"
		"    andl $15, %%ecx\n"
		"    movl mixers(,%%ecx,4), %%ecx\n"
		"    call *%%ecx\n"
		"    popl %%ecx\n"

		/* calculate sample relative position */
		"    movl %%eax, smpposw(,%%ecx,4)\n"
		"    movl %%edx, smpposf(,%%ecx,4)\n"

		/* update flags */
		"    movl looptype, %%eax\n"
		"    movl %%eax, voiceflags(,%%ecx,4)\n"

		/* update volumes */
		"    movl voll, %%eax\n"
		"    movl %%eax, volleft(,%%ecx,4)\n"
		"    movl volr, %%eax\n"
		"    movl %%eax, volright(,%%ecx,4)\n"

		/* update filter buffers */
		"    movl __fl1, %%eax\n"
		"    movl %%eax, fl1(,%%ecx,4)\n"
		"    movl __fb1, %%eax\n"
		"    movl %%eax, fb1(,%%ecx,4)\n"

	"    mixer_SkipVoice:\n"
		"    decl %%ecx\n"
		"  jns mixer_MixNext\n"

/* ryg990504 - changes for floatpostprocs start here */

/* how parameters are sent needs to be redone for gcc
 *
 * (and even gcc can been overriden for an arch due to optimization)
 *          - Stian    TODO TODO TODO TODO
 */
		"  movl postprocs, %%esi\n"

	"  mixer_PostprocLoop:\n"
		"    orl %%esi, %%esi\n"
		"    jz mixer_PostprocEnd\n"

		"    movl nsamples, %%edx\n"
		"    movl isstereo, %%ecx\n"
		"    movl samprate, %%ebx\n"
		"    movl tempbuf, %%eax\n"
		"    call *%%esi\n"

		"    movl 12(%%esi), %%esi\n"

		"  jmp mixer_PostprocLoop\n"

	"mixer_PostprocEnd:\n"

/* ryg990504 - changes for floatpostprocs end here */
		"  movl outfmt, %%eax\n"
		"  movl clippers(,%%eax,4), %%eax\n"

		"  movl outbuf, %%edi\n"
		"  movl tempbuf, %%esi\n"
		"  movl nsamples, %%ecx\n"

		"  movl isstereo, %%edx\n"
		"  orl %%edx, %%edx\n"
		"  jz mixer_clipmono\n"
		"    addl %%ecx, %%ecx\n"
	"mixer_clipmono:\n"

		"  call *%%eax\n"

	"mixer_endall:\n"
		"popl %%ebp\n"
#ifdef __PIC__
	 	"popl %%ebx\n"
#endif

		:
		: "n"(MIXF_PLAYING)
#ifdef __PIC__
		: "memory", "eax", "ecx", "edx", "edi", "esi"
#else
		: "memory", "eax", "ebx", "ecx", "edx", "edi", "esi"
#endif
	);
}

static __attribute__ ((used)) void dummy(void)
{
	
/* clear routines:
 * edi : 32 bit float buffer
 * ecx : # of samples
 */

/* clears and declicks tempbuffer (mono) */
	__asm__ __volatile__
	(
	"clearbufm:\n"
		"flds cremoveconst\n"        /* (fc) */
		"flds fadeleft\n"            /* (fl) (fc) */

	"clearbufm_clloop:\n"
		"  fsts (%edi)\n"
		"  fmul %st(1),%st\n"        /* (fl') (fc) */
		"  leal 4(%edi), %edi\n"
		"  decl %ecx\n"
		"jnz clearbufm_clloop\n"

		"fstps fadeleft\n"           /* (fc) */
		"fstp %st\n"                 /* - */

		"ret\n"
	);


/* clears and declicks tempbuffer (stereo)
 * edi : 32 bit float buffer
 * ecx : # of samples
 */
	__asm__ __volatile__
	(
	"clearbufs:\n"
		"flds cremoveconst\n"        /* (fc) */
		"flds faderight\n"           /* (fr) (fc) */
		"flds fadeleft\n"            /* (fl) (fr) (fc) */

	"clearbufs_clloop:\n"
		"  fsts (%edi)\n"
		"  fmul %st(2), %st\n"       /* (fl') (fr) (fc) */
		"  fxch %st(1)\n"            /* (fr) (fl') (fc) */
		"  fsts 4(%edi)\n"
		"  fmul %st(2), %st\n"       /* (fr') (fl') (fc) */
		"  fxch %st(1)\n"            /* (fl') (fr') (fc) */
		"  leal 8(%edi),%edi\n"
		"  decl %ecx\n"
		"jnz clearbufs_clloop\n"

		"fstps fadeleft\n"           /* (fr') (fc) */
		"fstps faderight\n"          /* (fc) */
		"fstp %st\n"                 /* - */

		"ret\n"
	);


/*
 * mixing routines:
 * eax = sample base ptr.
 * edi = dest ptr auf outbuffer
 * ecx = # of samples to mix
 * ebx = delta to next sample (whole part)
 * edx = fraction of sample position
 * esi = fraction of sample delta
 * ebp = ptr to loop end
 */

	__asm__ __volatile__
	(
	"mix_0:\n"
	/* mixing, MUTED
	 * quite sub-obtimal to do this with a loop, too, but this is really
	 * the only way to ensure maximum precision - and it's fully using
	 * the vast potential of the coder's lazyness.
	 */
		"movl nsamples, %%ecx\n"
		"shrl $2, %%ebp\n"
		"movl %%ebp, 2+mix_0_SM1\n" /* nasty self-modifying code. Kids, don't do this at home */
		"movl %%eax, %%ebp\n"
		"shrl $2, %%ebp\n"
	"mix_0_next:\n"
		"  addl %%esi, %%edx\n"
		"  adcl %%ebx, %%ebp\n"
	"mix_0_SM1:\n"
		"  cmpl $12345678, %%ebp\n"
		"  jge mix_0_LoopHandler\n"
		"  decl %%ecx\n"
		"jnz mix_0_next\n"
	"mix_0_ende:\n"
		"shll $2, %%ebp\n"
		"movl %%ebp, %%eax\n"
		"ret\n"
	"mix_0_LoopHandler:\n"
		"movl looptype, %%eax\n"
		"testl %0, %%eax\n"
		"jnz mix_0_loopme\n"
		"movl looptype, %%eax\n"
		"andl %1, %%eax\n"
		"movl %%eax, looptype\n"
		"jmp mix_0_ende\n"
	"mix_0_loopme:\n"
		"subl mixlooplen, %%ebp\n"
		"decl %%eax\n"
		"jz mix_0_ende\n"
		"jmp mix_0_next\n"
		:
		: "n"(MIXF_LOOPED),
		  "n"(FLAG_DISABLED)
	);

	__asm__ __volatile__
	(
	"mixm_n:\n"
	/* mixing, mono w/o interpolation
	 */
		"movl nsamples, %%ecx\n"
		"flds voll\n"                /* (vl) */
		"shrl $2, %%ebp\n"
		"movl %%ebp, mixm_n_SM1+2\n" /* self modifying code.  set loop end position */
		"movl %%eax, %%ebp\n"
		"shrl $2, %%ebp\n"
	/* align dword we don't need.. alignment is 32bit by default on gnu i386*/
	"mixm_n_next:\n"                     /* (vl) */
		"  flds (,%%ebp,4)\n"        /* (wert) (vl) */
		"  fld %%st(1)\n"            /* (vl) (wert) (vl) */
		"  addl %%esi, %%edx\n"
		"  leal 4(%%edi), %%edi\n"
		"  adcl %%ebx, %%ebp\n"
		"  fmulp %%st, %%st(1)\n"    /* (left) (vl) */
		"  fxch %%st(1)\n"           /* (vl) (left) */
		"  fadds volrl\n"            /* (vl') (left) */
		"  fxch %%st(1)\n"           /* (left) (vl) */
		"  fadds -4(%%edi)\n"        /* (lfinal) (vl') */
	"mixm_n_SM1:\n"
		"  cmpl $12345678, %%ebp\n"
		"  jge mixm_n_LoopHandler\n"
		"  fstps -4(%%edi)\n"        /* (vl') (-1) */
		"  decl %%ecx\n"
		"jnz mixm_n_next\n"
	"mixm_n_ende:\n"
		"fstps voll\n"               /* - */
		"shll $2, %%ebp\n"
		"movl %%ebp, %%eax\n"
		"ret\n"

	"mixm_n_LoopHandler:\n"
		"fstps -4(%%edi)\n"          /* (vl') */
		"movl looptype, %%eax\n"
		"testl %0, %%eax\n"
		"jnz mixm_n_loopme\n"
		"subl %%esi, %%edx\n"
		"sbbl %%ebx, %%ebp\n"
		"flds (,%%ebp,4)\n"          /* (wert) (vl) */
	"mixm_n_fill:\n" /*  sample ends -> fill rest of buffer with last sample value */
		"  fld %%st(1)\n"            /* (vl) (wert) (vl) */
		"  fmul %%st(1), %%st\n"     /* (left) (wert) (vl) */
		"  fadds -4(%%edi)\n"        /* (wert) (vl) */
		"  fstps -4(%%edi)\n"        /* (wert) (vl) */
		"  fxch %%st(1)\n"           /* (vl) (wert) */
		"  fadds volrl\n"            /* (vl') (wert) */
		"  fxch %%st(1)\n"           /* (wert) (vl') */
		"  leal 4(%%edi), %%edi\n"
		"  decl %%ecx\n"
		"jnz mixm_n_fill\n"
	/* update click-removal fade values */
		"fmul %%st(1), %%st\n"       /* (left) (vl) */
		"fadds fadeleft\n"           /* (fl') (vl) */
		"fstps fadeleft\n"           /* (vl) */
		"movl looptype, %%eax\n"
		"andl %1, %%eax\n"
		"movl %%eax, looptype\n"
		"jmp mixm_n_ende\n"

	"mixm_n_loopme:\n" /* sample loops -> jump to loop start */
		"subl mixlooplen, %%ebp\n"
		"decl %%ecx\n"
		"jz mixm_n_ende\n"
		"jmp mixm_n_next\n"
		:
		: "n"(MIXF_LOOPED),
		  "n"(FLAG_DISABLED)
	);

	__asm__ __volatile__
	(
	"mixs_n:\n"
	/* mixing, stereo w/o interpolation
	 */
		"movl nsamples, %%ecx\n"
		"flds voll\n"                /* (vl) */
		"flds volr\n"                /* (vr) (vl) */
		"shrl $2, %%ebp\n"
		"movl %%ebp,2+mixs_n_SM1\n"  /* self modifying code. set loop end position */
		"movl %%eax, %%ebp\n"
		"shrl $2, %%ebp\n"
	/* align dword.... we are already align 32bit */
	"mixs_n_next:\n"
		"  flds (,%%ebp,4)\n"        /* (wert) (vr) (vl) */
		"  addl %%esi, %%edx\n"
		"  leal 8(%%edi), %%edi\n"
		"  adcl %%ebx, %%ebp\n"
		"  fld %%st(1)\n"            /* (vr) (wert) (vr) (vl) */
		"  fld %%st(3)\n"            /* (vl) (vr) (wert) (vr) (vl) */
		"  fmul %%st(2), %%st\n"     /* (left) (vr) (wert) (vr) (vl) */
		"  fxch %%st(4)\n"           /* (vl)  (vr) (wert) (vr) (left) */
		"  fadds volrl\n"            /* (vl') (vr) (wert) (vr) (left) */
		"  fxch %%st(2)\n"           /* (wert) (vr) (vl') (vr) (left) */
		"  fmulp %%st(1)\n"          /* (right) (vl') (vr) (left) */
		"  fxch %%st(2)\n"           /* (vr) (vl') (right) (left) */
		"  fadds volrr\n"            /* (vr') (vl') (right) (left) */
		"  fxch %%st(3)\n"           /* (left)  (vl') (right) (vr') */
		"  fadds -8(%%edi)\n"        /* (lfinal) (vl') <right> (vr') */
		"  fxch %%st(2)\n"           /* (right) (vl') (lfinal) (vr') */
		"  fadds -4(%%edi)\n"        /* (rfinal) (vl') (lfinal) (vr') */
	"mixs_n_SM1:\n"
		"  cmpl $12345678, %%ebp\n"
		"  jge mixs_n_LoopHandler\n"
	/* hier 1 cycle frei */
		"  fstps -4(%%edi)\n"        /* (vl') (lfinal) (vr') */
		"  fxch %%st(1)\n"           /* (lfinal) (vl) (vr) */
		"  fstps -8(%%edi)\n"        /* (vl) (vr) */
		"  fxch %%st(1)\n"           /* (vr) (vl) */
		"  decl %%ecx\n"
		"jnz mixs_n_next\n"
	"mixs_n_ende:\n"
		"fstps volr\n"               /* (vl) */
		"fstps voll\n"               /* - */
		"shll $2, %%ebp\n"
		"movl %%ebp, %%eax\n"
		"ret\n"

	"mixs_n_LoopHandler:\n"
		"fstps -4(%%edi)\n"          /* (vl') (lfinal) (vr') */
		"fxch %%st(1)\n"             /* (lfinal) (vl) (vr) */
		"fstps -8(%%edi)\n"          /* (vl) (vr) */
		"fxch %%st(1)\n"             /* (vr) (vl) */
		"movl looptype, %%eax\n"
		"testl %0, %%eax\n"
		"jnz mixs_n_loopme\n"
		"fxch %%st(1)\n"             /* (vl) (vr) */
		"subl %%esi, %%edx\n"
		"sbbl %%ebx, %%ebp\n"
		"flds (,%%ebp,4)\n"          /* (wert) (vl) (vr) */
		"fxch %%st(2)\n"             /* (vr) (vl) (wert) */
	"mixs_n_fill:\n" /* sample ends -> fill rest of buffer with last sample value */
		"  fld %%st(1)\n"            /* (vl) (vr) (vl) (wert) */
		"  fmul %%st(3), %%st\n"     /* (left) (vr) (vl) (wert) */
		"  fxch %%st(1)\n"           /* (vr) (left) (vl) (wert) */
		"  fld %%st\n"               /* (vr) (vr) (left) (vl) (wert) */
		"  fmul %%st(4), %%st\n"     /* (right) (vr) (left) (vl) (wert) */
		"  fxch %%st(2)\n"           /* (left) (vr) (right) (vl) (wert) */
		"  fadds -8(%%edi)\n"
		"  fstps -8(%%edi)\n"        /* (vr) (right) (vl) (wert) */
		"  fxch %%st(1)\n"           /* (right) (vr) (vl) (wert) */
		"  fadds -4(%%edi)\n"
		"  fstps -4(%%edi)\n"        /* (vr) (vl) (wert) */
		"  fadds volrr\n"            /* (vr') (vl) (wert) */
		"  fxch %%st(1)\n"           /* (vl) (vr') (wert) */
		"  leal 8(%%edi), %%edi\n"
		"  decl %%ecx\n"
		"  fadds volrl\n"            /* (vl') (vr') (wert) */
		"  fxch %%st(1)\n"           /* (vr') (vl') (wert) */
		"jnz mixs_n_fill\n"
	/* update click-removal fade values */
		"fxch %%st(2)\n"             /* (wert) (vl) (vr) */
		"fld %%st\n"                 /* (wert) (wert) (vl) (vr) */
		"fmul %%st(2), %%st\n"       /* (left) (wert) (vl) (vr) */
		"fxch %%st(1)\n"             /* (wert) (left) (vl) (vr) */
		"fmul %%st(3), %%st\n"       /* (rite) (left) (vl) (vr) */
		"fxch %%st(1)\n"             /* (left) (rite) (vl) (vr) */
		"fadds fadeleft\n"           /* (fl') (rite) (vl) (vr) */
		"fxch %%st(1)\n"             /* (rite) (fl') (vl) (vr) */
		"fadds faderight\n"          /* (fr') (fl') (vl) (vr) */
		"fxch %%st(1)\n"             /* (fl') (fr') (vl) (vr) */
		"fstps fadeleft\n"           /* (fr') (vl) (vr) */
		"fstps faderight\n"          /* (vl) (vr) */
		"fxch %%st(1)\n"             /* (vr) (vl) */
		"movl looptype, %%eax\n"
		"andl %1, %%eax\n"
		"movl %%eax, looptype\n"
		"jmp mixs_n_ende\n"

	"mixs_n_loopme:\n"
	/* sample loops -> jump to loop start */
		"subl mixlooplen, %%ebp\n"
		"decl %%ecx\n"
		"jz mixs_n_ende\n"
		"jmp mixs_n_next\n"
		:
		: "n"(MIXF_LOOPED),
		  "n"(FLAG_DISABLED)
	);

	__asm__ __volatile__
	(
	"mixm_i:\n"
	/* mixing, mono+interpolation */
		"movl nsamples, %%ecx\n"
		"flds minuseins\n"           /* (-1) */
		"flds voll\n"                /* (vl) (-1) */
		"shrl $2, %%ebp\n"
		"movl %%ebp, mixm_i_SM1+2\n" /* self modifying code. set loop end position */
		"movl %%eax, %%ebp\n"
		"movl %%edx, %%eax\n"
		"shrl $9, %%eax\n"
		"shrl $2, %%ebp\n"
		"orl $0x38f00000, %%eax\n"
		"movl %%eax, magic1\n"

	/* align dword... we don't need to align shit here? */
	"mixm_i_next:\n"                     /* (vl) (-1) */
		"  flds 0(,%%ebp,4)\n"       /* (a) (vl) (-1) */
		"  fld %%st(0)\n"            /* (a) (a) (vl) (-1) */
		"  fld %%st(3)\n"            /* (-1) (a) (a) (vl) (-1) */
		"  fadds magic1\n"           /* (t) (a) (a) (vl) (-1) */
		"  fxch %%st(1)\n"           /* (a) (t) (a) (vl) (-1) */
		"  fsubrs 4(,%%ebp,4)\n"     /* (b-a) (t) (a) (vl) (-1) */
		"  addl %%esi, %%edx\n"
		"  leal 4(%%edi), %%edi\n"
		"  adcl %%ebx, %%ebp\n"
		"  fmulp %%st(1)\n"          /* ((b-a)*t) (a) (vl) (-1) */
		"  movl %%edx, %%eax\n"
		"  shrl $9, %%eax\n"
		"  faddp %%st(1)\n"          /* (wert) (vl) (-1) */
		"  fld %%st(1)\n"            /* (vl) (wert) (vl) (-1) */
		"  fmulp %%st, %%st(1)\n"    /* (left) (vl) (-1) */
		"  fxch %%st(1)\n"           /* (vl) (left) (-1) */
		"  fadds volrl\n"            /* (vl') (left) (-1) */
		"  fxch %%st(1)\n"           /* (left) (vl) (-1) */
		"  fadds -4(%%edi)\n"        /* (lfinal) (vl') (-1) */
		"  orl $0x3f800000, %%eax\n"
	"mixm_i_SM1:\n"
		"  cmpl $12345678, %%ebp\n"
		"  movl %%eax, magic1\n"
		"  jge mixm_i_LoopHandler\n"
	/* hier 1 cycle frei */
		"  fstps -4(%%edi)\n"        /* (vl') (-1) */
		"  decl %%ecx\n"
		"jnz mixm_i_next\n"
	"mixm_i_ende:\n"
		"fstps voll\n"               /* (whatever) */
		"fstp %%st\n"                /* - */
		"shll $2, %%ebp\n"
		"movl %%ebp, %%eax\n"
		"ret\n"

	"mixm_i_LoopHandler:\n"
		"fstps -4(%%edi)\n"          /* (vl') (-1) */
		"movl looptype, %%eax\n"
		"testl %0, %%eax\n"
		"jnz mixm_i_loopme\n"
		"subl %%esi, %%edx\n"
		"sbbl %%ebx, %%ebp\n"
		"flds (,%%ebp,4)\n"          /* (wert) (vl)  (-1) */
	"mixm_i_fill:\n" /* sample ends -> fill rest of buffer with last sample value */
		"  fld %%st(1)\n"            /* (vl) (wert) (vl)  (-1) */
		"  fmul %%st(1), %%st\n"     /* (left) (wert) (vl) (-1) */
		"  fadds -4(%%edi)\n"
		"  fstps -4(%%edi)\n"        /* (wert) (vl) (-1) */
		"  fxch %%st(1)\n"           /* (vl) (wert) (-1) */
		"  fadds volrl\n"            /* (vl') (wert) (-1) */
		"  fxch %%st(1)\n"           /* (wert) (vl') (-1) */
		"  leal 4(%%edi), %%edi\n"
		"  decl %%ecx\n"
		"jnz mixm_i_fill\n"
	/* update click-removal fade values */
		"fmul %%st(1), %%st\n"       /* (left) (vl) (-1) */
		"fadds fadeleft\n"           /* (fl') (vl) (-1) */
		"fstps fadeleft\n"           /* (vl) (-1) */
		"movl looptype, %%eax\n"
		"andl %1, %%eax\n"
		"movl %%eax, looptype\n"
		"jmp mixm_i_ende\n"

	"mixm_i_loopme:\n"
	/* sample loops -> jump to loop start */
		"subl mixlooplen, %%ebp\n"
		"decl %%ecx\n"
		"jz mixm_i_ende\n"
		"jmp mixm_i_next\n"
		:
		: "n"(MIXF_LOOPED),
		  "n"(FLAG_DISABLED)
	);

	__asm__ __volatile__
	(
	"mixs_i:\n"
	/* mixing, stereo+interpolation */
		"movl nsamples, %%ecx\n"
		"flds minuseins\n"           /* (-1) */
		"flds voll\n"                /* (vl) (-1) */
		"flds volr\n"                /* (vr) (vl) (-1) */
		"shrl $2, %%ebp\n"
		"movl %%ebp, 2+mixs_i_SM1\n" /* self modifying code. set loop end position */
		"movl %%eax, %%ebp\n"
		"movl %%edx, %%eax\n"
		"shrl $9, %%eax\n"
		"shrl $2, %%ebp\n"
		"orl $0x3f800000, %%eax\n"
		"movl %%eax, magic1\n"

	/* align dword... njet! */
	"mixs_i_next:\n"                     /* (vr) (vl) (-1) */
		"  flds 0(,%%ebp,4)\n"       /* (a) (vr) (vl) (-1) */
		"  fld %%st(0)\n"            /* (a) (a) (vr) (vl) (-1) */
		"  fld %%st(4)\n"            /* (-1) (a) (a) (vr) (vl) (-1) */
		"  fadds magic1\n"           /* (t) (a) (a) (vr) (vl) (-1) */
		"  fxch %%st(1)\n"           /* (a) (t) (a) (vr) (vl) (-1) */
		"  fsubrs 4(,%%ebp,4)\n"     /* (b-a) (t) (a) (vr) (vl) (-1) */
		"  addl %%esi, %%edx\n"
		"  leal 8(%%edi), %%edi\n"
		"  adcl %%ebx, %%ebp\n"
		"  fmulp %%st(1)\n"          /* ((b-a)*t) (a) (vr) (vl) (-1) */
		"  movl %%edx, %%eax\n"
		"  shrl $9, %%eax\n"
		"  faddp %%st(1)\n"          /* (wert) (vr) (vl) (-1) */
		"  fld %%st(1)\n"            /* (vr) (wert) (vr) (vl) (-1) */
		"  fld %%st(3)\n"            /* (vl) (vr) (wert) (vr) (vl) (-1) */
		"  fmul %%st(2), %%st\n"     /* (left) (vr) (wert) (vr) (vl) (-1) */
		"  fxch %%st(4)\n"           /* (vl)  (vr) (wert) (vr) (left) (-1) */
		"  fadds volrl\n"            /* (vl') (vr) (wert) (vr) (left) (-1) */
		"  fxch %%st(2)\n"           /* (wert) (vr) (vl') (vr) (left) (-1) */
		"  fmulp %%st(1)\n"          /* (right) (vl') (vr) (left) (-1) */
		"  fxch %%st(2)\n"           /* (vr) (vl') (right) (left) (-1) */
		"  fadds volrr\n"            /* (vr') (vl') (right) (left) (-1) */
		"  fxch %%st(3)\n"           /* (left)  (vl') (right) (vr') (-1) */
		"  fadds -8(%%edi)\n"        /* (lfinal) (vl') <right> (vr') (-1) */
		"  fxch %%st(2)\n"           /* (right) (vl') (lfinal) (vr') (-1) */
		"  fadds -4(%%edi)\n"        /* (rfinal) (vl') (lfinal) (vr') (-1) */
		"  orl $0x3f800000, %%eax\n"
	"mixs_i_SM1:\n"
		"  cmpl $12345678, %%ebp\n"
		"  movl %%eax, magic1\n"
		"  jge mixs_i_LoopHandler\n"
	/* hier 1 cycle frei */
		"  fstps -4(%%edi)\n"        /* (vl') (lfinal) <vr'> (-1) */
		"  fxch %%st(1)\n"           /* (lfinal) (vl) (vr) (-1) */
		"  fstps -8(%%edi)\n"        /* (vl) (vr) (-1) */
		"  fxch %%st(1)\n"           /* (vr) (vl) (-1) */
		"  decl %%ecx\n"
		"jnz mixs_i_next\n"
	"mixs_i_ende:\n"
		"fstps volr\n"
		"fstps voll\n"
		"fstp %%st\n"
		"shll $2, %%ebp\n"
		"movl %%ebp, %%eax\n"
		"ret\n"

	"mixs_i_LoopHandler:\n"
		"fstps -4(%%edi)\n"          /* (vl') (lfinal) <vr'> (-1) */
		"fxch %%st(1)\n"             /* (lfinal) (vl) (vr) (-1) */
		"fstps -8(%%edi)\n"          /* (vl) (vr) (-1) */
		"fxch %%st(1)\n"             /* (vr) (vl) (-1) */
		"movl looptype, %%eax\n"
		"testl %0, %%eax\n"
		"jnz mixs_i_loopme\n"
		"fxch %%st(2)\n"             /* (-1) (vl) (vr) */
		"fstp %%st\n"                /* (vl) (vr) */
		"subl %%esi, %%edx\n"
		"sbbl %%ebx, %%ebp\n"
		"flds (,%%ebp,4)\n"          /* (wert) (vl) (vr) */
		"fxch %%st(2)\n"             /* (vr) (vl) (wert) */
	"mixs_i_fill:\n"
	/* sample ends -> fill rest of buffer with last sample value */
		"  fld %%st(1)\n"            /* (vl) (vr) (vl) (wert) */
		"  fmul %%st(3), %%st\n"     /* (left) (vr) (vl) (wert) */
		"  fxch %%st(1)\n"           /* (vr) (left) (vl) (wert) */
		"  fld %%st\n"               /* (vr) (vr) (left) (vl) (wert) */
		"  fmul %%st(4), %%st\n"     /* (right) (vr) (left) (vl) (wert) */
		"  fxch %%st(2)\n"           /* (left) (vr) (right) (vl) (wert) */
		"  fadds -8(%%edi)\n"        /* (vr) (vl) (wert)            This should be (lfinal) (vr) (right) (vl) (wert) - stian */
		"  fstps -8(%%edi)\n"        /* (vr) (right) (vl) (wert) */
		"  fxch %%st(1)\n"           /* (right) (vr) (vl) (wert) */
		"  fadds -4(%%edi)\n"        /* (vr) (vl) (wert)            This should be (rfinal) (vr) (vl) (wert) - stian */
		"  fstps -4(%%edi)\n"        /* (vr) (vl) (wert) */
		"  fadds volrr\n"            /* (vr') (vl) (wert) */
		"  fxch %%st(1)\n"           /* (vl) (vr') (wert) */
		"  leal 8(%%edi), %%edi\n"
		"  decl %%ecx\n"
		"  fadds volrl\n"            /* (vl') (vr') (wert) */
		"  fxch %%st(1)\n"           /* (vr') (vl') (wert) */
		"jnz mixs_i_fill\n"
	/* update click-removal fade values */
		"fld %%st(2)\n"              /* (wert) (vr) (vl) (wert) */
		"fld %%st\n"                 /* (wert) (wert) (vr) (vl) (wert) */
		"fmul %%st(3), %%st\n"       /* (left) (wert) (vr) (vl) (wert) */
		"fxch %%st(1)\n"             /* (wert) (left) (vr) (vl) (wert) */
		"fmul %%st(2), %%st\n"       /* (rite) (left) (vr) (vl) (wert) */
		"fxch %%st(1)\n"             /* (left) (rite) (vr) (vl) (wert) */
		"fadds fadeleft\n"           /* (fl') (rite) (vr) (vl) (wert) */
		"fxch %%st(1)\n"             /* (rite) (fl') (vr) (vl) (wert) */
		"fadds faderight\n"          /* (fr') (fl') (vr) (vl) (wert) */
		"fxch %%st(1)\n"             /* (fl') (fr') (vr) (vl) (wert) */
		"fstps fadeleft\n"           /* (fr') (vr) (vl) (wert) */
		"fstps faderight\n"          /* (vr) (vl) (wert) */
		"movl looptype, %%eax\n"
		"andl %1, %%eax\n"
		"movl %%eax, looptype\n"
		"jmp mixs_i_ende\n"

	"mixs_i_loopme:\n"
	/* sample loops -> jump to loop start */
		"subl mixlooplen, %%ebp\n"
		"decl %%ecx\n"
		"jz mixs_i_ende\n"
		"jmp mixs_i_next\n"
		:
		: "n"(MIXF_LOOPED),
		  "n"(FLAG_DISABLED)
	);

	__asm__ __volatile__
	(
	"mixm_i2:\n"
	/* mixing, mono w/ cubic interpolation */
		"movl nsamples, %%ecx\n"
		"flds voll\n"                /* (vl) */
		"shrl $2, %%ebp\n"
		"movl %%ebp, mixm_i2_SM1\n" /* self modifying code. set loop end position */
		"movl %%eax, %%ebp\n"
		"shrl $2, %%ebp\n"
		"movl %%edx, %%eax\n"
		"shrl $24, %%eax\n"
	/* align dword we don't give a rats ass about */
	"mixm_i2_next:\n"                    /* (vl) */
		"  flds (,%%ebp,4)\n"        /* (w0) (vl) */
		"  fmuls ct0(,%%eax,4)\n"    /* (w0') (vl) */
		"  flds 4(,%%ebp,4)\n"       /* (w1) (w0') (vl) */
		"  fmuls ct1(,%%eax,4)\n"    /* (w1') (w0') (vl) */
		"  flds 8(,%%ebp,4)\n"       /* (w2) (w1') (w0') (vl) */
		"  fmuls ct2(,%%eax,4)\n"    /* (w2') (w1') (w0') (vl) */
		"  flds 12(,%%ebp,4)\n"      /* (w3) (w2') (w1') (w0') (vl) */
		"  fmuls ct3(,%%eax,4)\n"    /* (w3') (w2') (w1') (w0') (vl) */
		"  fxch %%st(2)\n"           /* (w1') (w2') (w3') (w0') (vl) */
		"  faddp %%st, %%st(3)\n"    /* (w2') (w3') (w0+w1) (vl) */
		"  addl %%esi, %%edx\n"
		"  leal 4(%%edi), %%edi\n"
		"  faddp %%st, %%st(2)\n"    /* (w2+w3) (w0+w1) (vl) */ /* I find this to be wrong - Stian TODO  faddp %st %st(1) anybody ?  */
		"  adcl %%ebx, %%ebp\n"
		"  movl %%edx, %%eax\n"
		"  faddp %%st,%%st(1)\n"     /* (wert) (vl) */ /* But since we add them together here it all ends correct - Stian */
		"  shrl $24, %%eax\n"
		"  fld %%st(1)\n"            /* (vl) (wert) (vl) */
		"  fmulp %%st, %%st(1)\n"    /* (left) (vl) */
		"  fxch %%st(1)\n"           /* (vl) (left) */
		"  fadds volrl\n"            /* (vl') (left) */
		"  fxch %%st(1)\n"           /* (left) (vl) */
		"  fadds -4(%%edi)\n"        /* (lfinal) (vl') */
	"mixm_i2_SM1:\n"
		"  cmpl $12345678, %%ebp\n"
		"  jge mixm_i2_LoopHandler\n"
		"  fstps -4(%%edi)\n"        /* (vl') */
		"  decl %%ecx\n"
		"jnz mixm_i2_next\n"
	"mixm_i2_ende:\n"
		"fstps voll\n"               /* - */
		"shll $2, %%ebp\n"
		"movl %%ebp, %%eax\n"
		"ret\n"

	"mixm_i2_LoopHandler:\n"
		"fstps -4(%%edi)\n"          /* (vl') */
		"pushl %%eax\n"
		"movl looptype, %%eax\n"
		"testl %0, %%eax\n"
		"jnz mixm_i2_loopme\n"
		"popl %%eax\n"
		"subl %%esi, %%edx\n"
		"sbbl %%ebx, %%ebp\n"
		"flds (,%%ebp,4)\n"          /* (wert) (vl) */
	"mixm_i2_fill:\n"
	/* sample ends -> fill rest of buffer with last sample value */
		"  fld %%st(1)\n"            /* (vl) (wert) (vl) */
		"  fmul %%st(1), %%st\n"     /* (left) (wert) (vl) */
		"  fadds -4(%%edi)\n"        /* (lfinal) (wert) (vl) */
		"  fstps -4(%%edi)\n"        /* (wert) (vl) */
		"  fxch %%st(1)\n"           /* (vl) (wert) */
		"  fadds volrl\n"            /* (vl') (wert) */
		"  fxch %%st(1)\n"           /* (wert) (vl') */
		"  leal 4(%%edi), %%edi\n"
		"  decl %%ecx\n"
		"jnz mixm_i2_fill\n"
	/* update click-removal fade values */
		"fmul %%st(1), %%st\n"       /* (left) (vl) */
		"fadds fadeleft\n"           /* (fl') (vl) */
		"fstps fadeleft\n"           /* (vl) */
		"movl looptype, %%eax\n"
		"andl %1, %%eax\n"
		"movl %%eax, looptype\n"
		"jmp mixm_i2_ende\n"

	"mixm_i2_loopme:\n"
	/* sample loops -> jump to loop start */
		"popl %%eax\n"
		"subl mixlooplen, %%ebp\n"
		"decl %%ecx\n"
		"jz mixm_i2_ende\n"
		"jmp mixm_i2_next\n"
		:
		: "n"(MIXF_LOOPED),
		  "n"(FLAG_DISABLED)
	);

	__asm__ __volatile__
	(
	"mixs_i2:\n"
	/* mixing, stereo w/ cubic interpolation */
		"movl nsamples, %%ecx\n"
		"flds voll\n"                /* (vl) */
		"flds volr\n"                /* (vr) (vl) */
		"shrl $2, %%ebp\n"
		"movl %%ebp, mixs_i2_SM1+2\n"/* self modifying code. set loop end position */
		"movl %%eax, %%ebp\n"
		"shrl $2, %%ebp\n"
		"movl %%edx, %%eax\n"
		"shrl $24, %%eax\n"
	/* align dword... see I care to do that */
	"mixs_i2_next:\n"
		"  flds (,%%ebp,4)\n"        /* (w0) (vr) (vl) */
		"  fmuls ct0(,%%eax,4)\n"    /* (w0') (vr) (vl) */
		"  flds 4(,%%ebp,4)\n"       /* (w1) (w0') (vr) (vl) */
		"  fmuls ct1(,%%eax,4)\n"    /* (w1') (w0') (vr) (vl) */
		"  flds 8(,%%ebp,4)\n"       /* (w2) (w1') (w0') (vr) (vl) */
		"  fmuls ct2(,%%eax,4)\n"    /* (w2') (w1') (w0') (vr) (vl) */
		"  flds 12(,%%ebp,4)\n"      /* (w3) (w2') (w1') (w0') (vr) (vl) */
		"  fmuls ct3(,%%eax,4)\n"    /* (w3') (w2') (w1') (w0') (vr) (vl) */
		"  fxch %%st(2)\n"           /* (w1') (w2') (w3') (w0') (vr) (vl) */
		"  faddp %%st, %%st(3)\n"    /* (w2') (w3') (w0+w1) (vr) (vl) */
		"  addl %%esi, %%edx\n"
		"  leal 8(%%edi), %%edi\n"
		"  faddp %%st, %%st(2)\n"    /* (w2+w3) (w0+w1) (vr) (vl)     I find this comment to be wrong, be the next addp merges them all together - Stian*/
		"  adcl %%ebx, %%ebp\n"
		"  movl %%edx, %%eax\n"
		"  faddp %%st, %%st(1)\n"    /* wert) (vr) (vl) */
		"  shrl $24, %%eax\n"
		"  fld %%st(1)\n"            /* (vr) (wert) (vr) (vl) */
		"  fld %%st(3)\n"            /* (vl) (vr) (wert) (vr) (vl) */
		"  fmul %%st(2), %%st\n"     /* (left) (vr) (wert) (vr) (vl) */
		"  fxch %%st(4)\n"           /* (vl)  (vr) (wert) (vr) (left) */
		"  fadds volrl\n"            /* (vl') (vr) (wert) (vr) (left) */
		"  fxch %%st(2)\n"           /* (wert) (vr) (vl') (vr) (left) */
		"  fmulp %%st(1)\n"          /* (right) (vl') (vr) (left) */
		"  fxch %%st(2)\n"           /* (vr) (vl') (right) (left) */
		"  fadds volrr\n"            /* (vr') (vl') (right) (left) */
		"  fxch %%st(3)\n"           /* (left)  (vl') (right) (vr') */
		"  fadds -8(%%edi)\n"        /* (lfinal) (vl') <right> (vr') */
		"  fxch %%st(2)\n"           /* (right) (vl') (lfinal) (vr') */
		"  fadds -4(%%edi)\n"        /* (rfinal) (vl') (lfinal) (vr') */
	"mixs_i2_SM1:\n"
		"  cmpl $12345678, %%ebp\n"
		"  jge mixs_i2_LoopHandler\n"
	/* hier 1 cycle frei */
		"  fstps -4(%%edi)\n"        /* (vl') (lfinal) (vr') */
		"  fxch %%st(1)\n"           /* (lfinal) (vl) (vr)  */
		"  fstps -8(%%edi)\n"        /* (vl) (vr) */
		"  fxch %%st(1)\n"           /* (vr) (vl) */
		"  decl %%ecx\n"
		"jnz mixs_i2_next\n"
	"mixs_i2_ende:\n"
		"fstps volr\n"               /* (vl) */
		"fstps voll\n"               /* - */
		"shll $2, %%ebp\n"
		"movl %%ebp, %%eax\n"
		"ret\n"

	"mixs_i2_LoopHandler:\n"
		"fstps -4(%%edi)\n"          /* (vl') (lfinal) (vr') */
		"fxch %%st(1)\n"             /* (lfinal) (vl) (vr) */
		"fstps -8(%%edi)\n"          /* (vl) (vr) */
		"fxch %%st(1)\n"             /* (vr) (vl) */
		"pushl %%eax\n"
		"movl looptype, %%eax\n"
		"testl %0, %%eax\n"
		"jnz mixs_i2_loopme\n"
		"popl %%eax\n"
		"fxch %%st(1)\n"             /* (vl) (vr) */
		"subl %%esi, %%edx\n"
		"sbbl %%ebx, %%ebp\n"
		"flds (,%%ebp,4)\n"          /* (wert) (vl) (vr) */
		"fxch %%st(2)\n"             /* (vr) (vl) (wert) */
	"mixs_i2_fill:\n"
	/* sample ends -> fill rest of buffer with last sample value */
		"  fld %%st(1)\n"            /* (vl) (vr) (vl) (wert) */
		"  fmul %%st(3), %%st\n"     /* (left) (vr) (vl) (wert) */
		"  fxch %%st(1)\n"           /* (vr) (left) (vl) (wert) */
		"  fld %%st\n"               /* (vr) (vr) (left) (vl) (wert) */
		"  fmul %%st(4), %%st\n"     /* (right) (vr) (left) (vl) (wert) */
		"  fxch %%st(2)\n"           /* (left) (vr) (right) (vl) (wert) */
		"  fadds -8(%%edi)\n"
		"  fstps -8(%%edi)\n"        /* (vr) (right) (vl) (wert) */
		"  fxch %%st(1)\n"           /* (right) (vr) (vl) (wert) */
		"  fadds -4(%%edi)\n"
		"  fstps -4(%%edi)\n"        /* (vr) (vl) (wert) */
		"  fadds volrr\n"            /* (vr') (vl) (wert) */
		"  fxch %%st(1)\n"           /* (vl) (vr') (wert) */
		"  leal 8(%%edi), %%edi\n"
		"  decl %%ecx\n"
		"  fadds volrl\n"            /* (vl') (vr') (wert) */
		"  fxch %%st(1)\n"           /* (vr') (vl') (wert) */
		"jnz mixs_i2_fill\n"
	/* update click-removal fade values */
		"fxch %%st(2)\n"             /* (wert) (vl) (vr) */
		"fld %%st\n"                 /* (wert) (wert) (vl) (vr) */
		"fmul %%st(2), %%st\n"       /* (left) (wert) (vl) (vr) */
		"fxch %%st(1)\n"             /* (wert) (left) (vl) (vr) */
		"fmul %%st(3), %%st\n"       /* (rite) (left) (vl) (vr) */
		"fxch %%st(1)\n"             /* (left) (rite) (vl) (vr) */
		"fadds fadeleft\n"           /* (fl') (rite) (vl) (vr) */
		"fxch %%st(1)\n"             /* (rite) (fl') (vl) (vr) */
		"fadds faderight\n"          /* (fr') (fl') (vl) (vr) */
		"fxch %%st(1)\n"             /* (fl') (fr') (vl) (vr) */
		"fstps fadeleft\n"           /* (fr') (vl) (vr) */
		"fstps faderight\n"          /* (vl) (vr) */
		"fxch %%st(1)\n"             /* (vr) (vl) */
		"movl looptype, %%eax\n"
		"andl %1, %%eax\n"
		"movl %%eax, looptype\n"
		"jmp mixs_i2_ende\n"

	"mixs_i2_loopme:\n"
	/* sample loops -> jump to loop start */
		"popl %%eax\n"
		"subl mixlooplen, %%ebp\n"
		"decl %%ecx\n"
		"jz mixs_i2_ende\n"
		"jmp mixs_i2_next\n"
		:
		: "n"(MIXF_LOOPED),
		  "n"(FLAG_DISABLED)
	);

	__asm__ __volatile__
	(
	"mixm_nf:\n"
	/* mixing, mono w/o interpolation, FILTERED */
		"movl nsamples, %%ecx\n"
		"flds voll\n"                /* (vl) */
		"shrl $2, %%ebp\n"
		"movl %%ebp, mixm_nf_SM1+2\n" /* self modifying code. set loop end position */
		"movl %%eax, %%ebp\n"
		"shrl $2, %%ebp\n"
		/* align dword sucks */
	"mixm_nf_next:\n"                    /* (vl) */
		"  flds (,%%ebp,4)\n"        /* (wert) (vl) */

	/* FILTER HIER:
	 * b=reso*b+freq*(in-l);
	 * l+=freq*b;
	 */
		"  fsubs __fl1\n"            /* (in-l) .. */
		"  fmuls ffrq\n"             /* (f*(in-l)) .. */
		"  flds __fb1\n"             /* (b) (f*(in-l)) .. */
		"  fmuls frez\n"             /* (r*b) (f*(in-l)) .. */
		"  faddp %%st, %%st(1)\n"    /* (b') .. */
		"  fsts __fb1\n"
		"  fmuls ffrq\n"             /* (f*b') .. */
		"  fadds __fl1\n"            /* (l') .. */
		"  fsts __fl1\n"             /* (out) (vl) */
	
		"  fld %%st(1)\n"            /* (vl) (wert) (vl) */
		"  addl %%esi, %%edx\n"
		"  leal 4(%%edi), %%edi\n"
		"  adcl %%ebx, %%ebp\n"
		"  fmulp %%st, %%st(1)\n"    /* (left) (vl) */
		"  fxch %%st(1)\n"           /* (vl) (left)  */
		"  fadds volrl\n"            /* (vl') (left) */
		"  fxch %%st(1)\n"           /* (left) (vl) */
		"  fadds -4(%%edi)\n"        /* (lfinal) (vl') */
	"mixm_nf_SM1:\n"
		"  cmpl $12345678, %%ebp\n"
		"  jge mixm_nf_LoopHandler\n"
		"  fstps -4(%%edi)\n"        /* (vl') */
		"  decl %%ecx\n"
		"jnz mixm_nf_next\n"
	"mixm_nf_ende:\n"
		"fstps voll\n"               /* - */
		"shll $2, %%ebp\n"
		"movl %%ebp, %%eax\n"
		"ret\n"

	"mixm_nf_LoopHandler:\n"
		"fstps -4(%%edi)\n"          /* (vl') */
		"movl looptype, %%eax\n"
		"testl %0, %%eax\n"
		"jnz mixm_nf_loopme\n"
		"subl %%esi, %%edx\n"
		"sbbl %%ebx, %%ebp\n"
		"flds (,%%ebp,4)\n"          /* (wert) (vl) */
	"mixm_nf_fill:\n"
	/* sample ends -> fill rest of buffer with last sample value */
		"  fld %%st(1)\n"            /* (vl) (wert) (vl) */
		"  fmul %%st(1), %%st\n"     /* (left) (wert) (vl) */
		"  fadds -4(%%edi)\n"        /* (lfinal) (wert) (vl) */
		"  fstps -4(%%edi)\n"        /* (wert) (vl) */
		"  fxch %%st(1)\n"           /* (vl) (wert) */
		"  fadds volrl\n"            /* (vl') (wert) */
		"  fxch %%st(1)\n"           /* (wert) (vl') */
		"  leal 4(%%edi), %%edi\n"
		"  decl %%ecx\n"
		"jnz mixm_nf_fill\n"
	/* update click-removal fade values */
		"fmul %%st(1), %%st\n"       /* (left) (vl) */
		"fadds fadeleft\n"           /* (fl') (vl) */
		"fstps fadeleft\n"           /* (vl) */
		"movl looptype, %%eax\n"
		"andl %1, %%eax\n"
		"movl %%eax, looptype\n"
		"jmp mixm_nf_ende\n"

	"mixm_nf_loopme:\n"
	/* sample loops -> jump to loop start */
		"subl mixlooplen, %%ebp\n"
		"decl %%ecx\n"
		"jz mixm_nf_ende\n"
		"jmp mixm_nf_next\n"
		:
		: "n"(MIXF_LOOPED),
		  "n"(FLAG_DISABLED)
	);

	__asm__ __volatile__
	(
	"mixs_nf:\n"
	/* mixing, stereo w/o interpolation, FILTERED */
		"movl nsamples, %%ecx\n"
		"flds voll\n"                /* (vl) */
		"flds volr\n"                /* (vr) (vl) */
		"shrl $2, %%ebp\n"
		"movl %%ebp, mixs_nf_SM1+2\n" /* self modifying code. set loop end position */
		"movl %%eax, %%ebp\n"
		"shrl $2, %%ebp\n"
	/* align dword is for clows */
"mixs_nf_next:\n"
		"  flds (,%%ebp,4)\n"        /* (wert) (vr) (vl) */

	/* FILTER HIER:
	 * b=reso*b+freq*(in-l);
	 * l+=freq*b;
	 */
		"  fsubs __fl1\n"            /* (in-l) .. */
		"  fmuls ffrq\n"             /* (f*(in-l)) .. */
		"  flds __fb1\n"             /* (b) (f*(in-l)) .. */
		"  fmuls frez\n"             /* (r*b) (f*(in-l)) .. */
		"  faddp %%st, %%st(1)\n"    /* (b') .. */
		"  fsts __fb1\n"
		"  fmuls ffrq\n"             /* (f*b') .. */
		"  fadds __fl1\n"            /* (l') .. */
		"  fsts __fl1\n"             /* (out) (vr) (vl) */

		"  addl %%esi, %%edx\n"
		"  leal 8(%%edi), %%edi\n"
		"  adcl %%ebx, %%ebp\n"
		"  fld %%st(1)\n"            /* (vr) (wert) (vr) (vl) */
		"  fld %%st(3)\n"            /* (vl) (vr) (wert) (vr) (vl) */
		"  fmul %%st(2), %%st\n"     /* (left) (vr) (wert) (vr) (vl) */
		"  fxch %%st(4)\n"           /* (vl)  (vr) (wert) (vr) (left) */
		"  fadds volrl\n"            /* (vl') (vr) (wert) (vr) (left) */
		"  fxch %%st(2)\n"           /* (wert) (vr) (vl') (vr) (left) */
		"  fmulp %%st(1)\n"          /* (right) (vl') (vr) (left) */
		"  fxch %%st(2)\n"           /* (vr) (vl') (right) (left) */
		"  fadds volrr\n"            /* (vr') (vl') (right) (left) */
		"  fxch %%st(3)\n"           /* (left)  (vl') (right) (vr') */
		"  fadds -8(%%edi)\n"        /* (lfinal) (vl') <right> (vr') */
		"  fxch %%st(2)\n"           /* (right) (vl') (lfinal) (vr') */
		"  fadds -4(%%edi)\n"        /* (rfinal) (vl') (lfinal) (vr') */
	"mixs_nf_SM1:\n"
		"  cmpl $12345678, %%ebp\n"
		"  jge mixs_nf_LoopHandler\n"
       /* hier 1 cycle frei */
		"  fstps -4(%%edi)\n"        /* (vl') (lfinal) (vr') */
		"  fxch %%st(1)\n"           /* (lfinal) (vl) (vr) */
		"  fstps -8(%%edi)\n"        /* (vl) (vr) */
		"  fxch %%st(1)\n"           /* (vr) (vl) */
		"  decl %%ecx\n"
		"jnz mixs_nf_next\n"
	"mixs_nf_ende:\n"
		"fstps volr\n"               /* (vl) */
		"fstps voll\n"               /* - */
		"shll $2, %%ebp\n"
		"movl %%ebp, %%eax\n"
		"ret\n"

	"mixs_nf_LoopHandler:\n"
		"fstps -4(%%edi)\n"          /* (vl') (lfinal) (vr') */
		"fxch %%st(1)\n"             /* (lfinal) (vl) (vr) */
		"fstps -8(%%edi)\n"          /* (vl) (vr) */
		"fxch %%st(1)\n"             /* (vr) (vl) */
		"movl looptype, %%eax\n"
		"testl %0, %%eax\n"
		"jnz mixs_nf_loopme\n"
		"fxch %%st(1)\n"             /* (vl) (vr) */
		"subl %%esi, %%edx\n"
		"sbbl %%ebx, %%ebp\n"
		"flds (,%%ebp,4)\n"          /* (wert) (vl) (vr) */
		"fxch %%st(2)\n"             /* (vr) (vl) (wert) */
	"mixs_nf_fill:\n"
	/* sample ends -> fill rest of buffer with last sample value */
		"  fld %%st(1)\n"            /* (vl) (vr) (vl) (wert) */
		"  fmul %%st(3), %%st\n"     /* (left) (vr) (vl) (wert) */
		"  fxch %%st(1)\n"           /* (vr) (left) (vl) (wert) */
		"  fld %%st\n"               /* (vr) (vr) (left) (vl) (wert) */
		"  fmul %%st(4), %%st\n"     /* (right) (vr) (left) (vl) (wert) */
		"  fxch %%st(2)\n"           /* (left) (vr) (right) (vl) (wert) */
		"  fadds -8(%%edi)\n"
		"  fstps -8(%%edi)\n"        /* (vr) (right) (vl) (wert) */
		"  fxch %%st(1)\n"           /* (right) (vr) (vl) (wert) */
		"  fadds -4(%%edi)\n"
		"  fstps -4(%%edi)\n"        /* (vr) (vl) (wert) */
		"  fadds volrr\n"            /* (vr') (vl) (wert) */
		"  fxch %%st(1)\n"           /* (vl) (vr') (wert) */
		"  leal 8(%%edi), %%edi\n"
		"  decl %%ecx\n"
		"  fadds volrl\n"            /* (vl') (vr') (wert) */
		"  fxch %%st(1)\n"           /* (vr') (vl') (wert) */
		"jnz mixs_nf_fill\n"
	/* update click-removal fade values */
		"fxch %%st(2)\n"             /* (wert) (vl) (vr) */
		"fld %%st\n"                 /* (wert) (wert) (vl) (vr) */
		"fmul %%st(2), %%st\n"       /* (left) (wert) (vl) (vr) */
		"fxch %%st(1)\n"             /* (wert) (left) (vl) (vr) */
		"fmul %%st(3), %%st\n"       /* (rite) (left) (vl) (vr) */
		"fxch %%st(1)\n"             /* (left) (rite) (vl) (vr) */
		"fadds fadeleft\n"           /* (fl') (rite) (vl) (vr) */
		"fxch %%st(1)\n"             /* (rite) (fl') (vl) (vr) */
		"fadds faderight\n"          /* (fr') (fl') (vl) (vr) */
		"fxch %%st(1)\n"             /* (fl') (fr') (vl) (vr) */
		"fstps fadeleft\n"           /* (fr') (vl) (vr) */
		"fstps faderight\n"          /* (vl) (vr) */
		"fxch %%st(1)\n"             /* (vr) (vl) */
		"movl looptype, %%eax\n"
		"andl %1, %%eax\n"
		"movl %%eax, looptype\n"
		"jmp mixs_nf_ende\n"

	"mixs_nf_loopme:\n"
	/* sample loops -> jump to loop start */
		"subl mixlooplen, %%ebp\n"
		"decl %%ecx\n"
		"jz mixs_nf_ende\n"
		"jmp mixs_nf_next\n"
		:
		: "n"(MIXF_LOOPED),
		  "n"(FLAG_DISABLED)
	);

	__asm__ __volatile__
	(
	"mixm_if:\n"
	/* mixing, mono+interpolation, FILTERED */
		"movl nsamples, %%ecx\n"
		"flds minuseins\n"           /* (-1) */
		"flds voll\n"                /* (vl) (-1) */
		"shrl $2, %%ebp\n"
		"movl %%ebp, mixm_if_SM1+2\n" /* self modifying code. set loop end position */
		"movl %%eax, %%ebp\n"
		"movl %%edx, %%eax\n"
		"shrl $9, %%eax\n"
		"shrl $2, %%ebp\n"
		"orl $0x3f800000, %%eax\n"
		"movl %%eax, magic1\n"

	/* align dword is for pussies */
	"mixm_if_next:\n"                    /* (vl) (-1) */
		"  flds 0(,%%ebp,4)\n"       /* (a) (vl) (-1) */
		"  fld %%st(0)\n"            /* (a) (a) (vl) (-1) */
		"  fld %%st(3)\n"            /* (-1) (a) (a) (vl) (-1) */
		"  fadds magic1\n"           /* (t) (a) (a) (vl) (-1) */
		"  fxch %%st(1)\n"           /* (a) (t) (a) (vl) (-1) */
		"  fsubrs 4(,%%ebp,4)\n"     /* (b-a) (t) (a) (vl) (-1) */
		"  addl %%esi, %%edx\n"
		"  leal 4(%%edi), %%edi\n"
		"  adcl %%ebx, %%ebp\n"
		"  fmulp %%st(1)\n"          /* ((b-a)*t) (a) (vl) (-1) */
		"  movl %%edx, %%eax\n"
		"  shrl $9, %%eax\n"
		"  faddp %%st(1)\n"          /* (wert) (vl) (-1) */

	/* FILTER HIER:
	 * b=reso*b+freq*(in-l);
	 * l+=freq*b;
	 */
		"  fsubs __fl1\n"            /* (in-l) .. */
		"  fmuls ffrq\n"             /* (f*(in-l)) .. */
		"  flds __fb1\n"             /* (b) (f*(in-l)) .. */
		"  fmuls frez\n"             /* (r*b) (f*(in-l)) .. */
		"  faddp %%st, %%st(1)\n"    /* (b') .. */
		"  fsts __fb1\n"
		"  fmuls ffrq\n"             /* (f*b') .. */
		"  fadds __fl1\n"            /* (l') .. */
		"  fsts __fl1\n"             /* (out) (vl) (-1) */

		"  fld %%st(1)\n"            /* (vl) (wert) (vl) (-1) */
		"  fmulp %%st, %%st(1)\n"    /* (left) (vl) (-1) */
		"  fxch %%st(1)\n"           /* (vl) (left) (-1) */
		"  fadds volrl\n"            /* (vl') (left) (-1) */
		"  fxch %%st(1)\n"           /* (left) (vl) (-1) */
		"  fadds -4(%%edi)\n"        /* (lfinal) (vl') (-1) */
		"  orl $0x3f800000, %%eax\n"
	"mixm_if_SM1:\n"
		"  cmpl $12345678, %%ebp\n"
		"  movl %%eax, magic1\n"
		"  jge mixm_if_LoopHandler\n"
	/* hier 1 cycle frei */
		"  fstps -4(%%edi)\n"        /* (vl') (-1) */
		"  decl %%ecx\n"
		"jnz mixm_if_next\n"
	"mixm_if_ende:\n"
		"fstps voll\n"               /* (whatever) */
		"fstp %%st\n"                /* - */
		"shll $2, %%ebp\n"
		"movl %%ebp, %%eax\n"
		"ret\n"

	"mixm_if_LoopHandler:\n"
		"fstps -4(%%edi)\n"          /* (vl') (-1) */
		"movl looptype, %%eax\n"
		"testl %0, %%eax\n"
		"jnz mixm_if_loopme\n"
		"subl %%esi, %%edx\n"
		"sbb %%ebx, %%ebp\n"
		"flds (,%%ebp,4)\n"          /* (wert) (vl)  (-1) */
	"mixm_if_fill:\n"
	/* sample ends -> fill rest of buffer with last sample value */
		"  fld %%st(1)\n"            /* (vl) (wert) (vl)  (-1) */
		"  fmul %%st(1), %%st\n"     /* (left) (wert) (vl) (-1) */
		"  fadds -4(%%edi)\n"
		"  fstps -4(%%edi)\n"        /* (wert) (vl) (-1) */
		"  fxch %%st(1)\n"           /* (vl) (wert) (-1) */
		"  fadds volrl\n"            /* (vl') (wert) (-1) */
		"  fxch %%st(1)\n"           /* (wert) (vl') (-1) */
		"  leal 4(%%edi), %%edi\n"
		"  decl %%ecx\n"
		"jnz mixm_if_fill\n"
	/* update click-removal fade values */
		"fmul %%st(1), %%st\n"       /* (left) (vl) (-1) */
		"fadds fadeleft\n"           /* (fl') (vl) (-1) */
		"fstps fadeleft\n"           /* (vl) (-1) */
		"movl looptype, %%eax\n"
		"andl %1, %%eax\n"
		"movl %%eax, looptype\n"
		"jmp mixm_if_ende\n"

	"mixm_if_loopme:\n"
	/* sample loops -> jump to loop start */
		"subl mixlooplen, %%ebp\n"
		"decl %%ecx\n"
		"jz mixm_if_ende\n"
		"jmp mixm_if_next\n"
		:
		: "n"(MIXF_LOOPED),
		  "n"(FLAG_DISABLED)
	);

	__asm__ __volatile__
	(
	"mixs_if:\n"
	/* mixing, stereo+interpolation, FILTERED */
		"movl nsamples, %%ecx\n"
		"flds minuseins\n"           /* (-1) */
		"flds voll\n"                /* (vl) (-1) */
		"flds volr\n"                /* (vr) (vl) (-1) */
		"shrl $2, %%ebp\n"
		"movl %%ebp, mixs_if_SM1+2\n" /* self modifying code. set loop end position */
		"movl %%eax, %%ebp\n"
		"movl %%edx, %%eax\n"
		"shrl $9, %%eax\n"
		"shrl $2, %%ebp\n"
		"orl $0x3f800000, %%eax\n"
		"movl %%eax, magic1\n"

	/* align dword is boring */
	"mixs_if_next:\n"                    /* (vr) (vl) (-1) */
		"  flds 0(,%%ebp,4)\n"       /* (a) (vr) (vl) (-1) */
		"  fld %%st(0)\n"            /* (a) (a) (vr) (vl) (-1) */
		"  fld %%st(4)\n"            /* (-1) (a) (a) (vr) (vl) (-1) */
		"  fadds magic1\n"           /* (t) (a) (a) (vr) (vl) (-1) */
		"  fxch %%st(1)\n"           /* (a) (t) (a) (vr) (vl) (-1) */
		"  fsubrs 4(,%%ebp,4)\n"     /* (b-a) (t) (a) (vr) (vl) (-1) */
		"  addl %%esi, %%edx\n"
		"  leal 8(%%edi), %%edi\n"
		"  adcl %%ebx, %%ebp\n"
		"  fmulp %%st(1)\n"          /* ((b-a)*t) (a) (vr) (vl) (-1) */
		"  movl %%edx, %%eax\n"
		"  shrl $9, %%eax\n"
		"  faddp %%st(1)\n"          /* (wert) (vr) (vl) (-1) */

	/* FILTER HIER:
	 * b=reso*b+freq*(in-l);
	 * l+=freq*b;
	 */
		"  fsubs __fl1\n"            /* (in-l) .. */
		"  fmuls ffrq\n"             /* (f*(in-l)) .. */
		"  flds __fb1\n"             /* (b) (f*(in-l)) .. */
		"  fmuls frez\n"             /* (r*b) (f*(in-l)) .. */
		"  faddp %%st, %%st(1)\n"    /* (b') .. */
		"  fsts __fb1\n"
		"  fmuls ffrq\n"             /* (f*b') .. */
		"  fadds __fl1\n"            /* (l') .. */
		"  fsts __fl1\n"             /* (out) (vr) (vl) */

		"  fld %%st(1)\n"            /* (vr) (wert) (vr) (vl) (-1) */
		"  fld %%st(3)\n"            /* (vl) (vr) (wert) (vr) (vl) (-1) */
		"  fmul %%st(2), %%st\n"     /* (left) (vr) (wert) (vr) (vl) (-1) */
		"  fxch %%st(4)\n"           /* (vl)  (vr) (wert) (vr) (left) (-1) */
		"  fadds volrl\n"            /* (vl') (vr) (wert) (vr) (left) (-1) */
		"  fxch %%st(2)\n"           /* (wert) (vr) (vl') (vr) (left) (-1) */
		"  fmulp %%st(1)\n"          /* (right) (vl') (vr) (left) (-1) */
		"  fxch %%st(2)\n"           /* (vr) (vl') (right) (left) (-1) */
		"  fadds volrr\n"            /* (vr') (vl') (right) (left) (-1) */
		"  fxch %%st(3)\n"           /* (left)  (vl') (right) (vr') (-1) */
		"  fadds -8(%%edi)\n"        /* (lfinal) (vl') <right> (vr') (-1) */
		"  fxch %%st(2)\n"           /* (right) (vl') (lfinal) (vr') (-1) */
		"  fadds -4(%%edi)\n"        /* (rfinal) (vl') (lfinal) (vr') (-1) */
		"  orl $0x3f800000, %%eax\n"
	"mixs_if_SM1:\n"
		"  cmpl $12345678, %%ebp\n"
		"  movl %%eax, magic1\n"
		"  jge mixs_if_LoopHandler;\n"
	/* hier 1 cycle frei */
		"  fstps -4(%%edi)\n"        /* (vl') (lfinal) <vr'> (-1) */
		"  fxch %%st(1)\n"           /* (lfinal) (vl) (vr) (-1) */
		"  fstps -8(%%edi)\n"        /* (vl) (vr) (-1) */
		"  fxch %%st(1)\n"           /* (vr) (vl) (-1) */
		"  decl %%ecx\n"
		"jnz mixs_if_next\n"
	"mixs_if_ende:\n"
		"fstps volr\n"
		"fstps voll\n"
		"fstp %%st\n"
		"shll $2, %%ebp\n"
		"movl %%ebp, %%eax\n"
		"ret\n"

	"mixs_if_LoopHandler:\n"
		"fstps -4(%%edi)\n"          /* (vl') (lfinal) (vr') (-1) */
		"fxch %%st(1)\n"             /* (lfinal) (vl) (vr) (-1) */
		"fstps -8(%%edi)\n"          /* (vl) (vr) (-1) */
		"fxch %%st(1)\n"             /* (vr) (vl) (-1) */
		"movl looptype, %%eax\n"
		"testl %0, %%eax\n"
		"jnz mixs_if_loopme\n"
		"fxch %%st(2)\n"             /* (-1) (vl) (vr) */
		"fstp %%st\n"                /* (vl) (vr) */
		"subl %%esi, %%edx\n"
		"sbbl %%ebx, %%ebp\n"
		"flds (,%%ebp,4)\n"          /* (wert) (vl) (vr) */
		"fxch %%st(2)\n"             /* (vr) (vl) (wert) */
	"mixs_if_fill:\n"
	/* sample ends -> fill rest of buffer with last sample value */
		"  fld %%st(1)\n"            /* (vl) (vr) (vl) (wert) */
		"  fmul %%st(3), %%st\n"     /* (left) (vr) (vl) (wert) */
		"  fxch %%st(1)\n"           /* (vr) (left) (vl) (wert) */
		"  fld %%st\n"               /* (vr) (vr) (left) (vl) (wert) */
		"  fmul %%st(4), %%st\n"     /* (right) (vr) (left) (vl) (wert) */
		"  fxch %%st(2)\n"           /* (left) (vr) (right) (vl) (wert) */
		"  fadds -8(%%edi)\n"        /* (vr) (vl) (wert) */
		"  fstps -8(%%edi)\n"        /* (vr) (right) (vl) (wert) */
		"  fxch %%st(1)\n"           /* (right) (vr) (vl) (wert) */
		"  fadds -4(%%edi)\n"        /* (vr) (vl) (wert) */
		"  fstps -4(%%edi)\n"        /* (vr) (vl) (wert) */
		"  fadds volrr\n"            /* (vr') (vl) (wert) */
		"  fxch %%st(1)\n"           /* (vl) (vr') (wert) */
		"  leal 8(%%edi), %%edi\n"
		"  decl %%ecx\n"
		"  fadds volrl\n"            /* (vl') (vr') (wert) */
		"  fxch %%st(1)\n"           /* (vr') (vl') (wert) */
		"jnz mixs_if_fill\n"
	/* update click-removal fade values */
		"fld %%st(2)\n"              /* (wert) (vr) (vl) (wert) */
		"fld %%st\n"                 /* (wert) (wert) (vr) (vl) (wert) */
		"fmul %%st(3), %%st\n"       /* (left) (wert) (vr) (vl) (wert) */
		"fxch %%st(1)\n"             /* (wert) (left) (vr) (vl) (wert) */
		"fmul %%st(2), %%st\n"       /* (rite) (left) (vr) (vl) (wert) */
		"fxch %%st(1)\n"             /* (left) (rite) (vr) (vl) (wert) */
		"fadds fadeleft\n"           /* (fl') (rite) (vr) (vl) (wert) */
		"fxch %%st(1)\n"             /* (rite) (fl') (vr) (vl) (wert) */
		"fadds faderight\n"          /* (fr') (fl') (vr) (vl) (wert) */
		"fxch %%st(1)\n"             /* (fl') (fr') (vr) (vl) (wert) */
		"fstps fadeleft\n"           /* (fr') (vr) (vl) (wert) */
		"fstps faderight\n"          /* (vr) (vl) (wert) */
		"movl looptype, %%eax\n"
		"andl %1, %%eax\n"
		"movl %%eax, looptype\n"
		"jmp mixs_if_ende\n"

	"mixs_if_loopme:\n"
	/* sample loops -> jump to loop start */
		"subl mixlooplen, %%ebp\n"
		"decl %%ecx\n"
		"jz mixs_if_ende\n"
		"jmp mixs_if_next\n"
		:
		: "n"(MIXF_LOOPED),
		  "n"(FLAG_DISABLED)
	);

	__asm__ __volatile__
	(
	"mixm_i2f:\n"
	/* mixing, mono w/ cubic interpolation, FILTERED */
		"movl nsamples, %%ecx\n"
		"flds voll\n"                /* (vl) */
		"shrl $2, %%ebp\n"
		"movl %%ebp, mixm_i2f_SM1+2\n" /* self modifying code. set loop end position */
		"movl %%eax, %%ebp\n"
		"shrl $2, %%ebp\n"
		"movl %%edx, %%eax\n"
		"shrl $24, %%eax\n"
	/* align dword... how many times have we ignored this now? */
	"mixm_i2f_next:\n"                   /* (vl) */
		"  flds (,%%ebp,4)\n"        /* (w0) (vl) */
		"  fmuls ct0(,%%eax,4)\n"    /* (w0') (vl) */
		"  flds 4(,%%ebp,4)\n"       /* (w1) (w0') (vl) */
		"  fmuls ct1(,%%eax,4)\n"    /* (w1') (w0') (vl) */
		"  flds 8(,%%ebp,4)\n"       /* (w2) (w1') (w0') (vl) */
		"  fmuls ct2(,%%eax,4)\n"    /* (w2') (w1') (w0') (vl) */
		"  flds 12(,%%ebp,4)\n"      /* (w3) (w2') (w1') (w0') (vl) */
		"  fmuls ct3(,%%eax,4)\n"    /* (w3') (w2') (w1') (w0') (vl) */
		"  fxch %%st(2)\n"           /* (w1') (w2') (w3') (w0') (vl) */
		"  faddp %%st, %%st(3)\n"    /* (w2') (w3') (w0+w1) (vl) */
		"  addl %%esi, %%edx\n"
		"  leal 4(%%edi), %%edi\n"
		"  faddp %%st, %%st(2)\n"    /* (w2+w3) (w0+w1) (vl) */
		"  adcl %%ebx, %%ebp\n"
		"  movl %%edx, %%eax\n"
		"  faddp %%st, %%st(1)\n"    /* (wert) (vl) */

	/* FILTER HIER:
	 * b=reso*b+freq*(in-l);
	 * l+=freq*b;
	 */
		"  fsubs __fl1\n"            /* (in-l) .. */
		"  fmuls ffrq\n"             /* (f*(in-l)) .. */
		"  flds __fb1\n"             /* (b) (f*(in-l)) .. */
		"  fmuls frez\n"             /* (r*b) (f*(in-l)) .. */
		"  faddp %%st, %%st(1)\n"    /* (b') .. */
		"  fsts __fb1\n"
		"  fmuls ffrq\n"             /* (f*b') .. */
		"  fadds __fl1\n"            /* (l') .. */
		"  fsts __fl1\n"             /* (out) (vr) (vl) */

		"  shrl $24, %%eax\n"
		"  fld %%st(1)\n"            /* (vl) (wert) (vl) */
		"  fmulp %%st, %%st(1)\n"    /* (left) (vl) */
		"  fxch %%st(1)\n"           /* (vl) (left) */
		"  fadds volrl\n"            /* (vl') (left) */
		"  fxch %%st(1)\n"           /* (left) (vl) */
		"  fadds -4(%%edi)\n"        /* (lfinal) (vl') */
	"mixm_i2f_SM1:\n"
		"  cmpl $12345678, %%ebp\n"
		"  jge mixm_i2f_LoopHandler\n"
		"  fstps -4(%%edi)\n"        /* (vl') */
		"  decl %%ecx\n"
		"jnz mixm_i2f_next\n"
	"mixm_i2f_ende:\n"
		"fstps voll\n"               /* - */
		"shll $2, %%ebp\n"
		"movl %%ebp, %%eax\n"
		"ret\n"

	"mixm_i2f_LoopHandler:\n"
		"fstps -4(%%edi)\n"          /* (vl') */
		"pushl %%eax\n"
		"movl looptype, %%eax\n"
		"testl %0, %%eax\n"
		"jnz mixm_i2f_loopme\n"
		"popl %%eax\n"
		"subl %%esi, %%edx\n"
		"sbbl %%ebx, %%ebp\n"
		"flds (,%%ebp,4)\n"          /* (wert) (vl) */
	"mixm_i2f_fill:\n"
	/* sample ends -> fill rest of buffer with last sample value */
		"  fld %%st(1)\n"            /* (vl) (wert) (vl) */
		"  fmul %%st(1), %%st\n"     /* (left) (wert) (vl) */
		"  fadds -4(%%edi)\n"        /* (lfinal) (wert) (vl) */
		"  fstps -4(%%edi)\n"        /* (wert) (vl) */
		"  fxch %%st(1)\n"           /* (vl) (wert) */
		"  fadds volrl\n"            /* (vl') (wert) */
		"  fxch %%st(1)\n"           /* (wert) (vl') */
		"  leal 4(%%edi), %%edi\n"
		"  decl %%ecx\n"
		"jnz mixm_i2f_fill\n"
	/* update click-removal fade values */
		"fmul %%st(1), %%st\n"       /* (left) (vl) */
		"fadds fadeleft\n"           /* (fl') (vl) */
		"fstps fadeleft\n"           /* (vl) */
		"movl looptype, %%eax\n"
		"andl %1, %%eax\n"
		"movl %%eax, looptype\n"
		"jmp mixm_i2f_ende\n"

	"mixm_i2f_loopme:\n"
	/* sample loops -> jump to loop start */
		"popl %%eax\n"
		"subl mixlooplen, %%ebp\n"
		"decl %%ecx\n"
		"jz mixm_i2f_ende\n"
		"jmp mixm_i2f_next\n"
		:
		: "n"(MIXF_LOOPED),
		  "n"(FLAG_DISABLED)
	);

	__asm__ __volatile__
	(
	"mixs_i2f:\n"
	/* mixing, stereo w/ cubic interpolation, FILTERED */
		"movl nsamples, %%ecx\n"
		"flds voll\n"                /* (vl) */
		"flds volr\n"                /* (vr) (vl) */
		"shrl $2, %%ebp\n"
		"movl %%ebp, mixs_i2f_SM1+2\n" /* self modifying code.  set loop end position */
		"movl %%eax, %%ebp\n"
		"shrl $2, %%ebp\n"
		"movl %%edx, %%eax\n"
		"shrl $24, %%eax\n"
	/* and again we ignore align dword */
	"mixs_i2f_next:\n"
		"  flds (,%%ebp,4)\n"        /* (w0) (vr) (vl) */
		"  fmuls ct0(,%%eax,4)\n"    /* (w0') (vr) (vl) */
		"  flds 4(,%%ebp,4)\n"       /* (w1) (w0') (vr) (vl) */
		"  fmuls ct1(,%%eax,4)\n"    /* (w1') (w0') (vr) (vl) */
		"  flds 8(,%%ebp,4)\n"       /* (w2) (w1') (w0') (vr) (vl) */
		"  fmuls ct2(,%%eax,4)\n"    /* (w2') (w1') (w0') (vr) (vl) */
		"  flds 12(,%%ebp,4)\n"      /* (w3) (w2') (w1') (w0') (vr) (vl) */
		"  fmuls ct3(,%%eax,4)\n"    /* (w3') (w2') (w1') (w0') (vr) (vl) */
		"  fxch %%st(2)\n"           /* (w1') (w2') (w3') (w0') (vr) (vl) */
		"  faddp %%st, %%st(3)\n"    /* (w2') (w3') (w0+w1) (vr) (vl) */
		"  addl %%esi, %%edx\n"
		"  leal 8(%%edi), %%edi\n"
		"  faddp %%st, %%st(2)\n"    /* (w2+w3) (w0+w1) (vr) (vl) */
		"  adcl %%ebx, %%ebp\n"
		"  movl %%edx, %%eax\n"
		"  faddp %%st, %%st(1)\n"    /* (wert) (vr) (vl) */

	/* FILTER HIER:
	 * b=reso*b+freq*(in-l);
	 * l+=freq*b;
	 */
		"  fsubs __fl1\n"            /* (in-l) .. */
		"  fmuls ffrq\n"             /* (f*(in-l)) .. */
		"  flds __fb1\n"             /* (b) (f*(in-l)) .. */
		"  fmuls frez\n"             /* (r*b) (f*(in-l)) .. */
		"  faddp %%st, %%st(1)\n"    /* (b') .. */
		"  fsts __fb1\n"
		"  fmuls ffrq\n"             /* (f*b') .. */
		"  fadds __fl1\n"            /* (l') .. */
		"  fsts __fl1\n"             /* (out) (vr) (vl) */

		"  shrl $24, %%eax\n"
		"  fld %%st(1)\n"            /* (vr) (wert) (vr) (vl) */
		"  fld %%st(3)\n"            /* (vl) (vr) (wert) (vr) (vl) */
		"  fmul %%st(2), %%st\n"     /* (left) (vr) (wert) (vr) (vl) */
		"  fxch %%st(4)\n"           /* (vl)  (vr) (wert) (vr) (left) */
		"  fadds volrl\n"            /* (vl') (vr) (wert) (vr) (left) */
		"  fxch %%st(2)\n"           /* (wert) (vr) (vl') (vr) (left) */
		"  fmulp %%st(1)\n"          /* (right) (vl') (vr) (left) */
		"  fxch %%st(2)\n"           /* (vr) (vl') (right) (left) */
		"  fadds volrr\n"            /* (vr') (vl') (right) (left) */
		"  fxch %%st(3)\n"           /* (left)  (vl') (right) (vr') */
		"  fadds -8(%%edi)\n"        /* (lfinal) (vl') <right> (vr') */
		"  fxch %%st(2)\n"           /* (right) (vl') (lfinal) (vr') */
		"  fadds -4(%%edi)\n"        /* (rfinal) (vl') (lfinal) (vr') */
	"mixs_i2f_SM1:\n"
		"  cmpl $12345678, %%ebp\n"
		"  jge mixs_i2f_LoopHandler\n"
	/* hier 1 cycle frei */
		"  fstps -4(%%edi)\n"        /* (vl') (lfinal) (vr') */
		"  fxch %%st(1)\n"           /* (lfinal) (vl) (vr) */
		"  fstps -8(%%edi)\n"        /* (vl) (vr) */
		"  fxch %%st(1)\n"           /* (vr) (vl) */
		"  decl %%ecx\n"
		"jnz mixs_i2f_next\n"
	"mixs_i2f_ende:\n"
		"fstps volr\n"               /* (vl) */
		"fstps voll\n"               /* - */
		"shll $2, %%ebp\n"
		"movl %%ebp, %%eax\n"
		"ret\n"

	"mixs_i2f_LoopHandler:\n"
		"fstps -4(%%edi)\n"          /* (vl') (lfinal) (vr') */
		"fxch %%st(1)\n"             /* (lfinal) (vl) (vr) */
		"fstps -8(%%edi)\n"          /* (vl) (vr) */
		"fxch %%st(1)\n"             /* (vr) (vl) */
		"pushl %%eax\n"
		"movl looptype, %%eax\n"
		"testl %0, %%eax\n"
		"jnz mixs_i2f_loopme\n"
		"popl %%eax\n"
		"fxch %%st(1)\n"             /* (vl) (vr) */
		"subl %%esi, %%edx\n"
		"sbbl %%ebx, %%ebp\n"
		"flds (,%%ebp,4)\n"          /* (wert) (vl) (vr) */
		"fxch %%st(2)\n"             /* (vr) (vl) (wert) */
	"mixs_i2f_fill:\n"
	/* sample ends -> fill rest of buffer with last sample value */
		"  fld %%st(1)\n"            /* (vl) (vr) (vl) (wert) */
		"  fmul %%st(3), %%st\n"     /* (left) (vr) (vl) (wert) */
		"  fxch %%st(1)\n"           /* (vr) (left) (vl) (wert) */
		"  fld %%st\n"               /* (vr) (vr) (left) (vl) (wert) */
		"  fmul %%st(4), %%st\n"     /* (right) (vr) (left) (vl) (wert) */
		"  fxch %%st(2)\n"           /* (left) (vr) (right) (vl) (wert) */
		"  fadds -8(%%edi)\n"
		"  fstps -8(%%edi)\n"        /* (vr) (right) (vl) (wert) */
		"  fxch %%st(1)\n"           /* (right) (vr) (vl) (wert) */
		"  fadds -4(%%edi)\n"
		"  fstps -4(%%edi)\n"        /* (vr) (vl) (wert) */
		"  fadds volrr\n"            /* (vr') (vl) (wert) */
		"  fxch %%st(1)\n"           /* (vl) (vr') (wert) */
		"  leal 8(%%edi), %%edi\n"
		"  decl %%ecx\n"
		"  fadds volrl\n"            /* (vl') (vr') (wert) */
		"  fxch %%st(1)\n"           /* (vr') (vl') (wert) */
		"jnz mixs_i2f_fill\n"
	/* update click-removal fade values */
		"fxch %%st(2)\n"             /* (wert) (vl) (vr) */
		"fld %%st\n"                 /* (wert) (wert) (vl) (vr) */
		"fmul %%st(2), %%st\n"       /* (left) (wert) (vl) (vr) */
		"fxch %%st(1)\n"             /* (wert) (left) (vl) (vr) */
		"fmul %%st(3), %%st\n"       /* (rite) (left) (vl) (vr) */
		"fxch %%st(1)\n"             /* (left) (rite) (vl) (vr) */
		"fadds fadeleft\n"           /* (fl') (rite) (vl) (vr) */
		"fxch %%st(1)\n"             /* (rite) (fl') (vl) (vr) */
		"fadds faderight\n"          /* (fr') (fl') (vl) (vr) */
		"fxch %%st(1)\n"             /* (fl') (fr') (vl) (vr) */
		"fstps fadeleft\n"           /* (fr') (vl) (vr) */
		"fstps faderight\n"          /* (vl) (vr) */
		"fxch %%st(1)\n"             /* (vr) (vl) */
		"movl looptype, %%eax\n"
		"andl %1, %%eax\n"
		"movl %%eax, looptype\n"
		"jmp mixs_i2f_ende\n"

	"mixs_i2f_loopme:\n"
	/* sample loops -> jump to loop start */
		"popl %%eax\n"
		"subl mixlooplen, %%ebp\n"
		"decl %%ecx\n"
		"jz mixs_i2f_ende\n"
		"jmp mixs_i2f_next\n"
		:
		: "n"(MIXF_LOOPED),
		  "n"(FLAG_DISABLED)
	);

/*
 * clip routines:
 * esi : 32 bit float input buffer
 * edi : 8/16 bit output buffer
 * ecx : # of samples to clamp (*2 if stereo!)
 */
	__asm__ __volatile__
	(
	"clip_16s:\n"
	/* convert/clip samples, 16bit signed */

		"flds clampmin\n"            /* (min) */
		"flds clampmax\n"            /* (max) (min) */
		"movw $32767, %bx\n"
		"movw $-32768, %dx\n"

	"clip_16s_lp:\n"
		"  flds (%esi)\n"            /* (ls) (max) (min) */
		"  fcom %st(1)\n"
		"  fnstsw %ax\n"
		"  sahf\n"
		"  ja clip_16s_max\n"
		"  fcom %st(2)\n"
		"  fstsw %ax\n"
		"  sahf\n"
		"  jb clip_16s_min\n"
		"  fistps (%edi)\n"          /* (max) (min) fi*s is 16bit */
	"clip_16s_next:\n"
		"  addl $4, %esi\n"
		"  addl $2, %edi\n"
		"  decl %ecx\n"
		"jnz clip_16s_lp\n"
		"jmp clip_16s_ende\n"

	"clip_16s_max:\n"
		"fstp %st\n"                 /* (max) (min) */
		"movw %bx, (%edi)\n"
		"jmp clip_16s_next\n"
	"clip_16s_min:\n"
		"fstp %st\n"
		"movw %dx, (%edi)\n"
		"jmp clip_16s_next\n"

	"clip_16s_ende:\n"
		"fstp %st\n"                 /* (min) */
		"fstp %st\n"                 /* - */
		"ret\n"
	);

	__asm__ __volatile__
	(
	"clip_16u:\n"
	/* convert/clip samples, 16bit unsigned */

		"flds clampmin\n"            /* (min) */
		"flds clampmax\n"            /* (max) (min) */
		"movw $32767, %bx\n"
		"movw $-32768, %dx\n"

	"clip_16u_lp:\n"
		"  flds (%esi)\n"            /* (ls) (max) (min) */
		"  fcom %st(1)\n"
		"  fnstsw %ax\n"
		"  sahf\n"
		"  ja clip_16u_max\n"
		"  fcom %st(2)\n"
		"  fstsw %ax\n"
		"  sahf\n"
		"  jb clip_16u_min\n"
		"  fistps clipval\n"         /* (max) (min) */
		"  movw clipval, %ax\n"
	"clip_16u_next:\n"
		"  xorw $0x8000, %ax\n"
		"  movw %ax, (%edi)\n"
		"  addl $4, %esi\n"
		"  addl $2, %edi\n"
		"  decl %ecx\n"
		"jnz clip_16u_lp\n"
		"jmp clip_16u_ende\n"

	"clip_16u_max:\n"
		"fstp %st\n"                 /* (max) (min) */
		"movw %bx, %ax\n"
		"jmp clip_16u_next\n"
	"clip_16u_min:\n"
		"fstp %st\n"                 /* (max) (min) */
		"movw %dx, %ax\n"
		"jmp clip_16u_next\n"

	"clip_16u_ende:\n"
		"fstp %st\n"                 /* (min) */
		"fstp %st\n"                 /* - */
		"ret\n"
	);

	__asm__ __volatile__
	(
	"clip_8s:\n"
	/* convert/clip samples, 8bit signed */
		"flds clampmin\n"            /* (min) */
		"flds clampmax\n"            /* (max) (min) */
		"movw $32767, %bx\n"
		"movw $-32768, %dx\n"

	"clip_8s_lp:\n"
		"  flds (%esi)\n"            /* (ls) (max) (min) */
		"  fcom %st(1)\n"
		"  fnstsw %ax\n"
		"  sahf\n"
		"  ja clip_8s_max\n"
		"  fcom %st(2)\n"
		"  fstsw %ax\n"
		"  sahf\n"
		"  jb clip_8s_min\n"
		"  fistps clipval\n"         /* (max) (min) */
		"  movw clipval, %ax\n"
	"clip_8s_next:\n"
		"  movb %ah, (%edi)\n"
		"  addl $4, %esi\n"
		"  addl $1, %edi\n"
		"  decl %ecx\n"
		"jnz clip_8s_lp\n"
		"jmp clip_8s_ende\n"

	"clip_8s_max:\n"
		"fstp %st\n"                 /* (max) (min) */
		"movw %bx, %ax\n"
		"jmp clip_8s_next\n"
	"clip_8s_min:\n"
		"fstp %st\n"                 /* (max) (min) */
		"movw %dx, %ax\n"
		"jmp clip_8s_next\n"

	"clip_8s_ende:\n"
		"fstp %st\n"                 /* (min) */
		"fstp %st\n"                 /* - */
		"ret\n"
	);

	__asm__ __volatile__
	(
	"clip_8u:\n"
	/* convert/clip samples, 8bit unsigned */
		"flds clampmin\n"            /* (min) */
		"flds clampmax\n"            /* (max) (min) */
		"movw $32767, %bx\n"
		"movw $-32767, %dx\n"

	"clip_8u_lp:\n"
		"  flds (%esi)\n"            /* (ls) (max) (min) */
		"  fcom %st(1)\n"
		"  fnstsw %ax\n"
		"  sahf\n"
		"  ja clip_8u_max\n"
		"  fcom %st(2)\n"
		"  fstsw %ax\n"
		"  sahf\n"
		"  jb clip_8u_min\n"
		"  fistps clipval\n"         /* (max) (min) */
		"  movw clipval, %ax\n"
	"clip_8u_next:\n"
		"  xorw $0x8000, %ax\n"
		"  movb %ah, (%edi)\n"
		"  addl $4, %esi\n"
		"  addl $1, %edi\n"
		"  decl %ecx\n"
		"jnz clip_8u_lp\n"
		"jmp clip_8u_ende\n"

	"clip_8u_max:\n"
		"fstp %st\n"                 /* (max) (min) */
		"movw %bx, %ax\n"
		"jmp clip_8u_next\n"
	"clip_8u_min:\n"
		"fstp %st\n"                 /* (max) (min) */
		"movw %dx, %ax\n"
		"jmp clip_8u_next\n"

	"clip_8u_ende:\n"
		"fstp %st\n"                 /* (min) */
		"fstp %st\n"                 /* - */
		"ret\n"
	);

	__asm__ __volatile__
	(
	".data\n"
	"clippers:\n"
		".long clip_8s, clip_8u, clip_16s, clip_16u\n"

	"mixers:\n"
		".long mixm_n, mixs_n, mixm_i, mixs_i\n"
		".long mixm_i2, mixs_i2, mix_0, mix_0\n"
		".long mixm_n, mixs_nf, mixm_if, mixs_if\n"
		".long mixm_i2f, mixs_i2f, mix_0, mix_0\n"
	".previous\n"
	);
}

void getchanvol (int n, int len)
{
	int d0;
	__asm__ __volatile__
	(
	/* parm
	 * eax : channel #
	 * ecx : no of samples
	 */
#ifdef __PIC__
	 	"pushl %%ebx\n"
#endif
		"pushl %%ebp\n"
		"fldz\n"                     /* (0) */
		"movl %%ecx, nsamples\n"

		"movl voiceflags(,%%eax,4), %%ebx\n"
		"testl %3, %%ebx\n"
		"jz getchanvol_SkipVoice\n"
		"movl looplen(,%%eax,4), %%ebx\n"
		"movl %%ebx, mixlooplen\n"
		"movl freqw(,%%eax,4), %%ebx\n"
		"movl freqf(,%%eax,4), %%esi\n"
		"movl smpposf(,%%eax,4), %%edx\n"
		"movl loopend(,%%eax,4), %%edi\n"
		"shrl $2, %%edi\n"
		"movl smpposw(,%%eax,4), %%ebp\n"
		"shrl $2, %%ebp\n"

	"getchanvol_next:\n"                 /* (sum) */
		"  flds (,%%ebp,4)\n"        /* (wert) (sum) */
		"  testl $0x80000000, (,%%ebp,4)\n"
		"  jnz getchanvol_neg\n"
		"  faddp %%st, %%st(1)\n"    /* (sum') */
		"  jmp getchanvol_goon\n"
	"getchanvol_neg:\n"
		"  fsubp %%st, %%st(1)\n"
	"getchanvol_goon:\n"
		"  addl %%esi, %%edx\n"
		"  adcl %%ebx, %%ebp\n"
		"  cmpl %%edi, %%ebp\n"
		"  jge getchanvol_LoopHandler\n"
		"  decl %%ecx\n"
		"jnz getchanvol_next\n"
		"jmp getchanvol_SkipVoice\n"
	"getchanvol_LoopHandler:\n"
		"testl %2, voiceflags(,%%eax,4)\n"
		"jz getchanvol_SkipVoice\n"
		"subl looplen(,%%eax,4), %%ebp\n"
		"decl %%ecx\n"
		"jz getchanvol_SkipVoice\n"
		"jmp getchanvol_next\n"
	"getchanvol_SkipVoice:\n"
		"fidivl nsamples\n"          /* (sum'') */
		"fld %%st(0)\n"              /* (s) (s) */
		"fmuls volleft(,%%eax,4)\n"  /* (sl) (s) */
		"fstps voll\n"               /* (s) */
		"fmuls volright(,%%eax,4)\n" /* (sr) */
		"fstps volr\n"               /* - */

		"popl %%ebp\n"
#ifdef __PIC__
	 	"popl %%ebx\n"
#endif
		: "=&c" (d0)
		: "a" (n),
		  "n" (MIXF_LOOPED),
		  "n" (MIXF_PLAYING),
		  "0" (len)
#ifdef __PIC__
		: "edx", "edi", "esi"
#else
		: "ebx", "edx", "edi", "esi"
#endif
	);
}

void stop_dwmixfa(void)
{
}
