/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * WAVPlay file type detection routines for the fileselector
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 */

#include "config.h"
#include <string.h>
#include <stdlib.h>
#include "types.h"
#include "filesel/mdb.h"

static unsigned char wavGetModuleType(const char *buf)
{
	if ((*(unsigned long*)buf==0x46464952)&&(*(unsigned long*)(buf+8)==0x45564157)&&(*(unsigned long*)(buf+12)==0x20746D66)&&(*(unsigned short*)(buf+20)==1))
		return mtWAV;
	return 0xFF;
}


static int wavReadMemInfo(struct moduleinfostruct *m, const char *buf, size_t len)
{
	int type=wavGetModuleType(buf);
	int i,j;

	m->modtype=type;

	switch (type)
	{
		case mtWAV:
			{
				char rate[10];
				i=20;
				m->modname[0]=0;
				sprintf(rate, "%d", (int)(*(unsigned long*)(buf+i+4)));
				for (j=strlen(rate); j<5; j++)
					strcat(m->modname, " ");
				strcat(m->modname, rate);
				if (*(unsigned short*)(buf+i+14)==8)
					strcat(m->modname, "Hz,  8 bit, ");
				else
					strcat(m->modname, "Hz, 16 bit, ");
				if (*(unsigned short*)(buf+i+2)==1)
					strcat(m->modname, "mono");
				else
					strcat(m->modname, "stereo");
				m->channels=*(unsigned short*)(buf+i+2);
				if (*(unsigned long*)(buf+i+16)==61746164)
					m->playtime=*(unsigned long*)(buf+i+20)/ *(unsigned long*)(buf+i+8);
				memset(&m->composer, 0, sizeof(m->composer));
				return 1;
			}
	}
	m->modtype=0xFF;
	return 0;
}

static int wavReadInfo(struct moduleinfostruct *m, FILE *fp, const char *mem, size_t len)
{
	return 0;
}

struct mdbreadnforegstruct wavReadInfoReg = {wavReadMemInfo, wavReadInfo};
