#ifndef _DIRDB_H
#define _DIRDB_H

#define DIRDB_NOPARENT 0xffffffff

extern const char dirdbsigv1[60];

extern void dirdbFlush(void); /* removes all nodes that hasn't been ref'ed yet aswell */
extern void dirdbGetFullname(uint32_t node, char *name /* PATH_MAX+1, ends not with a / */);
extern void dirdbGetFullnameNoBase(uint32_t node, char *name /* PATH_MAX+1, ends not with a / */);
extern void dirdbGetname(uint32_t node, char *name /*NAME_MAX+1*/);
extern void dirdbUnref(uint32_t node);
extern void dirdbRef(uint32_t node);
extern uint32_t dirdbFindAndRef(uint32_t parent, const char *name /* NAME_MAX + 1 */);
extern uint32_t dirdbResolvPathWithBaseAndRef(uint32_t base, char *name /* PATH_MAX + 1 */);
extern int dirdbInit(void);
extern void dirdbClose(void);

#endif
