/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * CPIFace file type dectection routines for the file selector
 *
 * revision history: (please note changes here)
 *  -kb980717   Tammo Hinrichs <opencp@gmx.net>
 *    -first release
 *  -fd981119   Felix Domke <tmbinc@gmx.net>
 *    -added the really important 'NO_CPIFACE_IMPORT'
 */

#include "config.h"
#include <string.h>
#include <stdlib.h>
#include "types.h"
#include "filesel/mdb.h"

static int cpiReadMemInfo(struct moduleinfostruct *m, const char *buf, size_t _ignore)
{
	if (!memcmp(buf, "CPANI\x1A\x00\x00", 8))
	{
		strncpy(m->modname,(char *)buf+8,31);
		if (!m->modname[0])
			strcpy(m->modname,"wuerfel mode animation");
		m->modtype=mtANI;
		return 1;
	}
	return 0;
}

static int cpiReadInfo(struct moduleinfostruct *m, FILE *file, const char *c, size_t _ignore)
{
	return 0;
}

struct mdbreadinforegstruct cpiReadInfoReg = {cpiReadMemInfo, cpiReadInfo};
