/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * CP.INI file and environment reading functions
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -fd981014   Felix Domke <tmbinc@gmx.net>
 *    -Bugfix at cfReadINIFile (first if-block, skips the filename in
 *     the commandline, without these, funny errors occured.)
 *  -fd981106   Felix Domke    <tmbinc@gmx.net>
 *    -edited for new binfile
 *  -ss040613   Stian Skjelstad <stian@nixia.no>
 *    - rewritten for unix
 *    - use argc and argv semantics
 *  -ss040825   Stian Skjelstad <stian@nixia.no>
 *    - added back the commandline stuff
 */

/*#define NO_CPDLL_IMPORT*/

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
/*#include "binfstd.h"*/
#include "psetting.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

/*char cfCPPath[PATH_MAX+1];*/ /* this is argv[0]*/
char cfConfigDir[PATH_MAX+1];
char cfDataDir[PATH_MAX+1]="";
char cfProgramDir[PATH_MAX+1]; /* we get this from argv[0] */
char cfTempDir[PATH_MAX+1]="/tmp";

#define KEYBUF_LEN 105
#define STRBUF_LEN 405

extern char fsListScramble;
extern char fsListRemove;
extern char fsScanNames;
extern char fsScanArcs;
extern char fsScanInArc;
extern char fsScanMIF;
extern char fsWriteModInfo;
extern char fsScrType;
extern char fsEditWin;
extern char fsColorTypes;

const char *cfConfigSec;
const char *cfSoundSec;
const char *cfScreenSec;
/*const char *cfCommandLine;*/


struct profilekey
{
  char *key;
  char *str;
  int linenum;
};

struct profileapp
{
  char *app;
  struct profilekey *keys;
  int nkeys;
  int linenum;
};

static struct profileapp *cfINIApps=NULL;
static int cfINInApps=0;

static int readiniline(char *key, char *str, char *line)
{
	const char *sol;
	const char *eol;
	const char *chk;

  /* read until we get a line*/
	while (isspace(*line))
		line++;
  /* this line is a comment ?*/
	if (((*line)==';')||((*line)=='#')||(!*line))
		return 0;

	sol=line;

	eol=sol;
    
	while ((*eol!=';')&&(*eol))
		eol++;
	while (isspace(eol[-1]))
	{
		if (sol==eol)
			return 0;
		eol--;
	}
	if ((*sol=='[')&&(eol[-1]==']'))
	{
		strcpy(key, "[]");
		if ((eol-sol)>400)
			return 0;
		memcpy(str, sol+1, eol-sol-2);
		str[eol-sol-2]=0;
		return 1;
	}
	if (!(chk=strchr(sol, '=')))
		return 0;
	while (isspace(chk[-1]))
	{
		if (chk==sol)
			return 0;
		chk--;
	}
	
	if ((chk-sol)>=(KEYBUF_LEN-1))
		return 0;
	memcpy(key, sol, chk-sol);
	key[chk-sol]=0;
	
	while (chk[-1]!='=')
		chk++;
	
	while ((chk<eol)&&isspace(*chk))
		chk++;
	
	if ((eol-chk)>=(STRBUF_LEN-1))
		return 0;
	memcpy(str, chk, eol-chk);
	str[eol-chk]=0;

	return 2;
}

static int cfReadINIFile(int argc, char *argv[])
{
	char path[PATH_MAX+1];
	FILE *f;
	int linenum=0;

	char keybuf[KEYBUF_LEN];
	char strbuf[STRBUF_LEN];


	char linebuffer[1024];
	/*  int curapp=-1;*/

	strcpy(path, cfConfigDir);
	strcat(path, "ocp.ini");

	strcpy(keybuf, "");

	cfINIApps=0;
	cfINInApps=0;
	
	if (!(f=fopen(path, "r")))
	{
/*		fprintf(stderr, "Failed to parse (%s)\n", path);*/
		strcpy(path, cfConfigDir);
		strcat(path, "cp.ini");
		if (!(f=fopen(path, "r")))
		{
/*			fprintf(stderr, "Failed to parse (%s)\n", path);*/
			return 1;
		}
	}

/*	fprintf(stderr, "Parsing %s\n", path);*/
 
	while (fgets(linebuffer, sizeof(linebuffer), f))
	{
		linenum++;
		if (linebuffer[strlen(linebuffer)]=='\n')
			linebuffer[strlen(linebuffer)]=0;

	    	switch (readiniline(keybuf, strbuf, linebuffer))
		{
			case 0:
				break;
			case 1:
				cfINInApps++;
				cfINIApps=realloc(cfINIApps, sizeof(cfINIApps[cfINInApps])*cfINInApps);
				cfINIApps[cfINInApps-1].app=strdup(strbuf);
				cfINIApps[cfINInApps-1].keys=NULL;
				cfINIApps[cfINInApps-1].nkeys=0;
				cfINIApps[cfINInApps-1].linenum=linenum;
				continue;
			case 2:
				{
					int index=cfINIApps[cfINInApps-1].nkeys;
					cfINIApps[cfINInApps-1].nkeys++;
					cfINIApps[cfINInApps-1].keys=realloc(cfINIApps[cfINInApps-1].keys, sizeof(cfINIApps[cfINInApps-1].keys[0])*(index+1));
					cfINIApps[cfINInApps-1].keys[index].key=strdup(keybuf);
					cfINIApps[cfINInApps-1].keys[index].str=strdup(strbuf);
					cfINIApps[cfINInApps-1].keys[index].linenum=linenum;
					continue;
				}
		}
	}
	{
		char *argvstat=0;
		int c;

		for (c=1;c<argc;c++)
			if ((argv[c][0]=='-')||(argv[c][0]=='/'))
			if (argv[c][1])
			{
				cfINInApps++;
				cfINIApps=realloc(cfINIApps, sizeof(cfINIApps[cfINInApps])*cfINInApps);
				cfINIApps[cfINInApps-1].app=strdup("commandline__");
				cfINIApps[cfINInApps-1].app[12]=argv[c][1];
				cfINIApps[cfINInApps-1].keys=NULL;
				cfINIApps[cfINInApps-1].nkeys=0;
				cfINIApps[cfINInApps-1].linenum=-1;

				argvstat=argv[c]+2;
				while (*argvstat)
				{
					char *temp=index(argvstat, ',');
					int index=cfINIApps[cfINInApps-1].nkeys;

					if (!temp)
						temp=argvstat+strlen(argvstat);

					cfINIApps[cfINInApps-1].nkeys++;
					cfINIApps[cfINInApps-1].keys=realloc(cfINIApps[cfINInApps-1].keys, sizeof(cfINIApps[cfINInApps-1].keys[0])*(index+1));
					cfINIApps[cfINInApps-1].keys[index].key=strdup("_");
					cfINIApps[cfINInApps-1].keys[index].key[0]=*argvstat;
					argvstat++;
					cfINIApps[cfINInApps-1].keys[index].str=malloc(temp-argvstat+1);
					strncpy(cfINIApps[cfINInApps-1].keys[index].str, argvstat, temp-argvstat);
					cfINIApps[cfINInApps-1].keys[index].str[temp-argvstat]=0;
					cfINIApps[cfINInApps-1].keys[index].linenum=-1;
					argvstat=temp;
					if (*argvstat)
						argvstat++;
				}
			}
			
		cfINInApps++;
		cfINIApps=realloc(cfINIApps, sizeof(cfINIApps[cfINInApps])*cfINInApps);
		cfINIApps[cfINInApps-1].app=strdup("CommandLine");
		cfINIApps[cfINInApps-1].keys=NULL;
		cfINIApps[cfINInApps-1].nkeys=0;
		cfINIApps[cfINInApps-1].linenum=-1;

		for (c=1;c<argc;c++)
			if ((argv[c][0]=='-')||(argv[c][0]=='/'))
			if (argv[c][1])
			{
				int index=cfINIApps[cfINInApps-1].nkeys;
				cfINIApps[cfINInApps-1].nkeys++;
				cfINIApps[cfINInApps-1].keys=realloc(cfINIApps[cfINInApps-1].keys, sizeof(cfINIApps[cfINInApps-1].keys[0])*(index+1));
				cfINIApps[cfINInApps-1].keys[index].key=strdup("_");
				cfINIApps[cfINInApps-1].keys[index].key[0]=argv[c][1];
				cfINIApps[cfINInApps-1].keys[index].str=strdup(argv[c]+2);
				cfINIApps[cfINInApps-1].keys[index].linenum=-1;
			}
	}
	fclose(f);
	return 0;
}

static void cfFreeINI(void)
{
	int i, j;
	for (i=0;i<cfINInApps;i++)
	{
		for (j=0;j<cfINIApps[i].nkeys;j++)
		{
			free(cfINIApps[i].keys[j].key);
			free(cfINIApps[i].keys[j].str);
		}
		free(cfINIApps[i].app);
		if (cfINIApps[i].keys)
			free(cfINIApps[i].keys);
	}
	if (cfINIApps)
		free(cfINIApps);
}

void cfCloseConfig()
{
	cfFreeINI();
}

const char *cfGetProfileString(const char *app, const char *key, const char *def)
{
	int i,j;
	for (i=0; i<cfINInApps; i++)
		if (!strcasecmp(cfINIApps[i].app, app))
			for (j=0; j<cfINIApps[i].nkeys; j++)
				if (!strcasecmp(cfINIApps[i].keys[j].key, key))
					return cfINIApps[i].keys[j].str;
	return def;
}

const char *cfGetProfileString2(const char *app, const char *app2, const char *key, const char *def)
{
	return cfGetProfileString(app, key, cfGetProfileString(app2, key, def));
}

int cfGetProfileInt(const char *app, const char *key, int def, int radix)
{
	const char *s=cfGetProfileString(app, key, "");
	if (!*s)
		return def;
	return strtol(s, 0, radix);
}

int cfGetProfileInt2(const char *app, const char *app2, const char *key, int def, int radix)
{
	return cfGetProfileInt(app, key, cfGetProfileInt(app2, key, def, radix), radix);
}

int cfGetProfileBool(const char *app, const char *key, int def, int err)
{
	const char *s=cfGetProfileString(app, key, 0);
	if (!s)
		return def;
	if (!*s)
		return err;
	if (!strcasecmp(s, "on")||!strcasecmp(s, "yes")||!strcasecmp(s, "+")||!strcasecmp(s, "true")||!strcasecmp(s, "1"))
		return 1;
	if (!strcasecmp(s, "off")||!strcasecmp(s, "no")||!strcasecmp(s, "-")||!strcasecmp(s, "false")||!strcasecmp(s, "0"))
		return 0;
	return err;
}

int cfGetProfileBool2(const char *app, const char *app2, const char *key, int def, int err)
{
	return cfGetProfileBool(app, key, cfGetProfileBool(app2, key, def, err), err);
}


int cfCountSpaceList(const char *str, int maxlen)
{
	int i=0;
	while (1)
	{
		const char *fb;

	    	while (isspace(*str))
			str++;
		if (!*str)
			return i;
		fb=str;
		while (!isspace(*str)&&*str)
			str++;
		if ((str-fb)<=maxlen)
			i++;
	}
}

int cfGetSpaceListEntry(char *buf, const char **str, int maxlen)
{
	while (1)
	{
		const char *fb;

		while (isspace(**str))
			(*str)++;
		if (!**str)
			return 0;
		fb=*str;
		while (!isspace(**str)&&**str)
			(*str)++;
		if (((*str)-fb)>maxlen)
			continue;
		memcpy(buf, fb, (*str)-fb);
		buf[(*str)-fb]=0;
		return 1;
	}
}



















int cfGetConfig(int argc, char *argv[])
{
	const char *t;

	if (!argc)
		return -1; /* no config at all pigs! */
	if (cfReadINIFile(argc, argv))
		fprintf(stderr, "Failed to read ocp.ini\nPlease put it in ~/.ocp/\n");
	else
		goto gotconfig;
	return -1;
gotconfig:

	strcpy(cfDataDir, cfGetProfileString("general", "datadir", cfDataDir));
	if (!cfDataDir[0])
		strcpy(cfDataDir, cfProgramDir);
	if (cfDataDir[strlen(cfDataDir)-1]!='/')
		strcat(cfDataDir, "/");
   
	t=getenv("TEMP");
	if (!t)
		t=getenv("TMP");
	if (t)
		strcpy(cfTempDir, t);
	if ((t=cfGetProfileString("general", "tempdir", t)))
		strcpy(cfTempDir, t);
	if (cfTempDir[strlen(cfTempDir)-1]!='/')
		strcat(cfTempDir, "/");

/*	{
	       	int i, j;
		for (i=0;i<cfINInApps;i++)
		{
			fprintf(stderr, "Section [%s]\n", cfINIApps[i].app);
			for (j=0;j<cfINIApps[i].nkeys;j++)
				fprintf(stderr, " %s=%s\n", cfINIApps[i].keys[j].key, cfINIApps[i].keys[j].str);
		}
	}*/

	return 0;
}
