#ifndef _ADB_H
#define _ADB_H

enum
{
	adbCallGet, adbCallDelete, adbCallMoveTo, adbCallMoveFrom, adbCallPut
};

struct adbregstruct
{
	const char *ext;
	int (*Scan)(const char *path);
	int (*Call)(int act, const char *apath, const char *fullname, const char *file, const char *dpath);
	struct adbregstruct *next;
};

#define ARC_PATH_MAX 127
struct __attribute__((packed)) arcentry
{
#define ADB_USED 1
#define ADB_DIRTY 2
#define ADB_ARC 4
	uint8_t flags;
	uint32_t parent;
	char name[ARC_PATH_MAX+1]; /* some stupid archives needs full path, which can be long */
	uint32_t size;
};

extern char adbInit(void);
extern void adbUpdate(void);
extern void adbClose(void);

extern int adbAdd(const struct arcentry *a);
extern uint32_t adbFind(const char *arcname);
extern char isarchivepath(const char *p);

#endif
