/* OpenCP Module Player
 * copyright (c) '94-'98 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * Audio CD player
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -ss040907   Stian Skjelstad <stian@nixia.no>
 *    -complete rewrite for linux
 */

#include <linux/cdrom.h>
#include "config.h"
#include <stdio.h>
#include <sys/ioctl.h>
#include "types.h"
#include "cdaudio.h"

int cdIsCDDrive(int fd)
{
	if (ioctl(fd, CDROM_GET_CAPABILITY, 0)>=0)
		return 1;
	return 0;
}

void cdStop(int fd)
{
	if (ioctl(fd, CDROMPAUSE))
		perror("cdaplay: ioctl(fd, CDROMPAUSE)");
}

void cdRestart(int fd)
{
	if (ioctl(fd, CDROMRESUME))
		perror("cdaplay: ioctl(fd, CDROMRESUME)");
}

unsigned short cdGetTracks(int fd, unsigned long *starts, unsigned char *first, unsigned short maxtracks)
{
	int min=0, max=0, i;
	struct cdrom_tochdr tochdr;
	struct cdrom_tocentry tocentry;

	*first=0;
	if (!ioctl(fd, CDROMREADTOCHDR, &tochdr))
	{
		if ((min=tochdr.cdth_trk0)<0)
			min=0;
		max=tochdr.cdth_trk1;
		if (max>maxtracks)
			max=maxtracks;
		for (i=min;i<=max;i++)
		{
			tocentry.cdte_track=i;
			tocentry.cdte_format= CDROM_LBA;
			if (!ioctl(fd, CDROMREADTOCENTRY, &tocentry))
				starts[i-min]=tocentry.cdte_addr.lba;
			else {
				perror("cdaplay: ioctl(fd, CDROMREADTOCENTRY, &tocentry)");
				max=i-1;
			}
		}
		tocentry.cdte_track=CDROM_LEADOUT;
		tocentry.cdte_format= CDROM_LBA;
		if (!ioctl(fd, CDROMREADTOCENTRY, &tocentry))
			starts[max+1-min]=tocentry.cdte_addr.lba;
		else {
			perror("cdaplay: ioctl(fd, CDROMREADTOCENTRY, &tocentry)");
			max-=1;
		}
	} else
		perror("cdaplay: ioctl(fd, CDROMREADTOCHDR, &tochdr)");
	if (max<0)
		min=max=0;
	*first=min;
	return max-min;
}

void cdPlay(int fd, unsigned long start, unsigned long len)
{
	struct cdrom_blk blk;
	blk.from=start;
	blk.len=len;
	if (ioctl(fd, CDROMPLAYBLK, &blk))
		perror("cdaplay: ioctl(fd, CROMPLAYBLK, &blk)");
}

unsigned long cdGetHeadLocation(int fd, uint16_t *stat)
{
	struct cdrom_subchnl subchn;

	subchn.cdsc_format=CDROM_LBA;
	if (ioctl(fd, CDROMSUBCHNL, &subchn))
	{
		perror("cdaplay: ioctl(fd, CDROMSUBCHNL, &subchn)");
		*stat=STATUS_ERROR;
		return 0;
	}
	switch (subchn.cdsc_audiostatus)
	{
		case CDROM_AUDIO_NO_STATUS:
		case CDROM_AUDIO_PLAY:
			*stat=STATUS_PLAY;
			break;
		case CDROM_AUDIO_PAUSED:
		case CDROM_AUDIO_COMPLETED:
			*stat=0;
			break;
		default:
			*stat=STATUS_ERROR;
	}
	return subchn.cdsc_absaddr.lba;
}
