/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * GMDPlay loader for X-Tracker modules
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 */

#include "config.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "types.h"
#include "boot/plinkman.h"
#include "dev/mcp.h"
#include "gmdplay.h"
#include "stuff/err.h"

static const uint8_t *ibuf;
static uint32_t bitbuf;
static uint8_t bitnum;

static inline uint16_t readbitsdmf(uint8_t n)
{
	uint16_t v=bitbuf&((1L<<n)-1);
	bitbuf>>=n;
	bitnum-=n;
	if (bitnum<=24)
	{
		bitbuf|=(long)*ibuf++<<bitnum;
		bitnum+=8;
	}
	return v;
}

static uint16_t nodenum, lastnode;
static int16_t huff[255][3];

static void readtree(void)
{
	int16_t (*node)[3];
	uint8_t left;
	uint8_t right;

	huff[nodenum][2]=readbitsdmf(7);
	node=&huff[lastnode];
	left=readbitsdmf(1);
	right=readbitsdmf(1);
	
	lastnode=++nodenum;
	if (left)
	{
		(*node)[0]=lastnode;
		readtree();
	} else
		(*node)[0]=-1;
	lastnode=nodenum;
	if (right)
	{
		(*node)[1]=lastnode;
		readtree();
	} else
		(*node)[1]=-1;
}

static void unpack0(uint8_t *ob, const void *ib, uint32_t len)
{
	uint32_t i;

	ibuf=(const uint8_t*)ib;
	bitbuf=*(uint32_t*)ibuf;
	ibuf+=4;
	bitnum=32;

	nodenum=lastnode=0;
	readtree();

	for (i=0; i<len; i++)
	{
		uint8_t sign=readbitsdmf(1)?0xFF:0;
		uint16_t pos=0;
		while ((huff[pos][0]!=-1)&&(huff[pos][1]!=-1))
			pos=huff[pos][readbitsdmf(1)];
		*ob++=huff[pos][2]^sign;
	}
}

static inline void putcmd(uint8_t **p, uint8_t c, uint8_t d)
{
	*(*p)++=c;
	*(*p)++=d;
}

static void calctempo(uint16_t rpm, uint8_t *tempo, uint8_t *bpm)
{
	for ((*tempo)=30; (*tempo)>1; (*tempo)--)
		if ((rpm*(*tempo)/24)<256)
			break;
	(*bpm)=rpm*(*tempo)/24;
}

int mpLoadDMF(struct gmdmodule *m, FILE *file)
{
	struct __attribute__((packed)) {
		uint32_t sig;
		uint8_t ver;
		char tracker[8];
		char name[30];
		char composer[20];
		char date[3];
	} hdr;
	
	uint32_t sig;
	uint32_t next;

	uint16_t ordloop,ordnum;
	uint16_t *orders;

	uint16_t patnum;
	uint8_t chnnum;

	uint8_t *patbuf;
	uint8_t **patadr;
	uint8_t (*temptrack)[3000];
	
	uint8_t *curadr;
	int16_t i;

	uint16_t nordnum;

	uint16_t curord;

	uint8_t speed;
	uint8_t ttype;
	uint8_t pbeat;
	uint8_t *pp=0;
	uint8_t voc=0; /* suppres warning for now ...*/
	uint16_t len=0; /* suppres warning for now ...*/
	uint8_t nextinfobyte[33];

	uint8_t smppack[256];

	mpReset(m);

  	fread(&hdr, sizeof(hdr), 1, file);
	if (hdr.sig!=*(uint32_t *)"DDMF")
		return errFormSig;

	if (hdr.ver<5)
		return errFormOldVer;

	m->options=MOD_TICK0|MOD_EXPOFREQ;

	memcpy(m->name, hdr.name, 30);
	m->name[30]=0;

	memcpy(m->composer, hdr.composer, 20);
	m->composer[20]=0;

	fread(&sig, sizeof(uint32_t), 1, file);
	fread(&next, sizeof(uint32_t), 1, file);

	if (sig==*(uint32_t *)"INFO")
	{
		fseek(file, next, SEEK_CUR);
		fread(&sig, sizeof(uint32_t), 1, file);
		fread(&next, sizeof(uint32_t), 1, file);
	}

	if (sig==*(uint32_t *)"CMSG")
	{
		char waste;
		uint16_t msglen;
		int16_t t;
		int16_t i;	
		fread(&waste, 1, 1, file);
		msglen=(next-1)/40;

		if (msglen)
		{
			m->message=malloc(sizeof(char *)*(msglen+1));
			if (!m->message)
				return errAllocMem;
			*m->message=malloc(sizeof(char)*(msglen*41));
			if (!*m->message)
				return errAllocMem;

			for (t=0; t<msglen; t++)
			{
				m->message[t]=*m->message+t*41;
				fread(m->message[t], 40, 1, file);
        
				for (i=0; i<40; i++)
					if (!m->message[t][i])
						m->message[t][i]=' ';
				m->message[t][40]=0;
			}
			m->message[msglen]=0;
		}

		fread(&sig, sizeof(uint32_t), 1, file);
		fread(&next, sizeof(uint32_t), 1, file);
	}

	if ((sig!=*(uint32_t *)"SEQU")||(next&1))
		return errFormStruc;

	orders=malloc(sizeof(uint16_t)*(next-4)); /* maybe too much... */
	if (!orders)
		return errAllocMem;
	fread(&ordloop, sizeof(int16_t), 1, file);
	fread(&ordnum, sizeof(int16_t), 1, file);
	fread(orders, next-4, 1, file);
	ordnum++;

	if (2*ordnum>(next-4))
		ordnum=(next-4)/2;
	if (ordloop>=ordnum)ordloop=0;

	fread(&sig, sizeof(uint32_t), 1, file);
	fread(&next, sizeof(uint32_t), 1, file);

	if (sig!=*(uint32_t *)"PATT")
		return errFormStruc;

	fread(&patnum, sizeof(uint16_t), 1, file);
	fread(&chnnum, sizeof(uint8_t), 1, file);
	m->channum=chnnum;

	patbuf=malloc(sizeof(uint8_t)*(next-3));
	patadr=malloc(sizeof(uint8_t *)*(patnum));
	temptrack=malloc(sizeof(uint8_t)*(m->channum+1)*3000);
	if (!patbuf||!patadr||!temptrack)
		return errAllocMem;
	fread(patbuf, next-3, 1, file);

/* get the pattern start adresses */
	curadr=patbuf; /* this part can easy crash if values are fucked in buffer we just red, TODO */
	for (i=0; i<patnum; i++)
	{
		patadr[i]=curadr;
		curadr+=8+*(uint32_t *)(curadr+4);
	}

/* get the new order number */
	nordnum=0;
	for (i=0; i<ordnum; i++)
		nordnum+=(*(uint16_t *)(patadr[orders[i]]+2)>256)?2:1;

/* relocate orders */
	curord=nordnum;
	for (i=ordnum-1; i>=0; i--)
	{
		if (*(unsigned short*)(patadr[orders[i]]+2)>256)
		{
			curord-=2;
			orders[curord]=orders[i];
			orders[curord+1]=orders[i]|0x8000;
		} else
			orders[--curord]=orders[i];
		if (i==ordloop)
			ordloop=curord;
	}
	ordnum=nordnum;

	m->patnum=ordnum;
	m->ordnum=ordnum;
	m->endord=m->patnum;
	m->loopord=ordloop;
	m->tracknum=ordnum*(m->channum+1);

	if (!mpAllocTracks(m, m->tracknum)||!mpAllocPatterns(m, m->patnum)||!mpAllocOrders(m, m->ordnum))
		return errAllocMem;

	for (i=0; i<m->ordnum; i++)
		m->orders[i]=i;

	speed=125;
	ttype=1;
	pbeat=8;

/* convert patterns */
	for (i=0; i<ordnum; i++)
	{
/*    if (orders[i]&0x8000)
        return errFormStruc; */
		int16_t j, row;
		int16_t rownum;

		uint8_t *(tp[33]);

		struct gmdtrack *trk;
		uint16_t tlen;

		if (!(orders[i]&0x8000))
		{
			pp=patadr[orders[i]&~0x8000];
			voc=*pp++;
			pbeat=(*pp++)>>4;
			if (!pbeat)
				pbeat=8;
			len=*(unsigned short*)pp;
			pp+=6;
			memset(nextinfobyte, 0, 33);
			if (len>256)
				rownum=256;
			else
				rownum=len;
		} else
			rownum=len-256;

		m->patterns[i].patlen=rownum;

		for (j=0; j<=m->channum; j++)
			tp[j]=temptrack[j];

		for (j=voc; j<m->channum; j++)
		{
			*tp[j]++=0;
			*tp[j]++=2;
			*tp[j]++=cmdKeyOff;
			*tp[j]++=0;
		}

		for (row=0; row<rownum; row++)
		{
			if (!nextinfobyte[m->channum])
			{
				uint8_t info;
				uint8_t data=data; /* supress warning.. it depends on info, and that is safe */
				uint8_t *cp;
				uint8_t tempochange;

				if (!pp)
				{
					fprintf(stderr, "playgmd: gmdldmf.c: pp not set\n");
					free(orders);
					free(patbuf);
					free(patadr);
					free(temptrack);
					return errFormStruc;
				}
				info=*pp++;

				if (info&0x80)
					nextinfobyte[m->channum]=*pp++;
				info&=~0x80;
				if (info)
					data=*pp++;

				cp=tp[m->channum]+2;
				tempochange=!row&&ttype&&!(orders[i]&0x8000);

				switch (info)
				{
					case 1:
						ttype=0;
						speed=data;
						tempochange=1;
						break;
					case 2:
						ttype=1;
						speed=data;
						tempochange=1;
						break;
					case 3:
						pbeat=data>>4;
						tempochange=ttype;
						break;
				}

				if (tempochange)
				{
					uint8_t tempo;
					uint8_t bpm;
					if (ttype&&pbeat)
						calctempo(speed*pbeat, &tempo, &bpm);
					else
						calctempo((speed+1)*15, &tempo, &bpm);
					putcmd(&cp, cmdTempo, tempo);
					putcmd(&cp, cmdSpeed, bpm);
				}

				if (cp!=(tp[m->channum]+2))
				{
					tp[m->channum][0]=row;
					tp[m->channum][1]=cp-tp[m->channum]-2;
					tp[m->channum]=cp;
				}
			} else
				nextinfobyte[m->channum]--;

			for (j=0; j<voc; j++)
				if (!nextinfobyte[j])
				{
					uint8_t cmds[9];
					uint8_t info=*pp++;
					uint8_t *cp;

					if (info&0x80)
						nextinfobyte[j]=*pp++;
					if (info&0x40)
						cmds[0]=*pp++;
					else
						cmds[0]=0;
					if (info&0x20)
						cmds[1]=*pp++;
					else
						cmds[1]=0;
					if (info&0x10)
						cmds[2]=*pp++;
					else
						cmds[2]=0;
					if (info&0x08)
					{
						cmds[3]=*pp++;
						cmds[4]=*pp++;
					} else
						cmds[3]=cmds[4]=0;
					if (info&0x04)
					{
						cmds[5]=*pp++;
						cmds[6]=*pp++;
					} else
						cmds[5]=cmds[6]=0;
					if (info&0x02)
					{
						cmds[7]=*pp++;
						cmds[8]=*pp++;
					} else
						cmds[7]=cmds[8]=0;

					cp=tp[j]+2;

					if (cmds[0]||(cmds[1]&&(cmds[1]!=255))||cmds[2]||(cmds[7]==7))
					{
						unsigned char *act=cp;
						*cp++=cmdPlayNote;
						if (cmds[0])
						{
							*act|=cmdPlayIns;
							*cp++=cmds[0]-1;
						}
						if (cmds[1]&&(cmds[1]!=255))
						{
							*act|=cmdPlayNte;
							*cp++=cmds[1]+23;
						}
						if (cmds[2])
						{
							*act|=cmdPlayVol;
							*cp++=cmds[2]-1;
						}
						if (cmds[7]==7)
						{
							*act|=cmdPlayPan;
							*cp++=cmds[8];
						}
					}
					if (cmds[1]==255)
						putcmd(&cp, cmdKeyOff, 0);

					switch (cmds[3])
					{
						case 1:
							putcmd(&cp, cmdKeyOff, 0); /* falsch! */
							break;
						case 2:
							putcmd(&cp, cmdSetLoop, 0);
							break;
						case 6:
							putcmd(&cp, cmdOffset, cmds[4]);
							break;
					}

					switch (cmds[5])
					{
						case 1:
							putcmd(&cp, cmdRowPitchSlideDMF, cmds[6]);
							break;
						case 3:
							putcmd(&cp, cmdArpeggio, cmds[6]);
							break;
						case 4:
							putcmd(&cp, cmdPitchSlideUDMF, cmds[6]);
							break;
						case 5:
							putcmd(&cp, cmdPitchSlideDDMF, cmds[6]);
							break;
						case 6:
							putcmd(&cp, cmdPitchSlideNDMF, cmds[6]);
							break;
						case 8:
							putcmd(&cp, cmdPitchVibratoSinDMF, cmds[6]);
							break;
						case 9:
							putcmd(&cp, cmdPitchVibratoTrgDMF, cmds[6]);
							break;
						case 10:
							putcmd(&cp, cmdPitchVibratoRecDMF, cmds[6]);
							break;
						case 12:
							putcmd(&cp, cmdKeyOff, 0); /* falsch! */
							break;
					}

					switch (cmds[7])
					{
						case 1:
							putcmd(&cp, cmdVolSlideUDMF, cmds[8]);
							break;
						case 2:
							putcmd(&cp, cmdVolSlideDDMF, cmds[8]);
							break;
						case 4:
							putcmd(&cp, cmdVolVibratoSinDMF, cmds[8]);
							break;
						case 5:
							putcmd(&cp, cmdVolVibratoTrgDMF, cmds[8]);
							break;
						case 6:
							putcmd(&cp, cmdVolVibratoRecDMF, cmds[8]);
							break;
						case 8:
							putcmd(&cp, cmdPanSlideLDMF, cmds[8]);
							break;
						case 9:
							putcmd(&cp, cmdPanSlideRDMF, cmds[8]);
							break;
						case 10:
							putcmd(&cp, cmdPanVibratoSinDMF, cmds[8]);
							break;
					}

					if (cp!=(tp[j]+2))
					{
						tp[j][0]=row;
						tp[j][1]=cp-tp[j]-2;
						tp[j]=cp;
					}
				} else
					nextinfobyte[j]--;
		}

		for (j=0; j<m->channum; j++)
		{
			struct gmdtrack *trk;
			uint16_t tlen;

			m->patterns[i].tracks[j]=i*(m->channum+1)+j;

			trk=&m->tracks[i*(m->channum+1)+j];
			tlen=tp[j]-temptrack[j];

			if (!tlen)
				trk->ptr=trk->end=0;
			else {
				trk->ptr=malloc(sizeof(uint8_t)*tlen);
				trk->end=trk->ptr+tlen;
				if (!trk->ptr)
					return errAllocMem;
				memcpy(trk->ptr, temptrack[j], tlen);
			}
		}

		m->patterns[i].gtrack=i*(m->channum+1)+m->channum;

		trk=&m->tracks[i*(m->channum+1)+m->channum];
		tlen=tp[m->channum]-temptrack[m->channum];

		if (!tlen)
			trk->ptr=trk->end=0;
		else {
			trk->ptr=malloc(sizeof(uint8_t)*tlen);
			trk->end=trk->ptr+tlen;
			if (!trk->ptr)
				return errAllocMem;
			memcpy(trk->ptr, temptrack[m->channum], tlen);
		}
	}

	free(temptrack);
	free(patbuf);
	free(patadr);
	free(orders);

	fread(&sig, sizeof(uint32_t), 1, file);
	fread(&next, sizeof(uint32_t), 1, file);

/* inst!! */

	if ((sig!=*(uint32_t *)"SMPI"))
		return errFormStruc;

	
	fread(&m->instnum, sizeof(uint8_t), 1, file);
	m->modsampnum=m->sampnum=m->instnum;


	
	if (!mpAllocInstruments(m, m->instnum)||!mpAllocSamples(m, m->sampnum)||!mpAllocModSamples(m, m->modsampnum))
		return errAllocMem;


	for (i=0; i<m->instnum; i++)
	{
		struct gmdinstrument *ip=&m->instruments[i];
		struct gmdsample *sp=&m->modsamples[i];
		struct sampleinfo *sip=&m->samples[i];

		uint8_t namelen;

		struct __attribute__((packed)) {
			uint32_t length;
			uint32_t loopstart;
			uint32_t loopend;
			uint16_t freq;
			uint8_t vol;
			uint8_t type;
			uint8_t filler[10];
			uint32_t crc32;
		} smp;
		uint8_t bit16;

		int j;

		
		fread(&namelen, sizeof(uint8_t), 1, file);
		if (namelen>31)
		{
			fread(ip->name, 31, 1, file);
			fseek(file, namelen-31, SEEK_CUR);
			namelen=31;
		} else
			fread(ip->name, namelen, 1, file);
		ip->name[namelen]=0;

		fread(&smp, sizeof(smp)-((hdr.ver<8)?8:0), 1, file);
		smppack[i]=!!(smp.type&0x04);
		bit16=!!(smp.type&0x02);
		if (smp.type&0x88)
			return errFormSupp; /* can't do this */
		if (bit16&&smppack[i])
			return errFormSupp; /* don't want 16 bit packed samples.. */
		sip->length=smp.length>>bit16;
		sip->loopstart=smp.loopstart>>bit16;
		sip->loopend=smp.loopend>>bit16;
		sip->samprate=smp.freq;
		sip->type=((smp.type&4)?mcpSampDelta:0)|(bit16?mcpSamp16Bit:0)|((smp.type&1)?mcpSampLoop:0);

		if (!smp.length)
			continue;

		for (j=0; j<128; j++)
			ip->samples[j]=i;
		*sp->name=0;
		sp->handle=i;
		sp->normnote=0;
		sp->stdvol=smp.vol?smp.vol:-1;
		sp->stdpan=-1;
		sp->opt=bit16?MP_OFFSETDIV2:0;
	}

	fread(&sig, sizeof(uint32_t), 1, file);
	fread(&next, sizeof(uint32_t), 1, file);

	if ((sig!=*(uint32_t *)"SMPD"))
		return errFormStruc;

	for (i=0; i<m->instnum; i++)
	{
/*		struct gmdinstrument *ip=&m->instruments[i];     NOT USED */
		struct gmdsample *sp=&m->modsamples[i];
		struct sampleinfo *sip=&m->samples[i];

		uint32_t len;
    		uint8_t *smpp;
	
		fread(&len, sizeof(uint32_t), 1, file);

	    	if (sp->handle==0xFFFF)
		{
			fseek(file, len, SEEK_CUR);
			continue;
		}
		
		smpp=malloc(sizeof(unsigned char)*len+4/* worst case padding */);
		if (!smpp)
			return errAllocMem;
		fread(smpp, len, 1, file);
		if (smppack[i])
		{
			uint8_t *dbuf=malloc(sizeof(unsigned char)*(sip->length+16));
			if (!dbuf)
				return errAllocMem;
			unpack0(dbuf, smpp, sip->length);
			free(smpp);
			smpp=dbuf;
		}
		
		sip->ptr=smpp;
	}

	return errOk;
}
struct linkinfostruct dllextinfo = {"gmdldmf", "OpenCP Module Loader: *.DMF (c) 1994-04 Niklas Beisert", DLLVERSION, 0};
