/*  GNU Ocrad - Optical Character Recognition program
    Copyright (C) 2003, 2004, 2005 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <cstdio>
#include <string>
#include <vector>
#include "common.h"
#include "rectangle.h"
#include "vrhomboid.h"
#include "track.h"
#include "bitmap.h"
#include "block.h"
#include "blockmap.h"
#include "character.h"
#include "textline.h"
#include "textblock.h"
#include "textpage.h"


Textpage::Textpage( const Bitmap & page_image, const char * filename,
                    const Control & control ) throw()
  : Rectangle( 0, 0, page_image.width() - 1, page_image.height() - 1 ),
  name( filename ), bmp( 0 )
  {
  if( control.debug_level < 0 || control.debug_level > 100 ) return;

  bmp = new Blockmap( page_image, control.debug_level );

  if( control.debug_level >= 98 )
    {
    if( control.outfile )
      bmp->print( control.outfile, control.debug_level );
    return;
    }
  if( control.debug_level > 89 ) return;

  // build a Textblock for every zone with text on blockmap
  for( int i = 0; i < bmp->zones(); ++i )
    {
    Textblock * tbp = new Textblock( bmp->zone_vector()[i].rectangle,
                      control.charset, bmp->zone_vector()[i].block_matrix );
    if( tbp->lines() ) tbpv.push_back( tbp );
    else delete tbp;
    }
  if( control.debug_level == 0 || !control.outfile ) return;
  if( control.debug_level >= 86 )
    {
    bool graph = ( control.debug_level >= 88 );
    bool recursive = ( control.debug_level & 1 );
    for( int i = 0; i < textblocks(); ++i )
      tbpv[i]->dprint( control, graph, recursive );
    return;
    }
  if( control.debug_level > 77 ) return;
  if( control.debug_level >= 70 )
    {
    Bitmap bitmap( bmp->data_matrix() );
    if( ( control.debug_level - 70 ) & 1 )	// mark zones
      {
      for( int i = 0; i < bmp->zones(); ++i )
        bitmap.draw_rectangle( bmp->zone_vector()[i].rectangle );
      }
    if( ( control.debug_level - 70 ) & 2 )	// mark lines
      {
      for( int i = 0; i < textblocks(); ++i ) tbpv[i]->lmark( bitmap );
      }
    if( ( control.debug_level - 70 ) & 4 )	// mark characters
      {
      for( int i = 0; i < textblocks(); ++i ) tbpv[i]->cmark( bitmap );
      }
    bitmap.save( control.outfile, control.filetype );
    return;
    }
  }


Textpage::~Textpage() throw()
  {
  for( int i = textblocks() - 1; i >= 0; --i ) delete tbpv[i];
  if( bmp ) delete bmp;
  }

/*
const Textblock & Textpage::textblock( int i ) const throw()
  {
  if( i < 0 || i >= textblocks() )
    Ocrad::internal_error( "Textpage::textblock, index out of bounds" );
  return *(tbpv[i]);
  }
*/

void Textpage::print( const Control & control ) const throw()
  {
  if( control.outfile )
    for( int i = 0; i < textblocks(); ++i )
      tbpv[i]->print( control );
  }


void Textpage::xprint( const Control & control ) const throw()
  {
  if( !control.exportfile ) return;

  std::fprintf( control.exportfile, "source file %s\n", name.c_str() );
  std::fprintf( control.exportfile, "total text blocks %d\n", textblocks() );

  for( int i = 0; i < textblocks(); ++i )
    {
    const Textblock & tb = *(tbpv[i]);
    std::fprintf( control.exportfile, "text block %d %d %d %d %d\n", i + 1,
                  tb.left(), tb.top(), tb.width(), tb.height() );
    tb.xprint( control );
    }
  }
