#! /bin/sh

if [ $# = 0 ]; then
    echo usage: $0 "<directory>/version.cc"
    exit
fi

svn info > svn_info
if [ $? = 0 ]; then
    VERSION_STAMP=`grep Revision: svn_info`
else
    if [ -e $1 ]; then
        # don't overwrite existing version with "n/a"
        exit
    fi
    VERSION_STAMP="(revision n/a)"
fi

VERSION_STAMP="$VERSION_STAMP; `date`; `uname -a`"

echo // Generated by generate_version_cc.sh >$1
echo const char \*hardcoded_version_string\(\) \{return \"$VERSION_STAMP\"\;\} >>$1
