/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2; coding: utf-8 -*- 
 *
 * Copyright (C) 2007, 2008, 2009 John P. Swensen
 *
 * This file is as a part of OctaveDE.
 *
 * Octave is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Octave is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Octave; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * */
#include "VariablesTreeView.h"
#include <iostream>

VariablesTreeView::VariablesTreeView() 
{
  // Generate the table and create the column headers
  mVariables = new VariablesColumns();
  mVariablesTreeModel = Gtk::ListStore::create( *mVariables );
  this->set_model( mVariablesTreeModel );
  this->append_column("Name", mVariables->m_col_name);
  this->append_column("Size", mVariables->m_col_size);
  this->append_column("Bytes", mVariables->m_col_bytes);
  this->append_column("Class", mVariables->m_col_class);    
  mVariablesTreeModel->clear();
}

VariablesTreeView::~VariablesTreeView()
{
  mVariablesTreeModel->clear();
  delete mVariables;
}

void VariablesTreeView::clearRows() 
{ 
  gdk_threads_enter();
  mVariablesTreeModel->clear();
  gdk_threads_leave();
}

void VariablesTreeView::addRow( vector<string> tokens )
{
  Gtk::TreeModel::Row row = *(mVariablesTreeModel->append());
  row[mVariables->m_col_name] = tokens[0];
  row[mVariables->m_col_size] = tokens[1];
  row[mVariables->m_col_bytes] = tokens[2];
  row[mVariables->m_col_class] = tokens[3];   
}

void VariablesTreeView::addVariables( vector<variable_info_t>& variables )
{
  gdk_threads_enter();
  for ( size_t i = 0 ; i < variables.size() ; i++ )
  {
    ostringstream oss;
    Gtk::TreeModel::Row row = *(mVariablesTreeModel->append());
    row[mVariables->m_col_name] = variables[i].variable_name;
    for ( size_t j = 0 ; j < variables[i].size.size() ; j++ )
    {
      oss << variables[i].size[j];
      if ( j != variables[i].size.size()-1 )
        oss << "x";
    }
    row[mVariables->m_col_size] = oss.str();
    oss.str("");
    oss << variables[i].byte_size;
    row[mVariables->m_col_bytes] = oss.str();
    row[mVariables->m_col_class] = variables[i].type_name;
  }
  gdk_threads_leave();
}

void VariablesTreeView::on_row_activated (const TreeModel::Path& path, TreeViewColumn* column)
{
  // Get the name of the variable
  Gtk::TreeModel::iterator iter = mVariablesTreeModel->get_iter(path);
  Glib::ustring jid = iter->get_value(mVariables->m_col_name);

  // TODO: Request it from the octave_server
  std::cout << "Double click on variable " << jid << std::endl;
}


