/*

Copyright (C) 2009  John P. Swensen

This file is part of OctaveDE.

Octave is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

Octave is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with Octave; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>.

*/

#ifndef __MEDITOR_H__
#define __MEDITOR_H__

#include <iostream>
using namespace std;

#include <stdio.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <gtksourceview/gtksourceview.h>
#include <gtksourceview/gtksourcelanguage.h>
#include <gtksourceview/gtksourcelanguagemanager.h>
#include <gtksourceview/gtksourcestyleschememanager.h>


#include <gtkmm.h>

#include "dock.h"
#include "dock-item.h"
#include "server.h"

#include "OctaveDEToolbar.h"
#include "MEditorPanel.h"


#define READ_BUFFER_SIZE   4096




////////////////////////////////////////////////////////////////////////
class MEditor : public Gtk::Window
{
public:
  static MEditor* GetInstance (Dock& mainDock, bool show_it = true);
  static MEditor* GetInstance (bool show_it = false);
private:

  /**
   * A dock pane used for the editor windows
   */
  Dock dockPane;

  /**
   * A langage manager.  NOTE: I have no ideo what the language manager really does,
   * I just know it is needed for the GtkSourceView code.
   */
  GtkSourceLanguageManager *lm;
  
  /**
   * A map used to associate MEditorPanels with GTK::TextView's when events occur.
   */
  std::map <Gtk::TextView*, MEditorPanel*> m_editorPanels; 

  //Child widgets:
  Gtk::VBox m_Box;

  // Menu widgets
  Gtk::MenuBar menuBar;
  Gtk::Menu fileMenu;
  Gtk::Menu editMenu;
  Gtk::Menu debugMenu;
  Gtk::Menu windowMenu;
  Gtk::Menu helpMenu;

  // Index used for naming untitled new documents
  int idx;

  // Singleton instance
  static MEditor* __instance;

  // Private constructor and destructor
  MEditor (Dock& mainDock);
  ~MEditor ();



public:
  static void loadDebugPixmaps (Gtk::Widget* widget);


  GtkWidget* getDock() {return dockPane.getGdlWidget();}

  void openFile (std::string filename);

  int openFileDialog (void);

  void onNew (void);

  void onOpen (void);

  void onSave (void);

  void onSaveAs (void);

  static int saveAsFileDialog (Glib::ustring& filename);

  void onQuit (void);

  void onUndo (void);
  void onRedo (void);

  void onCut (void);
  void onCopy (void);
  void onPaste (void);

  void onPreferences (void);

  void remove_all_breakpoints ();
  void remove_hit_breakpoint_marker ();
  int process_breakpoint_list (std::vector<bp_info_t>& bps);
  int add_breakpoint_marker (bp_info_t bp, bp_marker_type_t type = BP_MARKER_TYPE_LOC);

};


#endif //__MEDITOR_H__
