/*
 *
 * Copyright (C) 2007, 2008, 2009 John P. Swensen
 *
 * This file is as a part of OctaveDE.
 *
 * Octave is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Octave is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Octave; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * */

#include <gtkmm.h>
#include "OctaveUI.h"
#include <signal.h>

#ifdef __APPLE__
#include <crt_externs.h>
#endif



#ifdef WIN32

#include <windows.h>
#include <fcntl.h>
#include <io.h>

#include "GdlDockPane.h"

#define main octaveui_main
int main( int argc, char *argv[] );

int WinMain( HINSTANCE hInst,
	     HINSTANCE hPrev,
	     LPSTR lpCmdLine,
	     int nCmdShow)
{
  int argc = 1;
  char *argv[] = { "octaveui.exe" };

  /* allocate a hidden console window */
  HWINSTA h, hOrig;
  hOrig = GetProcessWindowStation();
  h = CreateWindowStation(NULL, 0, GENERIC_ALL, NULL);
  SetProcessWindowStation(h);
  AllocConsole();
  SetProcessWindowStation(hOrig);
  CloseWindowStation(h);

  /* initialize standard IO */
  int fd_in = open("CONIN$", _O_RDONLY | _O_BINARY);
  int fd_out = open("CONOUT$", _O_WRONLY | _O_BINARY);
  int fd_err = open("CONOUT$", _O_WRONLY | _O_BINARY);

  if (fd_in != 0)
    {
      dup2(fd_in, 0);
      close(fd_in);
    }
  if (fd_out != 1)
    {
      dup2(fd_out, 1);
      close(fd_out);
    }
  if (fd_err != 2)
    {
      dup2(fd_err, 2);
      close(fd_err);
    }

  *stdin = *(fdopen(0, "rb"));
  *stdout = *(fdopen(1, "wb"));
  *stderr = *(fdopen(2, "wb"));

  return main(argc, argv);
}

#endif

OctaveUI* octaveUI;


/*
 * int_handler - SIGINT handler
 */
pid_t childPid = 0;

void int_handler(int sig)
{
  kill(childPid, SIGKILL);
}

int main( int argc, char*argv[] )
{
  //#if 0 // Used for debugging, with the downside that the pager doesn't work
#ifndef __WIN32__
  int     status;
  int i;
  bool do_fork = true;

  char **safe_argv = (char **) malloc( sizeof(char *) * argc);
  for(i = 0; i < argc; i++)
  {
    safe_argv[i] = strcpy((char*)malloc(strlen(argv[i])+1), argv[i]);
    if (strcmp(safe_argv[i], "--no-fork") == 0)
      do_fork = false;
    if (strcmp(safe_argv[i], "--help") == 0)
    {
      printf("Usage: octavede [options]\n");
      printf("    --no-fork         Do not fork\n");
      printf("    --help            This help\n");
      exit(0);
    }
  }

  if (do_fork) 
  {
    // we need to reexec ourselves because of stupid OSX crap crappity crap
#ifdef __APPLE__
    int argc = *_NSGetArgc();
    char ** argv = *_NSGetArgv();
#endif // __APPLE__
    char * newargv[argc+2];

    for (int i = 0; i < argc; i++) 
    {
      newargv[i] = argv[i];
    }
    newargv[argc] = "--no-fork";
    newargv[argc+1] = NULL;

    childPid = fork();
    switch(childPid) 
    {
      case -1:
	::_exit(255);
	break;
      case 0:
	// Child
	if (setsid () < 0) 
	{ 
	  return 1; 
	} 
	execvp(argv[0], newargv);
	break;
      default:
	// Parent
	
	// Install a CTRL-C handler to kill the child process and exit
	::signal(SIGINT, int_handler);

	pid_t pid = wait(&status);
	_exit(0);
	break;
    }
  }
  else
#endif
  {
    g_thread_init (NULL);
    gdk_threads_init ();
    gdk_threads_enter ();

    gtk_disable_setlocale ();

    Gtk::Main kit(argc, argv);

    octaveUI = new OctaveUI();
    Gtk::Main::run(*octaveUI);
    gdk_threads_leave ();
  }
  return 0;
}
